# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetDataRepositoryAssociationResult',
    'AwaitableGetDataRepositoryAssociationResult',
    'get_data_repository_association',
    'get_data_repository_association_output',
]

@pulumi.output_type
class GetDataRepositoryAssociationResult:
    def __init__(__self__, association_id=None, imported_file_chunk_size=None, resource_arn=None, s3=None, tags=None):
        if association_id and not isinstance(association_id, str):
            raise TypeError("Expected argument 'association_id' to be a str")
        pulumi.set(__self__, "association_id", association_id)
        if imported_file_chunk_size and not isinstance(imported_file_chunk_size, int):
            raise TypeError("Expected argument 'imported_file_chunk_size' to be a int")
        pulumi.set(__self__, "imported_file_chunk_size", imported_file_chunk_size)
        if resource_arn and not isinstance(resource_arn, str):
            raise TypeError("Expected argument 'resource_arn' to be a str")
        pulumi.set(__self__, "resource_arn", resource_arn)
        if s3 and not isinstance(s3, dict):
            raise TypeError("Expected argument 's3' to be a dict")
        pulumi.set(__self__, "s3", s3)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="associationId")
    def association_id(self) -> Optional[builtins.str]:
        """
        Returns the data repository association's system generated Association ID.

        Example: `dra-abcdef0123456789d`
        """
        return pulumi.get(self, "association_id")

    @property
    @pulumi.getter(name="importedFileChunkSize")
    def imported_file_chunk_size(self) -> Optional[builtins.int]:
        """
        For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system or cache.
         The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000 MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
        """
        return pulumi.get(self, "imported_file_chunk_size")

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> Optional[builtins.str]:
        """
        Returns the data repository association's Amazon Resource Name (ARN).

        Example: `arn:aws:fsx:us-east-1:111122223333:association/fs-abc012345def6789a/dra-abcdef0123456789b`
        """
        return pulumi.get(self, "resource_arn")

    @property
    @pulumi.getter
    def s3(self) -> Optional['outputs.DataRepositoryAssociationS3']:
        """
        The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.
        """
        return pulumi.get(self, "s3")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
         For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html).
        """
        return pulumi.get(self, "tags")


class AwaitableGetDataRepositoryAssociationResult(GetDataRepositoryAssociationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataRepositoryAssociationResult(
            association_id=self.association_id,
            imported_file_chunk_size=self.imported_file_chunk_size,
            resource_arn=self.resource_arn,
            s3=self.s3,
            tags=self.tags)


def get_data_repository_association(association_id: Optional[builtins.str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataRepositoryAssociationResult:
    """
    Creates an Amazon FSx for Lustre data repository association (DRA). A data repository association is a link between a directory on the file system and an Amazon S3 bucket or prefix. You can have a maximum of 8 data repository associations on a file system. Data repository associations are supported on all FSx for Lustre 2.12 and newer file systems, excluding ``scratch_1`` deployment type.
     Each data repository association must have a unique Amazon FSx file system directory and a unique S3 bucket or prefix associated with it. You can configure a data repository association for automatic import only, for automatic export only, or for both. To learn more about linking a data repository to your file system, see [Linking your file system to an S3 bucket](https://docs.aws.amazon.com/fsx/latest/LustreGuide/create-dra-linked-data-repo.html).


    :param builtins.str association_id: Returns the data repository association's system generated Association ID.
           
           Example: `dra-abcdef0123456789d`
    """
    __args__ = dict()
    __args__['associationId'] = association_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:fsx:getDataRepositoryAssociation', __args__, opts=opts, typ=GetDataRepositoryAssociationResult).value

    return AwaitableGetDataRepositoryAssociationResult(
        association_id=pulumi.get(__ret__, 'association_id'),
        imported_file_chunk_size=pulumi.get(__ret__, 'imported_file_chunk_size'),
        resource_arn=pulumi.get(__ret__, 'resource_arn'),
        s3=pulumi.get(__ret__, 's3'),
        tags=pulumi.get(__ret__, 'tags'))
def get_data_repository_association_output(association_id: Optional[pulumi.Input[builtins.str]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDataRepositoryAssociationResult]:
    """
    Creates an Amazon FSx for Lustre data repository association (DRA). A data repository association is a link between a directory on the file system and an Amazon S3 bucket or prefix. You can have a maximum of 8 data repository associations on a file system. Data repository associations are supported on all FSx for Lustre 2.12 and newer file systems, excluding ``scratch_1`` deployment type.
     Each data repository association must have a unique Amazon FSx file system directory and a unique S3 bucket or prefix associated with it. You can configure a data repository association for automatic import only, for automatic export only, or for both. To learn more about linking a data repository to your file system, see [Linking your file system to an S3 bucket](https://docs.aws.amazon.com/fsx/latest/LustreGuide/create-dra-linked-data-repo.html).


    :param builtins.str association_id: Returns the data repository association's system generated Association ID.
           
           Example: `dra-abcdef0123456789d`
    """
    __args__ = dict()
    __args__['associationId'] = association_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:fsx:getDataRepositoryAssociation', __args__, opts=opts, typ=GetDataRepositoryAssociationResult)
    return __ret__.apply(lambda __response__: GetDataRepositoryAssociationResult(
        association_id=pulumi.get(__response__, 'association_id'),
        imported_file_chunk_size=pulumi.get(__response__, 'imported_file_chunk_size'),
        resource_arn=pulumi.get(__response__, 'resource_arn'),
        s3=pulumi.get(__response__, 's3'),
        tags=pulumi.get(__response__, 'tags')))
