# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'DatasetAttributesItemProperties',
    'EncryptionConfigProperties',
    'SchemaProperties',
]

@pulumi.output_type
class DatasetAttributesItemProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributeName":
            suggest = "attribute_name"
        elif key == "attributeType":
            suggest = "attribute_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatasetAttributesItemProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatasetAttributesItemProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatasetAttributesItemProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute_name: Optional[builtins.str] = None,
                 attribute_type: Optional['DatasetAttributesItemPropertiesAttributeType'] = None):
        """
        :param builtins.str attribute_name: Name of the dataset field
        :param 'DatasetAttributesItemPropertiesAttributeType' attribute_type: Data type of the field
        """
        if attribute_name is not None:
            pulumi.set(__self__, "attribute_name", attribute_name)
        if attribute_type is not None:
            pulumi.set(__self__, "attribute_type", attribute_type)

    @property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> Optional[builtins.str]:
        """
        Name of the dataset field
        """
        return pulumi.get(self, "attribute_name")

    @property
    @pulumi.getter(name="attributeType")
    def attribute_type(self) -> Optional['DatasetAttributesItemPropertiesAttributeType']:
        """
        Data type of the field
        """
        return pulumi.get(self, "attribute_type")


@pulumi.output_type
class EncryptionConfigProperties(dict):
    """
    A Key Management Service (KMS) key and the Identity and Access Management (IAM) role that Amazon Forecast can assume to access the key.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyArn":
            suggest = "kms_key_arn"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionConfigProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionConfigProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionConfigProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_arn: Optional[builtins.str] = None,
                 role_arn: Optional[builtins.str] = None):
        """
        A Key Management Service (KMS) key and the Identity and Access Management (IAM) role that Amazon Forecast can assume to access the key.
        :param builtins.str kms_key_arn: The Amazon Resource Name (ARN) of the KMS key.
        :param builtins.str role_arn: The ARN of the IAM role that Amazon Forecast can assume to access the AWS KMS key.
               
               Passing a role across AWS accounts is not allowed. If you pass a role that isn't in your account, you get an `InvalidInputException` error.
        """
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the KMS key.
        """
        return pulumi.get(self, "kms_key_arn")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the IAM role that Amazon Forecast can assume to access the AWS KMS key.

        Passing a role across AWS accounts is not allowed. If you pass a role that isn't in your account, you get an `InvalidInputException` error.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class SchemaProperties(dict):
    """
    The schema for the dataset. The schema attributes and their order must match the fields in your data. The dataset `Domain` and `DatasetType` that you choose determine the minimum required fields in your training data. For information about the required fields for a specific dataset domain and type, see [Dataset Domains and Dataset Types](https://docs.aws.amazon.com/forecast/latest/dg/howitworks-domains-ds-types.html) .
    """
    def __init__(__self__, *,
                 attributes: Optional[Sequence['outputs.DatasetAttributesItemProperties']] = None):
        """
        The schema for the dataset. The schema attributes and their order must match the fields in your data. The dataset `Domain` and `DatasetType` that you choose determine the minimum required fields in your training data. For information about the required fields for a specific dataset domain and type, see [Dataset Domains and Dataset Types](https://docs.aws.amazon.com/forecast/latest/dg/howitworks-domains-ds-types.html) .
        :param Sequence['DatasetAttributesItemProperties'] attributes: An array of attributes specifying the name and type of each field in a dataset.
        """
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[Sequence['outputs.DatasetAttributesItemProperties']]:
        """
        An array of attributes specifying the name and type of each field in a dataset.
        """
        return pulumi.get(self, "attributes")


