# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['DatasetArgs', 'Dataset']

@pulumi.input_type
class DatasetArgs:
    def __init__(__self__, *,
                 dataset_type: pulumi.Input['DatasetType'],
                 domain: pulumi.Input['DatasetDomain'],
                 schema: pulumi.Input['SchemaPropertiesArgs'],
                 data_frequency: Optional[pulumi.Input[builtins.str]] = None,
                 dataset_name: Optional[pulumi.Input[builtins.str]] = None,
                 encryption_config: Optional[pulumi.Input['EncryptionConfigPropertiesArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Dataset resource.
        :param pulumi.Input['DatasetType'] dataset_type: The dataset type
        :param pulumi.Input['DatasetDomain'] domain: The domain associated with the dataset
        :param pulumi.Input['SchemaPropertiesArgs'] schema: The schema for the dataset. The schema attributes and their order must match the fields in your data. The dataset `Domain` and `DatasetType` that you choose determine the minimum required fields in your training data. For information about the required fields for a specific dataset domain and type, see [Dataset Domains and Dataset Types](https://docs.aws.amazon.com/forecast/latest/dg/howitworks-domains-ds-types.html) .
        :param pulumi.Input[builtins.str] data_frequency: Frequency of data collection. This parameter is required for RELATED_TIME_SERIES
        :param pulumi.Input[builtins.str] dataset_name: A name for the dataset
        :param pulumi.Input['EncryptionConfigPropertiesArgs'] encryption_config: A Key Management Service (KMS) key and the Identity and Access Management (IAM) role that Amazon Forecast can assume to access the key.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
               
               For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
        """
        pulumi.set(__self__, "dataset_type", dataset_type)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "schema", schema)
        if data_frequency is not None:
            pulumi.set(__self__, "data_frequency", data_frequency)
        if dataset_name is not None:
            pulumi.set(__self__, "dataset_name", dataset_name)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> pulumi.Input['DatasetType']:
        """
        The dataset type
        """
        return pulumi.get(self, "dataset_type")

    @dataset_type.setter
    def dataset_type(self, value: pulumi.Input['DatasetType']):
        pulumi.set(self, "dataset_type", value)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Input['DatasetDomain']:
        """
        The domain associated with the dataset
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input['DatasetDomain']):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Input['SchemaPropertiesArgs']:
        """
        The schema for the dataset. The schema attributes and their order must match the fields in your data. The dataset `Domain` and `DatasetType` that you choose determine the minimum required fields in your training data. For information about the required fields for a specific dataset domain and type, see [Dataset Domains and Dataset Types](https://docs.aws.amazon.com/forecast/latest/dg/howitworks-domains-ds-types.html) .
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: pulumi.Input['SchemaPropertiesArgs']):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter(name="dataFrequency")
    def data_frequency(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Frequency of data collection. This parameter is required for RELATED_TIME_SERIES
        """
        return pulumi.get(self, "data_frequency")

    @data_frequency.setter
    def data_frequency(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_frequency", value)

    @property
    @pulumi.getter(name="datasetName")
    def dataset_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A name for the dataset
        """
        return pulumi.get(self, "dataset_name")

    @dataset_name.setter
    def dataset_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dataset_name", value)

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional[pulumi.Input['EncryptionConfigPropertiesArgs']]:
        """
        A Key Management Service (KMS) key and the Identity and Access Management (IAM) role that Amazon Forecast can assume to access the key.
        """
        return pulumi.get(self, "encryption_config")

    @encryption_config.setter
    def encryption_config(self, value: Optional[pulumi.Input['EncryptionConfigPropertiesArgs']]):
        pulumi.set(self, "encryption_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.

        For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:forecast:Dataset")
class Dataset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_frequency: Optional[pulumi.Input[builtins.str]] = None,
                 dataset_name: Optional[pulumi.Input[builtins.str]] = None,
                 dataset_type: Optional[pulumi.Input['DatasetType']] = None,
                 domain: Optional[pulumi.Input['DatasetDomain']] = None,
                 encryption_config: Optional[pulumi.Input[Union['EncryptionConfigPropertiesArgs', 'EncryptionConfigPropertiesArgsDict']]] = None,
                 schema: Optional[pulumi.Input[Union['SchemaPropertiesArgs', 'SchemaPropertiesArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type Definition for AWS::Forecast::Dataset

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] data_frequency: Frequency of data collection. This parameter is required for RELATED_TIME_SERIES
        :param pulumi.Input[builtins.str] dataset_name: A name for the dataset
        :param pulumi.Input['DatasetType'] dataset_type: The dataset type
        :param pulumi.Input['DatasetDomain'] domain: The domain associated with the dataset
        :param pulumi.Input[Union['EncryptionConfigPropertiesArgs', 'EncryptionConfigPropertiesArgsDict']] encryption_config: A Key Management Service (KMS) key and the Identity and Access Management (IAM) role that Amazon Forecast can assume to access the key.
        :param pulumi.Input[Union['SchemaPropertiesArgs', 'SchemaPropertiesArgsDict']] schema: The schema for the dataset. The schema attributes and their order must match the fields in your data. The dataset `Domain` and `DatasetType` that you choose determine the minimum required fields in your training data. For information about the required fields for a specific dataset domain and type, see [Dataset Domains and Dataset Types](https://docs.aws.amazon.com/forecast/latest/dg/howitworks-domains-ds-types.html) .
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
               
               For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatasetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type Definition for AWS::Forecast::Dataset

        :param str resource_name: The name of the resource.
        :param DatasetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatasetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_frequency: Optional[pulumi.Input[builtins.str]] = None,
                 dataset_name: Optional[pulumi.Input[builtins.str]] = None,
                 dataset_type: Optional[pulumi.Input['DatasetType']] = None,
                 domain: Optional[pulumi.Input['DatasetDomain']] = None,
                 encryption_config: Optional[pulumi.Input[Union['EncryptionConfigPropertiesArgs', 'EncryptionConfigPropertiesArgsDict']]] = None,
                 schema: Optional[pulumi.Input[Union['SchemaPropertiesArgs', 'SchemaPropertiesArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatasetArgs.__new__(DatasetArgs)

            __props__.__dict__["data_frequency"] = data_frequency
            __props__.__dict__["dataset_name"] = dataset_name
            if dataset_type is None and not opts.urn:
                raise TypeError("Missing required property 'dataset_type'")
            __props__.__dict__["dataset_type"] = dataset_type
            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            __props__.__dict__["encryption_config"] = encryption_config
            if schema is None and not opts.urn:
                raise TypeError("Missing required property 'schema'")
            __props__.__dict__["schema"] = schema
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["datasetName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Dataset, __self__).__init__(
            'aws-native:forecast:Dataset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Dataset':
        """
        Get an existing Dataset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DatasetArgs.__new__(DatasetArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["data_frequency"] = None
        __props__.__dict__["dataset_name"] = None
        __props__.__dict__["dataset_type"] = None
        __props__.__dict__["domain"] = None
        __props__.__dict__["encryption_config"] = None
        __props__.__dict__["schema"] = None
        __props__.__dict__["tags"] = None
        return Dataset(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the dataset.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="dataFrequency")
    def data_frequency(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Frequency of data collection. This parameter is required for RELATED_TIME_SERIES
        """
        return pulumi.get(self, "data_frequency")

    @property
    @pulumi.getter(name="datasetName")
    def dataset_name(self) -> pulumi.Output[builtins.str]:
        """
        A name for the dataset
        """
        return pulumi.get(self, "dataset_name")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> pulumi.Output['DatasetType']:
        """
        The dataset type
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output['DatasetDomain']:
        """
        The domain associated with the dataset
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> pulumi.Output[Optional['outputs.EncryptionConfigProperties']]:
        """
        A Key Management Service (KMS) key and the Identity and Access Management (IAM) role that Amazon Forecast can assume to access the key.
        """
        return pulumi.get(self, "encryption_config")

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Output['outputs.SchemaProperties']:
        """
        The schema for the dataset. The schema attributes and their order must match the fields in your data. The dataset `Domain` and `DatasetType` that you choose determine the minimum required fields in your training data. For information about the required fields for a specific dataset domain and type, see [Dataset Domains and Dataset Types](https://docs.aws.amazon.com/forecast/latest/dg/howitworks-domains-ds-types.html) .
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.

        For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
        """
        return pulumi.get(self, "tags")

