# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetExperimentTemplateResult',
    'AwaitableGetExperimentTemplateResult',
    'get_experiment_template',
    'get_experiment_template_output',
]

@pulumi.output_type
class GetExperimentTemplateResult:
    def __init__(__self__, actions=None, description=None, experiment_options=None, experiment_report_configuration=None, id=None, log_configuration=None, role_arn=None, stop_conditions=None, targets=None):
        if actions and not isinstance(actions, dict):
            raise TypeError("Expected argument 'actions' to be a dict")
        pulumi.set(__self__, "actions", actions)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if experiment_options and not isinstance(experiment_options, dict):
            raise TypeError("Expected argument 'experiment_options' to be a dict")
        pulumi.set(__self__, "experiment_options", experiment_options)
        if experiment_report_configuration and not isinstance(experiment_report_configuration, dict):
            raise TypeError("Expected argument 'experiment_report_configuration' to be a dict")
        pulumi.set(__self__, "experiment_report_configuration", experiment_report_configuration)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if log_configuration and not isinstance(log_configuration, dict):
            raise TypeError("Expected argument 'log_configuration' to be a dict")
        pulumi.set(__self__, "log_configuration", log_configuration)
        if role_arn and not isinstance(role_arn, str):
            raise TypeError("Expected argument 'role_arn' to be a str")
        pulumi.set(__self__, "role_arn", role_arn)
        if stop_conditions and not isinstance(stop_conditions, list):
            raise TypeError("Expected argument 'stop_conditions' to be a list")
        pulumi.set(__self__, "stop_conditions", stop_conditions)
        if targets and not isinstance(targets, dict):
            raise TypeError("Expected argument 'targets' to be a dict")
        pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter
    def actions(self) -> Optional[Mapping[str, 'outputs.ExperimentTemplateAction']]:
        """
        The actions for the experiment.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description for the experiment template.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="experimentOptions")
    def experiment_options(self) -> Optional['outputs.ExperimentTemplateExperimentOptions']:
        """
        The experiment options for an experiment template.
        """
        return pulumi.get(self, "experiment_options")

    @property
    @pulumi.getter(name="experimentReportConfiguration")
    def experiment_report_configuration(self) -> Optional['outputs.ExperimentTemplateExperimentReportConfiguration']:
        """
        Describes the report configuration for the experiment template.
        """
        return pulumi.get(self, "experiment_report_configuration")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the experiment template.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="logConfiguration")
    def log_configuration(self) -> Optional['outputs.ExperimentTemplateLogConfiguration']:
        """
        The configuration for experiment logging.
        """
        return pulumi.get(self, "log_configuration")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of an IAM role.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="stopConditions")
    def stop_conditions(self) -> Optional[Sequence['outputs.ExperimentTemplateStopCondition']]:
        """
        The stop conditions for the experiment.
        """
        return pulumi.get(self, "stop_conditions")

    @property
    @pulumi.getter
    def targets(self) -> Optional[Mapping[str, 'outputs.ExperimentTemplateTarget']]:
        """
        The targets for the experiment.
        """
        return pulumi.get(self, "targets")


class AwaitableGetExperimentTemplateResult(GetExperimentTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExperimentTemplateResult(
            actions=self.actions,
            description=self.description,
            experiment_options=self.experiment_options,
            experiment_report_configuration=self.experiment_report_configuration,
            id=self.id,
            log_configuration=self.log_configuration,
            role_arn=self.role_arn,
            stop_conditions=self.stop_conditions,
            targets=self.targets)


def get_experiment_template(id: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExperimentTemplateResult:
    """
    Resource schema for AWS::FIS::ExperimentTemplate


    :param builtins.str id: The ID of the experiment template.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:fis:getExperimentTemplate', __args__, opts=opts, typ=GetExperimentTemplateResult).value

    return AwaitableGetExperimentTemplateResult(
        actions=pulumi.get(__ret__, 'actions'),
        description=pulumi.get(__ret__, 'description'),
        experiment_options=pulumi.get(__ret__, 'experiment_options'),
        experiment_report_configuration=pulumi.get(__ret__, 'experiment_report_configuration'),
        id=pulumi.get(__ret__, 'id'),
        log_configuration=pulumi.get(__ret__, 'log_configuration'),
        role_arn=pulumi.get(__ret__, 'role_arn'),
        stop_conditions=pulumi.get(__ret__, 'stop_conditions'),
        targets=pulumi.get(__ret__, 'targets'))
def get_experiment_template_output(id: Optional[pulumi.Input[builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExperimentTemplateResult]:
    """
    Resource schema for AWS::FIS::ExperimentTemplate


    :param builtins.str id: The ID of the experiment template.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:fis:getExperimentTemplate', __args__, opts=opts, typ=GetExperimentTemplateResult)
    return __ret__.apply(lambda __response__: GetExperimentTemplateResult(
        actions=pulumi.get(__response__, 'actions'),
        description=pulumi.get(__response__, 'description'),
        experiment_options=pulumi.get(__response__, 'experiment_options'),
        experiment_report_configuration=pulumi.get(__response__, 'experiment_report_configuration'),
        id=pulumi.get(__response__, 'id'),
        log_configuration=pulumi.get(__response__, 'log_configuration'),
        role_arn=pulumi.get(__response__, 'role_arn'),
        stop_conditions=pulumi.get(__response__, 'stop_conditions'),
        targets=pulumi.get(__response__, 'targets')))
