# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['EnvironmentArgs', 'Environment']

@pulumi.input_type
class EnvironmentArgs:
    def __init__(__self__, *,
                 connectivity_info: pulumi.Input['ConnectivityInfoPropertiesArgs'],
                 license_info: pulumi.Input['LicenseInfoPropertiesArgs'],
                 service_access_subnet_id: pulumi.Input[builtins.str],
                 site_id: pulumi.Input[builtins.str],
                 terms_accepted: pulumi.Input[builtins.bool],
                 vcf_hostnames: pulumi.Input['VcfHostnamesPropertiesArgs'],
                 vcf_version: pulumi.Input['EnvironmentVcfVersion'],
                 vpc_id: pulumi.Input[builtins.str],
                 environment_name: Optional[pulumi.Input[builtins.str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentHostInfoForCreateArgs']]]] = None,
                 initial_vlans: Optional[pulumi.Input['InitialVlansPropertiesArgs']] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 service_access_security_groups: Optional[pulumi.Input['ServiceAccessSecurityGroupsPropertiesArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Environment resource.
        :param pulumi.Input['LicenseInfoPropertiesArgs'] license_info: The license information for an EVS environment
        :param pulumi.Input[builtins.str] environment_name: The name of an EVS environment
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentHostInfoForCreateArgs']]] hosts: The initial hosts for environment only required upon creation. Modification after creation will have no effect
        :param pulumi.Input['InitialVlansPropertiesArgs'] initial_vlans: The initial Vlan configuration only required upon creation. Modification after creation will have no effect
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        pulumi.set(__self__, "connectivity_info", connectivity_info)
        pulumi.set(__self__, "license_info", license_info)
        pulumi.set(__self__, "service_access_subnet_id", service_access_subnet_id)
        pulumi.set(__self__, "site_id", site_id)
        pulumi.set(__self__, "terms_accepted", terms_accepted)
        pulumi.set(__self__, "vcf_hostnames", vcf_hostnames)
        pulumi.set(__self__, "vcf_version", vcf_version)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if environment_name is not None:
            pulumi.set(__self__, "environment_name", environment_name)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if initial_vlans is not None:
            pulumi.set(__self__, "initial_vlans", initial_vlans)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if service_access_security_groups is not None:
            pulumi.set(__self__, "service_access_security_groups", service_access_security_groups)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="connectivityInfo")
    def connectivity_info(self) -> pulumi.Input['ConnectivityInfoPropertiesArgs']:
        return pulumi.get(self, "connectivity_info")

    @connectivity_info.setter
    def connectivity_info(self, value: pulumi.Input['ConnectivityInfoPropertiesArgs']):
        pulumi.set(self, "connectivity_info", value)

    @property
    @pulumi.getter(name="licenseInfo")
    def license_info(self) -> pulumi.Input['LicenseInfoPropertiesArgs']:
        """
        The license information for an EVS environment
        """
        return pulumi.get(self, "license_info")

    @license_info.setter
    def license_info(self, value: pulumi.Input['LicenseInfoPropertiesArgs']):
        pulumi.set(self, "license_info", value)

    @property
    @pulumi.getter(name="serviceAccessSubnetId")
    def service_access_subnet_id(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "service_access_subnet_id")

    @service_access_subnet_id.setter
    def service_access_subnet_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_access_subnet_id", value)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter(name="termsAccepted")
    def terms_accepted(self) -> pulumi.Input[builtins.bool]:
        return pulumi.get(self, "terms_accepted")

    @terms_accepted.setter
    def terms_accepted(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "terms_accepted", value)

    @property
    @pulumi.getter(name="vcfHostnames")
    def vcf_hostnames(self) -> pulumi.Input['VcfHostnamesPropertiesArgs']:
        return pulumi.get(self, "vcf_hostnames")

    @vcf_hostnames.setter
    def vcf_hostnames(self, value: pulumi.Input['VcfHostnamesPropertiesArgs']):
        pulumi.set(self, "vcf_hostnames", value)

    @property
    @pulumi.getter(name="vcfVersion")
    def vcf_version(self) -> pulumi.Input['EnvironmentVcfVersion']:
        return pulumi.get(self, "vcf_version")

    @vcf_version.setter
    def vcf_version(self, value: pulumi.Input['EnvironmentVcfVersion']):
        pulumi.set(self, "vcf_version", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="environmentName")
    def environment_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of an EVS environment
        """
        return pulumi.get(self, "environment_name")

    @environment_name.setter
    def environment_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "environment_name", value)

    @property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentHostInfoForCreateArgs']]]]:
        """
        The initial hosts for environment only required upon creation. Modification after creation will have no effect
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentHostInfoForCreateArgs']]]]):
        pulumi.set(self, "hosts", value)

    @property
    @pulumi.getter(name="initialVlans")
    def initial_vlans(self) -> Optional[pulumi.Input['InitialVlansPropertiesArgs']]:
        """
        The initial Vlan configuration only required upon creation. Modification after creation will have no effect
        """
        return pulumi.get(self, "initial_vlans")

    @initial_vlans.setter
    def initial_vlans(self, value: Optional[pulumi.Input['InitialVlansPropertiesArgs']]):
        pulumi.set(self, "initial_vlans", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="serviceAccessSecurityGroups")
    def service_access_security_groups(self) -> Optional[pulumi.Input['ServiceAccessSecurityGroupsPropertiesArgs']]:
        return pulumi.get(self, "service_access_security_groups")

    @service_access_security_groups.setter
    def service_access_security_groups(self, value: Optional[pulumi.Input['ServiceAccessSecurityGroupsPropertiesArgs']]):
        pulumi.set(self, "service_access_security_groups", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:evs:Environment")
class Environment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connectivity_info: Optional[pulumi.Input[Union['ConnectivityInfoPropertiesArgs', 'ConnectivityInfoPropertiesArgsDict']]] = None,
                 environment_name: Optional[pulumi.Input[builtins.str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentHostInfoForCreateArgs', 'EnvironmentHostInfoForCreateArgsDict']]]]] = None,
                 initial_vlans: Optional[pulumi.Input[Union['InitialVlansPropertiesArgs', 'InitialVlansPropertiesArgsDict']]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 license_info: Optional[pulumi.Input[Union['LicenseInfoPropertiesArgs', 'LicenseInfoPropertiesArgsDict']]] = None,
                 service_access_security_groups: Optional[pulumi.Input[Union['ServiceAccessSecurityGroupsPropertiesArgs', 'ServiceAccessSecurityGroupsPropertiesArgsDict']]] = None,
                 service_access_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 site_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 terms_accepted: Optional[pulumi.Input[builtins.bool]] = None,
                 vcf_hostnames: Optional[pulumi.Input[Union['VcfHostnamesPropertiesArgs', 'VcfHostnamesPropertiesArgsDict']]] = None,
                 vcf_version: Optional[pulumi.Input['EnvironmentVcfVersion']] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        An environment created within the EVS service

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] environment_name: The name of an EVS environment
        :param pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentHostInfoForCreateArgs', 'EnvironmentHostInfoForCreateArgsDict']]]] hosts: The initial hosts for environment only required upon creation. Modification after creation will have no effect
        :param pulumi.Input[Union['InitialVlansPropertiesArgs', 'InitialVlansPropertiesArgsDict']] initial_vlans: The initial Vlan configuration only required upon creation. Modification after creation will have no effect
        :param pulumi.Input[Union['LicenseInfoPropertiesArgs', 'LicenseInfoPropertiesArgsDict']] license_info: The license information for an EVS environment
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvironmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An environment created within the EVS service

        :param str resource_name: The name of the resource.
        :param EnvironmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connectivity_info: Optional[pulumi.Input[Union['ConnectivityInfoPropertiesArgs', 'ConnectivityInfoPropertiesArgsDict']]] = None,
                 environment_name: Optional[pulumi.Input[builtins.str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentHostInfoForCreateArgs', 'EnvironmentHostInfoForCreateArgsDict']]]]] = None,
                 initial_vlans: Optional[pulumi.Input[Union['InitialVlansPropertiesArgs', 'InitialVlansPropertiesArgsDict']]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 license_info: Optional[pulumi.Input[Union['LicenseInfoPropertiesArgs', 'LicenseInfoPropertiesArgsDict']]] = None,
                 service_access_security_groups: Optional[pulumi.Input[Union['ServiceAccessSecurityGroupsPropertiesArgs', 'ServiceAccessSecurityGroupsPropertiesArgsDict']]] = None,
                 service_access_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 site_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 terms_accepted: Optional[pulumi.Input[builtins.bool]] = None,
                 vcf_hostnames: Optional[pulumi.Input[Union['VcfHostnamesPropertiesArgs', 'VcfHostnamesPropertiesArgsDict']]] = None,
                 vcf_version: Optional[pulumi.Input['EnvironmentVcfVersion']] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentArgs.__new__(EnvironmentArgs)

            if connectivity_info is None and not opts.urn:
                raise TypeError("Missing required property 'connectivity_info'")
            __props__.__dict__["connectivity_info"] = connectivity_info
            __props__.__dict__["environment_name"] = environment_name
            __props__.__dict__["hosts"] = hosts
            __props__.__dict__["initial_vlans"] = initial_vlans
            __props__.__dict__["kms_key_id"] = kms_key_id
            if license_info is None and not opts.urn:
                raise TypeError("Missing required property 'license_info'")
            __props__.__dict__["license_info"] = license_info
            __props__.__dict__["service_access_security_groups"] = service_access_security_groups
            if service_access_subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_access_subnet_id'")
            __props__.__dict__["service_access_subnet_id"] = service_access_subnet_id
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["tags"] = tags
            if terms_accepted is None and not opts.urn:
                raise TypeError("Missing required property 'terms_accepted'")
            __props__.__dict__["terms_accepted"] = terms_accepted
            if vcf_hostnames is None and not opts.urn:
                raise TypeError("Missing required property 'vcf_hostnames'")
            __props__.__dict__["vcf_hostnames"] = vcf_hostnames
            if vcf_version is None and not opts.urn:
                raise TypeError("Missing required property 'vcf_version'")
            __props__.__dict__["vcf_version"] = vcf_version
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["checks"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["credentials"] = None
            __props__.__dict__["environment_arn"] = None
            __props__.__dict__["environment_id"] = None
            __props__.__dict__["environment_state"] = None
            __props__.__dict__["modified_at"] = None
            __props__.__dict__["state_details"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["connectivityInfo", "environmentName", "kmsKeyId", "licenseInfo", "serviceAccessSecurityGroups", "serviceAccessSubnetId", "siteId", "termsAccepted", "vcfHostnames", "vcfVersion", "vpcId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Environment, __self__).__init__(
            'aws-native:evs:Environment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Environment':
        """
        Get an existing Environment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = EnvironmentArgs.__new__(EnvironmentArgs)

        __props__.__dict__["checks"] = None
        __props__.__dict__["connectivity_info"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["credentials"] = None
        __props__.__dict__["environment_arn"] = None
        __props__.__dict__["environment_id"] = None
        __props__.__dict__["environment_name"] = None
        __props__.__dict__["environment_state"] = None
        __props__.__dict__["hosts"] = None
        __props__.__dict__["initial_vlans"] = None
        __props__.__dict__["kms_key_id"] = None
        __props__.__dict__["license_info"] = None
        __props__.__dict__["modified_at"] = None
        __props__.__dict__["service_access_security_groups"] = None
        __props__.__dict__["service_access_subnet_id"] = None
        __props__.__dict__["site_id"] = None
        __props__.__dict__["state_details"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["terms_accepted"] = None
        __props__.__dict__["vcf_hostnames"] = None
        __props__.__dict__["vcf_version"] = None
        __props__.__dict__["vpc_id"] = None
        return Environment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def checks(self) -> pulumi.Output[Sequence['outputs.EnvironmentCheck']]:
        return pulumi.get(self, "checks")

    @property
    @pulumi.getter(name="connectivityInfo")
    def connectivity_info(self) -> pulumi.Output['outputs.ConnectivityInfoProperties']:
        return pulumi.get(self, "connectivity_info")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def credentials(self) -> pulumi.Output[Sequence['outputs.EnvironmentSecret']]:
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="environmentArn")
    def environment_arn(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "environment_arn")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="environmentName")
    def environment_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of an EVS environment
        """
        return pulumi.get(self, "environment_name")

    @property
    @pulumi.getter(name="environmentState")
    def environment_state(self) -> pulumi.Output['EnvironmentState']:
        return pulumi.get(self, "environment_state")

    @property
    @pulumi.getter
    def hosts(self) -> pulumi.Output[Optional[Sequence['outputs.EnvironmentHostInfoForCreate']]]:
        """
        The initial hosts for environment only required upon creation. Modification after creation will have no effect
        """
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter(name="initialVlans")
    def initial_vlans(self) -> pulumi.Output[Optional['outputs.InitialVlansProperties']]:
        """
        The initial Vlan configuration only required upon creation. Modification after creation will have no effect
        """
        return pulumi.get(self, "initial_vlans")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="licenseInfo")
    def license_info(self) -> pulumi.Output['outputs.LicenseInfoProperties']:
        """
        The license information for an EVS environment
        """
        return pulumi.get(self, "license_info")

    @property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "modified_at")

    @property
    @pulumi.getter(name="serviceAccessSecurityGroups")
    def service_access_security_groups(self) -> pulumi.Output[Optional['outputs.ServiceAccessSecurityGroupsProperties']]:
        return pulumi.get(self, "service_access_security_groups")

    @property
    @pulumi.getter(name="serviceAccessSubnetId")
    def service_access_subnet_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "service_access_subnet_id")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter(name="stateDetails")
    def state_details(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "state_details")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="termsAccepted")
    def terms_accepted(self) -> pulumi.Output[builtins.bool]:
        return pulumi.get(self, "terms_accepted")

    @property
    @pulumi.getter(name="vcfHostnames")
    def vcf_hostnames(self) -> pulumi.Output['outputs.VcfHostnamesProperties']:
        return pulumi.get(self, "vcf_hostnames")

    @property
    @pulumi.getter(name="vcfVersion")
    def vcf_version(self) -> pulumi.Output['EnvironmentVcfVersion']:
        return pulumi.get(self, "vcf_version")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "vpc_id")

