# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ExperimentMetricGoalObject',
    'ExperimentOnlineAbConfigObject',
    'ExperimentRunningStatusObject',
    'ExperimentTreatmentObject',
    'ExperimentTreatmentToWeight',
    'FeatureEntityOverride',
    'FeatureVariationObject',
    'LaunchExecutionStatusObject',
    'LaunchGroupObject',
    'LaunchGroupToWeight',
    'LaunchMetricDefinitionObject',
    'LaunchSegmentOverride',
    'LaunchStepConfig',
    'ProjectAppConfigResourceObject',
    'ProjectDataDeliveryObject',
    'ProjectS3Destination',
]

@pulumi.output_type
class ExperimentMetricGoalObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "desiredChange":
            suggest = "desired_change"
        elif key == "entityIdKey":
            suggest = "entity_id_key"
        elif key == "metricName":
            suggest = "metric_name"
        elif key == "valueKey":
            suggest = "value_key"
        elif key == "eventPattern":
            suggest = "event_pattern"
        elif key == "unitLabel":
            suggest = "unit_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExperimentMetricGoalObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExperimentMetricGoalObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExperimentMetricGoalObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 desired_change: 'ExperimentMetricGoalObjectDesiredChange',
                 entity_id_key: builtins.str,
                 metric_name: builtins.str,
                 value_key: builtins.str,
                 event_pattern: Optional[builtins.str] = None,
                 unit_label: Optional[builtins.str] = None):
        """
        :param 'ExperimentMetricGoalObjectDesiredChange' desired_change: `INCREASE` means that a variation with a higher number for this metric is performing better.
               
               `DECREASE` means that a variation with a lower number for this metric is performing better.
        :param builtins.str entity_id_key: The JSON path to reference the entity id in the event.
        :param builtins.str metric_name: A name for the metric. It can include up to 255 characters.
        :param builtins.str value_key: The JSON path to reference the numerical metric value in the event.
        :param builtins.str event_pattern: Event patterns have the same structure as the events they match. Rules use event patterns to select events. An event pattern either matches an event or it doesn't.
        :param builtins.str unit_label: A label for the units that the metric is measuring.
        """
        pulumi.set(__self__, "desired_change", desired_change)
        pulumi.set(__self__, "entity_id_key", entity_id_key)
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "value_key", value_key)
        if event_pattern is not None:
            pulumi.set(__self__, "event_pattern", event_pattern)
        if unit_label is not None:
            pulumi.set(__self__, "unit_label", unit_label)

    @property
    @pulumi.getter(name="desiredChange")
    def desired_change(self) -> 'ExperimentMetricGoalObjectDesiredChange':
        """
        `INCREASE` means that a variation with a higher number for this metric is performing better.

        `DECREASE` means that a variation with a lower number for this metric is performing better.
        """
        return pulumi.get(self, "desired_change")

    @property
    @pulumi.getter(name="entityIdKey")
    def entity_id_key(self) -> builtins.str:
        """
        The JSON path to reference the entity id in the event.
        """
        return pulumi.get(self, "entity_id_key")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> builtins.str:
        """
        A name for the metric. It can include up to 255 characters.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter(name="valueKey")
    def value_key(self) -> builtins.str:
        """
        The JSON path to reference the numerical metric value in the event.
        """
        return pulumi.get(self, "value_key")

    @property
    @pulumi.getter(name="eventPattern")
    def event_pattern(self) -> Optional[builtins.str]:
        """
        Event patterns have the same structure as the events they match. Rules use event patterns to select events. An event pattern either matches an event or it doesn't.
        """
        return pulumi.get(self, "event_pattern")

    @property
    @pulumi.getter(name="unitLabel")
    def unit_label(self) -> Optional[builtins.str]:
        """
        A label for the units that the metric is measuring.
        """
        return pulumi.get(self, "unit_label")


@pulumi.output_type
class ExperimentOnlineAbConfigObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "controlTreatmentName":
            suggest = "control_treatment_name"
        elif key == "treatmentWeights":
            suggest = "treatment_weights"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExperimentOnlineAbConfigObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExperimentOnlineAbConfigObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExperimentOnlineAbConfigObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 control_treatment_name: Optional[builtins.str] = None,
                 treatment_weights: Optional[Sequence['outputs.ExperimentTreatmentToWeight']] = None):
        """
        :param builtins.str control_treatment_name: The name of the variation that is to be the default variation that the other variations are compared to.
        :param Sequence['ExperimentTreatmentToWeight'] treatment_weights: A set of key-value pairs. The keys are treatment names, and the values are the portion of experiment traffic to be assigned to that treatment. Specify the traffic portion in thousandths of a percent, so 20,000 for a variation would allocate 20% of the experiment traffic to that variation.
        """
        if control_treatment_name is not None:
            pulumi.set(__self__, "control_treatment_name", control_treatment_name)
        if treatment_weights is not None:
            pulumi.set(__self__, "treatment_weights", treatment_weights)

    @property
    @pulumi.getter(name="controlTreatmentName")
    def control_treatment_name(self) -> Optional[builtins.str]:
        """
        The name of the variation that is to be the default variation that the other variations are compared to.
        """
        return pulumi.get(self, "control_treatment_name")

    @property
    @pulumi.getter(name="treatmentWeights")
    def treatment_weights(self) -> Optional[Sequence['outputs.ExperimentTreatmentToWeight']]:
        """
        A set of key-value pairs. The keys are treatment names, and the values are the portion of experiment traffic to be assigned to that treatment. Specify the traffic portion in thousandths of a percent, so 20,000 for a variation would allocate 20% of the experiment traffic to that variation.
        """
        return pulumi.get(self, "treatment_weights")


@pulumi.output_type
class ExperimentRunningStatusObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "analysisCompleteTime":
            suggest = "analysis_complete_time"
        elif key == "desiredState":
            suggest = "desired_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExperimentRunningStatusObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExperimentRunningStatusObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExperimentRunningStatusObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 analysis_complete_time: Optional[builtins.str] = None,
                 desired_state: Optional[builtins.str] = None,
                 reason: Optional[builtins.str] = None,
                 status: Optional[builtins.str] = None):
        """
        :param builtins.str analysis_complete_time: Provide the analysis Completion time for an experiment
        :param builtins.str desired_state: Provide CANCELLED or COMPLETED desired state when stopping an experiment
        :param builtins.str reason: Reason is a required input for stopping the experiment
        :param builtins.str status: Provide START or STOP action to apply on an experiment
        """
        if analysis_complete_time is not None:
            pulumi.set(__self__, "analysis_complete_time", analysis_complete_time)
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="analysisCompleteTime")
    def analysis_complete_time(self) -> Optional[builtins.str]:
        """
        Provide the analysis Completion time for an experiment
        """
        return pulumi.get(self, "analysis_complete_time")

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[builtins.str]:
        """
        Provide CANCELLED or COMPLETED desired state when stopping an experiment
        """
        return pulumi.get(self, "desired_state")

    @property
    @pulumi.getter
    def reason(self) -> Optional[builtins.str]:
        """
        Reason is a required input for stopping the experiment
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        Provide START or STOP action to apply on an experiment
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class ExperimentTreatmentObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "treatmentName":
            suggest = "treatment_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExperimentTreatmentObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExperimentTreatmentObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExperimentTreatmentObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 feature: builtins.str,
                 treatment_name: builtins.str,
                 variation: builtins.str,
                 description: Optional[builtins.str] = None):
        """
        :param builtins.str feature: The name of the feature for this experiment.
        :param builtins.str treatment_name: A name for this treatment. It can include up to 127 characters.
        :param builtins.str variation: The name of the variation to use for this treatment.
        :param builtins.str description: The description of the treatment.
        """
        pulumi.set(__self__, "feature", feature)
        pulumi.set(__self__, "treatment_name", treatment_name)
        pulumi.set(__self__, "variation", variation)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def feature(self) -> builtins.str:
        """
        The name of the feature for this experiment.
        """
        return pulumi.get(self, "feature")

    @property
    @pulumi.getter(name="treatmentName")
    def treatment_name(self) -> builtins.str:
        """
        A name for this treatment. It can include up to 127 characters.
        """
        return pulumi.get(self, "treatment_name")

    @property
    @pulumi.getter
    def variation(self) -> builtins.str:
        """
        The name of the variation to use for this treatment.
        """
        return pulumi.get(self, "variation")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the treatment.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class ExperimentTreatmentToWeight(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "splitWeight":
            suggest = "split_weight"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExperimentTreatmentToWeight. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExperimentTreatmentToWeight.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExperimentTreatmentToWeight.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 split_weight: builtins.int,
                 treatment: builtins.str):
        """
        :param builtins.int split_weight: The portion of experiment traffic to allocate to this treatment. Specify the traffic portion in thousandths of a percent, so 20,000 allocated to a treatment would allocate 20% of the experiment traffic to that treatment.
        :param builtins.str treatment: The name of the treatment.
        """
        pulumi.set(__self__, "split_weight", split_weight)
        pulumi.set(__self__, "treatment", treatment)

    @property
    @pulumi.getter(name="splitWeight")
    def split_weight(self) -> builtins.int:
        """
        The portion of experiment traffic to allocate to this treatment. Specify the traffic portion in thousandths of a percent, so 20,000 allocated to a treatment would allocate 20% of the experiment traffic to that treatment.
        """
        return pulumi.get(self, "split_weight")

    @property
    @pulumi.getter
    def treatment(self) -> builtins.str:
        """
        The name of the treatment.
        """
        return pulumi.get(self, "treatment")


@pulumi.output_type
class FeatureEntityOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entityId":
            suggest = "entity_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeatureEntityOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeatureEntityOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeatureEntityOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entity_id: Optional[builtins.str] = None,
                 variation: Optional[builtins.str] = None):
        """
        :param builtins.str entity_id: The entity ID to be served the variation specified in `Variation` .
        :param builtins.str variation: The name of the variation to serve to the user session that matches the `EntityId` .
        """
        if entity_id is not None:
            pulumi.set(__self__, "entity_id", entity_id)
        if variation is not None:
            pulumi.set(__self__, "variation", variation)

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> Optional[builtins.str]:
        """
        The entity ID to be served the variation specified in `Variation` .
        """
        return pulumi.get(self, "entity_id")

    @property
    @pulumi.getter
    def variation(self) -> Optional[builtins.str]:
        """
        The name of the variation to serve to the user session that matches the `EntityId` .
        """
        return pulumi.get(self, "variation")


@pulumi.output_type
class FeatureVariationObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "booleanValue":
            suggest = "boolean_value"
        elif key == "doubleValue":
            suggest = "double_value"
        elif key == "longValue":
            suggest = "long_value"
        elif key == "stringValue":
            suggest = "string_value"
        elif key == "variationName":
            suggest = "variation_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeatureVariationObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeatureVariationObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeatureVariationObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boolean_value: Optional[builtins.bool] = None,
                 double_value: Optional[builtins.float] = None,
                 long_value: Optional[builtins.float] = None,
                 string_value: Optional[builtins.str] = None,
                 variation_name: Optional[builtins.str] = None):
        """
        :param builtins.bool boolean_value: The value assigned to this variation, if the variation type is boolean.
        :param builtins.float double_value: The value assigned to this variation, if the variation type is a double.
        :param builtins.float long_value: The value assigned to this variation, if the variation type is a long.
        :param builtins.str string_value: The value assigned to this variation, if the variation type is a string.
        :param builtins.str variation_name: A name for the variation. It can include up to 127 characters.
        """
        if boolean_value is not None:
            pulumi.set(__self__, "boolean_value", boolean_value)
        if double_value is not None:
            pulumi.set(__self__, "double_value", double_value)
        if long_value is not None:
            pulumi.set(__self__, "long_value", long_value)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)
        if variation_name is not None:
            pulumi.set(__self__, "variation_name", variation_name)

    @property
    @pulumi.getter(name="booleanValue")
    def boolean_value(self) -> Optional[builtins.bool]:
        """
        The value assigned to this variation, if the variation type is boolean.
        """
        return pulumi.get(self, "boolean_value")

    @property
    @pulumi.getter(name="doubleValue")
    def double_value(self) -> Optional[builtins.float]:
        """
        The value assigned to this variation, if the variation type is a double.
        """
        return pulumi.get(self, "double_value")

    @property
    @pulumi.getter(name="longValue")
    def long_value(self) -> Optional[builtins.float]:
        """
        The value assigned to this variation, if the variation type is a long.
        """
        return pulumi.get(self, "long_value")

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[builtins.str]:
        """
        The value assigned to this variation, if the variation type is a string.
        """
        return pulumi.get(self, "string_value")

    @property
    @pulumi.getter(name="variationName")
    def variation_name(self) -> Optional[builtins.str]:
        """
        A name for the variation. It can include up to 127 characters.
        """
        return pulumi.get(self, "variation_name")


@pulumi.output_type
class LaunchExecutionStatusObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "desiredState":
            suggest = "desired_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LaunchExecutionStatusObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LaunchExecutionStatusObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LaunchExecutionStatusObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: builtins.str,
                 desired_state: Optional[builtins.str] = None,
                 reason: Optional[builtins.str] = None):
        """
        :param builtins.str status: Provide START or STOP action to apply on a launch
        :param builtins.str desired_state: Provide CANCELLED or COMPLETED as the launch desired state. Defaults to Completed if not provided.
        :param builtins.str reason: Provide a reason for stopping the launch. Defaults to empty if not provided.
        """
        pulumi.set(__self__, "status", status)
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Provide START or STOP action to apply on a launch
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[builtins.str]:
        """
        Provide CANCELLED or COMPLETED as the launch desired state. Defaults to Completed if not provided.
        """
        return pulumi.get(self, "desired_state")

    @property
    @pulumi.getter
    def reason(self) -> Optional[builtins.str]:
        """
        Provide a reason for stopping the launch. Defaults to empty if not provided.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class LaunchGroupObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupName":
            suggest = "group_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LaunchGroupObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LaunchGroupObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LaunchGroupObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 feature: builtins.str,
                 group_name: builtins.str,
                 variation: builtins.str,
                 description: Optional[builtins.str] = None):
        """
        :param builtins.str feature: The feature that this launch is using.
        :param builtins.str group_name: A name for this launch group. It can include up to 127 characters.
        :param builtins.str variation: The feature variation to use for this launch group.
        :param builtins.str description: A description of the launch group.
        """
        pulumi.set(__self__, "feature", feature)
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "variation", variation)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def feature(self) -> builtins.str:
        """
        The feature that this launch is using.
        """
        return pulumi.get(self, "feature")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> builtins.str:
        """
        A name for this launch group. It can include up to 127 characters.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter
    def variation(self) -> builtins.str:
        """
        The feature variation to use for this launch group.
        """
        return pulumi.get(self, "variation")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A description of the launch group.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class LaunchGroupToWeight(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupName":
            suggest = "group_name"
        elif key == "splitWeight":
            suggest = "split_weight"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LaunchGroupToWeight. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LaunchGroupToWeight.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LaunchGroupToWeight.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_name: builtins.str,
                 split_weight: builtins.int):
        """
        :param builtins.str group_name: The name of the launch group. It can include up to 127 characters.
        :param builtins.int split_weight: The portion of launch traffic to allocate to this launch group.
               
               This is represented in thousandths of a percent. For example, specify 20,000 to allocate 20% of the launch audience to this launch group.
        """
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "split_weight", split_weight)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> builtins.str:
        """
        The name of the launch group. It can include up to 127 characters.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter(name="splitWeight")
    def split_weight(self) -> builtins.int:
        """
        The portion of launch traffic to allocate to this launch group.

        This is represented in thousandths of a percent. For example, specify 20,000 to allocate 20% of the launch audience to this launch group.
        """
        return pulumi.get(self, "split_weight")


@pulumi.output_type
class LaunchMetricDefinitionObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entityIdKey":
            suggest = "entity_id_key"
        elif key == "metricName":
            suggest = "metric_name"
        elif key == "valueKey":
            suggest = "value_key"
        elif key == "eventPattern":
            suggest = "event_pattern"
        elif key == "unitLabel":
            suggest = "unit_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LaunchMetricDefinitionObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LaunchMetricDefinitionObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LaunchMetricDefinitionObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entity_id_key: builtins.str,
                 metric_name: builtins.str,
                 value_key: builtins.str,
                 event_pattern: Optional[builtins.str] = None,
                 unit_label: Optional[builtins.str] = None):
        """
        :param builtins.str entity_id_key: The JSON path to reference the entity id in the event.
        :param builtins.str metric_name: A name for the metric. It can include up to 255 characters.
        :param builtins.str value_key: The JSON path to reference the numerical metric value in the event.
        :param builtins.str event_pattern: Event patterns have the same structure as the events they match. Rules use event patterns to select events. An event pattern either matches an event or it doesn't.
        :param builtins.str unit_label: A label for the units that the metric is measuring.
        """
        pulumi.set(__self__, "entity_id_key", entity_id_key)
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "value_key", value_key)
        if event_pattern is not None:
            pulumi.set(__self__, "event_pattern", event_pattern)
        if unit_label is not None:
            pulumi.set(__self__, "unit_label", unit_label)

    @property
    @pulumi.getter(name="entityIdKey")
    def entity_id_key(self) -> builtins.str:
        """
        The JSON path to reference the entity id in the event.
        """
        return pulumi.get(self, "entity_id_key")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> builtins.str:
        """
        A name for the metric. It can include up to 255 characters.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter(name="valueKey")
    def value_key(self) -> builtins.str:
        """
        The JSON path to reference the numerical metric value in the event.
        """
        return pulumi.get(self, "value_key")

    @property
    @pulumi.getter(name="eventPattern")
    def event_pattern(self) -> Optional[builtins.str]:
        """
        Event patterns have the same structure as the events they match. Rules use event patterns to select events. An event pattern either matches an event or it doesn't.
        """
        return pulumi.get(self, "event_pattern")

    @property
    @pulumi.getter(name="unitLabel")
    def unit_label(self) -> Optional[builtins.str]:
        """
        A label for the units that the metric is measuring.
        """
        return pulumi.get(self, "unit_label")


@pulumi.output_type
class LaunchSegmentOverride(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evaluationOrder":
            suggest = "evaluation_order"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LaunchSegmentOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LaunchSegmentOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LaunchSegmentOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 evaluation_order: builtins.int,
                 segment: builtins.str,
                 weights: Sequence['outputs.LaunchGroupToWeight']):
        """
        :param builtins.int evaluation_order: A number indicating the order to use to evaluate segment overrides, if there are more than one. Segment overrides with lower numbers are evaluated first.
        :param builtins.str segment: The ARN of the segment to use for this override.
        :param Sequence['LaunchGroupToWeight'] weights: The traffic allocation percentages among the feature variations to assign to this segment. This is a set of key-value pairs. The keys are variation names. The values represent the amount of traffic to allocate to that variation for this segment. This is expressed in thousandths of a percent, so a weight of 50000 represents 50% of traffic.
        """
        pulumi.set(__self__, "evaluation_order", evaluation_order)
        pulumi.set(__self__, "segment", segment)
        pulumi.set(__self__, "weights", weights)

    @property
    @pulumi.getter(name="evaluationOrder")
    def evaluation_order(self) -> builtins.int:
        """
        A number indicating the order to use to evaluate segment overrides, if there are more than one. Segment overrides with lower numbers are evaluated first.
        """
        return pulumi.get(self, "evaluation_order")

    @property
    @pulumi.getter
    def segment(self) -> builtins.str:
        """
        The ARN of the segment to use for this override.
        """
        return pulumi.get(self, "segment")

    @property
    @pulumi.getter
    def weights(self) -> Sequence['outputs.LaunchGroupToWeight']:
        """
        The traffic allocation percentages among the feature variations to assign to this segment. This is a set of key-value pairs. The keys are variation names. The values represent the amount of traffic to allocate to that variation for this segment. This is expressed in thousandths of a percent, so a weight of 50000 represents 50% of traffic.
        """
        return pulumi.get(self, "weights")


@pulumi.output_type
class LaunchStepConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupWeights":
            suggest = "group_weights"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "segmentOverrides":
            suggest = "segment_overrides"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LaunchStepConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LaunchStepConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LaunchStepConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_weights: Sequence['outputs.LaunchGroupToWeight'],
                 start_time: builtins.str,
                 segment_overrides: Optional[Sequence['outputs.LaunchSegmentOverride']] = None):
        """
        :param Sequence['LaunchGroupToWeight'] group_weights: An array of structures that define how much launch traffic to allocate to each launch group during this step of the launch.
        :param builtins.str start_time: The date and time to start this step of the launch. Use UTC format, `yyyy-MM-ddTHH:mm:ssZ` . For example, `2025-11-25T23:59:59Z`
        :param Sequence['LaunchSegmentOverride'] segment_overrides: An array of structures that you can use to specify different traffic splits for one or more audience *segments* . A segment is a portion of your audience that share one or more characteristics. Examples could be Chrome browser users, users in Europe, or Firefox browser users in Europe who also fit other criteria that your application collects, such as age.
               
               For more information, see [Use segments to focus your audience](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html) .
        """
        pulumi.set(__self__, "group_weights", group_weights)
        pulumi.set(__self__, "start_time", start_time)
        if segment_overrides is not None:
            pulumi.set(__self__, "segment_overrides", segment_overrides)

    @property
    @pulumi.getter(name="groupWeights")
    def group_weights(self) -> Sequence['outputs.LaunchGroupToWeight']:
        """
        An array of structures that define how much launch traffic to allocate to each launch group during this step of the launch.
        """
        return pulumi.get(self, "group_weights")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> builtins.str:
        """
        The date and time to start this step of the launch. Use UTC format, `yyyy-MM-ddTHH:mm:ssZ` . For example, `2025-11-25T23:59:59Z`
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="segmentOverrides")
    def segment_overrides(self) -> Optional[Sequence['outputs.LaunchSegmentOverride']]:
        """
        An array of structures that you can use to specify different traffic splits for one or more audience *segments* . A segment is a portion of your audience that share one or more characteristics. Examples could be Chrome browser users, users in Europe, or Firefox browser users in Europe who also fit other criteria that your application collects, such as age.

        For more information, see [Use segments to focus your audience](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html) .
        """
        return pulumi.get(self, "segment_overrides")


@pulumi.output_type
class ProjectAppConfigResourceObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationId":
            suggest = "application_id"
        elif key == "environmentId":
            suggest = "environment_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectAppConfigResourceObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectAppConfigResourceObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectAppConfigResourceObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_id: builtins.str,
                 environment_id: builtins.str):
        """
        :param builtins.str application_id: The ID of the AWS AppConfig application to use for client-side evaluation.
        :param builtins.str environment_id: The ID of the AWS AppConfig environment to use for client-side evaluation.
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "environment_id", environment_id)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> builtins.str:
        """
        The ID of the AWS AppConfig application to use for client-side evaluation.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> builtins.str:
        """
        The ID of the AWS AppConfig environment to use for client-side evaluation.
        """
        return pulumi.get(self, "environment_id")


@pulumi.output_type
class ProjectDataDeliveryObject(dict):
    """
    Destinations for data.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroup":
            suggest = "log_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectDataDeliveryObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectDataDeliveryObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectDataDeliveryObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_group: Optional[builtins.str] = None,
                 s3: Optional['outputs.ProjectS3Destination'] = None):
        """
        Destinations for data.
        :param builtins.str log_group: If the project stores evaluation events in CloudWatch Logs , this structure stores the log group name.
        :param 'ProjectS3Destination' s3: If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and bucket prefix.
        """
        if log_group is not None:
            pulumi.set(__self__, "log_group", log_group)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)

    @property
    @pulumi.getter(name="logGroup")
    def log_group(self) -> Optional[builtins.str]:
        """
        If the project stores evaluation events in CloudWatch Logs , this structure stores the log group name.
        """
        return pulumi.get(self, "log_group")

    @property
    @pulumi.getter
    def s3(self) -> Optional['outputs.ProjectS3Destination']:
        """
        If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and bucket prefix.
        """
        return pulumi.get(self, "s3")


@pulumi.output_type
class ProjectS3Destination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectS3Destination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectS3Destination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectS3Destination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: builtins.str,
                 prefix: Optional[builtins.str] = None):
        """
        :param builtins.str bucket_name: The name of the bucket in which Evidently stores evaluation events.
        :param builtins.str prefix: The bucket prefix in which Evidently stores evaluation events.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> builtins.str:
        """
        The name of the bucket in which Evidently stores evaluation events.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        """
        The bucket prefix in which Evidently stores evaluation events.
        """
        return pulumi.get(self, "prefix")


