# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetProjectResult',
    'AwaitableGetProjectResult',
    'get_project',
    'get_project_output',
]

@pulumi.output_type
class GetProjectResult:
    def __init__(__self__, app_config_resource=None, arn=None, data_delivery=None, description=None, tags=None):
        if app_config_resource and not isinstance(app_config_resource, dict):
            raise TypeError("Expected argument 'app_config_resource' to be a dict")
        pulumi.set(__self__, "app_config_resource", app_config_resource)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if data_delivery and not isinstance(data_delivery, dict):
            raise TypeError("Expected argument 'data_delivery' to be a dict")
        pulumi.set(__self__, "data_delivery", data_delivery)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="appConfigResource")
    def app_config_resource(self) -> Optional['outputs.ProjectAppConfigResourceObject']:
        """
        Use this parameter if the project will use *client-side evaluation powered by AWS AppConfig* . Client-side evaluation allows your application to assign variations to user sessions locally instead of by calling the [EvaluateFeature](https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_EvaluateFeature.html) operation. This mitigates the latency and availability risks that come with an API call. For more information, see [Use client-side evaluation - powered by AWS AppConfig .](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-client-side-evaluation.html)

        This parameter is a structure that contains information about the AWS AppConfig application that will be used as for client-side evaluation.

        To create a project that uses client-side evaluation, you must have the `evidently:ExportProjectAsConfiguration` permission.
        """
        return pulumi.get(self, "app_config_resource")

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The ARN of the project. For example, `arn:aws:evidently:us-west-2:0123455678912:project/myProject`
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="dataDelivery")
    def data_delivery(self) -> Optional['outputs.ProjectDataDeliveryObject']:
        """
        A structure that contains information about where Evidently is to store evaluation events for longer term storage, if you choose to do so. If you choose not to store these events, Evidently deletes them after using them to produce metrics and other experiment results that you can view.

        You can't specify both `CloudWatchLogs` and `S3Destination` in the same operation.
        """
        return pulumi.get(self, "data_delivery")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        An optional description of the project.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetProjectResult(GetProjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectResult(
            app_config_resource=self.app_config_resource,
            arn=self.arn,
            data_delivery=self.data_delivery,
            description=self.description,
            tags=self.tags)


def get_project(arn: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectResult:
    """
    Resource Type definition for AWS::Evidently::Project


    :param builtins.str arn: The ARN of the project. For example, `arn:aws:evidently:us-west-2:0123455678912:project/myProject`
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:evidently:getProject', __args__, opts=opts, typ=GetProjectResult).value

    return AwaitableGetProjectResult(
        app_config_resource=pulumi.get(__ret__, 'app_config_resource'),
        arn=pulumi.get(__ret__, 'arn'),
        data_delivery=pulumi.get(__ret__, 'data_delivery'),
        description=pulumi.get(__ret__, 'description'),
        tags=pulumi.get(__ret__, 'tags'))
def get_project_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProjectResult]:
    """
    Resource Type definition for AWS::Evidently::Project


    :param builtins.str arn: The ARN of the project. For example, `arn:aws:evidently:us-west-2:0123455678912:project/myProject`
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:evidently:getProject', __args__, opts=opts, typ=GetProjectResult)
    return __ret__.apply(lambda __response__: GetProjectResult(
        app_config_resource=pulumi.get(__response__, 'app_config_resource'),
        arn=pulumi.get(__response__, 'arn'),
        data_delivery=pulumi.get(__response__, 'data_delivery'),
        description=pulumi.get(__response__, 'description'),
        tags=pulumi.get(__response__, 'tags')))
