# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ExperimentMetricGoalObjectArgs',
    'ExperimentMetricGoalObjectArgsDict',
    'ExperimentOnlineAbConfigObjectArgs',
    'ExperimentOnlineAbConfigObjectArgsDict',
    'ExperimentRunningStatusObjectArgs',
    'ExperimentRunningStatusObjectArgsDict',
    'ExperimentTreatmentObjectArgs',
    'ExperimentTreatmentObjectArgsDict',
    'ExperimentTreatmentToWeightArgs',
    'ExperimentTreatmentToWeightArgsDict',
    'FeatureEntityOverrideArgs',
    'FeatureEntityOverrideArgsDict',
    'FeatureVariationObjectArgs',
    'FeatureVariationObjectArgsDict',
    'LaunchExecutionStatusObjectArgs',
    'LaunchExecutionStatusObjectArgsDict',
    'LaunchGroupObjectArgs',
    'LaunchGroupObjectArgsDict',
    'LaunchGroupToWeightArgs',
    'LaunchGroupToWeightArgsDict',
    'LaunchMetricDefinitionObjectArgs',
    'LaunchMetricDefinitionObjectArgsDict',
    'LaunchSegmentOverrideArgs',
    'LaunchSegmentOverrideArgsDict',
    'LaunchStepConfigArgs',
    'LaunchStepConfigArgsDict',
    'ProjectAppConfigResourceObjectArgs',
    'ProjectAppConfigResourceObjectArgsDict',
    'ProjectDataDeliveryObjectArgs',
    'ProjectDataDeliveryObjectArgsDict',
    'ProjectS3DestinationArgs',
    'ProjectS3DestinationArgsDict',
]

MYPY = False

if not MYPY:
    class ExperimentMetricGoalObjectArgsDict(TypedDict):
        desired_change: pulumi.Input['ExperimentMetricGoalObjectDesiredChange']
        """
        `INCREASE` means that a variation with a higher number for this metric is performing better.

        `DECREASE` means that a variation with a lower number for this metric is performing better.
        """
        entity_id_key: pulumi.Input[builtins.str]
        """
        The JSON path to reference the entity id in the event.
        """
        metric_name: pulumi.Input[builtins.str]
        """
        A name for the metric. It can include up to 255 characters.
        """
        value_key: pulumi.Input[builtins.str]
        """
        The JSON path to reference the numerical metric value in the event.
        """
        event_pattern: NotRequired[pulumi.Input[builtins.str]]
        """
        Event patterns have the same structure as the events they match. Rules use event patterns to select events. An event pattern either matches an event or it doesn't.
        """
        unit_label: NotRequired[pulumi.Input[builtins.str]]
        """
        A label for the units that the metric is measuring.
        """
elif False:
    ExperimentMetricGoalObjectArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ExperimentMetricGoalObjectArgs:
    def __init__(__self__, *,
                 desired_change: pulumi.Input['ExperimentMetricGoalObjectDesiredChange'],
                 entity_id_key: pulumi.Input[builtins.str],
                 metric_name: pulumi.Input[builtins.str],
                 value_key: pulumi.Input[builtins.str],
                 event_pattern: Optional[pulumi.Input[builtins.str]] = None,
                 unit_label: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input['ExperimentMetricGoalObjectDesiredChange'] desired_change: `INCREASE` means that a variation with a higher number for this metric is performing better.
               
               `DECREASE` means that a variation with a lower number for this metric is performing better.
        :param pulumi.Input[builtins.str] entity_id_key: The JSON path to reference the entity id in the event.
        :param pulumi.Input[builtins.str] metric_name: A name for the metric. It can include up to 255 characters.
        :param pulumi.Input[builtins.str] value_key: The JSON path to reference the numerical metric value in the event.
        :param pulumi.Input[builtins.str] event_pattern: Event patterns have the same structure as the events they match. Rules use event patterns to select events. An event pattern either matches an event or it doesn't.
        :param pulumi.Input[builtins.str] unit_label: A label for the units that the metric is measuring.
        """
        pulumi.set(__self__, "desired_change", desired_change)
        pulumi.set(__self__, "entity_id_key", entity_id_key)
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "value_key", value_key)
        if event_pattern is not None:
            pulumi.set(__self__, "event_pattern", event_pattern)
        if unit_label is not None:
            pulumi.set(__self__, "unit_label", unit_label)

    @property
    @pulumi.getter(name="desiredChange")
    def desired_change(self) -> pulumi.Input['ExperimentMetricGoalObjectDesiredChange']:
        """
        `INCREASE` means that a variation with a higher number for this metric is performing better.

        `DECREASE` means that a variation with a lower number for this metric is performing better.
        """
        return pulumi.get(self, "desired_change")

    @desired_change.setter
    def desired_change(self, value: pulumi.Input['ExperimentMetricGoalObjectDesiredChange']):
        pulumi.set(self, "desired_change", value)

    @property
    @pulumi.getter(name="entityIdKey")
    def entity_id_key(self) -> pulumi.Input[builtins.str]:
        """
        The JSON path to reference the entity id in the event.
        """
        return pulumi.get(self, "entity_id_key")

    @entity_id_key.setter
    def entity_id_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "entity_id_key", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[builtins.str]:
        """
        A name for the metric. It can include up to 255 characters.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter(name="valueKey")
    def value_key(self) -> pulumi.Input[builtins.str]:
        """
        The JSON path to reference the numerical metric value in the event.
        """
        return pulumi.get(self, "value_key")

    @value_key.setter
    def value_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value_key", value)

    @property
    @pulumi.getter(name="eventPattern")
    def event_pattern(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Event patterns have the same structure as the events they match. Rules use event patterns to select events. An event pattern either matches an event or it doesn't.
        """
        return pulumi.get(self, "event_pattern")

    @event_pattern.setter
    def event_pattern(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "event_pattern", value)

    @property
    @pulumi.getter(name="unitLabel")
    def unit_label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A label for the units that the metric is measuring.
        """
        return pulumi.get(self, "unit_label")

    @unit_label.setter
    def unit_label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "unit_label", value)


if not MYPY:
    class ExperimentOnlineAbConfigObjectArgsDict(TypedDict):
        control_treatment_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the variation that is to be the default variation that the other variations are compared to.
        """
        treatment_weights: NotRequired[pulumi.Input[Sequence[pulumi.Input['ExperimentTreatmentToWeightArgsDict']]]]
        """
        A set of key-value pairs. The keys are treatment names, and the values are the portion of experiment traffic to be assigned to that treatment. Specify the traffic portion in thousandths of a percent, so 20,000 for a variation would allocate 20% of the experiment traffic to that variation.
        """
elif False:
    ExperimentOnlineAbConfigObjectArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ExperimentOnlineAbConfigObjectArgs:
    def __init__(__self__, *,
                 control_treatment_name: Optional[pulumi.Input[builtins.str]] = None,
                 treatment_weights: Optional[pulumi.Input[Sequence[pulumi.Input['ExperimentTreatmentToWeightArgs']]]] = None):
        """
        :param pulumi.Input[builtins.str] control_treatment_name: The name of the variation that is to be the default variation that the other variations are compared to.
        :param pulumi.Input[Sequence[pulumi.Input['ExperimentTreatmentToWeightArgs']]] treatment_weights: A set of key-value pairs. The keys are treatment names, and the values are the portion of experiment traffic to be assigned to that treatment. Specify the traffic portion in thousandths of a percent, so 20,000 for a variation would allocate 20% of the experiment traffic to that variation.
        """
        if control_treatment_name is not None:
            pulumi.set(__self__, "control_treatment_name", control_treatment_name)
        if treatment_weights is not None:
            pulumi.set(__self__, "treatment_weights", treatment_weights)

    @property
    @pulumi.getter(name="controlTreatmentName")
    def control_treatment_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the variation that is to be the default variation that the other variations are compared to.
        """
        return pulumi.get(self, "control_treatment_name")

    @control_treatment_name.setter
    def control_treatment_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "control_treatment_name", value)

    @property
    @pulumi.getter(name="treatmentWeights")
    def treatment_weights(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExperimentTreatmentToWeightArgs']]]]:
        """
        A set of key-value pairs. The keys are treatment names, and the values are the portion of experiment traffic to be assigned to that treatment. Specify the traffic portion in thousandths of a percent, so 20,000 for a variation would allocate 20% of the experiment traffic to that variation.
        """
        return pulumi.get(self, "treatment_weights")

    @treatment_weights.setter
    def treatment_weights(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExperimentTreatmentToWeightArgs']]]]):
        pulumi.set(self, "treatment_weights", value)


if not MYPY:
    class ExperimentRunningStatusObjectArgsDict(TypedDict):
        analysis_complete_time: NotRequired[pulumi.Input[builtins.str]]
        """
        Provide the analysis Completion time for an experiment
        """
        desired_state: NotRequired[pulumi.Input[builtins.str]]
        """
        Provide CANCELLED or COMPLETED desired state when stopping an experiment
        """
        reason: NotRequired[pulumi.Input[builtins.str]]
        """
        Reason is a required input for stopping the experiment
        """
        status: NotRequired[pulumi.Input[builtins.str]]
        """
        Provide START or STOP action to apply on an experiment
        """
elif False:
    ExperimentRunningStatusObjectArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ExperimentRunningStatusObjectArgs:
    def __init__(__self__, *,
                 analysis_complete_time: Optional[pulumi.Input[builtins.str]] = None,
                 desired_state: Optional[pulumi.Input[builtins.str]] = None,
                 reason: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] analysis_complete_time: Provide the analysis Completion time for an experiment
        :param pulumi.Input[builtins.str] desired_state: Provide CANCELLED or COMPLETED desired state when stopping an experiment
        :param pulumi.Input[builtins.str] reason: Reason is a required input for stopping the experiment
        :param pulumi.Input[builtins.str] status: Provide START or STOP action to apply on an experiment
        """
        if analysis_complete_time is not None:
            pulumi.set(__self__, "analysis_complete_time", analysis_complete_time)
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="analysisCompleteTime")
    def analysis_complete_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Provide the analysis Completion time for an experiment
        """
        return pulumi.get(self, "analysis_complete_time")

    @analysis_complete_time.setter
    def analysis_complete_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "analysis_complete_time", value)

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Provide CANCELLED or COMPLETED desired state when stopping an experiment
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "desired_state", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Reason is a required input for stopping the experiment
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Provide START or STOP action to apply on an experiment
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)


if not MYPY:
    class ExperimentTreatmentObjectArgsDict(TypedDict):
        feature: pulumi.Input[builtins.str]
        """
        The name of the feature for this experiment.
        """
        treatment_name: pulumi.Input[builtins.str]
        """
        A name for this treatment. It can include up to 127 characters.
        """
        variation: pulumi.Input[builtins.str]
        """
        The name of the variation to use for this treatment.
        """
        description: NotRequired[pulumi.Input[builtins.str]]
        """
        The description of the treatment.
        """
elif False:
    ExperimentTreatmentObjectArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ExperimentTreatmentObjectArgs:
    def __init__(__self__, *,
                 feature: pulumi.Input[builtins.str],
                 treatment_name: pulumi.Input[builtins.str],
                 variation: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] feature: The name of the feature for this experiment.
        :param pulumi.Input[builtins.str] treatment_name: A name for this treatment. It can include up to 127 characters.
        :param pulumi.Input[builtins.str] variation: The name of the variation to use for this treatment.
        :param pulumi.Input[builtins.str] description: The description of the treatment.
        """
        pulumi.set(__self__, "feature", feature)
        pulumi.set(__self__, "treatment_name", treatment_name)
        pulumi.set(__self__, "variation", variation)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def feature(self) -> pulumi.Input[builtins.str]:
        """
        The name of the feature for this experiment.
        """
        return pulumi.get(self, "feature")

    @feature.setter
    def feature(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "feature", value)

    @property
    @pulumi.getter(name="treatmentName")
    def treatment_name(self) -> pulumi.Input[builtins.str]:
        """
        A name for this treatment. It can include up to 127 characters.
        """
        return pulumi.get(self, "treatment_name")

    @treatment_name.setter
    def treatment_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "treatment_name", value)

    @property
    @pulumi.getter
    def variation(self) -> pulumi.Input[builtins.str]:
        """
        The name of the variation to use for this treatment.
        """
        return pulumi.get(self, "variation")

    @variation.setter
    def variation(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "variation", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the treatment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class ExperimentTreatmentToWeightArgsDict(TypedDict):
        split_weight: pulumi.Input[builtins.int]
        """
        The portion of experiment traffic to allocate to this treatment. Specify the traffic portion in thousandths of a percent, so 20,000 allocated to a treatment would allocate 20% of the experiment traffic to that treatment.
        """
        treatment: pulumi.Input[builtins.str]
        """
        The name of the treatment.
        """
elif False:
    ExperimentTreatmentToWeightArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ExperimentTreatmentToWeightArgs:
    def __init__(__self__, *,
                 split_weight: pulumi.Input[builtins.int],
                 treatment: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.int] split_weight: The portion of experiment traffic to allocate to this treatment. Specify the traffic portion in thousandths of a percent, so 20,000 allocated to a treatment would allocate 20% of the experiment traffic to that treatment.
        :param pulumi.Input[builtins.str] treatment: The name of the treatment.
        """
        pulumi.set(__self__, "split_weight", split_weight)
        pulumi.set(__self__, "treatment", treatment)

    @property
    @pulumi.getter(name="splitWeight")
    def split_weight(self) -> pulumi.Input[builtins.int]:
        """
        The portion of experiment traffic to allocate to this treatment. Specify the traffic portion in thousandths of a percent, so 20,000 allocated to a treatment would allocate 20% of the experiment traffic to that treatment.
        """
        return pulumi.get(self, "split_weight")

    @split_weight.setter
    def split_weight(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "split_weight", value)

    @property
    @pulumi.getter
    def treatment(self) -> pulumi.Input[builtins.str]:
        """
        The name of the treatment.
        """
        return pulumi.get(self, "treatment")

    @treatment.setter
    def treatment(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "treatment", value)


if not MYPY:
    class FeatureEntityOverrideArgsDict(TypedDict):
        entity_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The entity ID to be served the variation specified in `Variation` .
        """
        variation: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the variation to serve to the user session that matches the `EntityId` .
        """
elif False:
    FeatureEntityOverrideArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FeatureEntityOverrideArgs:
    def __init__(__self__, *,
                 entity_id: Optional[pulumi.Input[builtins.str]] = None,
                 variation: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] entity_id: The entity ID to be served the variation specified in `Variation` .
        :param pulumi.Input[builtins.str] variation: The name of the variation to serve to the user session that matches the `EntityId` .
        """
        if entity_id is not None:
            pulumi.set(__self__, "entity_id", entity_id)
        if variation is not None:
            pulumi.set(__self__, "variation", variation)

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The entity ID to be served the variation specified in `Variation` .
        """
        return pulumi.get(self, "entity_id")

    @entity_id.setter
    def entity_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "entity_id", value)

    @property
    @pulumi.getter
    def variation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the variation to serve to the user session that matches the `EntityId` .
        """
        return pulumi.get(self, "variation")

    @variation.setter
    def variation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "variation", value)


if not MYPY:
    class FeatureVariationObjectArgsDict(TypedDict):
        boolean_value: NotRequired[pulumi.Input[builtins.bool]]
        """
        The value assigned to this variation, if the variation type is boolean.
        """
        double_value: NotRequired[pulumi.Input[builtins.float]]
        """
        The value assigned to this variation, if the variation type is a double.
        """
        long_value: NotRequired[pulumi.Input[builtins.float]]
        """
        The value assigned to this variation, if the variation type is a long.
        """
        string_value: NotRequired[pulumi.Input[builtins.str]]
        """
        The value assigned to this variation, if the variation type is a string.
        """
        variation_name: NotRequired[pulumi.Input[builtins.str]]
        """
        A name for the variation. It can include up to 127 characters.
        """
elif False:
    FeatureVariationObjectArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FeatureVariationObjectArgs:
    def __init__(__self__, *,
                 boolean_value: Optional[pulumi.Input[builtins.bool]] = None,
                 double_value: Optional[pulumi.Input[builtins.float]] = None,
                 long_value: Optional[pulumi.Input[builtins.float]] = None,
                 string_value: Optional[pulumi.Input[builtins.str]] = None,
                 variation_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.bool] boolean_value: The value assigned to this variation, if the variation type is boolean.
        :param pulumi.Input[builtins.float] double_value: The value assigned to this variation, if the variation type is a double.
        :param pulumi.Input[builtins.float] long_value: The value assigned to this variation, if the variation type is a long.
        :param pulumi.Input[builtins.str] string_value: The value assigned to this variation, if the variation type is a string.
        :param pulumi.Input[builtins.str] variation_name: A name for the variation. It can include up to 127 characters.
        """
        if boolean_value is not None:
            pulumi.set(__self__, "boolean_value", boolean_value)
        if double_value is not None:
            pulumi.set(__self__, "double_value", double_value)
        if long_value is not None:
            pulumi.set(__self__, "long_value", long_value)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)
        if variation_name is not None:
            pulumi.set(__self__, "variation_name", variation_name)

    @property
    @pulumi.getter(name="booleanValue")
    def boolean_value(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The value assigned to this variation, if the variation type is boolean.
        """
        return pulumi.get(self, "boolean_value")

    @boolean_value.setter
    def boolean_value(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "boolean_value", value)

    @property
    @pulumi.getter(name="doubleValue")
    def double_value(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The value assigned to this variation, if the variation type is a double.
        """
        return pulumi.get(self, "double_value")

    @double_value.setter
    def double_value(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "double_value", value)

    @property
    @pulumi.getter(name="longValue")
    def long_value(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The value assigned to this variation, if the variation type is a long.
        """
        return pulumi.get(self, "long_value")

    @long_value.setter
    def long_value(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "long_value", value)

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value assigned to this variation, if the variation type is a string.
        """
        return pulumi.get(self, "string_value")

    @string_value.setter
    def string_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "string_value", value)

    @property
    @pulumi.getter(name="variationName")
    def variation_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A name for the variation. It can include up to 127 characters.
        """
        return pulumi.get(self, "variation_name")

    @variation_name.setter
    def variation_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "variation_name", value)


if not MYPY:
    class LaunchExecutionStatusObjectArgsDict(TypedDict):
        status: pulumi.Input[builtins.str]
        """
        Provide START or STOP action to apply on a launch
        """
        desired_state: NotRequired[pulumi.Input[builtins.str]]
        """
        Provide CANCELLED or COMPLETED as the launch desired state. Defaults to Completed if not provided.
        """
        reason: NotRequired[pulumi.Input[builtins.str]]
        """
        Provide a reason for stopping the launch. Defaults to empty if not provided.
        """
elif False:
    LaunchExecutionStatusObjectArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LaunchExecutionStatusObjectArgs:
    def __init__(__self__, *,
                 status: pulumi.Input[builtins.str],
                 desired_state: Optional[pulumi.Input[builtins.str]] = None,
                 reason: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] status: Provide START or STOP action to apply on a launch
        :param pulumi.Input[builtins.str] desired_state: Provide CANCELLED or COMPLETED as the launch desired state. Defaults to Completed if not provided.
        :param pulumi.Input[builtins.str] reason: Provide a reason for stopping the launch. Defaults to empty if not provided.
        """
        pulumi.set(__self__, "status", status)
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def status(self) -> pulumi.Input[builtins.str]:
        """
        Provide START or STOP action to apply on a launch
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Provide CANCELLED or COMPLETED as the launch desired state. Defaults to Completed if not provided.
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "desired_state", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Provide a reason for stopping the launch. Defaults to empty if not provided.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "reason", value)


if not MYPY:
    class LaunchGroupObjectArgsDict(TypedDict):
        feature: pulumi.Input[builtins.str]
        """
        The feature that this launch is using.
        """
        group_name: pulumi.Input[builtins.str]
        """
        A name for this launch group. It can include up to 127 characters.
        """
        variation: pulumi.Input[builtins.str]
        """
        The feature variation to use for this launch group.
        """
        description: NotRequired[pulumi.Input[builtins.str]]
        """
        A description of the launch group.
        """
elif False:
    LaunchGroupObjectArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LaunchGroupObjectArgs:
    def __init__(__self__, *,
                 feature: pulumi.Input[builtins.str],
                 group_name: pulumi.Input[builtins.str],
                 variation: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] feature: The feature that this launch is using.
        :param pulumi.Input[builtins.str] group_name: A name for this launch group. It can include up to 127 characters.
        :param pulumi.Input[builtins.str] variation: The feature variation to use for this launch group.
        :param pulumi.Input[builtins.str] description: A description of the launch group.
        """
        pulumi.set(__self__, "feature", feature)
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "variation", variation)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def feature(self) -> pulumi.Input[builtins.str]:
        """
        The feature that this launch is using.
        """
        return pulumi.get(self, "feature")

    @feature.setter
    def feature(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "feature", value)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Input[builtins.str]:
        """
        A name for this launch group. It can include up to 127 characters.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "group_name", value)

    @property
    @pulumi.getter
    def variation(self) -> pulumi.Input[builtins.str]:
        """
        The feature variation to use for this launch group.
        """
        return pulumi.get(self, "variation")

    @variation.setter
    def variation(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "variation", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the launch group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class LaunchGroupToWeightArgsDict(TypedDict):
        group_name: pulumi.Input[builtins.str]
        """
        The name of the launch group. It can include up to 127 characters.
        """
        split_weight: pulumi.Input[builtins.int]
        """
        The portion of launch traffic to allocate to this launch group.

        This is represented in thousandths of a percent. For example, specify 20,000 to allocate 20% of the launch audience to this launch group.
        """
elif False:
    LaunchGroupToWeightArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LaunchGroupToWeightArgs:
    def __init__(__self__, *,
                 group_name: pulumi.Input[builtins.str],
                 split_weight: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.str] group_name: The name of the launch group. It can include up to 127 characters.
        :param pulumi.Input[builtins.int] split_weight: The portion of launch traffic to allocate to this launch group.
               
               This is represented in thousandths of a percent. For example, specify 20,000 to allocate 20% of the launch audience to this launch group.
        """
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "split_weight", split_weight)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the launch group. It can include up to 127 characters.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "group_name", value)

    @property
    @pulumi.getter(name="splitWeight")
    def split_weight(self) -> pulumi.Input[builtins.int]:
        """
        The portion of launch traffic to allocate to this launch group.

        This is represented in thousandths of a percent. For example, specify 20,000 to allocate 20% of the launch audience to this launch group.
        """
        return pulumi.get(self, "split_weight")

    @split_weight.setter
    def split_weight(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "split_weight", value)


if not MYPY:
    class LaunchMetricDefinitionObjectArgsDict(TypedDict):
        entity_id_key: pulumi.Input[builtins.str]
        """
        The JSON path to reference the entity id in the event.
        """
        metric_name: pulumi.Input[builtins.str]
        """
        A name for the metric. It can include up to 255 characters.
        """
        value_key: pulumi.Input[builtins.str]
        """
        The JSON path to reference the numerical metric value in the event.
        """
        event_pattern: NotRequired[pulumi.Input[builtins.str]]
        """
        Event patterns have the same structure as the events they match. Rules use event patterns to select events. An event pattern either matches an event or it doesn't.
        """
        unit_label: NotRequired[pulumi.Input[builtins.str]]
        """
        A label for the units that the metric is measuring.
        """
elif False:
    LaunchMetricDefinitionObjectArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LaunchMetricDefinitionObjectArgs:
    def __init__(__self__, *,
                 entity_id_key: pulumi.Input[builtins.str],
                 metric_name: pulumi.Input[builtins.str],
                 value_key: pulumi.Input[builtins.str],
                 event_pattern: Optional[pulumi.Input[builtins.str]] = None,
                 unit_label: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] entity_id_key: The JSON path to reference the entity id in the event.
        :param pulumi.Input[builtins.str] metric_name: A name for the metric. It can include up to 255 characters.
        :param pulumi.Input[builtins.str] value_key: The JSON path to reference the numerical metric value in the event.
        :param pulumi.Input[builtins.str] event_pattern: Event patterns have the same structure as the events they match. Rules use event patterns to select events. An event pattern either matches an event or it doesn't.
        :param pulumi.Input[builtins.str] unit_label: A label for the units that the metric is measuring.
        """
        pulumi.set(__self__, "entity_id_key", entity_id_key)
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "value_key", value_key)
        if event_pattern is not None:
            pulumi.set(__self__, "event_pattern", event_pattern)
        if unit_label is not None:
            pulumi.set(__self__, "unit_label", unit_label)

    @property
    @pulumi.getter(name="entityIdKey")
    def entity_id_key(self) -> pulumi.Input[builtins.str]:
        """
        The JSON path to reference the entity id in the event.
        """
        return pulumi.get(self, "entity_id_key")

    @entity_id_key.setter
    def entity_id_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "entity_id_key", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[builtins.str]:
        """
        A name for the metric. It can include up to 255 characters.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter(name="valueKey")
    def value_key(self) -> pulumi.Input[builtins.str]:
        """
        The JSON path to reference the numerical metric value in the event.
        """
        return pulumi.get(self, "value_key")

    @value_key.setter
    def value_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value_key", value)

    @property
    @pulumi.getter(name="eventPattern")
    def event_pattern(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Event patterns have the same structure as the events they match. Rules use event patterns to select events. An event pattern either matches an event or it doesn't.
        """
        return pulumi.get(self, "event_pattern")

    @event_pattern.setter
    def event_pattern(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "event_pattern", value)

    @property
    @pulumi.getter(name="unitLabel")
    def unit_label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A label for the units that the metric is measuring.
        """
        return pulumi.get(self, "unit_label")

    @unit_label.setter
    def unit_label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "unit_label", value)


if not MYPY:
    class LaunchSegmentOverrideArgsDict(TypedDict):
        evaluation_order: pulumi.Input[builtins.int]
        """
        A number indicating the order to use to evaluate segment overrides, if there are more than one. Segment overrides with lower numbers are evaluated first.
        """
        segment: pulumi.Input[builtins.str]
        """
        The ARN of the segment to use for this override.
        """
        weights: pulumi.Input[Sequence[pulumi.Input['LaunchGroupToWeightArgsDict']]]
        """
        The traffic allocation percentages among the feature variations to assign to this segment. This is a set of key-value pairs. The keys are variation names. The values represent the amount of traffic to allocate to that variation for this segment. This is expressed in thousandths of a percent, so a weight of 50000 represents 50% of traffic.
        """
elif False:
    LaunchSegmentOverrideArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LaunchSegmentOverrideArgs:
    def __init__(__self__, *,
                 evaluation_order: pulumi.Input[builtins.int],
                 segment: pulumi.Input[builtins.str],
                 weights: pulumi.Input[Sequence[pulumi.Input['LaunchGroupToWeightArgs']]]):
        """
        :param pulumi.Input[builtins.int] evaluation_order: A number indicating the order to use to evaluate segment overrides, if there are more than one. Segment overrides with lower numbers are evaluated first.
        :param pulumi.Input[builtins.str] segment: The ARN of the segment to use for this override.
        :param pulumi.Input[Sequence[pulumi.Input['LaunchGroupToWeightArgs']]] weights: The traffic allocation percentages among the feature variations to assign to this segment. This is a set of key-value pairs. The keys are variation names. The values represent the amount of traffic to allocate to that variation for this segment. This is expressed in thousandths of a percent, so a weight of 50000 represents 50% of traffic.
        """
        pulumi.set(__self__, "evaluation_order", evaluation_order)
        pulumi.set(__self__, "segment", segment)
        pulumi.set(__self__, "weights", weights)

    @property
    @pulumi.getter(name="evaluationOrder")
    def evaluation_order(self) -> pulumi.Input[builtins.int]:
        """
        A number indicating the order to use to evaluate segment overrides, if there are more than one. Segment overrides with lower numbers are evaluated first.
        """
        return pulumi.get(self, "evaluation_order")

    @evaluation_order.setter
    def evaluation_order(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "evaluation_order", value)

    @property
    @pulumi.getter
    def segment(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the segment to use for this override.
        """
        return pulumi.get(self, "segment")

    @segment.setter
    def segment(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "segment", value)

    @property
    @pulumi.getter
    def weights(self) -> pulumi.Input[Sequence[pulumi.Input['LaunchGroupToWeightArgs']]]:
        """
        The traffic allocation percentages among the feature variations to assign to this segment. This is a set of key-value pairs. The keys are variation names. The values represent the amount of traffic to allocate to that variation for this segment. This is expressed in thousandths of a percent, so a weight of 50000 represents 50% of traffic.
        """
        return pulumi.get(self, "weights")

    @weights.setter
    def weights(self, value: pulumi.Input[Sequence[pulumi.Input['LaunchGroupToWeightArgs']]]):
        pulumi.set(self, "weights", value)


if not MYPY:
    class LaunchStepConfigArgsDict(TypedDict):
        group_weights: pulumi.Input[Sequence[pulumi.Input['LaunchGroupToWeightArgsDict']]]
        """
        An array of structures that define how much launch traffic to allocate to each launch group during this step of the launch.
        """
        start_time: pulumi.Input[builtins.str]
        """
        The date and time to start this step of the launch. Use UTC format, `yyyy-MM-ddTHH:mm:ssZ` . For example, `2025-11-25T23:59:59Z`
        """
        segment_overrides: NotRequired[pulumi.Input[Sequence[pulumi.Input['LaunchSegmentOverrideArgsDict']]]]
        """
        An array of structures that you can use to specify different traffic splits for one or more audience *segments* . A segment is a portion of your audience that share one or more characteristics. Examples could be Chrome browser users, users in Europe, or Firefox browser users in Europe who also fit other criteria that your application collects, such as age.

        For more information, see [Use segments to focus your audience](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html) .
        """
elif False:
    LaunchStepConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LaunchStepConfigArgs:
    def __init__(__self__, *,
                 group_weights: pulumi.Input[Sequence[pulumi.Input['LaunchGroupToWeightArgs']]],
                 start_time: pulumi.Input[builtins.str],
                 segment_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchSegmentOverrideArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['LaunchGroupToWeightArgs']]] group_weights: An array of structures that define how much launch traffic to allocate to each launch group during this step of the launch.
        :param pulumi.Input[builtins.str] start_time: The date and time to start this step of the launch. Use UTC format, `yyyy-MM-ddTHH:mm:ssZ` . For example, `2025-11-25T23:59:59Z`
        :param pulumi.Input[Sequence[pulumi.Input['LaunchSegmentOverrideArgs']]] segment_overrides: An array of structures that you can use to specify different traffic splits for one or more audience *segments* . A segment is a portion of your audience that share one or more characteristics. Examples could be Chrome browser users, users in Europe, or Firefox browser users in Europe who also fit other criteria that your application collects, such as age.
               
               For more information, see [Use segments to focus your audience](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html) .
        """
        pulumi.set(__self__, "group_weights", group_weights)
        pulumi.set(__self__, "start_time", start_time)
        if segment_overrides is not None:
            pulumi.set(__self__, "segment_overrides", segment_overrides)

    @property
    @pulumi.getter(name="groupWeights")
    def group_weights(self) -> pulumi.Input[Sequence[pulumi.Input['LaunchGroupToWeightArgs']]]:
        """
        An array of structures that define how much launch traffic to allocate to each launch group during this step of the launch.
        """
        return pulumi.get(self, "group_weights")

    @group_weights.setter
    def group_weights(self, value: pulumi.Input[Sequence[pulumi.Input['LaunchGroupToWeightArgs']]]):
        pulumi.set(self, "group_weights", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input[builtins.str]:
        """
        The date and time to start this step of the launch. Use UTC format, `yyyy-MM-ddTHH:mm:ssZ` . For example, `2025-11-25T23:59:59Z`
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="segmentOverrides")
    def segment_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LaunchSegmentOverrideArgs']]]]:
        """
        An array of structures that you can use to specify different traffic splits for one or more audience *segments* . A segment is a portion of your audience that share one or more characteristics. Examples could be Chrome browser users, users in Europe, or Firefox browser users in Europe who also fit other criteria that your application collects, such as age.

        For more information, see [Use segments to focus your audience](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html) .
        """
        return pulumi.get(self, "segment_overrides")

    @segment_overrides.setter
    def segment_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchSegmentOverrideArgs']]]]):
        pulumi.set(self, "segment_overrides", value)


if not MYPY:
    class ProjectAppConfigResourceObjectArgsDict(TypedDict):
        application_id: pulumi.Input[builtins.str]
        """
        The ID of the AWS AppConfig application to use for client-side evaluation.
        """
        environment_id: pulumi.Input[builtins.str]
        """
        The ID of the AWS AppConfig environment to use for client-side evaluation.
        """
elif False:
    ProjectAppConfigResourceObjectArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProjectAppConfigResourceObjectArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[builtins.str],
                 environment_id: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] application_id: The ID of the AWS AppConfig application to use for client-side evaluation.
        :param pulumi.Input[builtins.str] environment_id: The ID of the AWS AppConfig environment to use for client-side evaluation.
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "environment_id", environment_id)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the AWS AppConfig application to use for client-side evaluation.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "application_id", value)

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the AWS AppConfig environment to use for client-side evaluation.
        """
        return pulumi.get(self, "environment_id")

    @environment_id.setter
    def environment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "environment_id", value)


if not MYPY:
    class ProjectDataDeliveryObjectArgsDict(TypedDict):
        """
        Destinations for data.
        """
        log_group: NotRequired[pulumi.Input[builtins.str]]
        """
        If the project stores evaluation events in CloudWatch Logs , this structure stores the log group name.
        """
        s3: NotRequired[pulumi.Input['ProjectS3DestinationArgsDict']]
        """
        If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and bucket prefix.
        """
elif False:
    ProjectDataDeliveryObjectArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProjectDataDeliveryObjectArgs:
    def __init__(__self__, *,
                 log_group: Optional[pulumi.Input[builtins.str]] = None,
                 s3: Optional[pulumi.Input['ProjectS3DestinationArgs']] = None):
        """
        Destinations for data.
        :param pulumi.Input[builtins.str] log_group: If the project stores evaluation events in CloudWatch Logs , this structure stores the log group name.
        :param pulumi.Input['ProjectS3DestinationArgs'] s3: If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and bucket prefix.
        """
        if log_group is not None:
            pulumi.set(__self__, "log_group", log_group)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)

    @property
    @pulumi.getter(name="logGroup")
    def log_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If the project stores evaluation events in CloudWatch Logs , this structure stores the log group name.
        """
        return pulumi.get(self, "log_group")

    @log_group.setter
    def log_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_group", value)

    @property
    @pulumi.getter
    def s3(self) -> Optional[pulumi.Input['ProjectS3DestinationArgs']]:
        """
        If the project stores evaluation events in an Amazon S3 bucket, this structure stores the bucket name and bucket prefix.
        """
        return pulumi.get(self, "s3")

    @s3.setter
    def s3(self, value: Optional[pulumi.Input['ProjectS3DestinationArgs']]):
        pulumi.set(self, "s3", value)


if not MYPY:
    class ProjectS3DestinationArgsDict(TypedDict):
        bucket_name: pulumi.Input[builtins.str]
        """
        The name of the bucket in which Evidently stores evaluation events.
        """
        prefix: NotRequired[pulumi.Input[builtins.str]]
        """
        The bucket prefix in which Evidently stores evaluation events.
        """
elif False:
    ProjectS3DestinationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProjectS3DestinationArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[builtins.str],
                 prefix: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] bucket_name: The name of the bucket in which Evidently stores evaluation events.
        :param pulumi.Input[builtins.str] prefix: The bucket prefix in which Evidently stores evaluation events.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the bucket in which Evidently stores evaluation events.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The bucket prefix in which Evidently stores evaluation events.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prefix", value)


