# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRegistryPolicyResult',
    'AwaitableGetRegistryPolicyResult',
    'get_registry_policy',
    'get_registry_policy_output',
]

@pulumi.output_type
class GetRegistryPolicyResult:
    def __init__(__self__, id=None, policy=None, registry_name=None, revision_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if policy and not isinstance(policy, dict):
            raise TypeError("Expected argument 'policy' to be a dict")
        pulumi.set(__self__, "policy", policy)
        if registry_name and not isinstance(registry_name, str):
            raise TypeError("Expected argument 'registry_name' to be a str")
        pulumi.set(__self__, "registry_name", registry_name)
        if revision_id and not isinstance(revision_id, str):
            raise TypeError("Expected argument 'revision_id' to be a str")
        pulumi.set(__self__, "revision_id", revision_id)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the policy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def policy(self) -> Optional[Any]:
        """
        A resource-based policy.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::EventSchemas::RegistryPolicy` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="registryName")
    def registry_name(self) -> Optional[builtins.str]:
        """
        The name of the registry.
        """
        return pulumi.get(self, "registry_name")

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> Optional[builtins.str]:
        """
        The revision ID of the policy.
        """
        return pulumi.get(self, "revision_id")


class AwaitableGetRegistryPolicyResult(GetRegistryPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegistryPolicyResult(
            id=self.id,
            policy=self.policy,
            registry_name=self.registry_name,
            revision_id=self.revision_id)


def get_registry_policy(id: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegistryPolicyResult:
    """
    Resource Type definition for AWS::EventSchemas::RegistryPolicy


    :param builtins.str id: The ID of the policy.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:eventschemas:getRegistryPolicy', __args__, opts=opts, typ=GetRegistryPolicyResult).value

    return AwaitableGetRegistryPolicyResult(
        id=pulumi.get(__ret__, 'id'),
        policy=pulumi.get(__ret__, 'policy'),
        registry_name=pulumi.get(__ret__, 'registry_name'),
        revision_id=pulumi.get(__ret__, 'revision_id'))
def get_registry_policy_output(id: Optional[pulumi.Input[builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRegistryPolicyResult]:
    """
    Resource Type definition for AWS::EventSchemas::RegistryPolicy


    :param builtins.str id: The ID of the policy.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:eventschemas:getRegistryPolicy', __args__, opts=opts, typ=GetRegistryPolicyResult)
    return __ret__.apply(lambda __response__: GetRegistryPolicyResult(
        id=pulumi.get(__response__, 'id'),
        policy=pulumi.get(__response__, 'policy'),
        registry_name=pulumi.get(__response__, 'registry_name'),
        revision_id=pulumi.get(__response__, 'revision_id')))
