# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ConnectionApiKeyAuthParameters',
    'ConnectionAuthParameters',
    'ConnectionBasicAuthParameters',
    'ConnectionClientParameters',
    'ConnectionConnectivityParameters',
    'ConnectionHttpParameters',
    'ConnectionOAuthParameters',
    'ConnectionParameter',
    'ConnectionResourceParameters',
    'DeadLetterConfigProperties',
    'EndpointEventBus',
    'EndpointFailoverConfig',
    'EndpointPrimary',
    'EndpointReplicationConfig',
    'EndpointRoutingConfig',
    'EndpointSecondary',
    'InvocationConnectivityParametersProperties',
    'RuleAppSyncParameters',
    'RuleAwsVpcConfiguration',
    'RuleBatchArrayProperties',
    'RuleBatchParameters',
    'RuleBatchRetryStrategy',
    'RuleCapacityProviderStrategyItem',
    'RuleDeadLetterConfig',
    'RuleEcsParameters',
    'RuleHttpParameters',
    'RuleInputTransformer',
    'RuleKinesisParameters',
    'RuleNetworkConfiguration',
    'RulePlacementConstraint',
    'RulePlacementStrategy',
    'RuleRedshiftDataParameters',
    'RuleRetryPolicy',
    'RuleRunCommandParameters',
    'RuleRunCommandTarget',
    'RuleSageMakerPipelineParameter',
    'RuleSageMakerPipelineParameters',
    'RuleSqsParameters',
    'RuleTag',
    'RuleTarget',
]

@pulumi.output_type
class ConnectionApiKeyAuthParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKeyName":
            suggest = "api_key_name"
        elif key == "apiKeyValue":
            suggest = "api_key_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionApiKeyAuthParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionApiKeyAuthParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionApiKeyAuthParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key_name: builtins.str,
                 api_key_value: builtins.str):
        """
        :param builtins.str api_key_name: The name of the API key to use for authorization.
        :param builtins.str api_key_value: The value for the API key to use for authorization.
        """
        pulumi.set(__self__, "api_key_name", api_key_name)
        pulumi.set(__self__, "api_key_value", api_key_value)

    @property
    @pulumi.getter(name="apiKeyName")
    def api_key_name(self) -> builtins.str:
        """
        The name of the API key to use for authorization.
        """
        return pulumi.get(self, "api_key_name")

    @property
    @pulumi.getter(name="apiKeyValue")
    def api_key_value(self) -> builtins.str:
        """
        The value for the API key to use for authorization.
        """
        return pulumi.get(self, "api_key_value")


@pulumi.output_type
class ConnectionAuthParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKeyAuthParameters":
            suggest = "api_key_auth_parameters"
        elif key == "basicAuthParameters":
            suggest = "basic_auth_parameters"
        elif key == "connectivityParameters":
            suggest = "connectivity_parameters"
        elif key == "invocationHttpParameters":
            suggest = "invocation_http_parameters"
        elif key == "oAuthParameters":
            suggest = "o_auth_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key_auth_parameters: Optional['outputs.ConnectionApiKeyAuthParameters'] = None,
                 basic_auth_parameters: Optional['outputs.ConnectionBasicAuthParameters'] = None,
                 connectivity_parameters: Optional['outputs.ConnectionConnectivityParameters'] = None,
                 invocation_http_parameters: Optional['outputs.ConnectionHttpParameters'] = None,
                 o_auth_parameters: Optional['outputs.ConnectionOAuthParameters'] = None):
        """
        :param 'ConnectionApiKeyAuthParameters' api_key_auth_parameters: The API Key parameters to use for authorization.
        :param 'ConnectionBasicAuthParameters' basic_auth_parameters: The authorization parameters for Basic authorization.
        :param 'ConnectionConnectivityParameters' connectivity_parameters: For private OAuth authentication endpoints. The parameters EventBridge uses to authenticate against the endpoint.
               
               For more information, see [Authorization methods for connections](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-target-connection-auth.html) in the **Amazon EventBridge User Guide** .
        :param 'ConnectionHttpParameters' invocation_http_parameters: Additional parameters for the connection that are passed through with every invocation to the HTTP endpoint.
        :param 'ConnectionOAuthParameters' o_auth_parameters: The OAuth parameters to use for authorization.
        """
        if api_key_auth_parameters is not None:
            pulumi.set(__self__, "api_key_auth_parameters", api_key_auth_parameters)
        if basic_auth_parameters is not None:
            pulumi.set(__self__, "basic_auth_parameters", basic_auth_parameters)
        if connectivity_parameters is not None:
            pulumi.set(__self__, "connectivity_parameters", connectivity_parameters)
        if invocation_http_parameters is not None:
            pulumi.set(__self__, "invocation_http_parameters", invocation_http_parameters)
        if o_auth_parameters is not None:
            pulumi.set(__self__, "o_auth_parameters", o_auth_parameters)

    @property
    @pulumi.getter(name="apiKeyAuthParameters")
    def api_key_auth_parameters(self) -> Optional['outputs.ConnectionApiKeyAuthParameters']:
        """
        The API Key parameters to use for authorization.
        """
        return pulumi.get(self, "api_key_auth_parameters")

    @property
    @pulumi.getter(name="basicAuthParameters")
    def basic_auth_parameters(self) -> Optional['outputs.ConnectionBasicAuthParameters']:
        """
        The authorization parameters for Basic authorization.
        """
        return pulumi.get(self, "basic_auth_parameters")

    @property
    @pulumi.getter(name="connectivityParameters")
    def connectivity_parameters(self) -> Optional['outputs.ConnectionConnectivityParameters']:
        """
        For private OAuth authentication endpoints. The parameters EventBridge uses to authenticate against the endpoint.

        For more information, see [Authorization methods for connections](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-target-connection-auth.html) in the **Amazon EventBridge User Guide** .
        """
        return pulumi.get(self, "connectivity_parameters")

    @property
    @pulumi.getter(name="invocationHttpParameters")
    def invocation_http_parameters(self) -> Optional['outputs.ConnectionHttpParameters']:
        """
        Additional parameters for the connection that are passed through with every invocation to the HTTP endpoint.
        """
        return pulumi.get(self, "invocation_http_parameters")

    @property
    @pulumi.getter(name="oAuthParameters")
    def o_auth_parameters(self) -> Optional['outputs.ConnectionOAuthParameters']:
        """
        The OAuth parameters to use for authorization.
        """
        return pulumi.get(self, "o_auth_parameters")


@pulumi.output_type
class ConnectionBasicAuthParameters(dict):
    def __init__(__self__, *,
                 password: builtins.str,
                 username: builtins.str):
        """
        :param builtins.str password: The password associated with the user name to use for Basic authorization.
        :param builtins.str username: The user name to use for Basic authorization.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> builtins.str:
        """
        The password associated with the user name to use for Basic authorization.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        """
        The user name to use for Basic authorization.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ConnectionClientParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionClientParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionClientParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionClientParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: builtins.str,
                 client_secret: builtins.str):
        """
        :param builtins.str client_id: The client ID to use for OAuth authorization.
        :param builtins.str client_secret: The client secret assciated with the client ID to use for OAuth authorization.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> builtins.str:
        """
        The client ID to use for OAuth authorization.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> builtins.str:
        """
        The client secret assciated with the client ID to use for OAuth authorization.
        """
        return pulumi.get(self, "client_secret")


@pulumi.output_type
class ConnectionConnectivityParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceParameters":
            suggest = "resource_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionConnectivityParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionConnectivityParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionConnectivityParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_parameters: 'outputs.ConnectionResourceParameters'):
        """
        :param 'ConnectionResourceParameters' resource_parameters: The parameters for EventBridge to use when invoking the resource endpoint.
        """
        pulumi.set(__self__, "resource_parameters", resource_parameters)

    @property
    @pulumi.getter(name="resourceParameters")
    def resource_parameters(self) -> 'outputs.ConnectionResourceParameters':
        """
        The parameters for EventBridge to use when invoking the resource endpoint.
        """
        return pulumi.get(self, "resource_parameters")


@pulumi.output_type
class ConnectionHttpParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bodyParameters":
            suggest = "body_parameters"
        elif key == "headerParameters":
            suggest = "header_parameters"
        elif key == "queryStringParameters":
            suggest = "query_string_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionHttpParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionHttpParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionHttpParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 body_parameters: Optional[Sequence['outputs.ConnectionParameter']] = None,
                 header_parameters: Optional[Sequence['outputs.ConnectionParameter']] = None,
                 query_string_parameters: Optional[Sequence['outputs.ConnectionParameter']] = None):
        """
        :param Sequence['ConnectionParameter'] body_parameters: Any additional body string parameters for the connection.
        :param Sequence['ConnectionParameter'] header_parameters: Any additional header parameters for the connection.
        :param Sequence['ConnectionParameter'] query_string_parameters: Any additional query string parameters for the connection.
        """
        if body_parameters is not None:
            pulumi.set(__self__, "body_parameters", body_parameters)
        if header_parameters is not None:
            pulumi.set(__self__, "header_parameters", header_parameters)
        if query_string_parameters is not None:
            pulumi.set(__self__, "query_string_parameters", query_string_parameters)

    @property
    @pulumi.getter(name="bodyParameters")
    def body_parameters(self) -> Optional[Sequence['outputs.ConnectionParameter']]:
        """
        Any additional body string parameters for the connection.
        """
        return pulumi.get(self, "body_parameters")

    @property
    @pulumi.getter(name="headerParameters")
    def header_parameters(self) -> Optional[Sequence['outputs.ConnectionParameter']]:
        """
        Any additional header parameters for the connection.
        """
        return pulumi.get(self, "header_parameters")

    @property
    @pulumi.getter(name="queryStringParameters")
    def query_string_parameters(self) -> Optional[Sequence['outputs.ConnectionParameter']]:
        """
        Any additional query string parameters for the connection.
        """
        return pulumi.get(self, "query_string_parameters")


@pulumi.output_type
class ConnectionOAuthParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationEndpoint":
            suggest = "authorization_endpoint"
        elif key == "clientParameters":
            suggest = "client_parameters"
        elif key == "httpMethod":
            suggest = "http_method"
        elif key == "oAuthHttpParameters":
            suggest = "o_auth_http_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionOAuthParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionOAuthParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionOAuthParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_endpoint: builtins.str,
                 client_parameters: 'outputs.ConnectionClientParameters',
                 http_method: 'ConnectionOAuthParametersHttpMethod',
                 o_auth_http_parameters: Optional['outputs.ConnectionHttpParameters'] = None):
        """
        :param builtins.str authorization_endpoint: The URL to the authorization endpoint when OAuth is specified as the authorization type.
        :param 'ConnectionClientParameters' client_parameters: The client parameters for OAuth authorization.
        :param 'ConnectionOAuthParametersHttpMethod' http_method: The method to use for the authorization request.
        :param 'ConnectionHttpParameters' o_auth_http_parameters: Details about the additional parameters to use for the connection.
        """
        pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        pulumi.set(__self__, "client_parameters", client_parameters)
        pulumi.set(__self__, "http_method", http_method)
        if o_auth_http_parameters is not None:
            pulumi.set(__self__, "o_auth_http_parameters", o_auth_http_parameters)

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> builtins.str:
        """
        The URL to the authorization endpoint when OAuth is specified as the authorization type.
        """
        return pulumi.get(self, "authorization_endpoint")

    @property
    @pulumi.getter(name="clientParameters")
    def client_parameters(self) -> 'outputs.ConnectionClientParameters':
        """
        The client parameters for OAuth authorization.
        """
        return pulumi.get(self, "client_parameters")

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> 'ConnectionOAuthParametersHttpMethod':
        """
        The method to use for the authorization request.
        """
        return pulumi.get(self, "http_method")

    @property
    @pulumi.getter(name="oAuthHttpParameters")
    def o_auth_http_parameters(self) -> Optional['outputs.ConnectionHttpParameters']:
        """
        Details about the additional parameters to use for the connection.
        """
        return pulumi.get(self, "o_auth_http_parameters")


@pulumi.output_type
class ConnectionParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isValueSecret":
            suggest = "is_value_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str,
                 is_value_secret: Optional[builtins.bool] = None):
        """
        :param builtins.str key: The key for a query string parameter.
        :param builtins.str value: The value associated with the key for the query string parameter.
        :param builtins.bool is_value_secret: Specifies whether the value is secret.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)
        if is_value_secret is not None:
            pulumi.set(__self__, "is_value_secret", is_value_secret)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key for a query string parameter.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value associated with the key for the query string parameter.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="isValueSecret")
    def is_value_secret(self) -> Optional[builtins.bool]:
        """
        Specifies whether the value is secret.
        """
        return pulumi.get(self, "is_value_secret")


@pulumi.output_type
class ConnectionResourceParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceConfigurationArn":
            suggest = "resource_configuration_arn"
        elif key == "resourceAssociationArn":
            suggest = "resource_association_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionResourceParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionResourceParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionResourceParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_configuration_arn: builtins.str,
                 resource_association_arn: Optional[builtins.str] = None):
        """
        :param builtins.str resource_configuration_arn: The Amazon Resource Name (ARN) of the Amazon VPC Lattice resource configuration for the resource endpoint.
        :param builtins.str resource_association_arn: For connections to private APIs, the Amazon Resource Name (ARN) of the resource association EventBridge created between the connection and the private API's resource configuration.
               
               > The value of this property is set by EventBridge . Any value you specify in your template is ignored.
        """
        pulumi.set(__self__, "resource_configuration_arn", resource_configuration_arn)
        if resource_association_arn is not None:
            pulumi.set(__self__, "resource_association_arn", resource_association_arn)

    @property
    @pulumi.getter(name="resourceConfigurationArn")
    def resource_configuration_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the Amazon VPC Lattice resource configuration for the resource endpoint.
        """
        return pulumi.get(self, "resource_configuration_arn")

    @property
    @pulumi.getter(name="resourceAssociationArn")
    def resource_association_arn(self) -> Optional[builtins.str]:
        """
        For connections to private APIs, the Amazon Resource Name (ARN) of the resource association EventBridge created between the connection and the private API's resource configuration.

        > The value of this property is set by EventBridge . Any value you specify in your template is ignored.
        """
        return pulumi.get(self, "resource_association_arn")


@pulumi.output_type
class DeadLetterConfigProperties(dict):
    """
    Dead Letter Queue for the event bus.
    """
    def __init__(__self__, *,
                 arn: Optional[builtins.str] = None):
        """
        Dead Letter Queue for the event bus.
        :param builtins.str arn: The ARN of the SQS queue specified as the target for the dead-letter queue.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The ARN of the SQS queue specified as the target for the dead-letter queue.
        """
        return pulumi.get(self, "arn")


@pulumi.output_type
class EndpointEventBus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventBusArn":
            suggest = "event_bus_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointEventBus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointEventBus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointEventBus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_bus_arn: builtins.str):
        pulumi.set(__self__, "event_bus_arn", event_bus_arn)

    @property
    @pulumi.getter(name="eventBusArn")
    def event_bus_arn(self) -> builtins.str:
        return pulumi.get(self, "event_bus_arn")


@pulumi.output_type
class EndpointFailoverConfig(dict):
    def __init__(__self__, *,
                 primary: 'outputs.EndpointPrimary',
                 secondary: 'outputs.EndpointSecondary'):
        """
        :param 'EndpointPrimary' primary: The main Region of the endpoint.
        :param 'EndpointSecondary' secondary: The Region that events are routed to when failover is triggered or event replication is enabled.
        """
        pulumi.set(__self__, "primary", primary)
        pulumi.set(__self__, "secondary", secondary)

    @property
    @pulumi.getter
    def primary(self) -> 'outputs.EndpointPrimary':
        """
        The main Region of the endpoint.
        """
        return pulumi.get(self, "primary")

    @property
    @pulumi.getter
    def secondary(self) -> 'outputs.EndpointSecondary':
        """
        The Region that events are routed to when failover is triggered or event replication is enabled.
        """
        return pulumi.get(self, "secondary")


@pulumi.output_type
class EndpointPrimary(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthCheck":
            suggest = "health_check"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointPrimary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointPrimary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointPrimary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health_check: builtins.str):
        """
        :param builtins.str health_check: The ARN of the health check used by the endpoint to determine whether failover is triggered.
        """
        pulumi.set(__self__, "health_check", health_check)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> builtins.str:
        """
        The ARN of the health check used by the endpoint to determine whether failover is triggered.
        """
        return pulumi.get(self, "health_check")


@pulumi.output_type
class EndpointReplicationConfig(dict):
    def __init__(__self__, *,
                 state: 'EndpointReplicationState'):
        """
        :param 'EndpointReplicationState' state: The state of event replication.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> 'EndpointReplicationState':
        """
        The state of event replication.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class EndpointRoutingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failoverConfig":
            suggest = "failover_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointRoutingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointRoutingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointRoutingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failover_config: 'outputs.EndpointFailoverConfig'):
        """
        :param 'EndpointFailoverConfig' failover_config: The failover configuration for an endpoint. This includes what triggers failover and what happens when it's triggered.
        """
        pulumi.set(__self__, "failover_config", failover_config)

    @property
    @pulumi.getter(name="failoverConfig")
    def failover_config(self) -> 'outputs.EndpointFailoverConfig':
        """
        The failover configuration for an endpoint. This includes what triggers failover and what happens when it's triggered.
        """
        return pulumi.get(self, "failover_config")


@pulumi.output_type
class EndpointSecondary(dict):
    def __init__(__self__, *,
                 route: builtins.str):
        """
        :param builtins.str route: Defines the secondary Region.
        """
        pulumi.set(__self__, "route", route)

    @property
    @pulumi.getter
    def route(self) -> builtins.str:
        """
        Defines the secondary Region.
        """
        return pulumi.get(self, "route")


@pulumi.output_type
class InvocationConnectivityParametersProperties(dict):
    """
    The private resource the HTTP request will be sent to.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceParameters":
            suggest = "resource_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InvocationConnectivityParametersProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InvocationConnectivityParametersProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InvocationConnectivityParametersProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_parameters: 'outputs.ConnectionResourceParameters'):
        """
        The private resource the HTTP request will be sent to.
        :param 'ConnectionResourceParameters' resource_parameters: The parameters for EventBridge to use when invoking the resource endpoint.
        """
        pulumi.set(__self__, "resource_parameters", resource_parameters)

    @property
    @pulumi.getter(name="resourceParameters")
    def resource_parameters(self) -> 'outputs.ConnectionResourceParameters':
        """
        The parameters for EventBridge to use when invoking the resource endpoint.
        """
        return pulumi.get(self, "resource_parameters")


@pulumi.output_type
class RuleAppSyncParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "graphQlOperation":
            suggest = "graph_ql_operation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleAppSyncParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleAppSyncParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleAppSyncParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 graph_ql_operation: builtins.str):
        """
        :param builtins.str graph_ql_operation: The GraphQL operation; that is, the query, mutation, or subscription to be parsed and executed by the GraphQL service.
               
               For more information, see [Operations](https://docs.aws.amazon.com/appsync/latest/devguide/graphql-architecture.html#graphql-operations) in the *AWS AppSync User Guide* .
        """
        pulumi.set(__self__, "graph_ql_operation", graph_ql_operation)

    @property
    @pulumi.getter(name="graphQlOperation")
    def graph_ql_operation(self) -> builtins.str:
        """
        The GraphQL operation; that is, the query, mutation, or subscription to be parsed and executed by the GraphQL service.

        For more information, see [Operations](https://docs.aws.amazon.com/appsync/latest/devguide/graphql-architecture.html#graphql-operations) in the *AWS AppSync User Guide* .
        """
        return pulumi.get(self, "graph_ql_operation")


@pulumi.output_type
class RuleAwsVpcConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignPublicIp":
            suggest = "assign_public_ip"
        elif key == "securityGroups":
            suggest = "security_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleAwsVpcConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleAwsVpcConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleAwsVpcConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnets: Sequence[builtins.str],
                 assign_public_ip: Optional[builtins.str] = None,
                 security_groups: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] subnets: Specifies the subnets associated with the task. These subnets must all be in the same VPC. You can specify as many as 16 subnets.
        :param builtins.str assign_public_ip: Specifies whether the task's elastic network interface receives a public IP address. You can specify `ENABLED` only when `LaunchType` in `EcsParameters` is set to `FARGATE` .
        :param Sequence[builtins.str] security_groups: Specifies the security groups associated with the task. These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
        """
        pulumi.set(__self__, "subnets", subnets)
        if assign_public_ip is not None:
            pulumi.set(__self__, "assign_public_ip", assign_public_ip)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[builtins.str]:
        """
        Specifies the subnets associated with the task. These subnets must all be in the same VPC. You can specify as many as 16 subnets.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter(name="assignPublicIp")
    def assign_public_ip(self) -> Optional[builtins.str]:
        """
        Specifies whether the task's elastic network interface receives a public IP address. You can specify `ENABLED` only when `LaunchType` in `EcsParameters` is set to `FARGATE` .
        """
        return pulumi.get(self, "assign_public_ip")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies the security groups associated with the task. These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
        """
        return pulumi.get(self, "security_groups")


@pulumi.output_type
class RuleBatchArrayProperties(dict):
    def __init__(__self__, *,
                 size: Optional[builtins.int] = None):
        """
        :param builtins.int size: The size of the array, if this is an array batch job. Valid values are integers between 2 and 10,000.
        """
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def size(self) -> Optional[builtins.int]:
        """
        The size of the array, if this is an array batch job. Valid values are integers between 2 and 10,000.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class RuleBatchParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobDefinition":
            suggest = "job_definition"
        elif key == "jobName":
            suggest = "job_name"
        elif key == "arrayProperties":
            suggest = "array_properties"
        elif key == "retryStrategy":
            suggest = "retry_strategy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleBatchParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleBatchParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleBatchParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_definition: builtins.str,
                 job_name: builtins.str,
                 array_properties: Optional['outputs.RuleBatchArrayProperties'] = None,
                 retry_strategy: Optional['outputs.RuleBatchRetryStrategy'] = None):
        """
        :param builtins.str job_definition: The ARN or name of the job definition to use if the event target is an AWS Batch job. This job definition must already exist.
        :param builtins.str job_name: The name to use for this execution of the job, if the target is an AWS Batch job.
        :param 'RuleBatchArrayProperties' array_properties: The array properties for the submitted job, such as the size of the array. The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target is an AWS Batch job.
        :param 'RuleBatchRetryStrategy' retry_strategy: The retry strategy to use for failed jobs, if the target is an AWS Batch job. The retry strategy is the number of times to retry the failed job execution. Valid values are 1–10. When you specify a retry strategy here, it overrides the retry strategy defined in the job definition.
        """
        pulumi.set(__self__, "job_definition", job_definition)
        pulumi.set(__self__, "job_name", job_name)
        if array_properties is not None:
            pulumi.set(__self__, "array_properties", array_properties)
        if retry_strategy is not None:
            pulumi.set(__self__, "retry_strategy", retry_strategy)

    @property
    @pulumi.getter(name="jobDefinition")
    def job_definition(self) -> builtins.str:
        """
        The ARN or name of the job definition to use if the event target is an AWS Batch job. This job definition must already exist.
        """
        return pulumi.get(self, "job_definition")

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> builtins.str:
        """
        The name to use for this execution of the job, if the target is an AWS Batch job.
        """
        return pulumi.get(self, "job_name")

    @property
    @pulumi.getter(name="arrayProperties")
    def array_properties(self) -> Optional['outputs.RuleBatchArrayProperties']:
        """
        The array properties for the submitted job, such as the size of the array. The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target is an AWS Batch job.
        """
        return pulumi.get(self, "array_properties")

    @property
    @pulumi.getter(name="retryStrategy")
    def retry_strategy(self) -> Optional['outputs.RuleBatchRetryStrategy']:
        """
        The retry strategy to use for failed jobs, if the target is an AWS Batch job. The retry strategy is the number of times to retry the failed job execution. Valid values are 1–10. When you specify a retry strategy here, it overrides the retry strategy defined in the job definition.
        """
        return pulumi.get(self, "retry_strategy")


@pulumi.output_type
class RuleBatchRetryStrategy(dict):
    def __init__(__self__, *,
                 attempts: Optional[builtins.int] = None):
        """
        :param builtins.int attempts: The number of times to attempt to retry, if the job fails. Valid values are 1–10.
        """
        if attempts is not None:
            pulumi.set(__self__, "attempts", attempts)

    @property
    @pulumi.getter
    def attempts(self) -> Optional[builtins.int]:
        """
        The number of times to attempt to retry, if the job fails. Valid values are 1–10.
        """
        return pulumi.get(self, "attempts")


@pulumi.output_type
class RuleCapacityProviderStrategyItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityProvider":
            suggest = "capacity_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleCapacityProviderStrategyItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleCapacityProviderStrategyItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleCapacityProviderStrategyItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_provider: builtins.str,
                 base: Optional[builtins.int] = None,
                 weight: Optional[builtins.int] = None):
        """
        :param builtins.str capacity_provider: The short name of the capacity provider.
        :param builtins.int base: The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. If no value is specified, the default value of 0 is used.
        :param builtins.int weight: The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied.
        """
        pulumi.set(__self__, "capacity_provider", capacity_provider)
        if base is not None:
            pulumi.set(__self__, "base", base)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="capacityProvider")
    def capacity_provider(self) -> builtins.str:
        """
        The short name of the capacity provider.
        """
        return pulumi.get(self, "capacity_provider")

    @property
    @pulumi.getter
    def base(self) -> Optional[builtins.int]:
        """
        The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. If no value is specified, the default value of 0 is used.
        """
        return pulumi.get(self, "base")

    @property
    @pulumi.getter
    def weight(self) -> Optional[builtins.int]:
        """
        The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class RuleDeadLetterConfig(dict):
    def __init__(__self__, *,
                 arn: Optional[builtins.str] = None):
        """
        :param builtins.str arn: The ARN of the SQS queue specified as the target for the dead-letter queue.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The ARN of the SQS queue specified as the target for the dead-letter queue.
        """
        return pulumi.get(self, "arn")


@pulumi.output_type
class RuleEcsParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskDefinitionArn":
            suggest = "task_definition_arn"
        elif key == "capacityProviderStrategy":
            suggest = "capacity_provider_strategy"
        elif key == "enableEcsManagedTags":
            suggest = "enable_ecs_managed_tags"
        elif key == "enableExecuteCommand":
            suggest = "enable_execute_command"
        elif key == "launchType":
            suggest = "launch_type"
        elif key == "networkConfiguration":
            suggest = "network_configuration"
        elif key == "placementConstraints":
            suggest = "placement_constraints"
        elif key == "placementStrategies":
            suggest = "placement_strategies"
        elif key == "platformVersion":
            suggest = "platform_version"
        elif key == "propagateTags":
            suggest = "propagate_tags"
        elif key == "referenceId":
            suggest = "reference_id"
        elif key == "tagList":
            suggest = "tag_list"
        elif key == "taskCount":
            suggest = "task_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleEcsParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleEcsParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleEcsParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 task_definition_arn: builtins.str,
                 capacity_provider_strategy: Optional[Sequence['outputs.RuleCapacityProviderStrategyItem']] = None,
                 enable_ecs_managed_tags: Optional[builtins.bool] = None,
                 enable_execute_command: Optional[builtins.bool] = None,
                 group: Optional[builtins.str] = None,
                 launch_type: Optional[builtins.str] = None,
                 network_configuration: Optional['outputs.RuleNetworkConfiguration'] = None,
                 placement_constraints: Optional[Sequence['outputs.RulePlacementConstraint']] = None,
                 placement_strategies: Optional[Sequence['outputs.RulePlacementStrategy']] = None,
                 platform_version: Optional[builtins.str] = None,
                 propagate_tags: Optional[builtins.str] = None,
                 reference_id: Optional[builtins.str] = None,
                 tag_list: Optional[Sequence['outputs.RuleTag']] = None,
                 task_count: Optional[builtins.int] = None):
        """
        :param builtins.str task_definition_arn: The ARN of the task definition to use if the event target is an Amazon ECS task.
        :param Sequence['RuleCapacityProviderStrategyItem'] capacity_provider_strategy: The capacity provider strategy to use for the task.
               
               If a `capacityProviderStrategy` is specified, the `launchType` parameter must be omitted. If no `capacityProviderStrategy` or launchType is specified, the `defaultCapacityProviderStrategy` for the cluster is used.
        :param builtins.bool enable_ecs_managed_tags: Specifies whether to enable Amazon ECS managed tags for the task. For more information, see [Tagging Your Amazon ECS Resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html) in the Amazon Elastic Container Service Developer Guide.
        :param builtins.bool enable_execute_command: Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task.
        :param builtins.str group: Specifies an ECS task group for the task. The maximum length is 255 characters.
        :param builtins.str launch_type: Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. The `FARGATE` value is supported only in the Regions where AWS Fargate with Amazon ECS is supported. For more information, see [AWS Fargate on Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS-Fargate.html) in the *Amazon Elastic Container Service Developer Guide* .
        :param 'RuleNetworkConfiguration' network_configuration: Use this structure if the Amazon ECS task uses the `awsvpc` network mode. This structure specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. This structure is required if `LaunchType` is `FARGATE` because the `awsvpc` mode is required for Fargate tasks.
               
               If you specify `NetworkConfiguration` when the target ECS task does not use the `awsvpc` network mode, the task fails.
        :param Sequence['RulePlacementConstraint'] placement_constraints: An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime).
        :param Sequence['RulePlacementStrategy'] placement_strategies: The placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task.
        :param builtins.str platform_version: Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as `1.1.0` .
               
               This structure is used only if `LaunchType` is `FARGATE` . For more information about valid platform versions, see [AWS Fargate Platform Versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html) in the *Amazon Elastic Container Service Developer Guide* .
        :param builtins.str propagate_tags: Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the TagResource API action.
        :param builtins.str reference_id: The reference ID to use for the task.
        :param Sequence['RuleTag'] tag_list: The metadata that you apply to the task to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. To learn more, see [RunTask](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html#ECS-RunTask-request-tags) in the Amazon ECS API Reference.
        :param builtins.int task_count: The number of tasks to create based on `TaskDefinition` . The default is 1.
        """
        pulumi.set(__self__, "task_definition_arn", task_definition_arn)
        if capacity_provider_strategy is not None:
            pulumi.set(__self__, "capacity_provider_strategy", capacity_provider_strategy)
        if enable_ecs_managed_tags is not None:
            pulumi.set(__self__, "enable_ecs_managed_tags", enable_ecs_managed_tags)
        if enable_execute_command is not None:
            pulumi.set(__self__, "enable_execute_command", enable_execute_command)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if launch_type is not None:
            pulumi.set(__self__, "launch_type", launch_type)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if placement_constraints is not None:
            pulumi.set(__self__, "placement_constraints", placement_constraints)
        if placement_strategies is not None:
            pulumi.set(__self__, "placement_strategies", placement_strategies)
        if platform_version is not None:
            pulumi.set(__self__, "platform_version", platform_version)
        if propagate_tags is not None:
            pulumi.set(__self__, "propagate_tags", propagate_tags)
        if reference_id is not None:
            pulumi.set(__self__, "reference_id", reference_id)
        if tag_list is not None:
            pulumi.set(__self__, "tag_list", tag_list)
        if task_count is not None:
            pulumi.set(__self__, "task_count", task_count)

    @property
    @pulumi.getter(name="taskDefinitionArn")
    def task_definition_arn(self) -> builtins.str:
        """
        The ARN of the task definition to use if the event target is an Amazon ECS task.
        """
        return pulumi.get(self, "task_definition_arn")

    @property
    @pulumi.getter(name="capacityProviderStrategy")
    def capacity_provider_strategy(self) -> Optional[Sequence['outputs.RuleCapacityProviderStrategyItem']]:
        """
        The capacity provider strategy to use for the task.

        If a `capacityProviderStrategy` is specified, the `launchType` parameter must be omitted. If no `capacityProviderStrategy` or launchType is specified, the `defaultCapacityProviderStrategy` for the cluster is used.
        """
        return pulumi.get(self, "capacity_provider_strategy")

    @property
    @pulumi.getter(name="enableEcsManagedTags")
    def enable_ecs_managed_tags(self) -> Optional[builtins.bool]:
        """
        Specifies whether to enable Amazon ECS managed tags for the task. For more information, see [Tagging Your Amazon ECS Resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html) in the Amazon Elastic Container Service Developer Guide.
        """
        return pulumi.get(self, "enable_ecs_managed_tags")

    @property
    @pulumi.getter(name="enableExecuteCommand")
    def enable_execute_command(self) -> Optional[builtins.bool]:
        """
        Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task.
        """
        return pulumi.get(self, "enable_execute_command")

    @property
    @pulumi.getter
    def group(self) -> Optional[builtins.str]:
        """
        Specifies an ECS task group for the task. The maximum length is 255 characters.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter(name="launchType")
    def launch_type(self) -> Optional[builtins.str]:
        """
        Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. The `FARGATE` value is supported only in the Regions where AWS Fargate with Amazon ECS is supported. For more information, see [AWS Fargate on Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS-Fargate.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        return pulumi.get(self, "launch_type")

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional['outputs.RuleNetworkConfiguration']:
        """
        Use this structure if the Amazon ECS task uses the `awsvpc` network mode. This structure specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. This structure is required if `LaunchType` is `FARGATE` because the `awsvpc` mode is required for Fargate tasks.

        If you specify `NetworkConfiguration` when the target ECS task does not use the `awsvpc` network mode, the task fails.
        """
        return pulumi.get(self, "network_configuration")

    @property
    @pulumi.getter(name="placementConstraints")
    def placement_constraints(self) -> Optional[Sequence['outputs.RulePlacementConstraint']]:
        """
        An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime).
        """
        return pulumi.get(self, "placement_constraints")

    @property
    @pulumi.getter(name="placementStrategies")
    def placement_strategies(self) -> Optional[Sequence['outputs.RulePlacementStrategy']]:
        """
        The placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task.
        """
        return pulumi.get(self, "placement_strategies")

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> Optional[builtins.str]:
        """
        Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as `1.1.0` .

        This structure is used only if `LaunchType` is `FARGATE` . For more information about valid platform versions, see [AWS Fargate Platform Versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        return pulumi.get(self, "platform_version")

    @property
    @pulumi.getter(name="propagateTags")
    def propagate_tags(self) -> Optional[builtins.str]:
        """
        Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the TagResource API action.
        """
        return pulumi.get(self, "propagate_tags")

    @property
    @pulumi.getter(name="referenceId")
    def reference_id(self) -> Optional[builtins.str]:
        """
        The reference ID to use for the task.
        """
        return pulumi.get(self, "reference_id")

    @property
    @pulumi.getter(name="tagList")
    def tag_list(self) -> Optional[Sequence['outputs.RuleTag']]:
        """
        The metadata that you apply to the task to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. To learn more, see [RunTask](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html#ECS-RunTask-request-tags) in the Amazon ECS API Reference.
        """
        return pulumi.get(self, "tag_list")

    @property
    @pulumi.getter(name="taskCount")
    def task_count(self) -> Optional[builtins.int]:
        """
        The number of tasks to create based on `TaskDefinition` . The default is 1.
        """
        return pulumi.get(self, "task_count")


@pulumi.output_type
class RuleHttpParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerParameters":
            suggest = "header_parameters"
        elif key == "pathParameterValues":
            suggest = "path_parameter_values"
        elif key == "queryStringParameters":
            suggest = "query_string_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleHttpParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleHttpParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleHttpParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_parameters: Optional[Mapping[str, builtins.str]] = None,
                 path_parameter_values: Optional[Sequence[builtins.str]] = None,
                 query_string_parameters: Optional[Mapping[str, builtins.str]] = None):
        """
        :param Mapping[str, builtins.str] header_parameters: The headers that need to be sent as part of request invoking the API Gateway API or EventBridge ApiDestination.
        :param Sequence[builtins.str] path_parameter_values: The path parameter values to be used to populate API Gateway API or EventBridge ApiDestination path wildcards ("*").
        :param Mapping[str, builtins.str] query_string_parameters: The query string keys/values that need to be sent as part of request invoking the API Gateway API or EventBridge ApiDestination.
        """
        if header_parameters is not None:
            pulumi.set(__self__, "header_parameters", header_parameters)
        if path_parameter_values is not None:
            pulumi.set(__self__, "path_parameter_values", path_parameter_values)
        if query_string_parameters is not None:
            pulumi.set(__self__, "query_string_parameters", query_string_parameters)

    @property
    @pulumi.getter(name="headerParameters")
    def header_parameters(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The headers that need to be sent as part of request invoking the API Gateway API or EventBridge ApiDestination.
        """
        return pulumi.get(self, "header_parameters")

    @property
    @pulumi.getter(name="pathParameterValues")
    def path_parameter_values(self) -> Optional[Sequence[builtins.str]]:
        """
        The path parameter values to be used to populate API Gateway API or EventBridge ApiDestination path wildcards ("*").
        """
        return pulumi.get(self, "path_parameter_values")

    @property
    @pulumi.getter(name="queryStringParameters")
    def query_string_parameters(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The query string keys/values that need to be sent as part of request invoking the API Gateway API or EventBridge ApiDestination.
        """
        return pulumi.get(self, "query_string_parameters")


@pulumi.output_type
class RuleInputTransformer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputTemplate":
            suggest = "input_template"
        elif key == "inputPathsMap":
            suggest = "input_paths_map"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleInputTransformer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleInputTransformer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleInputTransformer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_template: builtins.str,
                 input_paths_map: Optional[Mapping[str, builtins.str]] = None):
        """
        :param builtins.str input_template: Input template where you specify placeholders that will be filled with the values of the keys from `InputPathsMap` to customize the data sent to the target. Enclose each `InputPathsMaps` value in brackets: < *value* >
               
               If `InputTemplate` is a JSON object (surrounded by curly braces), the following restrictions apply:
               
               - The placeholder cannot be used as an object key.
               
               The following example shows the syntax for using `InputPathsMap` and `InputTemplate` .
               
               `"InputTransformer":`
               
               `{`
               
               `"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},`
               
               `"InputTemplate": "<instance> is in state <status>"`
               
               `}`
               
               To have the `InputTemplate` include quote marks within a JSON string, escape each quote marks with a slash, as in the following example:
               
               `"InputTransformer":`
               
               `{`
               
               `"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},`
               
               `"InputTemplate": "<instance> is in state \\"<status>\\""`
               
               `}`
               
               The `InputTemplate` can also be valid JSON with varibles in quotes or out, as in the following example:
               
               `"InputTransformer":`
               
               `{`
               
               `"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},`
               
               `"InputTemplate": '{"myInstance": <instance>,"myStatus": "<instance> is in state \\"<status>\\""}'`
               
               `}`
        :param Mapping[str, builtins.str] input_paths_map: Map of JSON paths to be extracted from the event. You can then insert these in the template in `InputTemplate` to produce the output you want to be sent to the target.
               
               `InputPathsMap` is an array key-value pairs, where each value is a valid JSON path. You can have as many as 100 key-value pairs. You must use JSON dot notation, not bracket notation.
               
               The keys cannot start with " AWS ."
        """
        pulumi.set(__self__, "input_template", input_template)
        if input_paths_map is not None:
            pulumi.set(__self__, "input_paths_map", input_paths_map)

    @property
    @pulumi.getter(name="inputTemplate")
    def input_template(self) -> builtins.str:
        """
        Input template where you specify placeholders that will be filled with the values of the keys from `InputPathsMap` to customize the data sent to the target. Enclose each `InputPathsMaps` value in brackets: < *value* >

        If `InputTemplate` is a JSON object (surrounded by curly braces), the following restrictions apply:

        - The placeholder cannot be used as an object key.

        The following example shows the syntax for using `InputPathsMap` and `InputTemplate` .

        `"InputTransformer":`

        `{`

        `"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},`

        `"InputTemplate": "<instance> is in state <status>"`

        `}`

        To have the `InputTemplate` include quote marks within a JSON string, escape each quote marks with a slash, as in the following example:

        `"InputTransformer":`

        `{`

        `"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},`

        `"InputTemplate": "<instance> is in state \\"<status>\\""`

        `}`

        The `InputTemplate` can also be valid JSON with varibles in quotes or out, as in the following example:

        `"InputTransformer":`

        `{`

        `"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},`

        `"InputTemplate": '{"myInstance": <instance>,"myStatus": "<instance> is in state \\"<status>\\""}'`

        `}`
        """
        return pulumi.get(self, "input_template")

    @property
    @pulumi.getter(name="inputPathsMap")
    def input_paths_map(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Map of JSON paths to be extracted from the event. You can then insert these in the template in `InputTemplate` to produce the output you want to be sent to the target.

        `InputPathsMap` is an array key-value pairs, where each value is a valid JSON path. You can have as many as 100 key-value pairs. You must use JSON dot notation, not bracket notation.

        The keys cannot start with " AWS ."
        """
        return pulumi.get(self, "input_paths_map")


@pulumi.output_type
class RuleKinesisParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "partitionKeyPath":
            suggest = "partition_key_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleKinesisParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleKinesisParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleKinesisParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 partition_key_path: builtins.str):
        """
        :param builtins.str partition_key_path: The JSON path to be extracted from the event and used as the partition key. For more information, see [Amazon Kinesis Streams Key Concepts](https://docs.aws.amazon.com/streams/latest/dev/key-concepts.html#partition-key) in the *Amazon Kinesis Streams Developer Guide* .
        """
        pulumi.set(__self__, "partition_key_path", partition_key_path)

    @property
    @pulumi.getter(name="partitionKeyPath")
    def partition_key_path(self) -> builtins.str:
        """
        The JSON path to be extracted from the event and used as the partition key. For more information, see [Amazon Kinesis Streams Key Concepts](https://docs.aws.amazon.com/streams/latest/dev/key-concepts.html#partition-key) in the *Amazon Kinesis Streams Developer Guide* .
        """
        return pulumi.get(self, "partition_key_path")


@pulumi.output_type
class RuleNetworkConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsVpcConfiguration":
            suggest = "aws_vpc_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_vpc_configuration: Optional['outputs.RuleAwsVpcConfiguration'] = None):
        """
        :param 'RuleAwsVpcConfiguration' aws_vpc_configuration: Use this structure to specify the VPC subnets and security groups for the task, and whether a public IP address is to be used. This structure is relevant only for ECS tasks that use the `awsvpc` network mode.
        """
        if aws_vpc_configuration is not None:
            pulumi.set(__self__, "aws_vpc_configuration", aws_vpc_configuration)

    @property
    @pulumi.getter(name="awsVpcConfiguration")
    def aws_vpc_configuration(self) -> Optional['outputs.RuleAwsVpcConfiguration']:
        """
        Use this structure to specify the VPC subnets and security groups for the task, and whether a public IP address is to be used. This structure is relevant only for ECS tasks that use the `awsvpc` network mode.
        """
        return pulumi.get(self, "aws_vpc_configuration")


@pulumi.output_type
class RulePlacementConstraint(dict):
    def __init__(__self__, *,
                 expression: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.str expression: A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is `distinctInstance` . To learn more, see [Cluster Query Language](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html) in the Amazon Elastic Container Service Developer Guide.
        :param builtins.str type: The type of constraint. Use distinctInstance to ensure that each task in a particular group is running on a different container instance. Use memberOf to restrict the selection to a group of valid candidates.
        """
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def expression(self) -> Optional[builtins.str]:
        """
        A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is `distinctInstance` . To learn more, see [Cluster Query Language](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html) in the Amazon Elastic Container Service Developer Guide.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The type of constraint. Use distinctInstance to ensure that each task in a particular group is running on a different container instance. Use memberOf to restrict the selection to a group of valid candidates.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RulePlacementStrategy(dict):
    def __init__(__self__, *,
                 field: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.str field: The field to apply the placement strategy against. For the spread placement strategy, valid values are instanceId (or host, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as attribute:ecs.availability-zone. For the binpack placement strategy, valid values are cpu and memory. For the random placement strategy, this field is not used.
        :param builtins.str type: The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task).
        """
        if field is not None:
            pulumi.set(__self__, "field", field)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def field(self) -> Optional[builtins.str]:
        """
        The field to apply the placement strategy against. For the spread placement strategy, valid values are instanceId (or host, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as attribute:ecs.availability-zone. For the binpack placement strategy, valid values are cpu and memory. For the random placement strategy, this field is not used.
        """
        return pulumi.get(self, "field")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task).
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RuleRedshiftDataParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dbUser":
            suggest = "db_user"
        elif key == "secretManagerArn":
            suggest = "secret_manager_arn"
        elif key == "statementName":
            suggest = "statement_name"
        elif key == "withEvent":
            suggest = "with_event"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleRedshiftDataParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleRedshiftDataParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleRedshiftDataParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database: builtins.str,
                 db_user: Optional[builtins.str] = None,
                 secret_manager_arn: Optional[builtins.str] = None,
                 sql: Optional[builtins.str] = None,
                 sqls: Optional[Sequence[builtins.str]] = None,
                 statement_name: Optional[builtins.str] = None,
                 with_event: Optional[builtins.bool] = None):
        """
        :param builtins.str database: The name of the database. Required when authenticating using temporary credentials.
        :param builtins.str db_user: The database user name. Required when authenticating using temporary credentials.
        :param builtins.str secret_manager_arn: The name or ARN of the secret that enables access to the database. Required when authenticating using AWS Secrets Manager.
        :param builtins.str sql: The SQL statement text to run.
        :param Sequence[builtins.str] sqls: One or more SQL statements to run. The SQL statements are run as a single transaction. They run serially in the order of the array. Subsequent SQL statements don't start until the previous statement in the array completes. If any SQL statement fails, then because they are run as one transaction, all work is rolled back.
        :param builtins.str statement_name: The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
        :param builtins.bool with_event: Indicates whether to send an event back to EventBridge after the SQL statement runs.
        """
        pulumi.set(__self__, "database", database)
        if db_user is not None:
            pulumi.set(__self__, "db_user", db_user)
        if secret_manager_arn is not None:
            pulumi.set(__self__, "secret_manager_arn", secret_manager_arn)
        if sql is not None:
            pulumi.set(__self__, "sql", sql)
        if sqls is not None:
            pulumi.set(__self__, "sqls", sqls)
        if statement_name is not None:
            pulumi.set(__self__, "statement_name", statement_name)
        if with_event is not None:
            pulumi.set(__self__, "with_event", with_event)

    @property
    @pulumi.getter
    def database(self) -> builtins.str:
        """
        The name of the database. Required when authenticating using temporary credentials.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="dbUser")
    def db_user(self) -> Optional[builtins.str]:
        """
        The database user name. Required when authenticating using temporary credentials.
        """
        return pulumi.get(self, "db_user")

    @property
    @pulumi.getter(name="secretManagerArn")
    def secret_manager_arn(self) -> Optional[builtins.str]:
        """
        The name or ARN of the secret that enables access to the database. Required when authenticating using AWS Secrets Manager.
        """
        return pulumi.get(self, "secret_manager_arn")

    @property
    @pulumi.getter
    def sql(self) -> Optional[builtins.str]:
        """
        The SQL statement text to run.
        """
        return pulumi.get(self, "sql")

    @property
    @pulumi.getter
    def sqls(self) -> Optional[Sequence[builtins.str]]:
        """
        One or more SQL statements to run. The SQL statements are run as a single transaction. They run serially in the order of the array. Subsequent SQL statements don't start until the previous statement in the array completes. If any SQL statement fails, then because they are run as one transaction, all work is rolled back.
        """
        return pulumi.get(self, "sqls")

    @property
    @pulumi.getter(name="statementName")
    def statement_name(self) -> Optional[builtins.str]:
        """
        The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
        """
        return pulumi.get(self, "statement_name")

    @property
    @pulumi.getter(name="withEvent")
    def with_event(self) -> Optional[builtins.bool]:
        """
        Indicates whether to send an event back to EventBridge after the SQL statement runs.
        """
        return pulumi.get(self, "with_event")


@pulumi.output_type
class RuleRetryPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumEventAgeInSeconds":
            suggest = "maximum_event_age_in_seconds"
        elif key == "maximumRetryAttempts":
            suggest = "maximum_retry_attempts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleRetryPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleRetryPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleRetryPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_event_age_in_seconds: Optional[builtins.int] = None,
                 maximum_retry_attempts: Optional[builtins.int] = None):
        """
        :param builtins.int maximum_event_age_in_seconds: The maximum amount of time, in seconds, to continue to make retry attempts.
        :param builtins.int maximum_retry_attempts: The maximum number of retry attempts to make before the request fails. Retry attempts continue until either the maximum number of attempts is made or until the duration of the `MaximumEventAgeInSeconds` is met.
        """
        if maximum_event_age_in_seconds is not None:
            pulumi.set(__self__, "maximum_event_age_in_seconds", maximum_event_age_in_seconds)
        if maximum_retry_attempts is not None:
            pulumi.set(__self__, "maximum_retry_attempts", maximum_retry_attempts)

    @property
    @pulumi.getter(name="maximumEventAgeInSeconds")
    def maximum_event_age_in_seconds(self) -> Optional[builtins.int]:
        """
        The maximum amount of time, in seconds, to continue to make retry attempts.
        """
        return pulumi.get(self, "maximum_event_age_in_seconds")

    @property
    @pulumi.getter(name="maximumRetryAttempts")
    def maximum_retry_attempts(self) -> Optional[builtins.int]:
        """
        The maximum number of retry attempts to make before the request fails. Retry attempts continue until either the maximum number of attempts is made or until the duration of the `MaximumEventAgeInSeconds` is met.
        """
        return pulumi.get(self, "maximum_retry_attempts")


@pulumi.output_type
class RuleRunCommandParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runCommandTargets":
            suggest = "run_command_targets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleRunCommandParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleRunCommandParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleRunCommandParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 run_command_targets: Sequence['outputs.RuleRunCommandTarget']):
        """
        :param Sequence['RuleRunCommandTarget'] run_command_targets: Currently, we support including only one RunCommandTarget block, which specifies either an array of InstanceIds or a tag.
        """
        pulumi.set(__self__, "run_command_targets", run_command_targets)

    @property
    @pulumi.getter(name="runCommandTargets")
    def run_command_targets(self) -> Sequence['outputs.RuleRunCommandTarget']:
        """
        Currently, we support including only one RunCommandTarget block, which specifies either an array of InstanceIds or a tag.
        """
        return pulumi.get(self, "run_command_targets")


@pulumi.output_type
class RuleRunCommandTarget(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str key: Can be either `tag:` *tag-key* or `InstanceIds` .
        :param Sequence[builtins.str] values: If `Key` is `tag:` *tag-key* , `Values` is a list of tag values. If `Key` is `InstanceIds` , `Values` is a list of Amazon EC2 instance IDs.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Can be either `tag:` *tag-key* or `InstanceIds` .
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        If `Key` is `tag:` *tag-key* , `Values` is a list of tag values. If `Key` is `InstanceIds` , `Values` is a list of Amazon EC2 instance IDs.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class RuleSageMakerPipelineParameter(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: Name of parameter to start execution of a SageMaker AI Model Building Pipeline.
        :param builtins.str value: Value of parameter to start execution of a SageMaker AI Model Building Pipeline.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of parameter to start execution of a SageMaker AI Model Building Pipeline.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value of parameter to start execution of a SageMaker AI Model Building Pipeline.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RuleSageMakerPipelineParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pipelineParameterList":
            suggest = "pipeline_parameter_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleSageMakerPipelineParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleSageMakerPipelineParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleSageMakerPipelineParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pipeline_parameter_list: Optional[Sequence['outputs.RuleSageMakerPipelineParameter']] = None):
        """
        :param Sequence['RuleSageMakerPipelineParameter'] pipeline_parameter_list: List of Parameter names and values for SageMaker AI Model Building Pipeline execution.
        """
        if pipeline_parameter_list is not None:
            pulumi.set(__self__, "pipeline_parameter_list", pipeline_parameter_list)

    @property
    @pulumi.getter(name="pipelineParameterList")
    def pipeline_parameter_list(self) -> Optional[Sequence['outputs.RuleSageMakerPipelineParameter']]:
        """
        List of Parameter names and values for SageMaker AI Model Building Pipeline execution.
        """
        return pulumi.get(self, "pipeline_parameter_list")


@pulumi.output_type
class RuleSqsParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageGroupId":
            suggest = "message_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleSqsParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleSqsParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleSqsParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message_group_id: builtins.str):
        """
        :param builtins.str message_group_id: The FIFO message group ID to use as the target.
        """
        pulumi.set(__self__, "message_group_id", message_group_id)

    @property
    @pulumi.getter(name="messageGroupId")
    def message_group_id(self) -> builtins.str:
        """
        The FIFO message group ID to use as the target.
        """
        return pulumi.get(self, "message_group_id")


@pulumi.output_type
class RuleTag(dict):
    def __init__(__self__, *,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str key: A string you can use to assign a value. The combination of tag keys and values can help you organize and categorize your resources.
        :param builtins.str value: The value for the specified tag key.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        A string you can use to assign a value. The combination of tag keys and values can help you organize and categorize your resources.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The value for the specified tag key.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RuleTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appSyncParameters":
            suggest = "app_sync_parameters"
        elif key == "batchParameters":
            suggest = "batch_parameters"
        elif key == "deadLetterConfig":
            suggest = "dead_letter_config"
        elif key == "ecsParameters":
            suggest = "ecs_parameters"
        elif key == "httpParameters":
            suggest = "http_parameters"
        elif key == "inputPath":
            suggest = "input_path"
        elif key == "inputTransformer":
            suggest = "input_transformer"
        elif key == "kinesisParameters":
            suggest = "kinesis_parameters"
        elif key == "redshiftDataParameters":
            suggest = "redshift_data_parameters"
        elif key == "retryPolicy":
            suggest = "retry_policy"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "runCommandParameters":
            suggest = "run_command_parameters"
        elif key == "sageMakerPipelineParameters":
            suggest = "sage_maker_pipeline_parameters"
        elif key == "sqsParameters":
            suggest = "sqs_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arn: builtins.str,
                 id: builtins.str,
                 app_sync_parameters: Optional['outputs.RuleAppSyncParameters'] = None,
                 batch_parameters: Optional['outputs.RuleBatchParameters'] = None,
                 dead_letter_config: Optional['outputs.RuleDeadLetterConfig'] = None,
                 ecs_parameters: Optional['outputs.RuleEcsParameters'] = None,
                 http_parameters: Optional['outputs.RuleHttpParameters'] = None,
                 input: Optional[builtins.str] = None,
                 input_path: Optional[builtins.str] = None,
                 input_transformer: Optional['outputs.RuleInputTransformer'] = None,
                 kinesis_parameters: Optional['outputs.RuleKinesisParameters'] = None,
                 redshift_data_parameters: Optional['outputs.RuleRedshiftDataParameters'] = None,
                 retry_policy: Optional['outputs.RuleRetryPolicy'] = None,
                 role_arn: Optional[builtins.str] = None,
                 run_command_parameters: Optional['outputs.RuleRunCommandParameters'] = None,
                 sage_maker_pipeline_parameters: Optional['outputs.RuleSageMakerPipelineParameters'] = None,
                 sqs_parameters: Optional['outputs.RuleSqsParameters'] = None):
        """
        :param builtins.str arn: The Amazon Resource Name (ARN) of the target.
        :param builtins.str id: The ID of the target within the specified rule. Use this ID to reference the target when updating the rule. We recommend using a memorable and unique string.
        :param 'RuleAppSyncParameters' app_sync_parameters: Contains the GraphQL operation to be parsed and executed, if the event target is an AWS AppSync API.
        :param 'RuleBatchParameters' batch_parameters: If the event target is an AWS Batch job, this contains the job definition, job name, and other parameters. For more information, see [Jobs](https://docs.aws.amazon.com/batch/latest/userguide/jobs.html) in the *AWS Batch User Guide* .
        :param 'RuleDeadLetterConfig' dead_letter_config: The `DeadLetterConfig` that defines the target queue to send dead-letter queue events to.
        :param 'RuleEcsParameters' ecs_parameters: Contains the Amazon ECS task definition and task count to be used, if the event target is an Amazon ECS task. For more information about Amazon ECS tasks, see [Task Definitions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html) in the *Amazon EC2 Container Service Developer Guide* .
        :param 'RuleHttpParameters' http_parameters: Contains the HTTP parameters to use when the target is a API Gateway endpoint or EventBridge ApiDestination.
               
               If you specify an API Gateway API or EventBridge ApiDestination as a target, you can use this parameter to specify headers, path parameters, and query string keys/values as part of your target invoking request. If you're using ApiDestinations, the corresponding Connection can also have these values configured. In case of any conflicting keys, values from the Connection take precedence.
        :param builtins.str input: Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the target. For more information, see [The JavaScript Object Notation (JSON) Data Interchange Format](https://docs.aws.amazon.com/http://www.rfc-editor.org/rfc/rfc7159.txt) .
        :param builtins.str input_path: The value of the JSONPath that is used for extracting part of the matched event when passing it to the target. You may use JSON dot notation or bracket notation. For more information about JSON paths, see [JSONPath](https://docs.aws.amazon.com/http://goessner.net/articles/JsonPath/) .
        :param 'RuleInputTransformer' input_transformer: Settings to enable you to provide custom input to a target based on certain event data. You can extract one or more key-value pairs from the event and then use that data to send customized input to the target.
        :param 'RuleKinesisParameters' kinesis_parameters: The custom parameter you can use to control the shard assignment, when the target is a Kinesis data stream. If you do not include this parameter, the default is to use the `eventId` as the partition key.
        :param 'RuleRedshiftDataParameters' redshift_data_parameters: Contains the Amazon Redshift Data API parameters to use when the target is a Amazon Redshift cluster.
               
               If you specify a Amazon Redshift Cluster as a Target, you can use this to specify parameters to invoke the Amazon Redshift Data API ExecuteStatement based on EventBridge events.
        :param 'RuleRetryPolicy' retry_policy: The retry policy configuration to use for the dead-letter queue.
        :param builtins.str role_arn: The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered. If one rule triggers multiple targets, you can use a different IAM role for each target.
        :param 'RuleRunCommandParameters' run_command_parameters: Parameters used when you are using the rule to invoke Amazon EC2 Run Command.
        :param 'RuleSageMakerPipelineParameters' sage_maker_pipeline_parameters: Contains the SageMaker AI Model Building Pipeline parameters to start execution of a SageMaker AI Model Building Pipeline.
               
               If you specify a SageMaker AI Model Building Pipeline as a target, you can use this to specify parameters to start a pipeline execution based on EventBridge events.
        :param 'RuleSqsParameters' sqs_parameters: Contains the message group ID to use when the target is a FIFO queue.
               
               If you specify an SQS FIFO queue as a target, the queue must have content-based deduplication enabled.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "id", id)
        if app_sync_parameters is not None:
            pulumi.set(__self__, "app_sync_parameters", app_sync_parameters)
        if batch_parameters is not None:
            pulumi.set(__self__, "batch_parameters", batch_parameters)
        if dead_letter_config is not None:
            pulumi.set(__self__, "dead_letter_config", dead_letter_config)
        if ecs_parameters is not None:
            pulumi.set(__self__, "ecs_parameters", ecs_parameters)
        if http_parameters is not None:
            pulumi.set(__self__, "http_parameters", http_parameters)
        if input is not None:
            pulumi.set(__self__, "input", input)
        if input_path is not None:
            pulumi.set(__self__, "input_path", input_path)
        if input_transformer is not None:
            pulumi.set(__self__, "input_transformer", input_transformer)
        if kinesis_parameters is not None:
            pulumi.set(__self__, "kinesis_parameters", kinesis_parameters)
        if redshift_data_parameters is not None:
            pulumi.set(__self__, "redshift_data_parameters", redshift_data_parameters)
        if retry_policy is not None:
            pulumi.set(__self__, "retry_policy", retry_policy)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if run_command_parameters is not None:
            pulumi.set(__self__, "run_command_parameters", run_command_parameters)
        if sage_maker_pipeline_parameters is not None:
            pulumi.set(__self__, "sage_maker_pipeline_parameters", sage_maker_pipeline_parameters)
        if sqs_parameters is not None:
            pulumi.set(__self__, "sqs_parameters", sqs_parameters)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the target.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the target within the specified rule. Use this ID to reference the target when updating the rule. We recommend using a memorable and unique string.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="appSyncParameters")
    def app_sync_parameters(self) -> Optional['outputs.RuleAppSyncParameters']:
        """
        Contains the GraphQL operation to be parsed and executed, if the event target is an AWS AppSync API.
        """
        return pulumi.get(self, "app_sync_parameters")

    @property
    @pulumi.getter(name="batchParameters")
    def batch_parameters(self) -> Optional['outputs.RuleBatchParameters']:
        """
        If the event target is an AWS Batch job, this contains the job definition, job name, and other parameters. For more information, see [Jobs](https://docs.aws.amazon.com/batch/latest/userguide/jobs.html) in the *AWS Batch User Guide* .
        """
        return pulumi.get(self, "batch_parameters")

    @property
    @pulumi.getter(name="deadLetterConfig")
    def dead_letter_config(self) -> Optional['outputs.RuleDeadLetterConfig']:
        """
        The `DeadLetterConfig` that defines the target queue to send dead-letter queue events to.
        """
        return pulumi.get(self, "dead_letter_config")

    @property
    @pulumi.getter(name="ecsParameters")
    def ecs_parameters(self) -> Optional['outputs.RuleEcsParameters']:
        """
        Contains the Amazon ECS task definition and task count to be used, if the event target is an Amazon ECS task. For more information about Amazon ECS tasks, see [Task Definitions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html) in the *Amazon EC2 Container Service Developer Guide* .
        """
        return pulumi.get(self, "ecs_parameters")

    @property
    @pulumi.getter(name="httpParameters")
    def http_parameters(self) -> Optional['outputs.RuleHttpParameters']:
        """
        Contains the HTTP parameters to use when the target is a API Gateway endpoint or EventBridge ApiDestination.

        If you specify an API Gateway API or EventBridge ApiDestination as a target, you can use this parameter to specify headers, path parameters, and query string keys/values as part of your target invoking request. If you're using ApiDestinations, the corresponding Connection can also have these values configured. In case of any conflicting keys, values from the Connection take precedence.
        """
        return pulumi.get(self, "http_parameters")

    @property
    @pulumi.getter
    def input(self) -> Optional[builtins.str]:
        """
        Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the target. For more information, see [The JavaScript Object Notation (JSON) Data Interchange Format](https://docs.aws.amazon.com/http://www.rfc-editor.org/rfc/rfc7159.txt) .
        """
        return pulumi.get(self, "input")

    @property
    @pulumi.getter(name="inputPath")
    def input_path(self) -> Optional[builtins.str]:
        """
        The value of the JSONPath that is used for extracting part of the matched event when passing it to the target. You may use JSON dot notation or bracket notation. For more information about JSON paths, see [JSONPath](https://docs.aws.amazon.com/http://goessner.net/articles/JsonPath/) .
        """
        return pulumi.get(self, "input_path")

    @property
    @pulumi.getter(name="inputTransformer")
    def input_transformer(self) -> Optional['outputs.RuleInputTransformer']:
        """
        Settings to enable you to provide custom input to a target based on certain event data. You can extract one or more key-value pairs from the event and then use that data to send customized input to the target.
        """
        return pulumi.get(self, "input_transformer")

    @property
    @pulumi.getter(name="kinesisParameters")
    def kinesis_parameters(self) -> Optional['outputs.RuleKinesisParameters']:
        """
        The custom parameter you can use to control the shard assignment, when the target is a Kinesis data stream. If you do not include this parameter, the default is to use the `eventId` as the partition key.
        """
        return pulumi.get(self, "kinesis_parameters")

    @property
    @pulumi.getter(name="redshiftDataParameters")
    def redshift_data_parameters(self) -> Optional['outputs.RuleRedshiftDataParameters']:
        """
        Contains the Amazon Redshift Data API parameters to use when the target is a Amazon Redshift cluster.

        If you specify a Amazon Redshift Cluster as a Target, you can use this to specify parameters to invoke the Amazon Redshift Data API ExecuteStatement based on EventBridge events.
        """
        return pulumi.get(self, "redshift_data_parameters")

    @property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> Optional['outputs.RuleRetryPolicy']:
        """
        The retry policy configuration to use for the dead-letter queue.
        """
        return pulumi.get(self, "retry_policy")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered. If one rule triggers multiple targets, you can use a different IAM role for each target.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="runCommandParameters")
    def run_command_parameters(self) -> Optional['outputs.RuleRunCommandParameters']:
        """
        Parameters used when you are using the rule to invoke Amazon EC2 Run Command.
        """
        return pulumi.get(self, "run_command_parameters")

    @property
    @pulumi.getter(name="sageMakerPipelineParameters")
    def sage_maker_pipeline_parameters(self) -> Optional['outputs.RuleSageMakerPipelineParameters']:
        """
        Contains the SageMaker AI Model Building Pipeline parameters to start execution of a SageMaker AI Model Building Pipeline.

        If you specify a SageMaker AI Model Building Pipeline as a target, you can use this to specify parameters to start a pipeline execution based on EventBridge events.
        """
        return pulumi.get(self, "sage_maker_pipeline_parameters")

    @property
    @pulumi.getter(name="sqsParameters")
    def sqs_parameters(self) -> Optional['outputs.RuleSqsParameters']:
        """
        Contains the message group ID to use when the target is a FIFO queue.

        If you specify an SQS FIFO queue as a target, the queue must have content-based deduplication enabled.
        """
        return pulumi.get(self, "sqs_parameters")


