# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetEndpointResult',
    'AwaitableGetEndpointResult',
    'get_endpoint',
    'get_endpoint_output',
]

@pulumi.output_type
class GetEndpointResult:
    def __init__(__self__, arn=None, description=None, endpoint_id=None, endpoint_url=None, event_buses=None, replication_config=None, role_arn=None, routing_config=None, state=None, state_reason=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if endpoint_id and not isinstance(endpoint_id, str):
            raise TypeError("Expected argument 'endpoint_id' to be a str")
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        if endpoint_url and not isinstance(endpoint_url, str):
            raise TypeError("Expected argument 'endpoint_url' to be a str")
        pulumi.set(__self__, "endpoint_url", endpoint_url)
        if event_buses and not isinstance(event_buses, list):
            raise TypeError("Expected argument 'event_buses' to be a list")
        pulumi.set(__self__, "event_buses", event_buses)
        if replication_config and not isinstance(replication_config, dict):
            raise TypeError("Expected argument 'replication_config' to be a dict")
        pulumi.set(__self__, "replication_config", replication_config)
        if role_arn and not isinstance(role_arn, str):
            raise TypeError("Expected argument 'role_arn' to be a str")
        pulumi.set(__self__, "role_arn", role_arn)
        if routing_config and not isinstance(routing_config, dict):
            raise TypeError("Expected argument 'routing_config' to be a dict")
        pulumi.set(__self__, "routing_config", routing_config)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if state_reason and not isinstance(state_reason, str):
            raise TypeError("Expected argument 'state_reason' to be a str")
        pulumi.set(__self__, "state_reason", state_reason)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The ARN of the endpoint.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A description for the endpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[builtins.str]:
        """
        The ID of the endpoint.
        """
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter(name="endpointUrl")
    def endpoint_url(self) -> Optional[builtins.str]:
        """
        The URL of the endpoint.
        """
        return pulumi.get(self, "endpoint_url")

    @property
    @pulumi.getter(name="eventBuses")
    def event_buses(self) -> Optional[Sequence['outputs.EndpointEventBus']]:
        """
        The event buses being used by the endpoint.

        *Exactly* : `2`
        """
        return pulumi.get(self, "event_buses")

    @property
    @pulumi.getter(name="replicationConfig")
    def replication_config(self) -> Optional['outputs.EndpointReplicationConfig']:
        """
        Whether event replication was enabled or disabled for this endpoint. The default state is `ENABLED` which means you must supply a `RoleArn` . If you don't have a `RoleArn` or you don't want event replication enabled, set the state to `DISABLED` .
        """
        return pulumi.get(self, "replication_config")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the role used by event replication for the endpoint.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="routingConfig")
    def routing_config(self) -> Optional['outputs.EndpointRoutingConfig']:
        """
        The routing configuration of the endpoint.
        """
        return pulumi.get(self, "routing_config")

    @property
    @pulumi.getter
    def state(self) -> Optional['EndpointState']:
        """
        The main Region of the endpoint.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateReason")
    def state_reason(self) -> Optional[builtins.str]:
        """
        The reason the endpoint is in its current state.
        """
        return pulumi.get(self, "state_reason")


class AwaitableGetEndpointResult(GetEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEndpointResult(
            arn=self.arn,
            description=self.description,
            endpoint_id=self.endpoint_id,
            endpoint_url=self.endpoint_url,
            event_buses=self.event_buses,
            replication_config=self.replication_config,
            role_arn=self.role_arn,
            routing_config=self.routing_config,
            state=self.state,
            state_reason=self.state_reason)


def get_endpoint(name: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEndpointResult:
    """
    Resource Type definition for AWS::Events::Endpoint.


    :param builtins.str name: The name of the endpoint.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:events:getEndpoint', __args__, opts=opts, typ=GetEndpointResult).value

    return AwaitableGetEndpointResult(
        arn=pulumi.get(__ret__, 'arn'),
        description=pulumi.get(__ret__, 'description'),
        endpoint_id=pulumi.get(__ret__, 'endpoint_id'),
        endpoint_url=pulumi.get(__ret__, 'endpoint_url'),
        event_buses=pulumi.get(__ret__, 'event_buses'),
        replication_config=pulumi.get(__ret__, 'replication_config'),
        role_arn=pulumi.get(__ret__, 'role_arn'),
        routing_config=pulumi.get(__ret__, 'routing_config'),
        state=pulumi.get(__ret__, 'state'),
        state_reason=pulumi.get(__ret__, 'state_reason'))
def get_endpoint_output(name: Optional[pulumi.Input[builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEndpointResult]:
    """
    Resource Type definition for AWS::Events::Endpoint.


    :param builtins.str name: The name of the endpoint.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:events:getEndpoint', __args__, opts=opts, typ=GetEndpointResult)
    return __ret__.apply(lambda __response__: GetEndpointResult(
        arn=pulumi.get(__response__, 'arn'),
        description=pulumi.get(__response__, 'description'),
        endpoint_id=pulumi.get(__response__, 'endpoint_id'),
        endpoint_url=pulumi.get(__response__, 'endpoint_url'),
        event_buses=pulumi.get(__response__, 'event_buses'),
        replication_config=pulumi.get(__response__, 'replication_config'),
        role_arn=pulumi.get(__response__, 'role_arn'),
        routing_config=pulumi.get(__response__, 'routing_config'),
        state=pulumi.get(__response__, 'state'),
        state_reason=pulumi.get(__response__, 'state_reason')))
