# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetConnectionResult',
    'AwaitableGetConnectionResult',
    'get_connection',
    'get_connection_output',
]

@pulumi.output_type
class GetConnectionResult:
    def __init__(__self__, arn=None, arn_for_policy=None, auth_parameters=None, authorization_type=None, description=None, invocation_connectivity_parameters=None, kms_key_identifier=None, secret_arn=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if arn_for_policy and not isinstance(arn_for_policy, str):
            raise TypeError("Expected argument 'arn_for_policy' to be a str")
        pulumi.set(__self__, "arn_for_policy", arn_for_policy)
        if auth_parameters and not isinstance(auth_parameters, dict):
            raise TypeError("Expected argument 'auth_parameters' to be a dict")
        pulumi.set(__self__, "auth_parameters", auth_parameters)
        if authorization_type and not isinstance(authorization_type, str):
            raise TypeError("Expected argument 'authorization_type' to be a str")
        pulumi.set(__self__, "authorization_type", authorization_type)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if invocation_connectivity_parameters and not isinstance(invocation_connectivity_parameters, dict):
            raise TypeError("Expected argument 'invocation_connectivity_parameters' to be a dict")
        pulumi.set(__self__, "invocation_connectivity_parameters", invocation_connectivity_parameters)
        if kms_key_identifier and not isinstance(kms_key_identifier, str):
            raise TypeError("Expected argument 'kms_key_identifier' to be a str")
        pulumi.set(__self__, "kms_key_identifier", kms_key_identifier)
        if secret_arn and not isinstance(secret_arn, str):
            raise TypeError("Expected argument 'secret_arn' to be a str")
        pulumi.set(__self__, "secret_arn", secret_arn)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The arn of the connection resource.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="arnForPolicy")
    def arn_for_policy(self) -> Optional[builtins.str]:
        """
        The arn of the connection resource to be used in IAM policies.
        """
        return pulumi.get(self, "arn_for_policy")

    @property
    @pulumi.getter(name="authParameters")
    def auth_parameters(self) -> Optional['outputs.ConnectionAuthParameters']:
        """
        The authorization parameters to use to authorize with the endpoint.

        You must include only authorization parameters for the `AuthorizationType` you specify.
        """
        return pulumi.get(self, "auth_parameters")

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> Optional['ConnectionAuthorizationType']:
        """
        The type of authorization to use for the connection.

        > OAUTH tokens are refreshed when a 401 or 407 response is returned.
        """
        return pulumi.get(self, "authorization_type")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        Description of the connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="invocationConnectivityParameters")
    def invocation_connectivity_parameters(self) -> Optional['outputs.InvocationConnectivityParametersProperties']:
        """
        The private resource the HTTP request will be sent to.
        """
        return pulumi.get(self, "invocation_connectivity_parameters")

    @property
    @pulumi.getter(name="kmsKeyIdentifier")
    def kms_key_identifier(self) -> Optional[builtins.str]:
        """
        The identifier of the AWS KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt this connection. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN.

        If you do not specify a customer managed key identifier, EventBridge uses an AWS owned key to encrypt the connection.

        For more information, see [Identify and view keys](https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html) in the *AWS Key Management Service Developer Guide* .
        """
        return pulumi.get(self, "kms_key_identifier")

    @property
    @pulumi.getter(name="secretArn")
    def secret_arn(self) -> Optional[builtins.str]:
        """
        The arn of the secrets manager secret created in the customer account.
        """
        return pulumi.get(self, "secret_arn")


class AwaitableGetConnectionResult(GetConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectionResult(
            arn=self.arn,
            arn_for_policy=self.arn_for_policy,
            auth_parameters=self.auth_parameters,
            authorization_type=self.authorization_type,
            description=self.description,
            invocation_connectivity_parameters=self.invocation_connectivity_parameters,
            kms_key_identifier=self.kms_key_identifier,
            secret_arn=self.secret_arn)


def get_connection(name: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectionResult:
    """
    Resource Type definition for AWS::Events::Connection.


    :param builtins.str name: Name of the connection.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:events:getConnection', __args__, opts=opts, typ=GetConnectionResult).value

    return AwaitableGetConnectionResult(
        arn=pulumi.get(__ret__, 'arn'),
        arn_for_policy=pulumi.get(__ret__, 'arn_for_policy'),
        auth_parameters=pulumi.get(__ret__, 'auth_parameters'),
        authorization_type=pulumi.get(__ret__, 'authorization_type'),
        description=pulumi.get(__ret__, 'description'),
        invocation_connectivity_parameters=pulumi.get(__ret__, 'invocation_connectivity_parameters'),
        kms_key_identifier=pulumi.get(__ret__, 'kms_key_identifier'),
        secret_arn=pulumi.get(__ret__, 'secret_arn'))
def get_connection_output(name: Optional[pulumi.Input[builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConnectionResult]:
    """
    Resource Type definition for AWS::Events::Connection.


    :param builtins.str name: Name of the connection.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:events:getConnection', __args__, opts=opts, typ=GetConnectionResult)
    return __ret__.apply(lambda __response__: GetConnectionResult(
        arn=pulumi.get(__response__, 'arn'),
        arn_for_policy=pulumi.get(__response__, 'arn_for_policy'),
        auth_parameters=pulumi.get(__response__, 'auth_parameters'),
        authorization_type=pulumi.get(__response__, 'authorization_type'),
        description=pulumi.get(__response__, 'description'),
        invocation_connectivity_parameters=pulumi.get(__response__, 'invocation_connectivity_parameters'),
        kms_key_identifier=pulumi.get(__response__, 'kms_key_identifier'),
        secret_arn=pulumi.get(__response__, 'secret_arn')))
