# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetArchiveResult',
    'AwaitableGetArchiveResult',
    'get_archive',
    'get_archive_output',
]

@pulumi.output_type
class GetArchiveResult:
    def __init__(__self__, arn=None, description=None, event_pattern=None, kms_key_identifier=None, retention_days=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if event_pattern and not isinstance(event_pattern, dict):
            raise TypeError("Expected argument 'event_pattern' to be a dict")
        pulumi.set(__self__, "event_pattern", event_pattern)
        if kms_key_identifier and not isinstance(kms_key_identifier, str):
            raise TypeError("Expected argument 'kms_key_identifier' to be a str")
        pulumi.set(__self__, "kms_key_identifier", kms_key_identifier)
        if retention_days and not isinstance(retention_days, int):
            raise TypeError("Expected argument 'retention_days' to be a int")
        pulumi.set(__self__, "retention_days", retention_days)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The ARN of the archive created.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A description for the archive.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eventPattern")
    def event_pattern(self) -> Optional[Any]:
        """
        An event pattern to use to filter events sent to the archive.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Events::Archive` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "event_pattern")

    @property
    @pulumi.getter(name="kmsKeyIdentifier")
    def kms_key_identifier(self) -> Optional[builtins.str]:
        """
        The identifier of the AWS KMS customer managed key for EventBridge to use, if you choose to use a customer managed key to encrypt this archive. The identifier can be the key Amazon Resource Name (ARN), KeyId, key alias, or key alias ARN.

        If you do not specify a customer managed key identifier, EventBridge uses an AWS owned key to encrypt the archive.

        For more information, see [Identify and view keys](https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html) in the *AWS Key Management Service Developer Guide* .

        > If you have specified that EventBridge use a customer managed key for encrypting the source event bus, we strongly recommend you also specify a customer managed key for any archives for the event bus as well.
        > 
        > For more information, see [Encrypting archives](https://docs.aws.amazon.com/eventbridge/latest/userguide/encryption-archives.html) in the *Amazon EventBridge User Guide* .
        """
        return pulumi.get(self, "kms_key_identifier")

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> Optional[builtins.int]:
        """
        The number of days to retain events for. Default value is 0. If set to 0, events are retained indefinitely
        """
        return pulumi.get(self, "retention_days")


class AwaitableGetArchiveResult(GetArchiveResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetArchiveResult(
            arn=self.arn,
            description=self.description,
            event_pattern=self.event_pattern,
            kms_key_identifier=self.kms_key_identifier,
            retention_days=self.retention_days)


def get_archive(archive_name: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetArchiveResult:
    """
    Resource Type definition for AWS::Events::Archive


    :param builtins.str archive_name: The name for the archive to create.
    """
    __args__ = dict()
    __args__['archiveName'] = archive_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:events:getArchive', __args__, opts=opts, typ=GetArchiveResult).value

    return AwaitableGetArchiveResult(
        arn=pulumi.get(__ret__, 'arn'),
        description=pulumi.get(__ret__, 'description'),
        event_pattern=pulumi.get(__ret__, 'event_pattern'),
        kms_key_identifier=pulumi.get(__ret__, 'kms_key_identifier'),
        retention_days=pulumi.get(__ret__, 'retention_days'))
def get_archive_output(archive_name: Optional[pulumi.Input[builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetArchiveResult]:
    """
    Resource Type definition for AWS::Events::Archive


    :param builtins.str archive_name: The name for the archive to create.
    """
    __args__ = dict()
    __args__['archiveName'] = archive_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:events:getArchive', __args__, opts=opts, typ=GetArchiveResult)
    return __ret__.apply(lambda __response__: GetArchiveResult(
        arn=pulumi.get(__response__, 'arn'),
        description=pulumi.get(__response__, 'description'),
        event_pattern=pulumi.get(__response__, 'event_pattern'),
        kms_key_identifier=pulumi.get(__response__, 'kms_key_identifier'),
        retention_days=pulumi.get(__response__, 'retention_days')))
