# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['IdMappingWorkflowArgs', 'IdMappingWorkflow']

@pulumi.input_type
class IdMappingWorkflowArgs:
    def __init__(__self__, *,
                 id_mapping_techniques: pulumi.Input['IdMappingWorkflowIdMappingTechniquesArgs'],
                 input_source_config: pulumi.Input[Sequence[pulumi.Input['IdMappingWorkflowInputSourceArgs']]],
                 role_arn: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 output_source_config: Optional[pulumi.Input[Sequence[pulumi.Input['IdMappingWorkflowOutputSourceArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 workflow_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a IdMappingWorkflow resource.
        :param pulumi.Input['IdMappingWorkflowIdMappingTechniquesArgs'] id_mapping_techniques: An object which defines the ID mapping technique and any additional configurations.
        :param pulumi.Input[Sequence[pulumi.Input['IdMappingWorkflowInputSourceArgs']]] input_source_config: A list of `InputSource` objects, which have the fields `InputSourceARN` and `SchemaName` .
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of the IAM role. AWS Entity Resolution assumes this role to create resources on your behalf as part of workflow execution.
        :param pulumi.Input[builtins.str] description: The description of the IdMappingWorkflow
        :param pulumi.Input[Sequence[pulumi.Input['IdMappingWorkflowOutputSourceArgs']]] output_source_config: A list of `IdMappingWorkflowOutputSource` objects, each of which contains fields `OutputS3Path` and `Output` .
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags used to organize, track, or control access for this resource.
        :param pulumi.Input[builtins.str] workflow_name: The name of the IdMappingWorkflow
        """
        pulumi.set(__self__, "id_mapping_techniques", id_mapping_techniques)
        pulumi.set(__self__, "input_source_config", input_source_config)
        pulumi.set(__self__, "role_arn", role_arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if output_source_config is not None:
            pulumi.set(__self__, "output_source_config", output_source_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if workflow_name is not None:
            pulumi.set(__self__, "workflow_name", workflow_name)

    @property
    @pulumi.getter(name="idMappingTechniques")
    def id_mapping_techniques(self) -> pulumi.Input['IdMappingWorkflowIdMappingTechniquesArgs']:
        """
        An object which defines the ID mapping technique and any additional configurations.
        """
        return pulumi.get(self, "id_mapping_techniques")

    @id_mapping_techniques.setter
    def id_mapping_techniques(self, value: pulumi.Input['IdMappingWorkflowIdMappingTechniquesArgs']):
        pulumi.set(self, "id_mapping_techniques", value)

    @property
    @pulumi.getter(name="inputSourceConfig")
    def input_source_config(self) -> pulumi.Input[Sequence[pulumi.Input['IdMappingWorkflowInputSourceArgs']]]:
        """
        A list of `InputSource` objects, which have the fields `InputSourceARN` and `SchemaName` .
        """
        return pulumi.get(self, "input_source_config")

    @input_source_config.setter
    def input_source_config(self, value: pulumi.Input[Sequence[pulumi.Input['IdMappingWorkflowInputSourceArgs']]]):
        pulumi.set(self, "input_source_config", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM role. AWS Entity Resolution assumes this role to create resources on your behalf as part of workflow execution.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the IdMappingWorkflow
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="outputSourceConfig")
    def output_source_config(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IdMappingWorkflowOutputSourceArgs']]]]:
        """
        A list of `IdMappingWorkflowOutputSource` objects, each of which contains fields `OutputS3Path` and `Output` .
        """
        return pulumi.get(self, "output_source_config")

    @output_source_config.setter
    def output_source_config(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IdMappingWorkflowOutputSourceArgs']]]]):
        pulumi.set(self, "output_source_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags used to organize, track, or control access for this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="workflowName")
    def workflow_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the IdMappingWorkflow
        """
        return pulumi.get(self, "workflow_name")

    @workflow_name.setter
    def workflow_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workflow_name", value)


@pulumi.type_token("aws-native:entityresolution:IdMappingWorkflow")
class IdMappingWorkflow(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 id_mapping_techniques: Optional[pulumi.Input[Union['IdMappingWorkflowIdMappingTechniquesArgs', 'IdMappingWorkflowIdMappingTechniquesArgsDict']]] = None,
                 input_source_config: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IdMappingWorkflowInputSourceArgs', 'IdMappingWorkflowInputSourceArgsDict']]]]] = None,
                 output_source_config: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IdMappingWorkflowOutputSourceArgs', 'IdMappingWorkflowOutputSourceArgsDict']]]]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 workflow_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        IdMappingWorkflow defined in AWS Entity Resolution service

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the IdMappingWorkflow
        :param pulumi.Input[Union['IdMappingWorkflowIdMappingTechniquesArgs', 'IdMappingWorkflowIdMappingTechniquesArgsDict']] id_mapping_techniques: An object which defines the ID mapping technique and any additional configurations.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IdMappingWorkflowInputSourceArgs', 'IdMappingWorkflowInputSourceArgsDict']]]] input_source_config: A list of `InputSource` objects, which have the fields `InputSourceARN` and `SchemaName` .
        :param pulumi.Input[Sequence[pulumi.Input[Union['IdMappingWorkflowOutputSourceArgs', 'IdMappingWorkflowOutputSourceArgsDict']]]] output_source_config: A list of `IdMappingWorkflowOutputSource` objects, each of which contains fields `OutputS3Path` and `Output` .
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of the IAM role. AWS Entity Resolution assumes this role to create resources on your behalf as part of workflow execution.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags used to organize, track, or control access for this resource.
        :param pulumi.Input[builtins.str] workflow_name: The name of the IdMappingWorkflow
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IdMappingWorkflowArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        IdMappingWorkflow defined in AWS Entity Resolution service

        :param str resource_name: The name of the resource.
        :param IdMappingWorkflowArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IdMappingWorkflowArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 id_mapping_techniques: Optional[pulumi.Input[Union['IdMappingWorkflowIdMappingTechniquesArgs', 'IdMappingWorkflowIdMappingTechniquesArgsDict']]] = None,
                 input_source_config: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IdMappingWorkflowInputSourceArgs', 'IdMappingWorkflowInputSourceArgsDict']]]]] = None,
                 output_source_config: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IdMappingWorkflowOutputSourceArgs', 'IdMappingWorkflowOutputSourceArgsDict']]]]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 workflow_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IdMappingWorkflowArgs.__new__(IdMappingWorkflowArgs)

            __props__.__dict__["description"] = description
            if id_mapping_techniques is None and not opts.urn:
                raise TypeError("Missing required property 'id_mapping_techniques'")
            __props__.__dict__["id_mapping_techniques"] = id_mapping_techniques
            if input_source_config is None and not opts.urn:
                raise TypeError("Missing required property 'input_source_config'")
            __props__.__dict__["input_source_config"] = input_source_config
            __props__.__dict__["output_source_config"] = output_source_config
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["workflow_name"] = workflow_name
            __props__.__dict__["created_at"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["workflow_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["workflowName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(IdMappingWorkflow, __self__).__init__(
            'aws-native:entityresolution:IdMappingWorkflow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'IdMappingWorkflow':
        """
        Get an existing IdMappingWorkflow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = IdMappingWorkflowArgs.__new__(IdMappingWorkflowArgs)

        __props__.__dict__["created_at"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["id_mapping_techniques"] = None
        __props__.__dict__["input_source_config"] = None
        __props__.__dict__["output_source_config"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["updated_at"] = None
        __props__.__dict__["workflow_arn"] = None
        __props__.__dict__["workflow_name"] = None
        return IdMappingWorkflow(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the IdMappingWorkflow
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="idMappingTechniques")
    def id_mapping_techniques(self) -> pulumi.Output['outputs.IdMappingWorkflowIdMappingTechniques']:
        """
        An object which defines the ID mapping technique and any additional configurations.
        """
        return pulumi.get(self, "id_mapping_techniques")

    @property
    @pulumi.getter(name="inputSourceConfig")
    def input_source_config(self) -> pulumi.Output[Sequence['outputs.IdMappingWorkflowInputSource']]:
        """
        A list of `InputSource` objects, which have the fields `InputSourceARN` and `SchemaName` .
        """
        return pulumi.get(self, "input_source_config")

    @property
    @pulumi.getter(name="outputSourceConfig")
    def output_source_config(self) -> pulumi.Output[Optional[Sequence['outputs.IdMappingWorkflowOutputSource']]]:
        """
        A list of `IdMappingWorkflowOutputSource` objects, each of which contains fields `OutputS3Path` and `Output` .
        """
        return pulumi.get(self, "output_source_config")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM role. AWS Entity Resolution assumes this role to create resources on your behalf as part of workflow execution.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags used to organize, track, or control access for this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="workflowArn")
    def workflow_arn(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "workflow_arn")

    @property
    @pulumi.getter(name="workflowName")
    def workflow_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the IdMappingWorkflow
        """
        return pulumi.get(self, "workflow_name")

