# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'StepHadoopJarStepConfig',
    'StepKeyValue',
]

@pulumi.output_type
class StepHadoopJarStepConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mainClass":
            suggest = "main_class"
        elif key == "stepProperties":
            suggest = "step_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StepHadoopJarStepConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StepHadoopJarStepConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StepHadoopJarStepConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 jar: builtins.str,
                 args: Optional[Sequence[builtins.str]] = None,
                 main_class: Optional[builtins.str] = None,
                 step_properties: Optional[Sequence['outputs.StepKeyValue']] = None):
        """
        :param builtins.str jar: A path to a JAR file run during the step.
        :param Sequence[builtins.str] args: A list of command line arguments passed to the JAR file's main function when executed.
        :param builtins.str main_class: The name of the main class in the specified Java file. If not specified, the JAR file should specify a Main-Class in its manifest file.
        :param Sequence['StepKeyValue'] step_properties: A list of Java properties that are set when the step runs. You can use these properties to pass key value pairs to your main function.
        """
        pulumi.set(__self__, "jar", jar)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if main_class is not None:
            pulumi.set(__self__, "main_class", main_class)
        if step_properties is not None:
            pulumi.set(__self__, "step_properties", step_properties)

    @property
    @pulumi.getter
    def jar(self) -> builtins.str:
        """
        A path to a JAR file run during the step.
        """
        return pulumi.get(self, "jar")

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of command line arguments passed to the JAR file's main function when executed.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> Optional[builtins.str]:
        """
        The name of the main class in the specified Java file. If not specified, the JAR file should specify a Main-Class in its manifest file.
        """
        return pulumi.get(self, "main_class")

    @property
    @pulumi.getter(name="stepProperties")
    def step_properties(self) -> Optional[Sequence['outputs.StepKeyValue']]:
        """
        A list of Java properties that are set when the step runs. You can use these properties to pass key value pairs to your main function.
        """
        return pulumi.get(self, "step_properties")


@pulumi.output_type
class StepKeyValue(dict):
    def __init__(__self__, *,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str key: The unique identifier of a key-value pair.
        :param builtins.str value: The value part of the identified key.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        The unique identifier of a key-value pair.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The value part of the identified key.
        """
        return pulumi.get(self, "value")


