# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'GetStudioSessionMappingResult',
    'AwaitableGetStudioSessionMappingResult',
    'get_studio_session_mapping',
    'get_studio_session_mapping_output',
]

@pulumi.output_type
class GetStudioSessionMappingResult:
    def __init__(__self__, session_policy_arn=None):
        if session_policy_arn and not isinstance(session_policy_arn, str):
            raise TypeError("Expected argument 'session_policy_arn' to be a str")
        pulumi.set(__self__, "session_policy_arn", session_policy_arn)

    @property
    @pulumi.getter(name="sessionPolicyArn")
    def session_policy_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) for the session policy that will be applied to the user or group. Session policies refine Studio user permissions without the need to use multiple IAM user roles.
        """
        return pulumi.get(self, "session_policy_arn")


class AwaitableGetStudioSessionMappingResult(GetStudioSessionMappingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStudioSessionMappingResult(
            session_policy_arn=self.session_policy_arn)


def get_studio_session_mapping(identity_name: Optional[builtins.str] = None,
                               identity_type: Optional['StudioSessionMappingIdentityType'] = None,
                               studio_id: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStudioSessionMappingResult:
    """
    An example resource schema demonstrating some basic constructs and validation rules.


    :param builtins.str identity_name: The name of the user or group. For more information, see UserName and DisplayName in the AWS SSO Identity Store API Reference. Either IdentityName or IdentityId must be specified.
    :param 'StudioSessionMappingIdentityType' identity_type: Specifies whether the identity to map to the Studio is a user or a group.
    :param builtins.str studio_id: The ID of the Amazon EMR Studio to which the user or group will be mapped.
    """
    __args__ = dict()
    __args__['identityName'] = identity_name
    __args__['identityType'] = identity_type
    __args__['studioId'] = studio_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:emr:getStudioSessionMapping', __args__, opts=opts, typ=GetStudioSessionMappingResult).value

    return AwaitableGetStudioSessionMappingResult(
        session_policy_arn=pulumi.get(__ret__, 'session_policy_arn'))
def get_studio_session_mapping_output(identity_name: Optional[pulumi.Input[builtins.str]] = None,
                                      identity_type: Optional[pulumi.Input['StudioSessionMappingIdentityType']] = None,
                                      studio_id: Optional[pulumi.Input[builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStudioSessionMappingResult]:
    """
    An example resource schema demonstrating some basic constructs and validation rules.


    :param builtins.str identity_name: The name of the user or group. For more information, see UserName and DisplayName in the AWS SSO Identity Store API Reference. Either IdentityName or IdentityId must be specified.
    :param 'StudioSessionMappingIdentityType' identity_type: Specifies whether the identity to map to the Studio is a user or a group.
    :param builtins.str studio_id: The ID of the Amazon EMR Studio to which the user or group will be mapped.
    """
    __args__ = dict()
    __args__['identityName'] = identity_name
    __args__['identityType'] = identity_type
    __args__['studioId'] = studio_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:emr:getStudioSessionMapping', __args__, opts=opts, typ=GetStudioSessionMappingResult)
    return __ret__.apply(lambda __response__: GetStudioSessionMappingResult(
        session_policy_arn=pulumi.get(__response__, 'session_policy_arn')))
