# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'StepHadoopJarStepConfigArgs',
    'StepHadoopJarStepConfigArgsDict',
    'StepKeyValueArgs',
    'StepKeyValueArgsDict',
]

MYPY = False

if not MYPY:
    class StepHadoopJarStepConfigArgsDict(TypedDict):
        jar: pulumi.Input[builtins.str]
        """
        A path to a JAR file run during the step.
        """
        args: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of command line arguments passed to the JAR file's main function when executed.
        """
        main_class: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the main class in the specified Java file. If not specified, the JAR file should specify a Main-Class in its manifest file.
        """
        step_properties: NotRequired[pulumi.Input[Sequence[pulumi.Input['StepKeyValueArgsDict']]]]
        """
        A list of Java properties that are set when the step runs. You can use these properties to pass key value pairs to your main function.
        """
elif False:
    StepHadoopJarStepConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StepHadoopJarStepConfigArgs:
    def __init__(__self__, *,
                 jar: pulumi.Input[builtins.str],
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 main_class: Optional[pulumi.Input[builtins.str]] = None,
                 step_properties: Optional[pulumi.Input[Sequence[pulumi.Input['StepKeyValueArgs']]]] = None):
        """
        :param pulumi.Input[builtins.str] jar: A path to a JAR file run during the step.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] args: A list of command line arguments passed to the JAR file's main function when executed.
        :param pulumi.Input[builtins.str] main_class: The name of the main class in the specified Java file. If not specified, the JAR file should specify a Main-Class in its manifest file.
        :param pulumi.Input[Sequence[pulumi.Input['StepKeyValueArgs']]] step_properties: A list of Java properties that are set when the step runs. You can use these properties to pass key value pairs to your main function.
        """
        pulumi.set(__self__, "jar", jar)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if main_class is not None:
            pulumi.set(__self__, "main_class", main_class)
        if step_properties is not None:
            pulumi.set(__self__, "step_properties", step_properties)

    @property
    @pulumi.getter
    def jar(self) -> pulumi.Input[builtins.str]:
        """
        A path to a JAR file run during the step.
        """
        return pulumi.get(self, "jar")

    @jar.setter
    def jar(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "jar", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of command line arguments passed to the JAR file's main function when executed.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the main class in the specified Java file. If not specified, the JAR file should specify a Main-Class in its manifest file.
        """
        return pulumi.get(self, "main_class")

    @main_class.setter
    def main_class(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "main_class", value)

    @property
    @pulumi.getter(name="stepProperties")
    def step_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StepKeyValueArgs']]]]:
        """
        A list of Java properties that are set when the step runs. You can use these properties to pass key value pairs to your main function.
        """
        return pulumi.get(self, "step_properties")

    @step_properties.setter
    def step_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StepKeyValueArgs']]]]):
        pulumi.set(self, "step_properties", value)


if not MYPY:
    class StepKeyValueArgsDict(TypedDict):
        key: NotRequired[pulumi.Input[builtins.str]]
        """
        The unique identifier of a key-value pair.
        """
        value: NotRequired[pulumi.Input[builtins.str]]
        """
        The value part of the identified key.
        """
elif False:
    StepKeyValueArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class StepKeyValueArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] key: The unique identifier of a key-value pair.
        :param pulumi.Input[builtins.str] value: The value part of the identified key.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier of a key-value pair.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value part of the identified key.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


