# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ListenerArgs', 'Listener']

@pulumi.input_type
class ListenerArgs:
    def __init__(__self__, *,
                 default_actions: pulumi.Input[Sequence[pulumi.Input['ListenerActionArgs']]],
                 load_balancer_arn: pulumi.Input[builtins.str],
                 alpn_policy: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerCertificateArgs']]]] = None,
                 listener_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerAttributeArgs']]]] = None,
                 mutual_authentication: Optional[pulumi.Input['ListenerMutualAuthenticationArgs']] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_policy: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Listener resource.
        :param pulumi.Input[Sequence[pulumi.Input['ListenerActionArgs']]] default_actions: The actions for the default rule. You cannot define a condition for a default rule.
                To create additional rules for an Application Load Balancer, use [AWS::ElasticLoadBalancingV2::ListenerRule](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html).
        :param pulumi.Input[builtins.str] load_balancer_arn: The Amazon Resource Name (ARN) of the load balancer.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] alpn_policy: [TLS listener] The name of the Application-Layer Protocol Negotiation (ALPN) policy.
        :param pulumi.Input[Sequence[pulumi.Input['ListenerCertificateArgs']]] certificates: The default SSL server certificate for a secure listener. You must provide exactly one certificate if the listener protocol is HTTPS or TLS.
                To create a certificate list for a secure listener, use [AWS::ElasticLoadBalancingV2::ListenerCertificate](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html).
        :param pulumi.Input[Sequence[pulumi.Input['ListenerAttributeArgs']]] listener_attributes: The listener attributes.
        :param pulumi.Input['ListenerMutualAuthenticationArgs'] mutual_authentication: The mutual authentication configuration information.
        :param pulumi.Input[builtins.int] port: The port on which the load balancer is listening. You can't specify a port for a Gateway Load Balancer.
        :param pulumi.Input[builtins.str] protocol: The protocol for connections from clients to the load balancer. For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, and TCP_UDP. You can’t specify the UDP or TCP_UDP protocol if dual-stack mode is enabled. You can't specify a protocol for a Gateway Load Balancer.
        :param pulumi.Input[builtins.str] ssl_policy: [HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported. For more information, see [Security policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/describe-ssl-policies.html) in the *Application Load Balancers Guide* and [Security policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/describe-ssl-policies.html) in the *Network Load Balancers Guide*.
                Updating the security policy can result in interruptions if the load balancer is handling a high volume of traffic. To decrease the possibility of an interruption if your load balancer is handling a high volume of traffic, create an additional load balancer or request an LCU reservation.
        """
        pulumi.set(__self__, "default_actions", default_actions)
        pulumi.set(__self__, "load_balancer_arn", load_balancer_arn)
        if alpn_policy is not None:
            pulumi.set(__self__, "alpn_policy", alpn_policy)
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if listener_attributes is not None:
            pulumi.set(__self__, "listener_attributes", listener_attributes)
        if mutual_authentication is not None:
            pulumi.set(__self__, "mutual_authentication", mutual_authentication)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if ssl_policy is not None:
            pulumi.set(__self__, "ssl_policy", ssl_policy)

    @property
    @pulumi.getter(name="defaultActions")
    def default_actions(self) -> pulumi.Input[Sequence[pulumi.Input['ListenerActionArgs']]]:
        """
        The actions for the default rule. You cannot define a condition for a default rule.
         To create additional rules for an Application Load Balancer, use [AWS::ElasticLoadBalancingV2::ListenerRule](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html).
        """
        return pulumi.get(self, "default_actions")

    @default_actions.setter
    def default_actions(self, value: pulumi.Input[Sequence[pulumi.Input['ListenerActionArgs']]]):
        pulumi.set(self, "default_actions", value)

    @property
    @pulumi.getter(name="loadBalancerArn")
    def load_balancer_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the load balancer.
        """
        return pulumi.get(self, "load_balancer_arn")

    @load_balancer_arn.setter
    def load_balancer_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "load_balancer_arn", value)

    @property
    @pulumi.getter(name="alpnPolicy")
    def alpn_policy(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        [TLS listener] The name of the Application-Layer Protocol Negotiation (ALPN) policy.
        """
        return pulumi.get(self, "alpn_policy")

    @alpn_policy.setter
    def alpn_policy(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "alpn_policy", value)

    @property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ListenerCertificateArgs']]]]:
        """
        The default SSL server certificate for a secure listener. You must provide exactly one certificate if the listener protocol is HTTPS or TLS.
         To create a certificate list for a secure listener, use [AWS::ElasticLoadBalancingV2::ListenerCertificate](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html).
        """
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerCertificateArgs']]]]):
        pulumi.set(self, "certificates", value)

    @property
    @pulumi.getter(name="listenerAttributes")
    def listener_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ListenerAttributeArgs']]]]:
        """
        The listener attributes.
        """
        return pulumi.get(self, "listener_attributes")

    @listener_attributes.setter
    def listener_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerAttributeArgs']]]]):
        pulumi.set(self, "listener_attributes", value)

    @property
    @pulumi.getter(name="mutualAuthentication")
    def mutual_authentication(self) -> Optional[pulumi.Input['ListenerMutualAuthenticationArgs']]:
        """
        The mutual authentication configuration information.
        """
        return pulumi.get(self, "mutual_authentication")

    @mutual_authentication.setter
    def mutual_authentication(self, value: Optional[pulumi.Input['ListenerMutualAuthenticationArgs']]):
        pulumi.set(self, "mutual_authentication", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port on which the load balancer is listening. You can't specify a port for a Gateway Load Balancer.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The protocol for connections from clients to the load balancer. For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, and TCP_UDP. You can’t specify the UDP or TCP_UDP protocol if dual-stack mode is enabled. You can't specify a protocol for a Gateway Load Balancer.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="sslPolicy")
    def ssl_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        [HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported. For more information, see [Security policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/describe-ssl-policies.html) in the *Application Load Balancers Guide* and [Security policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/describe-ssl-policies.html) in the *Network Load Balancers Guide*.
         Updating the security policy can result in interruptions if the load balancer is handling a high volume of traffic. To decrease the possibility of an interruption if your load balancer is handling a high volume of traffic, create an additional load balancer or request an LCU reservation.
        """
        return pulumi.get(self, "ssl_policy")

    @ssl_policy.setter
    def ssl_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_policy", value)


@pulumi.type_token("aws-native:elasticloadbalancingv2:Listener")
class Listener(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alpn_policy: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListenerCertificateArgs', 'ListenerCertificateArgsDict']]]]] = None,
                 default_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListenerActionArgs', 'ListenerActionArgsDict']]]]] = None,
                 listener_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListenerAttributeArgs', 'ListenerAttributeArgsDict']]]]] = None,
                 load_balancer_arn: Optional[pulumi.Input[builtins.str]] = None,
                 mutual_authentication: Optional[pulumi.Input[Union['ListenerMutualAuthenticationArgs', 'ListenerMutualAuthenticationArgsDict']]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_policy: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Specifies a listener for an Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] alpn_policy: [TLS listener] The name of the Application-Layer Protocol Negotiation (ALPN) policy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ListenerCertificateArgs', 'ListenerCertificateArgsDict']]]] certificates: The default SSL server certificate for a secure listener. You must provide exactly one certificate if the listener protocol is HTTPS or TLS.
                To create a certificate list for a secure listener, use [AWS::ElasticLoadBalancingV2::ListenerCertificate](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html).
        :param pulumi.Input[Sequence[pulumi.Input[Union['ListenerActionArgs', 'ListenerActionArgsDict']]]] default_actions: The actions for the default rule. You cannot define a condition for a default rule.
                To create additional rules for an Application Load Balancer, use [AWS::ElasticLoadBalancingV2::ListenerRule](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html).
        :param pulumi.Input[Sequence[pulumi.Input[Union['ListenerAttributeArgs', 'ListenerAttributeArgsDict']]]] listener_attributes: The listener attributes.
        :param pulumi.Input[builtins.str] load_balancer_arn: The Amazon Resource Name (ARN) of the load balancer.
        :param pulumi.Input[Union['ListenerMutualAuthenticationArgs', 'ListenerMutualAuthenticationArgsDict']] mutual_authentication: The mutual authentication configuration information.
        :param pulumi.Input[builtins.int] port: The port on which the load balancer is listening. You can't specify a port for a Gateway Load Balancer.
        :param pulumi.Input[builtins.str] protocol: The protocol for connections from clients to the load balancer. For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, and TCP_UDP. You can’t specify the UDP or TCP_UDP protocol if dual-stack mode is enabled. You can't specify a protocol for a Gateway Load Balancer.
        :param pulumi.Input[builtins.str] ssl_policy: [HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported. For more information, see [Security policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/describe-ssl-policies.html) in the *Application Load Balancers Guide* and [Security policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/describe-ssl-policies.html) in the *Network Load Balancers Guide*.
                Updating the security policy can result in interruptions if the load balancer is handling a high volume of traffic. To decrease the possibility of an interruption if your load balancer is handling a high volume of traffic, create an additional load balancer or request an LCU reservation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListenerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Specifies a listener for an Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.

        :param str resource_name: The name of the resource.
        :param ListenerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListenerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alpn_policy: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListenerCertificateArgs', 'ListenerCertificateArgsDict']]]]] = None,
                 default_actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListenerActionArgs', 'ListenerActionArgsDict']]]]] = None,
                 listener_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ListenerAttributeArgs', 'ListenerAttributeArgsDict']]]]] = None,
                 load_balancer_arn: Optional[pulumi.Input[builtins.str]] = None,
                 mutual_authentication: Optional[pulumi.Input[Union['ListenerMutualAuthenticationArgs', 'ListenerMutualAuthenticationArgsDict']]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_policy: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListenerArgs.__new__(ListenerArgs)

            __props__.__dict__["alpn_policy"] = alpn_policy
            __props__.__dict__["certificates"] = certificates
            if default_actions is None and not opts.urn:
                raise TypeError("Missing required property 'default_actions'")
            __props__.__dict__["default_actions"] = default_actions
            __props__.__dict__["listener_attributes"] = listener_attributes
            if load_balancer_arn is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer_arn'")
            __props__.__dict__["load_balancer_arn"] = load_balancer_arn
            __props__.__dict__["mutual_authentication"] = mutual_authentication
            __props__.__dict__["port"] = port
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["ssl_policy"] = ssl_policy
            __props__.__dict__["listener_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["loadBalancerArn"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Listener, __self__).__init__(
            'aws-native:elasticloadbalancingv2:Listener',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Listener':
        """
        Get an existing Listener resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ListenerArgs.__new__(ListenerArgs)

        __props__.__dict__["alpn_policy"] = None
        __props__.__dict__["certificates"] = None
        __props__.__dict__["default_actions"] = None
        __props__.__dict__["listener_arn"] = None
        __props__.__dict__["listener_attributes"] = None
        __props__.__dict__["load_balancer_arn"] = None
        __props__.__dict__["mutual_authentication"] = None
        __props__.__dict__["port"] = None
        __props__.__dict__["protocol"] = None
        __props__.__dict__["ssl_policy"] = None
        return Listener(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alpnPolicy")
    def alpn_policy(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        [TLS listener] The name of the Application-Layer Protocol Negotiation (ALPN) policy.
        """
        return pulumi.get(self, "alpn_policy")

    @property
    @pulumi.getter
    def certificates(self) -> pulumi.Output[Optional[Sequence['outputs.ListenerCertificate']]]:
        """
        The default SSL server certificate for a secure listener. You must provide exactly one certificate if the listener protocol is HTTPS or TLS.
         To create a certificate list for a secure listener, use [AWS::ElasticLoadBalancingV2::ListenerCertificate](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html).
        """
        return pulumi.get(self, "certificates")

    @property
    @pulumi.getter(name="defaultActions")
    def default_actions(self) -> pulumi.Output[Sequence['outputs.ListenerAction']]:
        """
        The actions for the default rule. You cannot define a condition for a default rule.
         To create additional rules for an Application Load Balancer, use [AWS::ElasticLoadBalancingV2::ListenerRule](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html).
        """
        return pulumi.get(self, "default_actions")

    @property
    @pulumi.getter(name="listenerArn")
    def listener_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the listener.
        """
        return pulumi.get(self, "listener_arn")

    @property
    @pulumi.getter(name="listenerAttributes")
    def listener_attributes(self) -> pulumi.Output[Optional[Sequence['outputs.ListenerAttribute']]]:
        """
        The listener attributes.
        """
        return pulumi.get(self, "listener_attributes")

    @property
    @pulumi.getter(name="loadBalancerArn")
    def load_balancer_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the load balancer.
        """
        return pulumi.get(self, "load_balancer_arn")

    @property
    @pulumi.getter(name="mutualAuthentication")
    def mutual_authentication(self) -> pulumi.Output[Optional['outputs.ListenerMutualAuthentication']]:
        """
        The mutual authentication configuration information.
        """
        return pulumi.get(self, "mutual_authentication")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The port on which the load balancer is listening. You can't specify a port for a Gateway Load Balancer.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The protocol for connections from clients to the load balancer. For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, and TCP_UDP. You can’t specify the UDP or TCP_UDP protocol if dual-stack mode is enabled. You can't specify a protocol for a Gateway Load Balancer.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="sslPolicy")
    def ssl_policy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        [HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported. For more information, see [Security policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/describe-ssl-policies.html) in the *Application Load Balancers Guide* and [Security policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/describe-ssl-policies.html) in the *Network Load Balancers Guide*.
         Updating the security policy can result in interruptions if the load balancer is handling a high volume of traffic. To decrease the possibility of an interruption if your load balancer is handling a high volume of traffic, create an additional load balancer or request an LCU reservation.
        """
        return pulumi.get(self, "ssl_policy")

