# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTrustStoreRevocationResult',
    'AwaitableGetTrustStoreRevocationResult',
    'get_trust_store_revocation',
    'get_trust_store_revocation_output',
]

@pulumi.output_type
class GetTrustStoreRevocationResult:
    def __init__(__self__, revocation_id=None, trust_store_revocations=None):
        if revocation_id and not isinstance(revocation_id, int):
            raise TypeError("Expected argument 'revocation_id' to be a int")
        pulumi.set(__self__, "revocation_id", revocation_id)
        if trust_store_revocations and not isinstance(trust_store_revocations, list):
            raise TypeError("Expected argument 'trust_store_revocations' to be a list")
        pulumi.set(__self__, "trust_store_revocations", trust_store_revocations)

    @property
    @pulumi.getter(name="revocationId")
    def revocation_id(self) -> Optional[builtins.int]:
        """
        The ID associated with the revocation.
        """
        return pulumi.get(self, "revocation_id")

    @property
    @pulumi.getter(name="trustStoreRevocations")
    def trust_store_revocations(self) -> Optional[Sequence['outputs.TrustStoreRevocation']]:
        """
        The data associated with a trust store revocation
        """
        return pulumi.get(self, "trust_store_revocations")


class AwaitableGetTrustStoreRevocationResult(GetTrustStoreRevocationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTrustStoreRevocationResult(
            revocation_id=self.revocation_id,
            trust_store_revocations=self.trust_store_revocations)


def get_trust_store_revocation(revocation_id: Optional[builtins.int] = None,
                               trust_store_arn: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTrustStoreRevocationResult:
    """
    Resource Type definition for AWS::ElasticLoadBalancingV2::TrustStoreRevocation


    :param builtins.int revocation_id: The ID associated with the revocation.
    :param builtins.str trust_store_arn: The Amazon Resource Name (ARN) of the trust store.
    """
    __args__ = dict()
    __args__['revocationId'] = revocation_id
    __args__['trustStoreArn'] = trust_store_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:elasticloadbalancingv2:getTrustStoreRevocation', __args__, opts=opts, typ=GetTrustStoreRevocationResult).value

    return AwaitableGetTrustStoreRevocationResult(
        revocation_id=pulumi.get(__ret__, 'revocation_id'),
        trust_store_revocations=pulumi.get(__ret__, 'trust_store_revocations'))
def get_trust_store_revocation_output(revocation_id: Optional[pulumi.Input[builtins.int]] = None,
                                      trust_store_arn: Optional[pulumi.Input[builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTrustStoreRevocationResult]:
    """
    Resource Type definition for AWS::ElasticLoadBalancingV2::TrustStoreRevocation


    :param builtins.int revocation_id: The ID associated with the revocation.
    :param builtins.str trust_store_arn: The Amazon Resource Name (ARN) of the trust store.
    """
    __args__ = dict()
    __args__['revocationId'] = revocation_id
    __args__['trustStoreArn'] = trust_store_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:elasticloadbalancingv2:getTrustStoreRevocation', __args__, opts=opts, typ=GetTrustStoreRevocationResult)
    return __ret__.apply(lambda __response__: GetTrustStoreRevocationResult(
        revocation_id=pulumi.get(__response__, 'revocation_id'),
        trust_store_revocations=pulumi.get(__response__, 'trust_store_revocations')))
