# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetLoadBalancerResult',
    'AwaitableGetLoadBalancerResult',
    'get_load_balancer',
    'get_load_balancer_output',
]

@pulumi.output_type
class GetLoadBalancerResult:
    def __init__(__self__, canonical_hosted_zone_id=None, dns_name=None, enable_prefix_for_ipv6_source_nat=None, enforce_security_group_inbound_rules_on_private_link_traffic=None, ip_address_type=None, ipv4_ipam_pool_id=None, load_balancer_arn=None, load_balancer_attributes=None, load_balancer_full_name=None, load_balancer_name=None, minimum_load_balancer_capacity=None, security_groups=None, subnet_mappings=None, subnets=None, tags=None):
        if canonical_hosted_zone_id and not isinstance(canonical_hosted_zone_id, str):
            raise TypeError("Expected argument 'canonical_hosted_zone_id' to be a str")
        pulumi.set(__self__, "canonical_hosted_zone_id", canonical_hosted_zone_id)
        if dns_name and not isinstance(dns_name, str):
            raise TypeError("Expected argument 'dns_name' to be a str")
        pulumi.set(__self__, "dns_name", dns_name)
        if enable_prefix_for_ipv6_source_nat and not isinstance(enable_prefix_for_ipv6_source_nat, str):
            raise TypeError("Expected argument 'enable_prefix_for_ipv6_source_nat' to be a str")
        pulumi.set(__self__, "enable_prefix_for_ipv6_source_nat", enable_prefix_for_ipv6_source_nat)
        if enforce_security_group_inbound_rules_on_private_link_traffic and not isinstance(enforce_security_group_inbound_rules_on_private_link_traffic, str):
            raise TypeError("Expected argument 'enforce_security_group_inbound_rules_on_private_link_traffic' to be a str")
        pulumi.set(__self__, "enforce_security_group_inbound_rules_on_private_link_traffic", enforce_security_group_inbound_rules_on_private_link_traffic)
        if ip_address_type and not isinstance(ip_address_type, str):
            raise TypeError("Expected argument 'ip_address_type' to be a str")
        pulumi.set(__self__, "ip_address_type", ip_address_type)
        if ipv4_ipam_pool_id and not isinstance(ipv4_ipam_pool_id, str):
            raise TypeError("Expected argument 'ipv4_ipam_pool_id' to be a str")
        pulumi.set(__self__, "ipv4_ipam_pool_id", ipv4_ipam_pool_id)
        if load_balancer_arn and not isinstance(load_balancer_arn, str):
            raise TypeError("Expected argument 'load_balancer_arn' to be a str")
        pulumi.set(__self__, "load_balancer_arn", load_balancer_arn)
        if load_balancer_attributes and not isinstance(load_balancer_attributes, list):
            raise TypeError("Expected argument 'load_balancer_attributes' to be a list")
        pulumi.set(__self__, "load_balancer_attributes", load_balancer_attributes)
        if load_balancer_full_name and not isinstance(load_balancer_full_name, str):
            raise TypeError("Expected argument 'load_balancer_full_name' to be a str")
        pulumi.set(__self__, "load_balancer_full_name", load_balancer_full_name)
        if load_balancer_name and not isinstance(load_balancer_name, str):
            raise TypeError("Expected argument 'load_balancer_name' to be a str")
        pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        if minimum_load_balancer_capacity and not isinstance(minimum_load_balancer_capacity, dict):
            raise TypeError("Expected argument 'minimum_load_balancer_capacity' to be a dict")
        pulumi.set(__self__, "minimum_load_balancer_capacity", minimum_load_balancer_capacity)
        if security_groups and not isinstance(security_groups, list):
            raise TypeError("Expected argument 'security_groups' to be a list")
        pulumi.set(__self__, "security_groups", security_groups)
        if subnet_mappings and not isinstance(subnet_mappings, list):
            raise TypeError("Expected argument 'subnet_mappings' to be a list")
        pulumi.set(__self__, "subnet_mappings", subnet_mappings)
        if subnets and not isinstance(subnets, list):
            raise TypeError("Expected argument 'subnets' to be a list")
        pulumi.set(__self__, "subnets", subnets)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="canonicalHostedZoneId")
    def canonical_hosted_zone_id(self) -> Optional[builtins.str]:
        """
        The ID of the Amazon Route 53 hosted zone associated with the load balancer. For example, `Z2P70J7EXAMPLE` .
        """
        return pulumi.get(self, "canonical_hosted_zone_id")

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[builtins.str]:
        """
        The DNS name for the load balancer. For example, `my-load-balancer-424835706.us-west-2.elb.amazonaws.com` .
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="enablePrefixForIpv6SourceNat")
    def enable_prefix_for_ipv6_source_nat(self) -> Optional[builtins.str]:
        """
        [Network Load Balancers with UDP listeners] Indicates whether to use an IPv6 prefix from each subnet for source NAT. The IP address type must be ``dualstack``. The default value is ``off``.
        """
        return pulumi.get(self, "enable_prefix_for_ipv6_source_nat")

    @property
    @pulumi.getter(name="enforceSecurityGroupInboundRulesOnPrivateLinkTraffic")
    def enforce_security_group_inbound_rules_on_private_link_traffic(self) -> Optional[builtins.str]:
        """
        Indicates whether to evaluate inbound security group rules for traffic sent to a Network Load Balancer through privatelink. The default is ``on``.
         You can't configure this property on a Network Load Balancer unless you associated a security group with the load balancer when you created it.
        """
        return pulumi.get(self, "enforce_security_group_inbound_rules_on_private_link_traffic")

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[builtins.str]:
        """
        The IP address type. Internal load balancers must use ``ipv4``.
         [Application Load Balancers] The possible values are ``ipv4`` (IPv4 addresses), ``dualstack`` (IPv4 and IPv6 addresses), and ``dualstack-without-public-ipv4`` (public IPv6 addresses and private IPv4 and IPv6 addresses).
         Application Load Balancer authentication supports IPv4 addresses only when connecting to an Identity Provider (IdP) or Amazon Cognito endpoint. Without a public IPv4 address the load balancer can't complete the authentication process, resulting in HTTP 500 errors.
         [Network Load Balancers and Gateway Load Balancers] The possible values are ``ipv4`` (IPv4 addresses) and ``dualstack`` (IPv4 and IPv6 addresses).
        """
        return pulumi.get(self, "ip_address_type")

    @property
    @pulumi.getter(name="ipv4IpamPoolId")
    def ipv4_ipam_pool_id(self) -> Optional[builtins.str]:
        """
        The ID of the IPv4 IPAM pool.
        """
        return pulumi.get(self, "ipv4_ipam_pool_id")

    @property
    @pulumi.getter(name="loadBalancerArn")
    def load_balancer_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the load balancer.
        """
        return pulumi.get(self, "load_balancer_arn")

    @property
    @pulumi.getter(name="loadBalancerAttributes")
    def load_balancer_attributes(self) -> Optional[Sequence['outputs.LoadBalancerAttribute']]:
        """
        The load balancer attributes.
        """
        return pulumi.get(self, "load_balancer_attributes")

    @property
    @pulumi.getter(name="loadBalancerFullName")
    def load_balancer_full_name(self) -> Optional[builtins.str]:
        """
        The full name of the load balancer. For example, `app/my-load-balancer/50dc6c495c0c9188` .
        """
        return pulumi.get(self, "load_balancer_full_name")

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> Optional[builtins.str]:
        """
        The name of the load balancer. For example, `my-load-balancer` .
        """
        return pulumi.get(self, "load_balancer_name")

    @property
    @pulumi.getter(name="minimumLoadBalancerCapacity")
    def minimum_load_balancer_capacity(self) -> Optional['outputs.LoadBalancerMinimumLoadBalancerCapacity']:
        """
        The minimum capacity for a load balancer.
        """
        return pulumi.get(self, "minimum_load_balancer_capacity")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[builtins.str]]:
        """
        [Application Load Balancers and Network Load Balancers] The IDs of the security groups for the load balancer.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter(name="subnetMappings")
    def subnet_mappings(self) -> Optional[Sequence['outputs.LoadBalancerSubnetMapping']]:
        """
        The IDs of the subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings, but not both.
         [Application Load Balancers] You must specify subnets from at least two Availability Zones. You can't specify Elastic IP addresses for your subnets.
         [Application Load Balancers on Outposts] You must specify one Outpost subnet.
         [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
         [Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify one Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you can specify one IPv6 address per subnet.
         [Gateway Load Balancers] You can specify subnets from one or more Availability Zones. You can't specify Elastic IP addresses for your subnets.
        """
        return pulumi.get(self, "subnet_mappings")

    @property
    @pulumi.getter
    def subnets(self) -> Optional[Sequence[builtins.str]]:
        """
        The IDs of the subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings, but not both. To specify an Elastic IP address, specify subnet mappings instead of subnets.
         [Application Load Balancers] You must specify subnets from at least two Availability Zones.
         [Application Load Balancers on Outposts] You must specify one Outpost subnet.
         [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
         [Network Load Balancers and Gateway Load Balancers] You can specify subnets from one or more Availability Zones.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags to assign to the load balancer.
        """
        return pulumi.get(self, "tags")


class AwaitableGetLoadBalancerResult(GetLoadBalancerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLoadBalancerResult(
            canonical_hosted_zone_id=self.canonical_hosted_zone_id,
            dns_name=self.dns_name,
            enable_prefix_for_ipv6_source_nat=self.enable_prefix_for_ipv6_source_nat,
            enforce_security_group_inbound_rules_on_private_link_traffic=self.enforce_security_group_inbound_rules_on_private_link_traffic,
            ip_address_type=self.ip_address_type,
            ipv4_ipam_pool_id=self.ipv4_ipam_pool_id,
            load_balancer_arn=self.load_balancer_arn,
            load_balancer_attributes=self.load_balancer_attributes,
            load_balancer_full_name=self.load_balancer_full_name,
            load_balancer_name=self.load_balancer_name,
            minimum_load_balancer_capacity=self.minimum_load_balancer_capacity,
            security_groups=self.security_groups,
            subnet_mappings=self.subnet_mappings,
            subnets=self.subnets,
            tags=self.tags)


def get_load_balancer(load_balancer_arn: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLoadBalancerResult:
    """
    Specifies an Application Load Balancer, a Network Load Balancer, or a Gateway Load Balancer.


    :param builtins.str load_balancer_arn: The Amazon Resource Name (ARN) of the load balancer.
    """
    __args__ = dict()
    __args__['loadBalancerArn'] = load_balancer_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:elasticloadbalancingv2:getLoadBalancer', __args__, opts=opts, typ=GetLoadBalancerResult).value

    return AwaitableGetLoadBalancerResult(
        canonical_hosted_zone_id=pulumi.get(__ret__, 'canonical_hosted_zone_id'),
        dns_name=pulumi.get(__ret__, 'dns_name'),
        enable_prefix_for_ipv6_source_nat=pulumi.get(__ret__, 'enable_prefix_for_ipv6_source_nat'),
        enforce_security_group_inbound_rules_on_private_link_traffic=pulumi.get(__ret__, 'enforce_security_group_inbound_rules_on_private_link_traffic'),
        ip_address_type=pulumi.get(__ret__, 'ip_address_type'),
        ipv4_ipam_pool_id=pulumi.get(__ret__, 'ipv4_ipam_pool_id'),
        load_balancer_arn=pulumi.get(__ret__, 'load_balancer_arn'),
        load_balancer_attributes=pulumi.get(__ret__, 'load_balancer_attributes'),
        load_balancer_full_name=pulumi.get(__ret__, 'load_balancer_full_name'),
        load_balancer_name=pulumi.get(__ret__, 'load_balancer_name'),
        minimum_load_balancer_capacity=pulumi.get(__ret__, 'minimum_load_balancer_capacity'),
        security_groups=pulumi.get(__ret__, 'security_groups'),
        subnet_mappings=pulumi.get(__ret__, 'subnet_mappings'),
        subnets=pulumi.get(__ret__, 'subnets'),
        tags=pulumi.get(__ret__, 'tags'))
def get_load_balancer_output(load_balancer_arn: Optional[pulumi.Input[builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLoadBalancerResult]:
    """
    Specifies an Application Load Balancer, a Network Load Balancer, or a Gateway Load Balancer.


    :param builtins.str load_balancer_arn: The Amazon Resource Name (ARN) of the load balancer.
    """
    __args__ = dict()
    __args__['loadBalancerArn'] = load_balancer_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:elasticloadbalancingv2:getLoadBalancer', __args__, opts=opts, typ=GetLoadBalancerResult)
    return __ret__.apply(lambda __response__: GetLoadBalancerResult(
        canonical_hosted_zone_id=pulumi.get(__response__, 'canonical_hosted_zone_id'),
        dns_name=pulumi.get(__response__, 'dns_name'),
        enable_prefix_for_ipv6_source_nat=pulumi.get(__response__, 'enable_prefix_for_ipv6_source_nat'),
        enforce_security_group_inbound_rules_on_private_link_traffic=pulumi.get(__response__, 'enforce_security_group_inbound_rules_on_private_link_traffic'),
        ip_address_type=pulumi.get(__response__, 'ip_address_type'),
        ipv4_ipam_pool_id=pulumi.get(__response__, 'ipv4_ipam_pool_id'),
        load_balancer_arn=pulumi.get(__response__, 'load_balancer_arn'),
        load_balancer_attributes=pulumi.get(__response__, 'load_balancer_attributes'),
        load_balancer_full_name=pulumi.get(__response__, 'load_balancer_full_name'),
        load_balancer_name=pulumi.get(__response__, 'load_balancer_name'),
        minimum_load_balancer_capacity=pulumi.get(__response__, 'minimum_load_balancer_capacity'),
        security_groups=pulumi.get(__response__, 'security_groups'),
        subnet_mappings=pulumi.get(__response__, 'subnet_mappings'),
        subnets=pulumi.get(__response__, 'subnets'),
        tags=pulumi.get(__response__, 'tags')))
