# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ListenerActionArgs',
    'ListenerActionArgsDict',
    'ListenerAttributeArgs',
    'ListenerAttributeArgsDict',
    'ListenerAuthenticateCognitoConfigArgs',
    'ListenerAuthenticateCognitoConfigArgsDict',
    'ListenerAuthenticateOidcConfigArgs',
    'ListenerAuthenticateOidcConfigArgsDict',
    'ListenerCertificateArgs',
    'ListenerCertificateArgsDict',
    'ListenerFixedResponseConfigArgs',
    'ListenerFixedResponseConfigArgsDict',
    'ListenerForwardConfigArgs',
    'ListenerForwardConfigArgsDict',
    'ListenerMutualAuthenticationArgs',
    'ListenerMutualAuthenticationArgsDict',
    'ListenerRedirectConfigArgs',
    'ListenerRedirectConfigArgsDict',
    'ListenerRuleActionArgs',
    'ListenerRuleActionArgsDict',
    'ListenerRuleAuthenticateCognitoConfigArgs',
    'ListenerRuleAuthenticateCognitoConfigArgsDict',
    'ListenerRuleAuthenticateOidcConfigArgs',
    'ListenerRuleAuthenticateOidcConfigArgsDict',
    'ListenerRuleFixedResponseConfigArgs',
    'ListenerRuleFixedResponseConfigArgsDict',
    'ListenerRuleForwardConfigArgs',
    'ListenerRuleForwardConfigArgsDict',
    'ListenerRuleHostHeaderConfigArgs',
    'ListenerRuleHostHeaderConfigArgsDict',
    'ListenerRuleHttpHeaderConfigArgs',
    'ListenerRuleHttpHeaderConfigArgsDict',
    'ListenerRuleHttpRequestMethodConfigArgs',
    'ListenerRuleHttpRequestMethodConfigArgsDict',
    'ListenerRulePathPatternConfigArgs',
    'ListenerRulePathPatternConfigArgsDict',
    'ListenerRuleQueryStringConfigArgs',
    'ListenerRuleQueryStringConfigArgsDict',
    'ListenerRuleQueryStringKeyValueArgs',
    'ListenerRuleQueryStringKeyValueArgsDict',
    'ListenerRuleRedirectConfigArgs',
    'ListenerRuleRedirectConfigArgsDict',
    'ListenerRuleRuleConditionArgs',
    'ListenerRuleRuleConditionArgsDict',
    'ListenerRuleSourceIpConfigArgs',
    'ListenerRuleSourceIpConfigArgsDict',
    'ListenerRuleTargetGroupStickinessConfigArgs',
    'ListenerRuleTargetGroupStickinessConfigArgsDict',
    'ListenerRuleTargetGroupTupleArgs',
    'ListenerRuleTargetGroupTupleArgsDict',
    'ListenerTargetGroupStickinessConfigArgs',
    'ListenerTargetGroupStickinessConfigArgsDict',
    'ListenerTargetGroupTupleArgs',
    'ListenerTargetGroupTupleArgsDict',
    'LoadBalancerAttributeArgs',
    'LoadBalancerAttributeArgsDict',
    'LoadBalancerMinimumLoadBalancerCapacityArgs',
    'LoadBalancerMinimumLoadBalancerCapacityArgsDict',
    'LoadBalancerSubnetMappingArgs',
    'LoadBalancerSubnetMappingArgsDict',
    'TargetGroupAttributeArgs',
    'TargetGroupAttributeArgsDict',
    'TargetGroupMatcherArgs',
    'TargetGroupMatcherArgsDict',
    'TargetGroupTargetDescriptionArgs',
    'TargetGroupTargetDescriptionArgsDict',
    'TrustStoreRevocationRevocationContentArgs',
    'TrustStoreRevocationRevocationContentArgsDict',
]

MYPY = False

if not MYPY:
    class ListenerActionArgsDict(TypedDict):
        """
        Specifies an action for a listener rule.
        """
        type: pulumi.Input[builtins.str]
        """
        The type of action.
        """
        authenticate_cognito_config: NotRequired[pulumi.Input['ListenerAuthenticateCognitoConfigArgsDict']]
        """
        [HTTPS listeners] Information for using Amazon Cognito to authenticate users. Specify only when ``Type`` is ``authenticate-cognito``.
        """
        authenticate_oidc_config: NotRequired[pulumi.Input['ListenerAuthenticateOidcConfigArgsDict']]
        """
        [HTTPS listeners] Information about an identity provider that is compliant with OpenID Connect (OIDC). Specify only when ``Type`` is ``authenticate-oidc``.
        """
        fixed_response_config: NotRequired[pulumi.Input['ListenerFixedResponseConfigArgsDict']]
        """
        [Application Load Balancer] Information for creating an action that returns a custom HTTP response. Specify only when ``Type`` is ``fixed-response``.
        """
        forward_config: NotRequired[pulumi.Input['ListenerForwardConfigArgsDict']]
        """
        Information for creating an action that distributes requests among one or more target groups. For Network Load Balancers, you can specify a single target group. Specify only when ``Type`` is ``forward``. If you specify both ``ForwardConfig`` and ``TargetGroupArn``, you can specify only one target group using ``ForwardConfig`` and it must be the same target group specified in ``TargetGroupArn``.
        """
        order: NotRequired[pulumi.Input[builtins.int]]
        """
        The order for the action. This value is required for rules with multiple actions. The action with the lowest value for order is performed first.
        """
        redirect_config: NotRequired[pulumi.Input['ListenerRedirectConfigArgsDict']]
        """
        [Application Load Balancer] Information for creating a redirect action. Specify only when ``Type`` is ``redirect``.
        """
        target_group_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) of the target group. Specify only when ``Type`` is ``forward`` and you want to route to a single target group. To route to one or more target groups, use ``ForwardConfig`` instead.
        """
elif False:
    ListenerActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerActionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 authenticate_cognito_config: Optional[pulumi.Input['ListenerAuthenticateCognitoConfigArgs']] = None,
                 authenticate_oidc_config: Optional[pulumi.Input['ListenerAuthenticateOidcConfigArgs']] = None,
                 fixed_response_config: Optional[pulumi.Input['ListenerFixedResponseConfigArgs']] = None,
                 forward_config: Optional[pulumi.Input['ListenerForwardConfigArgs']] = None,
                 order: Optional[pulumi.Input[builtins.int]] = None,
                 redirect_config: Optional[pulumi.Input['ListenerRedirectConfigArgs']] = None,
                 target_group_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        Specifies an action for a listener rule.
        :param pulumi.Input[builtins.str] type: The type of action.
        :param pulumi.Input['ListenerAuthenticateCognitoConfigArgs'] authenticate_cognito_config: [HTTPS listeners] Information for using Amazon Cognito to authenticate users. Specify only when ``Type`` is ``authenticate-cognito``.
        :param pulumi.Input['ListenerAuthenticateOidcConfigArgs'] authenticate_oidc_config: [HTTPS listeners] Information about an identity provider that is compliant with OpenID Connect (OIDC). Specify only when ``Type`` is ``authenticate-oidc``.
        :param pulumi.Input['ListenerFixedResponseConfigArgs'] fixed_response_config: [Application Load Balancer] Information for creating an action that returns a custom HTTP response. Specify only when ``Type`` is ``fixed-response``.
        :param pulumi.Input['ListenerForwardConfigArgs'] forward_config: Information for creating an action that distributes requests among one or more target groups. For Network Load Balancers, you can specify a single target group. Specify only when ``Type`` is ``forward``. If you specify both ``ForwardConfig`` and ``TargetGroupArn``, you can specify only one target group using ``ForwardConfig`` and it must be the same target group specified in ``TargetGroupArn``.
        :param pulumi.Input[builtins.int] order: The order for the action. This value is required for rules with multiple actions. The action with the lowest value for order is performed first.
        :param pulumi.Input['ListenerRedirectConfigArgs'] redirect_config: [Application Load Balancer] Information for creating a redirect action. Specify only when ``Type`` is ``redirect``.
        :param pulumi.Input[builtins.str] target_group_arn: The Amazon Resource Name (ARN) of the target group. Specify only when ``Type`` is ``forward`` and you want to route to a single target group. To route to one or more target groups, use ``ForwardConfig`` instead.
        """
        pulumi.set(__self__, "type", type)
        if authenticate_cognito_config is not None:
            pulumi.set(__self__, "authenticate_cognito_config", authenticate_cognito_config)
        if authenticate_oidc_config is not None:
            pulumi.set(__self__, "authenticate_oidc_config", authenticate_oidc_config)
        if fixed_response_config is not None:
            pulumi.set(__self__, "fixed_response_config", fixed_response_config)
        if forward_config is not None:
            pulumi.set(__self__, "forward_config", forward_config)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if redirect_config is not None:
            pulumi.set(__self__, "redirect_config", redirect_config)
        if target_group_arn is not None:
            pulumi.set(__self__, "target_group_arn", target_group_arn)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of action.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="authenticateCognitoConfig")
    def authenticate_cognito_config(self) -> Optional[pulumi.Input['ListenerAuthenticateCognitoConfigArgs']]:
        """
        [HTTPS listeners] Information for using Amazon Cognito to authenticate users. Specify only when ``Type`` is ``authenticate-cognito``.
        """
        return pulumi.get(self, "authenticate_cognito_config")

    @authenticate_cognito_config.setter
    def authenticate_cognito_config(self, value: Optional[pulumi.Input['ListenerAuthenticateCognitoConfigArgs']]):
        pulumi.set(self, "authenticate_cognito_config", value)

    @property
    @pulumi.getter(name="authenticateOidcConfig")
    def authenticate_oidc_config(self) -> Optional[pulumi.Input['ListenerAuthenticateOidcConfigArgs']]:
        """
        [HTTPS listeners] Information about an identity provider that is compliant with OpenID Connect (OIDC). Specify only when ``Type`` is ``authenticate-oidc``.
        """
        return pulumi.get(self, "authenticate_oidc_config")

    @authenticate_oidc_config.setter
    def authenticate_oidc_config(self, value: Optional[pulumi.Input['ListenerAuthenticateOidcConfigArgs']]):
        pulumi.set(self, "authenticate_oidc_config", value)

    @property
    @pulumi.getter(name="fixedResponseConfig")
    def fixed_response_config(self) -> Optional[pulumi.Input['ListenerFixedResponseConfigArgs']]:
        """
        [Application Load Balancer] Information for creating an action that returns a custom HTTP response. Specify only when ``Type`` is ``fixed-response``.
        """
        return pulumi.get(self, "fixed_response_config")

    @fixed_response_config.setter
    def fixed_response_config(self, value: Optional[pulumi.Input['ListenerFixedResponseConfigArgs']]):
        pulumi.set(self, "fixed_response_config", value)

    @property
    @pulumi.getter(name="forwardConfig")
    def forward_config(self) -> Optional[pulumi.Input['ListenerForwardConfigArgs']]:
        """
        Information for creating an action that distributes requests among one or more target groups. For Network Load Balancers, you can specify a single target group. Specify only when ``Type`` is ``forward``. If you specify both ``ForwardConfig`` and ``TargetGroupArn``, you can specify only one target group using ``ForwardConfig`` and it must be the same target group specified in ``TargetGroupArn``.
        """
        return pulumi.get(self, "forward_config")

    @forward_config.setter
    def forward_config(self, value: Optional[pulumi.Input['ListenerForwardConfigArgs']]):
        pulumi.set(self, "forward_config", value)

    @property
    @pulumi.getter
    def order(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The order for the action. This value is required for rules with multiple actions. The action with the lowest value for order is performed first.
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "order", value)

    @property
    @pulumi.getter(name="redirectConfig")
    def redirect_config(self) -> Optional[pulumi.Input['ListenerRedirectConfigArgs']]:
        """
        [Application Load Balancer] Information for creating a redirect action. Specify only when ``Type`` is ``redirect``.
        """
        return pulumi.get(self, "redirect_config")

    @redirect_config.setter
    def redirect_config(self, value: Optional[pulumi.Input['ListenerRedirectConfigArgs']]):
        pulumi.set(self, "redirect_config", value)

    @property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the target group. Specify only when ``Type`` is ``forward`` and you want to route to a single target group. To route to one or more target groups, use ``ForwardConfig`` instead.
        """
        return pulumi.get(self, "target_group_arn")

    @target_group_arn.setter
    def target_group_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_group_arn", value)


if not MYPY:
    class ListenerAttributeArgsDict(TypedDict):
        """
        Information about a listener attribute.
        """
        key: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the attribute.
         The following attribute is supported by Network Load Balancers, and Gateway Load Balancers.
          +  ``tcp.idle_timeout.seconds`` - The tcp idle timeout value, in seconds. The valid range is 60-6000 seconds. The default is 350 seconds.
          
         The following attributes are only supported by Application Load Balancers.
          +  ``routing.http.request.x_amzn_mtls_clientcert_serial_number.header_name`` - Enables you to modify the header name of the *X-Amzn-Mtls-Clientcert-Serial-Number* HTTP request header.
          +  ``routing.http.request.x_amzn_mtls_clientcert_issuer.header_name`` - Enables you to modify the header name of the *X-Amzn-Mtls-Clientcert-Issuer* HTTP request header.
          +  ``routing.http.request.x_amzn_mtls_clientcert_subject.header_name`` - Enables you to modify the header name of the *X-Amzn-Mtls-Clientcert-Subject* HTTP request header.
          +  ``routing.http.request.x_amzn_mtls_clientcert_validity.header_name`` - Enables you to modify the header name of the *X-Amzn-Mtls-Clientcert-Validity* HTTP request header.
          +  ``routing.http.request.x_amzn_mtls_clientcert_leaf.header_name`` - Enables you to modify the header name of the *X-Amzn-Mtls-Clientcert-Leaf* HTTP request header.
          +  ``routing.http.request.x_amzn_mtls_clientcert.header_name`` - Enables you to modify the header name of the *X-Amzn-Mtls-Clientcert* HTTP request header.
          +  ``routing.http.request.x_amzn_tls_version.header_name`` - Enables you to modify the header name of the *X-Amzn-Tls-Version* HTTP request header.
          +  ``routing.http.request.x_amzn_tls_cipher_suite.header_name`` - Enables you to modify the header name of the *X-Amzn-Tls-Cipher-Suite* HTTP request header.
          +  ``routing.http.response.server.enabled`` - Enables you to allow or remove the HTTP response server header.
          +  ``routing.http.response.strict_transport_security.header_value`` - Informs browsers that the site should only be accessed using HTTPS, and that any future attempts to access it using HTTP should automatically be converted to HTTPS.
          +  ``routing.http.response.access_control_allow_origin.header_value`` - Specifies which origins are allowed to access the server.
          +  ``routing.http.response.access_control_allow_methods.header_value`` - Returns which HTTP methods are allowed when accessing the server from a different origin.
          +  ``routing.http.response.access_control_allow_headers.header_value`` - Specifies which headers can be used during the request.
          +  ``routing.http.response.access_control_allow_credentials.header_value`` - Indicates whether the browser should include credentials such as cookies or authentication when making requests.
          +  ``routing.http.response.access_control_expose_headers.header_value`` - Returns which headers the browser can expose to the requesting client.
          +  ``routing.http.response.access_control_max_age.header_value`` - Specifies how long the results of a preflight request can be cached, in seconds.
          +  ``routing.http.response.content_security_policy.header_value`` - Specifies restrictions enforced by the browser to help minimize the risk of certain types of security threats.
          +  ``routing.http.response.x_content_type_options.header_value`` - Indicates whether the MIME types advertised in the *Content-Type* headers should be followed and not be changed.
          +  ``routing.http.response.x_frame_options.header_value`` - Indicates whether the browser is allowed to render a page in a *frame*, *iframe*, *embed* or *object*.
        """
        value: NotRequired[pulumi.Input[builtins.str]]
        """
        The value of the attribute.
        """
elif False:
    ListenerAttributeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerAttributeArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        Information about a listener attribute.
        :param pulumi.Input[builtins.str] key: The name of the attribute.
                The following attribute is supported by Network Load Balancers, and Gateway Load Balancers.
                 +  ``tcp.idle_timeout.seconds`` - The tcp idle timeout value, in seconds. The valid range is 60-6000 seconds. The default is 350 seconds.
                 
                The following attributes are only supported by Application Load Balancers.
                 +  ``routing.http.request.x_amzn_mtls_clientcert_serial_number.header_name`` - Enables you to modify the header name of the *X-Amzn-Mtls-Clientcert-Serial-Number* HTTP request header.
                 +  ``routing.http.request.x_amzn_mtls_clientcert_issuer.header_name`` - Enables you to modify the header name of the *X-Amzn-Mtls-Clientcert-Issuer* HTTP request header.
                 +  ``routing.http.request.x_amzn_mtls_clientcert_subject.header_name`` - Enables you to modify the header name of the *X-Amzn-Mtls-Clientcert-Subject* HTTP request header.
                 +  ``routing.http.request.x_amzn_mtls_clientcert_validity.header_name`` - Enables you to modify the header name of the *X-Amzn-Mtls-Clientcert-Validity* HTTP request header.
                 +  ``routing.http.request.x_amzn_mtls_clientcert_leaf.header_name`` - Enables you to modify the header name of the *X-Amzn-Mtls-Clientcert-Leaf* HTTP request header.
                 +  ``routing.http.request.x_amzn_mtls_clientcert.header_name`` - Enables you to modify the header name of the *X-Amzn-Mtls-Clientcert* HTTP request header.
                 +  ``routing.http.request.x_amzn_tls_version.header_name`` - Enables you to modify the header name of the *X-Amzn-Tls-Version* HTTP request header.
                 +  ``routing.http.request.x_amzn_tls_cipher_suite.header_name`` - Enables you to modify the header name of the *X-Amzn-Tls-Cipher-Suite* HTTP request header.
                 +  ``routing.http.response.server.enabled`` - Enables you to allow or remove the HTTP response server header.
                 +  ``routing.http.response.strict_transport_security.header_value`` - Informs browsers that the site should only be accessed using HTTPS, and that any future attempts to access it using HTTP should automatically be converted to HTTPS.
                 +  ``routing.http.response.access_control_allow_origin.header_value`` - Specifies which origins are allowed to access the server.
                 +  ``routing.http.response.access_control_allow_methods.header_value`` - Returns which HTTP methods are allowed when accessing the server from a different origin.
                 +  ``routing.http.response.access_control_allow_headers.header_value`` - Specifies which headers can be used during the request.
                 +  ``routing.http.response.access_control_allow_credentials.header_value`` - Indicates whether the browser should include credentials such as cookies or authentication when making requests.
                 +  ``routing.http.response.access_control_expose_headers.header_value`` - Returns which headers the browser can expose to the requesting client.
                 +  ``routing.http.response.access_control_max_age.header_value`` - Specifies how long the results of a preflight request can be cached, in seconds.
                 +  ``routing.http.response.content_security_policy.header_value`` - Specifies restrictions enforced by the browser to help minimize the risk of certain types of security threats.
                 +  ``routing.http.response.x_content_type_options.header_value`` - Indicates whether the MIME types advertised in the *Content-Type* headers should be followed and not be changed.
                 +  ``routing.http.response.x_frame_options.header_value`` - Indicates whether the browser is allowed to render a page in a *frame*, *iframe*, *embed* or *object*.
        :param pulumi.Input[builtins.str] value: The value of the attribute.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the attribute.
         The following attribute is supported by Network Load Balancers, and Gateway Load Balancers.
          +  ``tcp.idle_timeout.seconds`` - The tcp idle timeout value, in seconds. The valid range is 60-6000 seconds. The default is 350 seconds.
          
         The following attributes are only supported by Application Load Balancers.
          +  ``routing.http.request.x_amzn_mtls_clientcert_serial_number.header_name`` - Enables you to modify the header name of the *X-Amzn-Mtls-Clientcert-Serial-Number* HTTP request header.
          +  ``routing.http.request.x_amzn_mtls_clientcert_issuer.header_name`` - Enables you to modify the header name of the *X-Amzn-Mtls-Clientcert-Issuer* HTTP request header.
          +  ``routing.http.request.x_amzn_mtls_clientcert_subject.header_name`` - Enables you to modify the header name of the *X-Amzn-Mtls-Clientcert-Subject* HTTP request header.
          +  ``routing.http.request.x_amzn_mtls_clientcert_validity.header_name`` - Enables you to modify the header name of the *X-Amzn-Mtls-Clientcert-Validity* HTTP request header.
          +  ``routing.http.request.x_amzn_mtls_clientcert_leaf.header_name`` - Enables you to modify the header name of the *X-Amzn-Mtls-Clientcert-Leaf* HTTP request header.
          +  ``routing.http.request.x_amzn_mtls_clientcert.header_name`` - Enables you to modify the header name of the *X-Amzn-Mtls-Clientcert* HTTP request header.
          +  ``routing.http.request.x_amzn_tls_version.header_name`` - Enables you to modify the header name of the *X-Amzn-Tls-Version* HTTP request header.
          +  ``routing.http.request.x_amzn_tls_cipher_suite.header_name`` - Enables you to modify the header name of the *X-Amzn-Tls-Cipher-Suite* HTTP request header.
          +  ``routing.http.response.server.enabled`` - Enables you to allow or remove the HTTP response server header.
          +  ``routing.http.response.strict_transport_security.header_value`` - Informs browsers that the site should only be accessed using HTTPS, and that any future attempts to access it using HTTP should automatically be converted to HTTPS.
          +  ``routing.http.response.access_control_allow_origin.header_value`` - Specifies which origins are allowed to access the server.
          +  ``routing.http.response.access_control_allow_methods.header_value`` - Returns which HTTP methods are allowed when accessing the server from a different origin.
          +  ``routing.http.response.access_control_allow_headers.header_value`` - Specifies which headers can be used during the request.
          +  ``routing.http.response.access_control_allow_credentials.header_value`` - Indicates whether the browser should include credentials such as cookies or authentication when making requests.
          +  ``routing.http.response.access_control_expose_headers.header_value`` - Returns which headers the browser can expose to the requesting client.
          +  ``routing.http.response.access_control_max_age.header_value`` - Specifies how long the results of a preflight request can be cached, in seconds.
          +  ``routing.http.response.content_security_policy.header_value`` - Specifies restrictions enforced by the browser to help minimize the risk of certain types of security threats.
          +  ``routing.http.response.x_content_type_options.header_value`` - Indicates whether the MIME types advertised in the *Content-Type* headers should be followed and not be changed.
          +  ``routing.http.response.x_frame_options.header_value`` - Indicates whether the browser is allowed to render a page in a *frame*, *iframe*, *embed* or *object*.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value of the attribute.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ListenerAuthenticateCognitoConfigArgsDict(TypedDict):
        """
        Specifies information required when integrating with Amazon Cognito to authenticate users.
        """
        user_pool_arn: pulumi.Input[builtins.str]
        """
        The Amazon Resource Name (ARN) of the Amazon Cognito user pool.
        """
        user_pool_client_id: pulumi.Input[builtins.str]
        """
        The ID of the Amazon Cognito user pool client.
        """
        user_pool_domain: pulumi.Input[builtins.str]
        """
        The domain prefix or fully-qualified domain name of the Amazon Cognito user pool.
        """
        authentication_request_extra_params: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
        """
        on_unauthenticated_request: NotRequired[pulumi.Input[builtins.str]]
        """
        The behavior if the user is not authenticated. The following are possible values:
          +  deny```` - Return an HTTP 401 Unauthorized error.
          +  allow```` - Allow the request to be forwarded to the target.
          +  authenticate```` - Redirect the request to the IdP authorization endpoint. This is the default value.
        """
        scope: NotRequired[pulumi.Input[builtins.str]]
        """
        The set of user claims to be requested from the IdP. The default is ``openid``.
         To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
        """
        session_cookie_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the cookie used to maintain session information. The default is AWSELBAuthSessionCookie.
        """
        session_timeout: NotRequired[pulumi.Input[builtins.str]]
        """
        The maximum duration of the authentication session, in seconds. The default is 604800 seconds (7 days).
        """
elif False:
    ListenerAuthenticateCognitoConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerAuthenticateCognitoConfigArgs:
    def __init__(__self__, *,
                 user_pool_arn: pulumi.Input[builtins.str],
                 user_pool_client_id: pulumi.Input[builtins.str],
                 user_pool_domain: pulumi.Input[builtins.str],
                 authentication_request_extra_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 on_unauthenticated_request: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 session_cookie_name: Optional[pulumi.Input[builtins.str]] = None,
                 session_timeout: Optional[pulumi.Input[builtins.str]] = None):
        """
        Specifies information required when integrating with Amazon Cognito to authenticate users.
        :param pulumi.Input[builtins.str] user_pool_arn: The Amazon Resource Name (ARN) of the Amazon Cognito user pool.
        :param pulumi.Input[builtins.str] user_pool_client_id: The ID of the Amazon Cognito user pool client.
        :param pulumi.Input[builtins.str] user_pool_domain: The domain prefix or fully-qualified domain name of the Amazon Cognito user pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] authentication_request_extra_params: The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
        :param pulumi.Input[builtins.str] on_unauthenticated_request: The behavior if the user is not authenticated. The following are possible values:
                 +  deny```` - Return an HTTP 401 Unauthorized error.
                 +  allow```` - Allow the request to be forwarded to the target.
                 +  authenticate```` - Redirect the request to the IdP authorization endpoint. This is the default value.
        :param pulumi.Input[builtins.str] scope: The set of user claims to be requested from the IdP. The default is ``openid``.
                To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
        :param pulumi.Input[builtins.str] session_cookie_name: The name of the cookie used to maintain session information. The default is AWSELBAuthSessionCookie.
        :param pulumi.Input[builtins.str] session_timeout: The maximum duration of the authentication session, in seconds. The default is 604800 seconds (7 days).
        """
        pulumi.set(__self__, "user_pool_arn", user_pool_arn)
        pulumi.set(__self__, "user_pool_client_id", user_pool_client_id)
        pulumi.set(__self__, "user_pool_domain", user_pool_domain)
        if authentication_request_extra_params is not None:
            pulumi.set(__self__, "authentication_request_extra_params", authentication_request_extra_params)
        if on_unauthenticated_request is not None:
            pulumi.set(__self__, "on_unauthenticated_request", on_unauthenticated_request)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if session_cookie_name is not None:
            pulumi.set(__self__, "session_cookie_name", session_cookie_name)
        if session_timeout is not None:
            pulumi.set(__self__, "session_timeout", session_timeout)

    @property
    @pulumi.getter(name="userPoolArn")
    def user_pool_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Amazon Cognito user pool.
        """
        return pulumi.get(self, "user_pool_arn")

    @user_pool_arn.setter
    def user_pool_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_pool_arn", value)

    @property
    @pulumi.getter(name="userPoolClientId")
    def user_pool_client_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Amazon Cognito user pool client.
        """
        return pulumi.get(self, "user_pool_client_id")

    @user_pool_client_id.setter
    def user_pool_client_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_pool_client_id", value)

    @property
    @pulumi.getter(name="userPoolDomain")
    def user_pool_domain(self) -> pulumi.Input[builtins.str]:
        """
        The domain prefix or fully-qualified domain name of the Amazon Cognito user pool.
        """
        return pulumi.get(self, "user_pool_domain")

    @user_pool_domain.setter
    def user_pool_domain(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_pool_domain", value)

    @property
    @pulumi.getter(name="authenticationRequestExtraParams")
    def authentication_request_extra_params(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
        """
        return pulumi.get(self, "authentication_request_extra_params")

    @authentication_request_extra_params.setter
    def authentication_request_extra_params(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "authentication_request_extra_params", value)

    @property
    @pulumi.getter(name="onUnauthenticatedRequest")
    def on_unauthenticated_request(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The behavior if the user is not authenticated. The following are possible values:
          +  deny```` - Return an HTTP 401 Unauthorized error.
          +  allow```` - Allow the request to be forwarded to the target.
          +  authenticate```` - Redirect the request to the IdP authorization endpoint. This is the default value.
        """
        return pulumi.get(self, "on_unauthenticated_request")

    @on_unauthenticated_request.setter
    def on_unauthenticated_request(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "on_unauthenticated_request", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The set of user claims to be requested from the IdP. The default is ``openid``.
         To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="sessionCookieName")
    def session_cookie_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the cookie used to maintain session information. The default is AWSELBAuthSessionCookie.
        """
        return pulumi.get(self, "session_cookie_name")

    @session_cookie_name.setter
    def session_cookie_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "session_cookie_name", value)

    @property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The maximum duration of the authentication session, in seconds. The default is 604800 seconds (7 days).
        """
        return pulumi.get(self, "session_timeout")

    @session_timeout.setter
    def session_timeout(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "session_timeout", value)


if not MYPY:
    class ListenerAuthenticateOidcConfigArgsDict(TypedDict):
        """
        Specifies information required using an identity provide (IdP) that is compliant with OpenID Connect (OIDC) to authenticate users.
        """
        authorization_endpoint: pulumi.Input[builtins.str]
        """
        The authorization endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
        """
        client_id: pulumi.Input[builtins.str]
        """
        The OAuth 2.0 client identifier.
        """
        issuer: pulumi.Input[builtins.str]
        """
        The OIDC issuer identifier of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
        """
        token_endpoint: pulumi.Input[builtins.str]
        """
        The token endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
        """
        user_info_endpoint: pulumi.Input[builtins.str]
        """
        The user info endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
        """
        authentication_request_extra_params: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
        """
        client_secret: NotRequired[pulumi.Input[builtins.str]]
        """
        The OAuth 2.0 client secret. This parameter is required if you are creating a rule. If you are modifying a rule, you can omit this parameter if you set ``UseExistingClientSecret`` to true.
        """
        on_unauthenticated_request: NotRequired[pulumi.Input[builtins.str]]
        """
        The behavior if the user is not authenticated. The following are possible values:
          +  deny```` - Return an HTTP 401 Unauthorized error.
          +  allow```` - Allow the request to be forwarded to the target.
          +  authenticate```` - Redirect the request to the IdP authorization endpoint. This is the default value.
        """
        scope: NotRequired[pulumi.Input[builtins.str]]
        """
        The set of user claims to be requested from the IdP. The default is ``openid``.
         To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
        """
        session_cookie_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the cookie used to maintain session information. The default is AWSELBAuthSessionCookie.
        """
        session_timeout: NotRequired[pulumi.Input[builtins.str]]
        """
        The maximum duration of the authentication session, in seconds. The default is 604800 seconds (7 days).
        """
        use_existing_client_secret: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates whether to use the existing client secret when modifying a rule. If you are creating a rule, you can omit this parameter or set it to false.
        """
elif False:
    ListenerAuthenticateOidcConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerAuthenticateOidcConfigArgs:
    def __init__(__self__, *,
                 authorization_endpoint: pulumi.Input[builtins.str],
                 client_id: pulumi.Input[builtins.str],
                 issuer: pulumi.Input[builtins.str],
                 token_endpoint: pulumi.Input[builtins.str],
                 user_info_endpoint: pulumi.Input[builtins.str],
                 authentication_request_extra_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 on_unauthenticated_request: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 session_cookie_name: Optional[pulumi.Input[builtins.str]] = None,
                 session_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 use_existing_client_secret: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Specifies information required using an identity provide (IdP) that is compliant with OpenID Connect (OIDC) to authenticate users.
        :param pulumi.Input[builtins.str] authorization_endpoint: The authorization endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
        :param pulumi.Input[builtins.str] client_id: The OAuth 2.0 client identifier.
        :param pulumi.Input[builtins.str] issuer: The OIDC issuer identifier of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
        :param pulumi.Input[builtins.str] token_endpoint: The token endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
        :param pulumi.Input[builtins.str] user_info_endpoint: The user info endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] authentication_request_extra_params: The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
        :param pulumi.Input[builtins.str] client_secret: The OAuth 2.0 client secret. This parameter is required if you are creating a rule. If you are modifying a rule, you can omit this parameter if you set ``UseExistingClientSecret`` to true.
        :param pulumi.Input[builtins.str] on_unauthenticated_request: The behavior if the user is not authenticated. The following are possible values:
                 +  deny```` - Return an HTTP 401 Unauthorized error.
                 +  allow```` - Allow the request to be forwarded to the target.
                 +  authenticate```` - Redirect the request to the IdP authorization endpoint. This is the default value.
        :param pulumi.Input[builtins.str] scope: The set of user claims to be requested from the IdP. The default is ``openid``.
                To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
        :param pulumi.Input[builtins.str] session_cookie_name: The name of the cookie used to maintain session information. The default is AWSELBAuthSessionCookie.
        :param pulumi.Input[builtins.str] session_timeout: The maximum duration of the authentication session, in seconds. The default is 604800 seconds (7 days).
        :param pulumi.Input[builtins.bool] use_existing_client_secret: Indicates whether to use the existing client secret when modifying a rule. If you are creating a rule, you can omit this parameter or set it to false.
        """
        pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "token_endpoint", token_endpoint)
        pulumi.set(__self__, "user_info_endpoint", user_info_endpoint)
        if authentication_request_extra_params is not None:
            pulumi.set(__self__, "authentication_request_extra_params", authentication_request_extra_params)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if on_unauthenticated_request is not None:
            pulumi.set(__self__, "on_unauthenticated_request", on_unauthenticated_request)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if session_cookie_name is not None:
            pulumi.set(__self__, "session_cookie_name", session_cookie_name)
        if session_timeout is not None:
            pulumi.set(__self__, "session_timeout", session_timeout)
        if use_existing_client_secret is not None:
            pulumi.set(__self__, "use_existing_client_secret", use_existing_client_secret)

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> pulumi.Input[builtins.str]:
        """
        The authorization endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
        """
        return pulumi.get(self, "authorization_endpoint")

    @authorization_endpoint.setter
    def authorization_endpoint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "authorization_endpoint", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[builtins.str]:
        """
        The OAuth 2.0 client identifier.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter
    def issuer(self) -> pulumi.Input[builtins.str]:
        """
        The OIDC issuer identifier of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "issuer", value)

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> pulumi.Input[builtins.str]:
        """
        The token endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
        """
        return pulumi.get(self, "token_endpoint")

    @token_endpoint.setter
    def token_endpoint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "token_endpoint", value)

    @property
    @pulumi.getter(name="userInfoEndpoint")
    def user_info_endpoint(self) -> pulumi.Input[builtins.str]:
        """
        The user info endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
        """
        return pulumi.get(self, "user_info_endpoint")

    @user_info_endpoint.setter
    def user_info_endpoint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_info_endpoint", value)

    @property
    @pulumi.getter(name="authenticationRequestExtraParams")
    def authentication_request_extra_params(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
        """
        return pulumi.get(self, "authentication_request_extra_params")

    @authentication_request_extra_params.setter
    def authentication_request_extra_params(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "authentication_request_extra_params", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OAuth 2.0 client secret. This parameter is required if you are creating a rule. If you are modifying a rule, you can omit this parameter if you set ``UseExistingClientSecret`` to true.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="onUnauthenticatedRequest")
    def on_unauthenticated_request(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The behavior if the user is not authenticated. The following are possible values:
          +  deny```` - Return an HTTP 401 Unauthorized error.
          +  allow```` - Allow the request to be forwarded to the target.
          +  authenticate```` - Redirect the request to the IdP authorization endpoint. This is the default value.
        """
        return pulumi.get(self, "on_unauthenticated_request")

    @on_unauthenticated_request.setter
    def on_unauthenticated_request(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "on_unauthenticated_request", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The set of user claims to be requested from the IdP. The default is ``openid``.
         To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="sessionCookieName")
    def session_cookie_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the cookie used to maintain session information. The default is AWSELBAuthSessionCookie.
        """
        return pulumi.get(self, "session_cookie_name")

    @session_cookie_name.setter
    def session_cookie_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "session_cookie_name", value)

    @property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The maximum duration of the authentication session, in seconds. The default is 604800 seconds (7 days).
        """
        return pulumi.get(self, "session_timeout")

    @session_timeout.setter
    def session_timeout(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "session_timeout", value)

    @property
    @pulumi.getter(name="useExistingClientSecret")
    def use_existing_client_secret(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether to use the existing client secret when modifying a rule. If you are creating a rule, you can omit this parameter or set it to false.
        """
        return pulumi.get(self, "use_existing_client_secret")

    @use_existing_client_secret.setter
    def use_existing_client_secret(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_existing_client_secret", value)


if not MYPY:
    class ListenerCertificateArgsDict(TypedDict):
        """
        Specifies an SSL server certificate to use as the default certificate for a secure listener.
        """
        certificate_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) of the certificate.
        """
elif False:
    ListenerCertificateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerCertificateArgs:
    def __init__(__self__, *,
                 certificate_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        Specifies an SSL server certificate to use as the default certificate for a secure listener.
        :param pulumi.Input[builtins.str] certificate_arn: The Amazon Resource Name (ARN) of the certificate.
        """
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the certificate.
        """
        return pulumi.get(self, "certificate_arn")

    @certificate_arn.setter
    def certificate_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_arn", value)


if not MYPY:
    class ListenerFixedResponseConfigArgsDict(TypedDict):
        """
        Specifies information required when returning a custom HTTP response.
        """
        status_code: pulumi.Input[builtins.str]
        """
        The HTTP response code (2XX, 4XX, or 5XX).
        """
        content_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The content type.
         Valid Values: text/plain | text/css | text/html | application/javascript | application/json
        """
        message_body: NotRequired[pulumi.Input[builtins.str]]
        """
        The message.
        """
elif False:
    ListenerFixedResponseConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerFixedResponseConfigArgs:
    def __init__(__self__, *,
                 status_code: pulumi.Input[builtins.str],
                 content_type: Optional[pulumi.Input[builtins.str]] = None,
                 message_body: Optional[pulumi.Input[builtins.str]] = None):
        """
        Specifies information required when returning a custom HTTP response.
        :param pulumi.Input[builtins.str] status_code: The HTTP response code (2XX, 4XX, or 5XX).
        :param pulumi.Input[builtins.str] content_type: The content type.
                Valid Values: text/plain | text/css | text/html | application/javascript | application/json
        :param pulumi.Input[builtins.str] message_body: The message.
        """
        pulumi.set(__self__, "status_code", status_code)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if message_body is not None:
            pulumi.set(__self__, "message_body", message_body)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> pulumi.Input[builtins.str]:
        """
        The HTTP response code (2XX, 4XX, or 5XX).
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "status_code", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The content type.
         Valid Values: text/plain | text/css | text/html | application/javascript | application/json
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="messageBody")
    def message_body(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The message.
        """
        return pulumi.get(self, "message_body")

    @message_body.setter
    def message_body(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "message_body", value)


if not MYPY:
    class ListenerForwardConfigArgsDict(TypedDict):
        """
        Information for creating an action that distributes requests among one or more target groups. For Network Load Balancers, you can specify a single target group. Specify only when ``Type`` is ``forward``. If you specify both ``ForwardConfig`` and ``TargetGroupArn``, you can specify only one target group using ``ForwardConfig`` and it must be the same target group specified in ``TargetGroupArn``.
        """
        target_group_stickiness_config: NotRequired[pulumi.Input['ListenerTargetGroupStickinessConfigArgsDict']]
        """
        Information about the target group stickiness for a rule.
        """
        target_groups: NotRequired[pulumi.Input[Sequence[pulumi.Input['ListenerTargetGroupTupleArgsDict']]]]
        """
        Information about how traffic will be distributed between multiple target groups in a forward rule.
        """
elif False:
    ListenerForwardConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerForwardConfigArgs:
    def __init__(__self__, *,
                 target_group_stickiness_config: Optional[pulumi.Input['ListenerTargetGroupStickinessConfigArgs']] = None,
                 target_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerTargetGroupTupleArgs']]]] = None):
        """
        Information for creating an action that distributes requests among one or more target groups. For Network Load Balancers, you can specify a single target group. Specify only when ``Type`` is ``forward``. If you specify both ``ForwardConfig`` and ``TargetGroupArn``, you can specify only one target group using ``ForwardConfig`` and it must be the same target group specified in ``TargetGroupArn``.
        :param pulumi.Input['ListenerTargetGroupStickinessConfigArgs'] target_group_stickiness_config: Information about the target group stickiness for a rule.
        :param pulumi.Input[Sequence[pulumi.Input['ListenerTargetGroupTupleArgs']]] target_groups: Information about how traffic will be distributed between multiple target groups in a forward rule.
        """
        if target_group_stickiness_config is not None:
            pulumi.set(__self__, "target_group_stickiness_config", target_group_stickiness_config)
        if target_groups is not None:
            pulumi.set(__self__, "target_groups", target_groups)

    @property
    @pulumi.getter(name="targetGroupStickinessConfig")
    def target_group_stickiness_config(self) -> Optional[pulumi.Input['ListenerTargetGroupStickinessConfigArgs']]:
        """
        Information about the target group stickiness for a rule.
        """
        return pulumi.get(self, "target_group_stickiness_config")

    @target_group_stickiness_config.setter
    def target_group_stickiness_config(self, value: Optional[pulumi.Input['ListenerTargetGroupStickinessConfigArgs']]):
        pulumi.set(self, "target_group_stickiness_config", value)

    @property
    @pulumi.getter(name="targetGroups")
    def target_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ListenerTargetGroupTupleArgs']]]]:
        """
        Information about how traffic will be distributed between multiple target groups in a forward rule.
        """
        return pulumi.get(self, "target_groups")

    @target_groups.setter
    def target_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerTargetGroupTupleArgs']]]]):
        pulumi.set(self, "target_groups", value)


if not MYPY:
    class ListenerMutualAuthenticationArgsDict(TypedDict):
        """
        The mutual authentication configuration information.
        """
        advertise_trust_store_ca_names: NotRequired[pulumi.Input[builtins.str]]
        """
        Indicates whether trust store CA certificate names are advertised.
        """
        ignore_client_certificate_expiry: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates whether expired client certificates are ignored.
        """
        mode: NotRequired[pulumi.Input[builtins.str]]
        """
        The client certificate handling method. Options are ``off``, ``passthrough`` or ``verify``. The default value is ``off``.
        """
        trust_store_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) of the trust store.
        """
elif False:
    ListenerMutualAuthenticationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerMutualAuthenticationArgs:
    def __init__(__self__, *,
                 advertise_trust_store_ca_names: Optional[pulumi.Input[builtins.str]] = None,
                 ignore_client_certificate_expiry: Optional[pulumi.Input[builtins.bool]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 trust_store_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        The mutual authentication configuration information.
        :param pulumi.Input[builtins.str] advertise_trust_store_ca_names: Indicates whether trust store CA certificate names are advertised.
        :param pulumi.Input[builtins.bool] ignore_client_certificate_expiry: Indicates whether expired client certificates are ignored.
        :param pulumi.Input[builtins.str] mode: The client certificate handling method. Options are ``off``, ``passthrough`` or ``verify``. The default value is ``off``.
        :param pulumi.Input[builtins.str] trust_store_arn: The Amazon Resource Name (ARN) of the trust store.
        """
        if advertise_trust_store_ca_names is not None:
            pulumi.set(__self__, "advertise_trust_store_ca_names", advertise_trust_store_ca_names)
        if ignore_client_certificate_expiry is not None:
            pulumi.set(__self__, "ignore_client_certificate_expiry", ignore_client_certificate_expiry)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if trust_store_arn is not None:
            pulumi.set(__self__, "trust_store_arn", trust_store_arn)

    @property
    @pulumi.getter(name="advertiseTrustStoreCaNames")
    def advertise_trust_store_ca_names(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates whether trust store CA certificate names are advertised.
        """
        return pulumi.get(self, "advertise_trust_store_ca_names")

    @advertise_trust_store_ca_names.setter
    def advertise_trust_store_ca_names(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "advertise_trust_store_ca_names", value)

    @property
    @pulumi.getter(name="ignoreClientCertificateExpiry")
    def ignore_client_certificate_expiry(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether expired client certificates are ignored.
        """
        return pulumi.get(self, "ignore_client_certificate_expiry")

    @ignore_client_certificate_expiry.setter
    def ignore_client_certificate_expiry(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ignore_client_certificate_expiry", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The client certificate handling method. Options are ``off``, ``passthrough`` or ``verify``. The default value is ``off``.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="trustStoreArn")
    def trust_store_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the trust store.
        """
        return pulumi.get(self, "trust_store_arn")

    @trust_store_arn.setter
    def trust_store_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "trust_store_arn", value)


if not MYPY:
    class ListenerRedirectConfigArgsDict(TypedDict):
        """
        Information about a redirect action.
         A URI consists of the following components: protocol://hostname:port/path?query. You must modify at least one of the following components to avoid a redirect loop: protocol, hostname, port, or path. Any components that you do not modify retain their original values.
         You can reuse URI components using the following reserved keywords:
          +  #{protocol}
          +  #{host}
          +  #{port}
          +  #{path} (the leading "/" is removed)
          +  #{query}
          
         For example, you can change the path to "/new/#{path}", the hostname to "example.#{host}", or the query to "#{query}&value=xyz".
        """
        status_code: pulumi.Input[builtins.str]
        """
        The HTTP redirect code. The redirect is either permanent (HTTP 301) or temporary (HTTP 302).
        """
        host: NotRequired[pulumi.Input[builtins.str]]
        """
        The hostname. This component is not percent-encoded. The hostname can contain #{host}.
        """
        path: NotRequired[pulumi.Input[builtins.str]]
        """
        The absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}.
        """
        port: NotRequired[pulumi.Input[builtins.str]]
        """
        The port. You can specify a value from 1 to 65535 or #{port}.
        """
        protocol: NotRequired[pulumi.Input[builtins.str]]
        """
        The protocol. You can specify HTTP, HTTPS, or #{protocol}. You can redirect HTTP to HTTP, HTTP to HTTPS, and HTTPS to HTTPS. You can't redirect HTTPS to HTTP.
        """
        query: NotRequired[pulumi.Input[builtins.str]]
        """
        The query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?", as it is automatically added. You can specify any of the reserved keywords.
        """
elif False:
    ListenerRedirectConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRedirectConfigArgs:
    def __init__(__self__, *,
                 status_code: pulumi.Input[builtins.str],
                 host: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 query: Optional[pulumi.Input[builtins.str]] = None):
        """
        Information about a redirect action.
         A URI consists of the following components: protocol://hostname:port/path?query. You must modify at least one of the following components to avoid a redirect loop: protocol, hostname, port, or path. Any components that you do not modify retain their original values.
         You can reuse URI components using the following reserved keywords:
          +  #{protocol}
          +  #{host}
          +  #{port}
          +  #{path} (the leading "/" is removed)
          +  #{query}
          
         For example, you can change the path to "/new/#{path}", the hostname to "example.#{host}", or the query to "#{query}&value=xyz".
        :param pulumi.Input[builtins.str] status_code: The HTTP redirect code. The redirect is either permanent (HTTP 301) or temporary (HTTP 302).
        :param pulumi.Input[builtins.str] host: The hostname. This component is not percent-encoded. The hostname can contain #{host}.
        :param pulumi.Input[builtins.str] path: The absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}.
        :param pulumi.Input[builtins.str] port: The port. You can specify a value from 1 to 65535 or #{port}.
        :param pulumi.Input[builtins.str] protocol: The protocol. You can specify HTTP, HTTPS, or #{protocol}. You can redirect HTTP to HTTP, HTTP to HTTPS, and HTTPS to HTTPS. You can't redirect HTTPS to HTTP.
        :param pulumi.Input[builtins.str] query: The query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?", as it is automatically added. You can specify any of the reserved keywords.
        """
        pulumi.set(__self__, "status_code", status_code)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if query is not None:
            pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> pulumi.Input[builtins.str]:
        """
        The HTTP redirect code. The redirect is either permanent (HTTP 301) or temporary (HTTP 302).
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "status_code", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hostname. This component is not percent-encoded. The hostname can contain #{host}.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The port. You can specify a value from 1 to 65535 or #{port}.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The protocol. You can specify HTTP, HTTPS, or #{protocol}. You can redirect HTTP to HTTP, HTTP to HTTPS, and HTTPS to HTTPS. You can't redirect HTTPS to HTTP.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?", as it is automatically added. You can specify any of the reserved keywords.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "query", value)


if not MYPY:
    class ListenerRuleActionArgsDict(TypedDict):
        """
        Specifies an action for a listener rule.
        """
        type: pulumi.Input[builtins.str]
        """
        The type of action.
        """
        authenticate_cognito_config: NotRequired[pulumi.Input['ListenerRuleAuthenticateCognitoConfigArgsDict']]
        """
        [HTTPS listeners] Information for using Amazon Cognito to authenticate users. Specify only when ``Type`` is ``authenticate-cognito``.
        """
        authenticate_oidc_config: NotRequired[pulumi.Input['ListenerRuleAuthenticateOidcConfigArgsDict']]
        """
        [HTTPS listeners] Information about an identity provider that is compliant with OpenID Connect (OIDC). Specify only when ``Type`` is ``authenticate-oidc``.
        """
        fixed_response_config: NotRequired[pulumi.Input['ListenerRuleFixedResponseConfigArgsDict']]
        """
        [Application Load Balancer] Information for creating an action that returns a custom HTTP response. Specify only when ``Type`` is ``fixed-response``.
        """
        forward_config: NotRequired[pulumi.Input['ListenerRuleForwardConfigArgsDict']]
        """
        Information for creating an action that distributes requests among one or more target groups. For Network Load Balancers, you can specify a single target group. Specify only when ``Type`` is ``forward``. If you specify both ``ForwardConfig`` and ``TargetGroupArn``, you can specify only one target group using ``ForwardConfig`` and it must be the same target group specified in ``TargetGroupArn``.
        """
        order: NotRequired[pulumi.Input[builtins.int]]
        """
        The order for the action. This value is required for rules with multiple actions. The action with the lowest value for order is performed first.
        """
        redirect_config: NotRequired[pulumi.Input['ListenerRuleRedirectConfigArgsDict']]
        """
        [Application Load Balancer] Information for creating a redirect action. Specify only when ``Type`` is ``redirect``.
        """
        target_group_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) of the target group. Specify only when ``Type`` is ``forward`` and you want to route to a single target group. To route to one or more target groups, use ``ForwardConfig`` instead.
        """
elif False:
    ListenerRuleActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleActionArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 authenticate_cognito_config: Optional[pulumi.Input['ListenerRuleAuthenticateCognitoConfigArgs']] = None,
                 authenticate_oidc_config: Optional[pulumi.Input['ListenerRuleAuthenticateOidcConfigArgs']] = None,
                 fixed_response_config: Optional[pulumi.Input['ListenerRuleFixedResponseConfigArgs']] = None,
                 forward_config: Optional[pulumi.Input['ListenerRuleForwardConfigArgs']] = None,
                 order: Optional[pulumi.Input[builtins.int]] = None,
                 redirect_config: Optional[pulumi.Input['ListenerRuleRedirectConfigArgs']] = None,
                 target_group_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        Specifies an action for a listener rule.
        :param pulumi.Input[builtins.str] type: The type of action.
        :param pulumi.Input['ListenerRuleAuthenticateCognitoConfigArgs'] authenticate_cognito_config: [HTTPS listeners] Information for using Amazon Cognito to authenticate users. Specify only when ``Type`` is ``authenticate-cognito``.
        :param pulumi.Input['ListenerRuleAuthenticateOidcConfigArgs'] authenticate_oidc_config: [HTTPS listeners] Information about an identity provider that is compliant with OpenID Connect (OIDC). Specify only when ``Type`` is ``authenticate-oidc``.
        :param pulumi.Input['ListenerRuleFixedResponseConfigArgs'] fixed_response_config: [Application Load Balancer] Information for creating an action that returns a custom HTTP response. Specify only when ``Type`` is ``fixed-response``.
        :param pulumi.Input['ListenerRuleForwardConfigArgs'] forward_config: Information for creating an action that distributes requests among one or more target groups. For Network Load Balancers, you can specify a single target group. Specify only when ``Type`` is ``forward``. If you specify both ``ForwardConfig`` and ``TargetGroupArn``, you can specify only one target group using ``ForwardConfig`` and it must be the same target group specified in ``TargetGroupArn``.
        :param pulumi.Input[builtins.int] order: The order for the action. This value is required for rules with multiple actions. The action with the lowest value for order is performed first.
        :param pulumi.Input['ListenerRuleRedirectConfigArgs'] redirect_config: [Application Load Balancer] Information for creating a redirect action. Specify only when ``Type`` is ``redirect``.
        :param pulumi.Input[builtins.str] target_group_arn: The Amazon Resource Name (ARN) of the target group. Specify only when ``Type`` is ``forward`` and you want to route to a single target group. To route to one or more target groups, use ``ForwardConfig`` instead.
        """
        pulumi.set(__self__, "type", type)
        if authenticate_cognito_config is not None:
            pulumi.set(__self__, "authenticate_cognito_config", authenticate_cognito_config)
        if authenticate_oidc_config is not None:
            pulumi.set(__self__, "authenticate_oidc_config", authenticate_oidc_config)
        if fixed_response_config is not None:
            pulumi.set(__self__, "fixed_response_config", fixed_response_config)
        if forward_config is not None:
            pulumi.set(__self__, "forward_config", forward_config)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if redirect_config is not None:
            pulumi.set(__self__, "redirect_config", redirect_config)
        if target_group_arn is not None:
            pulumi.set(__self__, "target_group_arn", target_group_arn)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of action.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="authenticateCognitoConfig")
    def authenticate_cognito_config(self) -> Optional[pulumi.Input['ListenerRuleAuthenticateCognitoConfigArgs']]:
        """
        [HTTPS listeners] Information for using Amazon Cognito to authenticate users. Specify only when ``Type`` is ``authenticate-cognito``.
        """
        return pulumi.get(self, "authenticate_cognito_config")

    @authenticate_cognito_config.setter
    def authenticate_cognito_config(self, value: Optional[pulumi.Input['ListenerRuleAuthenticateCognitoConfigArgs']]):
        pulumi.set(self, "authenticate_cognito_config", value)

    @property
    @pulumi.getter(name="authenticateOidcConfig")
    def authenticate_oidc_config(self) -> Optional[pulumi.Input['ListenerRuleAuthenticateOidcConfigArgs']]:
        """
        [HTTPS listeners] Information about an identity provider that is compliant with OpenID Connect (OIDC). Specify only when ``Type`` is ``authenticate-oidc``.
        """
        return pulumi.get(self, "authenticate_oidc_config")

    @authenticate_oidc_config.setter
    def authenticate_oidc_config(self, value: Optional[pulumi.Input['ListenerRuleAuthenticateOidcConfigArgs']]):
        pulumi.set(self, "authenticate_oidc_config", value)

    @property
    @pulumi.getter(name="fixedResponseConfig")
    def fixed_response_config(self) -> Optional[pulumi.Input['ListenerRuleFixedResponseConfigArgs']]:
        """
        [Application Load Balancer] Information for creating an action that returns a custom HTTP response. Specify only when ``Type`` is ``fixed-response``.
        """
        return pulumi.get(self, "fixed_response_config")

    @fixed_response_config.setter
    def fixed_response_config(self, value: Optional[pulumi.Input['ListenerRuleFixedResponseConfigArgs']]):
        pulumi.set(self, "fixed_response_config", value)

    @property
    @pulumi.getter(name="forwardConfig")
    def forward_config(self) -> Optional[pulumi.Input['ListenerRuleForwardConfigArgs']]:
        """
        Information for creating an action that distributes requests among one or more target groups. For Network Load Balancers, you can specify a single target group. Specify only when ``Type`` is ``forward``. If you specify both ``ForwardConfig`` and ``TargetGroupArn``, you can specify only one target group using ``ForwardConfig`` and it must be the same target group specified in ``TargetGroupArn``.
        """
        return pulumi.get(self, "forward_config")

    @forward_config.setter
    def forward_config(self, value: Optional[pulumi.Input['ListenerRuleForwardConfigArgs']]):
        pulumi.set(self, "forward_config", value)

    @property
    @pulumi.getter
    def order(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The order for the action. This value is required for rules with multiple actions. The action with the lowest value for order is performed first.
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "order", value)

    @property
    @pulumi.getter(name="redirectConfig")
    def redirect_config(self) -> Optional[pulumi.Input['ListenerRuleRedirectConfigArgs']]:
        """
        [Application Load Balancer] Information for creating a redirect action. Specify only when ``Type`` is ``redirect``.
        """
        return pulumi.get(self, "redirect_config")

    @redirect_config.setter
    def redirect_config(self, value: Optional[pulumi.Input['ListenerRuleRedirectConfigArgs']]):
        pulumi.set(self, "redirect_config", value)

    @property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the target group. Specify only when ``Type`` is ``forward`` and you want to route to a single target group. To route to one or more target groups, use ``ForwardConfig`` instead.
        """
        return pulumi.get(self, "target_group_arn")

    @target_group_arn.setter
    def target_group_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_group_arn", value)


if not MYPY:
    class ListenerRuleAuthenticateCognitoConfigArgsDict(TypedDict):
        """
        Specifies information required when integrating with Amazon Cognito to authenticate users.
        """
        user_pool_arn: pulumi.Input[builtins.str]
        """
        The Amazon Resource Name (ARN) of the Amazon Cognito user pool.
        """
        user_pool_client_id: pulumi.Input[builtins.str]
        """
        The ID of the Amazon Cognito user pool client.
        """
        user_pool_domain: pulumi.Input[builtins.str]
        """
        The domain prefix or fully-qualified domain name of the Amazon Cognito user pool.
        """
        authentication_request_extra_params: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
        """
        on_unauthenticated_request: NotRequired[pulumi.Input[builtins.str]]
        """
        The behavior if the user is not authenticated. The following are possible values:
          +  deny```` - Return an HTTP 401 Unauthorized error.
          +  allow```` - Allow the request to be forwarded to the target.
          +  authenticate```` - Redirect the request to the IdP authorization endpoint. This is the default value.
        """
        scope: NotRequired[pulumi.Input[builtins.str]]
        """
        The set of user claims to be requested from the IdP. The default is ``openid``.
         To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
        """
        session_cookie_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the cookie used to maintain session information. The default is AWSELBAuthSessionCookie.
        """
        session_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum duration of the authentication session, in seconds. The default is 604800 seconds (7 days).
        """
elif False:
    ListenerRuleAuthenticateCognitoConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleAuthenticateCognitoConfigArgs:
    def __init__(__self__, *,
                 user_pool_arn: pulumi.Input[builtins.str],
                 user_pool_client_id: pulumi.Input[builtins.str],
                 user_pool_domain: pulumi.Input[builtins.str],
                 authentication_request_extra_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 on_unauthenticated_request: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 session_cookie_name: Optional[pulumi.Input[builtins.str]] = None,
                 session_timeout: Optional[pulumi.Input[builtins.int]] = None):
        """
        Specifies information required when integrating with Amazon Cognito to authenticate users.
        :param pulumi.Input[builtins.str] user_pool_arn: The Amazon Resource Name (ARN) of the Amazon Cognito user pool.
        :param pulumi.Input[builtins.str] user_pool_client_id: The ID of the Amazon Cognito user pool client.
        :param pulumi.Input[builtins.str] user_pool_domain: The domain prefix or fully-qualified domain name of the Amazon Cognito user pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] authentication_request_extra_params: The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
        :param pulumi.Input[builtins.str] on_unauthenticated_request: The behavior if the user is not authenticated. The following are possible values:
                 +  deny```` - Return an HTTP 401 Unauthorized error.
                 +  allow```` - Allow the request to be forwarded to the target.
                 +  authenticate```` - Redirect the request to the IdP authorization endpoint. This is the default value.
        :param pulumi.Input[builtins.str] scope: The set of user claims to be requested from the IdP. The default is ``openid``.
                To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
        :param pulumi.Input[builtins.str] session_cookie_name: The name of the cookie used to maintain session information. The default is AWSELBAuthSessionCookie.
        :param pulumi.Input[builtins.int] session_timeout: The maximum duration of the authentication session, in seconds. The default is 604800 seconds (7 days).
        """
        pulumi.set(__self__, "user_pool_arn", user_pool_arn)
        pulumi.set(__self__, "user_pool_client_id", user_pool_client_id)
        pulumi.set(__self__, "user_pool_domain", user_pool_domain)
        if authentication_request_extra_params is not None:
            pulumi.set(__self__, "authentication_request_extra_params", authentication_request_extra_params)
        if on_unauthenticated_request is not None:
            pulumi.set(__self__, "on_unauthenticated_request", on_unauthenticated_request)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if session_cookie_name is not None:
            pulumi.set(__self__, "session_cookie_name", session_cookie_name)
        if session_timeout is not None:
            pulumi.set(__self__, "session_timeout", session_timeout)

    @property
    @pulumi.getter(name="userPoolArn")
    def user_pool_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Amazon Cognito user pool.
        """
        return pulumi.get(self, "user_pool_arn")

    @user_pool_arn.setter
    def user_pool_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_pool_arn", value)

    @property
    @pulumi.getter(name="userPoolClientId")
    def user_pool_client_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Amazon Cognito user pool client.
        """
        return pulumi.get(self, "user_pool_client_id")

    @user_pool_client_id.setter
    def user_pool_client_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_pool_client_id", value)

    @property
    @pulumi.getter(name="userPoolDomain")
    def user_pool_domain(self) -> pulumi.Input[builtins.str]:
        """
        The domain prefix or fully-qualified domain name of the Amazon Cognito user pool.
        """
        return pulumi.get(self, "user_pool_domain")

    @user_pool_domain.setter
    def user_pool_domain(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_pool_domain", value)

    @property
    @pulumi.getter(name="authenticationRequestExtraParams")
    def authentication_request_extra_params(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
        """
        return pulumi.get(self, "authentication_request_extra_params")

    @authentication_request_extra_params.setter
    def authentication_request_extra_params(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "authentication_request_extra_params", value)

    @property
    @pulumi.getter(name="onUnauthenticatedRequest")
    def on_unauthenticated_request(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The behavior if the user is not authenticated. The following are possible values:
          +  deny```` - Return an HTTP 401 Unauthorized error.
          +  allow```` - Allow the request to be forwarded to the target.
          +  authenticate```` - Redirect the request to the IdP authorization endpoint. This is the default value.
        """
        return pulumi.get(self, "on_unauthenticated_request")

    @on_unauthenticated_request.setter
    def on_unauthenticated_request(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "on_unauthenticated_request", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The set of user claims to be requested from the IdP. The default is ``openid``.
         To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="sessionCookieName")
    def session_cookie_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the cookie used to maintain session information. The default is AWSELBAuthSessionCookie.
        """
        return pulumi.get(self, "session_cookie_name")

    @session_cookie_name.setter
    def session_cookie_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "session_cookie_name", value)

    @property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum duration of the authentication session, in seconds. The default is 604800 seconds (7 days).
        """
        return pulumi.get(self, "session_timeout")

    @session_timeout.setter
    def session_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "session_timeout", value)


if not MYPY:
    class ListenerRuleAuthenticateOidcConfigArgsDict(TypedDict):
        """
        Specifies information required using an identity provide (IdP) that is compliant with OpenID Connect (OIDC) to authenticate users.
        """
        authorization_endpoint: pulumi.Input[builtins.str]
        """
        The authorization endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
        """
        client_id: pulumi.Input[builtins.str]
        """
        The OAuth 2.0 client identifier.
        """
        issuer: pulumi.Input[builtins.str]
        """
        The OIDC issuer identifier of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
        """
        token_endpoint: pulumi.Input[builtins.str]
        """
        The token endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
        """
        user_info_endpoint: pulumi.Input[builtins.str]
        """
        The user info endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
        """
        authentication_request_extra_params: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
        """
        client_secret: NotRequired[pulumi.Input[builtins.str]]
        """
        The OAuth 2.0 client secret. This parameter is required if you are creating a rule. If you are modifying a rule, you can omit this parameter if you set ``UseExistingClientSecret`` to true.
        """
        on_unauthenticated_request: NotRequired[pulumi.Input[builtins.str]]
        """
        The behavior if the user is not authenticated. The following are possible values:
          +  deny```` - Return an HTTP 401 Unauthorized error.
          +  allow```` - Allow the request to be forwarded to the target.
          +  authenticate```` - Redirect the request to the IdP authorization endpoint. This is the default value.
        """
        scope: NotRequired[pulumi.Input[builtins.str]]
        """
        The set of user claims to be requested from the IdP. The default is ``openid``.
         To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
        """
        session_cookie_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the cookie used to maintain session information. The default is AWSELBAuthSessionCookie.
        """
        session_timeout: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum duration of the authentication session, in seconds. The default is 604800 seconds (7 days).
        """
        use_existing_client_secret: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates whether to use the existing client secret when modifying a rule. If you are creating a rule, you can omit this parameter or set it to false.
        """
elif False:
    ListenerRuleAuthenticateOidcConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleAuthenticateOidcConfigArgs:
    def __init__(__self__, *,
                 authorization_endpoint: pulumi.Input[builtins.str],
                 client_id: pulumi.Input[builtins.str],
                 issuer: pulumi.Input[builtins.str],
                 token_endpoint: pulumi.Input[builtins.str],
                 user_info_endpoint: pulumi.Input[builtins.str],
                 authentication_request_extra_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 on_unauthenticated_request: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 session_cookie_name: Optional[pulumi.Input[builtins.str]] = None,
                 session_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 use_existing_client_secret: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Specifies information required using an identity provide (IdP) that is compliant with OpenID Connect (OIDC) to authenticate users.
        :param pulumi.Input[builtins.str] authorization_endpoint: The authorization endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
        :param pulumi.Input[builtins.str] client_id: The OAuth 2.0 client identifier.
        :param pulumi.Input[builtins.str] issuer: The OIDC issuer identifier of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
        :param pulumi.Input[builtins.str] token_endpoint: The token endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
        :param pulumi.Input[builtins.str] user_info_endpoint: The user info endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] authentication_request_extra_params: The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
        :param pulumi.Input[builtins.str] client_secret: The OAuth 2.0 client secret. This parameter is required if you are creating a rule. If you are modifying a rule, you can omit this parameter if you set ``UseExistingClientSecret`` to true.
        :param pulumi.Input[builtins.str] on_unauthenticated_request: The behavior if the user is not authenticated. The following are possible values:
                 +  deny```` - Return an HTTP 401 Unauthorized error.
                 +  allow```` - Allow the request to be forwarded to the target.
                 +  authenticate```` - Redirect the request to the IdP authorization endpoint. This is the default value.
        :param pulumi.Input[builtins.str] scope: The set of user claims to be requested from the IdP. The default is ``openid``.
                To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
        :param pulumi.Input[builtins.str] session_cookie_name: The name of the cookie used to maintain session information. The default is AWSELBAuthSessionCookie.
        :param pulumi.Input[builtins.int] session_timeout: The maximum duration of the authentication session, in seconds. The default is 604800 seconds (7 days).
        :param pulumi.Input[builtins.bool] use_existing_client_secret: Indicates whether to use the existing client secret when modifying a rule. If you are creating a rule, you can omit this parameter or set it to false.
        """
        pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "token_endpoint", token_endpoint)
        pulumi.set(__self__, "user_info_endpoint", user_info_endpoint)
        if authentication_request_extra_params is not None:
            pulumi.set(__self__, "authentication_request_extra_params", authentication_request_extra_params)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if on_unauthenticated_request is not None:
            pulumi.set(__self__, "on_unauthenticated_request", on_unauthenticated_request)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if session_cookie_name is not None:
            pulumi.set(__self__, "session_cookie_name", session_cookie_name)
        if session_timeout is not None:
            pulumi.set(__self__, "session_timeout", session_timeout)
        if use_existing_client_secret is not None:
            pulumi.set(__self__, "use_existing_client_secret", use_existing_client_secret)

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> pulumi.Input[builtins.str]:
        """
        The authorization endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
        """
        return pulumi.get(self, "authorization_endpoint")

    @authorization_endpoint.setter
    def authorization_endpoint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "authorization_endpoint", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[builtins.str]:
        """
        The OAuth 2.0 client identifier.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter
    def issuer(self) -> pulumi.Input[builtins.str]:
        """
        The OIDC issuer identifier of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "issuer", value)

    @property
    @pulumi.getter(name="tokenEndpoint")
    def token_endpoint(self) -> pulumi.Input[builtins.str]:
        """
        The token endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
        """
        return pulumi.get(self, "token_endpoint")

    @token_endpoint.setter
    def token_endpoint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "token_endpoint", value)

    @property
    @pulumi.getter(name="userInfoEndpoint")
    def user_info_endpoint(self) -> pulumi.Input[builtins.str]:
        """
        The user info endpoint of the IdP. This must be a full URL, including the HTTPS protocol, the domain, and the path.
        """
        return pulumi.get(self, "user_info_endpoint")

    @user_info_endpoint.setter
    def user_info_endpoint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_info_endpoint", value)

    @property
    @pulumi.getter(name="authenticationRequestExtraParams")
    def authentication_request_extra_params(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
        """
        return pulumi.get(self, "authentication_request_extra_params")

    @authentication_request_extra_params.setter
    def authentication_request_extra_params(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "authentication_request_extra_params", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OAuth 2.0 client secret. This parameter is required if you are creating a rule. If you are modifying a rule, you can omit this parameter if you set ``UseExistingClientSecret`` to true.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="onUnauthenticatedRequest")
    def on_unauthenticated_request(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The behavior if the user is not authenticated. The following are possible values:
          +  deny```` - Return an HTTP 401 Unauthorized error.
          +  allow```` - Allow the request to be forwarded to the target.
          +  authenticate```` - Redirect the request to the IdP authorization endpoint. This is the default value.
        """
        return pulumi.get(self, "on_unauthenticated_request")

    @on_unauthenticated_request.setter
    def on_unauthenticated_request(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "on_unauthenticated_request", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The set of user claims to be requested from the IdP. The default is ``openid``.
         To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="sessionCookieName")
    def session_cookie_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the cookie used to maintain session information. The default is AWSELBAuthSessionCookie.
        """
        return pulumi.get(self, "session_cookie_name")

    @session_cookie_name.setter
    def session_cookie_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "session_cookie_name", value)

    @property
    @pulumi.getter(name="sessionTimeout")
    def session_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum duration of the authentication session, in seconds. The default is 604800 seconds (7 days).
        """
        return pulumi.get(self, "session_timeout")

    @session_timeout.setter
    def session_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "session_timeout", value)

    @property
    @pulumi.getter(name="useExistingClientSecret")
    def use_existing_client_secret(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether to use the existing client secret when modifying a rule. If you are creating a rule, you can omit this parameter or set it to false.
        """
        return pulumi.get(self, "use_existing_client_secret")

    @use_existing_client_secret.setter
    def use_existing_client_secret(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_existing_client_secret", value)


if not MYPY:
    class ListenerRuleFixedResponseConfigArgsDict(TypedDict):
        """
        Specifies information required when returning a custom HTTP response.
        """
        status_code: pulumi.Input[builtins.str]
        """
        The HTTP response code (2XX, 4XX, or 5XX).
        """
        content_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The content type.
         Valid Values: text/plain | text/css | text/html | application/javascript | application/json
        """
        message_body: NotRequired[pulumi.Input[builtins.str]]
        """
        The message.
        """
elif False:
    ListenerRuleFixedResponseConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleFixedResponseConfigArgs:
    def __init__(__self__, *,
                 status_code: pulumi.Input[builtins.str],
                 content_type: Optional[pulumi.Input[builtins.str]] = None,
                 message_body: Optional[pulumi.Input[builtins.str]] = None):
        """
        Specifies information required when returning a custom HTTP response.
        :param pulumi.Input[builtins.str] status_code: The HTTP response code (2XX, 4XX, or 5XX).
        :param pulumi.Input[builtins.str] content_type: The content type.
                Valid Values: text/plain | text/css | text/html | application/javascript | application/json
        :param pulumi.Input[builtins.str] message_body: The message.
        """
        pulumi.set(__self__, "status_code", status_code)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if message_body is not None:
            pulumi.set(__self__, "message_body", message_body)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> pulumi.Input[builtins.str]:
        """
        The HTTP response code (2XX, 4XX, or 5XX).
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "status_code", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The content type.
         Valid Values: text/plain | text/css | text/html | application/javascript | application/json
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="messageBody")
    def message_body(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The message.
        """
        return pulumi.get(self, "message_body")

    @message_body.setter
    def message_body(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "message_body", value)


if not MYPY:
    class ListenerRuleForwardConfigArgsDict(TypedDict):
        """
        Information for creating an action that distributes requests among one or more target groups. For Network Load Balancers, you can specify a single target group. Specify only when ``Type`` is ``forward``. If you specify both ``ForwardConfig`` and ``TargetGroupArn``, you can specify only one target group using ``ForwardConfig`` and it must be the same target group specified in ``TargetGroupArn``.
        """
        target_group_stickiness_config: NotRequired[pulumi.Input['ListenerRuleTargetGroupStickinessConfigArgsDict']]
        """
        Information about the target group stickiness for a rule.
        """
        target_groups: NotRequired[pulumi.Input[Sequence[pulumi.Input['ListenerRuleTargetGroupTupleArgsDict']]]]
        """
        Information about how traffic will be distributed between multiple target groups in a forward rule.
        """
elif False:
    ListenerRuleForwardConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleForwardConfigArgs:
    def __init__(__self__, *,
                 target_group_stickiness_config: Optional[pulumi.Input['ListenerRuleTargetGroupStickinessConfigArgs']] = None,
                 target_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerRuleTargetGroupTupleArgs']]]] = None):
        """
        Information for creating an action that distributes requests among one or more target groups. For Network Load Balancers, you can specify a single target group. Specify only when ``Type`` is ``forward``. If you specify both ``ForwardConfig`` and ``TargetGroupArn``, you can specify only one target group using ``ForwardConfig`` and it must be the same target group specified in ``TargetGroupArn``.
        :param pulumi.Input['ListenerRuleTargetGroupStickinessConfigArgs'] target_group_stickiness_config: Information about the target group stickiness for a rule.
        :param pulumi.Input[Sequence[pulumi.Input['ListenerRuleTargetGroupTupleArgs']]] target_groups: Information about how traffic will be distributed between multiple target groups in a forward rule.
        """
        if target_group_stickiness_config is not None:
            pulumi.set(__self__, "target_group_stickiness_config", target_group_stickiness_config)
        if target_groups is not None:
            pulumi.set(__self__, "target_groups", target_groups)

    @property
    @pulumi.getter(name="targetGroupStickinessConfig")
    def target_group_stickiness_config(self) -> Optional[pulumi.Input['ListenerRuleTargetGroupStickinessConfigArgs']]:
        """
        Information about the target group stickiness for a rule.
        """
        return pulumi.get(self, "target_group_stickiness_config")

    @target_group_stickiness_config.setter
    def target_group_stickiness_config(self, value: Optional[pulumi.Input['ListenerRuleTargetGroupStickinessConfigArgs']]):
        pulumi.set(self, "target_group_stickiness_config", value)

    @property
    @pulumi.getter(name="targetGroups")
    def target_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ListenerRuleTargetGroupTupleArgs']]]]:
        """
        Information about how traffic will be distributed between multiple target groups in a forward rule.
        """
        return pulumi.get(self, "target_groups")

    @target_groups.setter
    def target_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerRuleTargetGroupTupleArgs']]]]):
        pulumi.set(self, "target_groups", value)


if not MYPY:
    class ListenerRuleHostHeaderConfigArgsDict(TypedDict):
        """
        Information about a host header condition.
        """
        values: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The host names. The maximum size of each name is 128 characters. The comparison is case insensitive. The following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1 character).
         If you specify multiple strings, the condition is satisfied if one of the strings matches the host name.
        """
elif False:
    ListenerRuleHostHeaderConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleHostHeaderConfigArgs:
    def __init__(__self__, *,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Information about a host header condition.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] values: The host names. The maximum size of each name is 128 characters. The comparison is case insensitive. The following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1 character).
                If you specify multiple strings, the condition is satisfied if one of the strings matches the host name.
        """
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The host names. The maximum size of each name is 128 characters. The comparison is case insensitive. The following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1 character).
         If you specify multiple strings, the condition is satisfied if one of the strings matches the host name.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "values", value)


if not MYPY:
    class ListenerRuleHttpHeaderConfigArgsDict(TypedDict):
        """
        Information about an HTTP header condition.
         There is a set of standard HTTP header fields. You can also define custom HTTP header fields.
        """
        http_header_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the HTTP header field. The maximum size is 40 characters. The header name is case insensitive. The allowed characters are specified by RFC 7230. Wildcards are not supported.
        """
        values: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The strings to compare against the value of the HTTP header. The maximum size of each string is 128 characters. The comparison strings are case insensitive. The following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1 character).
         If the same header appears multiple times in the request, we search them in order until a match is found.
         If you specify multiple strings, the condition is satisfied if one of the strings matches the value of the HTTP header. To require that all of the strings are a match, create one condition per string.
        """
elif False:
    ListenerRuleHttpHeaderConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleHttpHeaderConfigArgs:
    def __init__(__self__, *,
                 http_header_name: Optional[pulumi.Input[builtins.str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Information about an HTTP header condition.
         There is a set of standard HTTP header fields. You can also define custom HTTP header fields.
        :param pulumi.Input[builtins.str] http_header_name: The name of the HTTP header field. The maximum size is 40 characters. The header name is case insensitive. The allowed characters are specified by RFC 7230. Wildcards are not supported.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] values: The strings to compare against the value of the HTTP header. The maximum size of each string is 128 characters. The comparison strings are case insensitive. The following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1 character).
                If the same header appears multiple times in the request, we search them in order until a match is found.
                If you specify multiple strings, the condition is satisfied if one of the strings matches the value of the HTTP header. To require that all of the strings are a match, create one condition per string.
        """
        if http_header_name is not None:
            pulumi.set(__self__, "http_header_name", http_header_name)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="httpHeaderName")
    def http_header_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the HTTP header field. The maximum size is 40 characters. The header name is case insensitive. The allowed characters are specified by RFC 7230. Wildcards are not supported.
        """
        return pulumi.get(self, "http_header_name")

    @http_header_name.setter
    def http_header_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "http_header_name", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The strings to compare against the value of the HTTP header. The maximum size of each string is 128 characters. The comparison strings are case insensitive. The following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1 character).
         If the same header appears multiple times in the request, we search them in order until a match is found.
         If you specify multiple strings, the condition is satisfied if one of the strings matches the value of the HTTP header. To require that all of the strings are a match, create one condition per string.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "values", value)


if not MYPY:
    class ListenerRuleHttpRequestMethodConfigArgsDict(TypedDict):
        """
        Information about an HTTP method condition.
         HTTP defines a set of request methods, also referred to as HTTP verbs. For more information, see the [HTTP Method Registry](https://docs.aws.amazon.com/https://www.iana.org/assignments/http-methods/http-methods.xhtml). You can also define custom HTTP methods.
        """
        values: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The name of the request method. The maximum size is 40 characters. The allowed characters are A-Z, hyphen (-), and underscore (_). The comparison is case sensitive. Wildcards are not supported; therefore, the method name must be an exact match.
         If you specify multiple strings, the condition is satisfied if one of the strings matches the HTTP request method. We recommend that you route GET and HEAD requests in the same way, because the response to a HEAD request may be cached.
        """
elif False:
    ListenerRuleHttpRequestMethodConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleHttpRequestMethodConfigArgs:
    def __init__(__self__, *,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Information about an HTTP method condition.
         HTTP defines a set of request methods, also referred to as HTTP verbs. For more information, see the [HTTP Method Registry](https://docs.aws.amazon.com/https://www.iana.org/assignments/http-methods/http-methods.xhtml). You can also define custom HTTP methods.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] values: The name of the request method. The maximum size is 40 characters. The allowed characters are A-Z, hyphen (-), and underscore (_). The comparison is case sensitive. Wildcards are not supported; therefore, the method name must be an exact match.
                If you specify multiple strings, the condition is satisfied if one of the strings matches the HTTP request method. We recommend that you route GET and HEAD requests in the same way, because the response to a HEAD request may be cached.
        """
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The name of the request method. The maximum size is 40 characters. The allowed characters are A-Z, hyphen (-), and underscore (_). The comparison is case sensitive. Wildcards are not supported; therefore, the method name must be an exact match.
         If you specify multiple strings, the condition is satisfied if one of the strings matches the HTTP request method. We recommend that you route GET and HEAD requests in the same way, because the response to a HEAD request may be cached.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "values", value)


if not MYPY:
    class ListenerRulePathPatternConfigArgsDict(TypedDict):
        """
        Information about a path pattern condition.
        """
        values: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The path patterns to compare against the request URL. The maximum size of each string is 128 characters. The comparison is case sensitive. The following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1 character).
         If you specify multiple strings, the condition is satisfied if one of them matches the request URL. The path pattern is compared only to the path of the URL, not to its query string.
        """
elif False:
    ListenerRulePathPatternConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRulePathPatternConfigArgs:
    def __init__(__self__, *,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Information about a path pattern condition.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] values: The path patterns to compare against the request URL. The maximum size of each string is 128 characters. The comparison is case sensitive. The following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1 character).
                If you specify multiple strings, the condition is satisfied if one of them matches the request URL. The path pattern is compared only to the path of the URL, not to its query string.
        """
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The path patterns to compare against the request URL. The maximum size of each string is 128 characters. The comparison is case sensitive. The following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1 character).
         If you specify multiple strings, the condition is satisfied if one of them matches the request URL. The path pattern is compared only to the path of the URL, not to its query string.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "values", value)


if not MYPY:
    class ListenerRuleQueryStringConfigArgsDict(TypedDict):
        """
        Information about a query string condition.
         The query string component of a URI starts after the first '?' character and is terminated by either a '#' character or the end of the URI. A typical query string contains key/value pairs separated by '&' characters. The allowed characters are specified by RFC 3986. Any character can be percentage encoded.
        """
        values: NotRequired[pulumi.Input[Sequence[pulumi.Input['ListenerRuleQueryStringKeyValueArgsDict']]]]
        """
        The key/value pairs or values to find in the query string. The maximum size of each string is 128 characters. The comparison is case insensitive. The following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1 character). To search for a literal '*' or '?' character in a query string, you must escape these characters in ``Values`` using a '\\' character.
         If you specify multiple key/value pairs or values, the condition is satisfied if one of them is found in the query string.
        """
elif False:
    ListenerRuleQueryStringConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleQueryStringConfigArgs:
    def __init__(__self__, *,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerRuleQueryStringKeyValueArgs']]]] = None):
        """
        Information about a query string condition.
         The query string component of a URI starts after the first '?' character and is terminated by either a '#' character or the end of the URI. A typical query string contains key/value pairs separated by '&' characters. The allowed characters are specified by RFC 3986. Any character can be percentage encoded.
        :param pulumi.Input[Sequence[pulumi.Input['ListenerRuleQueryStringKeyValueArgs']]] values: The key/value pairs or values to find in the query string. The maximum size of each string is 128 characters. The comparison is case insensitive. The following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1 character). To search for a literal '*' or '?' character in a query string, you must escape these characters in ``Values`` using a '\\' character.
                If you specify multiple key/value pairs or values, the condition is satisfied if one of them is found in the query string.
        """
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ListenerRuleQueryStringKeyValueArgs']]]]:
        """
        The key/value pairs or values to find in the query string. The maximum size of each string is 128 characters. The comparison is case insensitive. The following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1 character). To search for a literal '*' or '?' character in a query string, you must escape these characters in ``Values`` using a '\\' character.
         If you specify multiple key/value pairs or values, the condition is satisfied if one of them is found in the query string.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerRuleQueryStringKeyValueArgs']]]]):
        pulumi.set(self, "values", value)


if not MYPY:
    class ListenerRuleQueryStringKeyValueArgsDict(TypedDict):
        """
        Information about a key/value pair.
        """
        key: NotRequired[pulumi.Input[builtins.str]]
        """
        The key. You can omit the key.
        """
        value: NotRequired[pulumi.Input[builtins.str]]
        """
        The value.
        """
elif False:
    ListenerRuleQueryStringKeyValueArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleQueryStringKeyValueArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        Information about a key/value pair.
        :param pulumi.Input[builtins.str] key: The key. You can omit the key.
        :param pulumi.Input[builtins.str] value: The value.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The key. You can omit the key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class ListenerRuleRedirectConfigArgsDict(TypedDict):
        """
        Information about a redirect action.
         A URI consists of the following components: protocol://hostname:port/path?query. You must modify at least one of the following components to avoid a redirect loop: protocol, hostname, port, or path. Any components that you do not modify retain their original values.
         You can reuse URI components using the following reserved keywords:
          +  #{protocol}
          +  #{host}
          +  #{port}
          +  #{path} (the leading "/" is removed)
          +  #{query}
          
         For example, you can change the path to "/new/#{path}", the hostname to "example.#{host}", or the query to "#{query}&value=xyz".
        """
        status_code: pulumi.Input[builtins.str]
        """
        The HTTP redirect code. The redirect is either permanent (HTTP 301) or temporary (HTTP 302).
        """
        host: NotRequired[pulumi.Input[builtins.str]]
        """
        The hostname. This component is not percent-encoded. The hostname can contain #{host}.
        """
        path: NotRequired[pulumi.Input[builtins.str]]
        """
        The absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}.
        """
        port: NotRequired[pulumi.Input[builtins.str]]
        """
        The port. You can specify a value from 1 to 65535 or #{port}.
        """
        protocol: NotRequired[pulumi.Input[builtins.str]]
        """
        The protocol. You can specify HTTP, HTTPS, or #{protocol}. You can redirect HTTP to HTTP, HTTP to HTTPS, and HTTPS to HTTPS. You can't redirect HTTPS to HTTP.
        """
        query: NotRequired[pulumi.Input[builtins.str]]
        """
        The query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?", as it is automatically added. You can specify any of the reserved keywords.
        """
elif False:
    ListenerRuleRedirectConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleRedirectConfigArgs:
    def __init__(__self__, *,
                 status_code: pulumi.Input[builtins.str],
                 host: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 query: Optional[pulumi.Input[builtins.str]] = None):
        """
        Information about a redirect action.
         A URI consists of the following components: protocol://hostname:port/path?query. You must modify at least one of the following components to avoid a redirect loop: protocol, hostname, port, or path. Any components that you do not modify retain their original values.
         You can reuse URI components using the following reserved keywords:
          +  #{protocol}
          +  #{host}
          +  #{port}
          +  #{path} (the leading "/" is removed)
          +  #{query}
          
         For example, you can change the path to "/new/#{path}", the hostname to "example.#{host}", or the query to "#{query}&value=xyz".
        :param pulumi.Input[builtins.str] status_code: The HTTP redirect code. The redirect is either permanent (HTTP 301) or temporary (HTTP 302).
        :param pulumi.Input[builtins.str] host: The hostname. This component is not percent-encoded. The hostname can contain #{host}.
        :param pulumi.Input[builtins.str] path: The absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}.
        :param pulumi.Input[builtins.str] port: The port. You can specify a value from 1 to 65535 or #{port}.
        :param pulumi.Input[builtins.str] protocol: The protocol. You can specify HTTP, HTTPS, or #{protocol}. You can redirect HTTP to HTTP, HTTP to HTTPS, and HTTPS to HTTPS. You can't redirect HTTPS to HTTP.
        :param pulumi.Input[builtins.str] query: The query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?", as it is automatically added. You can specify any of the reserved keywords.
        """
        pulumi.set(__self__, "status_code", status_code)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if query is not None:
            pulumi.set(__self__, "query", query)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> pulumi.Input[builtins.str]:
        """
        The HTTP redirect code. The redirect is either permanent (HTTP 301) or temporary (HTTP 302).
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "status_code", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hostname. This component is not percent-encoded. The hostname can contain #{host}.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The port. You can specify a value from 1 to 65535 or #{port}.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The protocol. You can specify HTTP, HTTPS, or #{protocol}. You can redirect HTTP to HTTP, HTTP to HTTPS, and HTTPS to HTTPS. You can't redirect HTTPS to HTTP.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?", as it is automatically added. You can specify any of the reserved keywords.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "query", value)


if not MYPY:
    class ListenerRuleRuleConditionArgsDict(TypedDict):
        """
        Specifies a condition for a listener rule.
        """
        field: NotRequired[pulumi.Input[builtins.str]]
        """
        The field in the HTTP request. The following are the possible values:
          +   ``http-header`` 
          +   ``http-request-method`` 
          +   ``host-header`` 
          +   ``path-pattern`` 
          +   ``query-string`` 
          +   ``source-ip``
        """
        host_header_config: NotRequired[pulumi.Input['ListenerRuleHostHeaderConfigArgsDict']]
        """
        Information for a host header condition. Specify only when ``Field`` is ``host-header``.
        """
        http_header_config: NotRequired[pulumi.Input['ListenerRuleHttpHeaderConfigArgsDict']]
        """
        Information for an HTTP header condition. Specify only when ``Field`` is ``http-header``.
        """
        http_request_method_config: NotRequired[pulumi.Input['ListenerRuleHttpRequestMethodConfigArgsDict']]
        """
        Information for an HTTP method condition. Specify only when ``Field`` is ``http-request-method``.
        """
        path_pattern_config: NotRequired[pulumi.Input['ListenerRulePathPatternConfigArgsDict']]
        """
        Information for a path pattern condition. Specify only when ``Field`` is ``path-pattern``.
        """
        query_string_config: NotRequired[pulumi.Input['ListenerRuleQueryStringConfigArgsDict']]
        """
        Information for a query string condition. Specify only when ``Field`` is ``query-string``.
        """
        source_ip_config: NotRequired[pulumi.Input['ListenerRuleSourceIpConfigArgsDict']]
        """
        Information for a source IP condition. Specify only when ``Field`` is ``source-ip``.
        """
        values: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The condition value. Specify only when ``Field`` is ``host-header`` or ``path-pattern``. Alternatively, to specify multiple host names or multiple path patterns, use ``HostHeaderConfig`` or ``PathPatternConfig``.
         If ``Field`` is ``host-header`` and you're not using ``HostHeaderConfig``, you can specify a single host name (for example, my.example.com). A host name is case insensitive, can be up to 128 characters in length, and can contain any of the following characters.
          +  A-Z, a-z, 0-9
          +  - .
          +  * (matches 0 or more characters)
          +  ? (matches exactly 1 character)
          
         If ``Field`` is ``path-pattern`` and you're not using ``PathPatternConfig``, you can specify a single path pattern (for example, /img/*). A path pattern is case-sensitive, can be up to 128 characters in length, and can contain any of the following characters.
          +  A-Z, a-z, 0-9
          +  _ - . $ / ~ " ' @ : +
          +  & (using &amp;)
          +  * (matches 0 or more characters)
          +  ? (matches exactly 1 character)
        """
elif False:
    ListenerRuleRuleConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleRuleConditionArgs:
    def __init__(__self__, *,
                 field: Optional[pulumi.Input[builtins.str]] = None,
                 host_header_config: Optional[pulumi.Input['ListenerRuleHostHeaderConfigArgs']] = None,
                 http_header_config: Optional[pulumi.Input['ListenerRuleHttpHeaderConfigArgs']] = None,
                 http_request_method_config: Optional[pulumi.Input['ListenerRuleHttpRequestMethodConfigArgs']] = None,
                 path_pattern_config: Optional[pulumi.Input['ListenerRulePathPatternConfigArgs']] = None,
                 query_string_config: Optional[pulumi.Input['ListenerRuleQueryStringConfigArgs']] = None,
                 source_ip_config: Optional[pulumi.Input['ListenerRuleSourceIpConfigArgs']] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Specifies a condition for a listener rule.
        :param pulumi.Input[builtins.str] field: The field in the HTTP request. The following are the possible values:
                 +   ``http-header`` 
                 +   ``http-request-method`` 
                 +   ``host-header`` 
                 +   ``path-pattern`` 
                 +   ``query-string`` 
                 +   ``source-ip``
        :param pulumi.Input['ListenerRuleHostHeaderConfigArgs'] host_header_config: Information for a host header condition. Specify only when ``Field`` is ``host-header``.
        :param pulumi.Input['ListenerRuleHttpHeaderConfigArgs'] http_header_config: Information for an HTTP header condition. Specify only when ``Field`` is ``http-header``.
        :param pulumi.Input['ListenerRuleHttpRequestMethodConfigArgs'] http_request_method_config: Information for an HTTP method condition. Specify only when ``Field`` is ``http-request-method``.
        :param pulumi.Input['ListenerRulePathPatternConfigArgs'] path_pattern_config: Information for a path pattern condition. Specify only when ``Field`` is ``path-pattern``.
        :param pulumi.Input['ListenerRuleQueryStringConfigArgs'] query_string_config: Information for a query string condition. Specify only when ``Field`` is ``query-string``.
        :param pulumi.Input['ListenerRuleSourceIpConfigArgs'] source_ip_config: Information for a source IP condition. Specify only when ``Field`` is ``source-ip``.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] values: The condition value. Specify only when ``Field`` is ``host-header`` or ``path-pattern``. Alternatively, to specify multiple host names or multiple path patterns, use ``HostHeaderConfig`` or ``PathPatternConfig``.
                If ``Field`` is ``host-header`` and you're not using ``HostHeaderConfig``, you can specify a single host name (for example, my.example.com). A host name is case insensitive, can be up to 128 characters in length, and can contain any of the following characters.
                 +  A-Z, a-z, 0-9
                 +  - .
                 +  * (matches 0 or more characters)
                 +  ? (matches exactly 1 character)
                 
                If ``Field`` is ``path-pattern`` and you're not using ``PathPatternConfig``, you can specify a single path pattern (for example, /img/*). A path pattern is case-sensitive, can be up to 128 characters in length, and can contain any of the following characters.
                 +  A-Z, a-z, 0-9
                 +  _ - . $ / ~ " ' @ : +
                 +  & (using &amp;)
                 +  * (matches 0 or more characters)
                 +  ? (matches exactly 1 character)
        """
        if field is not None:
            pulumi.set(__self__, "field", field)
        if host_header_config is not None:
            pulumi.set(__self__, "host_header_config", host_header_config)
        if http_header_config is not None:
            pulumi.set(__self__, "http_header_config", http_header_config)
        if http_request_method_config is not None:
            pulumi.set(__self__, "http_request_method_config", http_request_method_config)
        if path_pattern_config is not None:
            pulumi.set(__self__, "path_pattern_config", path_pattern_config)
        if query_string_config is not None:
            pulumi.set(__self__, "query_string_config", query_string_config)
        if source_ip_config is not None:
            pulumi.set(__self__, "source_ip_config", source_ip_config)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def field(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The field in the HTTP request. The following are the possible values:
          +   ``http-header`` 
          +   ``http-request-method`` 
          +   ``host-header`` 
          +   ``path-pattern`` 
          +   ``query-string`` 
          +   ``source-ip``
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "field", value)

    @property
    @pulumi.getter(name="hostHeaderConfig")
    def host_header_config(self) -> Optional[pulumi.Input['ListenerRuleHostHeaderConfigArgs']]:
        """
        Information for a host header condition. Specify only when ``Field`` is ``host-header``.
        """
        return pulumi.get(self, "host_header_config")

    @host_header_config.setter
    def host_header_config(self, value: Optional[pulumi.Input['ListenerRuleHostHeaderConfigArgs']]):
        pulumi.set(self, "host_header_config", value)

    @property
    @pulumi.getter(name="httpHeaderConfig")
    def http_header_config(self) -> Optional[pulumi.Input['ListenerRuleHttpHeaderConfigArgs']]:
        """
        Information for an HTTP header condition. Specify only when ``Field`` is ``http-header``.
        """
        return pulumi.get(self, "http_header_config")

    @http_header_config.setter
    def http_header_config(self, value: Optional[pulumi.Input['ListenerRuleHttpHeaderConfigArgs']]):
        pulumi.set(self, "http_header_config", value)

    @property
    @pulumi.getter(name="httpRequestMethodConfig")
    def http_request_method_config(self) -> Optional[pulumi.Input['ListenerRuleHttpRequestMethodConfigArgs']]:
        """
        Information for an HTTP method condition. Specify only when ``Field`` is ``http-request-method``.
        """
        return pulumi.get(self, "http_request_method_config")

    @http_request_method_config.setter
    def http_request_method_config(self, value: Optional[pulumi.Input['ListenerRuleHttpRequestMethodConfigArgs']]):
        pulumi.set(self, "http_request_method_config", value)

    @property
    @pulumi.getter(name="pathPatternConfig")
    def path_pattern_config(self) -> Optional[pulumi.Input['ListenerRulePathPatternConfigArgs']]:
        """
        Information for a path pattern condition. Specify only when ``Field`` is ``path-pattern``.
        """
        return pulumi.get(self, "path_pattern_config")

    @path_pattern_config.setter
    def path_pattern_config(self, value: Optional[pulumi.Input['ListenerRulePathPatternConfigArgs']]):
        pulumi.set(self, "path_pattern_config", value)

    @property
    @pulumi.getter(name="queryStringConfig")
    def query_string_config(self) -> Optional[pulumi.Input['ListenerRuleQueryStringConfigArgs']]:
        """
        Information for a query string condition. Specify only when ``Field`` is ``query-string``.
        """
        return pulumi.get(self, "query_string_config")

    @query_string_config.setter
    def query_string_config(self, value: Optional[pulumi.Input['ListenerRuleQueryStringConfigArgs']]):
        pulumi.set(self, "query_string_config", value)

    @property
    @pulumi.getter(name="sourceIpConfig")
    def source_ip_config(self) -> Optional[pulumi.Input['ListenerRuleSourceIpConfigArgs']]:
        """
        Information for a source IP condition. Specify only when ``Field`` is ``source-ip``.
        """
        return pulumi.get(self, "source_ip_config")

    @source_ip_config.setter
    def source_ip_config(self, value: Optional[pulumi.Input['ListenerRuleSourceIpConfigArgs']]):
        pulumi.set(self, "source_ip_config", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The condition value. Specify only when ``Field`` is ``host-header`` or ``path-pattern``. Alternatively, to specify multiple host names or multiple path patterns, use ``HostHeaderConfig`` or ``PathPatternConfig``.
         If ``Field`` is ``host-header`` and you're not using ``HostHeaderConfig``, you can specify a single host name (for example, my.example.com). A host name is case insensitive, can be up to 128 characters in length, and can contain any of the following characters.
          +  A-Z, a-z, 0-9
          +  - .
          +  * (matches 0 or more characters)
          +  ? (matches exactly 1 character)
          
         If ``Field`` is ``path-pattern`` and you're not using ``PathPatternConfig``, you can specify a single path pattern (for example, /img/*). A path pattern is case-sensitive, can be up to 128 characters in length, and can contain any of the following characters.
          +  A-Z, a-z, 0-9
          +  _ - . $ / ~ " ' @ : +
          +  & (using &amp;)
          +  * (matches 0 or more characters)
          +  ? (matches exactly 1 character)
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "values", value)


if not MYPY:
    class ListenerRuleSourceIpConfigArgsDict(TypedDict):
        """
        Information about a source IP condition.
         You can use this condition to route based on the IP address of the source that connects to the load balancer. If a client is behind a proxy, this is the IP address of the proxy not the IP address of the client.
        """
        values: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The source IP addresses, in CIDR format. You can use both IPv4 and IPv6 addresses. Wildcards are not supported.
         If you specify multiple addresses, the condition is satisfied if the source IP address of the request matches one of the CIDR blocks. This condition is not satisfied by the addresses in the X-Forwarded-For header.
        """
elif False:
    ListenerRuleSourceIpConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleSourceIpConfigArgs:
    def __init__(__self__, *,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Information about a source IP condition.
         You can use this condition to route based on the IP address of the source that connects to the load balancer. If a client is behind a proxy, this is the IP address of the proxy not the IP address of the client.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] values: The source IP addresses, in CIDR format. You can use both IPv4 and IPv6 addresses. Wildcards are not supported.
                If you specify multiple addresses, the condition is satisfied if the source IP address of the request matches one of the CIDR blocks. This condition is not satisfied by the addresses in the X-Forwarded-For header.
        """
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The source IP addresses, in CIDR format. You can use both IPv4 and IPv6 addresses. Wildcards are not supported.
         If you specify multiple addresses, the condition is satisfied if the source IP address of the request matches one of the CIDR blocks. This condition is not satisfied by the addresses in the X-Forwarded-For header.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "values", value)


if not MYPY:
    class ListenerRuleTargetGroupStickinessConfigArgsDict(TypedDict):
        """
        Information about the target group stickiness for a rule.
        """
        duration_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        The time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).
        """
        enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates whether target group stickiness is enabled.
        """
elif False:
    ListenerRuleTargetGroupStickinessConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleTargetGroupStickinessConfigArgs:
    def __init__(__self__, *,
                 duration_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Information about the target group stickiness for a rule.
        :param pulumi.Input[builtins.int] duration_seconds: The time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).
        :param pulumi.Input[builtins.bool] enabled: Indicates whether target group stickiness is enabled.
        """
        if duration_seconds is not None:
            pulumi.set(__self__, "duration_seconds", duration_seconds)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="durationSeconds")
    def duration_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).
        """
        return pulumi.get(self, "duration_seconds")

    @duration_seconds.setter
    def duration_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "duration_seconds", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether target group stickiness is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class ListenerRuleTargetGroupTupleArgsDict(TypedDict):
        """
        Information about how traffic will be distributed between multiple target groups in a forward rule.
        """
        target_group_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) of the target group.
        """
        weight: NotRequired[pulumi.Input[builtins.int]]
        """
        The weight. The range is 0 to 999.
        """
elif False:
    ListenerRuleTargetGroupTupleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerRuleTargetGroupTupleArgs:
    def __init__(__self__, *,
                 target_group_arn: Optional[pulumi.Input[builtins.str]] = None,
                 weight: Optional[pulumi.Input[builtins.int]] = None):
        """
        Information about how traffic will be distributed between multiple target groups in a forward rule.
        :param pulumi.Input[builtins.str] target_group_arn: The Amazon Resource Name (ARN) of the target group.
        :param pulumi.Input[builtins.int] weight: The weight. The range is 0 to 999.
        """
        if target_group_arn is not None:
            pulumi.set(__self__, "target_group_arn", target_group_arn)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the target group.
        """
        return pulumi.get(self, "target_group_arn")

    @target_group_arn.setter
    def target_group_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_group_arn", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The weight. The range is 0 to 999.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "weight", value)


if not MYPY:
    class ListenerTargetGroupStickinessConfigArgsDict(TypedDict):
        """
        Information about the target group stickiness for a rule.
        """
        duration_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        The time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).
        """
        enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates whether target group stickiness is enabled.
        """
elif False:
    ListenerTargetGroupStickinessConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerTargetGroupStickinessConfigArgs:
    def __init__(__self__, *,
                 duration_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Information about the target group stickiness for a rule.
        :param pulumi.Input[builtins.int] duration_seconds: The time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).
        :param pulumi.Input[builtins.bool] enabled: Indicates whether target group stickiness is enabled.
        """
        if duration_seconds is not None:
            pulumi.set(__self__, "duration_seconds", duration_seconds)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="durationSeconds")
    def duration_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The time period, in seconds, during which requests from a client should be routed to the same target group. The range is 1-604800 seconds (7 days).
        """
        return pulumi.get(self, "duration_seconds")

    @duration_seconds.setter
    def duration_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "duration_seconds", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether target group stickiness is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class ListenerTargetGroupTupleArgsDict(TypedDict):
        """
        Information about how traffic will be distributed between multiple target groups in a forward rule.
        """
        target_group_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) of the target group.
        """
        weight: NotRequired[pulumi.Input[builtins.int]]
        """
        The weight. The range is 0 to 999.
        """
elif False:
    ListenerTargetGroupTupleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ListenerTargetGroupTupleArgs:
    def __init__(__self__, *,
                 target_group_arn: Optional[pulumi.Input[builtins.str]] = None,
                 weight: Optional[pulumi.Input[builtins.int]] = None):
        """
        Information about how traffic will be distributed between multiple target groups in a forward rule.
        :param pulumi.Input[builtins.str] target_group_arn: The Amazon Resource Name (ARN) of the target group.
        :param pulumi.Input[builtins.int] weight: The weight. The range is 0 to 999.
        """
        if target_group_arn is not None:
            pulumi.set(__self__, "target_group_arn", target_group_arn)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the target group.
        """
        return pulumi.get(self, "target_group_arn")

    @target_group_arn.setter
    def target_group_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_group_arn", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The weight. The range is 0 to 999.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "weight", value)


if not MYPY:
    class LoadBalancerAttributeArgsDict(TypedDict):
        """
        Specifies an attribute for an Application Load Balancer, a Network Load Balancer, or a Gateway Load Balancer.
        """
        key: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the attribute.
         The following attributes are supported by all load balancers:
          +  ``deletion_protection.enabled`` - Indicates whether deletion protection is enabled. The value is ``true`` or ``false``. The default is ``false``.
          +  ``load_balancing.cross_zone.enabled`` - Indicates whether cross-zone load balancing is enabled. The possible values are ``true`` and ``false``. The default for Network Load Balancers and Gateway Load Balancers is ``false``. The default for Application Load Balancers is ``true``, and can't be changed.
          
         The following attributes are supported by both Application Load Balancers and Network Load Balancers:
          +  ``access_logs.s3.enabled`` - Indicates whether access logs are enabled. The value is ``true`` or ``false``. The default is ``false``.
          +  ``access_logs.s3.bucket`` - The name of the S3 bucket for the access logs. This attribute is required if access logs are enabled. The bucket must exist in the same region as the load balancer and have a bucket policy that grants Elastic Load Balancing permissions to write to the bucket.
          +  ``access_logs.s3.prefix`` - The prefix for the location in the S3 bucket for the access logs.
          +  ``ipv6.deny_all_igw_traffic`` - Blocks internet gateway (IGW) access to the load balancer. It is set to ``false`` for internet-facing load balancers and ``true`` for internal load balancers, preventing unintended access to your internal load balancer through an internet gateway.
          +  ``zonal_shift.config.enabled`` - Indicates whether zonal shift is enabled. The possible values are ``true`` and ``false``. The default is ``false``.
          
         The following attributes are supported by only Application Load Balancers:
          +  ``idle_timeout.timeout_seconds`` - The idle timeout value, in seconds. The valid range is 1-4000 seconds. The default is 60 seconds.
          +  ``client_keep_alive.seconds`` - The client keep alive value, in seconds. The valid range is 60-604800 seconds. The default is 3600 seconds.
          +  ``connection_logs.s3.enabled`` - Indicates whether connection logs are enabled. The value is ``true`` or ``false``. The default is ``false``.
          +  ``connection_logs.s3.bucket`` - The name of the S3 bucket for the connection logs. This attribute is required if connection logs are enabled. The bucket must exist in the same region as the load balancer and have a bucket policy that grants Elastic Load Balancing permissions to write to the bucket.
          +  ``connection_logs.s3.prefix`` - The prefix for the location in the S3 bucket for the connection logs.
          +  ``routing.http.desync_mitigation_mode`` - Determines how the load balancer handles requests that might pose a security risk to your application. The possible values are ``monitor``, ``defensive``, and ``strictest``. The default is ``defensive``.
          +  ``routing.http.drop_invalid_header_fields.enabled`` - Indicates whether HTTP headers with invalid header fields are removed by the load balancer (``true``) or routed to targets (``false``). The default is ``false``.
          +  ``routing.http.preserve_host_header.enabled`` - Indicates whether the Application Load Balancer should preserve the ``Host`` header in the HTTP request and send it to the target without any change. The possible values are ``true`` and ``false``. The default is ``false``.
          +  ``routing.http.x_amzn_tls_version_and_cipher_suite.enabled`` - Indicates whether the two headers (``x-amzn-tls-version`` and ``x-amzn-tls-cipher-suite``), which contain information about the negotiated TLS version and cipher suite, are added to the client request before sending it to the target. The ``x-amzn-tls-version`` header has information about the TLS protocol version negotiated with the client, and the ``x-amzn-tls-cipher-suite`` header has information about the cipher suite negotiated with the client. Both headers are in OpenSSL format. The possible values for the attribute are ``true`` and ``false``. The default is ``false``.
          +  ``routing.http.xff_client_port.enabled`` - Indicates whether the ``X-Forwarded-For`` header should preserve the source port that the client used to connect to the load balancer. The possible values are ``true`` and ``false``. The default is ``false``.
          +  ``routing.http.xff_header_processing.mode`` - Enables you to modify, preserve, or remove the ``X-Forwarded-For`` header in the HTTP request before the Application Load Balancer sends the request to the target. The possible values are ``append``, ``preserve``, and ``remove``. The default is ``append``.
          +  If the value is ``append``, the Application Load Balancer adds the client IP address (of the last hop) to the ``X-Forwarded-For`` header in the HTTP request before it sends it to targets.
          +  If the value is ``preserve`` the Application Load Balancer preserves the ``X-Forwarded-For`` header in the HTTP request, and sends it to targets without any change.
          +  If the value is ``remove``, the Application Load Balancer removes the ``X-Forwarded-For`` header in the HTTP request before it sends it to targets.
          
          +  ``routing.http2.enabled`` - Indicates whether HTTP/2 is enabled. The possible values are ``true`` and ``false``. The default is ``true``. Elastic Load Balancing requires that message header names contain only alphanumeric characters and hyphens.
          +  ``waf.fail_open.enabled`` - Indicates whether to allow a WAF-enabled load balancer to route requests to targets if it is unable to forward the request to AWS WAF. The possible values are ``true`` and ``false``. The default is ``false``.
          
         The following attributes are supported by only Network Load Balancers:
          +  ``dns_record.client_routing_policy`` - Indicates how traffic is distributed among the load balancer Availability Zones. The possible values are ``availability_zone_affinity`` with 100 percent zonal affinity, ``partial_availability_zone_affinity`` with 85 percent zonal affinity, and ``any_availability_zone`` with 0 percent zonal affinity.
        """
        value: NotRequired[pulumi.Input[builtins.str]]
        """
        The value of the attribute.
        """
elif False:
    LoadBalancerAttributeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadBalancerAttributeArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        Specifies an attribute for an Application Load Balancer, a Network Load Balancer, or a Gateway Load Balancer.
        :param pulumi.Input[builtins.str] key: The name of the attribute.
                The following attributes are supported by all load balancers:
                 +  ``deletion_protection.enabled`` - Indicates whether deletion protection is enabled. The value is ``true`` or ``false``. The default is ``false``.
                 +  ``load_balancing.cross_zone.enabled`` - Indicates whether cross-zone load balancing is enabled. The possible values are ``true`` and ``false``. The default for Network Load Balancers and Gateway Load Balancers is ``false``. The default for Application Load Balancers is ``true``, and can't be changed.
                 
                The following attributes are supported by both Application Load Balancers and Network Load Balancers:
                 +  ``access_logs.s3.enabled`` - Indicates whether access logs are enabled. The value is ``true`` or ``false``. The default is ``false``.
                 +  ``access_logs.s3.bucket`` - The name of the S3 bucket for the access logs. This attribute is required if access logs are enabled. The bucket must exist in the same region as the load balancer and have a bucket policy that grants Elastic Load Balancing permissions to write to the bucket.
                 +  ``access_logs.s3.prefix`` - The prefix for the location in the S3 bucket for the access logs.
                 +  ``ipv6.deny_all_igw_traffic`` - Blocks internet gateway (IGW) access to the load balancer. It is set to ``false`` for internet-facing load balancers and ``true`` for internal load balancers, preventing unintended access to your internal load balancer through an internet gateway.
                 +  ``zonal_shift.config.enabled`` - Indicates whether zonal shift is enabled. The possible values are ``true`` and ``false``. The default is ``false``.
                 
                The following attributes are supported by only Application Load Balancers:
                 +  ``idle_timeout.timeout_seconds`` - The idle timeout value, in seconds. The valid range is 1-4000 seconds. The default is 60 seconds.
                 +  ``client_keep_alive.seconds`` - The client keep alive value, in seconds. The valid range is 60-604800 seconds. The default is 3600 seconds.
                 +  ``connection_logs.s3.enabled`` - Indicates whether connection logs are enabled. The value is ``true`` or ``false``. The default is ``false``.
                 +  ``connection_logs.s3.bucket`` - The name of the S3 bucket for the connection logs. This attribute is required if connection logs are enabled. The bucket must exist in the same region as the load balancer and have a bucket policy that grants Elastic Load Balancing permissions to write to the bucket.
                 +  ``connection_logs.s3.prefix`` - The prefix for the location in the S3 bucket for the connection logs.
                 +  ``routing.http.desync_mitigation_mode`` - Determines how the load balancer handles requests that might pose a security risk to your application. The possible values are ``monitor``, ``defensive``, and ``strictest``. The default is ``defensive``.
                 +  ``routing.http.drop_invalid_header_fields.enabled`` - Indicates whether HTTP headers with invalid header fields are removed by the load balancer (``true``) or routed to targets (``false``). The default is ``false``.
                 +  ``routing.http.preserve_host_header.enabled`` - Indicates whether the Application Load Balancer should preserve the ``Host`` header in the HTTP request and send it to the target without any change. The possible values are ``true`` and ``false``. The default is ``false``.
                 +  ``routing.http.x_amzn_tls_version_and_cipher_suite.enabled`` - Indicates whether the two headers (``x-amzn-tls-version`` and ``x-amzn-tls-cipher-suite``), which contain information about the negotiated TLS version and cipher suite, are added to the client request before sending it to the target. The ``x-amzn-tls-version`` header has information about the TLS protocol version negotiated with the client, and the ``x-amzn-tls-cipher-suite`` header has information about the cipher suite negotiated with the client. Both headers are in OpenSSL format. The possible values for the attribute are ``true`` and ``false``. The default is ``false``.
                 +  ``routing.http.xff_client_port.enabled`` - Indicates whether the ``X-Forwarded-For`` header should preserve the source port that the client used to connect to the load balancer. The possible values are ``true`` and ``false``. The default is ``false``.
                 +  ``routing.http.xff_header_processing.mode`` - Enables you to modify, preserve, or remove the ``X-Forwarded-For`` header in the HTTP request before the Application Load Balancer sends the request to the target. The possible values are ``append``, ``preserve``, and ``remove``. The default is ``append``.
                 +  If the value is ``append``, the Application Load Balancer adds the client IP address (of the last hop) to the ``X-Forwarded-For`` header in the HTTP request before it sends it to targets.
                 +  If the value is ``preserve`` the Application Load Balancer preserves the ``X-Forwarded-For`` header in the HTTP request, and sends it to targets without any change.
                 +  If the value is ``remove``, the Application Load Balancer removes the ``X-Forwarded-For`` header in the HTTP request before it sends it to targets.
                 
                 +  ``routing.http2.enabled`` - Indicates whether HTTP/2 is enabled. The possible values are ``true`` and ``false``. The default is ``true``. Elastic Load Balancing requires that message header names contain only alphanumeric characters and hyphens.
                 +  ``waf.fail_open.enabled`` - Indicates whether to allow a WAF-enabled load balancer to route requests to targets if it is unable to forward the request to AWS WAF. The possible values are ``true`` and ``false``. The default is ``false``.
                 
                The following attributes are supported by only Network Load Balancers:
                 +  ``dns_record.client_routing_policy`` - Indicates how traffic is distributed among the load balancer Availability Zones. The possible values are ``availability_zone_affinity`` with 100 percent zonal affinity, ``partial_availability_zone_affinity`` with 85 percent zonal affinity, and ``any_availability_zone`` with 0 percent zonal affinity.
        :param pulumi.Input[builtins.str] value: The value of the attribute.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the attribute.
         The following attributes are supported by all load balancers:
          +  ``deletion_protection.enabled`` - Indicates whether deletion protection is enabled. The value is ``true`` or ``false``. The default is ``false``.
          +  ``load_balancing.cross_zone.enabled`` - Indicates whether cross-zone load balancing is enabled. The possible values are ``true`` and ``false``. The default for Network Load Balancers and Gateway Load Balancers is ``false``. The default for Application Load Balancers is ``true``, and can't be changed.
          
         The following attributes are supported by both Application Load Balancers and Network Load Balancers:
          +  ``access_logs.s3.enabled`` - Indicates whether access logs are enabled. The value is ``true`` or ``false``. The default is ``false``.
          +  ``access_logs.s3.bucket`` - The name of the S3 bucket for the access logs. This attribute is required if access logs are enabled. The bucket must exist in the same region as the load balancer and have a bucket policy that grants Elastic Load Balancing permissions to write to the bucket.
          +  ``access_logs.s3.prefix`` - The prefix for the location in the S3 bucket for the access logs.
          +  ``ipv6.deny_all_igw_traffic`` - Blocks internet gateway (IGW) access to the load balancer. It is set to ``false`` for internet-facing load balancers and ``true`` for internal load balancers, preventing unintended access to your internal load balancer through an internet gateway.
          +  ``zonal_shift.config.enabled`` - Indicates whether zonal shift is enabled. The possible values are ``true`` and ``false``. The default is ``false``.
          
         The following attributes are supported by only Application Load Balancers:
          +  ``idle_timeout.timeout_seconds`` - The idle timeout value, in seconds. The valid range is 1-4000 seconds. The default is 60 seconds.
          +  ``client_keep_alive.seconds`` - The client keep alive value, in seconds. The valid range is 60-604800 seconds. The default is 3600 seconds.
          +  ``connection_logs.s3.enabled`` - Indicates whether connection logs are enabled. The value is ``true`` or ``false``. The default is ``false``.
          +  ``connection_logs.s3.bucket`` - The name of the S3 bucket for the connection logs. This attribute is required if connection logs are enabled. The bucket must exist in the same region as the load balancer and have a bucket policy that grants Elastic Load Balancing permissions to write to the bucket.
          +  ``connection_logs.s3.prefix`` - The prefix for the location in the S3 bucket for the connection logs.
          +  ``routing.http.desync_mitigation_mode`` - Determines how the load balancer handles requests that might pose a security risk to your application. The possible values are ``monitor``, ``defensive``, and ``strictest``. The default is ``defensive``.
          +  ``routing.http.drop_invalid_header_fields.enabled`` - Indicates whether HTTP headers with invalid header fields are removed by the load balancer (``true``) or routed to targets (``false``). The default is ``false``.
          +  ``routing.http.preserve_host_header.enabled`` - Indicates whether the Application Load Balancer should preserve the ``Host`` header in the HTTP request and send it to the target without any change. The possible values are ``true`` and ``false``. The default is ``false``.
          +  ``routing.http.x_amzn_tls_version_and_cipher_suite.enabled`` - Indicates whether the two headers (``x-amzn-tls-version`` and ``x-amzn-tls-cipher-suite``), which contain information about the negotiated TLS version and cipher suite, are added to the client request before sending it to the target. The ``x-amzn-tls-version`` header has information about the TLS protocol version negotiated with the client, and the ``x-amzn-tls-cipher-suite`` header has information about the cipher suite negotiated with the client. Both headers are in OpenSSL format. The possible values for the attribute are ``true`` and ``false``. The default is ``false``.
          +  ``routing.http.xff_client_port.enabled`` - Indicates whether the ``X-Forwarded-For`` header should preserve the source port that the client used to connect to the load balancer. The possible values are ``true`` and ``false``. The default is ``false``.
          +  ``routing.http.xff_header_processing.mode`` - Enables you to modify, preserve, or remove the ``X-Forwarded-For`` header in the HTTP request before the Application Load Balancer sends the request to the target. The possible values are ``append``, ``preserve``, and ``remove``. The default is ``append``.
          +  If the value is ``append``, the Application Load Balancer adds the client IP address (of the last hop) to the ``X-Forwarded-For`` header in the HTTP request before it sends it to targets.
          +  If the value is ``preserve`` the Application Load Balancer preserves the ``X-Forwarded-For`` header in the HTTP request, and sends it to targets without any change.
          +  If the value is ``remove``, the Application Load Balancer removes the ``X-Forwarded-For`` header in the HTTP request before it sends it to targets.
          
          +  ``routing.http2.enabled`` - Indicates whether HTTP/2 is enabled. The possible values are ``true`` and ``false``. The default is ``true``. Elastic Load Balancing requires that message header names contain only alphanumeric characters and hyphens.
          +  ``waf.fail_open.enabled`` - Indicates whether to allow a WAF-enabled load balancer to route requests to targets if it is unable to forward the request to AWS WAF. The possible values are ``true`` and ``false``. The default is ``false``.
          
         The following attributes are supported by only Network Load Balancers:
          +  ``dns_record.client_routing_policy`` - Indicates how traffic is distributed among the load balancer Availability Zones. The possible values are ``availability_zone_affinity`` with 100 percent zonal affinity, ``partial_availability_zone_affinity`` with 85 percent zonal affinity, and ``any_availability_zone`` with 0 percent zonal affinity.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value of the attribute.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class LoadBalancerMinimumLoadBalancerCapacityArgsDict(TypedDict):
        """
        The minimum capacity for a load balancer.
        """
        capacity_units: pulumi.Input[builtins.int]
        """
        The number of capacity units.
        """
elif False:
    LoadBalancerMinimumLoadBalancerCapacityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadBalancerMinimumLoadBalancerCapacityArgs:
    def __init__(__self__, *,
                 capacity_units: pulumi.Input[builtins.int]):
        """
        The minimum capacity for a load balancer.
        :param pulumi.Input[builtins.int] capacity_units: The number of capacity units.
        """
        pulumi.set(__self__, "capacity_units", capacity_units)

    @property
    @pulumi.getter(name="capacityUnits")
    def capacity_units(self) -> pulumi.Input[builtins.int]:
        """
        The number of capacity units.
        """
        return pulumi.get(self, "capacity_units")

    @capacity_units.setter
    def capacity_units(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "capacity_units", value)


if not MYPY:
    class LoadBalancerSubnetMappingArgsDict(TypedDict):
        """
        Specifies a subnet for a load balancer.
        """
        subnet_id: pulumi.Input[builtins.str]
        """
        The ID of the subnet.
        """
        allocation_id: NotRequired[pulumi.Input[builtins.str]]
        """
        [Network Load Balancers] The allocation ID of the Elastic IP address for an internet-facing load balancer.
        """
        i_pv6_address: NotRequired[pulumi.Input[builtins.str]]
        """
        [Network Load Balancers] The IPv6 address.
        """
        private_i_pv4_address: NotRequired[pulumi.Input[builtins.str]]
        """
        [Network Load Balancers] The private IPv4 address for an internal load balancer.
        """
        source_nat_ipv6_prefix: NotRequired[pulumi.Input[builtins.str]]
        """
        [Network Load Balancers with UDP listeners] The IPv6 prefix to use for source NAT. Specify an IPv6 prefix (/80 netmask) from the subnet CIDR block or ``auto_assigned`` to use an IPv6 prefix selected at random from the subnet CIDR block.
        """
elif False:
    LoadBalancerSubnetMappingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoadBalancerSubnetMappingArgs:
    def __init__(__self__, *,
                 subnet_id: pulumi.Input[builtins.str],
                 allocation_id: Optional[pulumi.Input[builtins.str]] = None,
                 i_pv6_address: Optional[pulumi.Input[builtins.str]] = None,
                 private_i_pv4_address: Optional[pulumi.Input[builtins.str]] = None,
                 source_nat_ipv6_prefix: Optional[pulumi.Input[builtins.str]] = None):
        """
        Specifies a subnet for a load balancer.
        :param pulumi.Input[builtins.str] subnet_id: The ID of the subnet.
        :param pulumi.Input[builtins.str] allocation_id: [Network Load Balancers] The allocation ID of the Elastic IP address for an internet-facing load balancer.
        :param pulumi.Input[builtins.str] i_pv6_address: [Network Load Balancers] The IPv6 address.
        :param pulumi.Input[builtins.str] private_i_pv4_address: [Network Load Balancers] The private IPv4 address for an internal load balancer.
        :param pulumi.Input[builtins.str] source_nat_ipv6_prefix: [Network Load Balancers with UDP listeners] The IPv6 prefix to use for source NAT. Specify an IPv6 prefix (/80 netmask) from the subnet CIDR block or ``auto_assigned`` to use an IPv6 prefix selected at random from the subnet CIDR block.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if allocation_id is not None:
            pulumi.set(__self__, "allocation_id", allocation_id)
        if i_pv6_address is not None:
            pulumi.set(__self__, "i_pv6_address", i_pv6_address)
        if private_i_pv4_address is not None:
            pulumi.set(__self__, "private_i_pv4_address", private_i_pv4_address)
        if source_nat_ipv6_prefix is not None:
            pulumi.set(__self__, "source_nat_ipv6_prefix", source_nat_ipv6_prefix)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the subnet.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        [Network Load Balancers] The allocation ID of the Elastic IP address for an internet-facing load balancer.
        """
        return pulumi.get(self, "allocation_id")

    @allocation_id.setter
    def allocation_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "allocation_id", value)

    @property
    @pulumi.getter(name="iPv6Address")
    def i_pv6_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        [Network Load Balancers] The IPv6 address.
        """
        return pulumi.get(self, "i_pv6_address")

    @i_pv6_address.setter
    def i_pv6_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "i_pv6_address", value)

    @property
    @pulumi.getter(name="privateIPv4Address")
    def private_i_pv4_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        [Network Load Balancers] The private IPv4 address for an internal load balancer.
        """
        return pulumi.get(self, "private_i_pv4_address")

    @private_i_pv4_address.setter
    def private_i_pv4_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_i_pv4_address", value)

    @property
    @pulumi.getter(name="sourceNatIpv6Prefix")
    def source_nat_ipv6_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        [Network Load Balancers with UDP listeners] The IPv6 prefix to use for source NAT. Specify an IPv6 prefix (/80 netmask) from the subnet CIDR block or ``auto_assigned`` to use an IPv6 prefix selected at random from the subnet CIDR block.
        """
        return pulumi.get(self, "source_nat_ipv6_prefix")

    @source_nat_ipv6_prefix.setter
    def source_nat_ipv6_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_nat_ipv6_prefix", value)


if not MYPY:
    class TargetGroupAttributeArgsDict(TypedDict):
        key: NotRequired[pulumi.Input[builtins.str]]
        """
        The value of the attribute.
        """
        value: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the attribute.
        """
elif False:
    TargetGroupAttributeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TargetGroupAttributeArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] key: The value of the attribute.
        :param pulumi.Input[builtins.str] value: The name of the attribute.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value of the attribute.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the attribute.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class TargetGroupMatcherArgsDict(TypedDict):
        grpc_code: NotRequired[pulumi.Input[builtins.str]]
        """
        You can specify values between 0 and 99. You can specify multiple values, or a range of values. The default value is 12.
        """
        http_code: NotRequired[pulumi.Input[builtins.str]]
        """
        For Application Load Balancers, you can specify values between 200 and 499, and the default value is 200. You can specify multiple values or a range of values. 
        """
elif False:
    TargetGroupMatcherArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TargetGroupMatcherArgs:
    def __init__(__self__, *,
                 grpc_code: Optional[pulumi.Input[builtins.str]] = None,
                 http_code: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] grpc_code: You can specify values between 0 and 99. You can specify multiple values, or a range of values. The default value is 12.
        :param pulumi.Input[builtins.str] http_code: For Application Load Balancers, you can specify values between 200 and 499, and the default value is 200. You can specify multiple values or a range of values. 
        """
        if grpc_code is not None:
            pulumi.set(__self__, "grpc_code", grpc_code)
        if http_code is not None:
            pulumi.set(__self__, "http_code", http_code)

    @property
    @pulumi.getter(name="grpcCode")
    def grpc_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        You can specify values between 0 and 99. You can specify multiple values, or a range of values. The default value is 12.
        """
        return pulumi.get(self, "grpc_code")

    @grpc_code.setter
    def grpc_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "grpc_code", value)

    @property
    @pulumi.getter(name="httpCode")
    def http_code(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        For Application Load Balancers, you can specify values between 200 and 499, and the default value is 200. You can specify multiple values or a range of values. 
        """
        return pulumi.get(self, "http_code")

    @http_code.setter
    def http_code(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "http_code", value)


if not MYPY:
    class TargetGroupTargetDescriptionArgsDict(TypedDict):
        id: pulumi.Input[builtins.str]
        """
        The ID of the target. If the target type of the target group is instance, specify an instance ID. If the target type is ip, specify an IP address. If the target type is lambda, specify the ARN of the Lambda function. If the target type is alb, specify the ARN of the Application Load Balancer target. 
        """
        availability_zone: NotRequired[pulumi.Input[builtins.str]]
        """
        An Availability Zone or all. This determines whether the target receives traffic from the load balancer nodes in the specified Availability Zone or from all enabled Availability Zones for the load balancer.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        The port on which the target is listening. If the target group protocol is GENEVE, the supported port is 6081. If the target type is alb, the targeted Application Load Balancer must have at least one listener whose port matches the target group port. Not used if the target is a Lambda function.
        """
elif False:
    TargetGroupTargetDescriptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TargetGroupTargetDescriptionArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[builtins.str],
                 availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] id: The ID of the target. If the target type of the target group is instance, specify an instance ID. If the target type is ip, specify an IP address. If the target type is lambda, specify the ARN of the Lambda function. If the target type is alb, specify the ARN of the Application Load Balancer target. 
        :param pulumi.Input[builtins.str] availability_zone: An Availability Zone or all. This determines whether the target receives traffic from the load balancer nodes in the specified Availability Zone or from all enabled Availability Zones for the load balancer.
        :param pulumi.Input[builtins.int] port: The port on which the target is listening. If the target group protocol is GENEVE, the supported port is 6081. If the target type is alb, the targeted Application Load Balancer must have at least one listener whose port matches the target group port. Not used if the target is a Lambda function.
        """
        pulumi.set(__self__, "id", id)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the target. If the target type of the target group is instance, specify an instance ID. If the target type is ip, specify an IP address. If the target type is lambda, specify the ARN of the Lambda function. If the target type is alb, specify the ARN of the Application Load Balancer target. 
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An Availability Zone or all. This determines whether the target receives traffic from the load balancer nodes in the specified Availability Zone or from all enabled Availability Zones for the load balancer.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The port on which the target is listening. If the target group protocol is GENEVE, the supported port is 6081. If the target type is alb, the targeted Application Load Balancer must have at least one listener whose port matches the target group port. Not used if the target is a Lambda function.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)


if not MYPY:
    class TrustStoreRevocationRevocationContentArgsDict(TypedDict):
        revocation_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The type of revocation file.
        """
        s3_bucket: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon S3 bucket for the revocation file.
        """
        s3_key: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon S3 path for the revocation file.
        """
        s3_object_version: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon S3 object version of the revocation file.
        """
elif False:
    TrustStoreRevocationRevocationContentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TrustStoreRevocationRevocationContentArgs:
    def __init__(__self__, *,
                 revocation_type: Optional[pulumi.Input[builtins.str]] = None,
                 s3_bucket: Optional[pulumi.Input[builtins.str]] = None,
                 s3_key: Optional[pulumi.Input[builtins.str]] = None,
                 s3_object_version: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] revocation_type: The type of revocation file.
        :param pulumi.Input[builtins.str] s3_bucket: The Amazon S3 bucket for the revocation file.
        :param pulumi.Input[builtins.str] s3_key: The Amazon S3 path for the revocation file.
        :param pulumi.Input[builtins.str] s3_object_version: The Amazon S3 object version of the revocation file.
        """
        if revocation_type is not None:
            pulumi.set(__self__, "revocation_type", revocation_type)
        if s3_bucket is not None:
            pulumi.set(__self__, "s3_bucket", s3_bucket)
        if s3_key is not None:
            pulumi.set(__self__, "s3_key", s3_key)
        if s3_object_version is not None:
            pulumi.set(__self__, "s3_object_version", s3_object_version)

    @property
    @pulumi.getter(name="revocationType")
    def revocation_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of revocation file.
        """
        return pulumi.get(self, "revocation_type")

    @revocation_type.setter
    def revocation_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "revocation_type", value)

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon S3 bucket for the revocation file.
        """
        return pulumi.get(self, "s3_bucket")

    @s3_bucket.setter
    def s3_bucket(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_bucket", value)

    @property
    @pulumi.getter(name="s3Key")
    def s3_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon S3 path for the revocation file.
        """
        return pulumi.get(self, "s3_key")

    @s3_key.setter
    def s3_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_key", value)

    @property
    @pulumi.getter(name="s3ObjectVersion")
    def s3_object_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon S3 object version of the revocation file.
        """
        return pulumi.get(self, "s3_object_version")

    @s3_object_version.setter
    def s3_object_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "s3_object_version", value)


