# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetConfigurationTemplateResult',
    'AwaitableGetConfigurationTemplateResult',
    'get_configuration_template',
    'get_configuration_template_output',
]

@pulumi.output_type
class GetConfigurationTemplateResult:
    def __init__(__self__, description=None, option_settings=None, template_name=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if option_settings and not isinstance(option_settings, list):
            raise TypeError("Expected argument 'option_settings' to be a list")
        pulumi.set(__self__, "option_settings", option_settings)
        if template_name and not isinstance(template_name, str):
            raise TypeError("Expected argument 'template_name' to be a str")
        pulumi.set(__self__, "template_name", template_name)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        An optional description for this configuration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="optionSettings")
    def option_settings(self) -> Optional[Sequence['outputs.ConfigurationTemplateConfigurationOptionSetting']]:
        """
        Option values for the Elastic Beanstalk configuration, such as the instance type. If specified, these values override the values obtained from the solution stack or the source configuration template. For a complete list of Elastic Beanstalk configuration options, see [Option Values](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options.html) in the AWS Elastic Beanstalk Developer Guide. 
        """
        return pulumi.get(self, "option_settings")

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> Optional[builtins.str]:
        """
        The name of the configuration template
        """
        return pulumi.get(self, "template_name")


class AwaitableGetConfigurationTemplateResult(GetConfigurationTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConfigurationTemplateResult(
            description=self.description,
            option_settings=self.option_settings,
            template_name=self.template_name)


def get_configuration_template(application_name: Optional[builtins.str] = None,
                               template_name: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConfigurationTemplateResult:
    """
    Resource Type definition for AWS::ElasticBeanstalk::ConfigurationTemplate


    :param builtins.str application_name: The name of the Elastic Beanstalk application to associate with this configuration template. 
    :param builtins.str template_name: The name of the configuration template
    """
    __args__ = dict()
    __args__['applicationName'] = application_name
    __args__['templateName'] = template_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:elasticbeanstalk:getConfigurationTemplate', __args__, opts=opts, typ=GetConfigurationTemplateResult).value

    return AwaitableGetConfigurationTemplateResult(
        description=pulumi.get(__ret__, 'description'),
        option_settings=pulumi.get(__ret__, 'option_settings'),
        template_name=pulumi.get(__ret__, 'template_name'))
def get_configuration_template_output(application_name: Optional[pulumi.Input[builtins.str]] = None,
                                      template_name: Optional[pulumi.Input[builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConfigurationTemplateResult]:
    """
    Resource Type definition for AWS::ElasticBeanstalk::ConfigurationTemplate


    :param builtins.str application_name: The name of the Elastic Beanstalk application to associate with this configuration template. 
    :param builtins.str template_name: The name of the configuration template
    """
    __args__ = dict()
    __args__['applicationName'] = application_name
    __args__['templateName'] = template_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:elasticbeanstalk:getConfigurationTemplate', __args__, opts=opts, typ=GetConfigurationTemplateResult)
    return __ret__.apply(lambda __response__: GetConfigurationTemplateResult(
        description=pulumi.get(__response__, 'description'),
        option_settings=pulumi.get(__response__, 'option_settings'),
        template_name=pulumi.get(__response__, 'template_name')))
