# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetApplicationResult',
    'AwaitableGetApplicationResult',
    'get_application',
    'get_application_output',
]

@pulumi.output_type
class GetApplicationResult:
    def __init__(__self__, description=None, resource_lifecycle_config=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if resource_lifecycle_config and not isinstance(resource_lifecycle_config, dict):
            raise TypeError("Expected argument 'resource_lifecycle_config' to be a dict")
        pulumi.set(__self__, "resource_lifecycle_config", resource_lifecycle_config)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        Your description of the application.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="resourceLifecycleConfig")
    def resource_lifecycle_config(self) -> Optional['outputs.ApplicationResourceLifecycleConfig']:
        """
        Specifies an application resource lifecycle configuration to prevent your application from accumulating too many versions.
        """
        return pulumi.get(self, "resource_lifecycle_config")


class AwaitableGetApplicationResult(GetApplicationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApplicationResult(
            description=self.description,
            resource_lifecycle_config=self.resource_lifecycle_config)


def get_application(application_name: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApplicationResult:
    """
    The AWS::ElasticBeanstalk::Application resource specifies an Elastic Beanstalk application.


    :param builtins.str application_name: A name for the Elastic Beanstalk application. If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the application name.
    """
    __args__ = dict()
    __args__['applicationName'] = application_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:elasticbeanstalk:getApplication', __args__, opts=opts, typ=GetApplicationResult).value

    return AwaitableGetApplicationResult(
        description=pulumi.get(__ret__, 'description'),
        resource_lifecycle_config=pulumi.get(__ret__, 'resource_lifecycle_config'))
def get_application_output(application_name: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApplicationResult]:
    """
    The AWS::ElasticBeanstalk::Application resource specifies an Elastic Beanstalk application.


    :param builtins.str application_name: A name for the Elastic Beanstalk application. If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the application name.
    """
    __args__ = dict()
    __args__['applicationName'] = application_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:elasticbeanstalk:getApplication', __args__, opts=opts, typ=GetApplicationResult)
    return __ret__.apply(lambda __response__: GetApplicationResult(
        description=pulumi.get(__response__, 'description'),
        resource_lifecycle_config=pulumi.get(__response__, 'resource_lifecycle_config')))
