# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetUserGroupResult',
    'AwaitableGetUserGroupResult',
    'get_user_group',
    'get_user_group_output',
]

@pulumi.output_type
class GetUserGroupResult:
    def __init__(__self__, arn=None, engine=None, status=None, tags=None, user_ids=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if engine and not isinstance(engine, str):
            raise TypeError("Expected argument 'engine' to be a str")
        pulumi.set(__self__, "engine", engine)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if user_ids and not isinstance(user_ids, list):
            raise TypeError("Expected argument 'user_ids' to be a list")
        pulumi.set(__self__, "user_ids", user_ids)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the user account.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def engine(self) -> Optional['UserGroupEngine']:
        """
        The target cache engine for the user group.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        Indicates user group status. Can be "creating", "active", "modifying", "deleting".
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this user.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="userIds")
    def user_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        List of users associated to this user group.
        """
        return pulumi.get(self, "user_ids")


class AwaitableGetUserGroupResult(GetUserGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserGroupResult(
            arn=self.arn,
            engine=self.engine,
            status=self.status,
            tags=self.tags,
            user_ids=self.user_ids)


def get_user_group(user_group_id: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserGroupResult:
    """
    Resource Type definition for AWS::ElastiCache::UserGroup


    :param builtins.str user_group_id: The ID of the user group.
    """
    __args__ = dict()
    __args__['userGroupId'] = user_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:elasticache:getUserGroup', __args__, opts=opts, typ=GetUserGroupResult).value

    return AwaitableGetUserGroupResult(
        arn=pulumi.get(__ret__, 'arn'),
        engine=pulumi.get(__ret__, 'engine'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        user_ids=pulumi.get(__ret__, 'user_ids'))
def get_user_group_output(user_group_id: Optional[pulumi.Input[builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserGroupResult]:
    """
    Resource Type definition for AWS::ElastiCache::UserGroup


    :param builtins.str user_group_id: The ID of the user group.
    """
    __args__ = dict()
    __args__['userGroupId'] = user_group_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:elasticache:getUserGroup', __args__, opts=opts, typ=GetUserGroupResult)
    return __ret__.apply(lambda __response__: GetUserGroupResult(
        arn=pulumi.get(__response__, 'arn'),
        engine=pulumi.get(__response__, 'engine'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        user_ids=pulumi.get(__response__, 'user_ids')))
