# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetParameterGroupResult',
    'AwaitableGetParameterGroupResult',
    'get_parameter_group',
    'get_parameter_group_output',
]

@pulumi.output_type
class GetParameterGroupResult:
    def __init__(__self__, cache_parameter_group_name=None, description=None, properties=None, tags=None):
        if cache_parameter_group_name and not isinstance(cache_parameter_group_name, str):
            raise TypeError("Expected argument 'cache_parameter_group_name' to be a str")
        pulumi.set(__self__, "cache_parameter_group_name", cache_parameter_group_name)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if properties and not isinstance(properties, dict):
            raise TypeError("Expected argument 'properties' to be a dict")
        pulumi.set(__self__, "properties", properties)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="cacheParameterGroupName")
    def cache_parameter_group_name(self) -> Optional[builtins.str]:
        """
        The name of the Cache Parameter Group.
        """
        return pulumi.get(self, "cache_parameter_group_name")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description for this cache parameter group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Mapping[str, builtins.str]]:
        """
        A comma-delimited list of parameter name/value pairs. For more information see ModifyCacheParameterGroup in the Amazon ElastiCache API Reference Guide.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Tags are composed of a Key/Value pair. You can use tags to categorize and track each parameter group. The tag value null is permitted.
        """
        return pulumi.get(self, "tags")


class AwaitableGetParameterGroupResult(GetParameterGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetParameterGroupResult(
            cache_parameter_group_name=self.cache_parameter_group_name,
            description=self.description,
            properties=self.properties,
            tags=self.tags)


def get_parameter_group(cache_parameter_group_name: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetParameterGroupResult:
    """
    Resource Type definition for AWS::ElastiCache::ParameterGroup


    :param builtins.str cache_parameter_group_name: The name of the Cache Parameter Group.
    """
    __args__ = dict()
    __args__['cacheParameterGroupName'] = cache_parameter_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:elasticache:getParameterGroup', __args__, opts=opts, typ=GetParameterGroupResult).value

    return AwaitableGetParameterGroupResult(
        cache_parameter_group_name=pulumi.get(__ret__, 'cache_parameter_group_name'),
        description=pulumi.get(__ret__, 'description'),
        properties=pulumi.get(__ret__, 'properties'),
        tags=pulumi.get(__ret__, 'tags'))
def get_parameter_group_output(cache_parameter_group_name: Optional[pulumi.Input[builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetParameterGroupResult]:
    """
    Resource Type definition for AWS::ElastiCache::ParameterGroup


    :param builtins.str cache_parameter_group_name: The name of the Cache Parameter Group.
    """
    __args__ = dict()
    __args__['cacheParameterGroupName'] = cache_parameter_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:elasticache:getParameterGroup', __args__, opts=opts, typ=GetParameterGroupResult)
    return __ret__.apply(lambda __response__: GetParameterGroupResult(
        cache_parameter_group_name=pulumi.get(__response__, 'cache_parameter_group_name'),
        description=pulumi.get(__response__, 'description'),
        properties=pulumi.get(__response__, 'properties'),
        tags=pulumi.get(__response__, 'tags')))
