# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetGlobalReplicationGroupResult',
    'AwaitableGetGlobalReplicationGroupResult',
    'get_global_replication_group',
    'get_global_replication_group_output',
]

@pulumi.output_type
class GetGlobalReplicationGroupResult:
    def __init__(__self__, cache_parameter_group_name=None, engine=None, global_replication_group_description=None, global_replication_group_id=None, members=None, status=None):
        if cache_parameter_group_name and not isinstance(cache_parameter_group_name, str):
            raise TypeError("Expected argument 'cache_parameter_group_name' to be a str")
        pulumi.set(__self__, "cache_parameter_group_name", cache_parameter_group_name)
        if engine and not isinstance(engine, str):
            raise TypeError("Expected argument 'engine' to be a str")
        pulumi.set(__self__, "engine", engine)
        if global_replication_group_description and not isinstance(global_replication_group_description, str):
            raise TypeError("Expected argument 'global_replication_group_description' to be a str")
        pulumi.set(__self__, "global_replication_group_description", global_replication_group_description)
        if global_replication_group_id and not isinstance(global_replication_group_id, str):
            raise TypeError("Expected argument 'global_replication_group_id' to be a str")
        pulumi.set(__self__, "global_replication_group_id", global_replication_group_id)
        if members and not isinstance(members, list):
            raise TypeError("Expected argument 'members' to be a list")
        pulumi.set(__self__, "members", members)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="cacheParameterGroupName")
    def cache_parameter_group_name(self) -> Optional[builtins.str]:
        """
        Cache parameter group name to use for the new engine version. This parameter cannot be modified independently.
        """
        return pulumi.get(self, "cache_parameter_group_name")

    @property
    @pulumi.getter
    def engine(self) -> Optional[builtins.str]:
        """
        The engine of the Global Datastore.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="globalReplicationGroupDescription")
    def global_replication_group_description(self) -> Optional[builtins.str]:
        """
        The optional description of the Global Datastore
        """
        return pulumi.get(self, "global_replication_group_description")

    @property
    @pulumi.getter(name="globalReplicationGroupId")
    def global_replication_group_id(self) -> Optional[builtins.str]:
        """
        The name of the Global Datastore, it is generated by ElastiCache adding a prefix to GlobalReplicationGroupIdSuffix.
        """
        return pulumi.get(self, "global_replication_group_id")

    @property
    @pulumi.getter
    def members(self) -> Optional[Sequence['outputs.GlobalReplicationGroupMember']]:
        """
        The replication groups that comprise the Global Datastore.
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        The status of the Global Datastore
        """
        return pulumi.get(self, "status")


class AwaitableGetGlobalReplicationGroupResult(GetGlobalReplicationGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGlobalReplicationGroupResult(
            cache_parameter_group_name=self.cache_parameter_group_name,
            engine=self.engine,
            global_replication_group_description=self.global_replication_group_description,
            global_replication_group_id=self.global_replication_group_id,
            members=self.members,
            status=self.status)


def get_global_replication_group(global_replication_group_id: Optional[builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGlobalReplicationGroupResult:
    """
    The AWS::ElastiCache::GlobalReplicationGroup resource creates an Amazon ElastiCache Global Replication Group.


    :param builtins.str global_replication_group_id: The name of the Global Datastore, it is generated by ElastiCache adding a prefix to GlobalReplicationGroupIdSuffix.
    """
    __args__ = dict()
    __args__['globalReplicationGroupId'] = global_replication_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:elasticache:getGlobalReplicationGroup', __args__, opts=opts, typ=GetGlobalReplicationGroupResult).value

    return AwaitableGetGlobalReplicationGroupResult(
        cache_parameter_group_name=pulumi.get(__ret__, 'cache_parameter_group_name'),
        engine=pulumi.get(__ret__, 'engine'),
        global_replication_group_description=pulumi.get(__ret__, 'global_replication_group_description'),
        global_replication_group_id=pulumi.get(__ret__, 'global_replication_group_id'),
        members=pulumi.get(__ret__, 'members'),
        status=pulumi.get(__ret__, 'status'))
def get_global_replication_group_output(global_replication_group_id: Optional[pulumi.Input[builtins.str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGlobalReplicationGroupResult]:
    """
    The AWS::ElastiCache::GlobalReplicationGroup resource creates an Amazon ElastiCache Global Replication Group.


    :param builtins.str global_replication_group_id: The name of the Global Datastore, it is generated by ElastiCache adding a prefix to GlobalReplicationGroupIdSuffix.
    """
    __args__ = dict()
    __args__['globalReplicationGroupId'] = global_replication_group_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:elasticache:getGlobalReplicationGroup', __args__, opts=opts, typ=GetGlobalReplicationGroupResult)
    return __ret__.apply(lambda __response__: GetGlobalReplicationGroupResult(
        cache_parameter_group_name=pulumi.get(__response__, 'cache_parameter_group_name'),
        engine=pulumi.get(__response__, 'engine'),
        global_replication_group_description=pulumi.get(__response__, 'global_replication_group_description'),
        global_replication_group_id=pulumi.get(__response__, 'global_replication_group_id'),
        members=pulumi.get(__response__, 'members'),
        status=pulumi.get(__response__, 'status')))
