# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AccessEntryAccessPolicy',
    'AccessEntryAccessScope',
    'AddonPodIdentityAssociation',
    'ClusterAccessConfig',
    'ClusterBlockStorage',
    'ClusterComputeConfig',
    'ClusterControlPlanePlacement',
    'ClusterElasticLoadBalancing',
    'ClusterEncryptionConfig',
    'ClusterKubernetesNetworkConfig',
    'ClusterLoggingEnabledTypes',
    'ClusterLoggingTypeConfig',
    'ClusterOutpostConfig',
    'ClusterProvider',
    'ClusterRemoteNetworkConfig',
    'ClusterRemoteNodeNetwork',
    'ClusterRemotePodNetwork',
    'ClusterResourcesVpcConfig',
    'ClusterStorageConfig',
    'ClusterUpgradePolicy',
    'ClusterZonalShiftConfig',
    'FargateProfileLabel',
    'FargateProfileSelector',
    'IdentityProviderConfigOidcIdentityProviderConfig',
    'IdentityProviderConfigRequiredClaim',
    'Logging',
    'NodegroupLaunchTemplateSpecification',
    'NodegroupNodeRepairConfig',
    'NodegroupRemoteAccess',
    'NodegroupScalingConfig',
    'NodegroupTaint',
    'NodegroupUpdateConfig',
]

@pulumi.output_type
class AccessEntryAccessPolicy(dict):
    """
    An access policy to associate with the current access entry.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessScope":
            suggest = "access_scope"
        elif key == "policyArn":
            suggest = "policy_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessEntryAccessPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessEntryAccessPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessEntryAccessPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_scope: 'outputs.AccessEntryAccessScope',
                 policy_arn: builtins.str):
        """
        An access policy to associate with the current access entry.
        :param 'AccessEntryAccessScope' access_scope: The scope of an `AccessPolicy` that's associated to an `AccessEntry` .
        :param builtins.str policy_arn: The ARN of the access policy to add to the access entry.
        """
        pulumi.set(__self__, "access_scope", access_scope)
        pulumi.set(__self__, "policy_arn", policy_arn)

    @property
    @pulumi.getter(name="accessScope")
    def access_scope(self) -> 'outputs.AccessEntryAccessScope':
        """
        The scope of an `AccessPolicy` that's associated to an `AccessEntry` .
        """
        return pulumi.get(self, "access_scope")

    @property
    @pulumi.getter(name="policyArn")
    def policy_arn(self) -> builtins.str:
        """
        The ARN of the access policy to add to the access entry.
        """
        return pulumi.get(self, "policy_arn")


@pulumi.output_type
class AccessEntryAccessScope(dict):
    """
    The access scope of the access policy.
    """
    def __init__(__self__, *,
                 type: 'AccessEntryAccessScopeType',
                 namespaces: Optional[Sequence[builtins.str]] = None):
        """
        The access scope of the access policy.
        :param 'AccessEntryAccessScopeType' type: The type of the access scope.
        :param Sequence[builtins.str] namespaces: The namespaces to associate with the access scope. Only specify if Type is set to 'namespace'.
        """
        pulumi.set(__self__, "type", type)
        if namespaces is not None:
            pulumi.set(__self__, "namespaces", namespaces)

    @property
    @pulumi.getter
    def type(self) -> 'AccessEntryAccessScopeType':
        """
        The type of the access scope.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def namespaces(self) -> Optional[Sequence[builtins.str]]:
        """
        The namespaces to associate with the access scope. Only specify if Type is set to 'namespace'.
        """
        return pulumi.get(self, "namespaces")


@pulumi.output_type
class AddonPodIdentityAssociation(dict):
    """
    A pod identity to associate with an add-on.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "serviceAccount":
            suggest = "service_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AddonPodIdentityAssociation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AddonPodIdentityAssociation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AddonPodIdentityAssociation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: builtins.str,
                 service_account: builtins.str):
        """
        A pod identity to associate with an add-on.
        :param builtins.str role_arn: The IAM role ARN that the pod identity association is created for.
        :param builtins.str service_account: The Kubernetes service account that the pod identity association is created for.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "service_account", service_account)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The IAM role ARN that the pod identity association is created for.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> builtins.str:
        """
        The Kubernetes service account that the pod identity association is created for.
        """
        return pulumi.get(self, "service_account")


@pulumi.output_type
class ClusterAccessConfig(dict):
    """
    An object representing the Access Config to use for the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationMode":
            suggest = "authentication_mode"
        elif key == "bootstrapClusterCreatorAdminPermissions":
            suggest = "bootstrap_cluster_creator_admin_permissions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAccessConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAccessConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAccessConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_mode: Optional['ClusterAccessConfigAuthenticationMode'] = None,
                 bootstrap_cluster_creator_admin_permissions: Optional[builtins.bool] = None):
        """
        An object representing the Access Config to use for the cluster.
        :param 'ClusterAccessConfigAuthenticationMode' authentication_mode: Specify the authentication mode that should be used to create your cluster.
        :param builtins.bool bootstrap_cluster_creator_admin_permissions: Set this value to false to avoid creating a default cluster admin Access Entry using the IAM principal used to create the cluster.
        """
        if authentication_mode is not None:
            pulumi.set(__self__, "authentication_mode", authentication_mode)
        if bootstrap_cluster_creator_admin_permissions is not None:
            pulumi.set(__self__, "bootstrap_cluster_creator_admin_permissions", bootstrap_cluster_creator_admin_permissions)

    @property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> Optional['ClusterAccessConfigAuthenticationMode']:
        """
        Specify the authentication mode that should be used to create your cluster.
        """
        return pulumi.get(self, "authentication_mode")

    @property
    @pulumi.getter(name="bootstrapClusterCreatorAdminPermissions")
    def bootstrap_cluster_creator_admin_permissions(self) -> Optional[builtins.bool]:
        """
        Set this value to false to avoid creating a default cluster admin Access Entry using the IAM principal used to create the cluster.
        """
        return pulumi.get(self, "bootstrap_cluster_creator_admin_permissions")


@pulumi.output_type
class ClusterBlockStorage(dict):
    """
    Todo: add description
    """
    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None):
        """
        Todo: add description
        :param builtins.bool enabled: Todo: add description
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Todo: add description
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ClusterComputeConfig(dict):
    """
    Todo: add description
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodePools":
            suggest = "node_pools"
        elif key == "nodeRoleArn":
            suggest = "node_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterComputeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterComputeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterComputeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None,
                 node_pools: Optional[Sequence[builtins.str]] = None,
                 node_role_arn: Optional[builtins.str] = None):
        """
        Todo: add description
        :param builtins.bool enabled: Todo: add description
        :param Sequence[builtins.str] node_pools: Todo: add description
        :param builtins.str node_role_arn: Todo: add description
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if node_pools is not None:
            pulumi.set(__self__, "node_pools", node_pools)
        if node_role_arn is not None:
            pulumi.set(__self__, "node_role_arn", node_role_arn)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Todo: add description
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="nodePools")
    def node_pools(self) -> Optional[Sequence[builtins.str]]:
        """
        Todo: add description
        """
        return pulumi.get(self, "node_pools")

    @property
    @pulumi.getter(name="nodeRoleArn")
    def node_role_arn(self) -> Optional[builtins.str]:
        """
        Todo: add description
        """
        return pulumi.get(self, "node_role_arn")


@pulumi.output_type
class ClusterControlPlanePlacement(dict):
    """
    Specify the placement group of the control plane machines for your cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupName":
            suggest = "group_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterControlPlanePlacement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterControlPlanePlacement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterControlPlanePlacement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_name: Optional[builtins.str] = None):
        """
        Specify the placement group of the control plane machines for your cluster.
        :param builtins.str group_name: Specify the placement group name of the control place machines for your cluster.
        """
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[builtins.str]:
        """
        Specify the placement group name of the control place machines for your cluster.
        """
        return pulumi.get(self, "group_name")


@pulumi.output_type
class ClusterElasticLoadBalancing(dict):
    """
    Todo: add description
    """
    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None):
        """
        Todo: add description
        :param builtins.bool enabled: Todo: add description
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Todo: add description
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ClusterEncryptionConfig(dict):
    """
    The encryption configuration for the cluster
    """
    def __init__(__self__, *,
                 provider: Optional['outputs.ClusterProvider'] = None,
                 resources: Optional[Sequence[builtins.str]] = None):
        """
        The encryption configuration for the cluster
        :param 'ClusterProvider' provider: The encryption provider for the cluster.
        :param Sequence[builtins.str] resources: Specifies the resources to be encrypted. The only supported value is "secrets".
        """
        if provider is not None:
            pulumi.set(__self__, "provider", provider)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def provider(self) -> Optional['outputs.ClusterProvider']:
        """
        The encryption provider for the cluster.
        """
        return pulumi.get(self, "provider")

    @property
    @pulumi.getter
    def resources(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies the resources to be encrypted. The only supported value is "secrets".
        """
        return pulumi.get(self, "resources")


@pulumi.output_type
class ClusterKubernetesNetworkConfig(dict):
    """
    The Kubernetes network configuration for the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "elasticLoadBalancing":
            suggest = "elastic_load_balancing"
        elif key == "ipFamily":
            suggest = "ip_family"
        elif key == "serviceIpv4Cidr":
            suggest = "service_ipv4_cidr"
        elif key == "serviceIpv6Cidr":
            suggest = "service_ipv6_cidr"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterKubernetesNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterKubernetesNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterKubernetesNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 elastic_load_balancing: Optional['outputs.ClusterElasticLoadBalancing'] = None,
                 ip_family: Optional['ClusterKubernetesNetworkConfigIpFamily'] = None,
                 service_ipv4_cidr: Optional[builtins.str] = None,
                 service_ipv6_cidr: Optional[builtins.str] = None):
        """
        The Kubernetes network configuration for the cluster.
        :param 'ClusterElasticLoadBalancing' elastic_load_balancing: Todo: add description
        :param 'ClusterKubernetesNetworkConfigIpFamily' ip_family: Ipv4 or Ipv6. You can only specify ipv6 for 1.21 and later clusters that use version 1.10.1 or later of the Amazon VPC CNI add-on
        :param builtins.str service_ipv4_cidr: The CIDR block to assign Kubernetes service IP addresses from. If you don't specify a block, Kubernetes assigns addresses from either the 10.100.0.0/16 or 172.20.0.0/16 CIDR blocks. We recommend that you specify a block that does not overlap with resources in other networks that are peered or connected to your VPC. 
        :param builtins.str service_ipv6_cidr: The CIDR block to assign Kubernetes service IP addresses from.
        """
        if elastic_load_balancing is not None:
            pulumi.set(__self__, "elastic_load_balancing", elastic_load_balancing)
        if ip_family is not None:
            pulumi.set(__self__, "ip_family", ip_family)
        if service_ipv4_cidr is not None:
            pulumi.set(__self__, "service_ipv4_cidr", service_ipv4_cidr)
        if service_ipv6_cidr is not None:
            pulumi.set(__self__, "service_ipv6_cidr", service_ipv6_cidr)

    @property
    @pulumi.getter(name="elasticLoadBalancing")
    def elastic_load_balancing(self) -> Optional['outputs.ClusterElasticLoadBalancing']:
        """
        Todo: add description
        """
        return pulumi.get(self, "elastic_load_balancing")

    @property
    @pulumi.getter(name="ipFamily")
    def ip_family(self) -> Optional['ClusterKubernetesNetworkConfigIpFamily']:
        """
        Ipv4 or Ipv6. You can only specify ipv6 for 1.21 and later clusters that use version 1.10.1 or later of the Amazon VPC CNI add-on
        """
        return pulumi.get(self, "ip_family")

    @property
    @pulumi.getter(name="serviceIpv4Cidr")
    def service_ipv4_cidr(self) -> Optional[builtins.str]:
        """
        The CIDR block to assign Kubernetes service IP addresses from. If you don't specify a block, Kubernetes assigns addresses from either the 10.100.0.0/16 or 172.20.0.0/16 CIDR blocks. We recommend that you specify a block that does not overlap with resources in other networks that are peered or connected to your VPC. 
        """
        return pulumi.get(self, "service_ipv4_cidr")

    @property
    @pulumi.getter(name="serviceIpv6Cidr")
    def service_ipv6_cidr(self) -> Optional[builtins.str]:
        """
        The CIDR block to assign Kubernetes service IP addresses from.
        """
        return pulumi.get(self, "service_ipv6_cidr")


@pulumi.output_type
class ClusterLoggingEnabledTypes(dict):
    """
    The cluster control plane logging configuration for your cluster. 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enabledTypes":
            suggest = "enabled_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterLoggingEnabledTypes. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterLoggingEnabledTypes.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterLoggingEnabledTypes.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled_types: Optional[Sequence['outputs.ClusterLoggingTypeConfig']] = None):
        """
        The cluster control plane logging configuration for your cluster. 
        :param Sequence['ClusterLoggingTypeConfig'] enabled_types: The enabled control plane logs for your cluster. All log types are disabled if the array is empty.
               
               > When updating a resource, you must include this `EnabledTypes` property if the previous CloudFormation template of the resource had it.
        """
        if enabled_types is not None:
            pulumi.set(__self__, "enabled_types", enabled_types)

    @property
    @pulumi.getter(name="enabledTypes")
    def enabled_types(self) -> Optional[Sequence['outputs.ClusterLoggingTypeConfig']]:
        """
        The enabled control plane logs for your cluster. All log types are disabled if the array is empty.

        > When updating a resource, you must include this `EnabledTypes` property if the previous CloudFormation template of the resource had it.
        """
        return pulumi.get(self, "enabled_types")


@pulumi.output_type
class ClusterLoggingTypeConfig(dict):
    """
    Enabled Logging Type
    """
    def __init__(__self__, *,
                 type: Optional['ClusterLoggingTypeConfigType'] = None):
        """
        Enabled Logging Type
        :param 'ClusterLoggingTypeConfigType' type: name of the log type
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional['ClusterLoggingTypeConfigType']:
        """
        name of the log type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ClusterOutpostConfig(dict):
    """
    An object representing the Outpost configuration to use for AWS EKS outpost cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "controlPlaneInstanceType":
            suggest = "control_plane_instance_type"
        elif key == "outpostArns":
            suggest = "outpost_arns"
        elif key == "controlPlanePlacement":
            suggest = "control_plane_placement"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterOutpostConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterOutpostConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterOutpostConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 control_plane_instance_type: builtins.str,
                 outpost_arns: Sequence[builtins.str],
                 control_plane_placement: Optional['outputs.ClusterControlPlanePlacement'] = None):
        """
        An object representing the Outpost configuration to use for AWS EKS outpost cluster.
        :param builtins.str control_plane_instance_type: Specify the Instance type of the machines that should be used to create your cluster.
        :param Sequence[builtins.str] outpost_arns: Specify one or more Arn(s) of Outpost(s) on which you would like to create your cluster.
        :param 'ClusterControlPlanePlacement' control_plane_placement: Specify the placement group of the control plane machines for your cluster.
        """
        pulumi.set(__self__, "control_plane_instance_type", control_plane_instance_type)
        pulumi.set(__self__, "outpost_arns", outpost_arns)
        if control_plane_placement is not None:
            pulumi.set(__self__, "control_plane_placement", control_plane_placement)

    @property
    @pulumi.getter(name="controlPlaneInstanceType")
    def control_plane_instance_type(self) -> builtins.str:
        """
        Specify the Instance type of the machines that should be used to create your cluster.
        """
        return pulumi.get(self, "control_plane_instance_type")

    @property
    @pulumi.getter(name="outpostArns")
    def outpost_arns(self) -> Sequence[builtins.str]:
        """
        Specify one or more Arn(s) of Outpost(s) on which you would like to create your cluster.
        """
        return pulumi.get(self, "outpost_arns")

    @property
    @pulumi.getter(name="controlPlanePlacement")
    def control_plane_placement(self) -> Optional['outputs.ClusterControlPlanePlacement']:
        """
        Specify the placement group of the control plane machines for your cluster.
        """
        return pulumi.get(self, "control_plane_placement")


@pulumi.output_type
class ClusterProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyArn":
            suggest = "key_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_arn: Optional[builtins.str] = None):
        """
        :param builtins.str key_arn: Amazon Resource Name (ARN) or alias of the KMS key. The KMS key must be symmetric, created in the same region as the cluster, and if the KMS key was created in a different account, the user must have access to the KMS key.
        """
        if key_arn is not None:
            pulumi.set(__self__, "key_arn", key_arn)

    @property
    @pulumi.getter(name="keyArn")
    def key_arn(self) -> Optional[builtins.str]:
        """
        Amazon Resource Name (ARN) or alias of the KMS key. The KMS key must be symmetric, created in the same region as the cluster, and if the KMS key was created in a different account, the user must have access to the KMS key.
        """
        return pulumi.get(self, "key_arn")


@pulumi.output_type
class ClusterRemoteNetworkConfig(dict):
    """
    Configuration fields for specifying on-premises node and pod CIDRs that are external to the VPC passed during cluster creation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "remoteNodeNetworks":
            suggest = "remote_node_networks"
        elif key == "remotePodNetworks":
            suggest = "remote_pod_networks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterRemoteNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterRemoteNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterRemoteNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 remote_node_networks: Sequence['outputs.ClusterRemoteNodeNetwork'],
                 remote_pod_networks: Optional[Sequence['outputs.ClusterRemotePodNetwork']] = None):
        """
        Configuration fields for specifying on-premises node and pod CIDRs that are external to the VPC passed during cluster creation.
        :param Sequence['ClusterRemoteNodeNetwork'] remote_node_networks: Network configuration of nodes run on-premises with EKS Hybrid Nodes.
        :param Sequence['ClusterRemotePodNetwork'] remote_pod_networks: Network configuration of pods run on-premises with EKS Hybrid Nodes.
        """
        pulumi.set(__self__, "remote_node_networks", remote_node_networks)
        if remote_pod_networks is not None:
            pulumi.set(__self__, "remote_pod_networks", remote_pod_networks)

    @property
    @pulumi.getter(name="remoteNodeNetworks")
    def remote_node_networks(self) -> Sequence['outputs.ClusterRemoteNodeNetwork']:
        """
        Network configuration of nodes run on-premises with EKS Hybrid Nodes.
        """
        return pulumi.get(self, "remote_node_networks")

    @property
    @pulumi.getter(name="remotePodNetworks")
    def remote_pod_networks(self) -> Optional[Sequence['outputs.ClusterRemotePodNetwork']]:
        """
        Network configuration of pods run on-premises with EKS Hybrid Nodes.
        """
        return pulumi.get(self, "remote_pod_networks")


@pulumi.output_type
class ClusterRemoteNodeNetwork(dict):
    """
    Network configuration of nodes run on-premises with EKS Hybrid Nodes.
    """
    def __init__(__self__, *,
                 cidrs: Sequence[builtins.str]):
        """
        Network configuration of nodes run on-premises with EKS Hybrid Nodes.
        :param Sequence[builtins.str] cidrs: Specifies the list of remote node CIDRs.
        """
        pulumi.set(__self__, "cidrs", cidrs)

    @property
    @pulumi.getter
    def cidrs(self) -> Sequence[builtins.str]:
        """
        Specifies the list of remote node CIDRs.
        """
        return pulumi.get(self, "cidrs")


@pulumi.output_type
class ClusterRemotePodNetwork(dict):
    """
    Network configuration of pods run on-premises with EKS Hybrid Nodes.
    """
    def __init__(__self__, *,
                 cidrs: Sequence[builtins.str]):
        """
        Network configuration of pods run on-premises with EKS Hybrid Nodes.
        :param Sequence[builtins.str] cidrs: Specifies the list of remote pod CIDRs.
        """
        pulumi.set(__self__, "cidrs", cidrs)

    @property
    @pulumi.getter
    def cidrs(self) -> Sequence[builtins.str]:
        """
        Specifies the list of remote pod CIDRs.
        """
        return pulumi.get(self, "cidrs")


@pulumi.output_type
class ClusterResourcesVpcConfig(dict):
    """
    An object representing the VPC configuration to use for an Amazon EKS cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetIds":
            suggest = "subnet_ids"
        elif key == "endpointPrivateAccess":
            suggest = "endpoint_private_access"
        elif key == "endpointPublicAccess":
            suggest = "endpoint_public_access"
        elif key == "publicAccessCidrs":
            suggest = "public_access_cidrs"
        elif key == "securityGroupIds":
            suggest = "security_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterResourcesVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterResourcesVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterResourcesVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_ids: Sequence[builtins.str],
                 endpoint_private_access: Optional[builtins.bool] = None,
                 endpoint_public_access: Optional[builtins.bool] = None,
                 public_access_cidrs: Optional[Sequence[builtins.str]] = None,
                 security_group_ids: Optional[Sequence[builtins.str]] = None):
        """
        An object representing the VPC configuration to use for an Amazon EKS cluster.
        :param Sequence[builtins.str] subnet_ids: Specify subnets for your Amazon EKS nodes. Amazon EKS creates cross-account elastic network interfaces in these subnets to allow communication between your nodes and the Kubernetes control plane.
        :param builtins.bool endpoint_private_access: Set this value to true to enable private access for your cluster's Kubernetes API server endpoint. If you enable private access, Kubernetes API requests from within your cluster's VPC use the private VPC endpoint. The default value for this parameter is false, which disables private access for your Kubernetes API server. If you disable private access and you have nodes or AWS Fargate pods in the cluster, then ensure that publicAccessCidrs includes the necessary CIDR blocks for communication with the nodes or Fargate pods.
        :param builtins.bool endpoint_public_access: Set this value to false to disable public access to your cluster's Kubernetes API server endpoint. If you disable public access, your cluster's Kubernetes API server can only receive requests from within the cluster VPC. The default value for this parameter is true, which enables public access for your Kubernetes API server.
        :param Sequence[builtins.str] public_access_cidrs: The CIDR blocks that are allowed access to your cluster's public Kubernetes API server endpoint. Communication to the endpoint from addresses outside of the CIDR blocks that you specify is denied. The default value is 0.0.0.0/0. If you've disabled private endpoint access and you have nodes or AWS Fargate pods in the cluster, then ensure that you specify the necessary CIDR blocks.
        :param Sequence[builtins.str] security_group_ids: Specify one or more security groups for the cross-account elastic network interfaces that Amazon EKS creates to use to allow communication between your worker nodes and the Kubernetes control plane. If you don't specify a security group, the default security group for your VPC is used.
        """
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if endpoint_private_access is not None:
            pulumi.set(__self__, "endpoint_private_access", endpoint_private_access)
        if endpoint_public_access is not None:
            pulumi.set(__self__, "endpoint_public_access", endpoint_public_access)
        if public_access_cidrs is not None:
            pulumi.set(__self__, "public_access_cidrs", public_access_cidrs)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[builtins.str]:
        """
        Specify subnets for your Amazon EKS nodes. Amazon EKS creates cross-account elastic network interfaces in these subnets to allow communication between your nodes and the Kubernetes control plane.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="endpointPrivateAccess")
    def endpoint_private_access(self) -> Optional[builtins.bool]:
        """
        Set this value to true to enable private access for your cluster's Kubernetes API server endpoint. If you enable private access, Kubernetes API requests from within your cluster's VPC use the private VPC endpoint. The default value for this parameter is false, which disables private access for your Kubernetes API server. If you disable private access and you have nodes or AWS Fargate pods in the cluster, then ensure that publicAccessCidrs includes the necessary CIDR blocks for communication with the nodes or Fargate pods.
        """
        return pulumi.get(self, "endpoint_private_access")

    @property
    @pulumi.getter(name="endpointPublicAccess")
    def endpoint_public_access(self) -> Optional[builtins.bool]:
        """
        Set this value to false to disable public access to your cluster's Kubernetes API server endpoint. If you disable public access, your cluster's Kubernetes API server can only receive requests from within the cluster VPC. The default value for this parameter is true, which enables public access for your Kubernetes API server.
        """
        return pulumi.get(self, "endpoint_public_access")

    @property
    @pulumi.getter(name="publicAccessCidrs")
    def public_access_cidrs(self) -> Optional[Sequence[builtins.str]]:
        """
        The CIDR blocks that are allowed access to your cluster's public Kubernetes API server endpoint. Communication to the endpoint from addresses outside of the CIDR blocks that you specify is denied. The default value is 0.0.0.0/0. If you've disabled private endpoint access and you have nodes or AWS Fargate pods in the cluster, then ensure that you specify the necessary CIDR blocks.
        """
        return pulumi.get(self, "public_access_cidrs")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        Specify one or more security groups for the cross-account elastic network interfaces that Amazon EKS creates to use to allow communication between your worker nodes and the Kubernetes control plane. If you don't specify a security group, the default security group for your VPC is used.
        """
        return pulumi.get(self, "security_group_ids")


@pulumi.output_type
class ClusterStorageConfig(dict):
    """
    Todo: add description
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockStorage":
            suggest = "block_storage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterStorageConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterStorageConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterStorageConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 block_storage: Optional['outputs.ClusterBlockStorage'] = None):
        """
        Todo: add description
        :param 'ClusterBlockStorage' block_storage: Todo: add description
        """
        if block_storage is not None:
            pulumi.set(__self__, "block_storage", block_storage)

    @property
    @pulumi.getter(name="blockStorage")
    def block_storage(self) -> Optional['outputs.ClusterBlockStorage']:
        """
        Todo: add description
        """
        return pulumi.get(self, "block_storage")


@pulumi.output_type
class ClusterUpgradePolicy(dict):
    """
    An object representing the Upgrade Policy to use for the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "supportType":
            suggest = "support_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterUpgradePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterUpgradePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterUpgradePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 support_type: Optional['ClusterUpgradePolicySupportType'] = None):
        """
        An object representing the Upgrade Policy to use for the cluster.
        :param 'ClusterUpgradePolicySupportType' support_type: Specify the support type for your cluster.
        """
        if support_type is not None:
            pulumi.set(__self__, "support_type", support_type)

    @property
    @pulumi.getter(name="supportType")
    def support_type(self) -> Optional['ClusterUpgradePolicySupportType']:
        """
        Specify the support type for your cluster.
        """
        return pulumi.get(self, "support_type")


@pulumi.output_type
class ClusterZonalShiftConfig(dict):
    """
    The current zonal shift configuration to use for the cluster.
    """
    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None):
        """
        The current zonal shift configuration to use for the cluster.
        :param builtins.bool enabled: Set this value to true to enable zonal shift for the cluster.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Set this value to true to enable zonal shift for the cluster.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class FargateProfileLabel(dict):
    """
    A key-value pair to associate with a pod.
    """
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        A key-value pair to associate with a pod.
        :param builtins.str key: The key name of the label.
        :param builtins.str value: The value for the label. 
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key name of the label.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value for the label. 
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class FargateProfileSelector(dict):
    def __init__(__self__, *,
                 namespace: builtins.str,
                 labels: Optional[Sequence['outputs.FargateProfileLabel']] = None):
        """
        :param builtins.str namespace: The Kubernetes `namespace` that the selector should match.
        :param Sequence['FargateProfileLabel'] labels: The Kubernetes labels that the selector should match. A pod must contain all of the labels that are specified in the selector for it to be considered a match.
        """
        pulumi.set(__self__, "namespace", namespace)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        The Kubernetes `namespace` that the selector should match.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Sequence['outputs.FargateProfileLabel']]:
        """
        The Kubernetes labels that the selector should match. A pod must contain all of the labels that are specified in the selector for it to be considered a match.
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class IdentityProviderConfigOidcIdentityProviderConfig(dict):
    """
    An object representing an OpenID Connect (OIDC) configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "issuerUrl":
            suggest = "issuer_url"
        elif key == "groupsClaim":
            suggest = "groups_claim"
        elif key == "groupsPrefix":
            suggest = "groups_prefix"
        elif key == "requiredClaims":
            suggest = "required_claims"
        elif key == "usernameClaim":
            suggest = "username_claim"
        elif key == "usernamePrefix":
            suggest = "username_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityProviderConfigOidcIdentityProviderConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityProviderConfigOidcIdentityProviderConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityProviderConfigOidcIdentityProviderConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: builtins.str,
                 issuer_url: builtins.str,
                 groups_claim: Optional[builtins.str] = None,
                 groups_prefix: Optional[builtins.str] = None,
                 required_claims: Optional[Sequence['outputs.IdentityProviderConfigRequiredClaim']] = None,
                 username_claim: Optional[builtins.str] = None,
                 username_prefix: Optional[builtins.str] = None):
        """
        An object representing an OpenID Connect (OIDC) configuration.
        :param builtins.str client_id: This is also known as audience. The ID for the client application that makes authentication requests to the OpenID identity provider.
        :param builtins.str issuer_url: The URL of the OpenID identity provider that allows the API server to discover public signing keys for verifying tokens.
        :param builtins.str groups_claim: The JWT claim that the provider uses to return your groups.
        :param builtins.str groups_prefix: The prefix that is prepended to group claims to prevent clashes with existing names (such as system: groups).
        :param Sequence['IdentityProviderConfigRequiredClaim'] required_claims: The key-value pairs that describe required claims in the identity token. If set, each claim is verified to be present in the token with a matching value.
        :param builtins.str username_claim: The JSON Web Token (JWT) claim to use as the username. The default is sub, which is expected to be a unique identifier of the end user. You can choose other claims, such as email or name, depending on the OpenID identity provider. Claims other than email are prefixed with the issuer URL to prevent naming clashes with other plug-ins.
        :param builtins.str username_prefix: The prefix that is prepended to username claims to prevent clashes with existing names. If you do not provide this field, and username is a value other than email, the prefix defaults to issuerurl#. You can use the value - to disable all prefixing.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "issuer_url", issuer_url)
        if groups_claim is not None:
            pulumi.set(__self__, "groups_claim", groups_claim)
        if groups_prefix is not None:
            pulumi.set(__self__, "groups_prefix", groups_prefix)
        if required_claims is not None:
            pulumi.set(__self__, "required_claims", required_claims)
        if username_claim is not None:
            pulumi.set(__self__, "username_claim", username_claim)
        if username_prefix is not None:
            pulumi.set(__self__, "username_prefix", username_prefix)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> builtins.str:
        """
        This is also known as audience. The ID for the client application that makes authentication requests to the OpenID identity provider.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> builtins.str:
        """
        The URL of the OpenID identity provider that allows the API server to discover public signing keys for verifying tokens.
        """
        return pulumi.get(self, "issuer_url")

    @property
    @pulumi.getter(name="groupsClaim")
    def groups_claim(self) -> Optional[builtins.str]:
        """
        The JWT claim that the provider uses to return your groups.
        """
        return pulumi.get(self, "groups_claim")

    @property
    @pulumi.getter(name="groupsPrefix")
    def groups_prefix(self) -> Optional[builtins.str]:
        """
        The prefix that is prepended to group claims to prevent clashes with existing names (such as system: groups).
        """
        return pulumi.get(self, "groups_prefix")

    @property
    @pulumi.getter(name="requiredClaims")
    def required_claims(self) -> Optional[Sequence['outputs.IdentityProviderConfigRequiredClaim']]:
        """
        The key-value pairs that describe required claims in the identity token. If set, each claim is verified to be present in the token with a matching value.
        """
        return pulumi.get(self, "required_claims")

    @property
    @pulumi.getter(name="usernameClaim")
    def username_claim(self) -> Optional[builtins.str]:
        """
        The JSON Web Token (JWT) claim to use as the username. The default is sub, which is expected to be a unique identifier of the end user. You can choose other claims, such as email or name, depending on the OpenID identity provider. Claims other than email are prefixed with the issuer URL to prevent naming clashes with other plug-ins.
        """
        return pulumi.get(self, "username_claim")

    @property
    @pulumi.getter(name="usernamePrefix")
    def username_prefix(self) -> Optional[builtins.str]:
        """
        The prefix that is prepended to username claims to prevent clashes with existing names. If you do not provide this field, and username is a value other than email, the prefix defaults to issuerurl#. You can use the value - to disable all prefixing.
        """
        return pulumi.get(self, "username_prefix")


@pulumi.output_type
class IdentityProviderConfigRequiredClaim(dict):
    """
    The key value pairs that describe required claims in the identity token. If set, each claim is verified to be present in the token with a matching value.
    """
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        The key value pairs that describe required claims in the identity token. If set, each claim is verified to be present in the token with a matching value.
        :param builtins.str key: The key of the requiredClaims.
        :param builtins.str value: The value for the requiredClaims.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The key of the requiredClaims.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value for the requiredClaims.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class Logging(dict):
    """
    Enable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs based on log types. By default, cluster control plane logs aren't exported to CloudWatch Logs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterLogging":
            suggest = "cluster_logging"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Logging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Logging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Logging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_logging: Optional['outputs.ClusterLoggingEnabledTypes'] = None):
        """
        Enable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs based on log types. By default, cluster control plane logs aren't exported to CloudWatch Logs.
        :param 'ClusterLoggingEnabledTypes' cluster_logging: The cluster control plane logging configuration for your cluster. 
        """
        if cluster_logging is not None:
            pulumi.set(__self__, "cluster_logging", cluster_logging)

    @property
    @pulumi.getter(name="clusterLogging")
    def cluster_logging(self) -> Optional['outputs.ClusterLoggingEnabledTypes']:
        """
        The cluster control plane logging configuration for your cluster. 
        """
        return pulumi.get(self, "cluster_logging")


@pulumi.output_type
class NodegroupLaunchTemplateSpecification(dict):
    """
    An object representing a launch template specification for AWS EKS Nodegroup.
    """
    def __init__(__self__, *,
                 id: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 version: Optional[builtins.str] = None):
        """
        An object representing a launch template specification for AWS EKS Nodegroup.
        :param builtins.str id: The ID of the launch template.
               
               You must specify either the launch template ID or the launch template name in the request, but not both. After node group creation, you cannot use a different ID.
        :param builtins.str name: The name of the launch template.
               
               You must specify either the launch template name or the launch template ID in the request, but not both. After node group creation, you cannot use a different name.
        :param builtins.str version: The version number of the launch template to use. If no version is specified, then the template's default version is used. You can use a different version for node group updates.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the launch template.

        You must specify either the launch template ID or the launch template name in the request, but not both. After node group creation, you cannot use a different ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the launch template.

        You must specify either the launch template name or the launch template ID in the request, but not both. After node group creation, you cannot use a different name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        The version number of the launch template to use. If no version is specified, then the template's default version is used. You can use a different version for node group updates.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class NodegroupNodeRepairConfig(dict):
    """
    The node auto repair configuration for node group.
    """
    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None):
        """
        The node auto repair configuration for node group.
        :param builtins.bool enabled: Set this value to true to enable node auto repair for the node group.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Set this value to true to enable node auto repair for the node group.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class NodegroupRemoteAccess(dict):
    """
    An object representing a remote access configuration specification for AWS EKS Nodegroup.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ec2SshKey":
            suggest = "ec2_ssh_key"
        elif key == "sourceSecurityGroups":
            suggest = "source_security_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodegroupRemoteAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodegroupRemoteAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodegroupRemoteAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ec2_ssh_key: builtins.str,
                 source_security_groups: Optional[Sequence[builtins.str]] = None):
        """
        An object representing a remote access configuration specification for AWS EKS Nodegroup.
        :param builtins.str ec2_ssh_key: The Amazon EC2 SSH key name that provides access for SSH communication with the nodes in the managed node group. For more information, see [Amazon EC2 key pairs and Linux instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html) in the *Amazon Elastic Compute Cloud User Guide for Linux Instances* . For Windows, an Amazon EC2 SSH key is used to obtain the RDP password. For more information, see [Amazon EC2 key pairs and Windows instances](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-key-pairs.html) in the *Amazon Elastic Compute Cloud User Guide for Windows Instances* .
        :param Sequence[builtins.str] source_security_groups: The security group IDs that are allowed SSH access (port 22) to the nodes. For Windows, the port is 3389. If you specify an Amazon EC2 SSH key but don't specify a source security group when you create a managed node group, then the port on the nodes is opened to the internet ( `0.0.0.0/0` ). For more information, see [Security Groups for Your VPC](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html) in the *Amazon Virtual Private Cloud User Guide* .
        """
        pulumi.set(__self__, "ec2_ssh_key", ec2_ssh_key)
        if source_security_groups is not None:
            pulumi.set(__self__, "source_security_groups", source_security_groups)

    @property
    @pulumi.getter(name="ec2SshKey")
    def ec2_ssh_key(self) -> builtins.str:
        """
        The Amazon EC2 SSH key name that provides access for SSH communication with the nodes in the managed node group. For more information, see [Amazon EC2 key pairs and Linux instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html) in the *Amazon Elastic Compute Cloud User Guide for Linux Instances* . For Windows, an Amazon EC2 SSH key is used to obtain the RDP password. For more information, see [Amazon EC2 key pairs and Windows instances](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-key-pairs.html) in the *Amazon Elastic Compute Cloud User Guide for Windows Instances* .
        """
        return pulumi.get(self, "ec2_ssh_key")

    @property
    @pulumi.getter(name="sourceSecurityGroups")
    def source_security_groups(self) -> Optional[Sequence[builtins.str]]:
        """
        The security group IDs that are allowed SSH access (port 22) to the nodes. For Windows, the port is 3389. If you specify an Amazon EC2 SSH key but don't specify a source security group when you create a managed node group, then the port on the nodes is opened to the internet ( `0.0.0.0/0` ). For more information, see [Security Groups for Your VPC](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html) in the *Amazon Virtual Private Cloud User Guide* .
        """
        return pulumi.get(self, "source_security_groups")


@pulumi.output_type
class NodegroupScalingConfig(dict):
    """
    An object representing a auto scaling group specification for AWS EKS Nodegroup.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "desiredSize":
            suggest = "desired_size"
        elif key == "maxSize":
            suggest = "max_size"
        elif key == "minSize":
            suggest = "min_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodegroupScalingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodegroupScalingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodegroupScalingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 desired_size: Optional[builtins.int] = None,
                 max_size: Optional[builtins.int] = None,
                 min_size: Optional[builtins.int] = None):
        """
        An object representing a auto scaling group specification for AWS EKS Nodegroup.
        :param builtins.int desired_size: The current number of nodes that the managed node group should maintain.
               
               > If you use the Kubernetes [Cluster Autoscaler](https://docs.aws.amazon.com/https://github.com/kubernetes/autoscaler#kubernetes-autoscaler) , you shouldn't change the `desiredSize` value directly, as this can cause the Cluster Autoscaler to suddenly scale up or scale down. 
               
               Whenever this parameter changes, the number of worker nodes in the node group is updated to the specified size. If this parameter is given a value that is smaller than the current number of running worker nodes, the necessary number of worker nodes are terminated to match the given value. When using CloudFormation, no action occurs if you remove this parameter from your CFN template.
               
               This parameter can be different from `minSize` in some cases, such as when starting with extra hosts for testing. This parameter can also be different when you want to start with an estimated number of needed hosts, but let the Cluster Autoscaler reduce the number if there are too many. When the Cluster Autoscaler is used, the `desiredSize` parameter is altered by the Cluster Autoscaler (but can be out-of-date for short periods of time). the Cluster Autoscaler doesn't scale a managed node group lower than `minSize` or higher than `maxSize` .
        :param builtins.int max_size: The maximum number of nodes that the managed node group can scale out to. For information about the maximum number that you can specify, see [Amazon EKS service quotas](https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html) in the *Amazon EKS User Guide* .
        :param builtins.int min_size: The minimum number of nodes that the managed node group can scale in to.
        """
        if desired_size is not None:
            pulumi.set(__self__, "desired_size", desired_size)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)

    @property
    @pulumi.getter(name="desiredSize")
    def desired_size(self) -> Optional[builtins.int]:
        """
        The current number of nodes that the managed node group should maintain.

        > If you use the Kubernetes [Cluster Autoscaler](https://docs.aws.amazon.com/https://github.com/kubernetes/autoscaler#kubernetes-autoscaler) , you shouldn't change the `desiredSize` value directly, as this can cause the Cluster Autoscaler to suddenly scale up or scale down. 

        Whenever this parameter changes, the number of worker nodes in the node group is updated to the specified size. If this parameter is given a value that is smaller than the current number of running worker nodes, the necessary number of worker nodes are terminated to match the given value. When using CloudFormation, no action occurs if you remove this parameter from your CFN template.

        This parameter can be different from `minSize` in some cases, such as when starting with extra hosts for testing. This parameter can also be different when you want to start with an estimated number of needed hosts, but let the Cluster Autoscaler reduce the number if there are too many. When the Cluster Autoscaler is used, the `desiredSize` parameter is altered by the Cluster Autoscaler (but can be out-of-date for short periods of time). the Cluster Autoscaler doesn't scale a managed node group lower than `minSize` or higher than `maxSize` .
        """
        return pulumi.get(self, "desired_size")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[builtins.int]:
        """
        The maximum number of nodes that the managed node group can scale out to. For information about the maximum number that you can specify, see [Amazon EKS service quotas](https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html) in the *Amazon EKS User Guide* .
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[builtins.int]:
        """
        The minimum number of nodes that the managed node group can scale in to.
        """
        return pulumi.get(self, "min_size")


@pulumi.output_type
class NodegroupTaint(dict):
    """
    An object representing a Taint specification for AWS EKS Nodegroup.
    """
    def __init__(__self__, *,
                 effect: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        An object representing a Taint specification for AWS EKS Nodegroup.
        :param builtins.str effect: The effect of the taint.
        :param builtins.str key: The key of the taint.
        :param builtins.str value: The value of the taint.
        """
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[builtins.str]:
        """
        The effect of the taint.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        The key of the taint.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The value of the taint.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NodegroupUpdateConfig(dict):
    """
    The node group update configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxUnavailable":
            suggest = "max_unavailable"
        elif key == "maxUnavailablePercentage":
            suggest = "max_unavailable_percentage"
        elif key == "updateStrategy":
            suggest = "update_strategy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodegroupUpdateConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodegroupUpdateConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodegroupUpdateConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_unavailable: Optional[builtins.float] = None,
                 max_unavailable_percentage: Optional[builtins.float] = None,
                 update_strategy: Optional[builtins.str] = None):
        """
        The node group update configuration.
        :param builtins.float max_unavailable: The maximum number of nodes unavailable at once during a version update. Nodes will be updated in parallel. This value or maxUnavailablePercentage is required to have a value.The maximum number is 100. 
        :param builtins.float max_unavailable_percentage: The maximum percentage of nodes unavailable during a version update. This percentage of nodes will be updated in parallel, up to 100 nodes at once. This value or maxUnavailable is required to have a value.
        :param builtins.str update_strategy: The configuration for the behavior to follow during an node group version update of this managed node group. You choose between two possible strategies for replacing nodes during an UpdateNodegroupVersion action.
        """
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)
        if max_unavailable_percentage is not None:
            pulumi.set(__self__, "max_unavailable_percentage", max_unavailable_percentage)
        if update_strategy is not None:
            pulumi.set(__self__, "update_strategy", update_strategy)

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[builtins.float]:
        """
        The maximum number of nodes unavailable at once during a version update. Nodes will be updated in parallel. This value or maxUnavailablePercentage is required to have a value.The maximum number is 100. 
        """
        return pulumi.get(self, "max_unavailable")

    @property
    @pulumi.getter(name="maxUnavailablePercentage")
    def max_unavailable_percentage(self) -> Optional[builtins.float]:
        """
        The maximum percentage of nodes unavailable during a version update. This percentage of nodes will be updated in parallel, up to 100 nodes at once. This value or maxUnavailable is required to have a value.
        """
        return pulumi.get(self, "max_unavailable_percentage")

    @property
    @pulumi.getter(name="updateStrategy")
    def update_strategy(self) -> Optional[builtins.str]:
        """
        The configuration for the behavior to follow during an node group version update of this managed node group. You choose between two possible strategies for replacing nodes during an UpdateNodegroupVersion action.
        """
        return pulumi.get(self, "update_strategy")


