# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NodegroupArgs', 'Nodegroup']

@pulumi.input_type
class NodegroupArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[builtins.str],
                 node_role: pulumi.Input[builtins.str],
                 subnets: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 ami_type: Optional[pulumi.Input[builtins.str]] = None,
                 capacity_type: Optional[pulumi.Input[builtins.str]] = None,
                 disk_size: Optional[pulumi.Input[builtins.int]] = None,
                 force_update_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 launch_template: Optional[pulumi.Input['NodegroupLaunchTemplateSpecificationArgs']] = None,
                 node_repair_config: Optional[pulumi.Input['NodegroupNodeRepairConfigArgs']] = None,
                 nodegroup_name: Optional[pulumi.Input[builtins.str]] = None,
                 release_version: Optional[pulumi.Input[builtins.str]] = None,
                 remote_access: Optional[pulumi.Input['NodegroupRemoteAccessArgs']] = None,
                 scaling_config: Optional[pulumi.Input['NodegroupScalingConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['NodegroupTaintArgs']]]] = None,
                 update_config: Optional[pulumi.Input['NodegroupUpdateConfigArgs']] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Nodegroup resource.
        :param pulumi.Input[builtins.str] cluster_name: Name of the cluster to create the node group in.
        :param pulumi.Input[builtins.str] node_role: The Amazon Resource Name (ARN) of the IAM role to associate with your node group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnets: The subnets to use for the Auto Scaling group that is created for your node group.
        :param pulumi.Input[builtins.str] ami_type: The AMI type for your node group.
        :param pulumi.Input[builtins.str] capacity_type: The capacity type of your managed node group.
        :param pulumi.Input[builtins.int] disk_size: The root device disk size (in GiB) for your node group instances.
        :param pulumi.Input[builtins.bool] force_update_enabled: Force the update if the existing node group's pods are unable to be drained due to a pod disruption budget issue.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] instance_types: Specify the instance types for a node group.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The Kubernetes labels to be applied to the nodes in the node group when they are created.
        :param pulumi.Input['NodegroupLaunchTemplateSpecificationArgs'] launch_template: An object representing a node group's launch template specification.
        :param pulumi.Input['NodegroupNodeRepairConfigArgs'] node_repair_config: The node auto repair configuration for node group.
        :param pulumi.Input[builtins.str] nodegroup_name: The unique name to give your node group.
        :param pulumi.Input[builtins.str] release_version: The AMI version of the Amazon EKS-optimized AMI to use with your node group.
        :param pulumi.Input['NodegroupRemoteAccessArgs'] remote_access: The remote access (SSH) configuration to use with your node group.
        :param pulumi.Input['NodegroupScalingConfigArgs'] scaling_config: The scaling configuration details for the Auto Scaling group that is created for your node group.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: The metadata, as key-value pairs, to apply to the node group to assist with categorization and organization. Follows same schema as Labels for consistency.
        :param pulumi.Input[Sequence[pulumi.Input['NodegroupTaintArgs']]] taints: The Kubernetes taints to be applied to the nodes in the node group when they are created.
        :param pulumi.Input['NodegroupUpdateConfigArgs'] update_config: The node group update configuration.
        :param pulumi.Input[builtins.str] version: The Kubernetes version to use for your managed nodes.
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "node_role", node_role)
        pulumi.set(__self__, "subnets", subnets)
        if ami_type is not None:
            pulumi.set(__self__, "ami_type", ami_type)
        if capacity_type is not None:
            pulumi.set(__self__, "capacity_type", capacity_type)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if force_update_enabled is not None:
            pulumi.set(__self__, "force_update_enabled", force_update_enabled)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if launch_template is not None:
            pulumi.set(__self__, "launch_template", launch_template)
        if node_repair_config is not None:
            pulumi.set(__self__, "node_repair_config", node_repair_config)
        if nodegroup_name is not None:
            pulumi.set(__self__, "nodegroup_name", nodegroup_name)
        if release_version is not None:
            pulumi.set(__self__, "release_version", release_version)
        if remote_access is not None:
            pulumi.set(__self__, "remote_access", remote_access)
        if scaling_config is not None:
            pulumi.set(__self__, "scaling_config", scaling_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if update_config is not None:
            pulumi.set(__self__, "update_config", update_config)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the cluster to create the node group in.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="nodeRole")
    def node_role(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM role to associate with your node group.
        """
        return pulumi.get(self, "node_role")

    @node_role.setter
    def node_role(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "node_role", value)

    @property
    @pulumi.getter
    def subnets(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The subnets to use for the Auto Scaling group that is created for your node group.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "subnets", value)

    @property
    @pulumi.getter(name="amiType")
    def ami_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AMI type for your node group.
        """
        return pulumi.get(self, "ami_type")

    @ami_type.setter
    def ami_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ami_type", value)

    @property
    @pulumi.getter(name="capacityType")
    def capacity_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The capacity type of your managed node group.
        """
        return pulumi.get(self, "capacity_type")

    @capacity_type.setter
    def capacity_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "capacity_type", value)

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The root device disk size (in GiB) for your node group instances.
        """
        return pulumi.get(self, "disk_size")

    @disk_size.setter
    def disk_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "disk_size", value)

    @property
    @pulumi.getter(name="forceUpdateEnabled")
    def force_update_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Force the update if the existing node group's pods are unable to be drained due to a pod disruption budget issue.
        """
        return pulumi.get(self, "force_update_enabled")

    @force_update_enabled.setter
    def force_update_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force_update_enabled", value)

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specify the instance types for a node group.
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "instance_types", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The Kubernetes labels to be applied to the nodes in the node group when they are created.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> Optional[pulumi.Input['NodegroupLaunchTemplateSpecificationArgs']]:
        """
        An object representing a node group's launch template specification.
        """
        return pulumi.get(self, "launch_template")

    @launch_template.setter
    def launch_template(self, value: Optional[pulumi.Input['NodegroupLaunchTemplateSpecificationArgs']]):
        pulumi.set(self, "launch_template", value)

    @property
    @pulumi.getter(name="nodeRepairConfig")
    def node_repair_config(self) -> Optional[pulumi.Input['NodegroupNodeRepairConfigArgs']]:
        """
        The node auto repair configuration for node group.
        """
        return pulumi.get(self, "node_repair_config")

    @node_repair_config.setter
    def node_repair_config(self, value: Optional[pulumi.Input['NodegroupNodeRepairConfigArgs']]):
        pulumi.set(self, "node_repair_config", value)

    @property
    @pulumi.getter(name="nodegroupName")
    def nodegroup_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique name to give your node group.
        """
        return pulumi.get(self, "nodegroup_name")

    @nodegroup_name.setter
    def nodegroup_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "nodegroup_name", value)

    @property
    @pulumi.getter(name="releaseVersion")
    def release_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AMI version of the Amazon EKS-optimized AMI to use with your node group.
        """
        return pulumi.get(self, "release_version")

    @release_version.setter
    def release_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "release_version", value)

    @property
    @pulumi.getter(name="remoteAccess")
    def remote_access(self) -> Optional[pulumi.Input['NodegroupRemoteAccessArgs']]:
        """
        The remote access (SSH) configuration to use with your node group.
        """
        return pulumi.get(self, "remote_access")

    @remote_access.setter
    def remote_access(self, value: Optional[pulumi.Input['NodegroupRemoteAccessArgs']]):
        pulumi.set(self, "remote_access", value)

    @property
    @pulumi.getter(name="scalingConfig")
    def scaling_config(self) -> Optional[pulumi.Input['NodegroupScalingConfigArgs']]:
        """
        The scaling configuration details for the Auto Scaling group that is created for your node group.
        """
        return pulumi.get(self, "scaling_config")

    @scaling_config.setter
    def scaling_config(self, value: Optional[pulumi.Input['NodegroupScalingConfigArgs']]):
        pulumi.set(self, "scaling_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The metadata, as key-value pairs, to apply to the node group to assist with categorization and organization. Follows same schema as Labels for consistency.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodegroupTaintArgs']]]]:
        """
        The Kubernetes taints to be applied to the nodes in the node group when they are created.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodegroupTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter(name="updateConfig")
    def update_config(self) -> Optional[pulumi.Input['NodegroupUpdateConfigArgs']]:
        """
        The node group update configuration.
        """
        return pulumi.get(self, "update_config")

    @update_config.setter
    def update_config(self, value: Optional[pulumi.Input['NodegroupUpdateConfigArgs']]):
        pulumi.set(self, "update_config", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Kubernetes version to use for your managed nodes.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("aws-native:eks:Nodegroup")
class Nodegroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ami_type: Optional[pulumi.Input[builtins.str]] = None,
                 capacity_type: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[builtins.str]] = None,
                 disk_size: Optional[pulumi.Input[builtins.int]] = None,
                 force_update_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 launch_template: Optional[pulumi.Input[Union['NodegroupLaunchTemplateSpecificationArgs', 'NodegroupLaunchTemplateSpecificationArgsDict']]] = None,
                 node_repair_config: Optional[pulumi.Input[Union['NodegroupNodeRepairConfigArgs', 'NodegroupNodeRepairConfigArgsDict']]] = None,
                 node_role: Optional[pulumi.Input[builtins.str]] = None,
                 nodegroup_name: Optional[pulumi.Input[builtins.str]] = None,
                 release_version: Optional[pulumi.Input[builtins.str]] = None,
                 remote_access: Optional[pulumi.Input[Union['NodegroupRemoteAccessArgs', 'NodegroupRemoteAccessArgsDict']]] = None,
                 scaling_config: Optional[pulumi.Input[Union['NodegroupScalingConfigArgs', 'NodegroupScalingConfigArgsDict']]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodegroupTaintArgs', 'NodegroupTaintArgsDict']]]]] = None,
                 update_config: Optional[pulumi.Input[Union['NodegroupUpdateConfigArgs', 'NodegroupUpdateConfigArgsDict']]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource schema for AWS::EKS::Nodegroup

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        eks_nodegroup = aws_native.eks.Nodegroup("eksNodegroup",
            cluster_name="prod",
            node_role="arn:aws:iam::012345678910:role/eksInstanceRole",
            scaling_config={
                "min_size": 3,
                "desired_size": 5,
                "max_size": 7,
            },
            labels={
                "key1": "Value1",
                "key2": "Value2",
            },
            subnets=[
                "subnet-6782e71e",
                "subnet-e7e761ac",
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        eks_nodegroup = aws_native.eks.Nodegroup("eksNodegroup",
            cluster_name="prod",
            node_role="arn:aws:iam::012345678910:role/eksInstanceRole",
            scaling_config={
                "min_size": 3,
                "desired_size": 5,
                "max_size": 7,
            },
            labels={
                "key1": "Value1",
                "key2": "Value2",
            },
            subnets=[
                "subnet-6782e71e",
                "subnet-e7e761ac",
            ])

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] ami_type: The AMI type for your node group.
        :param pulumi.Input[builtins.str] capacity_type: The capacity type of your managed node group.
        :param pulumi.Input[builtins.str] cluster_name: Name of the cluster to create the node group in.
        :param pulumi.Input[builtins.int] disk_size: The root device disk size (in GiB) for your node group instances.
        :param pulumi.Input[builtins.bool] force_update_enabled: Force the update if the existing node group's pods are unable to be drained due to a pod disruption budget issue.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] instance_types: Specify the instance types for a node group.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The Kubernetes labels to be applied to the nodes in the node group when they are created.
        :param pulumi.Input[Union['NodegroupLaunchTemplateSpecificationArgs', 'NodegroupLaunchTemplateSpecificationArgsDict']] launch_template: An object representing a node group's launch template specification.
        :param pulumi.Input[Union['NodegroupNodeRepairConfigArgs', 'NodegroupNodeRepairConfigArgsDict']] node_repair_config: The node auto repair configuration for node group.
        :param pulumi.Input[builtins.str] node_role: The Amazon Resource Name (ARN) of the IAM role to associate with your node group.
        :param pulumi.Input[builtins.str] nodegroup_name: The unique name to give your node group.
        :param pulumi.Input[builtins.str] release_version: The AMI version of the Amazon EKS-optimized AMI to use with your node group.
        :param pulumi.Input[Union['NodegroupRemoteAccessArgs', 'NodegroupRemoteAccessArgsDict']] remote_access: The remote access (SSH) configuration to use with your node group.
        :param pulumi.Input[Union['NodegroupScalingConfigArgs', 'NodegroupScalingConfigArgsDict']] scaling_config: The scaling configuration details for the Auto Scaling group that is created for your node group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnets: The subnets to use for the Auto Scaling group that is created for your node group.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: The metadata, as key-value pairs, to apply to the node group to assist with categorization and organization. Follows same schema as Labels for consistency.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NodegroupTaintArgs', 'NodegroupTaintArgsDict']]]] taints: The Kubernetes taints to be applied to the nodes in the node group when they are created.
        :param pulumi.Input[Union['NodegroupUpdateConfigArgs', 'NodegroupUpdateConfigArgsDict']] update_config: The node group update configuration.
        :param pulumi.Input[builtins.str] version: The Kubernetes version to use for your managed nodes.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NodegroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::EKS::Nodegroup

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        eks_nodegroup = aws_native.eks.Nodegroup("eksNodegroup",
            cluster_name="prod",
            node_role="arn:aws:iam::012345678910:role/eksInstanceRole",
            scaling_config={
                "min_size": 3,
                "desired_size": 5,
                "max_size": 7,
            },
            labels={
                "key1": "Value1",
                "key2": "Value2",
            },
            subnets=[
                "subnet-6782e71e",
                "subnet-e7e761ac",
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        eks_nodegroup = aws_native.eks.Nodegroup("eksNodegroup",
            cluster_name="prod",
            node_role="arn:aws:iam::012345678910:role/eksInstanceRole",
            scaling_config={
                "min_size": 3,
                "desired_size": 5,
                "max_size": 7,
            },
            labels={
                "key1": "Value1",
                "key2": "Value2",
            },
            subnets=[
                "subnet-6782e71e",
                "subnet-e7e761ac",
            ])

        ```

        :param str resource_name: The name of the resource.
        :param NodegroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NodegroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ami_type: Optional[pulumi.Input[builtins.str]] = None,
                 capacity_type: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[builtins.str]] = None,
                 disk_size: Optional[pulumi.Input[builtins.int]] = None,
                 force_update_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 launch_template: Optional[pulumi.Input[Union['NodegroupLaunchTemplateSpecificationArgs', 'NodegroupLaunchTemplateSpecificationArgsDict']]] = None,
                 node_repair_config: Optional[pulumi.Input[Union['NodegroupNodeRepairConfigArgs', 'NodegroupNodeRepairConfigArgsDict']]] = None,
                 node_role: Optional[pulumi.Input[builtins.str]] = None,
                 nodegroup_name: Optional[pulumi.Input[builtins.str]] = None,
                 release_version: Optional[pulumi.Input[builtins.str]] = None,
                 remote_access: Optional[pulumi.Input[Union['NodegroupRemoteAccessArgs', 'NodegroupRemoteAccessArgsDict']]] = None,
                 scaling_config: Optional[pulumi.Input[Union['NodegroupScalingConfigArgs', 'NodegroupScalingConfigArgsDict']]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NodegroupTaintArgs', 'NodegroupTaintArgsDict']]]]] = None,
                 update_config: Optional[pulumi.Input[Union['NodegroupUpdateConfigArgs', 'NodegroupUpdateConfigArgsDict']]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NodegroupArgs.__new__(NodegroupArgs)

            __props__.__dict__["ami_type"] = ami_type
            __props__.__dict__["capacity_type"] = capacity_type
            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["disk_size"] = disk_size
            __props__.__dict__["force_update_enabled"] = force_update_enabled
            __props__.__dict__["instance_types"] = instance_types
            __props__.__dict__["labels"] = labels
            __props__.__dict__["launch_template"] = launch_template
            __props__.__dict__["node_repair_config"] = node_repair_config
            if node_role is None and not opts.urn:
                raise TypeError("Missing required property 'node_role'")
            __props__.__dict__["node_role"] = node_role
            __props__.__dict__["nodegroup_name"] = nodegroup_name
            __props__.__dict__["release_version"] = release_version
            __props__.__dict__["remote_access"] = remote_access
            __props__.__dict__["scaling_config"] = scaling_config
            if subnets is None and not opts.urn:
                raise TypeError("Missing required property 'subnets'")
            __props__.__dict__["subnets"] = subnets
            __props__.__dict__["tags"] = tags
            __props__.__dict__["taints"] = taints
            __props__.__dict__["update_config"] = update_config
            __props__.__dict__["version"] = version
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["amiType", "capacityType", "clusterName", "diskSize", "instanceTypes[*]", "nodeRole", "nodegroupName", "remoteAccess", "subnets[*]"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Nodegroup, __self__).__init__(
            'aws-native:eks:Nodegroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Nodegroup':
        """
        Get an existing Nodegroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = NodegroupArgs.__new__(NodegroupArgs)

        __props__.__dict__["ami_type"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["capacity_type"] = None
        __props__.__dict__["cluster_name"] = None
        __props__.__dict__["disk_size"] = None
        __props__.__dict__["force_update_enabled"] = None
        __props__.__dict__["instance_types"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["launch_template"] = None
        __props__.__dict__["node_repair_config"] = None
        __props__.__dict__["node_role"] = None
        __props__.__dict__["nodegroup_name"] = None
        __props__.__dict__["release_version"] = None
        __props__.__dict__["remote_access"] = None
        __props__.__dict__["scaling_config"] = None
        __props__.__dict__["subnets"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["taints"] = None
        __props__.__dict__["update_config"] = None
        __props__.__dict__["version"] = None
        return Nodegroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="amiType")
    def ami_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The AMI type for your node group.
        """
        return pulumi.get(self, "ami_type")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) associated with the managed node group.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="capacityType")
    def capacity_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The capacity type of your managed node group.
        """
        return pulumi.get(self, "capacity_type")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the cluster to create the node group in.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The root device disk size (in GiB) for your node group instances.
        """
        return pulumi.get(self, "disk_size")

    @property
    @pulumi.getter(name="forceUpdateEnabled")
    def force_update_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Force the update if the existing node group's pods are unable to be drained due to a pod disruption budget issue.
        """
        return pulumi.get(self, "force_update_enabled")

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Specify the instance types for a node group.
        """
        return pulumi.get(self, "instance_types")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The Kubernetes labels to be applied to the nodes in the node group when they are created.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> pulumi.Output[Optional['outputs.NodegroupLaunchTemplateSpecification']]:
        """
        An object representing a node group's launch template specification.
        """
        return pulumi.get(self, "launch_template")

    @property
    @pulumi.getter(name="nodeRepairConfig")
    def node_repair_config(self) -> pulumi.Output[Optional['outputs.NodegroupNodeRepairConfig']]:
        """
        The node auto repair configuration for node group.
        """
        return pulumi.get(self, "node_repair_config")

    @property
    @pulumi.getter(name="nodeRole")
    def node_role(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM role to associate with your node group.
        """
        return pulumi.get(self, "node_role")

    @property
    @pulumi.getter(name="nodegroupName")
    def nodegroup_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The unique name to give your node group.
        """
        return pulumi.get(self, "nodegroup_name")

    @property
    @pulumi.getter(name="releaseVersion")
    def release_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The AMI version of the Amazon EKS-optimized AMI to use with your node group.
        """
        return pulumi.get(self, "release_version")

    @property
    @pulumi.getter(name="remoteAccess")
    def remote_access(self) -> pulumi.Output[Optional['outputs.NodegroupRemoteAccess']]:
        """
        The remote access (SSH) configuration to use with your node group.
        """
        return pulumi.get(self, "remote_access")

    @property
    @pulumi.getter(name="scalingConfig")
    def scaling_config(self) -> pulumi.Output[Optional['outputs.NodegroupScalingConfig']]:
        """
        The scaling configuration details for the Auto Scaling group that is created for your node group.
        """
        return pulumi.get(self, "scaling_config")

    @property
    @pulumi.getter
    def subnets(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The subnets to use for the Auto Scaling group that is created for your node group.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The metadata, as key-value pairs, to apply to the node group to assist with categorization and organization. Follows same schema as Labels for consistency.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def taints(self) -> pulumi.Output[Optional[Sequence['outputs.NodegroupTaint']]]:
        """
        The Kubernetes taints to be applied to the nodes in the node group when they are created.
        """
        return pulumi.get(self, "taints")

    @property
    @pulumi.getter(name="updateConfig")
    def update_config(self) -> pulumi.Output[Optional['outputs.NodegroupUpdateConfig']]:
        """
        The node group update configuration.
        """
        return pulumi.get(self, "update_config")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Kubernetes version to use for your managed nodes.
        """
        return pulumi.get(self, "version")

