# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetAddonResult',
    'AwaitableGetAddonResult',
    'get_addon',
    'get_addon_output',
]

@pulumi.output_type
class GetAddonResult:
    def __init__(__self__, addon_version=None, arn=None, configuration_values=None, service_account_role_arn=None, tags=None):
        if addon_version and not isinstance(addon_version, str):
            raise TypeError("Expected argument 'addon_version' to be a str")
        pulumi.set(__self__, "addon_version", addon_version)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if configuration_values and not isinstance(configuration_values, str):
            raise TypeError("Expected argument 'configuration_values' to be a str")
        pulumi.set(__self__, "configuration_values", configuration_values)
        if service_account_role_arn and not isinstance(service_account_role_arn, str):
            raise TypeError("Expected argument 'service_account_role_arn' to be a str")
        pulumi.set(__self__, "service_account_role_arn", service_account_role_arn)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="addonVersion")
    def addon_version(self) -> Optional[builtins.str]:
        """
        Version of Addon
        """
        return pulumi.get(self, "addon_version")

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        Amazon Resource Name (ARN) of the add-on
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="configurationValues")
    def configuration_values(self) -> Optional[builtins.str]:
        """
        The configuration values to use with the add-on
        """
        return pulumi.get(self, "configuration_values")

    @property
    @pulumi.getter(name="serviceAccountRoleArn")
    def service_account_role_arn(self) -> Optional[builtins.str]:
        """
        IAM role to bind to the add-on's service account
        """
        return pulumi.get(self, "service_account_role_arn")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetAddonResult(GetAddonResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAddonResult(
            addon_version=self.addon_version,
            arn=self.arn,
            configuration_values=self.configuration_values,
            service_account_role_arn=self.service_account_role_arn,
            tags=self.tags)


def get_addon(addon_name: Optional[builtins.str] = None,
              cluster_name: Optional[builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAddonResult:
    """
    Resource Schema for AWS::EKS::Addon


    :param builtins.str addon_name: Name of Addon
    :param builtins.str cluster_name: Name of Cluster
    """
    __args__ = dict()
    __args__['addonName'] = addon_name
    __args__['clusterName'] = cluster_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:eks:getAddon', __args__, opts=opts, typ=GetAddonResult).value

    return AwaitableGetAddonResult(
        addon_version=pulumi.get(__ret__, 'addon_version'),
        arn=pulumi.get(__ret__, 'arn'),
        configuration_values=pulumi.get(__ret__, 'configuration_values'),
        service_account_role_arn=pulumi.get(__ret__, 'service_account_role_arn'),
        tags=pulumi.get(__ret__, 'tags'))
def get_addon_output(addon_name: Optional[pulumi.Input[builtins.str]] = None,
                     cluster_name: Optional[pulumi.Input[builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAddonResult]:
    """
    Resource Schema for AWS::EKS::Addon


    :param builtins.str addon_name: Name of Addon
    :param builtins.str cluster_name: Name of Cluster
    """
    __args__ = dict()
    __args__['addonName'] = addon_name
    __args__['clusterName'] = cluster_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:eks:getAddon', __args__, opts=opts, typ=GetAddonResult)
    return __ret__.apply(lambda __response__: GetAddonResult(
        addon_version=pulumi.get(__response__, 'addon_version'),
        arn=pulumi.get(__response__, 'arn'),
        configuration_values=pulumi.get(__response__, 'configuration_values'),
        service_account_role_arn=pulumi.get(__response__, 'service_account_role_arn'),
        tags=pulumi.get(__response__, 'tags')))
