# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetAccessEntryResult',
    'AwaitableGetAccessEntryResult',
    'get_access_entry',
    'get_access_entry_output',
]

@pulumi.output_type
class GetAccessEntryResult:
    def __init__(__self__, access_entry_arn=None, access_policies=None, kubernetes_groups=None, tags=None, username=None):
        if access_entry_arn and not isinstance(access_entry_arn, str):
            raise TypeError("Expected argument 'access_entry_arn' to be a str")
        pulumi.set(__self__, "access_entry_arn", access_entry_arn)
        if access_policies and not isinstance(access_policies, list):
            raise TypeError("Expected argument 'access_policies' to be a list")
        pulumi.set(__self__, "access_policies", access_policies)
        if kubernetes_groups and not isinstance(kubernetes_groups, list):
            raise TypeError("Expected argument 'kubernetes_groups' to be a list")
        pulumi.set(__self__, "kubernetes_groups", kubernetes_groups)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="accessEntryArn")
    def access_entry_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the access entry.
        """
        return pulumi.get(self, "access_entry_arn")

    @property
    @pulumi.getter(name="accessPolicies")
    def access_policies(self) -> Optional[Sequence['outputs.AccessEntryAccessPolicy']]:
        """
        An array of access policies that are associated with the access entry.
        """
        return pulumi.get(self, "access_policies")

    @property
    @pulumi.getter(name="kubernetesGroups")
    def kubernetes_groups(self) -> Optional[Sequence[builtins.str]]:
        """
        The Kubernetes groups that the access entry is associated with.
        """
        return pulumi.get(self, "kubernetes_groups")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def username(self) -> Optional[builtins.str]:
        """
        The Kubernetes user that the access entry is associated with.
        """
        return pulumi.get(self, "username")


class AwaitableGetAccessEntryResult(GetAccessEntryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccessEntryResult(
            access_entry_arn=self.access_entry_arn,
            access_policies=self.access_policies,
            kubernetes_groups=self.kubernetes_groups,
            tags=self.tags,
            username=self.username)


def get_access_entry(cluster_name: Optional[builtins.str] = None,
                     principal_arn: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccessEntryResult:
    """
    An object representing an Amazon EKS AccessEntry.


    :param builtins.str cluster_name: The cluster that the access entry is created for.
    :param builtins.str principal_arn: The principal ARN that the access entry is created for.
    """
    __args__ = dict()
    __args__['clusterName'] = cluster_name
    __args__['principalArn'] = principal_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:eks:getAccessEntry', __args__, opts=opts, typ=GetAccessEntryResult).value

    return AwaitableGetAccessEntryResult(
        access_entry_arn=pulumi.get(__ret__, 'access_entry_arn'),
        access_policies=pulumi.get(__ret__, 'access_policies'),
        kubernetes_groups=pulumi.get(__ret__, 'kubernetes_groups'),
        tags=pulumi.get(__ret__, 'tags'),
        username=pulumi.get(__ret__, 'username'))
def get_access_entry_output(cluster_name: Optional[pulumi.Input[builtins.str]] = None,
                            principal_arn: Optional[pulumi.Input[builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccessEntryResult]:
    """
    An object representing an Amazon EKS AccessEntry.


    :param builtins.str cluster_name: The cluster that the access entry is created for.
    :param builtins.str principal_arn: The principal ARN that the access entry is created for.
    """
    __args__ = dict()
    __args__['clusterName'] = cluster_name
    __args__['principalArn'] = principal_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:eks:getAccessEntry', __args__, opts=opts, typ=GetAccessEntryResult)
    return __ret__.apply(lambda __response__: GetAccessEntryResult(
        access_entry_arn=pulumi.get(__response__, 'access_entry_arn'),
        access_policies=pulumi.get(__response__, 'access_policies'),
        kubernetes_groups=pulumi.get(__response__, 'kubernetes_groups'),
        tags=pulumi.get(__response__, 'tags'),
        username=pulumi.get(__response__, 'username')))
