# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['AccessEntryArgs', 'AccessEntry']

@pulumi.input_type
class AccessEntryArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[builtins.str],
                 principal_arn: pulumi.Input[builtins.str],
                 access_policies: Optional[pulumi.Input[Sequence[pulumi.Input['AccessEntryAccessPolicyArgs']]]] = None,
                 kubernetes_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AccessEntry resource.
        :param pulumi.Input[builtins.str] cluster_name: The cluster that the access entry is created for.
        :param pulumi.Input[builtins.str] principal_arn: The principal ARN that the access entry is created for.
        :param pulumi.Input[Sequence[pulumi.Input['AccessEntryAccessPolicyArgs']]] access_policies: An array of access policies that are associated with the access entry.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] kubernetes_groups: The Kubernetes groups that the access entry is associated with.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input[builtins.str] type: The node type to associate with the access entry.
        :param pulumi.Input[builtins.str] username: The Kubernetes user that the access entry is associated with.
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "principal_arn", principal_arn)
        if access_policies is not None:
            pulumi.set(__self__, "access_policies", access_policies)
        if kubernetes_groups is not None:
            pulumi.set(__self__, "kubernetes_groups", kubernetes_groups)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[builtins.str]:
        """
        The cluster that the access entry is created for.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="principalArn")
    def principal_arn(self) -> pulumi.Input[builtins.str]:
        """
        The principal ARN that the access entry is created for.
        """
        return pulumi.get(self, "principal_arn")

    @principal_arn.setter
    def principal_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "principal_arn", value)

    @property
    @pulumi.getter(name="accessPolicies")
    def access_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccessEntryAccessPolicyArgs']]]]:
        """
        An array of access policies that are associated with the access entry.
        """
        return pulumi.get(self, "access_policies")

    @access_policies.setter
    def access_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccessEntryAccessPolicyArgs']]]]):
        pulumi.set(self, "access_policies", value)

    @property
    @pulumi.getter(name="kubernetesGroups")
    def kubernetes_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The Kubernetes groups that the access entry is associated with.
        """
        return pulumi.get(self, "kubernetes_groups")

    @kubernetes_groups.setter
    def kubernetes_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "kubernetes_groups", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The node type to associate with the access entry.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Kubernetes user that the access entry is associated with.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("aws-native:eks:AccessEntry")
class AccessEntry(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessEntryAccessPolicyArgs', 'AccessEntryAccessPolicyArgsDict']]]]] = None,
                 cluster_name: Optional[pulumi.Input[builtins.str]] = None,
                 kubernetes_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 principal_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        An object representing an Amazon EKS AccessEntry.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccessEntryAccessPolicyArgs', 'AccessEntryAccessPolicyArgsDict']]]] access_policies: An array of access policies that are associated with the access entry.
        :param pulumi.Input[builtins.str] cluster_name: The cluster that the access entry is created for.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] kubernetes_groups: The Kubernetes groups that the access entry is associated with.
        :param pulumi.Input[builtins.str] principal_arn: The principal ARN that the access entry is created for.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input[builtins.str] type: The node type to associate with the access entry.
        :param pulumi.Input[builtins.str] username: The Kubernetes user that the access entry is associated with.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccessEntryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An object representing an Amazon EKS AccessEntry.

        :param str resource_name: The name of the resource.
        :param AccessEntryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessEntryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccessEntryAccessPolicyArgs', 'AccessEntryAccessPolicyArgsDict']]]]] = None,
                 cluster_name: Optional[pulumi.Input[builtins.str]] = None,
                 kubernetes_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 principal_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessEntryArgs.__new__(AccessEntryArgs)

            __props__.__dict__["access_policies"] = access_policies
            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["kubernetes_groups"] = kubernetes_groups
            if principal_arn is None and not opts.urn:
                raise TypeError("Missing required property 'principal_arn'")
            __props__.__dict__["principal_arn"] = principal_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["type"] = type
            __props__.__dict__["username"] = username
            __props__.__dict__["access_entry_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["clusterName", "principalArn", "type"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(AccessEntry, __self__).__init__(
            'aws-native:eks:AccessEntry',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'AccessEntry':
        """
        Get an existing AccessEntry resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AccessEntryArgs.__new__(AccessEntryArgs)

        __props__.__dict__["access_entry_arn"] = None
        __props__.__dict__["access_policies"] = None
        __props__.__dict__["cluster_name"] = None
        __props__.__dict__["kubernetes_groups"] = None
        __props__.__dict__["principal_arn"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["username"] = None
        return AccessEntry(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessEntryArn")
    def access_entry_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the access entry.
        """
        return pulumi.get(self, "access_entry_arn")

    @property
    @pulumi.getter(name="accessPolicies")
    def access_policies(self) -> pulumi.Output[Optional[Sequence['outputs.AccessEntryAccessPolicy']]]:
        """
        An array of access policies that are associated with the access entry.
        """
        return pulumi.get(self, "access_policies")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[builtins.str]:
        """
        The cluster that the access entry is created for.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="kubernetesGroups")
    def kubernetes_groups(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The Kubernetes groups that the access entry is associated with.
        """
        return pulumi.get(self, "kubernetes_groups")

    @property
    @pulumi.getter(name="principalArn")
    def principal_arn(self) -> pulumi.Output[builtins.str]:
        """
        The principal ARN that the access entry is created for.
        """
        return pulumi.get(self, "principal_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The node type to associate with the access entry.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Kubernetes user that the access entry is associated with.
        """
        return pulumi.get(self, "username")

