# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetMountTargetResult',
    'AwaitableGetMountTargetResult',
    'get_mount_target',
    'get_mount_target_output',
]

@pulumi.output_type
class GetMountTargetResult:
    def __init__(__self__, id=None, security_groups=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if security_groups and not isinstance(security_groups, list):
            raise TypeError("Expected argument 'security_groups' to be a list")
        pulumi.set(__self__, "security_groups", security_groups)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the Amazon EFS file system that the mount target provides access to.

        Example: `fs-0123456789111222a`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[builtins.str]]:
        """
        VPC security group IDs, of the form ``sg-xxxxxxxx``. These must be for the same VPC as the subnet specified. The maximum number of security groups depends on account quota. For more information, see [Amazon VPC Quotas](https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html) in the *Amazon VPC User Guide* (see the *Security Groups* table).
        """
        return pulumi.get(self, "security_groups")


class AwaitableGetMountTargetResult(GetMountTargetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMountTargetResult(
            id=self.id,
            security_groups=self.security_groups)


def get_mount_target(id: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMountTargetResult:
    """
    The ``AWS::EFS::MountTarget`` resource is an Amazon EFS resource that creates a mount target for an EFS file system. You can then mount the file system on Amazon EC2 instances or other resources by using the mount target.


    :param builtins.str id: The ID of the Amazon EFS file system that the mount target provides access to.
           
           Example: `fs-0123456789111222a`
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:efs:getMountTarget', __args__, opts=opts, typ=GetMountTargetResult).value

    return AwaitableGetMountTargetResult(
        id=pulumi.get(__ret__, 'id'),
        security_groups=pulumi.get(__ret__, 'security_groups'))
def get_mount_target_output(id: Optional[pulumi.Input[builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMountTargetResult]:
    """
    The ``AWS::EFS::MountTarget`` resource is an Amazon EFS resource that creates a mount target for an EFS file system. You can then mount the file system on Amazon EC2 instances or other resources by using the mount target.


    :param builtins.str id: The ID of the Amazon EFS file system that the mount target provides access to.
           
           Example: `fs-0123456789111222a`
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:efs:getMountTarget', __args__, opts=opts, typ=GetMountTargetResult)
    return __ret__.apply(lambda __response__: GetMountTargetResult(
        id=pulumi.get(__response__, 'id'),
        security_groups=pulumi.get(__response__, 'security_groups')))
