# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['TaskSetArgs', 'TaskSet']

@pulumi.input_type
class TaskSetArgs:
    def __init__(__self__, *,
                 cluster: pulumi.Input[builtins.str],
                 service: pulumi.Input[builtins.str],
                 task_definition: pulumi.Input[builtins.str],
                 capacity_provider_strategy: Optional[pulumi.Input[Sequence[pulumi.Input['TaskSetCapacityProviderStrategyItemArgs']]]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 launch_type: Optional[pulumi.Input['TaskSetLaunchType']] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input['TaskSetLoadBalancerArgs']]]] = None,
                 network_configuration: Optional[pulumi.Input['TaskSetNetworkConfigurationArgs']] = None,
                 platform_version: Optional[pulumi.Input[builtins.str]] = None,
                 scale: Optional[pulumi.Input['TaskSetScaleArgs']] = None,
                 service_registries: Optional[pulumi.Input[Sequence[pulumi.Input['TaskSetServiceRegistryArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a TaskSet resource.
        :param pulumi.Input[builtins.str] cluster: The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to create the task set in.
        :param pulumi.Input[builtins.str] service: The short name or full Amazon Resource Name (ARN) of the service to create the task set in.
        :param pulumi.Input[builtins.str] task_definition: The short name or full Amazon Resource Name (ARN) of the task definition for the tasks in the task set to use.
        :param pulumi.Input[Sequence[pulumi.Input['TaskSetCapacityProviderStrategyItemArgs']]] capacity_provider_strategy: The capacity provider strategy that are associated with the task set.
        :param pulumi.Input[builtins.str] external_id: An optional non-unique tag that identifies this task set in external systems. If the task set is associated with a service discovery registry, the tasks in this task set will have the ECS_TASK_SET_EXTERNAL_ID AWS Cloud Map attribute set to the provided value. 
        :param pulumi.Input['TaskSetLaunchType'] launch_type: The launch type that new tasks in the task set will use. For more information, see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html in the Amazon Elastic Container Service Developer Guide. 
        :param pulumi.Input[Sequence[pulumi.Input['TaskSetLoadBalancerArgs']]] load_balancers: A load balancer object representing the load balancer to use with the task set. The supported load balancer types are either an Application Load Balancer or a Network Load Balancer.
        :param pulumi.Input['TaskSetNetworkConfigurationArgs'] network_configuration: The network configuration for the task set.
        :param pulumi.Input[builtins.str] platform_version: The platform version that the tasks in the task set should use. A platform version is specified only for tasks using the Fargate launch type. If one isn't specified, the LATEST platform version is used by default.
        :param pulumi.Input['TaskSetScaleArgs'] scale: A floating-point percentage of the desired number of tasks to place and keep running in the task set.
        :param pulumi.Input[Sequence[pulumi.Input['TaskSetServiceRegistryArgs']]] service_registries: The details of the service discovery registries to assign to this task set. For more information, see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The metadata that you apply to the task set to help you categorize and organize them. Each tag consists of a key and an optional value. You define both.
               
               The following basic restrictions apply to tags:
               
               - Maximum number of tags per resource - 50
               - For each resource, each tag key must be unique, and each tag key can have only one value.
               - Maximum key length - 128 Unicode characters in UTF-8
               - Maximum value length - 256 Unicode characters in UTF-8
               - If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
               - Tag keys and values are case-sensitive.
               - Do not use `aws:` , `AWS:` , or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "task_definition", task_definition)
        if capacity_provider_strategy is not None:
            pulumi.set(__self__, "capacity_provider_strategy", capacity_provider_strategy)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if launch_type is not None:
            pulumi.set(__self__, "launch_type", launch_type)
        if load_balancers is not None:
            pulumi.set(__self__, "load_balancers", load_balancers)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if platform_version is not None:
            pulumi.set(__self__, "platform_version", platform_version)
        if scale is not None:
            pulumi.set(__self__, "scale", scale)
        if service_registries is not None:
            pulumi.set(__self__, "service_registries", service_registries)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Input[builtins.str]:
        """
        The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to create the task set in.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[builtins.str]:
        """
        The short name or full Amazon Resource Name (ARN) of the service to create the task set in.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="taskDefinition")
    def task_definition(self) -> pulumi.Input[builtins.str]:
        """
        The short name or full Amazon Resource Name (ARN) of the task definition for the tasks in the task set to use.
        """
        return pulumi.get(self, "task_definition")

    @task_definition.setter
    def task_definition(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "task_definition", value)

    @property
    @pulumi.getter(name="capacityProviderStrategy")
    def capacity_provider_strategy(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskSetCapacityProviderStrategyItemArgs']]]]:
        """
        The capacity provider strategy that are associated with the task set.
        """
        return pulumi.get(self, "capacity_provider_strategy")

    @capacity_provider_strategy.setter
    def capacity_provider_strategy(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskSetCapacityProviderStrategyItemArgs']]]]):
        pulumi.set(self, "capacity_provider_strategy", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional non-unique tag that identifies this task set in external systems. If the task set is associated with a service discovery registry, the tasks in this task set will have the ECS_TASK_SET_EXTERNAL_ID AWS Cloud Map attribute set to the provided value. 
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="launchType")
    def launch_type(self) -> Optional[pulumi.Input['TaskSetLaunchType']]:
        """
        The launch type that new tasks in the task set will use. For more information, see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html in the Amazon Elastic Container Service Developer Guide. 
        """
        return pulumi.get(self, "launch_type")

    @launch_type.setter
    def launch_type(self, value: Optional[pulumi.Input['TaskSetLaunchType']]):
        pulumi.set(self, "launch_type", value)

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskSetLoadBalancerArgs']]]]:
        """
        A load balancer object representing the load balancer to use with the task set. The supported load balancer types are either an Application Load Balancer or a Network Load Balancer.
        """
        return pulumi.get(self, "load_balancers")

    @load_balancers.setter
    def load_balancers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskSetLoadBalancerArgs']]]]):
        pulumi.set(self, "load_balancers", value)

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['TaskSetNetworkConfigurationArgs']]:
        """
        The network configuration for the task set.
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['TaskSetNetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The platform version that the tasks in the task set should use. A platform version is specified only for tasks using the Fargate launch type. If one isn't specified, the LATEST platform version is used by default.
        """
        return pulumi.get(self, "platform_version")

    @platform_version.setter
    def platform_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "platform_version", value)

    @property
    @pulumi.getter
    def scale(self) -> Optional[pulumi.Input['TaskSetScaleArgs']]:
        """
        A floating-point percentage of the desired number of tasks to place and keep running in the task set.
        """
        return pulumi.get(self, "scale")

    @scale.setter
    def scale(self, value: Optional[pulumi.Input['TaskSetScaleArgs']]):
        pulumi.set(self, "scale", value)

    @property
    @pulumi.getter(name="serviceRegistries")
    def service_registries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskSetServiceRegistryArgs']]]]:
        """
        The details of the service discovery registries to assign to this task set. For more information, see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html.
        """
        return pulumi.get(self, "service_registries")

    @service_registries.setter
    def service_registries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskSetServiceRegistryArgs']]]]):
        pulumi.set(self, "service_registries", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The metadata that you apply to the task set to help you categorize and organize them. Each tag consists of a key and an optional value. You define both.

        The following basic restrictions apply to tags:

        - Maximum number of tags per resource - 50
        - For each resource, each tag key must be unique, and each tag key can have only one value.
        - Maximum key length - 128 Unicode characters in UTF-8
        - Maximum value length - 256 Unicode characters in UTF-8
        - If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
        - Tag keys and values are case-sensitive.
        - Do not use `aws:` , `AWS:` , or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:ecs:TaskSet")
class TaskSet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity_provider_strategy: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TaskSetCapacityProviderStrategyItemArgs', 'TaskSetCapacityProviderStrategyItemArgsDict']]]]] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 launch_type: Optional[pulumi.Input['TaskSetLaunchType']] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TaskSetLoadBalancerArgs', 'TaskSetLoadBalancerArgsDict']]]]] = None,
                 network_configuration: Optional[pulumi.Input[Union['TaskSetNetworkConfigurationArgs', 'TaskSetNetworkConfigurationArgsDict']]] = None,
                 platform_version: Optional[pulumi.Input[builtins.str]] = None,
                 scale: Optional[pulumi.Input[Union['TaskSetScaleArgs', 'TaskSetScaleArgsDict']]] = None,
                 service: Optional[pulumi.Input[builtins.str]] = None,
                 service_registries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TaskSetServiceRegistryArgs', 'TaskSetServiceRegistryArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 task_definition: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Create a task set in the specified cluster and service. This is used when a service uses the EXTERNAL deployment controller type. For more information, see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.htmlin the Amazon Elastic Container Service Developer Guide.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TaskSetCapacityProviderStrategyItemArgs', 'TaskSetCapacityProviderStrategyItemArgsDict']]]] capacity_provider_strategy: The capacity provider strategy that are associated with the task set.
        :param pulumi.Input[builtins.str] cluster: The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to create the task set in.
        :param pulumi.Input[builtins.str] external_id: An optional non-unique tag that identifies this task set in external systems. If the task set is associated with a service discovery registry, the tasks in this task set will have the ECS_TASK_SET_EXTERNAL_ID AWS Cloud Map attribute set to the provided value. 
        :param pulumi.Input['TaskSetLaunchType'] launch_type: The launch type that new tasks in the task set will use. For more information, see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html in the Amazon Elastic Container Service Developer Guide. 
        :param pulumi.Input[Sequence[pulumi.Input[Union['TaskSetLoadBalancerArgs', 'TaskSetLoadBalancerArgsDict']]]] load_balancers: A load balancer object representing the load balancer to use with the task set. The supported load balancer types are either an Application Load Balancer or a Network Load Balancer.
        :param pulumi.Input[Union['TaskSetNetworkConfigurationArgs', 'TaskSetNetworkConfigurationArgsDict']] network_configuration: The network configuration for the task set.
        :param pulumi.Input[builtins.str] platform_version: The platform version that the tasks in the task set should use. A platform version is specified only for tasks using the Fargate launch type. If one isn't specified, the LATEST platform version is used by default.
        :param pulumi.Input[Union['TaskSetScaleArgs', 'TaskSetScaleArgsDict']] scale: A floating-point percentage of the desired number of tasks to place and keep running in the task set.
        :param pulumi.Input[builtins.str] service: The short name or full Amazon Resource Name (ARN) of the service to create the task set in.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TaskSetServiceRegistryArgs', 'TaskSetServiceRegistryArgsDict']]]] service_registries: The details of the service discovery registries to assign to this task set. For more information, see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The metadata that you apply to the task set to help you categorize and organize them. Each tag consists of a key and an optional value. You define both.
               
               The following basic restrictions apply to tags:
               
               - Maximum number of tags per resource - 50
               - For each resource, each tag key must be unique, and each tag key can have only one value.
               - Maximum key length - 128 Unicode characters in UTF-8
               - Maximum value length - 256 Unicode characters in UTF-8
               - If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
               - Tag keys and values are case-sensitive.
               - Do not use `aws:` , `AWS:` , or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
        :param pulumi.Input[builtins.str] task_definition: The short name or full Amazon Resource Name (ARN) of the task definition for the tasks in the task set to use.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TaskSetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a task set in the specified cluster and service. This is used when a service uses the EXTERNAL deployment controller type. For more information, see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.htmlin the Amazon Elastic Container Service Developer Guide.

        :param str resource_name: The name of the resource.
        :param TaskSetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TaskSetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity_provider_strategy: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TaskSetCapacityProviderStrategyItemArgs', 'TaskSetCapacityProviderStrategyItemArgsDict']]]]] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 launch_type: Optional[pulumi.Input['TaskSetLaunchType']] = None,
                 load_balancers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TaskSetLoadBalancerArgs', 'TaskSetLoadBalancerArgsDict']]]]] = None,
                 network_configuration: Optional[pulumi.Input[Union['TaskSetNetworkConfigurationArgs', 'TaskSetNetworkConfigurationArgsDict']]] = None,
                 platform_version: Optional[pulumi.Input[builtins.str]] = None,
                 scale: Optional[pulumi.Input[Union['TaskSetScaleArgs', 'TaskSetScaleArgsDict']]] = None,
                 service: Optional[pulumi.Input[builtins.str]] = None,
                 service_registries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TaskSetServiceRegistryArgs', 'TaskSetServiceRegistryArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 task_definition: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TaskSetArgs.__new__(TaskSetArgs)

            __props__.__dict__["capacity_provider_strategy"] = capacity_provider_strategy
            if cluster is None and not opts.urn:
                raise TypeError("Missing required property 'cluster'")
            __props__.__dict__["cluster"] = cluster
            __props__.__dict__["external_id"] = external_id
            __props__.__dict__["launch_type"] = launch_type
            __props__.__dict__["load_balancers"] = load_balancers
            __props__.__dict__["network_configuration"] = network_configuration
            __props__.__dict__["platform_version"] = platform_version
            __props__.__dict__["scale"] = scale
            if service is None and not opts.urn:
                raise TypeError("Missing required property 'service'")
            __props__.__dict__["service"] = service
            __props__.__dict__["service_registries"] = service_registries
            __props__.__dict__["tags"] = tags
            if task_definition is None and not opts.urn:
                raise TypeError("Missing required property 'task_definition'")
            __props__.__dict__["task_definition"] = task_definition
            __props__.__dict__["aws_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["capacityProviderStrategy[*]", "cluster", "externalId", "launchType", "loadBalancers[*]", "networkConfiguration", "platformVersion", "service", "serviceRegistries[*]", "taskDefinition"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(TaskSet, __self__).__init__(
            'aws-native:ecs:TaskSet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'TaskSet':
        """
        Get an existing TaskSet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = TaskSetArgs.__new__(TaskSetArgs)

        __props__.__dict__["aws_id"] = None
        __props__.__dict__["capacity_provider_strategy"] = None
        __props__.__dict__["cluster"] = None
        __props__.__dict__["external_id"] = None
        __props__.__dict__["launch_type"] = None
        __props__.__dict__["load_balancers"] = None
        __props__.__dict__["network_configuration"] = None
        __props__.__dict__["platform_version"] = None
        __props__.__dict__["scale"] = None
        __props__.__dict__["service"] = None
        __props__.__dict__["service_registries"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["task_definition"] = None
        return TaskSet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the task set.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="capacityProviderStrategy")
    def capacity_provider_strategy(self) -> pulumi.Output[Optional[Sequence['outputs.TaskSetCapacityProviderStrategyItem']]]:
        """
        The capacity provider strategy that are associated with the task set.
        """
        return pulumi.get(self, "capacity_provider_strategy")

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Output[builtins.str]:
        """
        The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to create the task set in.
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An optional non-unique tag that identifies this task set in external systems. If the task set is associated with a service discovery registry, the tasks in this task set will have the ECS_TASK_SET_EXTERNAL_ID AWS Cloud Map attribute set to the provided value. 
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="launchType")
    def launch_type(self) -> pulumi.Output[Optional['TaskSetLaunchType']]:
        """
        The launch type that new tasks in the task set will use. For more information, see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html in the Amazon Elastic Container Service Developer Guide. 
        """
        return pulumi.get(self, "launch_type")

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> pulumi.Output[Optional[Sequence['outputs.TaskSetLoadBalancer']]]:
        """
        A load balancer object representing the load balancer to use with the task set. The supported load balancer types are either an Application Load Balancer or a Network Load Balancer.
        """
        return pulumi.get(self, "load_balancers")

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> pulumi.Output[Optional['outputs.TaskSetNetworkConfiguration']]:
        """
        The network configuration for the task set.
        """
        return pulumi.get(self, "network_configuration")

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The platform version that the tasks in the task set should use. A platform version is specified only for tasks using the Fargate launch type. If one isn't specified, the LATEST platform version is used by default.
        """
        return pulumi.get(self, "platform_version")

    @property
    @pulumi.getter
    def scale(self) -> pulumi.Output[Optional['outputs.TaskSetScale']]:
        """
        A floating-point percentage of the desired number of tasks to place and keep running in the task set.
        """
        return pulumi.get(self, "scale")

    @property
    @pulumi.getter
    def service(self) -> pulumi.Output[builtins.str]:
        """
        The short name or full Amazon Resource Name (ARN) of the service to create the task set in.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="serviceRegistries")
    def service_registries(self) -> pulumi.Output[Optional[Sequence['outputs.TaskSetServiceRegistry']]]:
        """
        The details of the service discovery registries to assign to this task set. For more information, see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html.
        """
        return pulumi.get(self, "service_registries")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The metadata that you apply to the task set to help you categorize and organize them. Each tag consists of a key and an optional value. You define both.

        The following basic restrictions apply to tags:

        - Maximum number of tags per resource - 50
        - For each resource, each tag key must be unique, and each tag key can have only one value.
        - Maximum key length - 128 Unicode characters in UTF-8
        - Maximum value length - 256 Unicode characters in UTF-8
        - If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
        - Tag keys and values are case-sensitive.
        - Do not use `aws:` , `AWS:` , or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="taskDefinition")
    def task_definition(self) -> pulumi.Output[builtins.str]:
        """
        The short name or full Amazon Resource Name (ARN) of the task definition for the tasks in the task set to use.
        """
        return pulumi.get(self, "task_definition")

