# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['TaskDefinitionArgs', 'TaskDefinition']

@pulumi.input_type
class TaskDefinitionArgs:
    def __init__(__self__, *,
                 container_definitions: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionContainerDefinitionArgs']]]] = None,
                 cpu: Optional[pulumi.Input[builtins.str]] = None,
                 enable_fault_injection: Optional[pulumi.Input[builtins.bool]] = None,
                 ephemeral_storage: Optional[pulumi.Input['TaskDefinitionEphemeralStorageArgs']] = None,
                 execution_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 family: Optional[pulumi.Input[builtins.str]] = None,
                 inference_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionInferenceAcceleratorArgs']]]] = None,
                 ipc_mode: Optional[pulumi.Input[builtins.str]] = None,
                 memory: Optional[pulumi.Input[builtins.str]] = None,
                 network_mode: Optional[pulumi.Input[builtins.str]] = None,
                 pid_mode: Optional[pulumi.Input[builtins.str]] = None,
                 placement_constraints: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionPlacementConstraintArgs']]]] = None,
                 proxy_configuration: Optional[pulumi.Input['TaskDefinitionProxyConfigurationArgs']] = None,
                 requires_compatibilities: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 runtime_platform: Optional[pulumi.Input['TaskDefinitionRuntimePlatformArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 task_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionVolumeArgs']]]] = None):
        """
        The set of arguments for constructing a TaskDefinition resource.
        :param pulumi.Input[Sequence[pulumi.Input['TaskDefinitionContainerDefinitionArgs']]] container_definitions: A list of container definitions in JSON format that describe the different containers that make up your task. For more information about container definition parameters and defaults, see [Amazon ECS Task Definitions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param pulumi.Input[builtins.str] cpu: The number of ``cpu`` units used by the task. If you use the EC2 launch type, this field is optional. Any value can be used. If you use the Fargate launch type, this field is required. You must use one of the following values. The value that you choose determines your range of valid values for the ``memory`` parameter.
                If you're using the EC2 launch type or the external launch type, this field is optional. Supported values are between ``128`` CPU units (``0.125`` vCPUs) and ``196608`` CPU units (``192`` vCPUs). 
                This field is required for Fargate. For information about the valid values, see [Task size](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#task_size) in the *Amazon Elastic Container Service Developer Guide*.
        :param pulumi.Input[builtins.bool] enable_fault_injection: Enables fault injection and allows for fault injection requests to be accepted from the task's containers. The default value is ``false``.
        :param pulumi.Input['TaskDefinitionEphemeralStorageArgs'] ephemeral_storage: The ephemeral storage settings to use for tasks run with the task definition.
        :param pulumi.Input[builtins.str] execution_role_arn: The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent permission to make AWS API calls on your behalf. For informationabout the required IAM roles for Amazon ECS, see [IAM roles for Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/security-ecs-iam-role-overview.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param pulumi.Input[builtins.str] family: The name of a family that this task definition is registered to. Up to 255 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed.
                A family groups multiple versions of a task definition. Amazon ECS gives the first task definition that you registered to a family a revision number of 1. Amazon ECS gives sequential revision numbers to each task definition that you add.
                 To use revision numbers when you update a task definition, specify this property. If you don't specify a value, CFNlong generates a new task definition each time that you update it.
        :param pulumi.Input[Sequence[pulumi.Input['TaskDefinitionInferenceAcceleratorArgs']]] inference_accelerators: The Elastic Inference accelerators to use for the containers in the task.
        :param pulumi.Input[builtins.str] ipc_mode: The IPC resource namespace to use for the containers in the task. The valid values are ``host``, ``task``, or ``none``. If ``host`` is specified, then all containers within the tasks that specified the ``host`` IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance. If ``task`` is specified, all containers within the specified task share the same IPC resources. If ``none`` is specified, then IPC resources within the containers of a task are private and not shared with other containers in a task or on the container instance. If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance.
                If the ``host`` IPC mode is used, be aware that there is a heightened risk of undesired IPC namespace expose.
                If you are setting namespaced kernel parameters using ``systemControls`` for the containers in the task, the following will apply to your IPC resource namespace. For more information, see [System Controls](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html) in the *Amazon Elastic Container Service Developer Guide*.
                 +  For tasks that use the ``host`` IPC mode, IPC namespace related ``systemControls`` are not supported.
                 +  For tasks that use the ``task`` IPC mode, IPC namespace related ``systemControls`` will apply to all containers within a task.
                 
                 This parameter is not supported for Windows containers or tasks run on FARGATElong.
        :param pulumi.Input[builtins.str] memory: The amount (in MiB) of memory used by the task.
                If your tasks runs on Amazon EC2 instances, you must specify either a task-level memory value or a container-level memory value. This field is optional and any value can be used. If a task-level memory value is specified, the container-level memory value is optional. For more information regarding container-level memory and memory reservation, see [ContainerDefinition](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html).
                If your tasks runs on FARGATElong, this field is required. You must use one of the following values. The value you choose determines your range of valid values for the ``cpu`` parameter.
                 +  512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available ``cpu`` values: 256 (.25 vCPU)
                 +  1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available ``cpu`` values: 512 (.5 vCPU)
                 +  2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available ``cpu`` values: 1024 (1 vCPU)
                 +  Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available ``cpu`` values: 2048 (2 vCPU)
                 +  Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available ``cpu`` values: 4096 (4 vCPU)
                 +  Between 16 GB and 60 GB in 4 GB increments - Available ``cpu`` values: 8192 (8 vCPU)
                This option requires Linux platform ``1.4.0`` or later.
                 +  Between 32GB and 120 GB in 8 GB increments - Available ``cpu`` values: 16384 (16 vCPU)
                This option requires Linux platform ``1.4.0`` or later.
        :param pulumi.Input[builtins.str] network_mode: The Docker networking mode to use for the containers in the task. The valid values are ``none``, ``bridge``, ``awsvpc``, and ``host``. If no network mode is specified, the default is ``bridge``.
                For Amazon ECS tasks on Fargate, the ``awsvpc`` network mode is required. For Amazon ECS tasks on Amazon EC2 Linux instances, any network mode can be used. For Amazon ECS tasks on Amazon EC2 Windows instances, ``<default>`` or ``awsvpc`` can be used. If the network mode is set to ``none``, you cannot specify port mappings in your container definitions, and the tasks containers do not have external connectivity. The ``host`` and ``awsvpc`` network modes offer the highest networking performance for containers because they use the EC2 network stack instead of the virtualized network stack provided by the ``bridge`` mode.
                With the ``host`` and ``awsvpc`` network modes, exposed container ports are mapped directly to the corresponding host port (for the ``host`` network mode) or the attached elastic network interface port (for the ``awsvpc`` network mode), so you cannot take advantage of dynamic host port mappings. 
                 When using the ``host`` network mode, you should not run containers using the root user (UID 0). It is considered best practice to use a non-root user.
                 If the network mode is ``awsvpc``, the task is allocated an elastic network interface, and you must specify a [NetworkConfiguration](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_NetworkConfiguration.html) value when you create a service or run a task with the task definition. For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html) in the *Amazon Elastic Container Service Developer Guide*.
                If the network mode is ``host``, you cannot run multiple instantiations of the same task on a single container instance when port mappings are used.
        :param pulumi.Input[builtins.str] pid_mode: The process namespace to use for the containers in the task. The valid values are ``host`` or ``task``. On Fargate for Linux containers, the only valid value is ``task``. For example, monitoring sidecars might need ``pidMode`` to access information about other containers running in the same task.
                If ``host`` is specified, all containers within the tasks that specified the ``host`` PID mode on the same container instance share the same process namespace with the host Amazon EC2 instance.
                If ``task`` is specified, all containers within the specified task share the same process namespace.
                If no value is specified, the default is a private namespace for each container.
                If the ``host`` PID mode is used, there's a heightened risk of undesired process namespace exposure.
                 This parameter is not supported for Windows containers.
                  This parameter is only supported for tasks that are hosted on FARGATElong if the tasks are using platform version ``1.4.0`` or later (Linux). This isn't supported for Windows containers on Fargate.
        :param pulumi.Input[Sequence[pulumi.Input['TaskDefinitionPlacementConstraintArgs']]] placement_constraints: An array of placement constraint objects to use for tasks.
                 This parameter isn't supported for tasks run on FARGATElong.
        :param pulumi.Input['TaskDefinitionProxyConfigurationArgs'] proxy_configuration: The configuration details for the App Mesh proxy.
                Your Amazon ECS container instances require at least version 1.26.0 of the container agent and at least version 1.26.0-1 of the ``ecs-init`` package to use a proxy configuration. If your container instances are launched from the Amazon ECS optimized AMI version ``20190301`` or later, they contain the required versions of the container agent and ``ecs-init``. For more information, see [Amazon ECS-optimized Linux AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] requires_compatibilities: The task launch types the task definition was validated against. The valid values are ``EC2``, ``FARGATE``, and ``EXTERNAL``. For more information, see [Amazon ECS launch types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param pulumi.Input['TaskDefinitionRuntimePlatformArgs'] runtime_platform: The operating system that your tasks definitions run on. A platform family is specified only for tasks using the Fargate launch type.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The metadata that you apply to the task definition to help you categorize and organize them. Each tag consists of a key and an optional value. You define both of them.
                The following basic restrictions apply to tags:
                 +  Maximum number of tags per resource - 50
                 +  For each resource, each tag key must be unique, and each tag key can have only one value.
                 +  Maximum key length - 128 Unicode characters in UTF-8
                 +  Maximum value length - 256 Unicode characters in UTF-8
                 +  If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
                 +  Tag keys and values are case-sensitive.
                 +  Do not use ``aws:``, ``AWS:``, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
        :param pulumi.Input[builtins.str] task_role_arn: The short name or full Amazon Resource Name (ARN) of the IAMlong role that grants containers in the task permission to call AWS APIs on your behalf. For more information, see [Amazon ECS Task Role](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html) in the *Amazon Elastic Container Service Developer Guide*.
                IAM roles for tasks on Windows require that the ``-EnableTaskIAMRole`` option is set when you launch the Amazon ECS-optimized Windows AMI. Your containers must also run some configuration code to use the feature. For more information, see [Windows IAM roles for tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows_task_IAM_roles.html) in the *Amazon Elastic Container Service Developer Guide*.
                 String validation is done on the ECS side. If an invalid string value is given for ``TaskRoleArn``, it may cause the Cloudformation job to hang.
        :param pulumi.Input[Sequence[pulumi.Input['TaskDefinitionVolumeArgs']]] volumes: The list of data volume definitions for the task. For more information, see [Using data volumes in tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html) in the *Amazon Elastic Container Service Developer Guide*.
                 The ``host`` and ``sourcePath`` parameters aren't supported for tasks run on FARGATElong.
        """
        if container_definitions is not None:
            pulumi.set(__self__, "container_definitions", container_definitions)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if enable_fault_injection is not None:
            pulumi.set(__self__, "enable_fault_injection", enable_fault_injection)
        if ephemeral_storage is not None:
            pulumi.set(__self__, "ephemeral_storage", ephemeral_storage)
        if execution_role_arn is not None:
            pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if inference_accelerators is not None:
            pulumi.set(__self__, "inference_accelerators", inference_accelerators)
        if ipc_mode is not None:
            pulumi.set(__self__, "ipc_mode", ipc_mode)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if network_mode is not None:
            pulumi.set(__self__, "network_mode", network_mode)
        if pid_mode is not None:
            pulumi.set(__self__, "pid_mode", pid_mode)
        if placement_constraints is not None:
            pulumi.set(__self__, "placement_constraints", placement_constraints)
        if proxy_configuration is not None:
            pulumi.set(__self__, "proxy_configuration", proxy_configuration)
        if requires_compatibilities is not None:
            pulumi.set(__self__, "requires_compatibilities", requires_compatibilities)
        if runtime_platform is not None:
            pulumi.set(__self__, "runtime_platform", runtime_platform)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if task_role_arn is not None:
            pulumi.set(__self__, "task_role_arn", task_role_arn)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter(name="containerDefinitions")
    def container_definitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionContainerDefinitionArgs']]]]:
        """
        A list of container definitions in JSON format that describe the different containers that make up your task. For more information about container definition parameters and defaults, see [Amazon ECS Task Definitions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html) in the *Amazon Elastic Container Service Developer Guide*.
        """
        return pulumi.get(self, "container_definitions")

    @container_definitions.setter
    def container_definitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionContainerDefinitionArgs']]]]):
        pulumi.set(self, "container_definitions", value)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The number of ``cpu`` units used by the task. If you use the EC2 launch type, this field is optional. Any value can be used. If you use the Fargate launch type, this field is required. You must use one of the following values. The value that you choose determines your range of valid values for the ``memory`` parameter.
         If you're using the EC2 launch type or the external launch type, this field is optional. Supported values are between ``128`` CPU units (``0.125`` vCPUs) and ``196608`` CPU units (``192`` vCPUs). 
         This field is required for Fargate. For information about the valid values, see [Task size](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#task_size) in the *Amazon Elastic Container Service Developer Guide*.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="enableFaultInjection")
    def enable_fault_injection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables fault injection and allows for fault injection requests to be accepted from the task's containers. The default value is ``false``.
        """
        return pulumi.get(self, "enable_fault_injection")

    @enable_fault_injection.setter
    def enable_fault_injection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_fault_injection", value)

    @property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> Optional[pulumi.Input['TaskDefinitionEphemeralStorageArgs']]:
        """
        The ephemeral storage settings to use for tasks run with the task definition.
        """
        return pulumi.get(self, "ephemeral_storage")

    @ephemeral_storage.setter
    def ephemeral_storage(self, value: Optional[pulumi.Input['TaskDefinitionEphemeralStorageArgs']]):
        pulumi.set(self, "ephemeral_storage", value)

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent permission to make AWS API calls on your behalf. For informationabout the required IAM roles for Amazon ECS, see [IAM roles for Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/security-ecs-iam-role-overview.html) in the *Amazon Elastic Container Service Developer Guide*.
        """
        return pulumi.get(self, "execution_role_arn")

    @execution_role_arn.setter
    def execution_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "execution_role_arn", value)

    @property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of a family that this task definition is registered to. Up to 255 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed.
         A family groups multiple versions of a task definition. Amazon ECS gives the first task definition that you registered to a family a revision number of 1. Amazon ECS gives sequential revision numbers to each task definition that you add.
          To use revision numbers when you update a task definition, specify this property. If you don't specify a value, CFNlong generates a new task definition each time that you update it.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter(name="inferenceAccelerators")
    def inference_accelerators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionInferenceAcceleratorArgs']]]]:
        """
        The Elastic Inference accelerators to use for the containers in the task.
        """
        return pulumi.get(self, "inference_accelerators")

    @inference_accelerators.setter
    def inference_accelerators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionInferenceAcceleratorArgs']]]]):
        pulumi.set(self, "inference_accelerators", value)

    @property
    @pulumi.getter(name="ipcMode")
    def ipc_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IPC resource namespace to use for the containers in the task. The valid values are ``host``, ``task``, or ``none``. If ``host`` is specified, then all containers within the tasks that specified the ``host`` IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance. If ``task`` is specified, all containers within the specified task share the same IPC resources. If ``none`` is specified, then IPC resources within the containers of a task are private and not shared with other containers in a task or on the container instance. If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance.
         If the ``host`` IPC mode is used, be aware that there is a heightened risk of undesired IPC namespace expose.
         If you are setting namespaced kernel parameters using ``systemControls`` for the containers in the task, the following will apply to your IPC resource namespace. For more information, see [System Controls](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html) in the *Amazon Elastic Container Service Developer Guide*.
          +  For tasks that use the ``host`` IPC mode, IPC namespace related ``systemControls`` are not supported.
          +  For tasks that use the ``task`` IPC mode, IPC namespace related ``systemControls`` will apply to all containers within a task.
          
          This parameter is not supported for Windows containers or tasks run on FARGATElong.
        """
        return pulumi.get(self, "ipc_mode")

    @ipc_mode.setter
    def ipc_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipc_mode", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The amount (in MiB) of memory used by the task.
         If your tasks runs on Amazon EC2 instances, you must specify either a task-level memory value or a container-level memory value. This field is optional and any value can be used. If a task-level memory value is specified, the container-level memory value is optional. For more information regarding container-level memory and memory reservation, see [ContainerDefinition](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html).
         If your tasks runs on FARGATElong, this field is required. You must use one of the following values. The value you choose determines your range of valid values for the ``cpu`` parameter.
          +  512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available ``cpu`` values: 256 (.25 vCPU)
          +  1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available ``cpu`` values: 512 (.5 vCPU)
          +  2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available ``cpu`` values: 1024 (1 vCPU)
          +  Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available ``cpu`` values: 2048 (2 vCPU)
          +  Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available ``cpu`` values: 4096 (4 vCPU)
          +  Between 16 GB and 60 GB in 4 GB increments - Available ``cpu`` values: 8192 (8 vCPU)
         This option requires Linux platform ``1.4.0`` or later.
          +  Between 32GB and 120 GB in 8 GB increments - Available ``cpu`` values: 16384 (16 vCPU)
         This option requires Linux platform ``1.4.0`` or later.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "memory", value)

    @property
    @pulumi.getter(name="networkMode")
    def network_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Docker networking mode to use for the containers in the task. The valid values are ``none``, ``bridge``, ``awsvpc``, and ``host``. If no network mode is specified, the default is ``bridge``.
         For Amazon ECS tasks on Fargate, the ``awsvpc`` network mode is required. For Amazon ECS tasks on Amazon EC2 Linux instances, any network mode can be used. For Amazon ECS tasks on Amazon EC2 Windows instances, ``<default>`` or ``awsvpc`` can be used. If the network mode is set to ``none``, you cannot specify port mappings in your container definitions, and the tasks containers do not have external connectivity. The ``host`` and ``awsvpc`` network modes offer the highest networking performance for containers because they use the EC2 network stack instead of the virtualized network stack provided by the ``bridge`` mode.
         With the ``host`` and ``awsvpc`` network modes, exposed container ports are mapped directly to the corresponding host port (for the ``host`` network mode) or the attached elastic network interface port (for the ``awsvpc`` network mode), so you cannot take advantage of dynamic host port mappings. 
          When using the ``host`` network mode, you should not run containers using the root user (UID 0). It is considered best practice to use a non-root user.
          If the network mode is ``awsvpc``, the task is allocated an elastic network interface, and you must specify a [NetworkConfiguration](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_NetworkConfiguration.html) value when you create a service or run a task with the task definition. For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html) in the *Amazon Elastic Container Service Developer Guide*.
         If the network mode is ``host``, you cannot run multiple instantiations of the same task on a single container instance when port mappings are used.
        """
        return pulumi.get(self, "network_mode")

    @network_mode.setter
    def network_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_mode", value)

    @property
    @pulumi.getter(name="pidMode")
    def pid_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The process namespace to use for the containers in the task. The valid values are ``host`` or ``task``. On Fargate for Linux containers, the only valid value is ``task``. For example, monitoring sidecars might need ``pidMode`` to access information about other containers running in the same task.
         If ``host`` is specified, all containers within the tasks that specified the ``host`` PID mode on the same container instance share the same process namespace with the host Amazon EC2 instance.
         If ``task`` is specified, all containers within the specified task share the same process namespace.
         If no value is specified, the default is a private namespace for each container.
         If the ``host`` PID mode is used, there's a heightened risk of undesired process namespace exposure.
          This parameter is not supported for Windows containers.
           This parameter is only supported for tasks that are hosted on FARGATElong if the tasks are using platform version ``1.4.0`` or later (Linux). This isn't supported for Windows containers on Fargate.
        """
        return pulumi.get(self, "pid_mode")

    @pid_mode.setter
    def pid_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pid_mode", value)

    @property
    @pulumi.getter(name="placementConstraints")
    def placement_constraints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionPlacementConstraintArgs']]]]:
        """
        An array of placement constraint objects to use for tasks.
          This parameter isn't supported for tasks run on FARGATElong.
        """
        return pulumi.get(self, "placement_constraints")

    @placement_constraints.setter
    def placement_constraints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionPlacementConstraintArgs']]]]):
        pulumi.set(self, "placement_constraints", value)

    @property
    @pulumi.getter(name="proxyConfiguration")
    def proxy_configuration(self) -> Optional[pulumi.Input['TaskDefinitionProxyConfigurationArgs']]:
        """
        The configuration details for the App Mesh proxy.
         Your Amazon ECS container instances require at least version 1.26.0 of the container agent and at least version 1.26.0-1 of the ``ecs-init`` package to use a proxy configuration. If your container instances are launched from the Amazon ECS optimized AMI version ``20190301`` or later, they contain the required versions of the container agent and ``ecs-init``. For more information, see [Amazon ECS-optimized Linux AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html) in the *Amazon Elastic Container Service Developer Guide*.
        """
        return pulumi.get(self, "proxy_configuration")

    @proxy_configuration.setter
    def proxy_configuration(self, value: Optional[pulumi.Input['TaskDefinitionProxyConfigurationArgs']]):
        pulumi.set(self, "proxy_configuration", value)

    @property
    @pulumi.getter(name="requiresCompatibilities")
    def requires_compatibilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The task launch types the task definition was validated against. The valid values are ``EC2``, ``FARGATE``, and ``EXTERNAL``. For more information, see [Amazon ECS launch types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html) in the *Amazon Elastic Container Service Developer Guide*.
        """
        return pulumi.get(self, "requires_compatibilities")

    @requires_compatibilities.setter
    def requires_compatibilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "requires_compatibilities", value)

    @property
    @pulumi.getter(name="runtimePlatform")
    def runtime_platform(self) -> Optional[pulumi.Input['TaskDefinitionRuntimePlatformArgs']]:
        """
        The operating system that your tasks definitions run on. A platform family is specified only for tasks using the Fargate launch type.
        """
        return pulumi.get(self, "runtime_platform")

    @runtime_platform.setter
    def runtime_platform(self, value: Optional[pulumi.Input['TaskDefinitionRuntimePlatformArgs']]):
        pulumi.set(self, "runtime_platform", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The metadata that you apply to the task definition to help you categorize and organize them. Each tag consists of a key and an optional value. You define both of them.
         The following basic restrictions apply to tags:
          +  Maximum number of tags per resource - 50
          +  For each resource, each tag key must be unique, and each tag key can have only one value.
          +  Maximum key length - 128 Unicode characters in UTF-8
          +  Maximum value length - 256 Unicode characters in UTF-8
          +  If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
          +  Tag keys and values are case-sensitive.
          +  Do not use ``aws:``, ``AWS:``, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="taskRoleArn")
    def task_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The short name or full Amazon Resource Name (ARN) of the IAMlong role that grants containers in the task permission to call AWS APIs on your behalf. For more information, see [Amazon ECS Task Role](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html) in the *Amazon Elastic Container Service Developer Guide*.
         IAM roles for tasks on Windows require that the ``-EnableTaskIAMRole`` option is set when you launch the Amazon ECS-optimized Windows AMI. Your containers must also run some configuration code to use the feature. For more information, see [Windows IAM roles for tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows_task_IAM_roles.html) in the *Amazon Elastic Container Service Developer Guide*.
          String validation is done on the ECS side. If an invalid string value is given for ``TaskRoleArn``, it may cause the Cloudformation job to hang.
        """
        return pulumi.get(self, "task_role_arn")

    @task_role_arn.setter
    def task_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "task_role_arn", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionVolumeArgs']]]]:
        """
        The list of data volume definitions for the task. For more information, see [Using data volumes in tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html) in the *Amazon Elastic Container Service Developer Guide*.
          The ``host`` and ``sourcePath`` parameters aren't supported for tasks run on FARGATElong.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskDefinitionVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


@pulumi.type_token("aws-native:ecs:TaskDefinition")
class TaskDefinition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container_definitions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TaskDefinitionContainerDefinitionArgs', 'TaskDefinitionContainerDefinitionArgsDict']]]]] = None,
                 cpu: Optional[pulumi.Input[builtins.str]] = None,
                 enable_fault_injection: Optional[pulumi.Input[builtins.bool]] = None,
                 ephemeral_storage: Optional[pulumi.Input[Union['TaskDefinitionEphemeralStorageArgs', 'TaskDefinitionEphemeralStorageArgsDict']]] = None,
                 execution_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 family: Optional[pulumi.Input[builtins.str]] = None,
                 inference_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TaskDefinitionInferenceAcceleratorArgs', 'TaskDefinitionInferenceAcceleratorArgsDict']]]]] = None,
                 ipc_mode: Optional[pulumi.Input[builtins.str]] = None,
                 memory: Optional[pulumi.Input[builtins.str]] = None,
                 network_mode: Optional[pulumi.Input[builtins.str]] = None,
                 pid_mode: Optional[pulumi.Input[builtins.str]] = None,
                 placement_constraints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TaskDefinitionPlacementConstraintArgs', 'TaskDefinitionPlacementConstraintArgsDict']]]]] = None,
                 proxy_configuration: Optional[pulumi.Input[Union['TaskDefinitionProxyConfigurationArgs', 'TaskDefinitionProxyConfigurationArgsDict']]] = None,
                 requires_compatibilities: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 runtime_platform: Optional[pulumi.Input[Union['TaskDefinitionRuntimePlatformArgs', 'TaskDefinitionRuntimePlatformArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 task_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TaskDefinitionVolumeArgs', 'TaskDefinitionVolumeArgsDict']]]]] = None,
                 __props__=None):
        """
        Registers a new task definition from the supplied ``family`` and ``containerDefinitions``. Optionally, you can add data volumes to your containers with the ``volumes`` parameter. For more information about task definition parameters and defaults, see [Amazon ECS Task Definitions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html) in the *Amazon Elastic Container Service Developer Guide*.
         You can specify a role for your task with the ``taskRoleArn`` parameter. When you specify a role for a task, its containers can then use the latest versions of the CLI or SDKs to make API requests to the AWS services that are specified in the policy that's associated with the role. For more information, see [IAM Roles for Tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html) in the *Amazon Elastic Container Service Developer Guide*.
         You can specify a Docker networking mode for the containers in your task definition with the ``networkMode`` parameter. If you specify the ``awsvpc`` network mode, the task is allocated an elastic network interface, and you must specify a [NetworkConfiguration](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_NetworkConfiguration.html) when you create a service or run a task with the task definition. For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html) in the *Amazon Elastic Container Service Developer Guide*.
          In the following example or examples, the Authorization header contents (``AUTHPARAMS``) must be replaced with an AWS Signature Version 4 signature. For more information, see [Signature Version 4 Signing Process](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html) in the *General Reference*.
         You only need to learn how to sign HTTP requests if you intend to create them manually. When you use the [](https://docs.aws.amazon.com/cli/) or one of the [SDKs](https://docs.aws.amazon.com/tools/) to make requests to AWS, these tools automatically sign the requests for you, with the access key that you specify when you configure the tools. When you use these tools, you don't have to sign requests yourself.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        taskdefinition = aws_native.ecs.TaskDefinition("taskdefinition",
            requires_compatibilities=["EC2"],
            container_definitions=[
                {
                    "name": "my-app",
                    "mount_points": [{
                        "source_volume": "my-vol",
                        "container_path": "/var/www/my-vol",
                    }],
                    "image": "amazon/amazon-ecs-sample",
                    "cpu": 256,
                    "entry_point": [
                        "/usr/sbin/apache2",
                        "-D",
                        "FOREGROUND",
                    ],
                    "memory": 512,
                    "essential": True,
                },
                {
                    "name": "busybox",
                    "image": "busybox",
                    "cpu": 256,
                    "entry_point": [
                        "sh",
                        "-c",
                    ],
                    "memory": 512,
                    "command": ["/bin/sh -c \\"while true; do /bin/date > /var/www/my-vol/date; sleep 1; done\\""],
                    "essential": False,
                    "depends_on": [{
                        "container_name": "my-app",
                        "condition": "START",
                    }],
                    "volumes_from": [{
                        "source_container": "my-app",
                    }],
                },
            ],
            volumes=[{
                "host": {
                    "source_path": "/var/lib/docker/vfs/dir/",
                },
                "name": "my-vol",
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        taskdefinition = aws_native.ecs.TaskDefinition("taskdefinition",
            requires_compatibilities=["EC2"],
            container_definitions=[
                {
                    "name": "my-app",
                    "mount_points": [{
                        "source_volume": "my-vol",
                        "container_path": "/var/www/my-vol",
                    }],
                    "image": "amazon/amazon-ecs-sample",
                    "cpu": 256,
                    "entry_point": [
                        "/usr/sbin/apache2",
                        "-D",
                        "FOREGROUND",
                    ],
                    "memory": 512,
                    "essential": True,
                },
                {
                    "name": "busybox",
                    "image": "busybox",
                    "cpu": 256,
                    "entry_point": [
                        "sh",
                        "-c",
                    ],
                    "memory": 512,
                    "command": ["/bin/sh -c \\"while true; do /bin/date > /var/www/my-vol/date; sleep 1; done\\""],
                    "essential": False,
                    "depends_on": [{
                        "container_name": "my-app",
                        "condition": "START",
                    }],
                    "volumes_from": [{
                        "source_container": "my-app",
                    }],
                },
            ],
            volumes=[{
                "host": {
                    "source_path": "/var/lib/docker/vfs/dir/",
                },
                "name": "my-vol",
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        ecs_task_definition_resource = aws_native.ecs.TaskDefinition("ecsTaskDefinitionResource",
            container_definitions=[{
                "name": "first-run-task",
                "image": "httpd:2.4",
                "essential": True,
                "port_mappings": [{
                    "container_port": 80,
                    "protocol": "tcp",
                }],
                "environment": [
                    {
                        "name": "entryPoint",
                        "value": "sh, -c",
                    },
                    {
                        "name": "command",
                        "value": "/bin/sh -c \\\\\\"echo '<html> <head> <title>Amazon ECS Sample App</title> <style>body {margin-top: 40px; background-color: #333;} </style> </head><body> <div style=color:white;text-align:center> <h1>Amazon ECS Sample App</h1> <h2>Congratulations!</h2> <p>Your application is now running on a container in Amazon ECS.</p> </div></body></html>' >  /usr/local/apache2/htdocs/index.html && httpd-foreground\\\\\\"",
                    },
                ],
                "environment_files": [],
            }],
            family="first-run-task",
            cpu="1 vCPU",
            memory="3 GB")
        pulumi.export("ecsTaskDefinition", ecs_task_definition_resource.id)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        ecs_task_definition_resource = aws_native.ecs.TaskDefinition("ecsTaskDefinitionResource",
            container_definitions=[{
                "name": "first-run-task",
                "image": "httpd:2.4",
                "essential": True,
                "port_mappings": [{
                    "container_port": 80,
                    "protocol": "tcp",
                }],
                "environment": [
                    {
                        "name": "entryPoint",
                        "value": "sh, -c",
                    },
                    {
                        "name": "command",
                        "value": "/bin/sh -c \\\\\\"echo '<html> <head> <title>Amazon ECS Sample App</title> <style>body {margin-top: 40px; background-color: #333;} </style> </head><body> <div style=color:white;text-align:center> <h1>Amazon ECS Sample App</h1> <h2>Congratulations!</h2> <p>Your application is now running on a container in Amazon ECS.</p> </div></body></html>' >  /usr/local/apache2/htdocs/index.html && httpd-foreground\\\\\\"",
                    },
                ],
                "environment_files": [],
            }],
            family="first-run-task",
            cpu="1 vCPU",
            memory="3 GB")
        pulumi.export("ecsTaskDefinition", ecs_task_definition_resource.id)

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TaskDefinitionContainerDefinitionArgs', 'TaskDefinitionContainerDefinitionArgsDict']]]] container_definitions: A list of container definitions in JSON format that describe the different containers that make up your task. For more information about container definition parameters and defaults, see [Amazon ECS Task Definitions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param pulumi.Input[builtins.str] cpu: The number of ``cpu`` units used by the task. If you use the EC2 launch type, this field is optional. Any value can be used. If you use the Fargate launch type, this field is required. You must use one of the following values. The value that you choose determines your range of valid values for the ``memory`` parameter.
                If you're using the EC2 launch type or the external launch type, this field is optional. Supported values are between ``128`` CPU units (``0.125`` vCPUs) and ``196608`` CPU units (``192`` vCPUs). 
                This field is required for Fargate. For information about the valid values, see [Task size](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#task_size) in the *Amazon Elastic Container Service Developer Guide*.
        :param pulumi.Input[builtins.bool] enable_fault_injection: Enables fault injection and allows for fault injection requests to be accepted from the task's containers. The default value is ``false``.
        :param pulumi.Input[Union['TaskDefinitionEphemeralStorageArgs', 'TaskDefinitionEphemeralStorageArgsDict']] ephemeral_storage: The ephemeral storage settings to use for tasks run with the task definition.
        :param pulumi.Input[builtins.str] execution_role_arn: The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent permission to make AWS API calls on your behalf. For informationabout the required IAM roles for Amazon ECS, see [IAM roles for Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/security-ecs-iam-role-overview.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param pulumi.Input[builtins.str] family: The name of a family that this task definition is registered to. Up to 255 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed.
                A family groups multiple versions of a task definition. Amazon ECS gives the first task definition that you registered to a family a revision number of 1. Amazon ECS gives sequential revision numbers to each task definition that you add.
                 To use revision numbers when you update a task definition, specify this property. If you don't specify a value, CFNlong generates a new task definition each time that you update it.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TaskDefinitionInferenceAcceleratorArgs', 'TaskDefinitionInferenceAcceleratorArgsDict']]]] inference_accelerators: The Elastic Inference accelerators to use for the containers in the task.
        :param pulumi.Input[builtins.str] ipc_mode: The IPC resource namespace to use for the containers in the task. The valid values are ``host``, ``task``, or ``none``. If ``host`` is specified, then all containers within the tasks that specified the ``host`` IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance. If ``task`` is specified, all containers within the specified task share the same IPC resources. If ``none`` is specified, then IPC resources within the containers of a task are private and not shared with other containers in a task or on the container instance. If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance.
                If the ``host`` IPC mode is used, be aware that there is a heightened risk of undesired IPC namespace expose.
                If you are setting namespaced kernel parameters using ``systemControls`` for the containers in the task, the following will apply to your IPC resource namespace. For more information, see [System Controls](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html) in the *Amazon Elastic Container Service Developer Guide*.
                 +  For tasks that use the ``host`` IPC mode, IPC namespace related ``systemControls`` are not supported.
                 +  For tasks that use the ``task`` IPC mode, IPC namespace related ``systemControls`` will apply to all containers within a task.
                 
                 This parameter is not supported for Windows containers or tasks run on FARGATElong.
        :param pulumi.Input[builtins.str] memory: The amount (in MiB) of memory used by the task.
                If your tasks runs on Amazon EC2 instances, you must specify either a task-level memory value or a container-level memory value. This field is optional and any value can be used. If a task-level memory value is specified, the container-level memory value is optional. For more information regarding container-level memory and memory reservation, see [ContainerDefinition](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html).
                If your tasks runs on FARGATElong, this field is required. You must use one of the following values. The value you choose determines your range of valid values for the ``cpu`` parameter.
                 +  512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available ``cpu`` values: 256 (.25 vCPU)
                 +  1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available ``cpu`` values: 512 (.5 vCPU)
                 +  2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available ``cpu`` values: 1024 (1 vCPU)
                 +  Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available ``cpu`` values: 2048 (2 vCPU)
                 +  Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available ``cpu`` values: 4096 (4 vCPU)
                 +  Between 16 GB and 60 GB in 4 GB increments - Available ``cpu`` values: 8192 (8 vCPU)
                This option requires Linux platform ``1.4.0`` or later.
                 +  Between 32GB and 120 GB in 8 GB increments - Available ``cpu`` values: 16384 (16 vCPU)
                This option requires Linux platform ``1.4.0`` or later.
        :param pulumi.Input[builtins.str] network_mode: The Docker networking mode to use for the containers in the task. The valid values are ``none``, ``bridge``, ``awsvpc``, and ``host``. If no network mode is specified, the default is ``bridge``.
                For Amazon ECS tasks on Fargate, the ``awsvpc`` network mode is required. For Amazon ECS tasks on Amazon EC2 Linux instances, any network mode can be used. For Amazon ECS tasks on Amazon EC2 Windows instances, ``<default>`` or ``awsvpc`` can be used. If the network mode is set to ``none``, you cannot specify port mappings in your container definitions, and the tasks containers do not have external connectivity. The ``host`` and ``awsvpc`` network modes offer the highest networking performance for containers because they use the EC2 network stack instead of the virtualized network stack provided by the ``bridge`` mode.
                With the ``host`` and ``awsvpc`` network modes, exposed container ports are mapped directly to the corresponding host port (for the ``host`` network mode) or the attached elastic network interface port (for the ``awsvpc`` network mode), so you cannot take advantage of dynamic host port mappings. 
                 When using the ``host`` network mode, you should not run containers using the root user (UID 0). It is considered best practice to use a non-root user.
                 If the network mode is ``awsvpc``, the task is allocated an elastic network interface, and you must specify a [NetworkConfiguration](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_NetworkConfiguration.html) value when you create a service or run a task with the task definition. For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html) in the *Amazon Elastic Container Service Developer Guide*.
                If the network mode is ``host``, you cannot run multiple instantiations of the same task on a single container instance when port mappings are used.
        :param pulumi.Input[builtins.str] pid_mode: The process namespace to use for the containers in the task. The valid values are ``host`` or ``task``. On Fargate for Linux containers, the only valid value is ``task``. For example, monitoring sidecars might need ``pidMode`` to access information about other containers running in the same task.
                If ``host`` is specified, all containers within the tasks that specified the ``host`` PID mode on the same container instance share the same process namespace with the host Amazon EC2 instance.
                If ``task`` is specified, all containers within the specified task share the same process namespace.
                If no value is specified, the default is a private namespace for each container.
                If the ``host`` PID mode is used, there's a heightened risk of undesired process namespace exposure.
                 This parameter is not supported for Windows containers.
                  This parameter is only supported for tasks that are hosted on FARGATElong if the tasks are using platform version ``1.4.0`` or later (Linux). This isn't supported for Windows containers on Fargate.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TaskDefinitionPlacementConstraintArgs', 'TaskDefinitionPlacementConstraintArgsDict']]]] placement_constraints: An array of placement constraint objects to use for tasks.
                 This parameter isn't supported for tasks run on FARGATElong.
        :param pulumi.Input[Union['TaskDefinitionProxyConfigurationArgs', 'TaskDefinitionProxyConfigurationArgsDict']] proxy_configuration: The configuration details for the App Mesh proxy.
                Your Amazon ECS container instances require at least version 1.26.0 of the container agent and at least version 1.26.0-1 of the ``ecs-init`` package to use a proxy configuration. If your container instances are launched from the Amazon ECS optimized AMI version ``20190301`` or later, they contain the required versions of the container agent and ``ecs-init``. For more information, see [Amazon ECS-optimized Linux AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] requires_compatibilities: The task launch types the task definition was validated against. The valid values are ``EC2``, ``FARGATE``, and ``EXTERNAL``. For more information, see [Amazon ECS launch types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param pulumi.Input[Union['TaskDefinitionRuntimePlatformArgs', 'TaskDefinitionRuntimePlatformArgsDict']] runtime_platform: The operating system that your tasks definitions run on. A platform family is specified only for tasks using the Fargate launch type.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The metadata that you apply to the task definition to help you categorize and organize them. Each tag consists of a key and an optional value. You define both of them.
                The following basic restrictions apply to tags:
                 +  Maximum number of tags per resource - 50
                 +  For each resource, each tag key must be unique, and each tag key can have only one value.
                 +  Maximum key length - 128 Unicode characters in UTF-8
                 +  Maximum value length - 256 Unicode characters in UTF-8
                 +  If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
                 +  Tag keys and values are case-sensitive.
                 +  Do not use ``aws:``, ``AWS:``, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
        :param pulumi.Input[builtins.str] task_role_arn: The short name or full Amazon Resource Name (ARN) of the IAMlong role that grants containers in the task permission to call AWS APIs on your behalf. For more information, see [Amazon ECS Task Role](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html) in the *Amazon Elastic Container Service Developer Guide*.
                IAM roles for tasks on Windows require that the ``-EnableTaskIAMRole`` option is set when you launch the Amazon ECS-optimized Windows AMI. Your containers must also run some configuration code to use the feature. For more information, see [Windows IAM roles for tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows_task_IAM_roles.html) in the *Amazon Elastic Container Service Developer Guide*.
                 String validation is done on the ECS side. If an invalid string value is given for ``TaskRoleArn``, it may cause the Cloudformation job to hang.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TaskDefinitionVolumeArgs', 'TaskDefinitionVolumeArgsDict']]]] volumes: The list of data volume definitions for the task. For more information, see [Using data volumes in tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html) in the *Amazon Elastic Container Service Developer Guide*.
                 The ``host`` and ``sourcePath`` parameters aren't supported for tasks run on FARGATElong.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[TaskDefinitionArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Registers a new task definition from the supplied ``family`` and ``containerDefinitions``. Optionally, you can add data volumes to your containers with the ``volumes`` parameter. For more information about task definition parameters and defaults, see [Amazon ECS Task Definitions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html) in the *Amazon Elastic Container Service Developer Guide*.
         You can specify a role for your task with the ``taskRoleArn`` parameter. When you specify a role for a task, its containers can then use the latest versions of the CLI or SDKs to make API requests to the AWS services that are specified in the policy that's associated with the role. For more information, see [IAM Roles for Tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html) in the *Amazon Elastic Container Service Developer Guide*.
         You can specify a Docker networking mode for the containers in your task definition with the ``networkMode`` parameter. If you specify the ``awsvpc`` network mode, the task is allocated an elastic network interface, and you must specify a [NetworkConfiguration](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_NetworkConfiguration.html) when you create a service or run a task with the task definition. For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html) in the *Amazon Elastic Container Service Developer Guide*.
          In the following example or examples, the Authorization header contents (``AUTHPARAMS``) must be replaced with an AWS Signature Version 4 signature. For more information, see [Signature Version 4 Signing Process](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html) in the *General Reference*.
         You only need to learn how to sign HTTP requests if you intend to create them manually. When you use the [](https://docs.aws.amazon.com/cli/) or one of the [SDKs](https://docs.aws.amazon.com/tools/) to make requests to AWS, these tools automatically sign the requests for you, with the access key that you specify when you configure the tools. When you use these tools, you don't have to sign requests yourself.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        taskdefinition = aws_native.ecs.TaskDefinition("taskdefinition",
            requires_compatibilities=["EC2"],
            container_definitions=[
                {
                    "name": "my-app",
                    "mount_points": [{
                        "source_volume": "my-vol",
                        "container_path": "/var/www/my-vol",
                    }],
                    "image": "amazon/amazon-ecs-sample",
                    "cpu": 256,
                    "entry_point": [
                        "/usr/sbin/apache2",
                        "-D",
                        "FOREGROUND",
                    ],
                    "memory": 512,
                    "essential": True,
                },
                {
                    "name": "busybox",
                    "image": "busybox",
                    "cpu": 256,
                    "entry_point": [
                        "sh",
                        "-c",
                    ],
                    "memory": 512,
                    "command": ["/bin/sh -c \\"while true; do /bin/date > /var/www/my-vol/date; sleep 1; done\\""],
                    "essential": False,
                    "depends_on": [{
                        "container_name": "my-app",
                        "condition": "START",
                    }],
                    "volumes_from": [{
                        "source_container": "my-app",
                    }],
                },
            ],
            volumes=[{
                "host": {
                    "source_path": "/var/lib/docker/vfs/dir/",
                },
                "name": "my-vol",
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        taskdefinition = aws_native.ecs.TaskDefinition("taskdefinition",
            requires_compatibilities=["EC2"],
            container_definitions=[
                {
                    "name": "my-app",
                    "mount_points": [{
                        "source_volume": "my-vol",
                        "container_path": "/var/www/my-vol",
                    }],
                    "image": "amazon/amazon-ecs-sample",
                    "cpu": 256,
                    "entry_point": [
                        "/usr/sbin/apache2",
                        "-D",
                        "FOREGROUND",
                    ],
                    "memory": 512,
                    "essential": True,
                },
                {
                    "name": "busybox",
                    "image": "busybox",
                    "cpu": 256,
                    "entry_point": [
                        "sh",
                        "-c",
                    ],
                    "memory": 512,
                    "command": ["/bin/sh -c \\"while true; do /bin/date > /var/www/my-vol/date; sleep 1; done\\""],
                    "essential": False,
                    "depends_on": [{
                        "container_name": "my-app",
                        "condition": "START",
                    }],
                    "volumes_from": [{
                        "source_container": "my-app",
                    }],
                },
            ],
            volumes=[{
                "host": {
                    "source_path": "/var/lib/docker/vfs/dir/",
                },
                "name": "my-vol",
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        ecs_task_definition_resource = aws_native.ecs.TaskDefinition("ecsTaskDefinitionResource",
            container_definitions=[{
                "name": "first-run-task",
                "image": "httpd:2.4",
                "essential": True,
                "port_mappings": [{
                    "container_port": 80,
                    "protocol": "tcp",
                }],
                "environment": [
                    {
                        "name": "entryPoint",
                        "value": "sh, -c",
                    },
                    {
                        "name": "command",
                        "value": "/bin/sh -c \\\\\\"echo '<html> <head> <title>Amazon ECS Sample App</title> <style>body {margin-top: 40px; background-color: #333;} </style> </head><body> <div style=color:white;text-align:center> <h1>Amazon ECS Sample App</h1> <h2>Congratulations!</h2> <p>Your application is now running on a container in Amazon ECS.</p> </div></body></html>' >  /usr/local/apache2/htdocs/index.html && httpd-foreground\\\\\\"",
                    },
                ],
                "environment_files": [],
            }],
            family="first-run-task",
            cpu="1 vCPU",
            memory="3 GB")
        pulumi.export("ecsTaskDefinition", ecs_task_definition_resource.id)

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        ecs_task_definition_resource = aws_native.ecs.TaskDefinition("ecsTaskDefinitionResource",
            container_definitions=[{
                "name": "first-run-task",
                "image": "httpd:2.4",
                "essential": True,
                "port_mappings": [{
                    "container_port": 80,
                    "protocol": "tcp",
                }],
                "environment": [
                    {
                        "name": "entryPoint",
                        "value": "sh, -c",
                    },
                    {
                        "name": "command",
                        "value": "/bin/sh -c \\\\\\"echo '<html> <head> <title>Amazon ECS Sample App</title> <style>body {margin-top: 40px; background-color: #333;} </style> </head><body> <div style=color:white;text-align:center> <h1>Amazon ECS Sample App</h1> <h2>Congratulations!</h2> <p>Your application is now running on a container in Amazon ECS.</p> </div></body></html>' >  /usr/local/apache2/htdocs/index.html && httpd-foreground\\\\\\"",
                    },
                ],
                "environment_files": [],
            }],
            family="first-run-task",
            cpu="1 vCPU",
            memory="3 GB")
        pulumi.export("ecsTaskDefinition", ecs_task_definition_resource.id)

        ```

        :param str resource_name: The name of the resource.
        :param TaskDefinitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TaskDefinitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container_definitions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TaskDefinitionContainerDefinitionArgs', 'TaskDefinitionContainerDefinitionArgsDict']]]]] = None,
                 cpu: Optional[pulumi.Input[builtins.str]] = None,
                 enable_fault_injection: Optional[pulumi.Input[builtins.bool]] = None,
                 ephemeral_storage: Optional[pulumi.Input[Union['TaskDefinitionEphemeralStorageArgs', 'TaskDefinitionEphemeralStorageArgsDict']]] = None,
                 execution_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 family: Optional[pulumi.Input[builtins.str]] = None,
                 inference_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TaskDefinitionInferenceAcceleratorArgs', 'TaskDefinitionInferenceAcceleratorArgsDict']]]]] = None,
                 ipc_mode: Optional[pulumi.Input[builtins.str]] = None,
                 memory: Optional[pulumi.Input[builtins.str]] = None,
                 network_mode: Optional[pulumi.Input[builtins.str]] = None,
                 pid_mode: Optional[pulumi.Input[builtins.str]] = None,
                 placement_constraints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TaskDefinitionPlacementConstraintArgs', 'TaskDefinitionPlacementConstraintArgsDict']]]]] = None,
                 proxy_configuration: Optional[pulumi.Input[Union['TaskDefinitionProxyConfigurationArgs', 'TaskDefinitionProxyConfigurationArgsDict']]] = None,
                 requires_compatibilities: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 runtime_platform: Optional[pulumi.Input[Union['TaskDefinitionRuntimePlatformArgs', 'TaskDefinitionRuntimePlatformArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 task_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TaskDefinitionVolumeArgs', 'TaskDefinitionVolumeArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TaskDefinitionArgs.__new__(TaskDefinitionArgs)

            __props__.__dict__["container_definitions"] = container_definitions
            __props__.__dict__["cpu"] = cpu
            __props__.__dict__["enable_fault_injection"] = enable_fault_injection
            __props__.__dict__["ephemeral_storage"] = ephemeral_storage
            __props__.__dict__["execution_role_arn"] = execution_role_arn
            __props__.__dict__["family"] = family
            __props__.__dict__["inference_accelerators"] = inference_accelerators
            __props__.__dict__["ipc_mode"] = ipc_mode
            __props__.__dict__["memory"] = memory
            __props__.__dict__["network_mode"] = network_mode
            __props__.__dict__["pid_mode"] = pid_mode
            __props__.__dict__["placement_constraints"] = placement_constraints
            __props__.__dict__["proxy_configuration"] = proxy_configuration
            __props__.__dict__["requires_compatibilities"] = requires_compatibilities
            __props__.__dict__["runtime_platform"] = runtime_platform
            __props__.__dict__["tags"] = tags
            __props__.__dict__["task_role_arn"] = task_role_arn
            __props__.__dict__["volumes"] = volumes
            __props__.__dict__["task_definition_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["containerDefinitions[*]", "cpu", "enableFaultInjection", "ephemeralStorage", "executionRoleArn", "family", "inferenceAccelerators[*]", "ipcMode", "memory", "networkMode", "pidMode", "placementConstraints[*]", "proxyConfiguration", "requiresCompatibilities[*]", "runtimePlatform", "taskRoleArn", "volumes[*]"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(TaskDefinition, __self__).__init__(
            'aws-native:ecs:TaskDefinition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'TaskDefinition':
        """
        Get an existing TaskDefinition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = TaskDefinitionArgs.__new__(TaskDefinitionArgs)

        __props__.__dict__["container_definitions"] = None
        __props__.__dict__["cpu"] = None
        __props__.__dict__["enable_fault_injection"] = None
        __props__.__dict__["ephemeral_storage"] = None
        __props__.__dict__["execution_role_arn"] = None
        __props__.__dict__["family"] = None
        __props__.__dict__["inference_accelerators"] = None
        __props__.__dict__["ipc_mode"] = None
        __props__.__dict__["memory"] = None
        __props__.__dict__["network_mode"] = None
        __props__.__dict__["pid_mode"] = None
        __props__.__dict__["placement_constraints"] = None
        __props__.__dict__["proxy_configuration"] = None
        __props__.__dict__["requires_compatibilities"] = None
        __props__.__dict__["runtime_platform"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["task_definition_arn"] = None
        __props__.__dict__["task_role_arn"] = None
        __props__.__dict__["volumes"] = None
        return TaskDefinition(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="containerDefinitions")
    def container_definitions(self) -> pulumi.Output[Optional[Sequence['outputs.TaskDefinitionContainerDefinition']]]:
        """
        A list of container definitions in JSON format that describe the different containers that make up your task. For more information about container definition parameters and defaults, see [Amazon ECS Task Definitions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html) in the *Amazon Elastic Container Service Developer Guide*.
        """
        return pulumi.get(self, "container_definitions")

    @property
    @pulumi.getter
    def cpu(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The number of ``cpu`` units used by the task. If you use the EC2 launch type, this field is optional. Any value can be used. If you use the Fargate launch type, this field is required. You must use one of the following values. The value that you choose determines your range of valid values for the ``memory`` parameter.
         If you're using the EC2 launch type or the external launch type, this field is optional. Supported values are between ``128`` CPU units (``0.125`` vCPUs) and ``196608`` CPU units (``192`` vCPUs). 
         This field is required for Fargate. For information about the valid values, see [Task size](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#task_size) in the *Amazon Elastic Container Service Developer Guide*.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter(name="enableFaultInjection")
    def enable_fault_injection(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enables fault injection and allows for fault injection requests to be accepted from the task's containers. The default value is ``false``.
        """
        return pulumi.get(self, "enable_fault_injection")

    @property
    @pulumi.getter(name="ephemeralStorage")
    def ephemeral_storage(self) -> pulumi.Output[Optional['outputs.TaskDefinitionEphemeralStorage']]:
        """
        The ephemeral storage settings to use for tasks run with the task definition.
        """
        return pulumi.get(self, "ephemeral_storage")

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent permission to make AWS API calls on your behalf. For informationabout the required IAM roles for Amazon ECS, see [IAM roles for Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/security-ecs-iam-role-overview.html) in the *Amazon Elastic Container Service Developer Guide*.
        """
        return pulumi.get(self, "execution_role_arn")

    @property
    @pulumi.getter
    def family(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of a family that this task definition is registered to. Up to 255 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed.
         A family groups multiple versions of a task definition. Amazon ECS gives the first task definition that you registered to a family a revision number of 1. Amazon ECS gives sequential revision numbers to each task definition that you add.
          To use revision numbers when you update a task definition, specify this property. If you don't specify a value, CFNlong generates a new task definition each time that you update it.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter(name="inferenceAccelerators")
    def inference_accelerators(self) -> pulumi.Output[Optional[Sequence['outputs.TaskDefinitionInferenceAccelerator']]]:
        """
        The Elastic Inference accelerators to use for the containers in the task.
        """
        return pulumi.get(self, "inference_accelerators")

    @property
    @pulumi.getter(name="ipcMode")
    def ipc_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The IPC resource namespace to use for the containers in the task. The valid values are ``host``, ``task``, or ``none``. If ``host`` is specified, then all containers within the tasks that specified the ``host`` IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance. If ``task`` is specified, all containers within the specified task share the same IPC resources. If ``none`` is specified, then IPC resources within the containers of a task are private and not shared with other containers in a task or on the container instance. If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance.
         If the ``host`` IPC mode is used, be aware that there is a heightened risk of undesired IPC namespace expose.
         If you are setting namespaced kernel parameters using ``systemControls`` for the containers in the task, the following will apply to your IPC resource namespace. For more information, see [System Controls](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html) in the *Amazon Elastic Container Service Developer Guide*.
          +  For tasks that use the ``host`` IPC mode, IPC namespace related ``systemControls`` are not supported.
          +  For tasks that use the ``task`` IPC mode, IPC namespace related ``systemControls`` will apply to all containers within a task.
          
          This parameter is not supported for Windows containers or tasks run on FARGATElong.
        """
        return pulumi.get(self, "ipc_mode")

    @property
    @pulumi.getter
    def memory(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The amount (in MiB) of memory used by the task.
         If your tasks runs on Amazon EC2 instances, you must specify either a task-level memory value or a container-level memory value. This field is optional and any value can be used. If a task-level memory value is specified, the container-level memory value is optional. For more information regarding container-level memory and memory reservation, see [ContainerDefinition](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html).
         If your tasks runs on FARGATElong, this field is required. You must use one of the following values. The value you choose determines your range of valid values for the ``cpu`` parameter.
          +  512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available ``cpu`` values: 256 (.25 vCPU)
          +  1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available ``cpu`` values: 512 (.5 vCPU)
          +  2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available ``cpu`` values: 1024 (1 vCPU)
          +  Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available ``cpu`` values: 2048 (2 vCPU)
          +  Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available ``cpu`` values: 4096 (4 vCPU)
          +  Between 16 GB and 60 GB in 4 GB increments - Available ``cpu`` values: 8192 (8 vCPU)
         This option requires Linux platform ``1.4.0`` or later.
          +  Between 32GB and 120 GB in 8 GB increments - Available ``cpu`` values: 16384 (16 vCPU)
         This option requires Linux platform ``1.4.0`` or later.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter(name="networkMode")
    def network_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Docker networking mode to use for the containers in the task. The valid values are ``none``, ``bridge``, ``awsvpc``, and ``host``. If no network mode is specified, the default is ``bridge``.
         For Amazon ECS tasks on Fargate, the ``awsvpc`` network mode is required. For Amazon ECS tasks on Amazon EC2 Linux instances, any network mode can be used. For Amazon ECS tasks on Amazon EC2 Windows instances, ``<default>`` or ``awsvpc`` can be used. If the network mode is set to ``none``, you cannot specify port mappings in your container definitions, and the tasks containers do not have external connectivity. The ``host`` and ``awsvpc`` network modes offer the highest networking performance for containers because they use the EC2 network stack instead of the virtualized network stack provided by the ``bridge`` mode.
         With the ``host`` and ``awsvpc`` network modes, exposed container ports are mapped directly to the corresponding host port (for the ``host`` network mode) or the attached elastic network interface port (for the ``awsvpc`` network mode), so you cannot take advantage of dynamic host port mappings. 
          When using the ``host`` network mode, you should not run containers using the root user (UID 0). It is considered best practice to use a non-root user.
          If the network mode is ``awsvpc``, the task is allocated an elastic network interface, and you must specify a [NetworkConfiguration](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_NetworkConfiguration.html) value when you create a service or run a task with the task definition. For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html) in the *Amazon Elastic Container Service Developer Guide*.
         If the network mode is ``host``, you cannot run multiple instantiations of the same task on a single container instance when port mappings are used.
        """
        return pulumi.get(self, "network_mode")

    @property
    @pulumi.getter(name="pidMode")
    def pid_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The process namespace to use for the containers in the task. The valid values are ``host`` or ``task``. On Fargate for Linux containers, the only valid value is ``task``. For example, monitoring sidecars might need ``pidMode`` to access information about other containers running in the same task.
         If ``host`` is specified, all containers within the tasks that specified the ``host`` PID mode on the same container instance share the same process namespace with the host Amazon EC2 instance.
         If ``task`` is specified, all containers within the specified task share the same process namespace.
         If no value is specified, the default is a private namespace for each container.
         If the ``host`` PID mode is used, there's a heightened risk of undesired process namespace exposure.
          This parameter is not supported for Windows containers.
           This parameter is only supported for tasks that are hosted on FARGATElong if the tasks are using platform version ``1.4.0`` or later (Linux). This isn't supported for Windows containers on Fargate.
        """
        return pulumi.get(self, "pid_mode")

    @property
    @pulumi.getter(name="placementConstraints")
    def placement_constraints(self) -> pulumi.Output[Optional[Sequence['outputs.TaskDefinitionPlacementConstraint']]]:
        """
        An array of placement constraint objects to use for tasks.
          This parameter isn't supported for tasks run on FARGATElong.
        """
        return pulumi.get(self, "placement_constraints")

    @property
    @pulumi.getter(name="proxyConfiguration")
    def proxy_configuration(self) -> pulumi.Output[Optional['outputs.TaskDefinitionProxyConfiguration']]:
        """
        The configuration details for the App Mesh proxy.
         Your Amazon ECS container instances require at least version 1.26.0 of the container agent and at least version 1.26.0-1 of the ``ecs-init`` package to use a proxy configuration. If your container instances are launched from the Amazon ECS optimized AMI version ``20190301`` or later, they contain the required versions of the container agent and ``ecs-init``. For more information, see [Amazon ECS-optimized Linux AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html) in the *Amazon Elastic Container Service Developer Guide*.
        """
        return pulumi.get(self, "proxy_configuration")

    @property
    @pulumi.getter(name="requiresCompatibilities")
    def requires_compatibilities(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The task launch types the task definition was validated against. The valid values are ``EC2``, ``FARGATE``, and ``EXTERNAL``. For more information, see [Amazon ECS launch types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html) in the *Amazon Elastic Container Service Developer Guide*.
        """
        return pulumi.get(self, "requires_compatibilities")

    @property
    @pulumi.getter(name="runtimePlatform")
    def runtime_platform(self) -> pulumi.Output[Optional['outputs.TaskDefinitionRuntimePlatform']]:
        """
        The operating system that your tasks definitions run on. A platform family is specified only for tasks using the Fargate launch type.
        """
        return pulumi.get(self, "runtime_platform")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The metadata that you apply to the task definition to help you categorize and organize them. Each tag consists of a key and an optional value. You define both of them.
         The following basic restrictions apply to tags:
          +  Maximum number of tags per resource - 50
          +  For each resource, each tag key must be unique, and each tag key can have only one value.
          +  Maximum key length - 128 Unicode characters in UTF-8
          +  Maximum value length - 256 Unicode characters in UTF-8
          +  If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
          +  Tag keys and values are case-sensitive.
          +  Do not use ``aws:``, ``AWS:``, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="taskDefinitionArn")
    def task_definition_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the task definition.
        """
        return pulumi.get(self, "task_definition_arn")

    @property
    @pulumi.getter(name="taskRoleArn")
    def task_role_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The short name or full Amazon Resource Name (ARN) of the IAMlong role that grants containers in the task permission to call AWS APIs on your behalf. For more information, see [Amazon ECS Task Role](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html) in the *Amazon Elastic Container Service Developer Guide*.
         IAM roles for tasks on Windows require that the ``-EnableTaskIAMRole`` option is set when you launch the Amazon ECS-optimized Windows AMI. Your containers must also run some configuration code to use the feature. For more information, see [Windows IAM roles for tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows_task_IAM_roles.html) in the *Amazon Elastic Container Service Developer Guide*.
          String validation is done on the ECS side. If an invalid string value is given for ``TaskRoleArn``, it may cause the Cloudformation job to hang.
        """
        return pulumi.get(self, "task_role_arn")

    @property
    @pulumi.getter
    def volumes(self) -> pulumi.Output[Optional[Sequence['outputs.TaskDefinitionVolume']]]:
        """
        The list of data volume definitions for the task. For more information, see [Using data volumes in tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html) in the *Amazon Elastic Container Service Developer Guide*.
          The ``host`` and ``sourcePath`` parameters aren't supported for tasks run on FARGATElong.
        """
        return pulumi.get(self, "volumes")

