# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'CapacityProviderAutoScalingGroupProvider',
    'CapacityProviderManagedScaling',
    'ClusterCapacityProviderAssociationsCapacityProviderStrategy',
    'ClusterCapacityProviderStrategyItem',
    'ClusterConfiguration',
    'ClusterExecuteCommandConfiguration',
    'ClusterExecuteCommandLogConfiguration',
    'ClusterManagedStorageConfiguration',
    'ClusterServiceConnectDefaults',
    'ClusterSettings',
    'ServiceAwsVpcConfiguration',
    'ServiceCapacityProviderStrategyItem',
    'ServiceConnectClientAlias',
    'ServiceConnectConfiguration',
    'ServiceConnectService',
    'ServiceConnectTlsCertificateAuthority',
    'ServiceConnectTlsConfiguration',
    'ServiceDeploymentAlarms',
    'ServiceDeploymentCircuitBreaker',
    'ServiceDeploymentConfiguration',
    'ServiceDeploymentController',
    'ServiceEbsTagSpecification',
    'ServiceLoadBalancer',
    'ServiceLogConfiguration',
    'ServiceManagedEbsVolumeConfiguration',
    'ServiceNetworkConfiguration',
    'ServicePlacementConstraint',
    'ServicePlacementStrategy',
    'ServiceRegistry',
    'ServiceSecret',
    'ServiceTag',
    'ServiceTimeoutConfiguration',
    'ServiceVolumeConfiguration',
    'ServiceVpcLatticeConfiguration',
    'TaskDefinitionAuthorizationConfig',
    'TaskDefinitionContainerDefinition',
    'TaskDefinitionContainerDependency',
    'TaskDefinitionDevice',
    'TaskDefinitionDockerVolumeConfiguration',
    'TaskDefinitionEfsVolumeConfiguration',
    'TaskDefinitionEnvironmentFile',
    'TaskDefinitionEphemeralStorage',
    'TaskDefinitionFSxAuthorizationConfig',
    'TaskDefinitionFSxWindowsFileServerVolumeConfiguration',
    'TaskDefinitionFirelensConfiguration',
    'TaskDefinitionHealthCheck',
    'TaskDefinitionHostEntry',
    'TaskDefinitionHostVolumeProperties',
    'TaskDefinitionInferenceAccelerator',
    'TaskDefinitionKernelCapabilities',
    'TaskDefinitionKeyValuePair',
    'TaskDefinitionLinuxParameters',
    'TaskDefinitionLogConfiguration',
    'TaskDefinitionMountPoint',
    'TaskDefinitionPlacementConstraint',
    'TaskDefinitionPortMapping',
    'TaskDefinitionProxyConfiguration',
    'TaskDefinitionRepositoryCredentials',
    'TaskDefinitionResourceRequirement',
    'TaskDefinitionRestartPolicy',
    'TaskDefinitionRuntimePlatform',
    'TaskDefinitionSecret',
    'TaskDefinitionSystemControl',
    'TaskDefinitionTmpfs',
    'TaskDefinitionUlimit',
    'TaskDefinitionVolume',
    'TaskDefinitionVolumeFrom',
    'TaskSetAwsVpcConfiguration',
    'TaskSetCapacityProviderStrategyItem',
    'TaskSetLoadBalancer',
    'TaskSetNetworkConfiguration',
    'TaskSetScale',
    'TaskSetServiceRegistry',
]

@pulumi.output_type
class CapacityProviderAutoScalingGroupProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoScalingGroupArn":
            suggest = "auto_scaling_group_arn"
        elif key == "managedDraining":
            suggest = "managed_draining"
        elif key == "managedScaling":
            suggest = "managed_scaling"
        elif key == "managedTerminationProtection":
            suggest = "managed_termination_protection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CapacityProviderAutoScalingGroupProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CapacityProviderAutoScalingGroupProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CapacityProviderAutoScalingGroupProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_scaling_group_arn: builtins.str,
                 managed_draining: Optional['CapacityProviderAutoScalingGroupProviderManagedDraining'] = None,
                 managed_scaling: Optional['outputs.CapacityProviderManagedScaling'] = None,
                 managed_termination_protection: Optional['CapacityProviderAutoScalingGroupProviderManagedTerminationProtection'] = None):
        """
        :param builtins.str auto_scaling_group_arn: The Amazon Resource Name (ARN) that identifies the Auto Scaling group, or the Auto Scaling group name.
        :param 'CapacityProviderAutoScalingGroupProviderManagedDraining' managed_draining: The managed draining option for the Auto Scaling group capacity provider. When you enable this, Amazon ECS manages and gracefully drains the EC2 container instances that are in the Auto Scaling group capacity provider.
        :param 'CapacityProviderManagedScaling' managed_scaling: The managed scaling settings for the Auto Scaling group capacity provider.
        :param 'CapacityProviderAutoScalingGroupProviderManagedTerminationProtection' managed_termination_protection: The managed termination protection setting to use for the Auto Scaling group capacity provider. This determines whether the Auto Scaling group has managed termination protection. The default is off.
               
               > When using managed termination protection, managed scaling must also be used otherwise managed termination protection doesn't work. 
               
               When managed termination protection is on, Amazon ECS prevents the Amazon EC2 instances in an Auto Scaling group that contain tasks from being terminated during a scale-in action. The Auto Scaling group and each instance in the Auto Scaling group must have instance protection from scale-in actions on as well. For more information, see [Instance Protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection) in the *AWS Auto Scaling User Guide* .
               
               When managed termination protection is off, your Amazon EC2 instances aren't protected from termination when the Auto Scaling group scales in.
        """
        pulumi.set(__self__, "auto_scaling_group_arn", auto_scaling_group_arn)
        if managed_draining is not None:
            pulumi.set(__self__, "managed_draining", managed_draining)
        if managed_scaling is not None:
            pulumi.set(__self__, "managed_scaling", managed_scaling)
        if managed_termination_protection is not None:
            pulumi.set(__self__, "managed_termination_protection", managed_termination_protection)

    @property
    @pulumi.getter(name="autoScalingGroupArn")
    def auto_scaling_group_arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) that identifies the Auto Scaling group, or the Auto Scaling group name.
        """
        return pulumi.get(self, "auto_scaling_group_arn")

    @property
    @pulumi.getter(name="managedDraining")
    def managed_draining(self) -> Optional['CapacityProviderAutoScalingGroupProviderManagedDraining']:
        """
        The managed draining option for the Auto Scaling group capacity provider. When you enable this, Amazon ECS manages and gracefully drains the EC2 container instances that are in the Auto Scaling group capacity provider.
        """
        return pulumi.get(self, "managed_draining")

    @property
    @pulumi.getter(name="managedScaling")
    def managed_scaling(self) -> Optional['outputs.CapacityProviderManagedScaling']:
        """
        The managed scaling settings for the Auto Scaling group capacity provider.
        """
        return pulumi.get(self, "managed_scaling")

    @property
    @pulumi.getter(name="managedTerminationProtection")
    def managed_termination_protection(self) -> Optional['CapacityProviderAutoScalingGroupProviderManagedTerminationProtection']:
        """
        The managed termination protection setting to use for the Auto Scaling group capacity provider. This determines whether the Auto Scaling group has managed termination protection. The default is off.

        > When using managed termination protection, managed scaling must also be used otherwise managed termination protection doesn't work. 

        When managed termination protection is on, Amazon ECS prevents the Amazon EC2 instances in an Auto Scaling group that contain tasks from being terminated during a scale-in action. The Auto Scaling group and each instance in the Auto Scaling group must have instance protection from scale-in actions on as well. For more information, see [Instance Protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection) in the *AWS Auto Scaling User Guide* .

        When managed termination protection is off, your Amazon EC2 instances aren't protected from termination when the Auto Scaling group scales in.
        """
        return pulumi.get(self, "managed_termination_protection")


@pulumi.output_type
class CapacityProviderManagedScaling(dict):
    """
    The managed scaling settings for the Auto Scaling group capacity provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceWarmupPeriod":
            suggest = "instance_warmup_period"
        elif key == "maximumScalingStepSize":
            suggest = "maximum_scaling_step_size"
        elif key == "minimumScalingStepSize":
            suggest = "minimum_scaling_step_size"
        elif key == "targetCapacity":
            suggest = "target_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CapacityProviderManagedScaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CapacityProviderManagedScaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CapacityProviderManagedScaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_warmup_period: Optional[builtins.int] = None,
                 maximum_scaling_step_size: Optional[builtins.int] = None,
                 minimum_scaling_step_size: Optional[builtins.int] = None,
                 status: Optional['CapacityProviderManagedScalingStatus'] = None,
                 target_capacity: Optional[builtins.int] = None):
        """
        The managed scaling settings for the Auto Scaling group capacity provider.
        :param builtins.int instance_warmup_period: The period of time, in seconds, after a newly launched Amazon EC2 instance can contribute to CloudWatch metrics for Auto Scaling group. If this parameter is omitted, the default value of `300` seconds is used.
        :param builtins.int maximum_scaling_step_size: The maximum number of Amazon EC2 instances that Amazon ECS will scale out at one time. If this parameter is omitted, the default value of `10000` is used.
        :param builtins.int minimum_scaling_step_size: The minimum number of Amazon EC2 instances that Amazon ECS will scale out at one time. The scale in process is not affected by this parameter If this parameter is omitted, the default value of `1` is used.
               
               When additional capacity is required, Amazon ECS will scale up the minimum scaling step size even if the actual demand is less than the minimum scaling step size.
               
               If you use a capacity provider with an Auto Scaling group configured with more than one Amazon EC2 instance type or Availability Zone, Amazon ECS will scale up by the exact minimum scaling step size value and will ignore both the maximum scaling step size as well as the capacity demand.
        :param 'CapacityProviderManagedScalingStatus' status: Determines whether to use managed scaling for the capacity provider.
        :param builtins.int target_capacity: The target capacity utilization as a percentage for the capacity provider. The specified value must be greater than `0` and less than or equal to `100` . For example, if you want the capacity provider to maintain 10% spare capacity, then that means the utilization is 90%, so use a `targetCapacity` of `90` . The default value of `100` percent results in the Amazon EC2 instances in your Auto Scaling group being completely used.
        """
        if instance_warmup_period is not None:
            pulumi.set(__self__, "instance_warmup_period", instance_warmup_period)
        if maximum_scaling_step_size is not None:
            pulumi.set(__self__, "maximum_scaling_step_size", maximum_scaling_step_size)
        if minimum_scaling_step_size is not None:
            pulumi.set(__self__, "minimum_scaling_step_size", minimum_scaling_step_size)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if target_capacity is not None:
            pulumi.set(__self__, "target_capacity", target_capacity)

    @property
    @pulumi.getter(name="instanceWarmupPeriod")
    def instance_warmup_period(self) -> Optional[builtins.int]:
        """
        The period of time, in seconds, after a newly launched Amazon EC2 instance can contribute to CloudWatch metrics for Auto Scaling group. If this parameter is omitted, the default value of `300` seconds is used.
        """
        return pulumi.get(self, "instance_warmup_period")

    @property
    @pulumi.getter(name="maximumScalingStepSize")
    def maximum_scaling_step_size(self) -> Optional[builtins.int]:
        """
        The maximum number of Amazon EC2 instances that Amazon ECS will scale out at one time. If this parameter is omitted, the default value of `10000` is used.
        """
        return pulumi.get(self, "maximum_scaling_step_size")

    @property
    @pulumi.getter(name="minimumScalingStepSize")
    def minimum_scaling_step_size(self) -> Optional[builtins.int]:
        """
        The minimum number of Amazon EC2 instances that Amazon ECS will scale out at one time. The scale in process is not affected by this parameter If this parameter is omitted, the default value of `1` is used.

        When additional capacity is required, Amazon ECS will scale up the minimum scaling step size even if the actual demand is less than the minimum scaling step size.

        If you use a capacity provider with an Auto Scaling group configured with more than one Amazon EC2 instance type or Availability Zone, Amazon ECS will scale up by the exact minimum scaling step size value and will ignore both the maximum scaling step size as well as the capacity demand.
        """
        return pulumi.get(self, "minimum_scaling_step_size")

    @property
    @pulumi.getter
    def status(self) -> Optional['CapacityProviderManagedScalingStatus']:
        """
        Determines whether to use managed scaling for the capacity provider.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="targetCapacity")
    def target_capacity(self) -> Optional[builtins.int]:
        """
        The target capacity utilization as a percentage for the capacity provider. The specified value must be greater than `0` and less than or equal to `100` . For example, if you want the capacity provider to maintain 10% spare capacity, then that means the utilization is 90%, so use a `targetCapacity` of `90` . The default value of `100` percent results in the Amazon EC2 instances in your Auto Scaling group being completely used.
        """
        return pulumi.get(self, "target_capacity")


@pulumi.output_type
class ClusterCapacityProviderAssociationsCapacityProviderStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityProvider":
            suggest = "capacity_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCapacityProviderAssociationsCapacityProviderStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCapacityProviderAssociationsCapacityProviderStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCapacityProviderAssociationsCapacityProviderStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_provider: builtins.str,
                 base: Optional[builtins.int] = None,
                 weight: Optional[builtins.int] = None):
        pulumi.set(__self__, "capacity_provider", capacity_provider)
        if base is not None:
            pulumi.set(__self__, "base", base)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="capacityProvider")
    def capacity_provider(self) -> builtins.str:
        return pulumi.get(self, "capacity_provider")

    @property
    @pulumi.getter
    def base(self) -> Optional[builtins.int]:
        return pulumi.get(self, "base")

    @property
    @pulumi.getter
    def weight(self) -> Optional[builtins.int]:
        return pulumi.get(self, "weight")


@pulumi.output_type
class ClusterCapacityProviderStrategyItem(dict):
    """
    The ``CapacityProviderStrategyItem`` property specifies the details of the default capacity provider strategy for the cluster. When services or tasks are run in the cluster with no launch type or capacity provider strategy specified, the default capacity provider strategy is used.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityProvider":
            suggest = "capacity_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterCapacityProviderStrategyItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterCapacityProviderStrategyItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterCapacityProviderStrategyItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base: Optional[builtins.int] = None,
                 capacity_provider: Optional[builtins.str] = None,
                 weight: Optional[builtins.int] = None):
        """
        The ``CapacityProviderStrategyItem`` property specifies the details of the default capacity provider strategy for the cluster. When services or tasks are run in the cluster with no launch type or capacity provider strategy specified, the default capacity provider strategy is used.
        :param builtins.int base: The *base* value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a *base* defined. If no value is specified, the default value of ``0`` is used.
        :param builtins.str capacity_provider: The short name of the capacity provider.
        :param builtins.int weight: The *weight* value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The ``weight`` value is taken into consideration after the ``base`` value, if defined, is satisfied.
                If no ``weight`` value is specified, the default value of ``0`` is used. When multiple capacity providers are specified within a capacity provider strategy, at least one of the capacity providers must have a weight value greater than zero and any capacity providers with a weight of ``0`` can't be used to place tasks. If you specify multiple capacity providers in a strategy that all have a weight of ``0``, any ``RunTask`` or ``CreateService`` actions using the capacity provider strategy will fail.
                An example scenario for using weights is defining a strategy that contains two capacity providers and both have a weight of ``1``, then when the ``base`` is satisfied, the tasks will be split evenly across the two capacity providers. Using that same logic, if you specify a weight of ``1`` for *capacityProviderA* and a weight of ``4`` for *capacityProviderB*, then for every one task that's run using *capacityProviderA*, four tasks would use *capacityProviderB*.
        """
        if base is not None:
            pulumi.set(__self__, "base", base)
        if capacity_provider is not None:
            pulumi.set(__self__, "capacity_provider", capacity_provider)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def base(self) -> Optional[builtins.int]:
        """
        The *base* value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a *base* defined. If no value is specified, the default value of ``0`` is used.
        """
        return pulumi.get(self, "base")

    @property
    @pulumi.getter(name="capacityProvider")
    def capacity_provider(self) -> Optional[builtins.str]:
        """
        The short name of the capacity provider.
        """
        return pulumi.get(self, "capacity_provider")

    @property
    @pulumi.getter
    def weight(self) -> Optional[builtins.int]:
        """
        The *weight* value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The ``weight`` value is taken into consideration after the ``base`` value, if defined, is satisfied.
         If no ``weight`` value is specified, the default value of ``0`` is used. When multiple capacity providers are specified within a capacity provider strategy, at least one of the capacity providers must have a weight value greater than zero and any capacity providers with a weight of ``0`` can't be used to place tasks. If you specify multiple capacity providers in a strategy that all have a weight of ``0``, any ``RunTask`` or ``CreateService`` actions using the capacity provider strategy will fail.
         An example scenario for using weights is defining a strategy that contains two capacity providers and both have a weight of ``1``, then when the ``base`` is satisfied, the tasks will be split evenly across the two capacity providers. Using that same logic, if you specify a weight of ``1`` for *capacityProviderA* and a weight of ``4`` for *capacityProviderB*, then for every one task that's run using *capacityProviderA*, four tasks would use *capacityProviderB*.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ClusterConfiguration(dict):
    """
    The execute command and managed storage configuration for the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executeCommandConfiguration":
            suggest = "execute_command_configuration"
        elif key == "managedStorageConfiguration":
            suggest = "managed_storage_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execute_command_configuration: Optional['outputs.ClusterExecuteCommandConfiguration'] = None,
                 managed_storage_configuration: Optional['outputs.ClusterManagedStorageConfiguration'] = None):
        """
        The execute command and managed storage configuration for the cluster.
        :param 'ClusterExecuteCommandConfiguration' execute_command_configuration: The details of the execute command configuration.
        :param 'ClusterManagedStorageConfiguration' managed_storage_configuration: The details of the managed storage configuration.
        """
        if execute_command_configuration is not None:
            pulumi.set(__self__, "execute_command_configuration", execute_command_configuration)
        if managed_storage_configuration is not None:
            pulumi.set(__self__, "managed_storage_configuration", managed_storage_configuration)

    @property
    @pulumi.getter(name="executeCommandConfiguration")
    def execute_command_configuration(self) -> Optional['outputs.ClusterExecuteCommandConfiguration']:
        """
        The details of the execute command configuration.
        """
        return pulumi.get(self, "execute_command_configuration")

    @property
    @pulumi.getter(name="managedStorageConfiguration")
    def managed_storage_configuration(self) -> Optional['outputs.ClusterManagedStorageConfiguration']:
        """
        The details of the managed storage configuration.
        """
        return pulumi.get(self, "managed_storage_configuration")


@pulumi.output_type
class ClusterExecuteCommandConfiguration(dict):
    """
    The details of the execute command configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "logConfiguration":
            suggest = "log_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterExecuteCommandConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterExecuteCommandConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterExecuteCommandConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_id: Optional[builtins.str] = None,
                 log_configuration: Optional['outputs.ClusterExecuteCommandLogConfiguration'] = None,
                 logging: Optional[builtins.str] = None):
        """
        The details of the execute command configuration.
        :param builtins.str kms_key_id: Specify an KMSlong key ID to encrypt the data between the local client and the container.
        :param 'ClusterExecuteCommandLogConfiguration' log_configuration: The log configuration for the results of the execute command actions. The logs can be sent to CloudWatch Logs or an Amazon S3 bucket. When ``logging=OVERRIDE`` is specified, a ``logConfiguration`` must be provided.
        :param builtins.str logging: The log setting to use for redirecting logs for your execute command results. The following log settings are available.
                 +  ``NONE``: The execute command session is not logged.
                 +  ``DEFAULT``: The ``awslogs`` configuration in the task definition is used. If no logging parameter is specified, it defaults to this value. If no ``awslogs`` log driver is configured in the task definition, the output won't be logged.
                 +  ``OVERRIDE``: Specify the logging details as a part of ``logConfiguration``. If the ``OVERRIDE`` logging option is specified, the ``logConfiguration`` is required.
        """
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if log_configuration is not None:
            pulumi.set(__self__, "log_configuration", log_configuration)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[builtins.str]:
        """
        Specify an KMSlong key ID to encrypt the data between the local client and the container.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="logConfiguration")
    def log_configuration(self) -> Optional['outputs.ClusterExecuteCommandLogConfiguration']:
        """
        The log configuration for the results of the execute command actions. The logs can be sent to CloudWatch Logs or an Amazon S3 bucket. When ``logging=OVERRIDE`` is specified, a ``logConfiguration`` must be provided.
        """
        return pulumi.get(self, "log_configuration")

    @property
    @pulumi.getter
    def logging(self) -> Optional[builtins.str]:
        """
        The log setting to use for redirecting logs for your execute command results. The following log settings are available.
          +  ``NONE``: The execute command session is not logged.
          +  ``DEFAULT``: The ``awslogs`` configuration in the task definition is used. If no logging parameter is specified, it defaults to this value. If no ``awslogs`` log driver is configured in the task definition, the output won't be logged.
          +  ``OVERRIDE``: Specify the logging details as a part of ``logConfiguration``. If the ``OVERRIDE`` logging option is specified, the ``logConfiguration`` is required.
        """
        return pulumi.get(self, "logging")


@pulumi.output_type
class ClusterExecuteCommandLogConfiguration(dict):
    """
    The log configuration for the results of the execute command actions. The logs can be sent to CloudWatch Logs or an Amazon S3 bucket.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudWatchEncryptionEnabled":
            suggest = "cloud_watch_encryption_enabled"
        elif key == "cloudWatchLogGroupName":
            suggest = "cloud_watch_log_group_name"
        elif key == "s3BucketName":
            suggest = "s3_bucket_name"
        elif key == "s3EncryptionEnabled":
            suggest = "s3_encryption_enabled"
        elif key == "s3KeyPrefix":
            suggest = "s3_key_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterExecuteCommandLogConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterExecuteCommandLogConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterExecuteCommandLogConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_watch_encryption_enabled: Optional[builtins.bool] = None,
                 cloud_watch_log_group_name: Optional[builtins.str] = None,
                 s3_bucket_name: Optional[builtins.str] = None,
                 s3_encryption_enabled: Optional[builtins.bool] = None,
                 s3_key_prefix: Optional[builtins.str] = None):
        """
        The log configuration for the results of the execute command actions. The logs can be sent to CloudWatch Logs or an Amazon S3 bucket.
        :param builtins.bool cloud_watch_encryption_enabled: Determines whether to use encryption on the CloudWatch logs. If not specified, encryption will be off.
        :param builtins.str cloud_watch_log_group_name: The name of the CloudWatch log group to send logs to.
                 The CloudWatch log group must already be created.
        :param builtins.str s3_bucket_name: The name of the S3 bucket to send logs to.
                 The S3 bucket must already be created.
        :param builtins.bool s3_encryption_enabled: Determines whether to use encryption on the S3 logs. If not specified, encryption is not used.
        :param builtins.str s3_key_prefix: An optional folder in the S3 bucket to place logs in.
        """
        if cloud_watch_encryption_enabled is not None:
            pulumi.set(__self__, "cloud_watch_encryption_enabled", cloud_watch_encryption_enabled)
        if cloud_watch_log_group_name is not None:
            pulumi.set(__self__, "cloud_watch_log_group_name", cloud_watch_log_group_name)
        if s3_bucket_name is not None:
            pulumi.set(__self__, "s3_bucket_name", s3_bucket_name)
        if s3_encryption_enabled is not None:
            pulumi.set(__self__, "s3_encryption_enabled", s3_encryption_enabled)
        if s3_key_prefix is not None:
            pulumi.set(__self__, "s3_key_prefix", s3_key_prefix)

    @property
    @pulumi.getter(name="cloudWatchEncryptionEnabled")
    def cloud_watch_encryption_enabled(self) -> Optional[builtins.bool]:
        """
        Determines whether to use encryption on the CloudWatch logs. If not specified, encryption will be off.
        """
        return pulumi.get(self, "cloud_watch_encryption_enabled")

    @property
    @pulumi.getter(name="cloudWatchLogGroupName")
    def cloud_watch_log_group_name(self) -> Optional[builtins.str]:
        """
        The name of the CloudWatch log group to send logs to.
          The CloudWatch log group must already be created.
        """
        return pulumi.get(self, "cloud_watch_log_group_name")

    @property
    @pulumi.getter(name="s3BucketName")
    def s3_bucket_name(self) -> Optional[builtins.str]:
        """
        The name of the S3 bucket to send logs to.
          The S3 bucket must already be created.
        """
        return pulumi.get(self, "s3_bucket_name")

    @property
    @pulumi.getter(name="s3EncryptionEnabled")
    def s3_encryption_enabled(self) -> Optional[builtins.bool]:
        """
        Determines whether to use encryption on the S3 logs. If not specified, encryption is not used.
        """
        return pulumi.get(self, "s3_encryption_enabled")

    @property
    @pulumi.getter(name="s3KeyPrefix")
    def s3_key_prefix(self) -> Optional[builtins.str]:
        """
        An optional folder in the S3 bucket to place logs in.
        """
        return pulumi.get(self, "s3_key_prefix")


@pulumi.output_type
class ClusterManagedStorageConfiguration(dict):
    """
    The managed storage configuration for the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fargateEphemeralStorageKmsKeyId":
            suggest = "fargate_ephemeral_storage_kms_key_id"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterManagedStorageConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterManagedStorageConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterManagedStorageConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fargate_ephemeral_storage_kms_key_id: Optional[builtins.str] = None,
                 kms_key_id: Optional[builtins.str] = None):
        """
        The managed storage configuration for the cluster.
        :param builtins.str fargate_ephemeral_storage_kms_key_id: Specify the KMSlong key ID for Fargate ephemeral storage.
                When you specify a ``fargateEphemeralStorageKmsKeyId``, AWS Fargate uses the key to encrypt data at rest in ephemeral storage. For more information about Fargate ephemeral storage encryption, see [Customer managed keys for Fargate ephemeral storage for Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/fargate-storage-encryption.html) in the *Amazon Elastic Container Service Developer Guide*.
                The key must be a single Region key.
        :param builtins.str kms_key_id: Specify a KMSlong key ID to encrypt Amazon ECS managed storage.
                 When you specify a ``kmsKeyId``, Amazon ECS uses the key to encrypt data volumes managed by Amazon ECS that are attached to tasks in the cluster. The following data volumes are managed by Amazon ECS: Amazon EBS. For more information about encryption of Amazon EBS volumes attached to Amazon ECS tasks, see [Encrypt data stored in Amazon EBS volumes for Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-kms-encryption.html) in the *Amazon Elastic Container Service Developer Guide*.
                The key must be a single Region key.
        """
        if fargate_ephemeral_storage_kms_key_id is not None:
            pulumi.set(__self__, "fargate_ephemeral_storage_kms_key_id", fargate_ephemeral_storage_kms_key_id)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="fargateEphemeralStorageKmsKeyId")
    def fargate_ephemeral_storage_kms_key_id(self) -> Optional[builtins.str]:
        """
        Specify the KMSlong key ID for Fargate ephemeral storage.
         When you specify a ``fargateEphemeralStorageKmsKeyId``, AWS Fargate uses the key to encrypt data at rest in ephemeral storage. For more information about Fargate ephemeral storage encryption, see [Customer managed keys for Fargate ephemeral storage for Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/fargate-storage-encryption.html) in the *Amazon Elastic Container Service Developer Guide*.
         The key must be a single Region key.
        """
        return pulumi.get(self, "fargate_ephemeral_storage_kms_key_id")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[builtins.str]:
        """
        Specify a KMSlong key ID to encrypt Amazon ECS managed storage.
          When you specify a ``kmsKeyId``, Amazon ECS uses the key to encrypt data volumes managed by Amazon ECS that are attached to tasks in the cluster. The following data volumes are managed by Amazon ECS: Amazon EBS. For more information about encryption of Amazon EBS volumes attached to Amazon ECS tasks, see [Encrypt data stored in Amazon EBS volumes for Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-kms-encryption.html) in the *Amazon Elastic Container Service Developer Guide*.
         The key must be a single Region key.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class ClusterServiceConnectDefaults(dict):
    """
    Use this parameter to set a default Service Connect namespace. After you set a default Service Connect namespace, any new services with Service Connect turned on that are created in the cluster are added as client services in the namespace. This setting only applies to new services that set the ``enabled`` parameter to ``true`` in the ``ServiceConnectConfiguration``. You can set the namespace of each service individually in the ``ServiceConnectConfiguration`` to override this default parameter.
     Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
    """
    def __init__(__self__, *,
                 namespace: Optional[builtins.str] = None):
        """
        Use this parameter to set a default Service Connect namespace. After you set a default Service Connect namespace, any new services with Service Connect turned on that are created in the cluster are added as client services in the namespace. This setting only applies to new services that set the ``enabled`` parameter to ``true`` in the ``ServiceConnectConfiguration``. You can set the namespace of each service individually in the ``ServiceConnectConfiguration`` to override this default parameter.
         Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param builtins.str namespace: The namespace name or full Amazon Resource Name (ARN) of the CMAPlong namespace that's used when you create a service and don't specify a Service Connect configuration. The namespace name can include up to 1024 characters. The name is case-sensitive. The name can't include greater than (>), less than (<), double quotation marks ("), or slash (/).
                If you enter an existing namespace name or ARN, then that namespace will be used. Any namespace type is supported. The namespace must be in this account and this AWS Region.
                If you enter a new name, a CMAPlong namespace will be created. Amazon ECS creates a CMAP namespace with the "API calls" method of instance discovery only. This instance discovery method is the "HTTP" namespace type in the CLIlong. Other types of instance discovery aren't used by Service Connect.
                If you update the cluster with an empty string ``""`` for the namespace name, the cluster configuration for Service Connect is removed. Note that the namespace will remain in CMAP and must be deleted separately.
                For more information about CMAPlong, see [Working with Services](https://docs.aws.amazon.com/cloud-map/latest/dg/working-with-services.html) in the *Developer Guide*.
        """
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[builtins.str]:
        """
        The namespace name or full Amazon Resource Name (ARN) of the CMAPlong namespace that's used when you create a service and don't specify a Service Connect configuration. The namespace name can include up to 1024 characters. The name is case-sensitive. The name can't include greater than (>), less than (<), double quotation marks ("), or slash (/).
         If you enter an existing namespace name or ARN, then that namespace will be used. Any namespace type is supported. The namespace must be in this account and this AWS Region.
         If you enter a new name, a CMAPlong namespace will be created. Amazon ECS creates a CMAP namespace with the "API calls" method of instance discovery only. This instance discovery method is the "HTTP" namespace type in the CLIlong. Other types of instance discovery aren't used by Service Connect.
         If you update the cluster with an empty string ``""`` for the namespace name, the cluster configuration for Service Connect is removed. Note that the namespace will remain in CMAP and must be deleted separately.
         For more information about CMAPlong, see [Working with Services](https://docs.aws.amazon.com/cloud-map/latest/dg/working-with-services.html) in the *Developer Guide*.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class ClusterSettings(dict):
    """
    The settings to use when creating a cluster. This parameter is used to turn on CloudWatch Container Insights with enhanced observability or CloudWatch Container Insights for a cluster.
     Container Insights with enhanced observability provides all the Container Insights metrics, plus additional task and container metrics. This version supports enhanced observability for Amazon ECS clusters using the Amazon EC2 and Fargate launch types. After you configure Container Insights with enhanced observability on Amazon ECS, Container Insights auto-collects detailed infrastructure telemetry from the cluster level down to the container level in your environment and displays these critical performance data in curated dashboards removing the heavy lifting in observability set-up. 
     For more information, see [Monitor Amazon ECS containers using Container Insights with enhanced observability](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cloudwatch-container-insights.html) in the *Amazon Elastic Container Service Developer Guide*.
    """
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        The settings to use when creating a cluster. This parameter is used to turn on CloudWatch Container Insights with enhanced observability or CloudWatch Container Insights for a cluster.
         Container Insights with enhanced observability provides all the Container Insights metrics, plus additional task and container metrics. This version supports enhanced observability for Amazon ECS clusters using the Amazon EC2 and Fargate launch types. After you configure Container Insights with enhanced observability on Amazon ECS, Container Insights auto-collects detailed infrastructure telemetry from the cluster level down to the container level in your environment and displays these critical performance data in curated dashboards removing the heavy lifting in observability set-up. 
         For more information, see [Monitor Amazon ECS containers using Container Insights with enhanced observability](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cloudwatch-container-insights.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param builtins.str name: The name of the cluster setting. The value is ``containerInsights`` .
        :param builtins.str value: The value to set for the cluster setting. The supported values are ``enhanced``, ``enabled``, and ``disabled``. 
                To use Container Insights with enhanced observability, set the ``containerInsights`` account setting to ``enhanced``.
                To use Container Insights, set the ``containerInsights`` account setting to ``enabled``.
                If a cluster value is specified, it will override the ``containerInsights`` value set with [PutAccountSetting](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSetting.html) or [PutAccountSettingDefault](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSettingDefault.html).
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the cluster setting. The value is ``containerInsights`` .
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The value to set for the cluster setting. The supported values are ``enhanced``, ``enabled``, and ``disabled``. 
         To use Container Insights with enhanced observability, set the ``containerInsights`` account setting to ``enhanced``.
         To use Container Insights, set the ``containerInsights`` account setting to ``enabled``.
         If a cluster value is specified, it will override the ``containerInsights`` value set with [PutAccountSetting](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSetting.html) or [PutAccountSettingDefault](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSettingDefault.html).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceAwsVpcConfiguration(dict):
    """
    An object representing the networking details for a task or service. For example ``awsVpcConfiguration={subnets=["subnet-12344321"],securityGroups=["sg-12344321"]}``.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignPublicIp":
            suggest = "assign_public_ip"
        elif key == "securityGroups":
            suggest = "security_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceAwsVpcConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceAwsVpcConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceAwsVpcConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 assign_public_ip: Optional['ServiceAwsVpcConfigurationAssignPublicIp'] = None,
                 security_groups: Optional[Sequence[builtins.str]] = None,
                 subnets: Optional[Sequence[builtins.str]] = None):
        """
        An object representing the networking details for a task or service. For example ``awsVpcConfiguration={subnets=["subnet-12344321"],securityGroups=["sg-12344321"]}``.
        :param 'ServiceAwsVpcConfigurationAssignPublicIp' assign_public_ip: Whether the task's elastic network interface receives a public IP address. 
                Consider the following when you set this value:
                 +  When you use ``create-service`` or ``update-service``, the default is ``DISABLED``. 
                 +  When the service ``deploymentController`` is ``ECS``, the value must be ``DISABLED``.
        :param Sequence[builtins.str] security_groups: The IDs of the security groups associated with the task or service. If you don't specify a security group, the default security group for the VPC is used. There's a limit of 5 security groups that can be specified.
                 All specified security groups must be from the same VPC.
        :param Sequence[builtins.str] subnets: The IDs of the subnets associated with the task or service. There's a limit of 16 subnets that can be specified.
                 All specified subnets must be from the same VPC.
        """
        if assign_public_ip is not None:
            pulumi.set(__self__, "assign_public_ip", assign_public_ip)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="assignPublicIp")
    def assign_public_ip(self) -> Optional['ServiceAwsVpcConfigurationAssignPublicIp']:
        """
        Whether the task's elastic network interface receives a public IP address. 
         Consider the following when you set this value:
          +  When you use ``create-service`` or ``update-service``, the default is ``DISABLED``. 
          +  When the service ``deploymentController`` is ``ECS``, the value must be ``DISABLED``.
        """
        return pulumi.get(self, "assign_public_ip")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[builtins.str]]:
        """
        The IDs of the security groups associated with the task or service. If you don't specify a security group, the default security group for the VPC is used. There's a limit of 5 security groups that can be specified.
          All specified security groups must be from the same VPC.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter
    def subnets(self) -> Optional[Sequence[builtins.str]]:
        """
        The IDs of the subnets associated with the task or service. There's a limit of 16 subnets that can be specified.
          All specified subnets must be from the same VPC.
        """
        return pulumi.get(self, "subnets")


@pulumi.output_type
class ServiceCapacityProviderStrategyItem(dict):
    """
    The details of a capacity provider strategy. A capacity provider strategy can be set when using the ``RunTask`` or ``CreateService`` APIs or as the default capacity provider strategy for a cluster with the ``CreateCluster`` API.
     Only capacity providers that are already associated with a cluster and have an ``ACTIVE`` or ``UPDATING`` status can be used in a capacity provider strategy. The ``PutClusterCapacityProviders`` API is used to associate a capacity provider with a cluster.
     If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New Auto Scaling group capacity providers can be created with the ``CreateCapacityProvider`` API operation.
     To use an FARGATElong capacity provider, specify either the ``FARGATE`` or ``FARGATE_SPOT`` capacity providers. The FARGATElong capacity providers are available to all accounts and only need to be associated with a cluster to be used in a capacity provider strategy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityProvider":
            suggest = "capacity_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceCapacityProviderStrategyItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceCapacityProviderStrategyItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceCapacityProviderStrategyItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base: Optional[builtins.int] = None,
                 capacity_provider: Optional[builtins.str] = None,
                 weight: Optional[builtins.int] = None):
        """
        The details of a capacity provider strategy. A capacity provider strategy can be set when using the ``RunTask`` or ``CreateService`` APIs or as the default capacity provider strategy for a cluster with the ``CreateCluster`` API.
         Only capacity providers that are already associated with a cluster and have an ``ACTIVE`` or ``UPDATING`` status can be used in a capacity provider strategy. The ``PutClusterCapacityProviders`` API is used to associate a capacity provider with a cluster.
         If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New Auto Scaling group capacity providers can be created with the ``CreateCapacityProvider`` API operation.
         To use an FARGATElong capacity provider, specify either the ``FARGATE`` or ``FARGATE_SPOT`` capacity providers. The FARGATElong capacity providers are available to all accounts and only need to be associated with a cluster to be used in a capacity provider strategy.
        :param builtins.int base: The *base* value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a *base* defined. If no value is specified, the default value of ``0`` is used.
        :param builtins.str capacity_provider: The short name of the capacity provider.
        :param builtins.int weight: The *weight* value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The ``weight`` value is taken into consideration after the ``base`` value, if defined, is satisfied.
                If no ``weight`` value is specified, the default value of ``0`` is used. When multiple capacity providers are specified within a capacity provider strategy, at least one of the capacity providers must have a weight value greater than zero and any capacity providers with a weight of ``0`` can't be used to place tasks. If you specify multiple capacity providers in a strategy that all have a weight of ``0``, any ``RunTask`` or ``CreateService`` actions using the capacity provider strategy will fail.
                An example scenario for using weights is defining a strategy that contains two capacity providers and both have a weight of ``1``, then when the ``base`` is satisfied, the tasks will be split evenly across the two capacity providers. Using that same logic, if you specify a weight of ``1`` for *capacityProviderA* and a weight of ``4`` for *capacityProviderB*, then for every one task that's run using *capacityProviderA*, four tasks would use *capacityProviderB*.
        """
        if base is not None:
            pulumi.set(__self__, "base", base)
        if capacity_provider is not None:
            pulumi.set(__self__, "capacity_provider", capacity_provider)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def base(self) -> Optional[builtins.int]:
        """
        The *base* value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a *base* defined. If no value is specified, the default value of ``0`` is used.
        """
        return pulumi.get(self, "base")

    @property
    @pulumi.getter(name="capacityProvider")
    def capacity_provider(self) -> Optional[builtins.str]:
        """
        The short name of the capacity provider.
        """
        return pulumi.get(self, "capacity_provider")

    @property
    @pulumi.getter
    def weight(self) -> Optional[builtins.int]:
        """
        The *weight* value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The ``weight`` value is taken into consideration after the ``base`` value, if defined, is satisfied.
         If no ``weight`` value is specified, the default value of ``0`` is used. When multiple capacity providers are specified within a capacity provider strategy, at least one of the capacity providers must have a weight value greater than zero and any capacity providers with a weight of ``0`` can't be used to place tasks. If you specify multiple capacity providers in a strategy that all have a weight of ``0``, any ``RunTask`` or ``CreateService`` actions using the capacity provider strategy will fail.
         An example scenario for using weights is defining a strategy that contains two capacity providers and both have a weight of ``1``, then when the ``base`` is satisfied, the tasks will be split evenly across the two capacity providers. Using that same logic, if you specify a weight of ``1`` for *capacityProviderA* and a weight of ``4`` for *capacityProviderB*, then for every one task that's run using *capacityProviderA*, four tasks would use *capacityProviderB*.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ServiceConnectClientAlias(dict):
    """
    Each alias ("endpoint") is a fully-qualified name and port number that other tasks ("clients") can use to connect to this service.
     Each name and port mapping must be unique within the namespace.
     Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsName":
            suggest = "dns_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceConnectClientAlias. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceConnectClientAlias.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceConnectClientAlias.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: builtins.int,
                 dns_name: Optional[builtins.str] = None):
        """
        Each alias ("endpoint") is a fully-qualified name and port number that other tasks ("clients") can use to connect to this service.
         Each name and port mapping must be unique within the namespace.
         Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param builtins.int port: The listening port number for the Service Connect proxy. This port is available inside of all of the tasks within the same namespace.
                To avoid changing your applications in client Amazon ECS services, set this to the same port that the client application uses by default. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param builtins.str dns_name: The ``dnsName`` is the name that you use in the applications of client tasks to connect to this service. The name must be a valid DNS name but doesn't need to be fully-qualified. The name can include up to 127 characters. The name can include lowercase letters, numbers, underscores (_), hyphens (-), and periods (.). The name can't start with a hyphen.
                If this parameter isn't specified, the default value of ``discoveryName.namespace`` is used. If the ``discoveryName`` isn't specified, the port mapping name from the task definition is used in ``portName.namespace``.
                To avoid changing your applications in client Amazon ECS services, set this to the same name that the client application uses by default. For example, a few common names are ``database``, ``db``, or the lowercase name of a database, such as ``mysql`` or ``redis``. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
        """
        pulumi.set(__self__, "port", port)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)

    @property
    @pulumi.getter
    def port(self) -> builtins.int:
        """
        The listening port number for the Service Connect proxy. This port is available inside of all of the tasks within the same namespace.
         To avoid changing your applications in client Amazon ECS services, set this to the same port that the client application uses by default. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[builtins.str]:
        """
        The ``dnsName`` is the name that you use in the applications of client tasks to connect to this service. The name must be a valid DNS name but doesn't need to be fully-qualified. The name can include up to 127 characters. The name can include lowercase letters, numbers, underscores (_), hyphens (-), and periods (.). The name can't start with a hyphen.
         If this parameter isn't specified, the default value of ``discoveryName.namespace`` is used. If the ``discoveryName`` isn't specified, the port mapping name from the task definition is used in ``portName.namespace``.
         To avoid changing your applications in client Amazon ECS services, set this to the same name that the client application uses by default. For example, a few common names are ``database``, ``db``, or the lowercase name of a database, such as ``mysql`` or ``redis``. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
        """
        return pulumi.get(self, "dns_name")


@pulumi.output_type
class ServiceConnectConfiguration(dict):
    """
    The Service Connect configuration of your Amazon ECS service. The configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace.
     Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logConfiguration":
            suggest = "log_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceConnectConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceConnectConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceConnectConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: builtins.bool,
                 log_configuration: Optional['outputs.ServiceLogConfiguration'] = None,
                 namespace: Optional[builtins.str] = None,
                 services: Optional[Sequence['outputs.ServiceConnectService']] = None):
        """
        The Service Connect configuration of your Amazon ECS service. The configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace.
         Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param builtins.bool enabled: Specifies whether to use Service Connect with this service.
        :param 'ServiceLogConfiguration' log_configuration: The log configuration for the container. This parameter maps to ``LogConfig`` in the docker container create command and the ``--log-driver`` option to docker run.
                By default, containers use the same logging driver that the Docker daemon uses. However, the container might use a different logging driver than the Docker daemon by specifying a log driver configuration in the container definition.
                Understand the following when specifying a log configuration for your containers.
                 +  Amazon ECS currently supports a subset of the logging drivers available to the Docker daemon. Additional log drivers may be available in future releases of the Amazon ECS container agent.
                For tasks on FARGATElong, the supported log drivers are ``awslogs``, ``splunk``, and ``awsfirelens``.
                For tasks hosted on Amazon EC2 instances, the supported log drivers are ``awslogs``, ``fluentd``, ``gelf``, ``json-file``, ``journald``,``syslog``, ``splunk``, and ``awsfirelens``.
                 +  This parameter requires version 1.18 of the Docker Remote API or greater on your container instance.
                 +  For tasks that are hosted on Amazon EC2 instances, the Amazon ECS container agent must register the available logging drivers with the ``ECS_AVAILABLE_LOGGING_DRIVERS`` environment variable before containers placed on that instance can use these log configuration options. For more information, see [Amazon ECS container agent configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide*.
                 +  For tasks that are on FARGATElong, because you don't have access to the underlying infrastructure your tasks are hosted on, any additional software needed must be installed outside of the task. For example, the Fluentd output aggregators or a remote host running Logstash to send Gelf logs to.
        :param builtins.str namespace: The namespace name or full Amazon Resource Name (ARN) of the CMAPlong namespace for use with Service Connect. The namespace must be in the same AWS Region as the Amazon ECS service and cluster. The type of namespace doesn't affect Service Connect. For more information about CMAPlong, see [Working with Services](https://docs.aws.amazon.com/cloud-map/latest/dg/working-with-services.html) in the *Developer Guide*.
        :param Sequence['ServiceConnectService'] services: The list of Service Connect service objects. These are names and aliases (also known as endpoints) that are used by other Amazon ECS services to connect to this service. 
                This field is not required for a "client" Amazon ECS service that's a member of a namespace only to connect to other services within the namespace. An example of this would be a frontend application that accepts incoming requests from either a load balancer that's attached to the service or by other means.
                An object selects a port from the task definition, assigns a name for the CMAPlong service, and a list of aliases (endpoints) and ports for client applications to refer to this service.
        """
        pulumi.set(__self__, "enabled", enabled)
        if log_configuration is not None:
            pulumi.set(__self__, "log_configuration", log_configuration)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if services is not None:
            pulumi.set(__self__, "services", services)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Specifies whether to use Service Connect with this service.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="logConfiguration")
    def log_configuration(self) -> Optional['outputs.ServiceLogConfiguration']:
        """
        The log configuration for the container. This parameter maps to ``LogConfig`` in the docker container create command and the ``--log-driver`` option to docker run.
         By default, containers use the same logging driver that the Docker daemon uses. However, the container might use a different logging driver than the Docker daemon by specifying a log driver configuration in the container definition.
         Understand the following when specifying a log configuration for your containers.
          +  Amazon ECS currently supports a subset of the logging drivers available to the Docker daemon. Additional log drivers may be available in future releases of the Amazon ECS container agent.
         For tasks on FARGATElong, the supported log drivers are ``awslogs``, ``splunk``, and ``awsfirelens``.
         For tasks hosted on Amazon EC2 instances, the supported log drivers are ``awslogs``, ``fluentd``, ``gelf``, ``json-file``, ``journald``,``syslog``, ``splunk``, and ``awsfirelens``.
          +  This parameter requires version 1.18 of the Docker Remote API or greater on your container instance.
          +  For tasks that are hosted on Amazon EC2 instances, the Amazon ECS container agent must register the available logging drivers with the ``ECS_AVAILABLE_LOGGING_DRIVERS`` environment variable before containers placed on that instance can use these log configuration options. For more information, see [Amazon ECS container agent configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide*.
          +  For tasks that are on FARGATElong, because you don't have access to the underlying infrastructure your tasks are hosted on, any additional software needed must be installed outside of the task. For example, the Fluentd output aggregators or a remote host running Logstash to send Gelf logs to.
        """
        return pulumi.get(self, "log_configuration")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[builtins.str]:
        """
        The namespace name or full Amazon Resource Name (ARN) of the CMAPlong namespace for use with Service Connect. The namespace must be in the same AWS Region as the Amazon ECS service and cluster. The type of namespace doesn't affect Service Connect. For more information about CMAPlong, see [Working with Services](https://docs.aws.amazon.com/cloud-map/latest/dg/working-with-services.html) in the *Developer Guide*.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def services(self) -> Optional[Sequence['outputs.ServiceConnectService']]:
        """
        The list of Service Connect service objects. These are names and aliases (also known as endpoints) that are used by other Amazon ECS services to connect to this service. 
         This field is not required for a "client" Amazon ECS service that's a member of a namespace only to connect to other services within the namespace. An example of this would be a frontend application that accepts incoming requests from either a load balancer that's attached to the service or by other means.
         An object selects a port from the task definition, assigns a name for the CMAPlong service, and a list of aliases (endpoints) and ports for client applications to refer to this service.
        """
        return pulumi.get(self, "services")


@pulumi.output_type
class ServiceConnectService(dict):
    """
    The Service Connect service object configuration. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "portName":
            suggest = "port_name"
        elif key == "clientAliases":
            suggest = "client_aliases"
        elif key == "discoveryName":
            suggest = "discovery_name"
        elif key == "ingressPortOverride":
            suggest = "ingress_port_override"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceConnectService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceConnectService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceConnectService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port_name: builtins.str,
                 client_aliases: Optional[Sequence['outputs.ServiceConnectClientAlias']] = None,
                 discovery_name: Optional[builtins.str] = None,
                 ingress_port_override: Optional[builtins.int] = None,
                 timeout: Optional['outputs.ServiceTimeoutConfiguration'] = None,
                 tls: Optional['outputs.ServiceConnectTlsConfiguration'] = None):
        """
        The Service Connect service object configuration. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param builtins.str port_name: The ``portName`` must match the name of one of the ``portMappings`` from all the containers in the task definition of this Amazon ECS service.
        :param Sequence['ServiceConnectClientAlias'] client_aliases: The list of client aliases for this Service Connect service. You use these to assign names that can be used by client applications. The maximum number of client aliases that you can have in this list is 1.
                Each alias ("endpoint") is a fully-qualified name and port number that other Amazon ECS tasks ("clients") can use to connect to this service.
                Each name and port mapping must be unique within the namespace.
                For each ``ServiceConnectService``, you must provide at least one ``clientAlias`` with one ``port``.
        :param builtins.str discovery_name: The ``discoveryName`` is the name of the new CMAP service that Amazon ECS creates for this Amazon ECS service. This must be unique within the CMAP namespace. The name can contain up to 64 characters. The name can include lowercase letters, numbers, underscores (_), and hyphens (-). The name can't start with a hyphen.
                If the ``discoveryName`` isn't specified, the port mapping name from the task definition is used in ``portName.namespace``.
        :param builtins.int ingress_port_override: The port number for the Service Connect proxy to listen on.
                Use the value of this field to bypass the proxy for traffic on the port number specified in the named ``portMapping`` in the task definition of this application, and then use it in your VPC security groups to allow traffic into the proxy for this Amazon ECS service.
                In ``awsvpc`` mode and Fargate, the default value is the container port number. The container port number is in the ``portMapping`` in the task definition. In bridge mode, the default value is the ephemeral port of the Service Connect proxy.
        :param 'ServiceTimeoutConfiguration' timeout: A reference to an object that represents the configured timeouts for Service Connect.
        :param 'ServiceConnectTlsConfiguration' tls: A reference to an object that represents a Transport Layer Security (TLS) configuration.
        """
        pulumi.set(__self__, "port_name", port_name)
        if client_aliases is not None:
            pulumi.set(__self__, "client_aliases", client_aliases)
        if discovery_name is not None:
            pulumi.set(__self__, "discovery_name", discovery_name)
        if ingress_port_override is not None:
            pulumi.set(__self__, "ingress_port_override", ingress_port_override)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> builtins.str:
        """
        The ``portName`` must match the name of one of the ``portMappings`` from all the containers in the task definition of this Amazon ECS service.
        """
        return pulumi.get(self, "port_name")

    @property
    @pulumi.getter(name="clientAliases")
    def client_aliases(self) -> Optional[Sequence['outputs.ServiceConnectClientAlias']]:
        """
        The list of client aliases for this Service Connect service. You use these to assign names that can be used by client applications. The maximum number of client aliases that you can have in this list is 1.
         Each alias ("endpoint") is a fully-qualified name and port number that other Amazon ECS tasks ("clients") can use to connect to this service.
         Each name and port mapping must be unique within the namespace.
         For each ``ServiceConnectService``, you must provide at least one ``clientAlias`` with one ``port``.
        """
        return pulumi.get(self, "client_aliases")

    @property
    @pulumi.getter(name="discoveryName")
    def discovery_name(self) -> Optional[builtins.str]:
        """
        The ``discoveryName`` is the name of the new CMAP service that Amazon ECS creates for this Amazon ECS service. This must be unique within the CMAP namespace. The name can contain up to 64 characters. The name can include lowercase letters, numbers, underscores (_), and hyphens (-). The name can't start with a hyphen.
         If the ``discoveryName`` isn't specified, the port mapping name from the task definition is used in ``portName.namespace``.
        """
        return pulumi.get(self, "discovery_name")

    @property
    @pulumi.getter(name="ingressPortOverride")
    def ingress_port_override(self) -> Optional[builtins.int]:
        """
        The port number for the Service Connect proxy to listen on.
         Use the value of this field to bypass the proxy for traffic on the port number specified in the named ``portMapping`` in the task definition of this application, and then use it in your VPC security groups to allow traffic into the proxy for this Amazon ECS service.
         In ``awsvpc`` mode and Fargate, the default value is the container port number. The container port number is in the ``portMapping`` in the task definition. In bridge mode, the default value is the ephemeral port of the Service Connect proxy.
        """
        return pulumi.get(self, "ingress_port_override")

    @property
    @pulumi.getter
    def timeout(self) -> Optional['outputs.ServiceTimeoutConfiguration']:
        """
        A reference to an object that represents the configured timeouts for Service Connect.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def tls(self) -> Optional['outputs.ServiceConnectTlsConfiguration']:
        """
        A reference to an object that represents a Transport Layer Security (TLS) configuration.
        """
        return pulumi.get(self, "tls")


@pulumi.output_type
class ServiceConnectTlsCertificateAuthority(dict):
    """
    The certificate root authority that secures your service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsPcaAuthorityArn":
            suggest = "aws_pca_authority_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceConnectTlsCertificateAuthority. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceConnectTlsCertificateAuthority.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceConnectTlsCertificateAuthority.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_pca_authority_arn: Optional[builtins.str] = None):
        """
        The certificate root authority that secures your service.
        :param builtins.str aws_pca_authority_arn: The ARN of the AWS Private Certificate Authority certificate.
        """
        if aws_pca_authority_arn is not None:
            pulumi.set(__self__, "aws_pca_authority_arn", aws_pca_authority_arn)

    @property
    @pulumi.getter(name="awsPcaAuthorityArn")
    def aws_pca_authority_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the AWS Private Certificate Authority certificate.
        """
        return pulumi.get(self, "aws_pca_authority_arn")


@pulumi.output_type
class ServiceConnectTlsConfiguration(dict):
    """
    The key that encrypts and decrypts your resources for Service Connect TLS.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "issuerCertificateAuthority":
            suggest = "issuer_certificate_authority"
        elif key == "kmsKey":
            suggest = "kms_key"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceConnectTlsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceConnectTlsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceConnectTlsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 issuer_certificate_authority: 'outputs.ServiceConnectTlsCertificateAuthority',
                 kms_key: Optional[builtins.str] = None,
                 role_arn: Optional[builtins.str] = None):
        """
        The key that encrypts and decrypts your resources for Service Connect TLS.
        :param 'ServiceConnectTlsCertificateAuthority' issuer_certificate_authority: The signer certificate authority.
        :param builtins.str kms_key: The AWS Key Management Service key.
        :param builtins.str role_arn: The Amazon Resource Name (ARN) of the IAM role that's associated with the Service Connect TLS.
        """
        pulumi.set(__self__, "issuer_certificate_authority", issuer_certificate_authority)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="issuerCertificateAuthority")
    def issuer_certificate_authority(self) -> 'outputs.ServiceConnectTlsCertificateAuthority':
        """
        The signer certificate authority.
        """
        return pulumi.get(self, "issuer_certificate_authority")

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[builtins.str]:
        """
        The AWS Key Management Service key.
        """
        return pulumi.get(self, "kms_key")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the IAM role that's associated with the Service Connect TLS.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class ServiceDeploymentAlarms(dict):
    """
    One of the methods which provide a way for you to quickly identify when a deployment has failed, and then to optionally roll back the failure to the last working deployment.
     When the alarms are generated, Amazon ECS sets the service deployment to failed. Set the rollback parameter to have Amazon ECS to roll back your service to the last completed deployment after a failure.
     You can only use the ``DeploymentAlarms`` method to detect failures when the ``DeploymentController`` is set to ``ECS`` (rolling update).
     For more information, see [Rolling update](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-ecs.html) in the *Amazon Elastic Container Service Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alarmNames":
            suggest = "alarm_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceDeploymentAlarms. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceDeploymentAlarms.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceDeploymentAlarms.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarm_names: Sequence[builtins.str],
                 enable: builtins.bool,
                 rollback: builtins.bool):
        """
        One of the methods which provide a way for you to quickly identify when a deployment has failed, and then to optionally roll back the failure to the last working deployment.
         When the alarms are generated, Amazon ECS sets the service deployment to failed. Set the rollback parameter to have Amazon ECS to roll back your service to the last completed deployment after a failure.
         You can only use the ``DeploymentAlarms`` method to detect failures when the ``DeploymentController`` is set to ``ECS`` (rolling update).
         For more information, see [Rolling update](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-ecs.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param Sequence[builtins.str] alarm_names: One or more CloudWatch alarm names. Use a "," to separate the alarms.
        :param builtins.bool enable: Determines whether to use the CloudWatch alarm option in the service deployment process.
        :param builtins.bool rollback: Determines whether to configure Amazon ECS to roll back the service if a service deployment fails. If rollback is used, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
        """
        pulumi.set(__self__, "alarm_names", alarm_names)
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "rollback", rollback)

    @property
    @pulumi.getter(name="alarmNames")
    def alarm_names(self) -> Sequence[builtins.str]:
        """
        One or more CloudWatch alarm names. Use a "," to separate the alarms.
        """
        return pulumi.get(self, "alarm_names")

    @property
    @pulumi.getter
    def enable(self) -> builtins.bool:
        """
        Determines whether to use the CloudWatch alarm option in the service deployment process.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def rollback(self) -> builtins.bool:
        """
        Determines whether to configure Amazon ECS to roll back the service if a service deployment fails. If rollback is used, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
        """
        return pulumi.get(self, "rollback")


@pulumi.output_type
class ServiceDeploymentCircuitBreaker(dict):
    """
    The deployment circuit breaker can only be used for services using the rolling update (``ECS``) deployment type.
      The *deployment circuit breaker* determines whether a service deployment will fail if the service can't reach a steady state. If it is turned on, a service deployment will transition to a failed state and stop launching new tasks. You can also configure Amazon ECS to roll back your service to the last completed deployment after a failure. For more information, see [Rolling update](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-ecs.html) in the *Amazon Elastic Container Service Developer Guide*.
     For more information about API failure reasons, see [API failure reasons](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/api_failures_messages.html) in the *Amazon Elastic Container Service Developer Guide*.
    """
    def __init__(__self__, *,
                 enable: builtins.bool,
                 rollback: builtins.bool):
        """
        The deployment circuit breaker can only be used for services using the rolling update (``ECS``) deployment type.
          The *deployment circuit breaker* determines whether a service deployment will fail if the service can't reach a steady state. If it is turned on, a service deployment will transition to a failed state and stop launching new tasks. You can also configure Amazon ECS to roll back your service to the last completed deployment after a failure. For more information, see [Rolling update](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-ecs.html) in the *Amazon Elastic Container Service Developer Guide*.
         For more information about API failure reasons, see [API failure reasons](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/api_failures_messages.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param builtins.bool enable: Determines whether to use the deployment circuit breaker logic for the service.
        :param builtins.bool rollback: Determines whether to configure Amazon ECS to roll back the service if a service deployment fails. If rollback is on, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
        """
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "rollback", rollback)

    @property
    @pulumi.getter
    def enable(self) -> builtins.bool:
        """
        Determines whether to use the deployment circuit breaker logic for the service.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def rollback(self) -> builtins.bool:
        """
        Determines whether to configure Amazon ECS to roll back the service if a service deployment fails. If rollback is on, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
        """
        return pulumi.get(self, "rollback")


@pulumi.output_type
class ServiceDeploymentConfiguration(dict):
    """
    Optional deployment parameters that control how many tasks run during a deployment and the ordering of stopping and starting tasks.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deploymentCircuitBreaker":
            suggest = "deployment_circuit_breaker"
        elif key == "maximumPercent":
            suggest = "maximum_percent"
        elif key == "minimumHealthyPercent":
            suggest = "minimum_healthy_percent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceDeploymentConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceDeploymentConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceDeploymentConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarms: Optional['outputs.ServiceDeploymentAlarms'] = None,
                 deployment_circuit_breaker: Optional['outputs.ServiceDeploymentCircuitBreaker'] = None,
                 maximum_percent: Optional[builtins.int] = None,
                 minimum_healthy_percent: Optional[builtins.int] = None):
        """
        Optional deployment parameters that control how many tasks run during a deployment and the ordering of stopping and starting tasks.
        :param 'ServiceDeploymentAlarms' alarms: Information about the CloudWatch alarms.
        :param 'ServiceDeploymentCircuitBreaker' deployment_circuit_breaker: The deployment circuit breaker can only be used for services using the rolling update (``ECS``) deployment type.
                 The *deployment circuit breaker* determines whether a service deployment will fail if the service can't reach a steady state. If you use the deployment circuit breaker, a service deployment will transition to a failed state and stop launching new tasks. If you use the rollback option, when a service deployment fails, the service is rolled back to the last deployment that completed successfully. For more information, see [Rolling update](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-ecs.html) in the *Amazon Elastic Container Service Developer Guide*
        :param builtins.int maximum_percent: If a service is using the rolling update (``ECS``) deployment type, the ``maximumPercent`` parameter represents an upper limit on the number of your service's tasks that are allowed in the ``RUNNING`` or ``PENDING`` state during a deployment, as a percentage of the ``desiredCount`` (rounded down to the nearest integer). This parameter enables you to define the deployment batch size. For example, if your service is using the ``REPLICA`` service scheduler and has a ``desiredCount`` of four tasks and a ``maximumPercent`` value of 200%, the scheduler may start four new tasks before stopping the four older tasks (provided that the cluster resources required to do this are available). The default ``maximumPercent`` value for a service using the ``REPLICA`` service scheduler is 200%.
                The Amazon ECS scheduler uses this parameter to replace unhealthy tasks by starting replacement tasks first and then stopping the unhealthy tasks, as long as cluster resources for starting replacement tasks are available. For more information about how the scheduler replaces unhealthy tasks, see [Amazon ECS services](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html).
                If a service is using either the blue/green (``CODE_DEPLOY``) or ``EXTERNAL`` deployment types, and tasks in the service use the EC2 launch type, the *maximum percent* value is set to the default value. The *maximum percent* value is used to define the upper limit on the number of the tasks in the service that remain in the ``RUNNING`` state while the container instances are in the ``DRAINING`` state.
                 You can't specify a custom ``maximumPercent`` value for a service that uses either the blue/green (``CODE_DEPLOY``) or ``EXTERNAL`` deployment types and has tasks that use the EC2 launch type.
                 If the service uses either the blue/green (``CODE_DEPLOY``) or ``EXTERNAL`` deployment types, and the tasks in the service use the Fargate launch type, the maximum percent value is not used. The value is still returned when describing your service.
        :param builtins.int minimum_healthy_percent: If a service is using the rolling update (``ECS``) deployment type, the ``minimumHealthyPercent`` represents a lower limit on the number of your service's tasks that must remain in the ``RUNNING`` state during a deployment, as a percentage of the ``desiredCount`` (rounded up to the nearest integer). This parameter enables you to deploy without using additional cluster capacity. For example, if your service has a ``desiredCount`` of four tasks and a ``minimumHealthyPercent`` of 50%, the service scheduler may stop two existing tasks to free up cluster capacity before starting two new tasks. 
                 If any tasks are unhealthy and if ``maximumPercent`` doesn't allow the Amazon ECS scheduler to start replacement tasks, the scheduler stops the unhealthy tasks one-by-one — using the ``minimumHealthyPercent`` as a constraint — to clear up capacity to launch replacement tasks. For more information about how the scheduler replaces unhealthy tasks, see [Amazon ECS services](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html) . 
                For services that *do not* use a load balancer, the following should be noted:
                 +  A service is considered healthy if all essential containers within the tasks in the service pass their health checks.
                 +  If a task has no essential containers with a health check defined, the service scheduler will wait for 40 seconds after a task reaches a ``RUNNING`` state before the task is counted towards the minimum healthy percent total.
                 +  If a task has one or more essential containers with a health check defined, the service scheduler will wait for the task to reach a healthy status before counting it towards the minimum healthy percent total. A task is considered healthy when all essential containers within the task have passed their health checks. The amount of time the service scheduler can wait for is determined by the container health check settings. 
                 
                For services that *do* use a load balancer, the following should be noted:
                 +  If a task has no essential containers with a health check defined, the service scheduler will wait for the load balancer target group health check to return a healthy status before counting the task towards the minimum healthy percent total.
                 +  If a task has an essential container with a health check defined, the service scheduler will wait for both the task to reach a healthy status and the load balancer target group health check to return a healthy status before counting the task towards the minimum healthy percent total.
                 
                The default value for a replica service for ``minimumHealthyPercent`` is 100%. The default ``minimumHealthyPercent`` value for a service using the ``DAEMON`` service schedule is 0% for the CLI, the AWS SDKs, and the APIs and 50% for the AWS Management Console.
                The minimum number of healthy tasks during a deployment is the ``desiredCount`` multiplied by the ``minimumHealthyPercent``/100, rounded up to the nearest integer value.
                If a service is using either the blue/green (``CODE_DEPLOY``) or ``EXTERNAL`` deployment types and is running tasks that use the EC2 launch type, the *minimum healthy percent* value is set to the default value. The *minimum healthy percent* value is used to define the lower limit on the number of the tasks in the service that remain in the ``RUNNING`` state while the container instances are in the ``DRAINING`` state.
                 You can't specify a custom ``minimumHealthyPercent`` value for a service that uses either the blue/green (``CODE_DEPLOY``) or ``EXTERNAL`` deployment types and has tasks that use the EC2 launch type.
                 If a service is using either the blue/green (``CODE_DEPLOY``) or ``EXTERNAL`` deployment types and is running tasks that use the Fargate launch type, the minimum healthy percent value is not used, although it is returned when describing your service.
        """
        if alarms is not None:
            pulumi.set(__self__, "alarms", alarms)
        if deployment_circuit_breaker is not None:
            pulumi.set(__self__, "deployment_circuit_breaker", deployment_circuit_breaker)
        if maximum_percent is not None:
            pulumi.set(__self__, "maximum_percent", maximum_percent)
        if minimum_healthy_percent is not None:
            pulumi.set(__self__, "minimum_healthy_percent", minimum_healthy_percent)

    @property
    @pulumi.getter
    def alarms(self) -> Optional['outputs.ServiceDeploymentAlarms']:
        """
        Information about the CloudWatch alarms.
        """
        return pulumi.get(self, "alarms")

    @property
    @pulumi.getter(name="deploymentCircuitBreaker")
    def deployment_circuit_breaker(self) -> Optional['outputs.ServiceDeploymentCircuitBreaker']:
        """
        The deployment circuit breaker can only be used for services using the rolling update (``ECS``) deployment type.
          The *deployment circuit breaker* determines whether a service deployment will fail if the service can't reach a steady state. If you use the deployment circuit breaker, a service deployment will transition to a failed state and stop launching new tasks. If you use the rollback option, when a service deployment fails, the service is rolled back to the last deployment that completed successfully. For more information, see [Rolling update](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-ecs.html) in the *Amazon Elastic Container Service Developer Guide*
        """
        return pulumi.get(self, "deployment_circuit_breaker")

    @property
    @pulumi.getter(name="maximumPercent")
    def maximum_percent(self) -> Optional[builtins.int]:
        """
        If a service is using the rolling update (``ECS``) deployment type, the ``maximumPercent`` parameter represents an upper limit on the number of your service's tasks that are allowed in the ``RUNNING`` or ``PENDING`` state during a deployment, as a percentage of the ``desiredCount`` (rounded down to the nearest integer). This parameter enables you to define the deployment batch size. For example, if your service is using the ``REPLICA`` service scheduler and has a ``desiredCount`` of four tasks and a ``maximumPercent`` value of 200%, the scheduler may start four new tasks before stopping the four older tasks (provided that the cluster resources required to do this are available). The default ``maximumPercent`` value for a service using the ``REPLICA`` service scheduler is 200%.
         The Amazon ECS scheduler uses this parameter to replace unhealthy tasks by starting replacement tasks first and then stopping the unhealthy tasks, as long as cluster resources for starting replacement tasks are available. For more information about how the scheduler replaces unhealthy tasks, see [Amazon ECS services](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html).
         If a service is using either the blue/green (``CODE_DEPLOY``) or ``EXTERNAL`` deployment types, and tasks in the service use the EC2 launch type, the *maximum percent* value is set to the default value. The *maximum percent* value is used to define the upper limit on the number of the tasks in the service that remain in the ``RUNNING`` state while the container instances are in the ``DRAINING`` state.
          You can't specify a custom ``maximumPercent`` value for a service that uses either the blue/green (``CODE_DEPLOY``) or ``EXTERNAL`` deployment types and has tasks that use the EC2 launch type.
          If the service uses either the blue/green (``CODE_DEPLOY``) or ``EXTERNAL`` deployment types, and the tasks in the service use the Fargate launch type, the maximum percent value is not used. The value is still returned when describing your service.
        """
        return pulumi.get(self, "maximum_percent")

    @property
    @pulumi.getter(name="minimumHealthyPercent")
    def minimum_healthy_percent(self) -> Optional[builtins.int]:
        """
        If a service is using the rolling update (``ECS``) deployment type, the ``minimumHealthyPercent`` represents a lower limit on the number of your service's tasks that must remain in the ``RUNNING`` state during a deployment, as a percentage of the ``desiredCount`` (rounded up to the nearest integer). This parameter enables you to deploy without using additional cluster capacity. For example, if your service has a ``desiredCount`` of four tasks and a ``minimumHealthyPercent`` of 50%, the service scheduler may stop two existing tasks to free up cluster capacity before starting two new tasks. 
          If any tasks are unhealthy and if ``maximumPercent`` doesn't allow the Amazon ECS scheduler to start replacement tasks, the scheduler stops the unhealthy tasks one-by-one — using the ``minimumHealthyPercent`` as a constraint — to clear up capacity to launch replacement tasks. For more information about how the scheduler replaces unhealthy tasks, see [Amazon ECS services](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html) . 
         For services that *do not* use a load balancer, the following should be noted:
          +  A service is considered healthy if all essential containers within the tasks in the service pass their health checks.
          +  If a task has no essential containers with a health check defined, the service scheduler will wait for 40 seconds after a task reaches a ``RUNNING`` state before the task is counted towards the minimum healthy percent total.
          +  If a task has one or more essential containers with a health check defined, the service scheduler will wait for the task to reach a healthy status before counting it towards the minimum healthy percent total. A task is considered healthy when all essential containers within the task have passed their health checks. The amount of time the service scheduler can wait for is determined by the container health check settings. 
          
         For services that *do* use a load balancer, the following should be noted:
          +  If a task has no essential containers with a health check defined, the service scheduler will wait for the load balancer target group health check to return a healthy status before counting the task towards the minimum healthy percent total.
          +  If a task has an essential container with a health check defined, the service scheduler will wait for both the task to reach a healthy status and the load balancer target group health check to return a healthy status before counting the task towards the minimum healthy percent total.
          
         The default value for a replica service for ``minimumHealthyPercent`` is 100%. The default ``minimumHealthyPercent`` value for a service using the ``DAEMON`` service schedule is 0% for the CLI, the AWS SDKs, and the APIs and 50% for the AWS Management Console.
         The minimum number of healthy tasks during a deployment is the ``desiredCount`` multiplied by the ``minimumHealthyPercent``/100, rounded up to the nearest integer value.
         If a service is using either the blue/green (``CODE_DEPLOY``) or ``EXTERNAL`` deployment types and is running tasks that use the EC2 launch type, the *minimum healthy percent* value is set to the default value. The *minimum healthy percent* value is used to define the lower limit on the number of the tasks in the service that remain in the ``RUNNING`` state while the container instances are in the ``DRAINING`` state.
          You can't specify a custom ``minimumHealthyPercent`` value for a service that uses either the blue/green (``CODE_DEPLOY``) or ``EXTERNAL`` deployment types and has tasks that use the EC2 launch type.
          If a service is using either the blue/green (``CODE_DEPLOY``) or ``EXTERNAL`` deployment types and is running tasks that use the Fargate launch type, the minimum healthy percent value is not used, although it is returned when describing your service.
        """
        return pulumi.get(self, "minimum_healthy_percent")


@pulumi.output_type
class ServiceDeploymentController(dict):
    """
    The deployment controller to use for the service.
    """
    def __init__(__self__, *,
                 type: Optional['ServiceDeploymentControllerType'] = None):
        """
        The deployment controller to use for the service.
        :param 'ServiceDeploymentControllerType' type: The deployment controller type to use. There are three deployment controller types available:
                 + ECS The rolling update (ECS) deployment type involves replacing the current running version of the container with the latest version. The number of containers Amazon ECS adds or removes from the service during a rolling update is controlled by adjusting the minimum and maximum number of healthy tasks allowed during a service deployment, as specified in the DeploymentConfiguration. + CODE_DEPLOY The blue/green (CODE_DEPLOY) deployment type uses the blue/green deployment model powered by , which allows you to verify a new deployment of a service before sending production traffic to it. + EXTERNAL The external (EXTERNAL) deployment type enables you to use any third-party deployment controller for full control over the deployment process for an Amazon ECS service.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional['ServiceDeploymentControllerType']:
        """
        The deployment controller type to use. There are three deployment controller types available:
          + ECS The rolling update (ECS) deployment type involves replacing the current running version of the container with the latest version. The number of containers Amazon ECS adds or removes from the service during a rolling update is controlled by adjusting the minimum and maximum number of healthy tasks allowed during a service deployment, as specified in the DeploymentConfiguration. + CODE_DEPLOY The blue/green (CODE_DEPLOY) deployment type uses the blue/green deployment model powered by , which allows you to verify a new deployment of a service before sending production traffic to it. + EXTERNAL The external (EXTERNAL) deployment type enables you to use any third-party deployment controller for full control over the deployment process for an Amazon ECS service.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceEbsTagSpecification(dict):
    """
    The tag specifications of an Amazon EBS volume.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceType":
            suggest = "resource_type"
        elif key == "propagateTags":
            suggest = "propagate_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceEbsTagSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceEbsTagSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceEbsTagSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_type: builtins.str,
                 propagate_tags: Optional['ServiceEbsTagSpecificationPropagateTags'] = None,
                 tags: Optional[Sequence['outputs.ServiceTag']] = None):
        """
        The tag specifications of an Amazon EBS volume.
        :param builtins.str resource_type: The type of volume resource.
        :param 'ServiceEbsTagSpecificationPropagateTags' propagate_tags: Determines whether to propagate the tags from the task definition to 
               the Amazon EBS volume. Tags can only propagate to a ``SERVICE`` specified in 
               ``ServiceVolumeConfiguration``. If no value is specified, the tags aren't 
               propagated.
        :param Sequence['ServiceTag'] tags: The tags applied to this Amazon EBS volume. ``AmazonECSCreated`` and ``AmazonECSManaged`` are reserved tags that can't be used.
        """
        pulumi.set(__self__, "resource_type", resource_type)
        if propagate_tags is not None:
            pulumi.set(__self__, "propagate_tags", propagate_tags)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> builtins.str:
        """
        The type of volume resource.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="propagateTags")
    def propagate_tags(self) -> Optional['ServiceEbsTagSpecificationPropagateTags']:
        """
        Determines whether to propagate the tags from the task definition to 
        the Amazon EBS volume. Tags can only propagate to a ``SERVICE`` specified in 
        ``ServiceVolumeConfiguration``. If no value is specified, the tags aren't 
        propagated.
        """
        return pulumi.get(self, "propagate_tags")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.ServiceTag']]:
        """
        The tags applied to this Amazon EBS volume. ``AmazonECSCreated`` and ``AmazonECSManaged`` are reserved tags that can't be used.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ServiceLoadBalancer(dict):
    """
    The ``LoadBalancer`` property specifies details on a load balancer that is used with a service.
     If the service is using the ``CODE_DEPLOY`` deployment controller, the service is required to use either an Application Load Balancer or Network Load Balancer. When you are creating an ACDlong deployment group, you specify two target groups (referred to as a ``targetGroupPair``). Each target group binds to a separate task set in the deployment. The load balancer can also have up to two listeners, a required listener for production traffic and an optional listener that allows you to test new revisions of the service before routing production traffic to it.
     Services with tasks that use the ``awsvpc`` network mode (for example, those with the Fargate launch type) only support Application Load Balancers and Network Load Balancers. Classic Load Balancers are not supported. Also, when you create any target groups for these services, you must choose ``ip`` as the target type, not ``instance``. Tasks that use the ``awsvpc`` network mode are associated with an elastic network interface, not an Amazon EC2 instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"
        elif key == "containerPort":
            suggest = "container_port"
        elif key == "loadBalancerName":
            suggest = "load_balancer_name"
        elif key == "targetGroupArn":
            suggest = "target_group_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceLoadBalancer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceLoadBalancer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceLoadBalancer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_name: Optional[builtins.str] = None,
                 container_port: Optional[builtins.int] = None,
                 load_balancer_name: Optional[builtins.str] = None,
                 target_group_arn: Optional[builtins.str] = None):
        """
        The ``LoadBalancer`` property specifies details on a load balancer that is used with a service.
         If the service is using the ``CODE_DEPLOY`` deployment controller, the service is required to use either an Application Load Balancer or Network Load Balancer. When you are creating an ACDlong deployment group, you specify two target groups (referred to as a ``targetGroupPair``). Each target group binds to a separate task set in the deployment. The load balancer can also have up to two listeners, a required listener for production traffic and an optional listener that allows you to test new revisions of the service before routing production traffic to it.
         Services with tasks that use the ``awsvpc`` network mode (for example, those with the Fargate launch type) only support Application Load Balancers and Network Load Balancers. Classic Load Balancers are not supported. Also, when you create any target groups for these services, you must choose ``ip`` as the target type, not ``instance``. Tasks that use the ``awsvpc`` network mode are associated with an elastic network interface, not an Amazon EC2 instance.
        :param builtins.str container_name: The name of the container (as it appears in a container definition) to associate with the load balancer.
                You need to specify the container name when configuring the target group for an Amazon ECS load balancer.
        :param builtins.int container_port: The port on the container to associate with the load balancer. This port must correspond to a ``containerPort`` in the task definition the tasks in the service are using. For tasks that use the EC2 launch type, the container instance they're launched on must allow ingress traffic on the ``hostPort`` of the port mapping.
        :param builtins.str load_balancer_name: The name of the load balancer to associate with the Amazon ECS service or task set.
                If you are using an Application Load Balancer or a Network Load Balancer the load balancer name parameter should be omitted.
        :param builtins.str target_group_arn: The full Amazon Resource Name (ARN) of the Elastic Load Balancing target group or groups associated with a service or task set.
                A target group ARN is only specified when using an Application Load Balancer or Network Load Balancer. 
                For services using the ``ECS`` deployment controller, you can specify one or multiple target groups. For more information, see [Registering multiple target groups with a service](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html) in the *Amazon Elastic Container Service Developer Guide*.
                For services using the ``CODE_DEPLOY`` deployment controller, you're required to define two target groups for the load balancer. For more information, see [Blue/green deployment with CodeDeploy](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-bluegreen.html) in the *Amazon Elastic Container Service Developer Guide*.
                 If your service's task definition uses the ``awsvpc`` network mode, you must choose ``ip`` as the target type, not ``instance``. Do this when creating your target groups because tasks that use the ``awsvpc`` network mode are associated with an elastic network interface, not an Amazon EC2 instance. This network mode is required for the Fargate launch type.
        """
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if load_balancer_name is not None:
            pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        if target_group_arn is not None:
            pulumi.set(__self__, "target_group_arn", target_group_arn)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[builtins.str]:
        """
        The name of the container (as it appears in a container definition) to associate with the load balancer.
         You need to specify the container name when configuring the target group for an Amazon ECS load balancer.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[builtins.int]:
        """
        The port on the container to associate with the load balancer. This port must correspond to a ``containerPort`` in the task definition the tasks in the service are using. For tasks that use the EC2 launch type, the container instance they're launched on must allow ingress traffic on the ``hostPort`` of the port mapping.
        """
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> Optional[builtins.str]:
        """
        The name of the load balancer to associate with the Amazon ECS service or task set.
         If you are using an Application Load Balancer or a Network Load Balancer the load balancer name parameter should be omitted.
        """
        return pulumi.get(self, "load_balancer_name")

    @property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> Optional[builtins.str]:
        """
        The full Amazon Resource Name (ARN) of the Elastic Load Balancing target group or groups associated with a service or task set.
         A target group ARN is only specified when using an Application Load Balancer or Network Load Balancer. 
         For services using the ``ECS`` deployment controller, you can specify one or multiple target groups. For more information, see [Registering multiple target groups with a service](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html) in the *Amazon Elastic Container Service Developer Guide*.
         For services using the ``CODE_DEPLOY`` deployment controller, you're required to define two target groups for the load balancer. For more information, see [Blue/green deployment with CodeDeploy](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-bluegreen.html) in the *Amazon Elastic Container Service Developer Guide*.
          If your service's task definition uses the ``awsvpc`` network mode, you must choose ``ip`` as the target type, not ``instance``. Do this when creating your target groups because tasks that use the ``awsvpc`` network mode are associated with an elastic network interface, not an Amazon EC2 instance. This network mode is required for the Fargate launch type.
        """
        return pulumi.get(self, "target_group_arn")


@pulumi.output_type
class ServiceLogConfiguration(dict):
    """
    The log configuration for the container. This parameter maps to ``LogConfig`` in the docker container create command and the ``--log-driver`` option to docker run.
     By default, containers use the same logging driver that the Docker daemon uses. However, the container might use a different logging driver than the Docker daemon by specifying a log driver configuration in the container definition.
     Understand the following when specifying a log configuration for your containers.
      +  Amazon ECS currently supports a subset of the logging drivers available to the Docker daemon. Additional log drivers may be available in future releases of the Amazon ECS container agent.
     For tasks on FARGATElong, the supported log drivers are ``awslogs``, ``splunk``, and ``awsfirelens``.
     For tasks hosted on Amazon EC2 instances, the supported log drivers are ``awslogs``, ``fluentd``, ``gelf``, ``json-file``, ``journald``,``syslog``, ``splunk``, and ``awsfirelens``.
      +  This parameter requires version 1.18 of the Docker Remote API or greater on your container instance.
      +  For tasks that are hosted on Amazon EC2 instances, the Amazon ECS container agent must register the available logging drivers with the ``ECS_AVAILABLE_LOGGING_DRIVERS`` environment variable before containers placed on that instance can use these log configuration options. For more information, see [Amazon ECS container agent configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide*.
      +  For tasks that are on FARGATElong, because you don't have access to the underlying infrastructure your tasks are hosted on, any additional software needed must be installed outside of the task. For example, the Fluentd output aggregators or a remote host running Logstash to send Gelf logs to.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logDriver":
            suggest = "log_driver"
        elif key == "secretOptions":
            suggest = "secret_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceLogConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceLogConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceLogConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_driver: Optional[builtins.str] = None,
                 options: Optional[Mapping[str, builtins.str]] = None,
                 secret_options: Optional[Sequence['outputs.ServiceSecret']] = None):
        """
        The log configuration for the container. This parameter maps to ``LogConfig`` in the docker container create command and the ``--log-driver`` option to docker run.
         By default, containers use the same logging driver that the Docker daemon uses. However, the container might use a different logging driver than the Docker daemon by specifying a log driver configuration in the container definition.
         Understand the following when specifying a log configuration for your containers.
          +  Amazon ECS currently supports a subset of the logging drivers available to the Docker daemon. Additional log drivers may be available in future releases of the Amazon ECS container agent.
         For tasks on FARGATElong, the supported log drivers are ``awslogs``, ``splunk``, and ``awsfirelens``.
         For tasks hosted on Amazon EC2 instances, the supported log drivers are ``awslogs``, ``fluentd``, ``gelf``, ``json-file``, ``journald``,``syslog``, ``splunk``, and ``awsfirelens``.
          +  This parameter requires version 1.18 of the Docker Remote API or greater on your container instance.
          +  For tasks that are hosted on Amazon EC2 instances, the Amazon ECS container agent must register the available logging drivers with the ``ECS_AVAILABLE_LOGGING_DRIVERS`` environment variable before containers placed on that instance can use these log configuration options. For more information, see [Amazon ECS container agent configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide*.
          +  For tasks that are on FARGATElong, because you don't have access to the underlying infrastructure your tasks are hosted on, any additional software needed must be installed outside of the task. For example, the Fluentd output aggregators or a remote host running Logstash to send Gelf logs to.
        :param builtins.str log_driver: The log driver to use for the container.
                For tasks on FARGATElong, the supported log drivers are ``awslogs``, ``splunk``, and ``awsfirelens``.
                For tasks hosted on Amazon EC2 instances, the supported log drivers are ``awslogs``, ``fluentd``, ``gelf``, ``json-file``, ``journald``, ``syslog``, ``splunk``, and ``awsfirelens``.
                For more information about using the ``awslogs`` log driver, see [Send Amazon ECS logs to CloudWatch](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_awslogs.html) in the *Amazon Elastic Container Service Developer Guide*.
                For more information about using the ``awsfirelens`` log driver, see [Send Amazon ECS logs to an service or Partner](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html).
                 If you have a custom driver that isn't listed, you can fork the Amazon ECS container agent project that's [available on GitHub](https://docs.aws.amazon.com/https://github.com/aws/amazon-ecs-agent) and customize it to work with that driver. We encourage you to submit pull requests for changes that you would like to have included. However, we don't currently provide support for running modified copies of this software.
        :param Mapping[str, builtins.str] options: The configuration options to send to the log driver.
                The options you can specify depend on the log driver. Some of the options you can specify when you use the ``awslogs`` log driver to route logs to Amazon CloudWatch include the following:
                 + awslogs-create-group Required: No Specify whether you want the log group to be created automatically. If this option isn't specified, it defaults to false. Your IAM policy must include the logs:CreateLogGroup permission before you attempt to use awslogs-create-group. + awslogs-region Required: Yes Specify the Region that the awslogs log driver is to send your Docker logs to. You can choose to send all of your logs from clusters in different Regions to a single region in CloudWatch Logs. This is so that they're all visible in one location. Otherwise, you can separate them by Region for more granularity. Make sure that the specified log group exists in the Region that you specify with this option. + awslogs-group Required: Yes Make sure to specify a log group that the awslogs log driver sends its log streams to. + awslogs-stream-prefix Required: Yes, when using Fargate.Optional when using EC2. Use the awslogs-stream-prefix option to associate a log stream with the specified prefix, the container name, and the ID of the Amazon ECS task that the container belongs to. If you specify a prefix with this option, then the log stream takes the format prefix-name/container-name/ecs-task-id. If you don't specify a prefix with this option, then the log stream is named after the container ID that's assigned by the Docker daemon on the container instance. Because it's difficult to trace logs back to the container that sent them with just the Docker container ID (which is only available on the container instance), we recommend that you specify a prefix with this option. For Amazon ECS services, you can use the service name as the prefix. Doing so, you can trace log streams to the service that the container belongs to, the name of the container that sent them, and the ID of the task that the container belongs to. You must specify a stream-prefix for your logs to have your logs appear in the Log pane when using the Amazon ECS console. + awslogs-datetime-format Required: No This option defines a multiline start pattern in Python strftime format. A log message consists of a line that matches the pattern and any following lines that don’t match the pattern. The matched line is the delimiter between log messages. One example of a use case for using this format is for parsing output such as a stack dump, which might otherwise be logged in multiple entries. The correct pattern allows it to be captured in a single entry. For more information, see awslogs-datetime-format. You cannot configure both the awslogs-datetime-format and awslogs-multiline-pattern options. Multiline logging performs regular expression parsing and matching of all log messages. This might have a negative impact on logging performance. + awslogs-multiline-pattern Required: No This option defines a multiline start pattern that uses a regular expression. A log message consists of a line that matches the pattern and any following lines that don’t match the pattern. The matched line is the delimiter between log messages. For more information, see awslogs-multiline-pattern. This option is ignored if awslogs-datetime-format is also configured. You cannot configure both the awslogs-datetime-format and awslogs-multiline-pattern options. Multiline logging performs regular expression parsing and matching of all log messages. This might have a negative impact on logging performance. 
                The following options apply to all supported log drivers.
                 + mode Required: No Valid values: non-blocking | blocking This option defines the delivery mode of log messages from the container to the log driver specified using logDriver. The delivery mode you choose affects application availability when the flow of logs from container is interrupted. If you use the blocking mode and the flow of logs is interrupted, calls from container code to write to the stdout and stderr streams will block. The logging thread of the application will block as a result. This may cause the application to become unresponsive and lead to container healthcheck failure. If you use the non-blocking mode, the container's logs are instead stored in an in-memory intermediate buffer configured with the max-buffer-size option. This prevents the application from becoming unresponsive when logs cannot be sent. We recommend using this mode if you want to ensure service availability and are okay with some log loss. For more information, see Preventing log loss with non-blocking mode in the awslogs container log driver. You can set a default mode for all containers in a specific Region by using the defaultLogDriverMode account setting. If you don't specify the mode option or configure the account setting, Amazon ECS will default to the blocking mode. For more information about the account setting, see Default log driver mode in the Amazon Elastic Container Service Developer Guide. + max-buffer-size Required: No Default value: 1m When non-blocking mode is used, the max-buffer-size log option controls the size of the buffer that's used for intermediate message storage. Make sure to specify an adequate buffer size based on your application. When the buffer fills up, further logs cannot be stored. Logs that cannot be stored are lost. 
                To route logs using the ``splunk`` log router, you need to specify a ``splunk-token`` and a ``splunk-url``.
                When you use the ``awsfirelens`` log router to route logs to an AWS Service or AWS Partner Network destination for log storage and analytics, you can set the ``log-driver-buffer-limit`` option to limit the number of events that are buffered in memory, before being sent to the log router container. It can help to resolve potential log loss issue because high throughput might result in memory running out for the buffer inside of Docker.
                Other options you can specify when using ``awsfirelens`` to route logs depend on the destination. When you export logs to Amazon Data Firehose, you can specify the AWS Region with ``region`` and a name for the log stream with ``delivery_stream``.
                When you export logs to Amazon Kinesis Data Streams, you can specify an AWS Region with ``region`` and a data stream name with ``stream``.
                 When you export logs to Amazon OpenSearch Service, you can specify options like ``Name``, ``Host`` (OpenSearch Service endpoint without protocol), ``Port``, ``Index``, ``Type``, ``Aws_auth``, ``Aws_region``, ``Suppress_Type_Name``, and ``tls``. For more information, see [Under the hood: FireLens for Amazon ECS Tasks](https://docs.aws.amazon.com/containers/under-the-hood-firelens-for-amazon-ecs-tasks/).
                When you export logs to Amazon S3, you can specify the bucket using the ``bucket`` option. You can also specify ``region``, ``total_file_size``, ``upload_timeout``, and ``use_put_object`` as options.
                This parameter requires version 1.19 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: ``sudo docker version --format '{{.Server.APIVersion}}'``
        :param Sequence['ServiceSecret'] secret_options: The secrets to pass to the log configuration. For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html) in the *Amazon Elastic Container Service Developer Guide*.
        """
        if log_driver is not None:
            pulumi.set(__self__, "log_driver", log_driver)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if secret_options is not None:
            pulumi.set(__self__, "secret_options", secret_options)

    @property
    @pulumi.getter(name="logDriver")
    def log_driver(self) -> Optional[builtins.str]:
        """
        The log driver to use for the container.
         For tasks on FARGATElong, the supported log drivers are ``awslogs``, ``splunk``, and ``awsfirelens``.
         For tasks hosted on Amazon EC2 instances, the supported log drivers are ``awslogs``, ``fluentd``, ``gelf``, ``json-file``, ``journald``, ``syslog``, ``splunk``, and ``awsfirelens``.
         For more information about using the ``awslogs`` log driver, see [Send Amazon ECS logs to CloudWatch](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_awslogs.html) in the *Amazon Elastic Container Service Developer Guide*.
         For more information about using the ``awsfirelens`` log driver, see [Send Amazon ECS logs to an service or Partner](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html).
          If you have a custom driver that isn't listed, you can fork the Amazon ECS container agent project that's [available on GitHub](https://docs.aws.amazon.com/https://github.com/aws/amazon-ecs-agent) and customize it to work with that driver. We encourage you to submit pull requests for changes that you would like to have included. However, we don't currently provide support for running modified copies of this software.
        """
        return pulumi.get(self, "log_driver")

    @property
    @pulumi.getter
    def options(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The configuration options to send to the log driver.
         The options you can specify depend on the log driver. Some of the options you can specify when you use the ``awslogs`` log driver to route logs to Amazon CloudWatch include the following:
          + awslogs-create-group Required: No Specify whether you want the log group to be created automatically. If this option isn't specified, it defaults to false. Your IAM policy must include the logs:CreateLogGroup permission before you attempt to use awslogs-create-group. + awslogs-region Required: Yes Specify the Region that the awslogs log driver is to send your Docker logs to. You can choose to send all of your logs from clusters in different Regions to a single region in CloudWatch Logs. This is so that they're all visible in one location. Otherwise, you can separate them by Region for more granularity. Make sure that the specified log group exists in the Region that you specify with this option. + awslogs-group Required: Yes Make sure to specify a log group that the awslogs log driver sends its log streams to. + awslogs-stream-prefix Required: Yes, when using Fargate.Optional when using EC2. Use the awslogs-stream-prefix option to associate a log stream with the specified prefix, the container name, and the ID of the Amazon ECS task that the container belongs to. If you specify a prefix with this option, then the log stream takes the format prefix-name/container-name/ecs-task-id. If you don't specify a prefix with this option, then the log stream is named after the container ID that's assigned by the Docker daemon on the container instance. Because it's difficult to trace logs back to the container that sent them with just the Docker container ID (which is only available on the container instance), we recommend that you specify a prefix with this option. For Amazon ECS services, you can use the service name as the prefix. Doing so, you can trace log streams to the service that the container belongs to, the name of the container that sent them, and the ID of the task that the container belongs to. You must specify a stream-prefix for your logs to have your logs appear in the Log pane when using the Amazon ECS console. + awslogs-datetime-format Required: No This option defines a multiline start pattern in Python strftime format. A log message consists of a line that matches the pattern and any following lines that don’t match the pattern. The matched line is the delimiter between log messages. One example of a use case for using this format is for parsing output such as a stack dump, which might otherwise be logged in multiple entries. The correct pattern allows it to be captured in a single entry. For more information, see awslogs-datetime-format. You cannot configure both the awslogs-datetime-format and awslogs-multiline-pattern options. Multiline logging performs regular expression parsing and matching of all log messages. This might have a negative impact on logging performance. + awslogs-multiline-pattern Required: No This option defines a multiline start pattern that uses a regular expression. A log message consists of a line that matches the pattern and any following lines that don’t match the pattern. The matched line is the delimiter between log messages. For more information, see awslogs-multiline-pattern. This option is ignored if awslogs-datetime-format is also configured. You cannot configure both the awslogs-datetime-format and awslogs-multiline-pattern options. Multiline logging performs regular expression parsing and matching of all log messages. This might have a negative impact on logging performance. 
         The following options apply to all supported log drivers.
          + mode Required: No Valid values: non-blocking | blocking This option defines the delivery mode of log messages from the container to the log driver specified using logDriver. The delivery mode you choose affects application availability when the flow of logs from container is interrupted. If you use the blocking mode and the flow of logs is interrupted, calls from container code to write to the stdout and stderr streams will block. The logging thread of the application will block as a result. This may cause the application to become unresponsive and lead to container healthcheck failure. If you use the non-blocking mode, the container's logs are instead stored in an in-memory intermediate buffer configured with the max-buffer-size option. This prevents the application from becoming unresponsive when logs cannot be sent. We recommend using this mode if you want to ensure service availability and are okay with some log loss. For more information, see Preventing log loss with non-blocking mode in the awslogs container log driver. You can set a default mode for all containers in a specific Region by using the defaultLogDriverMode account setting. If you don't specify the mode option or configure the account setting, Amazon ECS will default to the blocking mode. For more information about the account setting, see Default log driver mode in the Amazon Elastic Container Service Developer Guide. + max-buffer-size Required: No Default value: 1m When non-blocking mode is used, the max-buffer-size log option controls the size of the buffer that's used for intermediate message storage. Make sure to specify an adequate buffer size based on your application. When the buffer fills up, further logs cannot be stored. Logs that cannot be stored are lost. 
         To route logs using the ``splunk`` log router, you need to specify a ``splunk-token`` and a ``splunk-url``.
         When you use the ``awsfirelens`` log router to route logs to an AWS Service or AWS Partner Network destination for log storage and analytics, you can set the ``log-driver-buffer-limit`` option to limit the number of events that are buffered in memory, before being sent to the log router container. It can help to resolve potential log loss issue because high throughput might result in memory running out for the buffer inside of Docker.
         Other options you can specify when using ``awsfirelens`` to route logs depend on the destination. When you export logs to Amazon Data Firehose, you can specify the AWS Region with ``region`` and a name for the log stream with ``delivery_stream``.
         When you export logs to Amazon Kinesis Data Streams, you can specify an AWS Region with ``region`` and a data stream name with ``stream``.
          When you export logs to Amazon OpenSearch Service, you can specify options like ``Name``, ``Host`` (OpenSearch Service endpoint without protocol), ``Port``, ``Index``, ``Type``, ``Aws_auth``, ``Aws_region``, ``Suppress_Type_Name``, and ``tls``. For more information, see [Under the hood: FireLens for Amazon ECS Tasks](https://docs.aws.amazon.com/containers/under-the-hood-firelens-for-amazon-ecs-tasks/).
         When you export logs to Amazon S3, you can specify the bucket using the ``bucket`` option. You can also specify ``region``, ``total_file_size``, ``upload_timeout``, and ``use_put_object`` as options.
         This parameter requires version 1.19 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: ``sudo docker version --format '{{.Server.APIVersion}}'``
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="secretOptions")
    def secret_options(self) -> Optional[Sequence['outputs.ServiceSecret']]:
        """
        The secrets to pass to the log configuration. For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html) in the *Amazon Elastic Container Service Developer Guide*.
        """
        return pulumi.get(self, "secret_options")


@pulumi.output_type
class ServiceManagedEbsVolumeConfiguration(dict):
    """
    The configuration for the Amazon EBS volume that Amazon ECS creates and manages on your behalf. These settings are used to create each Amazon EBS volume, with one volume created for each task in the service. For information about the supported launch types and operating systems, see [Supported operating systems and launch types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-volumes.html#ebs-volumes-configuration) in the*Amazon Elastic Container Service Developer Guide*.
     Many of these parameters map 1:1 with the Amazon EBS ``CreateVolume`` API request parameters.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "filesystemType":
            suggest = "filesystem_type"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "sizeInGiB":
            suggest = "size_in_gi_b"
        elif key == "snapshotId":
            suggest = "snapshot_id"
        elif key == "tagSpecifications":
            suggest = "tag_specifications"
        elif key == "volumeInitializationRate":
            suggest = "volume_initialization_rate"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceManagedEbsVolumeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceManagedEbsVolumeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceManagedEbsVolumeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: builtins.str,
                 encrypted: Optional[builtins.bool] = None,
                 filesystem_type: Optional[builtins.str] = None,
                 iops: Optional[builtins.int] = None,
                 kms_key_id: Optional[builtins.str] = None,
                 size_in_gi_b: Optional[builtins.int] = None,
                 snapshot_id: Optional[builtins.str] = None,
                 tag_specifications: Optional[Sequence['outputs.ServiceEbsTagSpecification']] = None,
                 throughput: Optional[builtins.int] = None,
                 volume_initialization_rate: Optional[builtins.int] = None,
                 volume_type: Optional[builtins.str] = None):
        """
        The configuration for the Amazon EBS volume that Amazon ECS creates and manages on your behalf. These settings are used to create each Amazon EBS volume, with one volume created for each task in the service. For information about the supported launch types and operating systems, see [Supported operating systems and launch types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-volumes.html#ebs-volumes-configuration) in the*Amazon Elastic Container Service Developer Guide*.
         Many of these parameters map 1:1 with the Amazon EBS ``CreateVolume`` API request parameters.
        :param builtins.str role_arn: The ARN of the IAM role to associate with this volume. This is the Amazon ECS infrastructure IAM role that is used to manage your AWS infrastructure. We recommend using the Amazon ECS-managed ``AmazonECSInfrastructureRolePolicyForVolumes`` IAM policy with this role. For more information, see [Amazon ECS infrastructure IAM role](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/infrastructure_IAM_role.html) in the *Amazon ECS Developer Guide*.
        :param builtins.bool encrypted: Indicates whether the volume should be encrypted. If you turn on Region-level Amazon EBS encryption by default but set this value as ``false``, the setting is overridden and the volume is encrypted with the KMS key specified for Amazon EBS encryption by default. This parameter maps 1:1 with the ``Encrypted`` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*.
        :param builtins.str filesystem_type: The filesystem type for the volume. For volumes created from a snapshot, you must specify the same filesystem type that the volume was using when the snapshot was created. If there is a filesystem type mismatch, the tasks will fail to start.
                The available Linux filesystem types are
                ``ext3``, ``ext4``, and ``xfs``. If no value is specified, the ``xfs`` filesystem type is used by default.
                The available Windows filesystem types are ``NTFS``.
        :param builtins.int iops: The number of I/O operations per second (IOPS). For ``gp3``, ``io1``, and ``io2`` volumes, this represents the number of IOPS that are provisioned for the volume. For ``gp2`` volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting.
                The following are the supported values for each volume type.
                 +  ``gp3``: 3,000 - 16,000 IOPS
                 +  ``io1``: 100 - 64,000 IOPS
                 +  ``io2``: 100 - 256,000 IOPS
                 
                This parameter is required for ``io1`` and ``io2`` volume types. The default for ``gp3`` volumes is ``3,000 IOPS``. This parameter is not supported for ``st1``, ``sc1``, or ``standard`` volume types.
                This parameter maps 1:1 with the ``Iops`` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*.
        :param builtins.str kms_key_id: The Amazon Resource Name (ARN) identifier of the AWS Key Management Service key to use for Amazon EBS encryption. When a key is specified using this parameter, it overrides Amazon EBS default encryption or any KMS key that you specified for cluster-level managed storage encryption. This parameter maps 1:1 with the ``KmsKeyId`` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*. For more information about encrypting Amazon EBS volumes attached to tasks, see [Encrypt data stored in Amazon EBS volumes attached to Amazon ECS tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-kms-encryption.html).
                 AWS authenticates the AWS Key Management Service key asynchronously. Therefore, if you specify an ID, alias, or ARN that is invalid, the action can appear to complete, but eventually fails.
        :param builtins.int size_in_gi_b: The size of the volume in GiB. You must specify either a volume size or a snapshot ID. If you specify a snapshot ID, the snapshot size is used for the volume size by default. You can optionally specify a volume size greater than or equal to the snapshot size. This parameter maps 1:1 with the ``Size`` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*.
                The following are the supported volume size values for each volume type.
                 +  ``gp2`` and ``gp3``: 1-16,384
                 +  ``io1`` and ``io2``: 4-16,384
                 +  ``st1`` and ``sc1``: 125-16,384
                 +  ``standard``: 1-1,024
        :param builtins.str snapshot_id: The snapshot that Amazon ECS uses to create volumes for attachment to tasks maintained by the service. You must specify either ``snapshotId`` or ``sizeInGiB`` in your volume configuration. This parameter maps 1:1 with the ``SnapshotId`` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*.
        :param Sequence['ServiceEbsTagSpecification'] tag_specifications: The tags to apply to the volume. Amazon ECS applies service-managed tags by default. This parameter maps 1:1 with the ``TagSpecifications.N`` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*.
        :param builtins.int throughput: The throughput to provision for a volume, in MiB/s, with a maximum of 1,000 MiB/s. This parameter maps 1:1 with the ``Throughput`` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*.
                 This parameter is only supported for the ``gp3`` volume type.
        :param builtins.int volume_initialization_rate: The rate, in MiB/s, at which data is fetched from a snapshot of an existing EBS volume to create new volumes for attachment to the tasks maintained by the service. This property can be specified only if you specify a ``snapshotId``. For more information, see [Initialize Amazon EBS volumes](https://docs.aws.amazon.com/ebs/latest/userguide/initalize-volume.html) in the *Amazon EBS User Guide*.
        :param builtins.str volume_type: The volume type. This parameter maps 1:1 with the ``VolumeType`` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*. For more information, see [Amazon EBS volume types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volume-types.html) in the *Amazon EC2 User Guide*.
                The following are the supported volume types.
                 +  General Purpose SSD: ``gp2``|``gp3``
                 +  Provisioned IOPS SSD: ``io1``|``io2``
                 +  Throughput Optimized HDD: ``st1``
                 +  Cold HDD: ``sc1``
                 +  Magnetic: ``standard``
                 The magnetic volume type is not supported on Fargate.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if filesystem_type is not None:
            pulumi.set(__self__, "filesystem_type", filesystem_type)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if size_in_gi_b is not None:
            pulumi.set(__self__, "size_in_gi_b", size_in_gi_b)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if tag_specifications is not None:
            pulumi.set(__self__, "tag_specifications", tag_specifications)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if volume_initialization_rate is not None:
            pulumi.set(__self__, "volume_initialization_rate", volume_initialization_rate)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The ARN of the IAM role to associate with this volume. This is the Amazon ECS infrastructure IAM role that is used to manage your AWS infrastructure. We recommend using the Amazon ECS-managed ``AmazonECSInfrastructureRolePolicyForVolumes`` IAM policy with this role. For more information, see [Amazon ECS infrastructure IAM role](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/infrastructure_IAM_role.html) in the *Amazon ECS Developer Guide*.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[builtins.bool]:
        """
        Indicates whether the volume should be encrypted. If you turn on Region-level Amazon EBS encryption by default but set this value as ``false``, the setting is overridden and the volume is encrypted with the KMS key specified for Amazon EBS encryption by default. This parameter maps 1:1 with the ``Encrypted`` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter(name="filesystemType")
    def filesystem_type(self) -> Optional[builtins.str]:
        """
        The filesystem type for the volume. For volumes created from a snapshot, you must specify the same filesystem type that the volume was using when the snapshot was created. If there is a filesystem type mismatch, the tasks will fail to start.
         The available Linux filesystem types are
         ``ext3``, ``ext4``, and ``xfs``. If no value is specified, the ``xfs`` filesystem type is used by default.
         The available Windows filesystem types are ``NTFS``.
        """
        return pulumi.get(self, "filesystem_type")

    @property
    @pulumi.getter
    def iops(self) -> Optional[builtins.int]:
        """
        The number of I/O operations per second (IOPS). For ``gp3``, ``io1``, and ``io2`` volumes, this represents the number of IOPS that are provisioned for the volume. For ``gp2`` volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting.
         The following are the supported values for each volume type.
          +  ``gp3``: 3,000 - 16,000 IOPS
          +  ``io1``: 100 - 64,000 IOPS
          +  ``io2``: 100 - 256,000 IOPS
          
         This parameter is required for ``io1`` and ``io2`` volume types. The default for ``gp3`` volumes is ``3,000 IOPS``. This parameter is not supported for ``st1``, ``sc1``, or ``standard`` volume types.
         This parameter maps 1:1 with the ``Iops`` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) identifier of the AWS Key Management Service key to use for Amazon EBS encryption. When a key is specified using this parameter, it overrides Amazon EBS default encryption or any KMS key that you specified for cluster-level managed storage encryption. This parameter maps 1:1 with the ``KmsKeyId`` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*. For more information about encrypting Amazon EBS volumes attached to tasks, see [Encrypt data stored in Amazon EBS volumes attached to Amazon ECS tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-kms-encryption.html).
          AWS authenticates the AWS Key Management Service key asynchronously. Therefore, if you specify an ID, alias, or ARN that is invalid, the action can appear to complete, but eventually fails.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="sizeInGiB")
    def size_in_gi_b(self) -> Optional[builtins.int]:
        """
        The size of the volume in GiB. You must specify either a volume size or a snapshot ID. If you specify a snapshot ID, the snapshot size is used for the volume size by default. You can optionally specify a volume size greater than or equal to the snapshot size. This parameter maps 1:1 with the ``Size`` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*.
         The following are the supported volume size values for each volume type.
          +  ``gp2`` and ``gp3``: 1-16,384
          +  ``io1`` and ``io2``: 4-16,384
          +  ``st1`` and ``sc1``: 125-16,384
          +  ``standard``: 1-1,024
        """
        return pulumi.get(self, "size_in_gi_b")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[builtins.str]:
        """
        The snapshot that Amazon ECS uses to create volumes for attachment to tasks maintained by the service. You must specify either ``snapshotId`` or ``sizeInGiB`` in your volume configuration. This parameter maps 1:1 with the ``SnapshotId`` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter(name="tagSpecifications")
    def tag_specifications(self) -> Optional[Sequence['outputs.ServiceEbsTagSpecification']]:
        """
        The tags to apply to the volume. Amazon ECS applies service-managed tags by default. This parameter maps 1:1 with the ``TagSpecifications.N`` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*.
        """
        return pulumi.get(self, "tag_specifications")

    @property
    @pulumi.getter
    def throughput(self) -> Optional[builtins.int]:
        """
        The throughput to provision for a volume, in MiB/s, with a maximum of 1,000 MiB/s. This parameter maps 1:1 with the ``Throughput`` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*.
          This parameter is only supported for the ``gp3`` volume type.
        """
        return pulumi.get(self, "throughput")

    @property
    @pulumi.getter(name="volumeInitializationRate")
    def volume_initialization_rate(self) -> Optional[builtins.int]:
        """
        The rate, in MiB/s, at which data is fetched from a snapshot of an existing EBS volume to create new volumes for attachment to the tasks maintained by the service. This property can be specified only if you specify a ``snapshotId``. For more information, see [Initialize Amazon EBS volumes](https://docs.aws.amazon.com/ebs/latest/userguide/initalize-volume.html) in the *Amazon EBS User Guide*.
        """
        return pulumi.get(self, "volume_initialization_rate")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[builtins.str]:
        """
        The volume type. This parameter maps 1:1 with the ``VolumeType`` parameter of the [CreateVolume API](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html) in the *Amazon EC2 API Reference*. For more information, see [Amazon EBS volume types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volume-types.html) in the *Amazon EC2 User Guide*.
         The following are the supported volume types.
          +  General Purpose SSD: ``gp2``|``gp3``
          +  Provisioned IOPS SSD: ``io1``|``io2``
          +  Throughput Optimized HDD: ``st1``
          +  Cold HDD: ``sc1``
          +  Magnetic: ``standard``
          The magnetic volume type is not supported on Fargate.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class ServiceNetworkConfiguration(dict):
    """
    The network configuration for a task or service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsvpcConfiguration":
            suggest = "awsvpc_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 awsvpc_configuration: Optional['outputs.ServiceAwsVpcConfiguration'] = None):
        """
        The network configuration for a task or service.
        :param 'ServiceAwsVpcConfiguration' awsvpc_configuration: The VPC subnets and security groups that are associated with a task.
                 All specified subnets and security groups must be from the same VPC.
        """
        if awsvpc_configuration is not None:
            pulumi.set(__self__, "awsvpc_configuration", awsvpc_configuration)

    @property
    @pulumi.getter(name="awsvpcConfiguration")
    def awsvpc_configuration(self) -> Optional['outputs.ServiceAwsVpcConfiguration']:
        """
        The VPC subnets and security groups that are associated with a task.
          All specified subnets and security groups must be from the same VPC.
        """
        return pulumi.get(self, "awsvpc_configuration")


@pulumi.output_type
class ServicePlacementConstraint(dict):
    """
    An object representing a constraint on task placement. For more information, see [Task placement constraints](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html) in the *Amazon Elastic Container Service Developer Guide*.
      If you're using the Fargate launch type, task placement constraints aren't supported.
    """
    def __init__(__self__, *,
                 type: 'ServicePlacementConstraintType',
                 expression: Optional[builtins.str] = None):
        """
        An object representing a constraint on task placement. For more information, see [Task placement constraints](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html) in the *Amazon Elastic Container Service Developer Guide*.
          If you're using the Fargate launch type, task placement constraints aren't supported.
        :param 'ServicePlacementConstraintType' type: The type of constraint. Use ``distinctInstance`` to ensure that each task in a particular group is running on a different container instance. Use ``memberOf`` to restrict the selection to a group of valid candidates.
        :param builtins.str expression: A cluster query language expression to apply to the constraint. The expression can have a maximum length of 2000 characters. You can't specify an expression if the constraint type is ``distinctInstance``. For more information, see [Cluster query language](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html) in the *Amazon Elastic Container Service Developer Guide*.
        """
        pulumi.set(__self__, "type", type)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter
    def type(self) -> 'ServicePlacementConstraintType':
        """
        The type of constraint. Use ``distinctInstance`` to ensure that each task in a particular group is running on a different container instance. Use ``memberOf`` to restrict the selection to a group of valid candidates.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def expression(self) -> Optional[builtins.str]:
        """
        A cluster query language expression to apply to the constraint. The expression can have a maximum length of 2000 characters. You can't specify an expression if the constraint type is ``distinctInstance``. For more information, see [Cluster query language](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html) in the *Amazon Elastic Container Service Developer Guide*.
        """
        return pulumi.get(self, "expression")


@pulumi.output_type
class ServicePlacementStrategy(dict):
    """
    The task placement strategy for a task or service. For more information, see [Task placement strategies](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html) in the *Amazon Elastic Container Service Developer Guide*.
    """
    def __init__(__self__, *,
                 type: 'ServicePlacementStrategyType',
                 field: Optional[builtins.str] = None):
        """
        The task placement strategy for a task or service. For more information, see [Task placement strategies](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param 'ServicePlacementStrategyType' type: The type of placement strategy. The ``random`` placement strategy randomly places tasks on available candidates. The ``spread`` placement strategy spreads placement across available candidates evenly based on the ``field`` parameter. The ``binpack`` strategy places tasks on available candidates that have the least available amount of the resource that's specified with the ``field`` parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory but still enough to run the task.
        :param builtins.str field: The field to apply the placement strategy against. For the ``spread`` placement strategy, valid values are ``instanceId`` (or ``host``, which has the same effect), or any platform or custom attribute that's applied to a container instance, such as ``attribute:ecs.availability-zone``. For the ``binpack`` placement strategy, valid values are ``cpu`` and ``memory``. For the ``random`` placement strategy, this field is not used.
        """
        pulumi.set(__self__, "type", type)
        if field is not None:
            pulumi.set(__self__, "field", field)

    @property
    @pulumi.getter
    def type(self) -> 'ServicePlacementStrategyType':
        """
        The type of placement strategy. The ``random`` placement strategy randomly places tasks on available candidates. The ``spread`` placement strategy spreads placement across available candidates evenly based on the ``field`` parameter. The ``binpack`` strategy places tasks on available candidates that have the least available amount of the resource that's specified with the ``field`` parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory but still enough to run the task.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def field(self) -> Optional[builtins.str]:
        """
        The field to apply the placement strategy against. For the ``spread`` placement strategy, valid values are ``instanceId`` (or ``host``, which has the same effect), or any platform or custom attribute that's applied to a container instance, such as ``attribute:ecs.availability-zone``. For the ``binpack`` placement strategy, valid values are ``cpu`` and ``memory``. For the ``random`` placement strategy, this field is not used.
        """
        return pulumi.get(self, "field")


@pulumi.output_type
class ServiceRegistry(dict):
    """
    The details for the service registry.
     Each service may be associated with one service registry. Multiple service registries for each service are not supported.
     When you add, update, or remove the service registries configuration, Amazon ECS starts a new deployment. New tasks are registered and deregistered to the updated service registry configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"
        elif key == "containerPort":
            suggest = "container_port"
        elif key == "registryArn":
            suggest = "registry_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceRegistry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceRegistry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceRegistry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_name: Optional[builtins.str] = None,
                 container_port: Optional[builtins.int] = None,
                 port: Optional[builtins.int] = None,
                 registry_arn: Optional[builtins.str] = None):
        """
        The details for the service registry.
         Each service may be associated with one service registry. Multiple service registries for each service are not supported.
         When you add, update, or remove the service registries configuration, Amazon ECS starts a new deployment. New tasks are registered and deregistered to the updated service registry configuration.
        :param builtins.str container_name: The container name value to be used for your service discovery service. It's already specified in the task definition. If the task definition that your service task specifies uses the ``bridge`` or ``host`` network mode, you must specify a ``containerName`` and ``containerPort`` combination from the task definition. If the task definition that your service task specifies uses the ``awsvpc`` network mode and a type SRV DNS record is used, you must specify either a ``containerName`` and ``containerPort`` combination or a ``port`` value. However, you can't specify both.
        :param builtins.int container_port: The port value to be used for your service discovery service. It's already specified in the task definition. If the task definition your service task specifies uses the ``bridge`` or ``host`` network mode, you must specify a ``containerName`` and ``containerPort`` combination from the task definition. If the task definition your service task specifies uses the ``awsvpc`` network mode and a type SRV DNS record is used, you must specify either a ``containerName`` and ``containerPort`` combination or a ``port`` value. However, you can't specify both.
        :param builtins.int port: The port value used if your service discovery service specified an SRV record. This field might be used if both the ``awsvpc`` network mode and SRV records are used.
        :param builtins.str registry_arn: The Amazon Resource Name (ARN) of the service registry. The currently supported service registry is CMAP. For more information, see [CreateService](https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html).
        """
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if registry_arn is not None:
            pulumi.set(__self__, "registry_arn", registry_arn)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[builtins.str]:
        """
        The container name value to be used for your service discovery service. It's already specified in the task definition. If the task definition that your service task specifies uses the ``bridge`` or ``host`` network mode, you must specify a ``containerName`` and ``containerPort`` combination from the task definition. If the task definition that your service task specifies uses the ``awsvpc`` network mode and a type SRV DNS record is used, you must specify either a ``containerName`` and ``containerPort`` combination or a ``port`` value. However, you can't specify both.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[builtins.int]:
        """
        The port value to be used for your service discovery service. It's already specified in the task definition. If the task definition your service task specifies uses the ``bridge`` or ``host`` network mode, you must specify a ``containerName`` and ``containerPort`` combination from the task definition. If the task definition your service task specifies uses the ``awsvpc`` network mode and a type SRV DNS record is used, you must specify either a ``containerName`` and ``containerPort`` combination or a ``port`` value. However, you can't specify both.
        """
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        The port value used if your service discovery service specified an SRV record. This field might be used if both the ``awsvpc`` network mode and SRV records are used.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="registryArn")
    def registry_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the service registry. The currently supported service registry is CMAP. For more information, see [CreateService](https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html).
        """
        return pulumi.get(self, "registry_arn")


@pulumi.output_type
class ServiceSecret(dict):
    """
    An object representing the secret to expose to your container. Secrets can be exposed to a container in the following ways:
      +  To inject sensitive data into your containers as environment variables, use the ``secrets`` container definition parameter.
      +  To reference sensitive information in the log configuration of a container, use the ``secretOptions`` container definition parameter.
      
     For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html) in the *Amazon Elastic Container Service Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueFrom":
            suggest = "value_from"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 value_from: builtins.str):
        """
        An object representing the secret to expose to your container. Secrets can be exposed to a container in the following ways:
          +  To inject sensitive data into your containers as environment variables, use the ``secrets`` container definition parameter.
          +  To reference sensitive information in the log configuration of a container, use the ``secretOptions`` container definition parameter.
          
         For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param builtins.str name: The name of the secret.
        :param builtins.str value_from: The secret to expose to the container. The supported values are either the full ARN of the ASMlong secret or the full ARN of the parameter in the SSM Parameter Store.
                For information about the require IAMlong permissions, see [Required IAM permissions for Amazon ECS secrets](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-secrets.html#secrets-iam) (for Secrets Manager) or [Required IAM permissions for Amazon ECS secrets](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-parameters.html) (for Systems Manager Parameter store) in the *Amazon Elastic Container Service Developer Guide*.
                 If the SSM Parameter Store parameter exists in the same Region as the task you're launching, then you can use either the full ARN or name of the parameter. If the parameter exists in a different Region, then the full ARN must be specified.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value_from", value_from)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the secret.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="valueFrom")
    def value_from(self) -> builtins.str:
        """
        The secret to expose to the container. The supported values are either the full ARN of the ASMlong secret or the full ARN of the parameter in the SSM Parameter Store.
         For information about the require IAMlong permissions, see [Required IAM permissions for Amazon ECS secrets](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-secrets.html#secrets-iam) (for Secrets Manager) or [Required IAM permissions for Amazon ECS secrets](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-parameters.html) (for Systems Manager Parameter store) in the *Amazon Elastic Container Service Developer Guide*.
          If the SSM Parameter Store parameter exists in the same Region as the task you're launching, then you can use either the full ARN or name of the parameter. If the parameter exists in a different Region, then the full ARN must be specified.
        """
        return pulumi.get(self, "value_from")


@pulumi.output_type
class ServiceTag(dict):
    """
    The metadata that you apply to a resource to help you categorize and organize them. Each tag consists of a key and an optional value. You define them.
     The following basic restrictions apply to tags:
      +  Maximum number of tags per resource - 50
      +  For each resource, each tag key must be unique, and each tag key can have only one value.
      +  Maximum key length - 128 Unicode characters in UTF-8
      +  Maximum value length - 256 Unicode characters in UTF-8
      +  If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
      +  Tag keys and values are case-sensitive.
      +  Do not use ``aws:``, ``AWS:``, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
      
     In order to tag a service that has the following ARN format, you need to migrate the service to the long ARN. You must use the API, CLI or console to migrate the service ARN. For more information, see [Migrate an short service ARN to a long ARN](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-arn-migration.html) in the *Developer Guide*.
      ``arn:aws:ecs:region:aws_account_id:service/service-name`` 
     After the migration is complete, the following are true:
      +   The service ARN is: ``arn:aws:ecs:region:aws_account_id:service/cluster-name/service-name``
      +  You can use CFN to tag the service as you would a service with a long ARN format.
      +  When the ``PhysicalResourceId`` in the CFN stack represents a service, the value does not change and will be the short service ARN.
    """
    def __init__(__self__, *,
                 key: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        The metadata that you apply to a resource to help you categorize and organize them. Each tag consists of a key and an optional value. You define them.
         The following basic restrictions apply to tags:
          +  Maximum number of tags per resource - 50
          +  For each resource, each tag key must be unique, and each tag key can have only one value.
          +  Maximum key length - 128 Unicode characters in UTF-8
          +  Maximum value length - 256 Unicode characters in UTF-8
          +  If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
          +  Tag keys and values are case-sensitive.
          +  Do not use ``aws:``, ``AWS:``, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
          
         In order to tag a service that has the following ARN format, you need to migrate the service to the long ARN. You must use the API, CLI or console to migrate the service ARN. For more information, see [Migrate an short service ARN to a long ARN](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-arn-migration.html) in the *Developer Guide*.
          ``arn:aws:ecs:region:aws_account_id:service/service-name`` 
         After the migration is complete, the following are true:
          +   The service ARN is: ``arn:aws:ecs:region:aws_account_id:service/cluster-name/service-name``
          +  You can use CFN to tag the service as you would a service with a long ARN format.
          +  When the ``PhysicalResourceId`` in the CFN stack represents a service, the value does not change and will be the short service ARN.
        :param builtins.str key: One part of a key-value pair that make up a tag. A ``key`` is a general label that acts like a category for more specific tag values.
        :param builtins.str value: The optional part of a key-value pair that make up a tag. A ``value`` acts as a descriptor within a tag category (key).
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        One part of a key-value pair that make up a tag. A ``key`` is a general label that acts like a category for more specific tag values.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The optional part of a key-value pair that make up a tag. A ``value`` acts as a descriptor within a tag category (key).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceTimeoutConfiguration(dict):
    """
    An object that represents the timeout configurations for Service Connect.
      If ``idleTimeout`` is set to a time that is less than ``perRequestTimeout``, the connection will close when the ``idleTimeout`` is reached and not the ``perRequestTimeout``.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idleTimeoutSeconds":
            suggest = "idle_timeout_seconds"
        elif key == "perRequestTimeoutSeconds":
            suggest = "per_request_timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTimeoutConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTimeoutConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTimeoutConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idle_timeout_seconds: Optional[builtins.int] = None,
                 per_request_timeout_seconds: Optional[builtins.int] = None):
        """
        An object that represents the timeout configurations for Service Connect.
          If ``idleTimeout`` is set to a time that is less than ``perRequestTimeout``, the connection will close when the ``idleTimeout`` is reached and not the ``perRequestTimeout``.
        :param builtins.int idle_timeout_seconds: The amount of time in seconds a connection will stay active while idle. A value of ``0`` can be set to disable ``idleTimeout``.
                The ``idleTimeout`` default for ``HTTP``/``HTTP2``/``GRPC`` is 5 minutes.
                The ``idleTimeout`` default for ``TCP`` is 1 hour.
        :param builtins.int per_request_timeout_seconds: The amount of time waiting for the upstream to respond with a complete response per request. A value of ``0`` can be set to disable ``perRequestTimeout``. ``perRequestTimeout`` can only be set if Service Connect ``appProtocol`` isn't ``TCP``. Only ``idleTimeout`` is allowed for ``TCP````appProtocol``.
        """
        if idle_timeout_seconds is not None:
            pulumi.set(__self__, "idle_timeout_seconds", idle_timeout_seconds)
        if per_request_timeout_seconds is not None:
            pulumi.set(__self__, "per_request_timeout_seconds", per_request_timeout_seconds)

    @property
    @pulumi.getter(name="idleTimeoutSeconds")
    def idle_timeout_seconds(self) -> Optional[builtins.int]:
        """
        The amount of time in seconds a connection will stay active while idle. A value of ``0`` can be set to disable ``idleTimeout``.
         The ``idleTimeout`` default for ``HTTP``/``HTTP2``/``GRPC`` is 5 minutes.
         The ``idleTimeout`` default for ``TCP`` is 1 hour.
        """
        return pulumi.get(self, "idle_timeout_seconds")

    @property
    @pulumi.getter(name="perRequestTimeoutSeconds")
    def per_request_timeout_seconds(self) -> Optional[builtins.int]:
        """
        The amount of time waiting for the upstream to respond with a complete response per request. A value of ``0`` can be set to disable ``perRequestTimeout``. ``perRequestTimeout`` can only be set if Service Connect ``appProtocol`` isn't ``TCP``. Only ``idleTimeout`` is allowed for ``TCP````appProtocol``.
        """
        return pulumi.get(self, "per_request_timeout_seconds")


@pulumi.output_type
class ServiceVolumeConfiguration(dict):
    """
    The configuration for a volume specified in the task definition as a volume that is configured at launch time. Currently, the only supported volume type is an Amazon EBS volume.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "managedEbsVolume":
            suggest = "managed_ebs_volume"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVolumeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVolumeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVolumeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 managed_ebs_volume: Optional['outputs.ServiceManagedEbsVolumeConfiguration'] = None):
        """
        The configuration for a volume specified in the task definition as a volume that is configured at launch time. Currently, the only supported volume type is an Amazon EBS volume.
        :param builtins.str name: The name of the volume. This value must match the volume name from the ``Volume`` object in the task definition.
        :param 'ServiceManagedEbsVolumeConfiguration' managed_ebs_volume: The configuration for the Amazon EBS volume that Amazon ECS creates and manages on your behalf. These settings are used to create each Amazon EBS volume, with one volume created for each task in the service. The Amazon EBS volumes are visible in your account in the Amazon EC2 console once they are created.
        """
        pulumi.set(__self__, "name", name)
        if managed_ebs_volume is not None:
            pulumi.set(__self__, "managed_ebs_volume", managed_ebs_volume)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the volume. This value must match the volume name from the ``Volume`` object in the task definition.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="managedEbsVolume")
    def managed_ebs_volume(self) -> Optional['outputs.ServiceManagedEbsVolumeConfiguration']:
        """
        The configuration for the Amazon EBS volume that Amazon ECS creates and manages on your behalf. These settings are used to create each Amazon EBS volume, with one volume created for each task in the service. The Amazon EBS volumes are visible in your account in the Amazon EC2 console once they are created.
        """
        return pulumi.get(self, "managed_ebs_volume")


@pulumi.output_type
class ServiceVpcLatticeConfiguration(dict):
    """
    The VPC Lattice configuration for your service that holds the information for the target group(s) Amazon ECS tasks will be registered to.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "portName":
            suggest = "port_name"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "targetGroupArn":
            suggest = "target_group_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVpcLatticeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVpcLatticeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVpcLatticeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port_name: builtins.str,
                 role_arn: builtins.str,
                 target_group_arn: builtins.str):
        """
        The VPC Lattice configuration for your service that holds the information for the target group(s) Amazon ECS tasks will be registered to.
        :param builtins.str port_name: The name of the port mapping to register in the VPC Lattice target group. This is the name of the ``portMapping`` you defined in your task definition.
        :param builtins.str role_arn: The ARN of the IAM role to associate with this VPC Lattice configuration. This is the Amazon ECS
                infrastructure IAM role that is used to manage your VPC Lattice infrastructure.
        :param builtins.str target_group_arn: The full Amazon Resource Name (ARN) of the target group or groups associated with the VPC Lattice configuration that the Amazon ECS tasks will be registered to.
        """
        pulumi.set(__self__, "port_name", port_name)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "target_group_arn", target_group_arn)

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> builtins.str:
        """
        The name of the port mapping to register in the VPC Lattice target group. This is the name of the ``portMapping`` you defined in your task definition.
        """
        return pulumi.get(self, "port_name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> builtins.str:
        """
        The ARN of the IAM role to associate with this VPC Lattice configuration. This is the Amazon ECS
         infrastructure IAM role that is used to manage your VPC Lattice infrastructure.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> builtins.str:
        """
        The full Amazon Resource Name (ARN) of the target group or groups associated with the VPC Lattice configuration that the Amazon ECS tasks will be registered to.
        """
        return pulumi.get(self, "target_group_arn")


@pulumi.output_type
class TaskDefinitionAuthorizationConfig(dict):
    """
    The authorization configuration details for the Amazon EFS file system.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessPointId":
            suggest = "access_point_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionAuthorizationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionAuthorizationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionAuthorizationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_point_id: Optional[builtins.str] = None,
                 iam: Optional['TaskDefinitionAuthorizationConfigIam'] = None):
        """
        The authorization configuration details for the Amazon EFS file system.
        :param builtins.str access_point_id: The Amazon EFS access point ID to use. If an access point is specified, the root directory value specified in the ``EFSVolumeConfiguration`` must either be omitted or set to ``/`` which will enforce the path set on the EFS access point. If an access point is used, transit encryption must be on in the ``EFSVolumeConfiguration``. For more information, see [Working with Amazon EFS access points](https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html) in the *Amazon Elastic File System User Guide*.
        :param 'TaskDefinitionAuthorizationConfigIam' iam: Determines whether to use the Amazon ECS task role defined in a task definition when mounting the Amazon EFS file system. If it is turned on, transit encryption must be turned on in the ``EFSVolumeConfiguration``. If this parameter is omitted, the default value of ``DISABLED`` is used. For more information, see [Using Amazon EFS access points](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/efs-volumes.html#efs-volume-accesspoints) in the *Amazon Elastic Container Service Developer Guide*.
        """
        if access_point_id is not None:
            pulumi.set(__self__, "access_point_id", access_point_id)
        if iam is not None:
            pulumi.set(__self__, "iam", iam)

    @property
    @pulumi.getter(name="accessPointId")
    def access_point_id(self) -> Optional[builtins.str]:
        """
        The Amazon EFS access point ID to use. If an access point is specified, the root directory value specified in the ``EFSVolumeConfiguration`` must either be omitted or set to ``/`` which will enforce the path set on the EFS access point. If an access point is used, transit encryption must be on in the ``EFSVolumeConfiguration``. For more information, see [Working with Amazon EFS access points](https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html) in the *Amazon Elastic File System User Guide*.
        """
        return pulumi.get(self, "access_point_id")

    @property
    @pulumi.getter
    def iam(self) -> Optional['TaskDefinitionAuthorizationConfigIam']:
        """
        Determines whether to use the Amazon ECS task role defined in a task definition when mounting the Amazon EFS file system. If it is turned on, transit encryption must be turned on in the ``EFSVolumeConfiguration``. If this parameter is omitted, the default value of ``DISABLED`` is used. For more information, see [Using Amazon EFS access points](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/efs-volumes.html#efs-volume-accesspoints) in the *Amazon Elastic Container Service Developer Guide*.
        """
        return pulumi.get(self, "iam")


@pulumi.output_type
class TaskDefinitionContainerDefinition(dict):
    """
    The ``ContainerDefinition`` property specifies a container definition. Container definitions are used in task definitions to describe the different containers that are launched as part of a task.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialSpecs":
            suggest = "credential_specs"
        elif key == "dependsOn":
            suggest = "depends_on"
        elif key == "disableNetworking":
            suggest = "disable_networking"
        elif key == "dnsSearchDomains":
            suggest = "dns_search_domains"
        elif key == "dnsServers":
            suggest = "dns_servers"
        elif key == "dockerLabels":
            suggest = "docker_labels"
        elif key == "dockerSecurityOptions":
            suggest = "docker_security_options"
        elif key == "entryPoint":
            suggest = "entry_point"
        elif key == "environmentFiles":
            suggest = "environment_files"
        elif key == "extraHosts":
            suggest = "extra_hosts"
        elif key == "firelensConfiguration":
            suggest = "firelens_configuration"
        elif key == "healthCheck":
            suggest = "health_check"
        elif key == "linuxParameters":
            suggest = "linux_parameters"
        elif key == "logConfiguration":
            suggest = "log_configuration"
        elif key == "memoryReservation":
            suggest = "memory_reservation"
        elif key == "mountPoints":
            suggest = "mount_points"
        elif key == "portMappings":
            suggest = "port_mappings"
        elif key == "pseudoTerminal":
            suggest = "pseudo_terminal"
        elif key == "readonlyRootFilesystem":
            suggest = "readonly_root_filesystem"
        elif key == "repositoryCredentials":
            suggest = "repository_credentials"
        elif key == "resourceRequirements":
            suggest = "resource_requirements"
        elif key == "restartPolicy":
            suggest = "restart_policy"
        elif key == "startTimeout":
            suggest = "start_timeout"
        elif key == "stopTimeout":
            suggest = "stop_timeout"
        elif key == "systemControls":
            suggest = "system_controls"
        elif key == "versionConsistency":
            suggest = "version_consistency"
        elif key == "volumesFrom":
            suggest = "volumes_from"
        elif key == "workingDirectory":
            suggest = "working_directory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionContainerDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionContainerDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionContainerDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: builtins.str,
                 name: builtins.str,
                 command: Optional[Sequence[builtins.str]] = None,
                 cpu: Optional[builtins.int] = None,
                 credential_specs: Optional[Sequence[builtins.str]] = None,
                 depends_on: Optional[Sequence['outputs.TaskDefinitionContainerDependency']] = None,
                 disable_networking: Optional[builtins.bool] = None,
                 dns_search_domains: Optional[Sequence[builtins.str]] = None,
                 dns_servers: Optional[Sequence[builtins.str]] = None,
                 docker_labels: Optional[Mapping[str, builtins.str]] = None,
                 docker_security_options: Optional[Sequence[builtins.str]] = None,
                 entry_point: Optional[Sequence[builtins.str]] = None,
                 environment: Optional[Sequence['outputs.TaskDefinitionKeyValuePair']] = None,
                 environment_files: Optional[Sequence['outputs.TaskDefinitionEnvironmentFile']] = None,
                 essential: Optional[builtins.bool] = None,
                 extra_hosts: Optional[Sequence['outputs.TaskDefinitionHostEntry']] = None,
                 firelens_configuration: Optional['outputs.TaskDefinitionFirelensConfiguration'] = None,
                 health_check: Optional['outputs.TaskDefinitionHealthCheck'] = None,
                 hostname: Optional[builtins.str] = None,
                 interactive: Optional[builtins.bool] = None,
                 links: Optional[Sequence[builtins.str]] = None,
                 linux_parameters: Optional['outputs.TaskDefinitionLinuxParameters'] = None,
                 log_configuration: Optional['outputs.TaskDefinitionLogConfiguration'] = None,
                 memory: Optional[builtins.int] = None,
                 memory_reservation: Optional[builtins.int] = None,
                 mount_points: Optional[Sequence['outputs.TaskDefinitionMountPoint']] = None,
                 port_mappings: Optional[Sequence['outputs.TaskDefinitionPortMapping']] = None,
                 privileged: Optional[builtins.bool] = None,
                 pseudo_terminal: Optional[builtins.bool] = None,
                 readonly_root_filesystem: Optional[builtins.bool] = None,
                 repository_credentials: Optional['outputs.TaskDefinitionRepositoryCredentials'] = None,
                 resource_requirements: Optional[Sequence['outputs.TaskDefinitionResourceRequirement']] = None,
                 restart_policy: Optional['outputs.TaskDefinitionRestartPolicy'] = None,
                 secrets: Optional[Sequence['outputs.TaskDefinitionSecret']] = None,
                 start_timeout: Optional[builtins.int] = None,
                 stop_timeout: Optional[builtins.int] = None,
                 system_controls: Optional[Sequence['outputs.TaskDefinitionSystemControl']] = None,
                 ulimits: Optional[Sequence['outputs.TaskDefinitionUlimit']] = None,
                 user: Optional[builtins.str] = None,
                 version_consistency: Optional['TaskDefinitionContainerDefinitionVersionConsistency'] = None,
                 volumes_from: Optional[Sequence['outputs.TaskDefinitionVolumeFrom']] = None,
                 working_directory: Optional[builtins.str] = None):
        """
        The ``ContainerDefinition`` property specifies a container definition. Container definitions are used in task definitions to describe the different containers that are launched as part of a task.
        :param builtins.str image: The image used to start a container. This string is passed directly to the Docker daemon. By default, images in the Docker Hub registry are available. Other repositories are specified with either ``repository-url/image:tag`` or ``repository-url/image@digest``. Up to 255 letters (uppercase and lowercase), numbers, hyphens, underscores, colons, periods, forward slashes, and number signs are allowed. This parameter maps to ``Image`` in the docker container create command and the ``IMAGE`` parameter of docker run.
                 +  When a new task starts, the Amazon ECS container agent pulls the latest version of the specified image and tag for the container to use. However, subsequent updates to a repository image aren't propagated to already running tasks.
                 +  Images in Amazon ECR repositories can be specified by either using the full ``registry/repository:tag`` or ``registry/repository@digest``. For example, ``012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>:latest`` or ``012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>@sha256:94afd1f2e64d908bc90dbca0035a5b567EXAMPLE``. 
                 +  Images in official repositories on Docker Hub use a single name (for example, ``ubuntu`` or ``mongo``).
                 +  Images in other repositories on Docker Hub are qualified with an organization name (for example, ``amazon/amazon-ecs-agent``).
                 +  Images in other online repositories are qualified further by a domain name (for example, ``quay.io/assemblyline/ubuntu``).
        :param builtins.str name: The name of a container. If you're linking multiple containers together in a task definition, the ``name`` of one container can be entered in the ``links`` of another container to connect the containers. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. This parameter maps to ``name`` in the docker container create command and the ``--name`` option to docker run.
        :param Sequence[builtins.str] command: The command that's passed to the container. This parameter maps to ``Cmd`` in the docker container create command and the ``COMMAND`` parameter to docker run. If there are multiple arguments, each argument is a separated string in the array.
        :param builtins.int cpu: The number of ``cpu`` units reserved for the container. This parameter maps to ``CpuShares`` in the docker container create commandand the ``--cpu-shares`` option to docker run.
                This field is optional for tasks using the Fargate launch type, and the only requirement is that the total amount of CPU reserved for all containers within a task be lower than the task-level ``cpu`` value.
                 You can determine the number of CPU units that are available per EC2 instance type by multiplying the vCPUs listed for that instance type on the [Amazon EC2 Instances](https://docs.aws.amazon.com/ec2/instance-types/) detail page by 1,024.
                 Linux containers share unallocated CPU units with other containers on the container instance with the same ratio as their allocated amount. For example, if you run a single-container task on a single-core instance type with 512 CPU units specified for that container, and that's the only task running on the container instance, that container could use the full 1,024 CPU unit share at any given time. However, if you launched another copy of the same task on that container instance, each task is guaranteed a minimum of 512 CPU units when needed. Moreover, each container could float to higher CPU usage if the other container was not using it. If both tasks were 100% active all of the time, they would be limited to 512 CPU units.
                On Linux container instances, the Docker daemon on the container instance uses the CPU value to calculate the relative CPU share ratios for running containers. The minimum valid CPU share value that the Linux kernel allows is 2, and the maximum valid CPU share value that the Linux kernel allows is 262144. However, the CPU parameter isn't required, and you can use CPU values below 2 or above 262144 in your container definitions. For CPU values below 2 (including null) or above 262144, the behavior varies based on your Amazon ECS container agent version:
                 +  *Agent versions less than or equal to 1.1.0:* Null and zero CPU values are passed to Docker as 0, which Docker then converts to 1,024 CPU shares. CPU values of 1 are passed to Docker as 1, which the Linux kernel converts to two CPU shares.
                 +  *Agent versions greater than or equal to 1.2.0:* Null, zero, and CPU values of 1 are passed to Docker as 2.
                 +  *Agent versions greater than or equal to 1.84.0:* CPU values greater than 256 vCPU are passed to Docker as 256, which is equivalent to 262144 CPU shares.
                 
                On Windows container instances, the CPU limit is enforced as an absolute limit, or a quota. Windows containers only have access to the specified amount of CPU that's described in the task definition. A null or zero CPU value is passed to Docker as ``0``, which Windows interprets as 1% of one CPU.
        :param Sequence[builtins.str] credential_specs: A list of ARNs in SSM or Amazon S3 to a credential spec (``CredSpec``) file that configures the container for Active Directory authentication. We recommend that you use this parameter instead of the ``dockerSecurityOptions``. The maximum number of ARNs is 1.
                There are two formats for each ARN.
                 + credentialspecdomainless:MyARN You use credentialspecdomainless:MyARN to provide a CredSpec with an additional section for a secret in . You provide the login credentials to the domain in the secret. Each task that runs on any container instance can join different domains. You can use this format without joining the container instance to a domain. + credentialspec:MyARN You use credentialspec:MyARN to provide a CredSpec for a single domain. You must join the container instance to the domain before you start any tasks that use this task definition. 
                In both formats, replace ``MyARN`` with the ARN in SSM or Amazon S3.
                If you provide a ``credentialspecdomainless:MyARN``, the ``credspec`` must provide a ARN in ASMlong for a secret containing the username, password, and the domain to connect to. For better security, the instance isn't joined to the domain for domainless authentication. Other applications on the instance can't use the domainless credentials. You can use this parameter to run tasks on the same instance, even it the tasks need to join different domains. For more information, see [Using gMSAs for Windows Containers](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows-gmsa.html) and [Using gMSAs for Linux Containers](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/linux-gmsa.html).
        :param Sequence['TaskDefinitionContainerDependency'] depends_on: The dependencies defined for container startup and shutdown. A container can contain multiple dependencies. When a dependency is defined for container startup, for container shutdown it is reversed.
                For tasks using the EC2 launch type, the container instances require at least version 1.26.0 of the container agent to turn on container dependencies. However, we recommend using the latest container agent version. For information about checking your agent version and updating to the latest version, see [Updating the Amazon ECS Container Agent](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html) in the *Amazon Elastic Container Service Developer Guide*. If you're using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the ``ecs-init`` package. If your container instances are launched from version ``20190301`` or later, then they contain the required versions of the container agent and ``ecs-init``. For more information, see [Amazon ECS-optimized Linux AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html) in the *Amazon Elastic Container Service Developer Guide*.
                For tasks using the Fargate launch type, the task or service requires the following platforms:
                 +  Linux platform version ``1.3.0`` or later.
                 +  Windows platform version ``1.0.0`` or later.
                 
                If the task definition is used in a blue/green deployment that uses [AWS::CodeDeploy::DeploymentGroup BlueGreenDeploymentConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-bluegreendeploymentconfiguration.html), the ``dependsOn`` parameter is not supported. For more information see [Issue #680](https://docs.aws.amazon.com/https://github.com/aws-cloudformation/cloudformation-coverage-roadmap/issues/680) on the on the GitHub website.
        :param builtins.bool disable_networking: When this parameter is true, networking is off within the container. This parameter maps to ``NetworkDisabled`` in the docker container create command.
                 This parameter is not supported for Windows containers.
        :param Sequence[builtins.str] dns_search_domains: A list of DNS search domains that are presented to the container. This parameter maps to ``DnsSearch`` in the docker container create command and the ``--dns-search`` option to docker run.
                 This parameter is not supported for Windows containers.
        :param Sequence[builtins.str] dns_servers: A list of DNS servers that are presented to the container. This parameter maps to ``Dns`` in the docker container create command and the ``--dns`` option to docker run.
                 This parameter is not supported for Windows containers.
        :param Mapping[str, builtins.str] docker_labels: A key/value map of labels to add to the container. This parameter maps to ``Labels`` in the docker container create command and the ``--label`` option to docker run. This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: ``sudo docker version --format '{{.Server.APIVersion}}'``
        :param Sequence[builtins.str] docker_security_options: A list of strings to provide custom configuration for multiple security systems. This field isn't valid for containers in tasks using the Fargate launch type.
                For Linux tasks on EC2, this parameter can be used to reference custom labels for SELinux and AppArmor multi-level security systems.
                For any tasks on EC2, this parameter can be used to reference a credential spec file that configures a container for Active Directory authentication. For more information, see [Using gMSAs for Windows Containers](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows-gmsa.html) and [Using gMSAs for Linux Containers](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/linux-gmsa.html) in the *Amazon Elastic Container Service Developer Guide*.
                This parameter maps to ``SecurityOpt`` in the docker container create command and the ``--security-opt`` option to docker run.
                 The Amazon ECS container agent running on a container instance must register with the ``ECS_SELINUX_CAPABLE=true`` or ``ECS_APPARMOR_CAPABLE=true`` environment variables before containers placed on that instance can use these security options. For more information, see [Amazon ECS Container Agent Configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide*.
                 Valid values: "no-new-privileges" | "apparmor:PROFILE" | "label:value" | "credentialspec:CredentialSpecFilePath"
        :param Sequence[builtins.str] entry_point: Early versions of the Amazon ECS container agent don't properly handle ``entryPoint`` parameters. If you have problems using ``entryPoint``, update your container agent or enter your commands and arguments as ``command`` array items instead.
                 The entry point that's passed to the container. This parameter maps to ``Entrypoint`` in the docker container create command and the ``--entrypoint`` option to docker run.
        :param Sequence['TaskDefinitionKeyValuePair'] environment: The environment variables to pass to a container. This parameter maps to ``Env`` in the docker container create command and the ``--env`` option to docker run.
                 We don't recommend that you use plaintext environment variables for sensitive information, such as credential data.
        :param Sequence['TaskDefinitionEnvironmentFile'] environment_files: A list of files containing the environment variables to pass to a container. This parameter maps to the ``--env-file`` option to docker run.
                You can specify up to ten environment files. The file must have a ``.env`` file extension. Each line in an environment file contains an environment variable in ``VARIABLE=VALUE`` format. Lines beginning with ``#`` are treated as comments and are ignored.
                If there are environment variables specified using the ``environment`` parameter in a container definition, they take precedence over the variables contained within an environment file. If multiple environment files are specified that contain the same variable, they're processed from the top down. We recommend that you use unique variable names. For more information, see [Specifying Environment Variables](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/taskdef-envfiles.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param builtins.bool essential: If the ``essential`` parameter of a container is marked as ``true``, and that container fails or stops for any reason, all other containers that are part of the task are stopped. If the ``essential`` parameter of a container is marked as ``false``, its failure doesn't affect the rest of the containers in a task. If this parameter is omitted, a container is assumed to be essential.
                All tasks must have at least one essential container. If you have an application that's composed of multiple containers, group containers that are used for a common purpose into components, and separate the different components into multiple task definitions. For more information, see [Application Architecture](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/application_architecture.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param Sequence['TaskDefinitionHostEntry'] extra_hosts: A list of hostnames and IP address mappings to append to the ``/etc/hosts`` file on the container. This parameter maps to ``ExtraHosts`` in the docker container create command and the ``--add-host`` option to docker run.
                 This parameter isn't supported for Windows containers or tasks that use the ``awsvpc`` network mode.
        :param 'TaskDefinitionFirelensConfiguration' firelens_configuration: The FireLens configuration for the container. This is used to specify and configure a log router for container logs. For more information, see [Custom Log Routing](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param 'TaskDefinitionHealthCheck' health_check: The container health check command and associated configuration parameters for the container. This parameter maps to ``HealthCheck`` in the docker container create command and the ``HEALTHCHECK`` parameter of docker run.
        :param builtins.str hostname: The hostname to use for your container. This parameter maps to ``Hostname`` in the docker container create command and the ``--hostname`` option to docker run.
                 The ``hostname`` parameter is not supported if you're using the ``awsvpc`` network mode.
        :param builtins.bool interactive: When this parameter is ``true``, you can deploy containerized applications that require ``stdin`` or a ``tty`` to be allocated. This parameter maps to ``OpenStdin`` in the docker container create command and the ``--interactive`` option to docker run.
        :param Sequence[builtins.str] links: The ``links`` parameter allows containers to communicate with each other without the need for port mappings. This parameter is only supported if the network mode of a task definition is ``bridge``. The ``name:internalName`` construct is analogous to ``name:alias`` in Docker links. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed.. This parameter maps to ``Links`` in the docker container create command and the ``--link`` option to docker run.
                 This parameter is not supported for Windows containers.
                  Containers that are collocated on a single container instance may be able to communicate with each other without requiring links or host port mappings. Network isolation is achieved on the container instance using security groups and VPC settings.
        :param 'TaskDefinitionLinuxParameters' linux_parameters: Linux-specific modifications that are applied to the container, such as Linux kernel capabilities. For more information see [KernelCapabilities](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_KernelCapabilities.html).
                 This parameter is not supported for Windows containers.
        :param 'TaskDefinitionLogConfiguration' log_configuration: The log configuration specification for the container.
                This parameter maps to ``LogConfig`` in the docker Create a container command and the ``--log-driver`` option to docker run. By default, containers use the same logging driver that the Docker daemon uses. However, the container may use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information on the options for different supported log drivers, see [Configure logging drivers](https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/) in the Docker documentation.
                 Amazon ECS currently supports a subset of the logging drivers available to the Docker daemon (shown in the [LogConfiguration](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_LogConfiguration.html) data type). Additional log drivers may be available in future releases of the Amazon ECS container agent.
                 This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: ``sudo docker version --format '{{.Server.APIVersion}}'``
                 The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the ``ECS_AVAILABLE_LOGGING_DRIVERS`` environment variable before containers placed on that instance can use these log configuration options. For more information, see [Container Agent Configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Developer Guide*.
        :param builtins.int memory: The amount (in MiB) of memory to present to the container. If your container attempts to exceed the memory specified here, the container is killed. The total amount of memory reserved for all containers within a task must be lower than the task ``memory`` value, if one is specified. This parameter maps to ``Memory`` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the ``--memory`` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration).
                If using the Fargate launch type, this parameter is optional.
                If using the EC2 launch type, you must specify either a task-level memory value or a container-level memory value. If you specify both a container-level ``memory`` and ``memoryReservation`` value, ``memory`` must be greater than ``memoryReservation``. If you specify ``memoryReservation``, then that value is subtracted from the available memory resources for the container instance where the container is placed. Otherwise, the value of ``memory`` is used.
                The Docker 20.10.0 or later daemon reserves a minimum of 6 MiB of memory for a container, so you should not specify fewer than 6 MiB of memory for your containers.
                The Docker 19.03.13-ce or earlier daemon reserves a minimum of 4 MiB of memory for a container, so you should not specify fewer than 4 MiB of memory for your containers.
        :param builtins.int memory_reservation: The soft limit (in MiB) of memory to reserve for the container. When system memory is under heavy contention, Docker attempts to keep the container memory to this soft limit. However, your container can consume more memory when it needs to, up to either the hard limit specified with the ``memory`` parameter (if applicable), or all of the available memory on the container instance, whichever comes first. This parameter maps to ``MemoryReservation`` in the docker container create command and the ``--memory-reservation`` option to docker run.
                If a task-level memory value is not specified, you must specify a non-zero integer for one or both of ``memory`` or ``memoryReservation`` in a container definition. If you specify both, ``memory`` must be greater than ``memoryReservation``. If you specify ``memoryReservation``, then that value is subtracted from the available memory resources for the container instance where the container is placed. Otherwise, the value of ``memory`` is used.
                For example, if your container normally uses 128 MiB of memory, but occasionally bursts to 256 MiB of memory for short periods of time, you can set a ``memoryReservation`` of 128 MiB, and a ``memory`` hard limit of 300 MiB. This configuration would allow the container to only reserve 128 MiB of memory from the remaining resources on the container instance, but also allow the container to consume more memory resources when needed.
                The Docker 20.10.0 or later daemon reserves a minimum of 6 MiB of memory for a container. So, don't specify less than 6 MiB of memory for your containers. 
                The Docker 19.03.13-ce or earlier daemon reserves a minimum of 4 MiB of memory for a container. So, don't specify less than 4 MiB of memory for your containers.
        :param Sequence['TaskDefinitionMountPoint'] mount_points: The mount points for data volumes in your container.
                This parameter maps to ``Volumes`` in the docker container create command and the ``--volume`` option to docker run.
                Windows containers can mount whole directories on the same drive as ``$env:ProgramData``. Windows containers can't mount directories on a different drive, and mount point can't be across drives.
        :param Sequence['TaskDefinitionPortMapping'] port_mappings: The list of port mappings for the container. Port mappings allow containers to access ports on the host container instance to send or receive traffic.
                For task definitions that use the ``awsvpc`` network mode, you should only specify the ``containerPort``. The ``hostPort`` can be left blank or it must be the same value as the ``containerPort``.
                Port mappings on Windows use the ``NetNAT`` gateway address rather than ``localhost``. There is no loopback for port mappings on Windows, so you cannot access a container's mapped port from the host itself. 
                This parameter maps to ``PortBindings`` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the ``--publish`` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/). If the network mode of a task definition is set to ``none``, then you can't specify port mappings. If the network mode of a task definition is set to ``host``, then host ports must either be undefined or they must match the container port in the port mapping.
                 After a task reaches the ``RUNNING`` status, manual and automatic host and container port assignments are visible in the *Network Bindings* section of a container description for a selected task in the Amazon ECS console. The assignments are also visible in the ``networkBindings`` section [DescribeTasks](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeTasks.html) responses.
        :param builtins.bool privileged: When this parameter is true, the container is given elevated privileges on the host container instance (similar to the ``root`` user). This parameter maps to ``Privileged`` in the docker container create command and the ``--privileged`` option to docker run
                 This parameter is not supported for Windows containers or tasks run on FARGATElong.
        :param builtins.bool pseudo_terminal: When this parameter is ``true``, a TTY is allocated. This parameter maps to ``Tty`` in the docker container create command and the ``--tty`` option to docker run.
        :param builtins.bool readonly_root_filesystem: When this parameter is true, the container is given read-only access to its root file system. This parameter maps to ``ReadonlyRootfs`` in the docker container create command and the ``--read-only`` option to docker run.
                 This parameter is not supported for Windows containers.
        :param 'TaskDefinitionRepositoryCredentials' repository_credentials: The private repository authentication credentials to use.
        :param Sequence['TaskDefinitionResourceRequirement'] resource_requirements: The type and amount of a resource to assign to a container. The only supported resource is a GPU.
        :param 'TaskDefinitionRestartPolicy' restart_policy: The restart policy for a container. When you set up a restart policy, Amazon ECS can restart the container without needing to replace the task. For more information, see [Restart individual containers in Amazon ECS tasks with container restart policies](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-restart-policy.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param Sequence['TaskDefinitionSecret'] secrets: The secrets to pass to the container. For more information, see [Specifying Sensitive Data](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param builtins.int start_timeout: Time duration (in seconds) to wait before giving up on resolving dependencies for a container. For example, you specify two containers in a task definition with containerA having a dependency on containerB reaching a ``COMPLETE``, ``SUCCESS``, or ``HEALTHY`` status. If a ``startTimeout`` value is specified for containerB and it doesn't reach the desired status within that time then containerA gives up and not start. This results in the task transitioning to a ``STOPPED`` state.
                 When the ``ECS_CONTAINER_START_TIMEOUT`` container agent configuration variable is used, it's enforced independently from this start timeout value.
                 For tasks using the Fargate launch type, the task or service requires the following platforms:
                 +  Linux platform version ``1.3.0`` or later.
                 +  Windows platform version ``1.0.0`` or later.
                 
                For tasks using the EC2 launch type, your container instances require at least version ``1.26.0`` of the container agent to use a container start timeout value. However, we recommend using the latest container agent version. For information about checking your agent version and updating to the latest version, see [Updating the Amazon ECS Container Agent](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html) in the *Amazon Elastic Container Service Developer Guide*. If you're using an Amazon ECS-optimized Linux AMI, your instance needs at least version ``1.26.0-1`` of the ``ecs-init`` package. If your container instances are launched from version ``20190301`` or later, then they contain the required versions of the container agent and ``ecs-init``. For more information, see [Amazon ECS-optimized Linux AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html) in the *Amazon Elastic Container Service Developer Guide*.
                The valid values for Fargate are 2-120 seconds.
        :param builtins.int stop_timeout: Time duration (in seconds) to wait before the container is forcefully killed if it doesn't exit normally on its own.
                For tasks using the Fargate launch type, the task or service requires the following platforms:
                 +  Linux platform version ``1.3.0`` or later.
                 +  Windows platform version ``1.0.0`` or later.
                 
                For tasks that use the Fargate launch type, the max stop timeout value is 120 seconds and if the parameter is not specified, the default value of 30 seconds is used.
                For tasks that use the EC2 launch type, if the ``stopTimeout`` parameter isn't specified, the value set for the Amazon ECS container agent configuration variable ``ECS_CONTAINER_STOP_TIMEOUT`` is used. If neither the ``stopTimeout`` parameter or the ``ECS_CONTAINER_STOP_TIMEOUT`` agent configuration variable are set, then the default values of 30 seconds for Linux containers and 30 seconds on Windows containers are used. Your container instances require at least version 1.26.0 of the container agent to use a container stop timeout value. However, we recommend using the latest container agent version. For information about checking your agent version and updating to the latest version, see [Updating the Amazon ECS Container Agent](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html) in the *Amazon Elastic Container Service Developer Guide*. If you're using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the ``ecs-init`` package. If your container instances are launched from version ``20190301`` or later, then they contain the required versions of the container agent and ``ecs-init``. For more information, see [Amazon ECS-optimized Linux AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html) in the *Amazon Elastic Container Service Developer Guide*.
                The valid values for Fargate are 2-120 seconds.
        :param Sequence['TaskDefinitionSystemControl'] system_controls: A list of namespaced kernel parameters to set in the container. This parameter maps to ``Sysctls`` in the docker container create command and the ``--sysctl`` option to docker run. For example, you can configure ``net.ipv4.tcp_keepalive_time`` setting to maintain longer lived connections.
        :param Sequence['TaskDefinitionUlimit'] ulimits: A list of ``ulimits`` to set in the container. This parameter maps to ``Ulimits`` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the ``--ulimit`` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/). Valid naming values are displayed in the [Ulimit](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_Ulimit.html) data type. This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: ``sudo docker version --format '{{.Server.APIVersion}}'``
                 This parameter is not supported for Windows containers.
        :param builtins.str user: The user to use inside the container. This parameter maps to ``User`` in the docker container create command and the ``--user`` option to docker run.
                 When running tasks using the ``host`` network mode, don't run containers using the root user (UID 0). We recommend using a non-root user for better security.
                 You can specify the ``user`` using the following formats. If specifying a UID or GID, you must specify it as a positive integer.
                 +   ``user`` 
                 +   ``user:group`` 
                 +   ``uid`` 
                 +   ``uid:gid`` 
                 +   ``user:gid`` 
                 +   ``uid:group`` 
                 
                 This parameter is not supported for Windows containers.
        :param 'TaskDefinitionContainerDefinitionVersionConsistency' version_consistency: Specifies whether Amazon ECS will resolve the container image tag provided in the container definition to an image digest. By default, the value is ``enabled``. If you set the value for a container as ``disabled``, Amazon ECS will not resolve the provided container image tag to a digest and will use the original image URI specified in the container definition for deployment. For more information about container image resolution, see [Container image resolution](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-ecs.html#deployment-container-image-stability) in the *Amazon ECS Developer Guide*.
        :param Sequence['TaskDefinitionVolumeFrom'] volumes_from: Data volumes to mount from another container. This parameter maps to ``VolumesFrom`` in the docker container create command and the ``--volumes-from`` option to docker run.
        :param builtins.str working_directory: The working directory to run commands inside the container in. This parameter maps to ``WorkingDir`` in the docker container create command and the ``--workdir`` option to docker run.
        """
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "name", name)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if credential_specs is not None:
            pulumi.set(__self__, "credential_specs", credential_specs)
        if depends_on is not None:
            pulumi.set(__self__, "depends_on", depends_on)
        if disable_networking is not None:
            pulumi.set(__self__, "disable_networking", disable_networking)
        if dns_search_domains is not None:
            pulumi.set(__self__, "dns_search_domains", dns_search_domains)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if docker_labels is not None:
            pulumi.set(__self__, "docker_labels", docker_labels)
        if docker_security_options is not None:
            pulumi.set(__self__, "docker_security_options", docker_security_options)
        if entry_point is not None:
            pulumi.set(__self__, "entry_point", entry_point)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if environment_files is not None:
            pulumi.set(__self__, "environment_files", environment_files)
        if essential is not None:
            pulumi.set(__self__, "essential", essential)
        if extra_hosts is not None:
            pulumi.set(__self__, "extra_hosts", extra_hosts)
        if firelens_configuration is not None:
            pulumi.set(__self__, "firelens_configuration", firelens_configuration)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if interactive is not None:
            pulumi.set(__self__, "interactive", interactive)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if linux_parameters is not None:
            pulumi.set(__self__, "linux_parameters", linux_parameters)
        if log_configuration is not None:
            pulumi.set(__self__, "log_configuration", log_configuration)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if memory_reservation is not None:
            pulumi.set(__self__, "memory_reservation", memory_reservation)
        if mount_points is not None:
            pulumi.set(__self__, "mount_points", mount_points)
        if port_mappings is not None:
            pulumi.set(__self__, "port_mappings", port_mappings)
        if privileged is not None:
            pulumi.set(__self__, "privileged", privileged)
        if pseudo_terminal is not None:
            pulumi.set(__self__, "pseudo_terminal", pseudo_terminal)
        if readonly_root_filesystem is not None:
            pulumi.set(__self__, "readonly_root_filesystem", readonly_root_filesystem)
        if repository_credentials is not None:
            pulumi.set(__self__, "repository_credentials", repository_credentials)
        if resource_requirements is not None:
            pulumi.set(__self__, "resource_requirements", resource_requirements)
        if restart_policy is not None:
            pulumi.set(__self__, "restart_policy", restart_policy)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if start_timeout is not None:
            pulumi.set(__self__, "start_timeout", start_timeout)
        if stop_timeout is not None:
            pulumi.set(__self__, "stop_timeout", stop_timeout)
        if system_controls is not None:
            pulumi.set(__self__, "system_controls", system_controls)
        if ulimits is not None:
            pulumi.set(__self__, "ulimits", ulimits)
        if user is not None:
            pulumi.set(__self__, "user", user)
        if version_consistency is not None:
            pulumi.set(__self__, "version_consistency", version_consistency)
        if volumes_from is not None:
            pulumi.set(__self__, "volumes_from", volumes_from)
        if working_directory is not None:
            pulumi.set(__self__, "working_directory", working_directory)

    @property
    @pulumi.getter
    def image(self) -> builtins.str:
        """
        The image used to start a container. This string is passed directly to the Docker daemon. By default, images in the Docker Hub registry are available. Other repositories are specified with either ``repository-url/image:tag`` or ``repository-url/image@digest``. Up to 255 letters (uppercase and lowercase), numbers, hyphens, underscores, colons, periods, forward slashes, and number signs are allowed. This parameter maps to ``Image`` in the docker container create command and the ``IMAGE`` parameter of docker run.
          +  When a new task starts, the Amazon ECS container agent pulls the latest version of the specified image and tag for the container to use. However, subsequent updates to a repository image aren't propagated to already running tasks.
          +  Images in Amazon ECR repositories can be specified by either using the full ``registry/repository:tag`` or ``registry/repository@digest``. For example, ``012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>:latest`` or ``012345678910.dkr.ecr.<region-name>.amazonaws.com/<repository-name>@sha256:94afd1f2e64d908bc90dbca0035a5b567EXAMPLE``. 
          +  Images in official repositories on Docker Hub use a single name (for example, ``ubuntu`` or ``mongo``).
          +  Images in other repositories on Docker Hub are qualified with an organization name (for example, ``amazon/amazon-ecs-agent``).
          +  Images in other online repositories are qualified further by a domain name (for example, ``quay.io/assemblyline/ubuntu``).
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of a container. If you're linking multiple containers together in a task definition, the ``name`` of one container can be entered in the ``links`` of another container to connect the containers. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. This parameter maps to ``name`` in the docker container create command and the ``--name`` option to docker run.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def command(self) -> Optional[Sequence[builtins.str]]:
        """
        The command that's passed to the container. This parameter maps to ``Cmd`` in the docker container create command and the ``COMMAND`` parameter to docker run. If there are multiple arguments, each argument is a separated string in the array.
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def cpu(self) -> Optional[builtins.int]:
        """
        The number of ``cpu`` units reserved for the container. This parameter maps to ``CpuShares`` in the docker container create commandand the ``--cpu-shares`` option to docker run.
         This field is optional for tasks using the Fargate launch type, and the only requirement is that the total amount of CPU reserved for all containers within a task be lower than the task-level ``cpu`` value.
          You can determine the number of CPU units that are available per EC2 instance type by multiplying the vCPUs listed for that instance type on the [Amazon EC2 Instances](https://docs.aws.amazon.com/ec2/instance-types/) detail page by 1,024.
          Linux containers share unallocated CPU units with other containers on the container instance with the same ratio as their allocated amount. For example, if you run a single-container task on a single-core instance type with 512 CPU units specified for that container, and that's the only task running on the container instance, that container could use the full 1,024 CPU unit share at any given time. However, if you launched another copy of the same task on that container instance, each task is guaranteed a minimum of 512 CPU units when needed. Moreover, each container could float to higher CPU usage if the other container was not using it. If both tasks were 100% active all of the time, they would be limited to 512 CPU units.
         On Linux container instances, the Docker daemon on the container instance uses the CPU value to calculate the relative CPU share ratios for running containers. The minimum valid CPU share value that the Linux kernel allows is 2, and the maximum valid CPU share value that the Linux kernel allows is 262144. However, the CPU parameter isn't required, and you can use CPU values below 2 or above 262144 in your container definitions. For CPU values below 2 (including null) or above 262144, the behavior varies based on your Amazon ECS container agent version:
          +  *Agent versions less than or equal to 1.1.0:* Null and zero CPU values are passed to Docker as 0, which Docker then converts to 1,024 CPU shares. CPU values of 1 are passed to Docker as 1, which the Linux kernel converts to two CPU shares.
          +  *Agent versions greater than or equal to 1.2.0:* Null, zero, and CPU values of 1 are passed to Docker as 2.
          +  *Agent versions greater than or equal to 1.84.0:* CPU values greater than 256 vCPU are passed to Docker as 256, which is equivalent to 262144 CPU shares.
          
         On Windows container instances, the CPU limit is enforced as an absolute limit, or a quota. Windows containers only have access to the specified amount of CPU that's described in the task definition. A null or zero CPU value is passed to Docker as ``0``, which Windows interprets as 1% of one CPU.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter(name="credentialSpecs")
    def credential_specs(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of ARNs in SSM or Amazon S3 to a credential spec (``CredSpec``) file that configures the container for Active Directory authentication. We recommend that you use this parameter instead of the ``dockerSecurityOptions``. The maximum number of ARNs is 1.
         There are two formats for each ARN.
          + credentialspecdomainless:MyARN You use credentialspecdomainless:MyARN to provide a CredSpec with an additional section for a secret in . You provide the login credentials to the domain in the secret. Each task that runs on any container instance can join different domains. You can use this format without joining the container instance to a domain. + credentialspec:MyARN You use credentialspec:MyARN to provide a CredSpec for a single domain. You must join the container instance to the domain before you start any tasks that use this task definition. 
         In both formats, replace ``MyARN`` with the ARN in SSM or Amazon S3.
         If you provide a ``credentialspecdomainless:MyARN``, the ``credspec`` must provide a ARN in ASMlong for a secret containing the username, password, and the domain to connect to. For better security, the instance isn't joined to the domain for domainless authentication. Other applications on the instance can't use the domainless credentials. You can use this parameter to run tasks on the same instance, even it the tasks need to join different domains. For more information, see [Using gMSAs for Windows Containers](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows-gmsa.html) and [Using gMSAs for Linux Containers](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/linux-gmsa.html).
        """
        return pulumi.get(self, "credential_specs")

    @property
    @pulumi.getter(name="dependsOn")
    def depends_on(self) -> Optional[Sequence['outputs.TaskDefinitionContainerDependency']]:
        """
        The dependencies defined for container startup and shutdown. A container can contain multiple dependencies. When a dependency is defined for container startup, for container shutdown it is reversed.
         For tasks using the EC2 launch type, the container instances require at least version 1.26.0 of the container agent to turn on container dependencies. However, we recommend using the latest container agent version. For information about checking your agent version and updating to the latest version, see [Updating the Amazon ECS Container Agent](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html) in the *Amazon Elastic Container Service Developer Guide*. If you're using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the ``ecs-init`` package. If your container instances are launched from version ``20190301`` or later, then they contain the required versions of the container agent and ``ecs-init``. For more information, see [Amazon ECS-optimized Linux AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html) in the *Amazon Elastic Container Service Developer Guide*.
         For tasks using the Fargate launch type, the task or service requires the following platforms:
          +  Linux platform version ``1.3.0`` or later.
          +  Windows platform version ``1.0.0`` or later.
          
         If the task definition is used in a blue/green deployment that uses [AWS::CodeDeploy::DeploymentGroup BlueGreenDeploymentConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codedeploy-deploymentgroup-bluegreendeploymentconfiguration.html), the ``dependsOn`` parameter is not supported. For more information see [Issue #680](https://docs.aws.amazon.com/https://github.com/aws-cloudformation/cloudformation-coverage-roadmap/issues/680) on the on the GitHub website.
        """
        return pulumi.get(self, "depends_on")

    @property
    @pulumi.getter(name="disableNetworking")
    def disable_networking(self) -> Optional[builtins.bool]:
        """
        When this parameter is true, networking is off within the container. This parameter maps to ``NetworkDisabled`` in the docker container create command.
          This parameter is not supported for Windows containers.
        """
        return pulumi.get(self, "disable_networking")

    @property
    @pulumi.getter(name="dnsSearchDomains")
    def dns_search_domains(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of DNS search domains that are presented to the container. This parameter maps to ``DnsSearch`` in the docker container create command and the ``--dns-search`` option to docker run.
          This parameter is not supported for Windows containers.
        """
        return pulumi.get(self, "dns_search_domains")

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of DNS servers that are presented to the container. This parameter maps to ``Dns`` in the docker container create command and the ``--dns`` option to docker run.
          This parameter is not supported for Windows containers.
        """
        return pulumi.get(self, "dns_servers")

    @property
    @pulumi.getter(name="dockerLabels")
    def docker_labels(self) -> Optional[Mapping[str, builtins.str]]:
        """
        A key/value map of labels to add to the container. This parameter maps to ``Labels`` in the docker container create command and the ``--label`` option to docker run. This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: ``sudo docker version --format '{{.Server.APIVersion}}'``
        """
        return pulumi.get(self, "docker_labels")

    @property
    @pulumi.getter(name="dockerSecurityOptions")
    def docker_security_options(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of strings to provide custom configuration for multiple security systems. This field isn't valid for containers in tasks using the Fargate launch type.
         For Linux tasks on EC2, this parameter can be used to reference custom labels for SELinux and AppArmor multi-level security systems.
         For any tasks on EC2, this parameter can be used to reference a credential spec file that configures a container for Active Directory authentication. For more information, see [Using gMSAs for Windows Containers](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows-gmsa.html) and [Using gMSAs for Linux Containers](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/linux-gmsa.html) in the *Amazon Elastic Container Service Developer Guide*.
         This parameter maps to ``SecurityOpt`` in the docker container create command and the ``--security-opt`` option to docker run.
          The Amazon ECS container agent running on a container instance must register with the ``ECS_SELINUX_CAPABLE=true`` or ``ECS_APPARMOR_CAPABLE=true`` environment variables before containers placed on that instance can use these security options. For more information, see [Amazon ECS Container Agent Configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Amazon Elastic Container Service Developer Guide*.
          Valid values: "no-new-privileges" | "apparmor:PROFILE" | "label:value" | "credentialspec:CredentialSpecFilePath"
        """
        return pulumi.get(self, "docker_security_options")

    @property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> Optional[Sequence[builtins.str]]:
        """
        Early versions of the Amazon ECS container agent don't properly handle ``entryPoint`` parameters. If you have problems using ``entryPoint``, update your container agent or enter your commands and arguments as ``command`` array items instead.
          The entry point that's passed to the container. This parameter maps to ``Entrypoint`` in the docker container create command and the ``--entrypoint`` option to docker run.
        """
        return pulumi.get(self, "entry_point")

    @property
    @pulumi.getter
    def environment(self) -> Optional[Sequence['outputs.TaskDefinitionKeyValuePair']]:
        """
        The environment variables to pass to a container. This parameter maps to ``Env`` in the docker container create command and the ``--env`` option to docker run.
          We don't recommend that you use plaintext environment variables for sensitive information, such as credential data.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="environmentFiles")
    def environment_files(self) -> Optional[Sequence['outputs.TaskDefinitionEnvironmentFile']]:
        """
        A list of files containing the environment variables to pass to a container. This parameter maps to the ``--env-file`` option to docker run.
         You can specify up to ten environment files. The file must have a ``.env`` file extension. Each line in an environment file contains an environment variable in ``VARIABLE=VALUE`` format. Lines beginning with ``#`` are treated as comments and are ignored.
         If there are environment variables specified using the ``environment`` parameter in a container definition, they take precedence over the variables contained within an environment file. If multiple environment files are specified that contain the same variable, they're processed from the top down. We recommend that you use unique variable names. For more information, see [Specifying Environment Variables](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/taskdef-envfiles.html) in the *Amazon Elastic Container Service Developer Guide*.
        """
        return pulumi.get(self, "environment_files")

    @property
    @pulumi.getter
    def essential(self) -> Optional[builtins.bool]:
        """
        If the ``essential`` parameter of a container is marked as ``true``, and that container fails or stops for any reason, all other containers that are part of the task are stopped. If the ``essential`` parameter of a container is marked as ``false``, its failure doesn't affect the rest of the containers in a task. If this parameter is omitted, a container is assumed to be essential.
         All tasks must have at least one essential container. If you have an application that's composed of multiple containers, group containers that are used for a common purpose into components, and separate the different components into multiple task definitions. For more information, see [Application Architecture](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/application_architecture.html) in the *Amazon Elastic Container Service Developer Guide*.
        """
        return pulumi.get(self, "essential")

    @property
    @pulumi.getter(name="extraHosts")
    def extra_hosts(self) -> Optional[Sequence['outputs.TaskDefinitionHostEntry']]:
        """
        A list of hostnames and IP address mappings to append to the ``/etc/hosts`` file on the container. This parameter maps to ``ExtraHosts`` in the docker container create command and the ``--add-host`` option to docker run.
          This parameter isn't supported for Windows containers or tasks that use the ``awsvpc`` network mode.
        """
        return pulumi.get(self, "extra_hosts")

    @property
    @pulumi.getter(name="firelensConfiguration")
    def firelens_configuration(self) -> Optional['outputs.TaskDefinitionFirelensConfiguration']:
        """
        The FireLens configuration for the container. This is used to specify and configure a log router for container logs. For more information, see [Custom Log Routing](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html) in the *Amazon Elastic Container Service Developer Guide*.
        """
        return pulumi.get(self, "firelens_configuration")

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional['outputs.TaskDefinitionHealthCheck']:
        """
        The container health check command and associated configuration parameters for the container. This parameter maps to ``HealthCheck`` in the docker container create command and the ``HEALTHCHECK`` parameter of docker run.
        """
        return pulumi.get(self, "health_check")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[builtins.str]:
        """
        The hostname to use for your container. This parameter maps to ``Hostname`` in the docker container create command and the ``--hostname`` option to docker run.
          The ``hostname`` parameter is not supported if you're using the ``awsvpc`` network mode.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def interactive(self) -> Optional[builtins.bool]:
        """
        When this parameter is ``true``, you can deploy containerized applications that require ``stdin`` or a ``tty`` to be allocated. This parameter maps to ``OpenStdin`` in the docker container create command and the ``--interactive`` option to docker run.
        """
        return pulumi.get(self, "interactive")

    @property
    @pulumi.getter
    def links(self) -> Optional[Sequence[builtins.str]]:
        """
        The ``links`` parameter allows containers to communicate with each other without the need for port mappings. This parameter is only supported if the network mode of a task definition is ``bridge``. The ``name:internalName`` construct is analogous to ``name:alias`` in Docker links. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed.. This parameter maps to ``Links`` in the docker container create command and the ``--link`` option to docker run.
          This parameter is not supported for Windows containers.
           Containers that are collocated on a single container instance may be able to communicate with each other without requiring links or host port mappings. Network isolation is achieved on the container instance using security groups and VPC settings.
        """
        return pulumi.get(self, "links")

    @property
    @pulumi.getter(name="linuxParameters")
    def linux_parameters(self) -> Optional['outputs.TaskDefinitionLinuxParameters']:
        """
        Linux-specific modifications that are applied to the container, such as Linux kernel capabilities. For more information see [KernelCapabilities](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_KernelCapabilities.html).
          This parameter is not supported for Windows containers.
        """
        return pulumi.get(self, "linux_parameters")

    @property
    @pulumi.getter(name="logConfiguration")
    def log_configuration(self) -> Optional['outputs.TaskDefinitionLogConfiguration']:
        """
        The log configuration specification for the container.
         This parameter maps to ``LogConfig`` in the docker Create a container command and the ``--log-driver`` option to docker run. By default, containers use the same logging driver that the Docker daemon uses. However, the container may use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information on the options for different supported log drivers, see [Configure logging drivers](https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/) in the Docker documentation.
          Amazon ECS currently supports a subset of the logging drivers available to the Docker daemon (shown in the [LogConfiguration](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_LogConfiguration.html) data type). Additional log drivers may be available in future releases of the Amazon ECS container agent.
          This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: ``sudo docker version --format '{{.Server.APIVersion}}'``
          The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the ``ECS_AVAILABLE_LOGGING_DRIVERS`` environment variable before containers placed on that instance can use these log configuration options. For more information, see [Container Agent Configuration](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html) in the *Developer Guide*.
        """
        return pulumi.get(self, "log_configuration")

    @property
    @pulumi.getter
    def memory(self) -> Optional[builtins.int]:
        """
        The amount (in MiB) of memory to present to the container. If your container attempts to exceed the memory specified here, the container is killed. The total amount of memory reserved for all containers within a task must be lower than the task ``memory`` value, if one is specified. This parameter maps to ``Memory`` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the ``--memory`` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/#security-configuration).
         If using the Fargate launch type, this parameter is optional.
         If using the EC2 launch type, you must specify either a task-level memory value or a container-level memory value. If you specify both a container-level ``memory`` and ``memoryReservation`` value, ``memory`` must be greater than ``memoryReservation``. If you specify ``memoryReservation``, then that value is subtracted from the available memory resources for the container instance where the container is placed. Otherwise, the value of ``memory`` is used.
         The Docker 20.10.0 or later daemon reserves a minimum of 6 MiB of memory for a container, so you should not specify fewer than 6 MiB of memory for your containers.
         The Docker 19.03.13-ce or earlier daemon reserves a minimum of 4 MiB of memory for a container, so you should not specify fewer than 4 MiB of memory for your containers.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter(name="memoryReservation")
    def memory_reservation(self) -> Optional[builtins.int]:
        """
        The soft limit (in MiB) of memory to reserve for the container. When system memory is under heavy contention, Docker attempts to keep the container memory to this soft limit. However, your container can consume more memory when it needs to, up to either the hard limit specified with the ``memory`` parameter (if applicable), or all of the available memory on the container instance, whichever comes first. This parameter maps to ``MemoryReservation`` in the docker container create command and the ``--memory-reservation`` option to docker run.
         If a task-level memory value is not specified, you must specify a non-zero integer for one or both of ``memory`` or ``memoryReservation`` in a container definition. If you specify both, ``memory`` must be greater than ``memoryReservation``. If you specify ``memoryReservation``, then that value is subtracted from the available memory resources for the container instance where the container is placed. Otherwise, the value of ``memory`` is used.
         For example, if your container normally uses 128 MiB of memory, but occasionally bursts to 256 MiB of memory for short periods of time, you can set a ``memoryReservation`` of 128 MiB, and a ``memory`` hard limit of 300 MiB. This configuration would allow the container to only reserve 128 MiB of memory from the remaining resources on the container instance, but also allow the container to consume more memory resources when needed.
         The Docker 20.10.0 or later daemon reserves a minimum of 6 MiB of memory for a container. So, don't specify less than 6 MiB of memory for your containers. 
         The Docker 19.03.13-ce or earlier daemon reserves a minimum of 4 MiB of memory for a container. So, don't specify less than 4 MiB of memory for your containers.
        """
        return pulumi.get(self, "memory_reservation")

    @property
    @pulumi.getter(name="mountPoints")
    def mount_points(self) -> Optional[Sequence['outputs.TaskDefinitionMountPoint']]:
        """
        The mount points for data volumes in your container.
         This parameter maps to ``Volumes`` in the docker container create command and the ``--volume`` option to docker run.
         Windows containers can mount whole directories on the same drive as ``$env:ProgramData``. Windows containers can't mount directories on a different drive, and mount point can't be across drives.
        """
        return pulumi.get(self, "mount_points")

    @property
    @pulumi.getter(name="portMappings")
    def port_mappings(self) -> Optional[Sequence['outputs.TaskDefinitionPortMapping']]:
        """
        The list of port mappings for the container. Port mappings allow containers to access ports on the host container instance to send or receive traffic.
         For task definitions that use the ``awsvpc`` network mode, you should only specify the ``containerPort``. The ``hostPort`` can be left blank or it must be the same value as the ``containerPort``.
         Port mappings on Windows use the ``NetNAT`` gateway address rather than ``localhost``. There is no loopback for port mappings on Windows, so you cannot access a container's mapped port from the host itself. 
         This parameter maps to ``PortBindings`` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the ``--publish`` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/). If the network mode of a task definition is set to ``none``, then you can't specify port mappings. If the network mode of a task definition is set to ``host``, then host ports must either be undefined or they must match the container port in the port mapping.
          After a task reaches the ``RUNNING`` status, manual and automatic host and container port assignments are visible in the *Network Bindings* section of a container description for a selected task in the Amazon ECS console. The assignments are also visible in the ``networkBindings`` section [DescribeTasks](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeTasks.html) responses.
        """
        return pulumi.get(self, "port_mappings")

    @property
    @pulumi.getter
    def privileged(self) -> Optional[builtins.bool]:
        """
        When this parameter is true, the container is given elevated privileges on the host container instance (similar to the ``root`` user). This parameter maps to ``Privileged`` in the docker container create command and the ``--privileged`` option to docker run
          This parameter is not supported for Windows containers or tasks run on FARGATElong.
        """
        return pulumi.get(self, "privileged")

    @property
    @pulumi.getter(name="pseudoTerminal")
    def pseudo_terminal(self) -> Optional[builtins.bool]:
        """
        When this parameter is ``true``, a TTY is allocated. This parameter maps to ``Tty`` in the docker container create command and the ``--tty`` option to docker run.
        """
        return pulumi.get(self, "pseudo_terminal")

    @property
    @pulumi.getter(name="readonlyRootFilesystem")
    def readonly_root_filesystem(self) -> Optional[builtins.bool]:
        """
        When this parameter is true, the container is given read-only access to its root file system. This parameter maps to ``ReadonlyRootfs`` in the docker container create command and the ``--read-only`` option to docker run.
          This parameter is not supported for Windows containers.
        """
        return pulumi.get(self, "readonly_root_filesystem")

    @property
    @pulumi.getter(name="repositoryCredentials")
    def repository_credentials(self) -> Optional['outputs.TaskDefinitionRepositoryCredentials']:
        """
        The private repository authentication credentials to use.
        """
        return pulumi.get(self, "repository_credentials")

    @property
    @pulumi.getter(name="resourceRequirements")
    def resource_requirements(self) -> Optional[Sequence['outputs.TaskDefinitionResourceRequirement']]:
        """
        The type and amount of a resource to assign to a container. The only supported resource is a GPU.
        """
        return pulumi.get(self, "resource_requirements")

    @property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> Optional['outputs.TaskDefinitionRestartPolicy']:
        """
        The restart policy for a container. When you set up a restart policy, Amazon ECS can restart the container without needing to replace the task. For more information, see [Restart individual containers in Amazon ECS tasks with container restart policies](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-restart-policy.html) in the *Amazon Elastic Container Service Developer Guide*.
        """
        return pulumi.get(self, "restart_policy")

    @property
    @pulumi.getter
    def secrets(self) -> Optional[Sequence['outputs.TaskDefinitionSecret']]:
        """
        The secrets to pass to the container. For more information, see [Specifying Sensitive Data](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html) in the *Amazon Elastic Container Service Developer Guide*.
        """
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter(name="startTimeout")
    def start_timeout(self) -> Optional[builtins.int]:
        """
        Time duration (in seconds) to wait before giving up on resolving dependencies for a container. For example, you specify two containers in a task definition with containerA having a dependency on containerB reaching a ``COMPLETE``, ``SUCCESS``, or ``HEALTHY`` status. If a ``startTimeout`` value is specified for containerB and it doesn't reach the desired status within that time then containerA gives up and not start. This results in the task transitioning to a ``STOPPED`` state.
          When the ``ECS_CONTAINER_START_TIMEOUT`` container agent configuration variable is used, it's enforced independently from this start timeout value.
          For tasks using the Fargate launch type, the task or service requires the following platforms:
          +  Linux platform version ``1.3.0`` or later.
          +  Windows platform version ``1.0.0`` or later.
          
         For tasks using the EC2 launch type, your container instances require at least version ``1.26.0`` of the container agent to use a container start timeout value. However, we recommend using the latest container agent version. For information about checking your agent version and updating to the latest version, see [Updating the Amazon ECS Container Agent](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html) in the *Amazon Elastic Container Service Developer Guide*. If you're using an Amazon ECS-optimized Linux AMI, your instance needs at least version ``1.26.0-1`` of the ``ecs-init`` package. If your container instances are launched from version ``20190301`` or later, then they contain the required versions of the container agent and ``ecs-init``. For more information, see [Amazon ECS-optimized Linux AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html) in the *Amazon Elastic Container Service Developer Guide*.
         The valid values for Fargate are 2-120 seconds.
        """
        return pulumi.get(self, "start_timeout")

    @property
    @pulumi.getter(name="stopTimeout")
    def stop_timeout(self) -> Optional[builtins.int]:
        """
        Time duration (in seconds) to wait before the container is forcefully killed if it doesn't exit normally on its own.
         For tasks using the Fargate launch type, the task or service requires the following platforms:
          +  Linux platform version ``1.3.0`` or later.
          +  Windows platform version ``1.0.0`` or later.
          
         For tasks that use the Fargate launch type, the max stop timeout value is 120 seconds and if the parameter is not specified, the default value of 30 seconds is used.
         For tasks that use the EC2 launch type, if the ``stopTimeout`` parameter isn't specified, the value set for the Amazon ECS container agent configuration variable ``ECS_CONTAINER_STOP_TIMEOUT`` is used. If neither the ``stopTimeout`` parameter or the ``ECS_CONTAINER_STOP_TIMEOUT`` agent configuration variable are set, then the default values of 30 seconds for Linux containers and 30 seconds on Windows containers are used. Your container instances require at least version 1.26.0 of the container agent to use a container stop timeout value. However, we recommend using the latest container agent version. For information about checking your agent version and updating to the latest version, see [Updating the Amazon ECS Container Agent](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html) in the *Amazon Elastic Container Service Developer Guide*. If you're using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the ``ecs-init`` package. If your container instances are launched from version ``20190301`` or later, then they contain the required versions of the container agent and ``ecs-init``. For more information, see [Amazon ECS-optimized Linux AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html) in the *Amazon Elastic Container Service Developer Guide*.
         The valid values for Fargate are 2-120 seconds.
        """
        return pulumi.get(self, "stop_timeout")

    @property
    @pulumi.getter(name="systemControls")
    def system_controls(self) -> Optional[Sequence['outputs.TaskDefinitionSystemControl']]:
        """
        A list of namespaced kernel parameters to set in the container. This parameter maps to ``Sysctls`` in the docker container create command and the ``--sysctl`` option to docker run. For example, you can configure ``net.ipv4.tcp_keepalive_time`` setting to maintain longer lived connections.
        """
        return pulumi.get(self, "system_controls")

    @property
    @pulumi.getter
    def ulimits(self) -> Optional[Sequence['outputs.TaskDefinitionUlimit']]:
        """
        A list of ``ulimits`` to set in the container. This parameter maps to ``Ulimits`` in the [Create a container](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/) and the ``--ulimit`` option to [docker run](https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/). Valid naming values are displayed in the [Ulimit](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_Ulimit.html) data type. This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: ``sudo docker version --format '{{.Server.APIVersion}}'``
          This parameter is not supported for Windows containers.
        """
        return pulumi.get(self, "ulimits")

    @property
    @pulumi.getter
    def user(self) -> Optional[builtins.str]:
        """
        The user to use inside the container. This parameter maps to ``User`` in the docker container create command and the ``--user`` option to docker run.
          When running tasks using the ``host`` network mode, don't run containers using the root user (UID 0). We recommend using a non-root user for better security.
          You can specify the ``user`` using the following formats. If specifying a UID or GID, you must specify it as a positive integer.
          +   ``user`` 
          +   ``user:group`` 
          +   ``uid`` 
          +   ``uid:gid`` 
          +   ``user:gid`` 
          +   ``uid:group`` 
          
          This parameter is not supported for Windows containers.
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="versionConsistency")
    def version_consistency(self) -> Optional['TaskDefinitionContainerDefinitionVersionConsistency']:
        """
        Specifies whether Amazon ECS will resolve the container image tag provided in the container definition to an image digest. By default, the value is ``enabled``. If you set the value for a container as ``disabled``, Amazon ECS will not resolve the provided container image tag to a digest and will use the original image URI specified in the container definition for deployment. For more information about container image resolution, see [Container image resolution](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-ecs.html#deployment-container-image-stability) in the *Amazon ECS Developer Guide*.
        """
        return pulumi.get(self, "version_consistency")

    @property
    @pulumi.getter(name="volumesFrom")
    def volumes_from(self) -> Optional[Sequence['outputs.TaskDefinitionVolumeFrom']]:
        """
        Data volumes to mount from another container. This parameter maps to ``VolumesFrom`` in the docker container create command and the ``--volumes-from`` option to docker run.
        """
        return pulumi.get(self, "volumes_from")

    @property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> Optional[builtins.str]:
        """
        The working directory to run commands inside the container in. This parameter maps to ``WorkingDir`` in the docker container create command and the ``--workdir`` option to docker run.
        """
        return pulumi.get(self, "working_directory")


@pulumi.output_type
class TaskDefinitionContainerDependency(dict):
    """
    The ``ContainerDependency`` property specifies the dependencies defined for container startup and shutdown. A container can contain multiple dependencies. When a dependency is defined for container startup, for container shutdown it is reversed.
     Your Amazon ECS container instances require at least version 1.26.0 of the container agent to enable container dependencies. However, we recommend using the latest container agent version. For information about checking your agent version and updating to the latest version, see [Updating the Amazon ECS Container Agent](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html) in the *Amazon Elastic Container Service Developer Guide*. If you are using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the ``ecs-init`` package. If your container instances are launched from version ``20190301`` or later, then they contain the required versions of the container agent and ``ecs-init``. For more information, see [Amazon ECS-optimized Linux AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html) in the *Amazon Elastic Container Service Developer Guide*.
      For tasks using the Fargate launch type, this parameter requires that the task or service uses platform version 1.3.0 or later.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionContainerDependency. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionContainerDependency.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionContainerDependency.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 condition: Optional[builtins.str] = None,
                 container_name: Optional[builtins.str] = None):
        """
        The ``ContainerDependency`` property specifies the dependencies defined for container startup and shutdown. A container can contain multiple dependencies. When a dependency is defined for container startup, for container shutdown it is reversed.
         Your Amazon ECS container instances require at least version 1.26.0 of the container agent to enable container dependencies. However, we recommend using the latest container agent version. For information about checking your agent version and updating to the latest version, see [Updating the Amazon ECS Container Agent](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html) in the *Amazon Elastic Container Service Developer Guide*. If you are using an Amazon ECS-optimized Linux AMI, your instance needs at least version 1.26.0-1 of the ``ecs-init`` package. If your container instances are launched from version ``20190301`` or later, then they contain the required versions of the container agent and ``ecs-init``. For more information, see [Amazon ECS-optimized Linux AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html) in the *Amazon Elastic Container Service Developer Guide*.
          For tasks using the Fargate launch type, this parameter requires that the task or service uses platform version 1.3.0 or later.
        :param builtins.str condition: The dependency condition of the container. The following are the available conditions and their behavior:
                 +  ``START`` - This condition emulates the behavior of links and volumes today. It validates that a dependent container is started before permitting other containers to start.
                 +  ``COMPLETE`` - This condition validates that a dependent container runs to completion (exits) before permitting other containers to start. This can be useful for nonessential containers that run a script and then exit. This condition can't be set on an essential container.
                 +  ``SUCCESS`` - This condition is the same as ``COMPLETE``, but it also requires that the container exits with a ``zero`` status. This condition can't be set on an essential container.
                 +  ``HEALTHY`` - This condition validates that the dependent container passes its Docker health check before permitting other containers to start. This requires that the dependent container has health checks configured. This condition is confirmed only at task startup.
        :param builtins.str container_name: The name of a container.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)

    @property
    @pulumi.getter
    def condition(self) -> Optional[builtins.str]:
        """
        The dependency condition of the container. The following are the available conditions and their behavior:
          +  ``START`` - This condition emulates the behavior of links and volumes today. It validates that a dependent container is started before permitting other containers to start.
          +  ``COMPLETE`` - This condition validates that a dependent container runs to completion (exits) before permitting other containers to start. This can be useful for nonessential containers that run a script and then exit. This condition can't be set on an essential container.
          +  ``SUCCESS`` - This condition is the same as ``COMPLETE``, but it also requires that the container exits with a ``zero`` status. This condition can't be set on an essential container.
          +  ``HEALTHY`` - This condition validates that the dependent container passes its Docker health check before permitting other containers to start. This requires that the dependent container has health checks configured. This condition is confirmed only at task startup.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[builtins.str]:
        """
        The name of a container.
        """
        return pulumi.get(self, "container_name")


@pulumi.output_type
class TaskDefinitionDevice(dict):
    """
    The ``Device`` property specifies an object representing a container instance host device.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerPath":
            suggest = "container_path"
        elif key == "hostPath":
            suggest = "host_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionDevice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionDevice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionDevice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_path: Optional[builtins.str] = None,
                 host_path: Optional[builtins.str] = None,
                 permissions: Optional[Sequence[builtins.str]] = None):
        """
        The ``Device`` property specifies an object representing a container instance host device.
        :param builtins.str container_path: The path inside the container at which to expose the host device.
        :param builtins.str host_path: The path for the device on the host container instance.
        :param Sequence[builtins.str] permissions: The explicit permissions to provide to the container for the device. By default, the container has permissions for ``read``, ``write``, and ``mknod`` for the device.
        """
        if container_path is not None:
            pulumi.set(__self__, "container_path", container_path)
        if host_path is not None:
            pulumi.set(__self__, "host_path", host_path)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter(name="containerPath")
    def container_path(self) -> Optional[builtins.str]:
        """
        The path inside the container at which to expose the host device.
        """
        return pulumi.get(self, "container_path")

    @property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> Optional[builtins.str]:
        """
        The path for the device on the host container instance.
        """
        return pulumi.get(self, "host_path")

    @property
    @pulumi.getter
    def permissions(self) -> Optional[Sequence[builtins.str]]:
        """
        The explicit permissions to provide to the container for the device. By default, the container has permissions for ``read``, ``write``, and ``mknod`` for the device.
        """
        return pulumi.get(self, "permissions")


@pulumi.output_type
class TaskDefinitionDockerVolumeConfiguration(dict):
    """
    The ``DockerVolumeConfiguration`` property specifies a Docker volume configuration and is used when you use Docker volumes. Docker volumes are only supported when you are using the EC2 launch type. Windows containers only support the use of the ``local`` driver. To use bind mounts, specify a ``host`` instead.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverOpts":
            suggest = "driver_opts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionDockerVolumeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionDockerVolumeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionDockerVolumeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoprovision: Optional[builtins.bool] = None,
                 driver: Optional[builtins.str] = None,
                 driver_opts: Optional[Mapping[str, builtins.str]] = None,
                 labels: Optional[Mapping[str, builtins.str]] = None,
                 scope: Optional[builtins.str] = None):
        """
        The ``DockerVolumeConfiguration`` property specifies a Docker volume configuration and is used when you use Docker volumes. Docker volumes are only supported when you are using the EC2 launch type. Windows containers only support the use of the ``local`` driver. To use bind mounts, specify a ``host`` instead.
        :param builtins.bool autoprovision: If this value is ``true``, the Docker volume is created if it doesn't already exist.
                 This field is only used if the ``scope`` is ``shared``.
        :param builtins.str driver: The Docker volume driver to use. The driver value must match the driver name provided by Docker because it is used for task placement. If the driver was installed using the Docker plugin CLI, use ``docker plugin ls`` to retrieve the driver name from your container instance. If the driver was installed using another method, use Docker plugin discovery to retrieve the driver name. This parameter maps to ``Driver`` in the docker container create command and the ``xxdriver`` option to docker volume create.
        :param Mapping[str, builtins.str] driver_opts: A map of Docker driver-specific options passed through. This parameter maps to ``DriverOpts`` in the docker create-volume command and the ``xxopt`` option to docker volume create.
        :param Mapping[str, builtins.str] labels: Custom metadata to add to your Docker volume. This parameter maps to ``Labels`` in the docker container create command and the ``xxlabel`` option to docker volume create.
        :param builtins.str scope: The scope for the Docker volume that determines its lifecycle. Docker volumes that are scoped to a ``task`` are automatically provisioned when the task starts and destroyed when the task stops. Docker volumes that are scoped as ``shared`` persist after the task stops.
        """
        if autoprovision is not None:
            pulumi.set(__self__, "autoprovision", autoprovision)
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if driver_opts is not None:
            pulumi.set(__self__, "driver_opts", driver_opts)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def autoprovision(self) -> Optional[builtins.bool]:
        """
        If this value is ``true``, the Docker volume is created if it doesn't already exist.
          This field is only used if the ``scope`` is ``shared``.
        """
        return pulumi.get(self, "autoprovision")

    @property
    @pulumi.getter
    def driver(self) -> Optional[builtins.str]:
        """
        The Docker volume driver to use. The driver value must match the driver name provided by Docker because it is used for task placement. If the driver was installed using the Docker plugin CLI, use ``docker plugin ls`` to retrieve the driver name from your container instance. If the driver was installed using another method, use Docker plugin discovery to retrieve the driver name. This parameter maps to ``Driver`` in the docker container create command and the ``xxdriver`` option to docker volume create.
        """
        return pulumi.get(self, "driver")

    @property
    @pulumi.getter(name="driverOpts")
    def driver_opts(self) -> Optional[Mapping[str, builtins.str]]:
        """
        A map of Docker driver-specific options passed through. This parameter maps to ``DriverOpts`` in the docker create-volume command and the ``xxopt`` option to docker volume create.
        """
        return pulumi.get(self, "driver_opts")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Custom metadata to add to your Docker volume. This parameter maps to ``Labels`` in the docker container create command and the ``xxlabel`` option to docker volume create.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def scope(self) -> Optional[builtins.str]:
        """
        The scope for the Docker volume that determines its lifecycle. Docker volumes that are scoped to a ``task`` are automatically provisioned when the task starts and destroyed when the task stops. Docker volumes that are scoped as ``shared`` persist after the task stops.
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class TaskDefinitionEfsVolumeConfiguration(dict):
    """
    This parameter is specified when you're using an Amazon Elastic File System file system for task storage. For more information, see [Amazon EFS volumes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/efs-volumes.html) in the *Amazon Elastic Container Service Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filesystemId":
            suggest = "filesystem_id"
        elif key == "authorizationConfig":
            suggest = "authorization_config"
        elif key == "rootDirectory":
            suggest = "root_directory"
        elif key == "transitEncryption":
            suggest = "transit_encryption"
        elif key == "transitEncryptionPort":
            suggest = "transit_encryption_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionEfsVolumeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionEfsVolumeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionEfsVolumeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filesystem_id: builtins.str,
                 authorization_config: Optional['outputs.TaskDefinitionAuthorizationConfig'] = None,
                 root_directory: Optional[builtins.str] = None,
                 transit_encryption: Optional['TaskDefinitionEfsVolumeConfigurationTransitEncryption'] = None,
                 transit_encryption_port: Optional[builtins.int] = None):
        """
        This parameter is specified when you're using an Amazon Elastic File System file system for task storage. For more information, see [Amazon EFS volumes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/efs-volumes.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param builtins.str filesystem_id: The Amazon EFS file system ID to use.
        :param 'TaskDefinitionAuthorizationConfig' authorization_config: The authorization configuration details for the Amazon EFS file system.
        :param builtins.str root_directory: The directory within the Amazon EFS file system to mount as the root directory inside the host. If this parameter is omitted, the root of the Amazon EFS volume will be used. Specifying ``/`` will have the same effect as omitting this parameter.
                 If an EFS access point is specified in the ``authorizationConfig``, the root directory parameter must either be omitted or set to ``/`` which will enforce the path set on the EFS access point.
        :param 'TaskDefinitionEfsVolumeConfigurationTransitEncryption' transit_encryption: Determines whether to use encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server. Transit encryption must be turned on if Amazon EFS IAM authorization is used. If this parameter is omitted, the default value of ``DISABLED`` is used. For more information, see [Encrypting data in transit](https://docs.aws.amazon.com/efs/latest/ug/encryption-in-transit.html) in the *Amazon Elastic File System User Guide*.
        :param builtins.int transit_encryption_port: The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server. If you do not specify a transit encryption port, it will use the port selection strategy that the Amazon EFS mount helper uses. For more information, see [EFS mount helper](https://docs.aws.amazon.com/efs/latest/ug/efs-mount-helper.html) in the *Amazon Elastic File System User Guide*.
        """
        pulumi.set(__self__, "filesystem_id", filesystem_id)
        if authorization_config is not None:
            pulumi.set(__self__, "authorization_config", authorization_config)
        if root_directory is not None:
            pulumi.set(__self__, "root_directory", root_directory)
        if transit_encryption is not None:
            pulumi.set(__self__, "transit_encryption", transit_encryption)
        if transit_encryption_port is not None:
            pulumi.set(__self__, "transit_encryption_port", transit_encryption_port)

    @property
    @pulumi.getter(name="filesystemId")
    def filesystem_id(self) -> builtins.str:
        """
        The Amazon EFS file system ID to use.
        """
        return pulumi.get(self, "filesystem_id")

    @property
    @pulumi.getter(name="authorizationConfig")
    def authorization_config(self) -> Optional['outputs.TaskDefinitionAuthorizationConfig']:
        """
        The authorization configuration details for the Amazon EFS file system.
        """
        return pulumi.get(self, "authorization_config")

    @property
    @pulumi.getter(name="rootDirectory")
    def root_directory(self) -> Optional[builtins.str]:
        """
        The directory within the Amazon EFS file system to mount as the root directory inside the host. If this parameter is omitted, the root of the Amazon EFS volume will be used. Specifying ``/`` will have the same effect as omitting this parameter.
          If an EFS access point is specified in the ``authorizationConfig``, the root directory parameter must either be omitted or set to ``/`` which will enforce the path set on the EFS access point.
        """
        return pulumi.get(self, "root_directory")

    @property
    @pulumi.getter(name="transitEncryption")
    def transit_encryption(self) -> Optional['TaskDefinitionEfsVolumeConfigurationTransitEncryption']:
        """
        Determines whether to use encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server. Transit encryption must be turned on if Amazon EFS IAM authorization is used. If this parameter is omitted, the default value of ``DISABLED`` is used. For more information, see [Encrypting data in transit](https://docs.aws.amazon.com/efs/latest/ug/encryption-in-transit.html) in the *Amazon Elastic File System User Guide*.
        """
        return pulumi.get(self, "transit_encryption")

    @property
    @pulumi.getter(name="transitEncryptionPort")
    def transit_encryption_port(self) -> Optional[builtins.int]:
        """
        The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server. If you do not specify a transit encryption port, it will use the port selection strategy that the Amazon EFS mount helper uses. For more information, see [EFS mount helper](https://docs.aws.amazon.com/efs/latest/ug/efs-mount-helper.html) in the *Amazon Elastic File System User Guide*.
        """
        return pulumi.get(self, "transit_encryption_port")


@pulumi.output_type
class TaskDefinitionEnvironmentFile(dict):
    """
    A list of files containing the environment variables to pass to a container. You can specify up to ten environment files. The file must have a ``.env`` file extension. Each line in an environment file should contain an environment variable in ``VARIABLE=VALUE`` format. Lines beginning with ``#`` are treated as comments and are ignored.
     If there are environment variables specified using the ``environment`` parameter in a container definition, they take precedence over the variables contained within an environment file. If multiple environment files are specified that contain the same variable, they're processed from the top down. We recommend that you use unique variable names. For more information, see [Use a file to pass environment variables to a container](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/use-environment-file.html) in the *Amazon Elastic Container Service Developer Guide*.
     Environment variable files are objects in Amazon S3 and all Amazon S3 security considerations apply. 
     You must use the following platforms for the Fargate launch type:
      +  Linux platform version ``1.4.0`` or later.
      +  Windows platform version ``1.0.0`` or later.
      
     Consider the following when using the Fargate launch type:
      +  The file is handled like a native Docker env-file.
      +  There is no support for shell escape handling.
      +  The container entry point interperts the ``VARIABLE`` values.
    """
    def __init__(__self__, *,
                 type: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        A list of files containing the environment variables to pass to a container. You can specify up to ten environment files. The file must have a ``.env`` file extension. Each line in an environment file should contain an environment variable in ``VARIABLE=VALUE`` format. Lines beginning with ``#`` are treated as comments and are ignored.
         If there are environment variables specified using the ``environment`` parameter in a container definition, they take precedence over the variables contained within an environment file. If multiple environment files are specified that contain the same variable, they're processed from the top down. We recommend that you use unique variable names. For more information, see [Use a file to pass environment variables to a container](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/use-environment-file.html) in the *Amazon Elastic Container Service Developer Guide*.
         Environment variable files are objects in Amazon S3 and all Amazon S3 security considerations apply. 
         You must use the following platforms for the Fargate launch type:
          +  Linux platform version ``1.4.0`` or later.
          +  Windows platform version ``1.0.0`` or later.
          
         Consider the following when using the Fargate launch type:
          +  The file is handled like a native Docker env-file.
          +  There is no support for shell escape handling.
          +  The container entry point interperts the ``VARIABLE`` values.
        :param builtins.str type: The file type to use. Environment files are objects in Amazon S3. The only supported value is ``s3``.
        :param builtins.str value: The Amazon Resource Name (ARN) of the Amazon S3 object containing the environment variable file.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The file type to use. Environment files are objects in Amazon S3. The only supported value is ``s3``.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Amazon S3 object containing the environment variable file.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class TaskDefinitionEphemeralStorage(dict):
    """
    The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on FARGATElong. For more information, see [Using data volumes in tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html) in the *Amazon ECS Developer Guide;*.
      For tasks using the Fargate launch type, the task requires the following platforms:
      +  Linux platform version ``1.4.0`` or later.
      +  Windows platform version ``1.0.0`` or later.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeInGiB":
            suggest = "size_in_gi_b"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionEphemeralStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionEphemeralStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionEphemeralStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size_in_gi_b: Optional[builtins.int] = None):
        """
        The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on FARGATElong. For more information, see [Using data volumes in tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html) in the *Amazon ECS Developer Guide;*.
          For tasks using the Fargate launch type, the task requires the following platforms:
          +  Linux platform version ``1.4.0`` or later.
          +  Windows platform version ``1.0.0`` or later.
        :param builtins.int size_in_gi_b: The total amount, in GiB, of ephemeral storage to set for the task. The minimum supported value is ``21`` GiB and the maximum supported value is ``200`` GiB.
        """
        if size_in_gi_b is not None:
            pulumi.set(__self__, "size_in_gi_b", size_in_gi_b)

    @property
    @pulumi.getter(name="sizeInGiB")
    def size_in_gi_b(self) -> Optional[builtins.int]:
        """
        The total amount, in GiB, of ephemeral storage to set for the task. The minimum supported value is ``21`` GiB and the maximum supported value is ``200`` GiB.
        """
        return pulumi.get(self, "size_in_gi_b")


@pulumi.output_type
class TaskDefinitionFSxAuthorizationConfig(dict):
    """
    The authorization configuration details for Amazon FSx for Windows File Server file system. See [FSxWindowsFileServerVolumeConfiguration](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_FSxWindowsFileServerVolumeConfiguration.html) in the *Amazon ECS API Reference*.
     For more information and the input format, see [Amazon FSx for Windows File Server Volumes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/wfsx-volumes.html) in the *Amazon Elastic Container Service Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialsParameter":
            suggest = "credentials_parameter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionFSxAuthorizationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionFSxAuthorizationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionFSxAuthorizationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credentials_parameter: builtins.str,
                 domain: builtins.str):
        """
        The authorization configuration details for Amazon FSx for Windows File Server file system. See [FSxWindowsFileServerVolumeConfiguration](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_FSxWindowsFileServerVolumeConfiguration.html) in the *Amazon ECS API Reference*.
         For more information and the input format, see [Amazon FSx for Windows File Server Volumes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/wfsx-volumes.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param builtins.str credentials_parameter: The authorization credential option to use. The authorization credential options can be provided using either the Amazon Resource Name (ARN) of an ASMlong secret or SSM Parameter Store parameter. The ARN refers to the stored credentials.
        :param builtins.str domain: A fully qualified domain name hosted by an [](https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_microsoft_ad.html) Managed Microsoft AD (Active Directory) or self-hosted AD on Amazon EC2.
        """
        pulumi.set(__self__, "credentials_parameter", credentials_parameter)
        pulumi.set(__self__, "domain", domain)

    @property
    @pulumi.getter(name="credentialsParameter")
    def credentials_parameter(self) -> builtins.str:
        """
        The authorization credential option to use. The authorization credential options can be provided using either the Amazon Resource Name (ARN) of an ASMlong secret or SSM Parameter Store parameter. The ARN refers to the stored credentials.
        """
        return pulumi.get(self, "credentials_parameter")

    @property
    @pulumi.getter
    def domain(self) -> builtins.str:
        """
        A fully qualified domain name hosted by an [](https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_microsoft_ad.html) Managed Microsoft AD (Active Directory) or self-hosted AD on Amazon EC2.
        """
        return pulumi.get(self, "domain")


@pulumi.output_type
class TaskDefinitionFSxWindowsFileServerVolumeConfiguration(dict):
    """
    This parameter is specified when you're using [Amazon FSx for Windows File Server](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/what-is.html) file system for task storage.
     For more information and the input format, see [Amazon FSx for Windows File Server volumes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/wfsx-volumes.html) in the *Amazon Elastic Container Service Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileSystemId":
            suggest = "file_system_id"
        elif key == "rootDirectory":
            suggest = "root_directory"
        elif key == "authorizationConfig":
            suggest = "authorization_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionFSxWindowsFileServerVolumeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionFSxWindowsFileServerVolumeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionFSxWindowsFileServerVolumeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_system_id: builtins.str,
                 root_directory: builtins.str,
                 authorization_config: Optional['outputs.TaskDefinitionFSxAuthorizationConfig'] = None):
        """
        This parameter is specified when you're using [Amazon FSx for Windows File Server](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/what-is.html) file system for task storage.
         For more information and the input format, see [Amazon FSx for Windows File Server volumes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/wfsx-volumes.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param builtins.str file_system_id: The Amazon FSx for Windows File Server file system ID to use.
        :param builtins.str root_directory: The directory within the Amazon FSx for Windows File Server file system to mount as the root directory inside the host.
        :param 'TaskDefinitionFSxAuthorizationConfig' authorization_config: The authorization configuration details for the Amazon FSx for Windows File Server file system.
        """
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "root_directory", root_directory)
        if authorization_config is not None:
            pulumi.set(__self__, "authorization_config", authorization_config)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> builtins.str:
        """
        The Amazon FSx for Windows File Server file system ID to use.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="rootDirectory")
    def root_directory(self) -> builtins.str:
        """
        The directory within the Amazon FSx for Windows File Server file system to mount as the root directory inside the host.
        """
        return pulumi.get(self, "root_directory")

    @property
    @pulumi.getter(name="authorizationConfig")
    def authorization_config(self) -> Optional['outputs.TaskDefinitionFSxAuthorizationConfig']:
        """
        The authorization configuration details for the Amazon FSx for Windows File Server file system.
        """
        return pulumi.get(self, "authorization_config")


@pulumi.output_type
class TaskDefinitionFirelensConfiguration(dict):
    """
    The FireLens configuration for the container. This is used to specify and configure a log router for container logs. For more information, see [Custom log routing](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html) in the *Amazon Elastic Container Service Developer Guide*.
    """
    def __init__(__self__, *,
                 options: Optional[Mapping[str, builtins.str]] = None,
                 type: Optional[builtins.str] = None):
        """
        The FireLens configuration for the container. This is used to specify and configure a log router for container logs. For more information, see [Custom log routing](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param Mapping[str, builtins.str] options: The options to use when configuring the log router. This field is optional and can be used to add additional metadata, such as the task, task definition, cluster, and container instance details to the log event.
                 If specified, valid option keys are:
                 +  ``enable-ecs-log-metadata``, which can be ``true`` or ``false``
                 +  ``config-file-type``, which can be ``s3`` or ``file``
                 +  ``config-file-value``, which is either an S3 ARN or a file path
        :param builtins.str type: The log router to use. The valid values are ``fluentd`` or ``fluentbit``.
        """
        if options is not None:
            pulumi.set(__self__, "options", options)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def options(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The options to use when configuring the log router. This field is optional and can be used to add additional metadata, such as the task, task definition, cluster, and container instance details to the log event.
          If specified, valid option keys are:
          +  ``enable-ecs-log-metadata``, which can be ``true`` or ``false``
          +  ``config-file-type``, which can be ``s3`` or ``file``
          +  ``config-file-value``, which is either an S3 ARN or a file path
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The log router to use. The valid values are ``fluentd`` or ``fluentbit``.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class TaskDefinitionHealthCheck(dict):
    """
    The ``HealthCheck`` property specifies an object representing a container health check. Health check parameters that are specified in a container definition override any Docker health checks that exist in the container image (such as those specified in a parent image or from the image's Dockerfile). This configuration maps to the ``HEALTHCHECK`` parameter of docker run.
      The Amazon ECS container agent only monitors and reports on the health checks specified in the task definition. Amazon ECS does not monitor Docker health checks that are embedded in a container image and not specified in the container definition. Health check parameters that are specified in a container definition override any Docker health checks that exist in the container image.
      If a task is run manually, and not as part of a service, the task will continue its lifecycle regardless of its health status. For tasks that are part of a service, if the task reports as unhealthy then the task will be stopped and the service scheduler will replace it.
     The following are notes about container health check support:
      +  Container health checks require version 1.17.0 or greater of the Amazon ECS container agent. For more information, see [Updating the Amazon ECS Container Agent](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html).
      +  Container health checks are supported for Fargate tasks if you are using platform version 1.1.0 or greater. For more information, see [Platform Versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
      +  Container health checks are not supported for tasks that are part of a service that is configured to use a Classic Load Balancer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startPeriod":
            suggest = "start_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionHealthCheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionHealthCheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionHealthCheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 command: Optional[Sequence[builtins.str]] = None,
                 interval: Optional[builtins.int] = None,
                 retries: Optional[builtins.int] = None,
                 start_period: Optional[builtins.int] = None,
                 timeout: Optional[builtins.int] = None):
        """
        The ``HealthCheck`` property specifies an object representing a container health check. Health check parameters that are specified in a container definition override any Docker health checks that exist in the container image (such as those specified in a parent image or from the image's Dockerfile). This configuration maps to the ``HEALTHCHECK`` parameter of docker run.
          The Amazon ECS container agent only monitors and reports on the health checks specified in the task definition. Amazon ECS does not monitor Docker health checks that are embedded in a container image and not specified in the container definition. Health check parameters that are specified in a container definition override any Docker health checks that exist in the container image.
          If a task is run manually, and not as part of a service, the task will continue its lifecycle regardless of its health status. For tasks that are part of a service, if the task reports as unhealthy then the task will be stopped and the service scheduler will replace it.
         The following are notes about container health check support:
          +  Container health checks require version 1.17.0 or greater of the Amazon ECS container agent. For more information, see [Updating the Amazon ECS Container Agent](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-update.html).
          +  Container health checks are supported for Fargate tasks if you are using platform version 1.1.0 or greater. For more information, see [Platform Versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
          +  Container health checks are not supported for tasks that are part of a service that is configured to use a Classic Load Balancer.
        :param Sequence[builtins.str] command: A string array representing the command that the container runs to determine if it is healthy. The string array must start with ``CMD`` to run the command arguments directly, or ``CMD-SHELL`` to run the command with the container's default shell. 
                 When you use the AWS Management Console JSON panel, the CLIlong, or the APIs, enclose the list of commands in double quotes and brackets.
                 ``[ "CMD-SHELL", "curl -f http://localhost/ || exit 1" ]`` 
                You don't include the double quotes and brackets when you use the AWS Management Console.
                 ``CMD-SHELL, curl -f http://localhost/ || exit 1`` 
                An exit code of 0 indicates success, and non-zero exit code indicates failure. For more information, see ``HealthCheck`` in the docker container create command.
        :param builtins.int interval: The time period in seconds between each health check execution. You may specify between 5 and 300 seconds. The default value is 30 seconds. This value applies only when you specify a ``command``.
        :param builtins.int retries: The number of times to retry a failed health check before the container is considered unhealthy. You may specify between 1 and 10 retries. The default value is 3. This value applies only when you specify a ``command``.
        :param builtins.int start_period: The optional grace period to provide containers time to bootstrap before failed health checks count towards the maximum number of retries. You can specify between 0 and 300 seconds. By default, the ``startPeriod`` is off. This value applies only when you specify a ``command``. 
                 If a health check succeeds within the ``startPeriod``, then the container is considered healthy and any subsequent failures count toward the maximum number of retries.
        :param builtins.int timeout: The time period in seconds to wait for a health check to succeed before it is considered a failure. You may specify between 2 and 60 seconds. The default value is 5. This value applies only when you specify a ``command``.
        """
        if command is not None:
            pulumi.set(__self__, "command", command)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if start_period is not None:
            pulumi.set(__self__, "start_period", start_period)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def command(self) -> Optional[Sequence[builtins.str]]:
        """
        A string array representing the command that the container runs to determine if it is healthy. The string array must start with ``CMD`` to run the command arguments directly, or ``CMD-SHELL`` to run the command with the container's default shell. 
          When you use the AWS Management Console JSON panel, the CLIlong, or the APIs, enclose the list of commands in double quotes and brackets.
          ``[ "CMD-SHELL", "curl -f http://localhost/ || exit 1" ]`` 
         You don't include the double quotes and brackets when you use the AWS Management Console.
          ``CMD-SHELL, curl -f http://localhost/ || exit 1`` 
         An exit code of 0 indicates success, and non-zero exit code indicates failure. For more information, see ``HealthCheck`` in the docker container create command.
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def interval(self) -> Optional[builtins.int]:
        """
        The time period in seconds between each health check execution. You may specify between 5 and 300 seconds. The default value is 30 seconds. This value applies only when you specify a ``command``.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def retries(self) -> Optional[builtins.int]:
        """
        The number of times to retry a failed health check before the container is considered unhealthy. You may specify between 1 and 10 retries. The default value is 3. This value applies only when you specify a ``command``.
        """
        return pulumi.get(self, "retries")

    @property
    @pulumi.getter(name="startPeriod")
    def start_period(self) -> Optional[builtins.int]:
        """
        The optional grace period to provide containers time to bootstrap before failed health checks count towards the maximum number of retries. You can specify between 0 and 300 seconds. By default, the ``startPeriod`` is off. This value applies only when you specify a ``command``. 
          If a health check succeeds within the ``startPeriod``, then the container is considered healthy and any subsequent failures count toward the maximum number of retries.
        """
        return pulumi.get(self, "start_period")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[builtins.int]:
        """
        The time period in seconds to wait for a health check to succeed before it is considered a failure. You may specify between 2 and 60 seconds. The default value is 5. This value applies only when you specify a ``command``.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class TaskDefinitionHostEntry(dict):
    """
    The ``HostEntry`` property specifies a hostname and an IP address that are added to the ``/etc/hosts`` file of a container through the ``extraHosts`` parameter of its ``ContainerDefinition`` resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionHostEntry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionHostEntry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionHostEntry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hostname: Optional[builtins.str] = None,
                 ip_address: Optional[builtins.str] = None):
        """
        The ``HostEntry`` property specifies a hostname and an IP address that are added to the ``/etc/hosts`` file of a container through the ``extraHosts`` parameter of its ``ContainerDefinition`` resource.
        :param builtins.str hostname: The hostname to use in the ``/etc/hosts`` entry.
        :param builtins.str ip_address: The IP address to use in the ``/etc/hosts`` entry.
        """
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[builtins.str]:
        """
        The hostname to use in the ``/etc/hosts`` entry.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[builtins.str]:
        """
        The IP address to use in the ``/etc/hosts`` entry.
        """
        return pulumi.get(self, "ip_address")


@pulumi.output_type
class TaskDefinitionHostVolumeProperties(dict):
    """
    The ``HostVolumeProperties`` property specifies details on a container instance bind mount host volume.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourcePath":
            suggest = "source_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionHostVolumeProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionHostVolumeProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionHostVolumeProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_path: Optional[builtins.str] = None):
        """
        The ``HostVolumeProperties`` property specifies details on a container instance bind mount host volume.
        :param builtins.str source_path: When the ``host`` parameter is used, specify a ``sourcePath`` to declare the path on the host container instance that's presented to the container. If this parameter is empty, then the Docker daemon has assigned a host path for you. If the ``host`` parameter contains a ``sourcePath`` file location, then the data volume persists at the specified location on the host container instance until you delete it manually. If the ``sourcePath`` value doesn't exist on the host container instance, the Docker daemon creates it. If the location does exist, the contents of the source path folder are exported.
                If you're using the Fargate launch type, the ``sourcePath`` parameter is not supported.
        """
        if source_path is not None:
            pulumi.set(__self__, "source_path", source_path)

    @property
    @pulumi.getter(name="sourcePath")
    def source_path(self) -> Optional[builtins.str]:
        """
        When the ``host`` parameter is used, specify a ``sourcePath`` to declare the path on the host container instance that's presented to the container. If this parameter is empty, then the Docker daemon has assigned a host path for you. If the ``host`` parameter contains a ``sourcePath`` file location, then the data volume persists at the specified location on the host container instance until you delete it manually. If the ``sourcePath`` value doesn't exist on the host container instance, the Docker daemon creates it. If the location does exist, the contents of the source path folder are exported.
         If you're using the Fargate launch type, the ``sourcePath`` parameter is not supported.
        """
        return pulumi.get(self, "source_path")


@pulumi.output_type
class TaskDefinitionInferenceAccelerator(dict):
    """
    Details on an Elastic Inference accelerator. For more information, see [Working with Amazon Elastic Inference on Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-inference.html) in the *Amazon Elastic Container Service Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceName":
            suggest = "device_name"
        elif key == "deviceType":
            suggest = "device_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionInferenceAccelerator. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionInferenceAccelerator.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionInferenceAccelerator.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_name: Optional[builtins.str] = None,
                 device_type: Optional[builtins.str] = None):
        """
        Details on an Elastic Inference accelerator. For more information, see [Working with Amazon Elastic Inference on Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-inference.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param builtins.str device_name: The Elastic Inference accelerator device name. The ``deviceName`` must also be referenced in a container definition as a [ResourceRequirement](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ResourceRequirement.html).
        :param builtins.str device_type: The Elastic Inference accelerator type to use.
        """
        if device_name is not None:
            pulumi.set(__self__, "device_name", device_name)
        if device_type is not None:
            pulumi.set(__self__, "device_type", device_type)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> Optional[builtins.str]:
        """
        The Elastic Inference accelerator device name. The ``deviceName`` must also be referenced in a container definition as a [ResourceRequirement](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ResourceRequirement.html).
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter(name="deviceType")
    def device_type(self) -> Optional[builtins.str]:
        """
        The Elastic Inference accelerator type to use.
        """
        return pulumi.get(self, "device_type")


@pulumi.output_type
class TaskDefinitionKernelCapabilities(dict):
    """
    The Linux capabilities to add or remove from the default Docker configuration for a container defined in the task definition. For more detailed information about these Linux capabilities, see the [capabilities(7)](https://docs.aws.amazon.com/http://man7.org/linux/man-pages/man7/capabilities.7.html) Linux manual page.
     The following describes how Docker processes the Linux capabilities specified in the ``add`` and ``drop`` request parameters. For information about the latest behavior, see [Docker Compose: order of cap_drop and cap_add](https://docs.aws.amazon.com/https://forums.docker.com/t/docker-compose-order-of-cap-drop-and-cap-add/97136/1) in the Docker Community Forum.
      +  When the container is a privleged container, the container capabilities are all of the default Docker capabilities. The capabilities specified in the ``add`` request parameter, and the ``drop`` request parameter are ignored.
      +  When the ``add`` request parameter is set to ALL, the container capabilities are all of the default Docker capabilities, excluding those specified in the ``drop`` request parameter.
      +  When the ``drop`` request parameter is set to ALL, the container capabilities are the capabilities specified in the ``add`` request parameter.
      +  When the ``add`` request parameter and the ``drop`` request parameter are both empty, the capabilities the container capabilities are all of the default Docker capabilities.
      +  The default is to first drop the capabilities specified in the ``drop`` request parameter, and then add the capabilities specified in the ``add`` request parameter.
    """
    def __init__(__self__, *,
                 add: Optional[Sequence[builtins.str]] = None,
                 drop: Optional[Sequence[builtins.str]] = None):
        """
        The Linux capabilities to add or remove from the default Docker configuration for a container defined in the task definition. For more detailed information about these Linux capabilities, see the [capabilities(7)](https://docs.aws.amazon.com/http://man7.org/linux/man-pages/man7/capabilities.7.html) Linux manual page.
         The following describes how Docker processes the Linux capabilities specified in the ``add`` and ``drop`` request parameters. For information about the latest behavior, see [Docker Compose: order of cap_drop and cap_add](https://docs.aws.amazon.com/https://forums.docker.com/t/docker-compose-order-of-cap-drop-and-cap-add/97136/1) in the Docker Community Forum.
          +  When the container is a privleged container, the container capabilities are all of the default Docker capabilities. The capabilities specified in the ``add`` request parameter, and the ``drop`` request parameter are ignored.
          +  When the ``add`` request parameter is set to ALL, the container capabilities are all of the default Docker capabilities, excluding those specified in the ``drop`` request parameter.
          +  When the ``drop`` request parameter is set to ALL, the container capabilities are the capabilities specified in the ``add`` request parameter.
          +  When the ``add`` request parameter and the ``drop`` request parameter are both empty, the capabilities the container capabilities are all of the default Docker capabilities.
          +  The default is to first drop the capabilities specified in the ``drop`` request parameter, and then add the capabilities specified in the ``add`` request parameter.
        :param Sequence[builtins.str] add: The Linux capabilities for the container that have been added to the default configuration provided by Docker. This parameter maps to ``CapAdd`` in the docker container create command and the ``--cap-add`` option to docker run.
                 Tasks launched on FARGATElong only support adding the ``SYS_PTRACE`` kernel capability.
                 Valid values: ``"ALL" | "AUDIT_CONTROL" | "AUDIT_WRITE" | "BLOCK_SUSPEND" | "CHOWN" | "DAC_OVERRIDE" | "DAC_READ_SEARCH" | "FOWNER" | "FSETID" | "IPC_LOCK" | "IPC_OWNER" | "KILL" | "LEASE" | "LINUX_IMMUTABLE" | "MAC_ADMIN" | "MAC_OVERRIDE" | "MKNOD" | "NET_ADMIN" | "NET_BIND_SERVICE" | "NET_BROADCAST" | "NET_RAW" | "SETFCAP" | "SETGID" | "SETPCAP" | "SETUID" | "SYS_ADMIN" | "SYS_BOOT" | "SYS_CHROOT" | "SYS_MODULE" | "SYS_NICE" | "SYS_PACCT" | "SYS_PTRACE" | "SYS_RAWIO" | "SYS_RESOURCE" | "SYS_TIME" | "SYS_TTY_CONFIG" | "SYSLOG" | "WAKE_ALARM"``
        :param Sequence[builtins.str] drop: The Linux capabilities for the container that have been removed from the default configuration provided by Docker. This parameter maps to ``CapDrop`` in the docker container create command and the ``--cap-drop`` option to docker run.
                Valid values: ``"ALL" | "AUDIT_CONTROL" | "AUDIT_WRITE" | "BLOCK_SUSPEND" | "CHOWN" | "DAC_OVERRIDE" | "DAC_READ_SEARCH" | "FOWNER" | "FSETID" | "IPC_LOCK" | "IPC_OWNER" | "KILL" | "LEASE" | "LINUX_IMMUTABLE" | "MAC_ADMIN" | "MAC_OVERRIDE" | "MKNOD" | "NET_ADMIN" | "NET_BIND_SERVICE" | "NET_BROADCAST" | "NET_RAW" | "SETFCAP" | "SETGID" | "SETPCAP" | "SETUID" | "SYS_ADMIN" | "SYS_BOOT" | "SYS_CHROOT" | "SYS_MODULE" | "SYS_NICE" | "SYS_PACCT" | "SYS_PTRACE" | "SYS_RAWIO" | "SYS_RESOURCE" | "SYS_TIME" | "SYS_TTY_CONFIG" | "SYSLOG" | "WAKE_ALARM"``
        """
        if add is not None:
            pulumi.set(__self__, "add", add)
        if drop is not None:
            pulumi.set(__self__, "drop", drop)

    @property
    @pulumi.getter
    def add(self) -> Optional[Sequence[builtins.str]]:
        """
        The Linux capabilities for the container that have been added to the default configuration provided by Docker. This parameter maps to ``CapAdd`` in the docker container create command and the ``--cap-add`` option to docker run.
          Tasks launched on FARGATElong only support adding the ``SYS_PTRACE`` kernel capability.
          Valid values: ``"ALL" | "AUDIT_CONTROL" | "AUDIT_WRITE" | "BLOCK_SUSPEND" | "CHOWN" | "DAC_OVERRIDE" | "DAC_READ_SEARCH" | "FOWNER" | "FSETID" | "IPC_LOCK" | "IPC_OWNER" | "KILL" | "LEASE" | "LINUX_IMMUTABLE" | "MAC_ADMIN" | "MAC_OVERRIDE" | "MKNOD" | "NET_ADMIN" | "NET_BIND_SERVICE" | "NET_BROADCAST" | "NET_RAW" | "SETFCAP" | "SETGID" | "SETPCAP" | "SETUID" | "SYS_ADMIN" | "SYS_BOOT" | "SYS_CHROOT" | "SYS_MODULE" | "SYS_NICE" | "SYS_PACCT" | "SYS_PTRACE" | "SYS_RAWIO" | "SYS_RESOURCE" | "SYS_TIME" | "SYS_TTY_CONFIG" | "SYSLOG" | "WAKE_ALARM"``
        """
        return pulumi.get(self, "add")

    @property
    @pulumi.getter
    def drop(self) -> Optional[Sequence[builtins.str]]:
        """
        The Linux capabilities for the container that have been removed from the default configuration provided by Docker. This parameter maps to ``CapDrop`` in the docker container create command and the ``--cap-drop`` option to docker run.
         Valid values: ``"ALL" | "AUDIT_CONTROL" | "AUDIT_WRITE" | "BLOCK_SUSPEND" | "CHOWN" | "DAC_OVERRIDE" | "DAC_READ_SEARCH" | "FOWNER" | "FSETID" | "IPC_LOCK" | "IPC_OWNER" | "KILL" | "LEASE" | "LINUX_IMMUTABLE" | "MAC_ADMIN" | "MAC_OVERRIDE" | "MKNOD" | "NET_ADMIN" | "NET_BIND_SERVICE" | "NET_BROADCAST" | "NET_RAW" | "SETFCAP" | "SETGID" | "SETPCAP" | "SETUID" | "SYS_ADMIN" | "SYS_BOOT" | "SYS_CHROOT" | "SYS_MODULE" | "SYS_NICE" | "SYS_PACCT" | "SYS_PTRACE" | "SYS_RAWIO" | "SYS_RESOURCE" | "SYS_TIME" | "SYS_TTY_CONFIG" | "SYSLOG" | "WAKE_ALARM"``
        """
        return pulumi.get(self, "drop")


@pulumi.output_type
class TaskDefinitionKeyValuePair(dict):
    """
    A key-value pair object.
    """
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        A key-value pair object.
        :param builtins.str name: The name of the key-value pair. For environment variables, this is the name of the environment variable.
        :param builtins.str value: The value of the key-value pair. For environment variables, this is the value of the environment variable.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the key-value pair. For environment variables, this is the name of the environment variable.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The value of the key-value pair. For environment variables, this is the value of the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class TaskDefinitionLinuxParameters(dict):
    """
    The Linux-specific options that are applied to the container, such as Linux [KernelCapabilities](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_KernelCapabilities.html).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "initProcessEnabled":
            suggest = "init_process_enabled"
        elif key == "maxSwap":
            suggest = "max_swap"
        elif key == "sharedMemorySize":
            suggest = "shared_memory_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionLinuxParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionLinuxParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionLinuxParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capabilities: Optional['outputs.TaskDefinitionKernelCapabilities'] = None,
                 devices: Optional[Sequence['outputs.TaskDefinitionDevice']] = None,
                 init_process_enabled: Optional[builtins.bool] = None,
                 max_swap: Optional[builtins.int] = None,
                 shared_memory_size: Optional[builtins.int] = None,
                 swappiness: Optional[builtins.int] = None,
                 tmpfs: Optional[Sequence['outputs.TaskDefinitionTmpfs']] = None):
        """
        The Linux-specific options that are applied to the container, such as Linux [KernelCapabilities](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_KernelCapabilities.html).
        :param 'TaskDefinitionKernelCapabilities' capabilities: The Linux capabilities for the container that are added to or dropped from the default configuration provided by Docker.
                 For tasks that use the Fargate launch type, ``capabilities`` is supported for all platform versions but the ``add`` parameter is only supported if using platform version 1.4.0 or later.
        :param Sequence['TaskDefinitionDevice'] devices: Any host devices to expose to the container. This parameter maps to ``Devices`` in the docker container create command and the ``--device`` option to docker run.
                 If you're using tasks that use the Fargate launch type, the ``devices`` parameter isn't supported.
        :param builtins.bool init_process_enabled: Run an ``init`` process inside the container that forwards signals and reaps processes. This parameter maps to the ``--init`` option to docker run. This parameter requires version 1.25 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: ``sudo docker version --format '{{.Server.APIVersion}}'``
        :param builtins.int max_swap: The total amount of swap memory (in MiB) a container can use. This parameter will be translated to the ``--memory-swap`` option to docker run where the value would be the sum of the container memory plus the ``maxSwap`` value.
                If a ``maxSwap`` value of ``0`` is specified, the container will not use swap. Accepted values are ``0`` or any positive integer. If the ``maxSwap`` parameter is omitted, the container will use the swap configuration for the container instance it is running on. A ``maxSwap`` value must be set for the ``swappiness`` parameter to be used.
                 If you're using tasks that use the Fargate launch type, the ``maxSwap`` parameter isn't supported.
                If you're using tasks on Amazon Linux 2023 the ``swappiness`` parameter isn't supported.
        :param builtins.int shared_memory_size: The value for the size (in MiB) of the ``/dev/shm`` volume. This parameter maps to the ``--shm-size`` option to docker run.
                 If you are using tasks that use the Fargate launch type, the ``sharedMemorySize`` parameter is not supported.
        :param builtins.int swappiness: This allows you to tune a container's memory swappiness behavior. A ``swappiness`` value of ``0`` will cause swapping to not happen unless absolutely necessary. A ``swappiness`` value of ``100`` will cause pages to be swapped very aggressively. Accepted values are whole numbers between ``0`` and ``100``. If the ``swappiness`` parameter is not specified, a default value of ``60`` is used. If a value is not specified for ``maxSwap`` then this parameter is ignored. This parameter maps to the ``--memory-swappiness`` option to docker run.
                 If you're using tasks that use the Fargate launch type, the ``swappiness`` parameter isn't supported.
                If you're using tasks on Amazon Linux 2023 the ``swappiness`` parameter isn't supported.
        :param Sequence['TaskDefinitionTmpfs'] tmpfs: The container path, mount options, and size (in MiB) of the tmpfs mount. This parameter maps to the ``--tmpfs`` option to docker run.
                 If you're using tasks that use the Fargate launch type, the ``tmpfs`` parameter isn't supported.
        """
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if init_process_enabled is not None:
            pulumi.set(__self__, "init_process_enabled", init_process_enabled)
        if max_swap is not None:
            pulumi.set(__self__, "max_swap", max_swap)
        if shared_memory_size is not None:
            pulumi.set(__self__, "shared_memory_size", shared_memory_size)
        if swappiness is not None:
            pulumi.set(__self__, "swappiness", swappiness)
        if tmpfs is not None:
            pulumi.set(__self__, "tmpfs", tmpfs)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional['outputs.TaskDefinitionKernelCapabilities']:
        """
        The Linux capabilities for the container that are added to or dropped from the default configuration provided by Docker.
          For tasks that use the Fargate launch type, ``capabilities`` is supported for all platform versions but the ``add`` parameter is only supported if using platform version 1.4.0 or later.
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter
    def devices(self) -> Optional[Sequence['outputs.TaskDefinitionDevice']]:
        """
        Any host devices to expose to the container. This parameter maps to ``Devices`` in the docker container create command and the ``--device`` option to docker run.
          If you're using tasks that use the Fargate launch type, the ``devices`` parameter isn't supported.
        """
        return pulumi.get(self, "devices")

    @property
    @pulumi.getter(name="initProcessEnabled")
    def init_process_enabled(self) -> Optional[builtins.bool]:
        """
        Run an ``init`` process inside the container that forwards signals and reaps processes. This parameter maps to the ``--init`` option to docker run. This parameter requires version 1.25 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: ``sudo docker version --format '{{.Server.APIVersion}}'``
        """
        return pulumi.get(self, "init_process_enabled")

    @property
    @pulumi.getter(name="maxSwap")
    def max_swap(self) -> Optional[builtins.int]:
        """
        The total amount of swap memory (in MiB) a container can use. This parameter will be translated to the ``--memory-swap`` option to docker run where the value would be the sum of the container memory plus the ``maxSwap`` value.
         If a ``maxSwap`` value of ``0`` is specified, the container will not use swap. Accepted values are ``0`` or any positive integer. If the ``maxSwap`` parameter is omitted, the container will use the swap configuration for the container instance it is running on. A ``maxSwap`` value must be set for the ``swappiness`` parameter to be used.
          If you're using tasks that use the Fargate launch type, the ``maxSwap`` parameter isn't supported.
         If you're using tasks on Amazon Linux 2023 the ``swappiness`` parameter isn't supported.
        """
        return pulumi.get(self, "max_swap")

    @property
    @pulumi.getter(name="sharedMemorySize")
    def shared_memory_size(self) -> Optional[builtins.int]:
        """
        The value for the size (in MiB) of the ``/dev/shm`` volume. This parameter maps to the ``--shm-size`` option to docker run.
          If you are using tasks that use the Fargate launch type, the ``sharedMemorySize`` parameter is not supported.
        """
        return pulumi.get(self, "shared_memory_size")

    @property
    @pulumi.getter
    def swappiness(self) -> Optional[builtins.int]:
        """
        This allows you to tune a container's memory swappiness behavior. A ``swappiness`` value of ``0`` will cause swapping to not happen unless absolutely necessary. A ``swappiness`` value of ``100`` will cause pages to be swapped very aggressively. Accepted values are whole numbers between ``0`` and ``100``. If the ``swappiness`` parameter is not specified, a default value of ``60`` is used. If a value is not specified for ``maxSwap`` then this parameter is ignored. This parameter maps to the ``--memory-swappiness`` option to docker run.
          If you're using tasks that use the Fargate launch type, the ``swappiness`` parameter isn't supported.
         If you're using tasks on Amazon Linux 2023 the ``swappiness`` parameter isn't supported.
        """
        return pulumi.get(self, "swappiness")

    @property
    @pulumi.getter
    def tmpfs(self) -> Optional[Sequence['outputs.TaskDefinitionTmpfs']]:
        """
        The container path, mount options, and size (in MiB) of the tmpfs mount. This parameter maps to the ``--tmpfs`` option to docker run.
          If you're using tasks that use the Fargate launch type, the ``tmpfs`` parameter isn't supported.
        """
        return pulumi.get(self, "tmpfs")


@pulumi.output_type
class TaskDefinitionLogConfiguration(dict):
    """
    The ``LogConfiguration`` property specifies log configuration options to send to a custom log driver for the container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logDriver":
            suggest = "log_driver"
        elif key == "secretOptions":
            suggest = "secret_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionLogConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionLogConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionLogConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_driver: builtins.str,
                 options: Optional[Mapping[str, builtins.str]] = None,
                 secret_options: Optional[Sequence['outputs.TaskDefinitionSecret']] = None):
        """
        The ``LogConfiguration`` property specifies log configuration options to send to a custom log driver for the container.
        :param builtins.str log_driver: The log driver to use for the container.
                For tasks on FARGATElong, the supported log drivers are ``awslogs``, ``splunk``, and ``awsfirelens``.
                For tasks hosted on Amazon EC2 instances, the supported log drivers are ``awslogs``, ``fluentd``, ``gelf``, ``json-file``, ``journald``, ``syslog``, ``splunk``, and ``awsfirelens``.
                For more information about using the ``awslogs`` log driver, see [Send Amazon ECS logs to CloudWatch](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_awslogs.html) in the *Amazon Elastic Container Service Developer Guide*.
                For more information about using the ``awsfirelens`` log driver, see [Send Amazon ECS logs to an service or Partner](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html).
                 If you have a custom driver that isn't listed, you can fork the Amazon ECS container agent project that's [available on GitHub](https://docs.aws.amazon.com/https://github.com/aws/amazon-ecs-agent) and customize it to work with that driver. We encourage you to submit pull requests for changes that you would like to have included. However, we don't currently provide support for running modified copies of this software.
        :param Mapping[str, builtins.str] options: The configuration options to send to the log driver.
                The options you can specify depend on the log driver. Some of the options you can specify when you use the ``awslogs`` log driver to route logs to Amazon CloudWatch include the following:
                 + awslogs-create-group Required: No Specify whether you want the log group to be created automatically. If this option isn't specified, it defaults to false. Your IAM policy must include the logs:CreateLogGroup permission before you attempt to use awslogs-create-group. + awslogs-region Required: Yes Specify the Region that the awslogs log driver is to send your Docker logs to. You can choose to send all of your logs from clusters in different Regions to a single region in CloudWatch Logs. This is so that they're all visible in one location. Otherwise, you can separate them by Region for more granularity. Make sure that the specified log group exists in the Region that you specify with this option. + awslogs-group Required: Yes Make sure to specify a log group that the awslogs log driver sends its log streams to. + awslogs-stream-prefix Required: Yes, when using Fargate.Optional when using EC2. Use the awslogs-stream-prefix option to associate a log stream with the specified prefix, the container name, and the ID of the Amazon ECS task that the container belongs to. If you specify a prefix with this option, then the log stream takes the format prefix-name/container-name/ecs-task-id. If you don't specify a prefix with this option, then the log stream is named after the container ID that's assigned by the Docker daemon on the container instance. Because it's difficult to trace logs back to the container that sent them with just the Docker container ID (which is only available on the container instance), we recommend that you specify a prefix with this option. For Amazon ECS services, you can use the service name as the prefix. Doing so, you can trace log streams to the service that the container belongs to, the name of the container that sent them, and the ID of the task that the container belongs to. You must specify a stream-prefix for your logs to have your logs appear in the Log pane when using the Amazon ECS console. + awslogs-datetime-format Required: No This option defines a multiline start pattern in Python strftime format. A log message consists of a line that matches the pattern and any following lines that don’t match the pattern. The matched line is the delimiter between log messages. One example of a use case for using this format is for parsing output such as a stack dump, which might otherwise be logged in multiple entries. The correct pattern allows it to be captured in a single entry. For more information, see awslogs-datetime-format. You cannot configure both the awslogs-datetime-format and awslogs-multiline-pattern options. Multiline logging performs regular expression parsing and matching of all log messages. This might have a negative impact on logging performance. + awslogs-multiline-pattern Required: No This option defines a multiline start pattern that uses a regular expression. A log message consists of a line that matches the pattern and any following lines that don’t match the pattern. The matched line is the delimiter between log messages. For more information, see awslogs-multiline-pattern. This option is ignored if awslogs-datetime-format is also configured. You cannot configure both the awslogs-datetime-format and awslogs-multiline-pattern options. Multiline logging performs regular expression parsing and matching of all log messages. This might have a negative impact on logging performance. 
                The following options apply to all supported log drivers.
                 + mode Required: No Valid values: non-blocking | blocking This option defines the delivery mode of log messages from the container to the log driver specified using logDriver. The delivery mode you choose affects application availability when the flow of logs from container is interrupted. If you use the blocking mode and the flow of logs is interrupted, calls from container code to write to the stdout and stderr streams will block. The logging thread of the application will block as a result. This may cause the application to become unresponsive and lead to container healthcheck failure. If you use the non-blocking mode, the container's logs are instead stored in an in-memory intermediate buffer configured with the max-buffer-size option. This prevents the application from becoming unresponsive when logs cannot be sent. We recommend using this mode if you want to ensure service availability and are okay with some log loss. For more information, see Preventing log loss with non-blocking mode in the awslogs container log driver. You can set a default mode for all containers in a specific Region by using the defaultLogDriverMode account setting. If you don't specify the mode option or configure the account setting, Amazon ECS will default to the blocking mode. For more information about the account setting, see Default log driver mode in the Amazon Elastic Container Service Developer Guide. On June 25, 2025, Amazon ECS is changing the default log driver mode from blocking to non-blocking to prioritize task availability over logging. To continue using the blocking mode after this change, do one of the following: Set the mode option in your container definition's logConfiguration as blocking. Set the defaultLogDriverMode account setting to blocking. + max-buffer-size Required: No Default value: 1m When non-blocking mode is used, the max-buffer-size log option controls the size of the buffer that's used for intermediate message storage. Make sure to specify an adequate buffer size based on your application. When the buffer fills up, further logs cannot be stored. Logs that cannot be stored are lost. 
                To route logs using the ``splunk`` log router, you need to specify a ``splunk-token`` and a ``splunk-url``.
                When you use the ``awsfirelens`` log router to route logs to an AWS Service or AWS Partner Network destination for log storage and analytics, you can set the ``log-driver-buffer-limit`` option to limit the number of events that are buffered in memory, before being sent to the log router container. It can help to resolve potential log loss issue because high throughput might result in memory running out for the buffer inside of Docker.
                Other options you can specify when using ``awsfirelens`` to route logs depend on the destination. When you export logs to Amazon Data Firehose, you can specify the AWS Region with ``region`` and a name for the log stream with ``delivery_stream``.
                When you export logs to Amazon Kinesis Data Streams, you can specify an AWS Region with ``region`` and a data stream name with ``stream``.
                 When you export logs to Amazon OpenSearch Service, you can specify options like ``Name``, ``Host`` (OpenSearch Service endpoint without protocol), ``Port``, ``Index``, ``Type``, ``Aws_auth``, ``Aws_region``, ``Suppress_Type_Name``, and ``tls``. For more information, see [Under the hood: FireLens for Amazon ECS Tasks](https://docs.aws.amazon.com/containers/under-the-hood-firelens-for-amazon-ecs-tasks/).
                When you export logs to Amazon S3, you can specify the bucket using the ``bucket`` option. You can also specify ``region``, ``total_file_size``, ``upload_timeout``, and ``use_put_object`` as options.
                This parameter requires version 1.19 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: ``sudo docker version --format '{{.Server.APIVersion}}'``
        :param Sequence['TaskDefinitionSecret'] secret_options: The secrets to pass to the log configuration. For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html) in the *Amazon Elastic Container Service Developer Guide*.
        """
        pulumi.set(__self__, "log_driver", log_driver)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if secret_options is not None:
            pulumi.set(__self__, "secret_options", secret_options)

    @property
    @pulumi.getter(name="logDriver")
    def log_driver(self) -> builtins.str:
        """
        The log driver to use for the container.
         For tasks on FARGATElong, the supported log drivers are ``awslogs``, ``splunk``, and ``awsfirelens``.
         For tasks hosted on Amazon EC2 instances, the supported log drivers are ``awslogs``, ``fluentd``, ``gelf``, ``json-file``, ``journald``, ``syslog``, ``splunk``, and ``awsfirelens``.
         For more information about using the ``awslogs`` log driver, see [Send Amazon ECS logs to CloudWatch](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_awslogs.html) in the *Amazon Elastic Container Service Developer Guide*.
         For more information about using the ``awsfirelens`` log driver, see [Send Amazon ECS logs to an service or Partner](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html).
          If you have a custom driver that isn't listed, you can fork the Amazon ECS container agent project that's [available on GitHub](https://docs.aws.amazon.com/https://github.com/aws/amazon-ecs-agent) and customize it to work with that driver. We encourage you to submit pull requests for changes that you would like to have included. However, we don't currently provide support for running modified copies of this software.
        """
        return pulumi.get(self, "log_driver")

    @property
    @pulumi.getter
    def options(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The configuration options to send to the log driver.
         The options you can specify depend on the log driver. Some of the options you can specify when you use the ``awslogs`` log driver to route logs to Amazon CloudWatch include the following:
          + awslogs-create-group Required: No Specify whether you want the log group to be created automatically. If this option isn't specified, it defaults to false. Your IAM policy must include the logs:CreateLogGroup permission before you attempt to use awslogs-create-group. + awslogs-region Required: Yes Specify the Region that the awslogs log driver is to send your Docker logs to. You can choose to send all of your logs from clusters in different Regions to a single region in CloudWatch Logs. This is so that they're all visible in one location. Otherwise, you can separate them by Region for more granularity. Make sure that the specified log group exists in the Region that you specify with this option. + awslogs-group Required: Yes Make sure to specify a log group that the awslogs log driver sends its log streams to. + awslogs-stream-prefix Required: Yes, when using Fargate.Optional when using EC2. Use the awslogs-stream-prefix option to associate a log stream with the specified prefix, the container name, and the ID of the Amazon ECS task that the container belongs to. If you specify a prefix with this option, then the log stream takes the format prefix-name/container-name/ecs-task-id. If you don't specify a prefix with this option, then the log stream is named after the container ID that's assigned by the Docker daemon on the container instance. Because it's difficult to trace logs back to the container that sent them with just the Docker container ID (which is only available on the container instance), we recommend that you specify a prefix with this option. For Amazon ECS services, you can use the service name as the prefix. Doing so, you can trace log streams to the service that the container belongs to, the name of the container that sent them, and the ID of the task that the container belongs to. You must specify a stream-prefix for your logs to have your logs appear in the Log pane when using the Amazon ECS console. + awslogs-datetime-format Required: No This option defines a multiline start pattern in Python strftime format. A log message consists of a line that matches the pattern and any following lines that don’t match the pattern. The matched line is the delimiter between log messages. One example of a use case for using this format is for parsing output such as a stack dump, which might otherwise be logged in multiple entries. The correct pattern allows it to be captured in a single entry. For more information, see awslogs-datetime-format. You cannot configure both the awslogs-datetime-format and awslogs-multiline-pattern options. Multiline logging performs regular expression parsing and matching of all log messages. This might have a negative impact on logging performance. + awslogs-multiline-pattern Required: No This option defines a multiline start pattern that uses a regular expression. A log message consists of a line that matches the pattern and any following lines that don’t match the pattern. The matched line is the delimiter between log messages. For more information, see awslogs-multiline-pattern. This option is ignored if awslogs-datetime-format is also configured. You cannot configure both the awslogs-datetime-format and awslogs-multiline-pattern options. Multiline logging performs regular expression parsing and matching of all log messages. This might have a negative impact on logging performance. 
         The following options apply to all supported log drivers.
          + mode Required: No Valid values: non-blocking | blocking This option defines the delivery mode of log messages from the container to the log driver specified using logDriver. The delivery mode you choose affects application availability when the flow of logs from container is interrupted. If you use the blocking mode and the flow of logs is interrupted, calls from container code to write to the stdout and stderr streams will block. The logging thread of the application will block as a result. This may cause the application to become unresponsive and lead to container healthcheck failure. If you use the non-blocking mode, the container's logs are instead stored in an in-memory intermediate buffer configured with the max-buffer-size option. This prevents the application from becoming unresponsive when logs cannot be sent. We recommend using this mode if you want to ensure service availability and are okay with some log loss. For more information, see Preventing log loss with non-blocking mode in the awslogs container log driver. You can set a default mode for all containers in a specific Region by using the defaultLogDriverMode account setting. If you don't specify the mode option or configure the account setting, Amazon ECS will default to the blocking mode. For more information about the account setting, see Default log driver mode in the Amazon Elastic Container Service Developer Guide. On June 25, 2025, Amazon ECS is changing the default log driver mode from blocking to non-blocking to prioritize task availability over logging. To continue using the blocking mode after this change, do one of the following: Set the mode option in your container definition's logConfiguration as blocking. Set the defaultLogDriverMode account setting to blocking. + max-buffer-size Required: No Default value: 1m When non-blocking mode is used, the max-buffer-size log option controls the size of the buffer that's used for intermediate message storage. Make sure to specify an adequate buffer size based on your application. When the buffer fills up, further logs cannot be stored. Logs that cannot be stored are lost. 
         To route logs using the ``splunk`` log router, you need to specify a ``splunk-token`` and a ``splunk-url``.
         When you use the ``awsfirelens`` log router to route logs to an AWS Service or AWS Partner Network destination for log storage and analytics, you can set the ``log-driver-buffer-limit`` option to limit the number of events that are buffered in memory, before being sent to the log router container. It can help to resolve potential log loss issue because high throughput might result in memory running out for the buffer inside of Docker.
         Other options you can specify when using ``awsfirelens`` to route logs depend on the destination. When you export logs to Amazon Data Firehose, you can specify the AWS Region with ``region`` and a name for the log stream with ``delivery_stream``.
         When you export logs to Amazon Kinesis Data Streams, you can specify an AWS Region with ``region`` and a data stream name with ``stream``.
          When you export logs to Amazon OpenSearch Service, you can specify options like ``Name``, ``Host`` (OpenSearch Service endpoint without protocol), ``Port``, ``Index``, ``Type``, ``Aws_auth``, ``Aws_region``, ``Suppress_Type_Name``, and ``tls``. For more information, see [Under the hood: FireLens for Amazon ECS Tasks](https://docs.aws.amazon.com/containers/under-the-hood-firelens-for-amazon-ecs-tasks/).
         When you export logs to Amazon S3, you can specify the bucket using the ``bucket`` option. You can also specify ``region``, ``total_file_size``, ``upload_timeout``, and ``use_put_object`` as options.
         This parameter requires version 1.19 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: ``sudo docker version --format '{{.Server.APIVersion}}'``
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="secretOptions")
    def secret_options(self) -> Optional[Sequence['outputs.TaskDefinitionSecret']]:
        """
        The secrets to pass to the log configuration. For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html) in the *Amazon Elastic Container Service Developer Guide*.
        """
        return pulumi.get(self, "secret_options")


@pulumi.output_type
class TaskDefinitionMountPoint(dict):
    """
    The details for a volume mount point that's used in a container definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerPath":
            suggest = "container_path"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "sourceVolume":
            suggest = "source_volume"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionMountPoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionMountPoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionMountPoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_path: Optional[builtins.str] = None,
                 read_only: Optional[builtins.bool] = None,
                 source_volume: Optional[builtins.str] = None):
        """
        The details for a volume mount point that's used in a container definition.
        :param builtins.str container_path: The path on the container to mount the host volume at.
        :param builtins.bool read_only: If this value is ``true``, the container has read-only access to the volume. If this value is ``false``, then the container can write to the volume. The default value is ``false``.
        :param builtins.str source_volume: The name of the volume to mount. Must be a volume name referenced in the ``name`` parameter of task definition ``volume``.
        """
        if container_path is not None:
            pulumi.set(__self__, "container_path", container_path)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if source_volume is not None:
            pulumi.set(__self__, "source_volume", source_volume)

    @property
    @pulumi.getter(name="containerPath")
    def container_path(self) -> Optional[builtins.str]:
        """
        The path on the container to mount the host volume at.
        """
        return pulumi.get(self, "container_path")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[builtins.bool]:
        """
        If this value is ``true``, the container has read-only access to the volume. If this value is ``false``, then the container can write to the volume. The default value is ``false``.
        """
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter(name="sourceVolume")
    def source_volume(self) -> Optional[builtins.str]:
        """
        The name of the volume to mount. Must be a volume name referenced in the ``name`` parameter of task definition ``volume``.
        """
        return pulumi.get(self, "source_volume")


@pulumi.output_type
class TaskDefinitionPlacementConstraint(dict):
    """
    The constraint on task placement in the task definition. For more information, see [Task placement constraints](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html) in the *Amazon Elastic Container Service Developer Guide*.
      Task placement constraints aren't supported for tasks run on FARGATElong.
    """
    def __init__(__self__, *,
                 type: builtins.str,
                 expression: Optional[builtins.str] = None):
        """
        The constraint on task placement in the task definition. For more information, see [Task placement constraints](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html) in the *Amazon Elastic Container Service Developer Guide*.
          Task placement constraints aren't supported for tasks run on FARGATElong.
        :param builtins.str type: The type of constraint. The ``MemberOf`` constraint restricts selection to be from a group of valid candidates.
        :param builtins.str expression: A cluster query language expression to apply to the constraint. For more information, see [Cluster query language](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html) in the *Amazon Elastic Container Service Developer Guide*.
        """
        pulumi.set(__self__, "type", type)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of constraint. The ``MemberOf`` constraint restricts selection to be from a group of valid candidates.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def expression(self) -> Optional[builtins.str]:
        """
        A cluster query language expression to apply to the constraint. For more information, see [Cluster query language](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html) in the *Amazon Elastic Container Service Developer Guide*.
        """
        return pulumi.get(self, "expression")


@pulumi.output_type
class TaskDefinitionPortMapping(dict):
    """
    The ``PortMapping`` property specifies a port mapping. Port mappings allow containers to access ports on the host container instance to send or receive traffic. Port mappings are specified as part of the container definition.
     If you are using containers in a task with the ``awsvpc`` or ``host`` network mode, exposed ports should be specified using ``containerPort``. The ``hostPort`` can be left blank or it must be the same value as the ``containerPort``.
     After a task reaches the ``RUNNING`` status, manual and automatic host and container port assignments are visible in the ``networkBindings`` section of [DescribeTasks](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeTasks.html) API responses.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appProtocol":
            suggest = "app_protocol"
        elif key == "containerPort":
            suggest = "container_port"
        elif key == "containerPortRange":
            suggest = "container_port_range"
        elif key == "hostPort":
            suggest = "host_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionPortMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionPortMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionPortMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_protocol: Optional['TaskDefinitionPortMappingAppProtocol'] = None,
                 container_port: Optional[builtins.int] = None,
                 container_port_range: Optional[builtins.str] = None,
                 host_port: Optional[builtins.int] = None,
                 name: Optional[builtins.str] = None,
                 protocol: Optional[builtins.str] = None):
        """
        The ``PortMapping`` property specifies a port mapping. Port mappings allow containers to access ports on the host container instance to send or receive traffic. Port mappings are specified as part of the container definition.
         If you are using containers in a task with the ``awsvpc`` or ``host`` network mode, exposed ports should be specified using ``containerPort``. The ``hostPort`` can be left blank or it must be the same value as the ``containerPort``.
         After a task reaches the ``RUNNING`` status, manual and automatic host and container port assignments are visible in the ``networkBindings`` section of [DescribeTasks](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeTasks.html) API responses.
        :param 'TaskDefinitionPortMappingAppProtocol' app_protocol: The application protocol that's used for the port mapping. This parameter only applies to Service Connect. We recommend that you set this parameter to be consistent with the protocol that your application uses. If you set this parameter, Amazon ECS adds protocol-specific connection handling to the Service Connect proxy. If you set this parameter, Amazon ECS adds protocol-specific telemetry in the Amazon ECS console and CloudWatch.
                If you don't set a value for this parameter, then TCP is used. However, Amazon ECS doesn't add protocol-specific telemetry for TCP.
                ``appProtocol`` is immutable in a Service Connect service. Updating this field requires a service deletion and redeployment.
                Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param builtins.int container_port: The port number on the container that's bound to the user-specified or automatically assigned host port.
                If you use containers in a task with the ``awsvpc`` or ``host`` network mode, specify the exposed ports using ``containerPort``.
                If you use containers in a task with the ``bridge`` network mode and you specify a container port and not a host port, your container automatically receives a host port in the ephemeral port range. For more information, see ``hostPort``. Port mappings that are automatically assigned in this way do not count toward the 100 reserved ports limit of a container instance.
        :param builtins.str container_port_range: The port number range on the container that's bound to the dynamically mapped host port range. 
                The following rules apply when you specify a ``containerPortRange``:
                 +  You must use either the ``bridge`` network mode or the ``awsvpc`` network mode.
                 +  This parameter is available for both the EC2 and FARGATElong launch types.
                 +  This parameter is available for both the Linux and Windows operating systems.
                 +  The container instance must have at least version 1.67.0 of the container agent and at least version 1.67.0-1 of the ``ecs-init`` package 
                 +  You can specify a maximum of 100 port ranges per container.
                 +  You do not specify a ``hostPortRange``. The value of the ``hostPortRange`` is set as follows:
                 +  For containers in a task with the ``awsvpc`` network mode, the ``hostPortRange`` is set to the same value as the ``containerPortRange``. This is a static mapping strategy.
                 +  For containers in a task with the ``bridge`` network mode, the Amazon ECS agent finds open host ports from the default ephemeral range and passes it to docker to bind them to the container ports.
                 
                 +  The ``containerPortRange`` valid values are between 1 and 65535.
                 +  A port can only be included in one port mapping per container.
                 +  You cannot specify overlapping port ranges.
                 +  The first port in the range must be less than last port in the range.
                 +  Docker recommends that you turn off the docker-proxy in the Docker daemon config file when you have a large number of ports.
                For more information, see [Issue #11185](https://docs.aws.amazon.com/https://github.com/moby/moby/issues/11185) on the Github website.
                For information about how to turn off the docker-proxy in the Docker daemon config file, see [Docker daemon](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/bootstrap_container_instance.html#bootstrap_docker_daemon) in the *Amazon ECS Developer Guide*.
                 
                You can call [DescribeTasks](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeTasks.html) to view the ``hostPortRange`` which are the host ports that are bound to the container ports.
        :param builtins.int host_port: The port number on the container instance to reserve for your container.
                If you specify a ``containerPortRange``, leave this field empty and the value of the ``hostPort`` is set as follows:
                 +  For containers in a task with the ``awsvpc`` network mode, the ``hostPort`` is set to the same value as the ``containerPort``. This is a static mapping strategy.
                 +  For containers in a task with the ``bridge`` network mode, the Amazon ECS agent finds open ports on the host and automatically binds them to the container ports. This is a dynamic mapping strategy.
                 
                If you use containers in a task with the ``awsvpc`` or ``host`` network mode, the ``hostPort`` can either be left blank or set to the same value as the ``containerPort``.
                If you use containers in a task with the ``bridge`` network mode, you can specify a non-reserved host port for your container port mapping, or you can omit the ``hostPort`` (or set it to ``0``) while specifying a ``containerPort`` and your container automatically receives a port in the ephemeral port range for your container instance operating system and Docker version.
                The default ephemeral port range for Docker version 1.6.0 and later is listed on the instance under ``/proc/sys/net/ipv4/ip_local_port_range``. If this kernel parameter is unavailable, the default ephemeral port range from 49153 through 65535 (Linux) or 49152 through 65535 (Windows) is used. Do not attempt to specify a host port in the ephemeral port range as these are reserved for automatic assignment. In general, ports below 32768 are outside of the ephemeral port range.
                The default reserved ports are 22 for SSH, the Docker ports 2375 and 2376, and the Amazon ECS container agent ports 51678-51680. Any host port that was previously specified in a running task is also reserved while the task is running. That is, after a task stops, the host port is released. The current reserved ports are displayed in the ``remainingResources`` of [DescribeContainerInstances](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeContainerInstances.html) output. A container instance can have up to 100 reserved ports at a time. This number includes the default reserved ports. Automatically assigned ports aren't included in the 100 reserved ports quota.
        :param builtins.str name: The name that's used for the port mapping. This parameter is the name that you use in the ``serviceConnectConfiguration`` and the ``vpcLatticeConfigurations`` of a service. The name can include up to 64 characters. The characters can include lowercase letters, numbers, underscores (_), and hyphens (-). The name can't start with a hyphen.
        :param builtins.str protocol: The protocol used for the port mapping. Valid values are ``tcp`` and ``udp``. The default is ``tcp``. ``protocol`` is immutable in a Service Connect service. Updating this field requires a service deletion and redeployment.
        """
        if app_protocol is not None:
            pulumi.set(__self__, "app_protocol", app_protocol)
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if container_port_range is not None:
            pulumi.set(__self__, "container_port_range", container_port_range)
        if host_port is not None:
            pulumi.set(__self__, "host_port", host_port)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="appProtocol")
    def app_protocol(self) -> Optional['TaskDefinitionPortMappingAppProtocol']:
        """
        The application protocol that's used for the port mapping. This parameter only applies to Service Connect. We recommend that you set this parameter to be consistent with the protocol that your application uses. If you set this parameter, Amazon ECS adds protocol-specific connection handling to the Service Connect proxy. If you set this parameter, Amazon ECS adds protocol-specific telemetry in the Amazon ECS console and CloudWatch.
         If you don't set a value for this parameter, then TCP is used. However, Amazon ECS doesn't add protocol-specific telemetry for TCP.
         ``appProtocol`` is immutable in a Service Connect service. Updating this field requires a service deletion and redeployment.
         Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
        """
        return pulumi.get(self, "app_protocol")

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[builtins.int]:
        """
        The port number on the container that's bound to the user-specified or automatically assigned host port.
         If you use containers in a task with the ``awsvpc`` or ``host`` network mode, specify the exposed ports using ``containerPort``.
         If you use containers in a task with the ``bridge`` network mode and you specify a container port and not a host port, your container automatically receives a host port in the ephemeral port range. For more information, see ``hostPort``. Port mappings that are automatically assigned in this way do not count toward the 100 reserved ports limit of a container instance.
        """
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter(name="containerPortRange")
    def container_port_range(self) -> Optional[builtins.str]:
        """
        The port number range on the container that's bound to the dynamically mapped host port range. 
         The following rules apply when you specify a ``containerPortRange``:
          +  You must use either the ``bridge`` network mode or the ``awsvpc`` network mode.
          +  This parameter is available for both the EC2 and FARGATElong launch types.
          +  This parameter is available for both the Linux and Windows operating systems.
          +  The container instance must have at least version 1.67.0 of the container agent and at least version 1.67.0-1 of the ``ecs-init`` package 
          +  You can specify a maximum of 100 port ranges per container.
          +  You do not specify a ``hostPortRange``. The value of the ``hostPortRange`` is set as follows:
          +  For containers in a task with the ``awsvpc`` network mode, the ``hostPortRange`` is set to the same value as the ``containerPortRange``. This is a static mapping strategy.
          +  For containers in a task with the ``bridge`` network mode, the Amazon ECS agent finds open host ports from the default ephemeral range and passes it to docker to bind them to the container ports.
          
          +  The ``containerPortRange`` valid values are between 1 and 65535.
          +  A port can only be included in one port mapping per container.
          +  You cannot specify overlapping port ranges.
          +  The first port in the range must be less than last port in the range.
          +  Docker recommends that you turn off the docker-proxy in the Docker daemon config file when you have a large number of ports.
         For more information, see [Issue #11185](https://docs.aws.amazon.com/https://github.com/moby/moby/issues/11185) on the Github website.
         For information about how to turn off the docker-proxy in the Docker daemon config file, see [Docker daemon](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/bootstrap_container_instance.html#bootstrap_docker_daemon) in the *Amazon ECS Developer Guide*.
          
         You can call [DescribeTasks](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeTasks.html) to view the ``hostPortRange`` which are the host ports that are bound to the container ports.
        """
        return pulumi.get(self, "container_port_range")

    @property
    @pulumi.getter(name="hostPort")
    def host_port(self) -> Optional[builtins.int]:
        """
        The port number on the container instance to reserve for your container.
         If you specify a ``containerPortRange``, leave this field empty and the value of the ``hostPort`` is set as follows:
          +  For containers in a task with the ``awsvpc`` network mode, the ``hostPort`` is set to the same value as the ``containerPort``. This is a static mapping strategy.
          +  For containers in a task with the ``bridge`` network mode, the Amazon ECS agent finds open ports on the host and automatically binds them to the container ports. This is a dynamic mapping strategy.
          
         If you use containers in a task with the ``awsvpc`` or ``host`` network mode, the ``hostPort`` can either be left blank or set to the same value as the ``containerPort``.
         If you use containers in a task with the ``bridge`` network mode, you can specify a non-reserved host port for your container port mapping, or you can omit the ``hostPort`` (or set it to ``0``) while specifying a ``containerPort`` and your container automatically receives a port in the ephemeral port range for your container instance operating system and Docker version.
         The default ephemeral port range for Docker version 1.6.0 and later is listed on the instance under ``/proc/sys/net/ipv4/ip_local_port_range``. If this kernel parameter is unavailable, the default ephemeral port range from 49153 through 65535 (Linux) or 49152 through 65535 (Windows) is used. Do not attempt to specify a host port in the ephemeral port range as these are reserved for automatic assignment. In general, ports below 32768 are outside of the ephemeral port range.
         The default reserved ports are 22 for SSH, the Docker ports 2375 and 2376, and the Amazon ECS container agent ports 51678-51680. Any host port that was previously specified in a running task is also reserved while the task is running. That is, after a task stops, the host port is released. The current reserved ports are displayed in the ``remainingResources`` of [DescribeContainerInstances](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeContainerInstances.html) output. A container instance can have up to 100 reserved ports at a time. This number includes the default reserved ports. Automatically assigned ports aren't included in the 100 reserved ports quota.
        """
        return pulumi.get(self, "host_port")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name that's used for the port mapping. This parameter is the name that you use in the ``serviceConnectConfiguration`` and the ``vpcLatticeConfigurations`` of a service. The name can include up to 64 characters. The characters can include lowercase letters, numbers, underscores (_), and hyphens (-). The name can't start with a hyphen.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[builtins.str]:
        """
        The protocol used for the port mapping. Valid values are ``tcp`` and ``udp``. The default is ``tcp``. ``protocol`` is immutable in a Service Connect service. Updating this field requires a service deletion and redeployment.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class TaskDefinitionProxyConfiguration(dict):
    """
    The configuration details for the App Mesh proxy.
     For tasks that use the EC2 launch type, the container instances require at least version 1.26.0 of the container agent and at least version 1.26.0-1 of the ``ecs-init`` package to use a proxy configuration. If your container instances are launched from the Amazon ECS optimized AMI version ``20190301`` or later, then they contain the required versions of the container agent and ``ecs-init``. For more information, see [Amazon ECS-optimized Linux AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html)
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"
        elif key == "proxyConfigurationProperties":
            suggest = "proxy_configuration_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionProxyConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionProxyConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionProxyConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_name: builtins.str,
                 proxy_configuration_properties: Optional[Sequence['outputs.TaskDefinitionKeyValuePair']] = None,
                 type: Optional[builtins.str] = None):
        """
        The configuration details for the App Mesh proxy.
         For tasks that use the EC2 launch type, the container instances require at least version 1.26.0 of the container agent and at least version 1.26.0-1 of the ``ecs-init`` package to use a proxy configuration. If your container instances are launched from the Amazon ECS optimized AMI version ``20190301`` or later, then they contain the required versions of the container agent and ``ecs-init``. For more information, see [Amazon ECS-optimized Linux AMI](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html)
        :param builtins.str container_name: The name of the container that will serve as the App Mesh proxy.
        :param Sequence['TaskDefinitionKeyValuePair'] proxy_configuration_properties: The set of network configuration parameters to provide the Container Network Interface (CNI) plugin, specified as key-value pairs.
                 +  ``IgnoredUID`` - (Required) The user ID (UID) of the proxy container as defined by the ``user`` parameter in a container definition. This is used to ensure the proxy ignores its own traffic. If ``IgnoredGID`` is specified, this field can be empty.
                 +  ``IgnoredGID`` - (Required) The group ID (GID) of the proxy container as defined by the ``user`` parameter in a container definition. This is used to ensure the proxy ignores its own traffic. If ``IgnoredUID`` is specified, this field can be empty.
                 +  ``AppPorts`` - (Required) The list of ports that the application uses. Network traffic to these ports is forwarded to the ``ProxyIngressPort`` and ``ProxyEgressPort``.
                 +  ``ProxyIngressPort`` - (Required) Specifies the port that incoming traffic to the ``AppPorts`` is directed to.
                 +  ``ProxyEgressPort`` - (Required) Specifies the port that outgoing traffic from the ``AppPorts`` is directed to.
                 +  ``EgressIgnoredPorts`` - (Required) The egress traffic going to the specified ports is ignored and not redirected to the ``ProxyEgressPort``. It can be an empty list.
                 +  ``EgressIgnoredIPs`` - (Required) The egress traffic going to the specified IP addresses is ignored and not redirected to the ``ProxyEgressPort``. It can be an empty list.
        :param builtins.str type: The proxy type. The only supported value is ``APPMESH``.
        """
        pulumi.set(__self__, "container_name", container_name)
        if proxy_configuration_properties is not None:
            pulumi.set(__self__, "proxy_configuration_properties", proxy_configuration_properties)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> builtins.str:
        """
        The name of the container that will serve as the App Mesh proxy.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="proxyConfigurationProperties")
    def proxy_configuration_properties(self) -> Optional[Sequence['outputs.TaskDefinitionKeyValuePair']]:
        """
        The set of network configuration parameters to provide the Container Network Interface (CNI) plugin, specified as key-value pairs.
          +  ``IgnoredUID`` - (Required) The user ID (UID) of the proxy container as defined by the ``user`` parameter in a container definition. This is used to ensure the proxy ignores its own traffic. If ``IgnoredGID`` is specified, this field can be empty.
          +  ``IgnoredGID`` - (Required) The group ID (GID) of the proxy container as defined by the ``user`` parameter in a container definition. This is used to ensure the proxy ignores its own traffic. If ``IgnoredUID`` is specified, this field can be empty.
          +  ``AppPorts`` - (Required) The list of ports that the application uses. Network traffic to these ports is forwarded to the ``ProxyIngressPort`` and ``ProxyEgressPort``.
          +  ``ProxyIngressPort`` - (Required) Specifies the port that incoming traffic to the ``AppPorts`` is directed to.
          +  ``ProxyEgressPort`` - (Required) Specifies the port that outgoing traffic from the ``AppPorts`` is directed to.
          +  ``EgressIgnoredPorts`` - (Required) The egress traffic going to the specified ports is ignored and not redirected to the ``ProxyEgressPort``. It can be an empty list.
          +  ``EgressIgnoredIPs`` - (Required) The egress traffic going to the specified IP addresses is ignored and not redirected to the ``ProxyEgressPort``. It can be an empty list.
        """
        return pulumi.get(self, "proxy_configuration_properties")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The proxy type. The only supported value is ``APPMESH``.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class TaskDefinitionRepositoryCredentials(dict):
    """
    The repository credentials for private registry authentication.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialsParameter":
            suggest = "credentials_parameter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionRepositoryCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionRepositoryCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionRepositoryCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credentials_parameter: Optional[builtins.str] = None):
        """
        The repository credentials for private registry authentication.
        :param builtins.str credentials_parameter: The Amazon Resource Name (ARN) of the secret containing the private repository credentials.
                 When you use the Amazon ECS API, CLI, or AWS SDK, if the secret exists in the same Region as the task that you're launching then you can use either the full ARN or the name of the secret. When you use the AWS Management Console, you must specify the full ARN of the secret.
        """
        if credentials_parameter is not None:
            pulumi.set(__self__, "credentials_parameter", credentials_parameter)

    @property
    @pulumi.getter(name="credentialsParameter")
    def credentials_parameter(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the secret containing the private repository credentials.
          When you use the Amazon ECS API, CLI, or AWS SDK, if the secret exists in the same Region as the task that you're launching then you can use either the full ARN or the name of the secret. When you use the AWS Management Console, you must specify the full ARN of the secret.
        """
        return pulumi.get(self, "credentials_parameter")


@pulumi.output_type
class TaskDefinitionResourceRequirement(dict):
    """
    The type and amount of a resource to assign to a container. The supported resource types are GPUs and Elastic Inference accelerators. For more information, see [Working with GPUs on Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-gpu.html) or [Working with Amazon Elastic Inference on Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-inference.html) in the *Amazon Elastic Container Service Developer Guide*
    """
    def __init__(__self__, *,
                 type: builtins.str,
                 value: builtins.str):
        """
        The type and amount of a resource to assign to a container. The supported resource types are GPUs and Elastic Inference accelerators. For more information, see [Working with GPUs on Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-gpu.html) or [Working with Amazon Elastic Inference on Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-inference.html) in the *Amazon Elastic Container Service Developer Guide*
        :param builtins.str type: The type of resource to assign to a container.
        :param builtins.str value: The value for the specified resource type.
                When the type is ``GPU``, the value is the number of physical ``GPUs`` the Amazon ECS container agent reserves for the container. The number of GPUs that's reserved for all containers in a task can't exceed the number of available GPUs on the container instance that the task is launched on.
                When the type is ``InferenceAccelerator``, the ``value`` matches the ``deviceName`` for an [InferenceAccelerator](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_InferenceAccelerator.html) specified in a task definition.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of resource to assign to a container.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value for the specified resource type.
         When the type is ``GPU``, the value is the number of physical ``GPUs`` the Amazon ECS container agent reserves for the container. The number of GPUs that's reserved for all containers in a task can't exceed the number of available GPUs on the container instance that the task is launched on.
         When the type is ``InferenceAccelerator``, the ``value`` matches the ``deviceName`` for an [InferenceAccelerator](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_InferenceAccelerator.html) specified in a task definition.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class TaskDefinitionRestartPolicy(dict):
    """
    You can enable a restart policy for each container defined in your task definition, to overcome transient failures faster and maintain task availability. When you enable a restart policy for a container, Amazon ECS can restart the container if it exits, without needing to replace the task. For more information, see [Restart individual containers in Amazon ECS tasks with container restart policies](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-restart-policy.html) in the *Amazon Elastic Container Service Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoredExitCodes":
            suggest = "ignored_exit_codes"
        elif key == "restartAttemptPeriod":
            suggest = "restart_attempt_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionRestartPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionRestartPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionRestartPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None,
                 ignored_exit_codes: Optional[Sequence[builtins.int]] = None,
                 restart_attempt_period: Optional[builtins.int] = None):
        """
        You can enable a restart policy for each container defined in your task definition, to overcome transient failures faster and maintain task availability. When you enable a restart policy for a container, Amazon ECS can restart the container if it exits, without needing to replace the task. For more information, see [Restart individual containers in Amazon ECS tasks with container restart policies](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-restart-policy.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param builtins.bool enabled: Specifies whether a restart policy is enabled for the container.
        :param Sequence[builtins.int] ignored_exit_codes: A list of exit codes that Amazon ECS will ignore and not attempt a restart on. You can specify a maximum of 50 container exit codes. By default, Amazon ECS does not ignore any exit codes.
        :param builtins.int restart_attempt_period: A period of time (in seconds) that the container must run for before a restart can be attempted. A container can be restarted only once every ``restartAttemptPeriod`` seconds. If a container isn't able to run for this time period and exits early, it will not be restarted. You can set a minimum ``restartAttemptPeriod`` of 60 seconds and a maximum ``restartAttemptPeriod`` of 1800 seconds. By default, a container must run for 300 seconds before it can be restarted.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ignored_exit_codes is not None:
            pulumi.set(__self__, "ignored_exit_codes", ignored_exit_codes)
        if restart_attempt_period is not None:
            pulumi.set(__self__, "restart_attempt_period", restart_attempt_period)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Specifies whether a restart policy is enabled for the container.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="ignoredExitCodes")
    def ignored_exit_codes(self) -> Optional[Sequence[builtins.int]]:
        """
        A list of exit codes that Amazon ECS will ignore and not attempt a restart on. You can specify a maximum of 50 container exit codes. By default, Amazon ECS does not ignore any exit codes.
        """
        return pulumi.get(self, "ignored_exit_codes")

    @property
    @pulumi.getter(name="restartAttemptPeriod")
    def restart_attempt_period(self) -> Optional[builtins.int]:
        """
        A period of time (in seconds) that the container must run for before a restart can be attempted. A container can be restarted only once every ``restartAttemptPeriod`` seconds. If a container isn't able to run for this time period and exits early, it will not be restarted. You can set a minimum ``restartAttemptPeriod`` of 60 seconds and a maximum ``restartAttemptPeriod`` of 1800 seconds. By default, a container must run for 300 seconds before it can be restarted.
        """
        return pulumi.get(self, "restart_attempt_period")


@pulumi.output_type
class TaskDefinitionRuntimePlatform(dict):
    """
    Information about the platform for the Amazon ECS service or task.
     For more information about ``RuntimePlatform``, see [RuntimePlatform](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#runtime-platform) in the *Amazon Elastic Container Service Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuArchitecture":
            suggest = "cpu_architecture"
        elif key == "operatingSystemFamily":
            suggest = "operating_system_family"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionRuntimePlatform. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionRuntimePlatform.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionRuntimePlatform.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_architecture: Optional[builtins.str] = None,
                 operating_system_family: Optional[builtins.str] = None):
        """
        Information about the platform for the Amazon ECS service or task.
         For more information about ``RuntimePlatform``, see [RuntimePlatform](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#runtime-platform) in the *Amazon Elastic Container Service Developer Guide*.
        :param builtins.str cpu_architecture: The CPU architecture.
                You can run your Linux tasks on an ARM-based platform by setting the value to ``ARM64``. This option is available for tasks that run on Linux Amazon EC2 instance or Linux containers on Fargate.
        :param builtins.str operating_system_family: The operating system.
        """
        if cpu_architecture is not None:
            pulumi.set(__self__, "cpu_architecture", cpu_architecture)
        if operating_system_family is not None:
            pulumi.set(__self__, "operating_system_family", operating_system_family)

    @property
    @pulumi.getter(name="cpuArchitecture")
    def cpu_architecture(self) -> Optional[builtins.str]:
        """
        The CPU architecture.
         You can run your Linux tasks on an ARM-based platform by setting the value to ``ARM64``. This option is available for tasks that run on Linux Amazon EC2 instance or Linux containers on Fargate.
        """
        return pulumi.get(self, "cpu_architecture")

    @property
    @pulumi.getter(name="operatingSystemFamily")
    def operating_system_family(self) -> Optional[builtins.str]:
        """
        The operating system.
        """
        return pulumi.get(self, "operating_system_family")


@pulumi.output_type
class TaskDefinitionSecret(dict):
    """
    An object representing the secret to expose to your container. Secrets can be exposed to a container in the following ways:
      +  To inject sensitive data into your containers as environment variables, use the ``secrets`` container definition parameter.
      +  To reference sensitive information in the log configuration of a container, use the ``secretOptions`` container definition parameter.
      
     For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html) in the *Amazon Elastic Container Service Developer Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueFrom":
            suggest = "value_from"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 value_from: builtins.str):
        """
        An object representing the secret to expose to your container. Secrets can be exposed to a container in the following ways:
          +  To inject sensitive data into your containers as environment variables, use the ``secrets`` container definition parameter.
          +  To reference sensitive information in the log configuration of a container, use the ``secretOptions`` container definition parameter.
          
         For more information, see [Specifying sensitive data](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html) in the *Amazon Elastic Container Service Developer Guide*.
        :param builtins.str name: The name of the secret.
        :param builtins.str value_from: The secret to expose to the container. The supported values are either the full ARN of the ASMlong secret or the full ARN of the parameter in the SSM Parameter Store.
                For information about the require IAMlong permissions, see [Required IAM permissions for Amazon ECS secrets](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-secrets.html#secrets-iam) (for Secrets Manager) or [Required IAM permissions for Amazon ECS secrets](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-parameters.html) (for Systems Manager Parameter store) in the *Amazon Elastic Container Service Developer Guide*.
                 If the SSM Parameter Store parameter exists in the same Region as the task you're launching, then you can use either the full ARN or name of the parameter. If the parameter exists in a different Region, then the full ARN must be specified.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value_from", value_from)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the secret.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="valueFrom")
    def value_from(self) -> builtins.str:
        """
        The secret to expose to the container. The supported values are either the full ARN of the ASMlong secret or the full ARN of the parameter in the SSM Parameter Store.
         For information about the require IAMlong permissions, see [Required IAM permissions for Amazon ECS secrets](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-secrets.html#secrets-iam) (for Secrets Manager) or [Required IAM permissions for Amazon ECS secrets](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-parameters.html) (for Systems Manager Parameter store) in the *Amazon Elastic Container Service Developer Guide*.
          If the SSM Parameter Store parameter exists in the same Region as the task you're launching, then you can use either the full ARN or name of the parameter. If the parameter exists in a different Region, then the full ARN must be specified.
        """
        return pulumi.get(self, "value_from")


@pulumi.output_type
class TaskDefinitionSystemControl(dict):
    """
    A list of namespaced kernel parameters to set in the container. This parameter maps to ``Sysctls`` in the docker container create command and the ``--sysctl`` option to docker run. For example, you can configure ``net.ipv4.tcp_keepalive_time`` setting to maintain longer lived connections.
     We don't recommend that you specify network-related ``systemControls`` parameters for multiple containers in a single task that also uses either the ``awsvpc`` or ``host`` network mode. Doing this has the following disadvantages:
      +  For tasks that use the ``awsvpc`` network mode including Fargate, if you set ``systemControls`` for any container, it applies to all containers in the task. If you set different ``systemControls`` for multiple containers in a single task, the container that's started last determines which ``systemControls`` take effect.
      +  For tasks that use the ``host`` network mode, the network namespace ``systemControls`` aren't supported.
      
     If you're setting an IPC resource namespace to use for the containers in the task, the following conditions apply to your system controls. For more information, see [IPC mode](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#task_definition_ipcmode).
      +  For tasks that use the ``host`` IPC mode, IPC namespace ``systemControls`` aren't supported.
      +  For tasks that use the ``task`` IPC mode, IPC namespace ``systemControls`` values apply to all containers within a task.
      
      This parameter is not supported for Windows containers.
       This parameter is only supported for tasks that are hosted on FARGATElong if the tasks are using platform version ``1.4.0`` or later (Linux). This isn't supported for Windows containers on Fargate.
    """
    def __init__(__self__, *,
                 namespace: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        A list of namespaced kernel parameters to set in the container. This parameter maps to ``Sysctls`` in the docker container create command and the ``--sysctl`` option to docker run. For example, you can configure ``net.ipv4.tcp_keepalive_time`` setting to maintain longer lived connections.
         We don't recommend that you specify network-related ``systemControls`` parameters for multiple containers in a single task that also uses either the ``awsvpc`` or ``host`` network mode. Doing this has the following disadvantages:
          +  For tasks that use the ``awsvpc`` network mode including Fargate, if you set ``systemControls`` for any container, it applies to all containers in the task. If you set different ``systemControls`` for multiple containers in a single task, the container that's started last determines which ``systemControls`` take effect.
          +  For tasks that use the ``host`` network mode, the network namespace ``systemControls`` aren't supported.
          
         If you're setting an IPC resource namespace to use for the containers in the task, the following conditions apply to your system controls. For more information, see [IPC mode](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#task_definition_ipcmode).
          +  For tasks that use the ``host`` IPC mode, IPC namespace ``systemControls`` aren't supported.
          +  For tasks that use the ``task`` IPC mode, IPC namespace ``systemControls`` values apply to all containers within a task.
          
          This parameter is not supported for Windows containers.
           This parameter is only supported for tasks that are hosted on FARGATElong if the tasks are using platform version ``1.4.0`` or later (Linux). This isn't supported for Windows containers on Fargate.
        :param builtins.str namespace: The namespaced kernel parameter to set a ``value`` for.
        :param builtins.str value: The namespaced kernel parameter to set a ``value`` for.
                Valid IPC namespace values: ``"kernel.msgmax" | "kernel.msgmnb" | "kernel.msgmni" | "kernel.sem" | "kernel.shmall" | "kernel.shmmax" | "kernel.shmmni" | "kernel.shm_rmid_forced"``, and ``Sysctls`` that start with ``"fs.mqueue.*"``
                Valid network namespace values: ``Sysctls`` that start with ``"net.*"``. Only namespaced ``Sysctls`` that exist within the container starting with "net.* are accepted.
                All of these values are supported by Fargate.
        """
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[builtins.str]:
        """
        The namespaced kernel parameter to set a ``value`` for.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The namespaced kernel parameter to set a ``value`` for.
         Valid IPC namespace values: ``"kernel.msgmax" | "kernel.msgmnb" | "kernel.msgmni" | "kernel.sem" | "kernel.shmall" | "kernel.shmmax" | "kernel.shmmni" | "kernel.shm_rmid_forced"``, and ``Sysctls`` that start with ``"fs.mqueue.*"``
         Valid network namespace values: ``Sysctls`` that start with ``"net.*"``. Only namespaced ``Sysctls`` that exist within the container starting with "net.* are accepted.
         All of these values are supported by Fargate.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class TaskDefinitionTmpfs(dict):
    """
    The container path, mount options, and size of the tmpfs mount.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerPath":
            suggest = "container_path"
        elif key == "mountOptions":
            suggest = "mount_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionTmpfs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionTmpfs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionTmpfs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size: builtins.int,
                 container_path: Optional[builtins.str] = None,
                 mount_options: Optional[Sequence[builtins.str]] = None):
        """
        The container path, mount options, and size of the tmpfs mount.
        :param builtins.int size: The maximum size (in MiB) of the tmpfs volume.
        :param builtins.str container_path: The absolute file path where the tmpfs volume is to be mounted.
        :param Sequence[builtins.str] mount_options: The list of tmpfs volume mount options.
                Valid values: ``"defaults" | "ro" | "rw" | "suid" | "nosuid" | "dev" | "nodev" | "exec" | "noexec" | "sync" | "async" | "dirsync" | "remount" | "mand" | "nomand" | "atime" | "noatime" | "diratime" | "nodiratime" | "bind" | "rbind" | "unbindable" | "runbindable" | "private" | "rprivate" | "shared" | "rshared" | "slave" | "rslave" | "relatime" | "norelatime" | "strictatime" | "nostrictatime" | "mode" | "uid" | "gid" | "nr_inodes" | "nr_blocks" | "mpol"``
        """
        pulumi.set(__self__, "size", size)
        if container_path is not None:
            pulumi.set(__self__, "container_path", container_path)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)

    @property
    @pulumi.getter
    def size(self) -> builtins.int:
        """
        The maximum size (in MiB) of the tmpfs volume.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="containerPath")
    def container_path(self) -> Optional[builtins.str]:
        """
        The absolute file path where the tmpfs volume is to be mounted.
        """
        return pulumi.get(self, "container_path")

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of tmpfs volume mount options.
         Valid values: ``"defaults" | "ro" | "rw" | "suid" | "nosuid" | "dev" | "nodev" | "exec" | "noexec" | "sync" | "async" | "dirsync" | "remount" | "mand" | "nomand" | "atime" | "noatime" | "diratime" | "nodiratime" | "bind" | "rbind" | "unbindable" | "runbindable" | "private" | "rprivate" | "shared" | "rshared" | "slave" | "rslave" | "relatime" | "norelatime" | "strictatime" | "nostrictatime" | "mode" | "uid" | "gid" | "nr_inodes" | "nr_blocks" | "mpol"``
        """
        return pulumi.get(self, "mount_options")


@pulumi.output_type
class TaskDefinitionUlimit(dict):
    """
    The ``ulimit`` settings to pass to the container.
     Amazon ECS tasks hosted on FARGATElong use the default resource limit values set by the operating system with the exception of the ``nofile`` resource limit parameter which FARGATElong overrides. The ``nofile`` resource limit sets a restriction on the number of open files that a container can use. The default ``nofile`` soft limit is ``65535`` and the default hard limit is ``65535``.
     You can specify the ``ulimit`` settings for a container in a task definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hardLimit":
            suggest = "hard_limit"
        elif key == "softLimit":
            suggest = "soft_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionUlimit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionUlimit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionUlimit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hard_limit: builtins.int,
                 name: builtins.str,
                 soft_limit: builtins.int):
        """
        The ``ulimit`` settings to pass to the container.
         Amazon ECS tasks hosted on FARGATElong use the default resource limit values set by the operating system with the exception of the ``nofile`` resource limit parameter which FARGATElong overrides. The ``nofile`` resource limit sets a restriction on the number of open files that a container can use. The default ``nofile`` soft limit is ``65535`` and the default hard limit is ``65535``.
         You can specify the ``ulimit`` settings for a container in a task definition.
        :param builtins.int hard_limit: The hard limit for the ``ulimit`` type. The value can be specified in bytes, seconds, or as a count, depending on the ``type`` of the ``ulimit``.
        :param builtins.str name: The ``type`` of the ``ulimit``.
        :param builtins.int soft_limit: The soft limit for the ``ulimit`` type. The value can be specified in bytes, seconds, or as a count, depending on the ``type`` of the ``ulimit``.
        """
        pulumi.set(__self__, "hard_limit", hard_limit)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "soft_limit", soft_limit)

    @property
    @pulumi.getter(name="hardLimit")
    def hard_limit(self) -> builtins.int:
        """
        The hard limit for the ``ulimit`` type. The value can be specified in bytes, seconds, or as a count, depending on the ``type`` of the ``ulimit``.
        """
        return pulumi.get(self, "hard_limit")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The ``type`` of the ``ulimit``.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="softLimit")
    def soft_limit(self) -> builtins.int:
        """
        The soft limit for the ``ulimit`` type. The value can be specified in bytes, seconds, or as a count, depending on the ``type`` of the ``ulimit``.
        """
        return pulumi.get(self, "soft_limit")


@pulumi.output_type
class TaskDefinitionVolume(dict):
    """
    The data volume configuration for tasks launched using this task definition. Specifying a volume configuration in a task definition is optional. The volume configuration may contain multiple volumes but only one volume configured at launch is supported. Each volume defined in the volume configuration may only specify a ``name`` and one of either ``configuredAtLaunch``, ``dockerVolumeConfiguration``, ``efsVolumeConfiguration``, ``fsxWindowsFileServerVolumeConfiguration``, or ``host``. If an empty volume configuration is specified, by default Amazon ECS uses a host volume. For more information, see [Using data volumes in tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configuredAtLaunch":
            suggest = "configured_at_launch"
        elif key == "dockerVolumeConfiguration":
            suggest = "docker_volume_configuration"
        elif key == "efsVolumeConfiguration":
            suggest = "efs_volume_configuration"
        elif key == "fSxWindowsFileServerVolumeConfiguration":
            suggest = "f_sx_windows_file_server_volume_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 configured_at_launch: Optional[builtins.bool] = None,
                 docker_volume_configuration: Optional['outputs.TaskDefinitionDockerVolumeConfiguration'] = None,
                 efs_volume_configuration: Optional['outputs.TaskDefinitionEfsVolumeConfiguration'] = None,
                 f_sx_windows_file_server_volume_configuration: Optional['outputs.TaskDefinitionFSxWindowsFileServerVolumeConfiguration'] = None,
                 host: Optional['outputs.TaskDefinitionHostVolumeProperties'] = None,
                 name: Optional[builtins.str] = None):
        """
        The data volume configuration for tasks launched using this task definition. Specifying a volume configuration in a task definition is optional. The volume configuration may contain multiple volumes but only one volume configured at launch is supported. Each volume defined in the volume configuration may only specify a ``name`` and one of either ``configuredAtLaunch``, ``dockerVolumeConfiguration``, ``efsVolumeConfiguration``, ``fsxWindowsFileServerVolumeConfiguration``, or ``host``. If an empty volume configuration is specified, by default Amazon ECS uses a host volume. For more information, see [Using data volumes in tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html).
        :param builtins.bool configured_at_launch: Indicates whether the volume should be configured at launch time. This is used to create Amazon EBS volumes for standalone tasks or tasks created as part of a service. Each task definition revision may only have one volume configured at launch in the volume configuration.
                To configure a volume at launch time, use this task definition revision and specify a ``volumeConfigurations`` object when calling the ``CreateService``, ``UpdateService``, ``RunTask`` or ``StartTask`` APIs.
        :param 'TaskDefinitionDockerVolumeConfiguration' docker_volume_configuration: This parameter is specified when you use Docker volumes.
                Windows containers only support the use of the ``local`` driver. To use bind mounts, specify the ``host`` parameter instead.
                 Docker volumes aren't supported by tasks run on FARGATElong.
        :param 'TaskDefinitionEfsVolumeConfiguration' efs_volume_configuration: This parameter is specified when you use an Amazon Elastic File System file system for task storage.
        :param 'TaskDefinitionFSxWindowsFileServerVolumeConfiguration' f_sx_windows_file_server_volume_configuration: This parameter is specified when you use Amazon FSx for Windows File Server file system for task storage.
        :param 'TaskDefinitionHostVolumeProperties' host: This parameter is specified when you use bind mount host volumes. The contents of the ``host`` parameter determine whether your bind mount host volume persists on the host container instance and where it's stored. If the ``host`` parameter is empty, then the Docker daemon assigns a host path for your data volume. However, the data isn't guaranteed to persist after the containers that are associated with it stop running.
                Windows containers can mount whole directories on the same drive as ``$env:ProgramData``. Windows containers can't mount directories on a different drive, and mount point can't be across drives. For example, you can mount ``C:\\my\\path:C:\\my\\path`` and ``D:\\:D:\\``, but not ``D:\\my\\path:C:\\my\\path`` or ``D:\\:C:\\my\\path``.
        :param builtins.str name: The name of the volume. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed.
                When using a volume configured at launch, the ``name`` is required and must also be specified as the volume name in the ``ServiceVolumeConfiguration`` or ``TaskVolumeConfiguration`` parameter when creating your service or standalone task.
                For all other types of volumes, this name is referenced in the ``sourceVolume`` parameter of the ``mountPoints`` object in the container definition.
                When a volume is using the ``efsVolumeConfiguration``, the name is required.
        """
        if configured_at_launch is not None:
            pulumi.set(__self__, "configured_at_launch", configured_at_launch)
        if docker_volume_configuration is not None:
            pulumi.set(__self__, "docker_volume_configuration", docker_volume_configuration)
        if efs_volume_configuration is not None:
            pulumi.set(__self__, "efs_volume_configuration", efs_volume_configuration)
        if f_sx_windows_file_server_volume_configuration is not None:
            pulumi.set(__self__, "f_sx_windows_file_server_volume_configuration", f_sx_windows_file_server_volume_configuration)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="configuredAtLaunch")
    def configured_at_launch(self) -> Optional[builtins.bool]:
        """
        Indicates whether the volume should be configured at launch time. This is used to create Amazon EBS volumes for standalone tasks or tasks created as part of a service. Each task definition revision may only have one volume configured at launch in the volume configuration.
         To configure a volume at launch time, use this task definition revision and specify a ``volumeConfigurations`` object when calling the ``CreateService``, ``UpdateService``, ``RunTask`` or ``StartTask`` APIs.
        """
        return pulumi.get(self, "configured_at_launch")

    @property
    @pulumi.getter(name="dockerVolumeConfiguration")
    def docker_volume_configuration(self) -> Optional['outputs.TaskDefinitionDockerVolumeConfiguration']:
        """
        This parameter is specified when you use Docker volumes.
         Windows containers only support the use of the ``local`` driver. To use bind mounts, specify the ``host`` parameter instead.
          Docker volumes aren't supported by tasks run on FARGATElong.
        """
        return pulumi.get(self, "docker_volume_configuration")

    @property
    @pulumi.getter(name="efsVolumeConfiguration")
    def efs_volume_configuration(self) -> Optional['outputs.TaskDefinitionEfsVolumeConfiguration']:
        """
        This parameter is specified when you use an Amazon Elastic File System file system for task storage.
        """
        return pulumi.get(self, "efs_volume_configuration")

    @property
    @pulumi.getter(name="fSxWindowsFileServerVolumeConfiguration")
    def f_sx_windows_file_server_volume_configuration(self) -> Optional['outputs.TaskDefinitionFSxWindowsFileServerVolumeConfiguration']:
        """
        This parameter is specified when you use Amazon FSx for Windows File Server file system for task storage.
        """
        return pulumi.get(self, "f_sx_windows_file_server_volume_configuration")

    @property
    @pulumi.getter
    def host(self) -> Optional['outputs.TaskDefinitionHostVolumeProperties']:
        """
        This parameter is specified when you use bind mount host volumes. The contents of the ``host`` parameter determine whether your bind mount host volume persists on the host container instance and where it's stored. If the ``host`` parameter is empty, then the Docker daemon assigns a host path for your data volume. However, the data isn't guaranteed to persist after the containers that are associated with it stop running.
         Windows containers can mount whole directories on the same drive as ``$env:ProgramData``. Windows containers can't mount directories on a different drive, and mount point can't be across drives. For example, you can mount ``C:\\my\\path:C:\\my\\path`` and ``D:\\:D:\\``, but not ``D:\\my\\path:C:\\my\\path`` or ``D:\\:C:\\my\\path``.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the volume. Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed.
         When using a volume configured at launch, the ``name`` is required and must also be specified as the volume name in the ``ServiceVolumeConfiguration`` or ``TaskVolumeConfiguration`` parameter when creating your service or standalone task.
         For all other types of volumes, this name is referenced in the ``sourceVolume`` parameter of the ``mountPoints`` object in the container definition.
         When a volume is using the ``efsVolumeConfiguration``, the name is required.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class TaskDefinitionVolumeFrom(dict):
    """
    Details on a data volume from another container in the same task definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readOnly":
            suggest = "read_only"
        elif key == "sourceContainer":
            suggest = "source_container"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskDefinitionVolumeFrom. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskDefinitionVolumeFrom.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskDefinitionVolumeFrom.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 read_only: Optional[builtins.bool] = None,
                 source_container: Optional[builtins.str] = None):
        """
        Details on a data volume from another container in the same task definition.
        :param builtins.bool read_only: If this value is ``true``, the container has read-only access to the volume. If this value is ``false``, then the container can write to the volume. The default value is ``false``.
        :param builtins.str source_container: The name of another container within the same task definition to mount volumes from.
        """
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if source_container is not None:
            pulumi.set(__self__, "source_container", source_container)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[builtins.bool]:
        """
        If this value is ``true``, the container has read-only access to the volume. If this value is ``false``, then the container can write to the volume. The default value is ``false``.
        """
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter(name="sourceContainer")
    def source_container(self) -> Optional[builtins.str]:
        """
        The name of another container within the same task definition to mount volumes from.
        """
        return pulumi.get(self, "source_container")


@pulumi.output_type
class TaskSetAwsVpcConfiguration(dict):
    """
    The VPC subnets and security groups associated with a task. All specified subnets and security groups must be from the same VPC.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignPublicIp":
            suggest = "assign_public_ip"
        elif key == "securityGroups":
            suggest = "security_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskSetAwsVpcConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskSetAwsVpcConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskSetAwsVpcConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnets: Sequence[builtins.str],
                 assign_public_ip: Optional['TaskSetAwsVpcConfigurationAssignPublicIp'] = None,
                 security_groups: Optional[Sequence[builtins.str]] = None):
        """
        The VPC subnets and security groups associated with a task. All specified subnets and security groups must be from the same VPC.
        :param Sequence[builtins.str] subnets: The subnets associated with the task or service. There is a limit of 16 subnets that can be specified per AwsVpcConfiguration.
        :param 'TaskSetAwsVpcConfigurationAssignPublicIp' assign_public_ip: Whether the task's elastic network interface receives a public IP address. The default value is DISABLED.
        :param Sequence[builtins.str] security_groups: The security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used. There is a limit of 5 security groups that can be specified per AwsVpcConfiguration.
        """
        pulumi.set(__self__, "subnets", subnets)
        if assign_public_ip is not None:
            pulumi.set(__self__, "assign_public_ip", assign_public_ip)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[builtins.str]:
        """
        The subnets associated with the task or service. There is a limit of 16 subnets that can be specified per AwsVpcConfiguration.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter(name="assignPublicIp")
    def assign_public_ip(self) -> Optional['TaskSetAwsVpcConfigurationAssignPublicIp']:
        """
        Whether the task's elastic network interface receives a public IP address. The default value is DISABLED.
        """
        return pulumi.get(self, "assign_public_ip")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[builtins.str]]:
        """
        The security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used. There is a limit of 5 security groups that can be specified per AwsVpcConfiguration.
        """
        return pulumi.get(self, "security_groups")


@pulumi.output_type
class TaskSetCapacityProviderStrategyItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityProvider":
            suggest = "capacity_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskSetCapacityProviderStrategyItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskSetCapacityProviderStrategyItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskSetCapacityProviderStrategyItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base: Optional[builtins.int] = None,
                 capacity_provider: Optional[builtins.str] = None,
                 weight: Optional[builtins.int] = None):
        """
        :param builtins.int base: The *base* value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a *base* defined. If no value is specified, the default value of `0` is used.
        :param builtins.str capacity_provider: The short name of the capacity provider.
        :param builtins.int weight: The *weight* value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The `weight` value is taken into consideration after the `base` value, if defined, is satisfied.
               
               If no `weight` value is specified, the default value of `0` is used. When multiple capacity providers are specified within a capacity provider strategy, at least one of the capacity providers must have a weight value greater than zero and any capacity providers with a weight of `0` can't be used to place tasks. If you specify multiple capacity providers in a strategy that all have a weight of `0` , any `RunTask` or `CreateService` actions using the capacity provider strategy will fail.
               
               An example scenario for using weights is defining a strategy that contains two capacity providers and both have a weight of `1` , then when the `base` is satisfied, the tasks will be split evenly across the two capacity providers. Using that same logic, if you specify a weight of `1` for *capacityProviderA* and a weight of `4` for *capacityProviderB* , then for every one task that's run using *capacityProviderA* , four tasks would use *capacityProviderB* .
        """
        if base is not None:
            pulumi.set(__self__, "base", base)
        if capacity_provider is not None:
            pulumi.set(__self__, "capacity_provider", capacity_provider)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def base(self) -> Optional[builtins.int]:
        """
        The *base* value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a *base* defined. If no value is specified, the default value of `0` is used.
        """
        return pulumi.get(self, "base")

    @property
    @pulumi.getter(name="capacityProvider")
    def capacity_provider(self) -> Optional[builtins.str]:
        """
        The short name of the capacity provider.
        """
        return pulumi.get(self, "capacity_provider")

    @property
    @pulumi.getter
    def weight(self) -> Optional[builtins.int]:
        """
        The *weight* value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The `weight` value is taken into consideration after the `base` value, if defined, is satisfied.

        If no `weight` value is specified, the default value of `0` is used. When multiple capacity providers are specified within a capacity provider strategy, at least one of the capacity providers must have a weight value greater than zero and any capacity providers with a weight of `0` can't be used to place tasks. If you specify multiple capacity providers in a strategy that all have a weight of `0` , any `RunTask` or `CreateService` actions using the capacity provider strategy will fail.

        An example scenario for using weights is defining a strategy that contains two capacity providers and both have a weight of `1` , then when the `base` is satisfied, the tasks will be split evenly across the two capacity providers. Using that same logic, if you specify a weight of `1` for *capacityProviderA* and a weight of `4` for *capacityProviderB* , then for every one task that's run using *capacityProviderA* , four tasks would use *capacityProviderB* .
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class TaskSetLoadBalancer(dict):
    """
    A load balancer object representing the load balancer to use with the task set. The supported load balancer types are either an Application Load Balancer or a Network Load Balancer. 
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"
        elif key == "containerPort":
            suggest = "container_port"
        elif key == "targetGroupArn":
            suggest = "target_group_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskSetLoadBalancer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskSetLoadBalancer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskSetLoadBalancer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_name: Optional[builtins.str] = None,
                 container_port: Optional[builtins.int] = None,
                 target_group_arn: Optional[builtins.str] = None):
        """
        A load balancer object representing the load balancer to use with the task set. The supported load balancer types are either an Application Load Balancer or a Network Load Balancer. 
        :param builtins.str container_name: The name of the container (as it appears in a container definition) to associate with the load balancer.
        :param builtins.int container_port: The port on the container to associate with the load balancer. This port must correspond to a containerPort in the task definition the tasks in the service are using. For tasks that use the EC2 launch type, the container instance they are launched on must allow ingress traffic on the hostPort of the port mapping.
        :param builtins.str target_group_arn: The full Amazon Resource Name (ARN) of the Elastic Load Balancing target group or groups associated with a service or task set. A target group ARN is only specified when using an Application Load Balancer or Network Load Balancer. If you are using a Classic Load Balancer this should be omitted. For services using the ECS deployment controller, you can specify one or multiple target groups. For more information, see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html in the Amazon Elastic Container Service Developer Guide. For services using the CODE_DEPLOY deployment controller, you are required to define two target groups for the load balancer. For more information, see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-bluegreen.html in the Amazon Elastic Container Service Developer Guide. If your service's task definition uses the awsvpc network mode (which is required for the Fargate launch type), you must choose ip as the target type, not instance, when creating your target groups because tasks that use the awsvpc network mode are associated with an elastic network interface, not an Amazon EC2 instance.
        """
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if target_group_arn is not None:
            pulumi.set(__self__, "target_group_arn", target_group_arn)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[builtins.str]:
        """
        The name of the container (as it appears in a container definition) to associate with the load balancer.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[builtins.int]:
        """
        The port on the container to associate with the load balancer. This port must correspond to a containerPort in the task definition the tasks in the service are using. For tasks that use the EC2 launch type, the container instance they are launched on must allow ingress traffic on the hostPort of the port mapping.
        """
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> Optional[builtins.str]:
        """
        The full Amazon Resource Name (ARN) of the Elastic Load Balancing target group or groups associated with a service or task set. A target group ARN is only specified when using an Application Load Balancer or Network Load Balancer. If you are using a Classic Load Balancer this should be omitted. For services using the ECS deployment controller, you can specify one or multiple target groups. For more information, see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html in the Amazon Elastic Container Service Developer Guide. For services using the CODE_DEPLOY deployment controller, you are required to define two target groups for the load balancer. For more information, see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-bluegreen.html in the Amazon Elastic Container Service Developer Guide. If your service's task definition uses the awsvpc network mode (which is required for the Fargate launch type), you must choose ip as the target type, not instance, when creating your target groups because tasks that use the awsvpc network mode are associated with an elastic network interface, not an Amazon EC2 instance.
        """
        return pulumi.get(self, "target_group_arn")


@pulumi.output_type
class TaskSetNetworkConfiguration(dict):
    """
    An object representing the network configuration for a task or service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsVpcConfiguration":
            suggest = "aws_vpc_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskSetNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskSetNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskSetNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_vpc_configuration: Optional['outputs.TaskSetAwsVpcConfiguration'] = None):
        """
        An object representing the network configuration for a task or service.
        :param 'TaskSetAwsVpcConfiguration' aws_vpc_configuration: The VPC subnets and security groups that are associated with a task.
               
               > All specified subnets and security groups must be from the same VPC.
        """
        if aws_vpc_configuration is not None:
            pulumi.set(__self__, "aws_vpc_configuration", aws_vpc_configuration)

    @property
    @pulumi.getter(name="awsVpcConfiguration")
    def aws_vpc_configuration(self) -> Optional['outputs.TaskSetAwsVpcConfiguration']:
        """
        The VPC subnets and security groups that are associated with a task.

        > All specified subnets and security groups must be from the same VPC.
        """
        return pulumi.get(self, "aws_vpc_configuration")


@pulumi.output_type
class TaskSetScale(dict):
    def __init__(__self__, *,
                 unit: Optional['TaskSetScaleUnit'] = None,
                 value: Optional[builtins.float] = None):
        """
        :param 'TaskSetScaleUnit' unit: The unit of measure for the scale value.
        :param builtins.float value: The value, specified as a percent total of a service's desiredCount, to scale the task set. Accepted values are numbers between 0 and 100.
        """
        if unit is not None:
            pulumi.set(__self__, "unit", unit)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional['TaskSetScaleUnit']:
        """
        The unit of measure for the scale value.
        """
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.float]:
        """
        The value, specified as a percent total of a service's desiredCount, to scale the task set. Accepted values are numbers between 0 and 100.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class TaskSetServiceRegistry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerName":
            suggest = "container_name"
        elif key == "containerPort":
            suggest = "container_port"
        elif key == "registryArn":
            suggest = "registry_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskSetServiceRegistry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskSetServiceRegistry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskSetServiceRegistry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_name: Optional[builtins.str] = None,
                 container_port: Optional[builtins.int] = None,
                 port: Optional[builtins.int] = None,
                 registry_arn: Optional[builtins.str] = None):
        """
        :param builtins.str container_name: The container name value, already specified in the task definition, to be used for your service discovery service. If the task definition that your service task specifies uses the bridge or host network mode, you must specify a containerName and containerPort combination from the task definition. If the task definition that your service task specifies uses the awsvpc network mode and a type SRV DNS record is used, you must specify either a containerName and containerPort combination or a port value, but not both.
        :param builtins.int container_port: The port value, already specified in the task definition, to be used for your service discovery service. If the task definition your service task specifies uses the bridge or host network mode, you must specify a containerName and containerPort combination from the task definition. If the task definition your service task specifies uses the awsvpc network mode and a type SRV DNS record is used, you must specify either a containerName and containerPort combination or a port value, but not both.
        :param builtins.int port: The port value used if your service discovery service specified an SRV record. This field may be used if both the awsvpc network mode and SRV records are used.
        :param builtins.str registry_arn: The Amazon Resource Name (ARN) of the service registry. The currently supported service registry is AWS Cloud Map. For more information, see https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html
        """
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if registry_arn is not None:
            pulumi.set(__self__, "registry_arn", registry_arn)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[builtins.str]:
        """
        The container name value, already specified in the task definition, to be used for your service discovery service. If the task definition that your service task specifies uses the bridge or host network mode, you must specify a containerName and containerPort combination from the task definition. If the task definition that your service task specifies uses the awsvpc network mode and a type SRV DNS record is used, you must specify either a containerName and containerPort combination or a port value, but not both.
        """
        return pulumi.get(self, "container_name")

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[builtins.int]:
        """
        The port value, already specified in the task definition, to be used for your service discovery service. If the task definition your service task specifies uses the bridge or host network mode, you must specify a containerName and containerPort combination from the task definition. If the task definition your service task specifies uses the awsvpc network mode and a type SRV DNS record is used, you must specify either a containerName and containerPort combination or a port value, but not both.
        """
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        The port value used if your service discovery service specified an SRV record. This field may be used if both the awsvpc network mode and SRV records are used.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="registryArn")
    def registry_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the service registry. The currently supported service registry is AWS Cloud Map. For more information, see https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html
        """
        return pulumi.get(self, "registry_arn")


