# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetTaskSetResult',
    'AwaitableGetTaskSetResult',
    'get_task_set',
    'get_task_set_output',
]

@pulumi.output_type
class GetTaskSetResult:
    def __init__(__self__, id=None, scale=None, tags=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if scale and not isinstance(scale, dict):
            raise TypeError("Expected argument 'scale' to be a dict")
        pulumi.set(__self__, "scale", scale)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the task set.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def scale(self) -> Optional['outputs.TaskSetScale']:
        """
        A floating-point percentage of the desired number of tasks to place and keep running in the task set.
        """
        return pulumi.get(self, "scale")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The metadata that you apply to the task set to help you categorize and organize them. Each tag consists of a key and an optional value. You define both.

        The following basic restrictions apply to tags:

        - Maximum number of tags per resource - 50
        - For each resource, each tag key must be unique, and each tag key can have only one value.
        - Maximum key length - 128 Unicode characters in UTF-8
        - Maximum value length - 256 Unicode characters in UTF-8
        - If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
        - Tag keys and values are case-sensitive.
        - Do not use `aws:` , `AWS:` , or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
        """
        return pulumi.get(self, "tags")


class AwaitableGetTaskSetResult(GetTaskSetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTaskSetResult(
            id=self.id,
            scale=self.scale,
            tags=self.tags)


def get_task_set(cluster: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 service: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTaskSetResult:
    """
    Create a task set in the specified cluster and service. This is used when a service uses the EXTERNAL deployment controller type. For more information, see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.htmlin the Amazon Elastic Container Service Developer Guide.


    :param builtins.str cluster: The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to create the task set in.
    :param builtins.str id: The ID of the task set.
    :param builtins.str service: The short name or full Amazon Resource Name (ARN) of the service to create the task set in.
    """
    __args__ = dict()
    __args__['cluster'] = cluster
    __args__['id'] = id
    __args__['service'] = service
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ecs:getTaskSet', __args__, opts=opts, typ=GetTaskSetResult).value

    return AwaitableGetTaskSetResult(
        id=pulumi.get(__ret__, 'id'),
        scale=pulumi.get(__ret__, 'scale'),
        tags=pulumi.get(__ret__, 'tags'))
def get_task_set_output(cluster: Optional[pulumi.Input[builtins.str]] = None,
                        id: Optional[pulumi.Input[builtins.str]] = None,
                        service: Optional[pulumi.Input[builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTaskSetResult]:
    """
    Create a task set in the specified cluster and service. This is used when a service uses the EXTERNAL deployment controller type. For more information, see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.htmlin the Amazon Elastic Container Service Developer Guide.


    :param builtins.str cluster: The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to create the task set in.
    :param builtins.str id: The ID of the task set.
    :param builtins.str service: The short name or full Amazon Resource Name (ARN) of the service to create the task set in.
    """
    __args__ = dict()
    __args__['cluster'] = cluster
    __args__['id'] = id
    __args__['service'] = service
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ecs:getTaskSet', __args__, opts=opts, typ=GetTaskSetResult)
    return __ret__.apply(lambda __response__: GetTaskSetResult(
        id=pulumi.get(__response__, 'id'),
        scale=pulumi.get(__response__, 'scale'),
        tags=pulumi.get(__response__, 'tags')))
