# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['ClusterCapacityProviderAssociationsArgs', 'ClusterCapacityProviderAssociations']

@pulumi.input_type
class ClusterCapacityProviderAssociationsArgs:
    def __init__(__self__, *,
                 capacity_providers: pulumi.Input[Sequence[pulumi.Input[Union['ClusterCapacityProviderAssociationsCapacityProvider', builtins.str]]]],
                 cluster: pulumi.Input[builtins.str],
                 default_capacity_provider_strategy: pulumi.Input[Sequence[pulumi.Input['ClusterCapacityProviderAssociationsCapacityProviderStrategyArgs']]]):
        """
        The set of arguments for constructing a ClusterCapacityProviderAssociations resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterCapacityProviderAssociationsCapacityProvider', builtins.str]]]] capacity_providers: The capacity providers to associate with the cluster.
        :param pulumi.Input[builtins.str] cluster: The cluster the capacity provider association is the target of.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterCapacityProviderAssociationsCapacityProviderStrategyArgs']]] default_capacity_provider_strategy: The default capacity provider strategy to associate with the cluster.
        """
        pulumi.set(__self__, "capacity_providers", capacity_providers)
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "default_capacity_provider_strategy", default_capacity_provider_strategy)

    @property
    @pulumi.getter(name="capacityProviders")
    def capacity_providers(self) -> pulumi.Input[Sequence[pulumi.Input[Union['ClusterCapacityProviderAssociationsCapacityProvider', builtins.str]]]]:
        """
        The capacity providers to associate with the cluster.
        """
        return pulumi.get(self, "capacity_providers")

    @capacity_providers.setter
    def capacity_providers(self, value: pulumi.Input[Sequence[pulumi.Input[Union['ClusterCapacityProviderAssociationsCapacityProvider', builtins.str]]]]):
        pulumi.set(self, "capacity_providers", value)

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Input[builtins.str]:
        """
        The cluster the capacity provider association is the target of.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter(name="defaultCapacityProviderStrategy")
    def default_capacity_provider_strategy(self) -> pulumi.Input[Sequence[pulumi.Input['ClusterCapacityProviderAssociationsCapacityProviderStrategyArgs']]]:
        """
        The default capacity provider strategy to associate with the cluster.
        """
        return pulumi.get(self, "default_capacity_provider_strategy")

    @default_capacity_provider_strategy.setter
    def default_capacity_provider_strategy(self, value: pulumi.Input[Sequence[pulumi.Input['ClusterCapacityProviderAssociationsCapacityProviderStrategyArgs']]]):
        pulumi.set(self, "default_capacity_provider_strategy", value)


@pulumi.type_token("aws-native:ecs:ClusterCapacityProviderAssociations")
class ClusterCapacityProviderAssociations(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity_providers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterCapacityProviderAssociationsCapacityProvider', builtins.str]]]]] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 default_capacity_provider_strategy: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterCapacityProviderAssociationsCapacityProviderStrategyArgs', 'ClusterCapacityProviderAssociationsCapacityProviderStrategyArgsDict']]]]] = None,
                 __props__=None):
        """
        Associate a set of ECS Capacity Providers with a specified ECS Cluster

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        cluster_name = config.require("clusterName")
        cluster_cpassociation = aws_native.ecs.ClusterCapacityProviderAssociations("clusterCPAssociation",
            cluster=cluster_name,
            capacity_providers=[
                aws_native.ecs.ClusterCapacityProviderAssociationsCapacityProvider.FARGATE,
                aws_native.ecs.ClusterCapacityProviderAssociationsCapacityProvider.FARGATE_SPOT,
            ],
            default_capacity_provider_strategy=[
                {
                    "base": 2,
                    "weight": 1,
                    "capacity_provider": aws_native.ecs.ClusterCapacityProviderAssociationsCapacityProvider.FARGATE,
                },
                {
                    "base": 0,
                    "weight": 1,
                    "capacity_provider": aws_native.ecs.ClusterCapacityProviderAssociationsCapacityProvider.FARGATE_SPOT,
                },
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        cluster_name = config.require("clusterName")
        cluster_cpassociation = aws_native.ecs.ClusterCapacityProviderAssociations("clusterCPAssociation",
            cluster=cluster_name,
            capacity_providers=[
                aws_native.ecs.ClusterCapacityProviderAssociationsCapacityProvider.FARGATE,
                aws_native.ecs.ClusterCapacityProviderAssociationsCapacityProvider.FARGATE_SPOT,
            ],
            default_capacity_provider_strategy=[
                {
                    "base": 2,
                    "weight": 1,
                    "capacity_provider": aws_native.ecs.ClusterCapacityProviderAssociationsCapacityProvider.FARGATE,
                },
                {
                    "base": 0,
                    "weight": 1,
                    "capacity_provider": aws_native.ecs.ClusterCapacityProviderAssociationsCapacityProvider.FARGATE_SPOT,
                },
            ])

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterCapacityProviderAssociationsCapacityProvider', builtins.str]]]] capacity_providers: The capacity providers to associate with the cluster.
        :param pulumi.Input[builtins.str] cluster: The cluster the capacity provider association is the target of.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterCapacityProviderAssociationsCapacityProviderStrategyArgs', 'ClusterCapacityProviderAssociationsCapacityProviderStrategyArgsDict']]]] default_capacity_provider_strategy: The default capacity provider strategy to associate with the cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterCapacityProviderAssociationsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Associate a set of ECS Capacity Providers with a specified ECS Cluster

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        cluster_name = config.require("clusterName")
        cluster_cpassociation = aws_native.ecs.ClusterCapacityProviderAssociations("clusterCPAssociation",
            cluster=cluster_name,
            capacity_providers=[
                aws_native.ecs.ClusterCapacityProviderAssociationsCapacityProvider.FARGATE,
                aws_native.ecs.ClusterCapacityProviderAssociationsCapacityProvider.FARGATE_SPOT,
            ],
            default_capacity_provider_strategy=[
                {
                    "base": 2,
                    "weight": 1,
                    "capacity_provider": aws_native.ecs.ClusterCapacityProviderAssociationsCapacityProvider.FARGATE,
                },
                {
                    "base": 0,
                    "weight": 1,
                    "capacity_provider": aws_native.ecs.ClusterCapacityProviderAssociationsCapacityProvider.FARGATE_SPOT,
                },
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        cluster_name = config.require("clusterName")
        cluster_cpassociation = aws_native.ecs.ClusterCapacityProviderAssociations("clusterCPAssociation",
            cluster=cluster_name,
            capacity_providers=[
                aws_native.ecs.ClusterCapacityProviderAssociationsCapacityProvider.FARGATE,
                aws_native.ecs.ClusterCapacityProviderAssociationsCapacityProvider.FARGATE_SPOT,
            ],
            default_capacity_provider_strategy=[
                {
                    "base": 2,
                    "weight": 1,
                    "capacity_provider": aws_native.ecs.ClusterCapacityProviderAssociationsCapacityProvider.FARGATE,
                },
                {
                    "base": 0,
                    "weight": 1,
                    "capacity_provider": aws_native.ecs.ClusterCapacityProviderAssociationsCapacityProvider.FARGATE_SPOT,
                },
            ])

        ```

        :param str resource_name: The name of the resource.
        :param ClusterCapacityProviderAssociationsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterCapacityProviderAssociationsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity_providers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterCapacityProviderAssociationsCapacityProvider', builtins.str]]]]] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 default_capacity_provider_strategy: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterCapacityProviderAssociationsCapacityProviderStrategyArgs', 'ClusterCapacityProviderAssociationsCapacityProviderStrategyArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterCapacityProviderAssociationsArgs.__new__(ClusterCapacityProviderAssociationsArgs)

            if capacity_providers is None and not opts.urn:
                raise TypeError("Missing required property 'capacity_providers'")
            __props__.__dict__["capacity_providers"] = capacity_providers
            if cluster is None and not opts.urn:
                raise TypeError("Missing required property 'cluster'")
            __props__.__dict__["cluster"] = cluster
            if default_capacity_provider_strategy is None and not opts.urn:
                raise TypeError("Missing required property 'default_capacity_provider_strategy'")
            __props__.__dict__["default_capacity_provider_strategy"] = default_capacity_provider_strategy
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["cluster"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ClusterCapacityProviderAssociations, __self__).__init__(
            'aws-native:ecs:ClusterCapacityProviderAssociations',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ClusterCapacityProviderAssociations':
        """
        Get an existing ClusterCapacityProviderAssociations resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ClusterCapacityProviderAssociationsArgs.__new__(ClusterCapacityProviderAssociationsArgs)

        __props__.__dict__["capacity_providers"] = None
        __props__.__dict__["cluster"] = None
        __props__.__dict__["default_capacity_provider_strategy"] = None
        return ClusterCapacityProviderAssociations(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="capacityProviders")
    def capacity_providers(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The capacity providers to associate with the cluster.
        """
        return pulumi.get(self, "capacity_providers")

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Output[builtins.str]:
        """
        The cluster the capacity provider association is the target of.
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter(name="defaultCapacityProviderStrategy")
    def default_capacity_provider_strategy(self) -> pulumi.Output[Sequence['outputs.ClusterCapacityProviderAssociationsCapacityProviderStrategy']]:
        """
        The default capacity provider strategy to associate with the cluster.
        """
        return pulumi.get(self, "default_capacity_provider_strategy")

