# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['CapacityProviderArgs', 'CapacityProvider']

@pulumi.input_type
class CapacityProviderArgs:
    def __init__(__self__, *,
                 auto_scaling_group_provider: Optional[pulumi.Input['CapacityProviderAutoScalingGroupProviderArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a CapacityProvider resource.
        :param pulumi.Input['CapacityProviderAutoScalingGroupProviderArgs'] auto_scaling_group_provider: The Auto Scaling group settings for the capacity provider.
        :param pulumi.Input[builtins.str] name: The name of the capacity provider. If a name is specified, it cannot start with `aws` , `ecs` , or `fargate` . If no name is specified, a default name in the `CFNStackName-CFNResourceName-RandomString` format is used.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The metadata that you apply to the capacity provider to help you categorize and organize it. Each tag consists of a key and an optional value. You define both.
               
               The following basic restrictions apply to tags:
               
               - Maximum number of tags per resource - 50
               - For each resource, each tag key must be unique, and each tag key can have only one value.
               - Maximum key length - 128 Unicode characters in UTF-8
               - Maximum value length - 256 Unicode characters in UTF-8
               - If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
               - Tag keys and values are case-sensitive.
               - Do not use `aws:` , `AWS:` , or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
        """
        if auto_scaling_group_provider is not None:
            pulumi.set(__self__, "auto_scaling_group_provider", auto_scaling_group_provider)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="autoScalingGroupProvider")
    def auto_scaling_group_provider(self) -> Optional[pulumi.Input['CapacityProviderAutoScalingGroupProviderArgs']]:
        """
        The Auto Scaling group settings for the capacity provider.
        """
        return pulumi.get(self, "auto_scaling_group_provider")

    @auto_scaling_group_provider.setter
    def auto_scaling_group_provider(self, value: Optional[pulumi.Input['CapacityProviderAutoScalingGroupProviderArgs']]):
        pulumi.set(self, "auto_scaling_group_provider", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the capacity provider. If a name is specified, it cannot start with `aws` , `ecs` , or `fargate` . If no name is specified, a default name in the `CFNStackName-CFNResourceName-RandomString` format is used.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The metadata that you apply to the capacity provider to help you categorize and organize it. Each tag consists of a key and an optional value. You define both.

        The following basic restrictions apply to tags:

        - Maximum number of tags per resource - 50
        - For each resource, each tag key must be unique, and each tag key can have only one value.
        - Maximum key length - 128 Unicode characters in UTF-8
        - Maximum value length - 256 Unicode characters in UTF-8
        - If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
        - Tag keys and values are case-sensitive.
        - Do not use `aws:` , `AWS:` , or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:ecs:CapacityProvider")
class CapacityProvider(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_scaling_group_provider: Optional[pulumi.Input[Union['CapacityProviderAutoScalingGroupProviderArgs', 'CapacityProviderAutoScalingGroupProviderArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::ECS::CapacityProvider.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_capacity_provider = aws_native.ecs.CapacityProvider("myCapacityProvider",
            auto_scaling_group_provider={
                "auto_scaling_group_arn": "arn:aws:autoscaling:us-west-2:123456789012:autoScalingGroup:a1b2c3d4-5678-90ab-cdef-EXAMPLE11111:autoScalingGroupName/MyAutoScalingGroup",
                "managed_scaling": {
                    "maximum_scaling_step_size": 10,
                    "minimum_scaling_step_size": 1,
                    "status": aws_native.ecs.CapacityProviderManagedScalingStatus.ENABLED,
                    "target_capacity": 100,
                },
                "managed_termination_protection": aws_native.ecs.CapacityProviderAutoScalingGroupProviderManagedTerminationProtection.ENABLED,
            },
            tags=[{
                "key": "environment",
                "value": "production",
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_capacity_provider = aws_native.ecs.CapacityProvider("myCapacityProvider",
            auto_scaling_group_provider={
                "auto_scaling_group_arn": "arn:aws:autoscaling:us-west-2:123456789012:autoScalingGroup:a1b2c3d4-5678-90ab-cdef-EXAMPLE11111:autoScalingGroupName/MyAutoScalingGroup",
                "managed_scaling": {
                    "maximum_scaling_step_size": 10,
                    "minimum_scaling_step_size": 1,
                    "status": aws_native.ecs.CapacityProviderManagedScalingStatus.ENABLED,
                    "target_capacity": 100,
                },
                "managed_termination_protection": aws_native.ecs.CapacityProviderAutoScalingGroupProviderManagedTerminationProtection.ENABLED,
            },
            tags=[{
                "key": "environment",
                "value": "production",
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        auto_scaling_group_arn1 = config.require("autoScalingGroupArn1")
        auto_scaling_group_arn2 = config.require("autoScalingGroupArn2")
        capacity_provider1 = aws_native.ecs.CapacityProvider("capacityProvider1", auto_scaling_group_provider={
            "auto_scaling_group_arn": auto_scaling_group_arn1,
            "managed_scaling": {
                "status": aws_native.ecs.CapacityProviderManagedScalingStatus.ENABLED,
            },
            "managed_termination_protection": aws_native.ecs.CapacityProviderAutoScalingGroupProviderManagedTerminationProtection.DISABLED,
        })
        capacity_provider2 = aws_native.ecs.CapacityProvider("capacityProvider2", auto_scaling_group_provider={
            "auto_scaling_group_arn": auto_scaling_group_arn2,
            "managed_scaling": {
                "status": aws_native.ecs.CapacityProviderManagedScalingStatus.ENABLED,
            },
            "managed_termination_protection": aws_native.ecs.CapacityProviderAutoScalingGroupProviderManagedTerminationProtection.DISABLED,
        })
        cluster = aws_native.ecs.Cluster("cluster")
        cluster_cpassociation = aws_native.ecs.ClusterCapacityProviderAssociations("clusterCPAssociation",
            cluster=cluster.id,
            capacity_providers=[
                capacity_provider1.id,
                capacity_provider2.id,
            ],
            default_capacity_provider_strategy=[
                {
                    "base": 2,
                    "weight": 6,
                    "capacity_provider": capacity_provider1.id,
                },
                {
                    "base": 0,
                    "weight": 10,
                    "capacity_provider": capacity_provider2.id,
                },
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        auto_scaling_group_arn1 = config.require("autoScalingGroupArn1")
        auto_scaling_group_arn2 = config.require("autoScalingGroupArn2")
        capacity_provider1 = aws_native.ecs.CapacityProvider("capacityProvider1", auto_scaling_group_provider={
            "auto_scaling_group_arn": auto_scaling_group_arn1,
            "managed_scaling": {
                "status": aws_native.ecs.CapacityProviderManagedScalingStatus.ENABLED,
            },
            "managed_termination_protection": aws_native.ecs.CapacityProviderAutoScalingGroupProviderManagedTerminationProtection.DISABLED,
        })
        capacity_provider2 = aws_native.ecs.CapacityProvider("capacityProvider2", auto_scaling_group_provider={
            "auto_scaling_group_arn": auto_scaling_group_arn2,
            "managed_scaling": {
                "status": aws_native.ecs.CapacityProviderManagedScalingStatus.ENABLED,
            },
            "managed_termination_protection": aws_native.ecs.CapacityProviderAutoScalingGroupProviderManagedTerminationProtection.DISABLED,
        })
        cluster = aws_native.ecs.Cluster("cluster")
        cluster_cpassociation = aws_native.ecs.ClusterCapacityProviderAssociations("clusterCPAssociation",
            cluster=cluster.id,
            capacity_providers=[
                capacity_provider1.id,
                capacity_provider2.id,
            ],
            default_capacity_provider_strategy=[
                {
                    "base": 2,
                    "weight": 6,
                    "capacity_provider": capacity_provider1.id,
                },
                {
                    "base": 0,
                    "weight": 10,
                    "capacity_provider": capacity_provider2.id,
                },
            ])

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CapacityProviderAutoScalingGroupProviderArgs', 'CapacityProviderAutoScalingGroupProviderArgsDict']] auto_scaling_group_provider: The Auto Scaling group settings for the capacity provider.
        :param pulumi.Input[builtins.str] name: The name of the capacity provider. If a name is specified, it cannot start with `aws` , `ecs` , or `fargate` . If no name is specified, a default name in the `CFNStackName-CFNResourceName-RandomString` format is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The metadata that you apply to the capacity provider to help you categorize and organize it. Each tag consists of a key and an optional value. You define both.
               
               The following basic restrictions apply to tags:
               
               - Maximum number of tags per resource - 50
               - For each resource, each tag key must be unique, and each tag key can have only one value.
               - Maximum key length - 128 Unicode characters in UTF-8
               - Maximum value length - 256 Unicode characters in UTF-8
               - If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
               - Tag keys and values are case-sensitive.
               - Do not use `aws:` , `AWS:` , or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[CapacityProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::ECS::CapacityProvider.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_capacity_provider = aws_native.ecs.CapacityProvider("myCapacityProvider",
            auto_scaling_group_provider={
                "auto_scaling_group_arn": "arn:aws:autoscaling:us-west-2:123456789012:autoScalingGroup:a1b2c3d4-5678-90ab-cdef-EXAMPLE11111:autoScalingGroupName/MyAutoScalingGroup",
                "managed_scaling": {
                    "maximum_scaling_step_size": 10,
                    "minimum_scaling_step_size": 1,
                    "status": aws_native.ecs.CapacityProviderManagedScalingStatus.ENABLED,
                    "target_capacity": 100,
                },
                "managed_termination_protection": aws_native.ecs.CapacityProviderAutoScalingGroupProviderManagedTerminationProtection.ENABLED,
            },
            tags=[{
                "key": "environment",
                "value": "production",
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_capacity_provider = aws_native.ecs.CapacityProvider("myCapacityProvider",
            auto_scaling_group_provider={
                "auto_scaling_group_arn": "arn:aws:autoscaling:us-west-2:123456789012:autoScalingGroup:a1b2c3d4-5678-90ab-cdef-EXAMPLE11111:autoScalingGroupName/MyAutoScalingGroup",
                "managed_scaling": {
                    "maximum_scaling_step_size": 10,
                    "minimum_scaling_step_size": 1,
                    "status": aws_native.ecs.CapacityProviderManagedScalingStatus.ENABLED,
                    "target_capacity": 100,
                },
                "managed_termination_protection": aws_native.ecs.CapacityProviderAutoScalingGroupProviderManagedTerminationProtection.ENABLED,
            },
            tags=[{
                "key": "environment",
                "value": "production",
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        auto_scaling_group_arn1 = config.require("autoScalingGroupArn1")
        auto_scaling_group_arn2 = config.require("autoScalingGroupArn2")
        capacity_provider1 = aws_native.ecs.CapacityProvider("capacityProvider1", auto_scaling_group_provider={
            "auto_scaling_group_arn": auto_scaling_group_arn1,
            "managed_scaling": {
                "status": aws_native.ecs.CapacityProviderManagedScalingStatus.ENABLED,
            },
            "managed_termination_protection": aws_native.ecs.CapacityProviderAutoScalingGroupProviderManagedTerminationProtection.DISABLED,
        })
        capacity_provider2 = aws_native.ecs.CapacityProvider("capacityProvider2", auto_scaling_group_provider={
            "auto_scaling_group_arn": auto_scaling_group_arn2,
            "managed_scaling": {
                "status": aws_native.ecs.CapacityProviderManagedScalingStatus.ENABLED,
            },
            "managed_termination_protection": aws_native.ecs.CapacityProviderAutoScalingGroupProviderManagedTerminationProtection.DISABLED,
        })
        cluster = aws_native.ecs.Cluster("cluster")
        cluster_cpassociation = aws_native.ecs.ClusterCapacityProviderAssociations("clusterCPAssociation",
            cluster=cluster.id,
            capacity_providers=[
                capacity_provider1.id,
                capacity_provider2.id,
            ],
            default_capacity_provider_strategy=[
                {
                    "base": 2,
                    "weight": 6,
                    "capacity_provider": capacity_provider1.id,
                },
                {
                    "base": 0,
                    "weight": 10,
                    "capacity_provider": capacity_provider2.id,
                },
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        config = pulumi.Config()
        auto_scaling_group_arn1 = config.require("autoScalingGroupArn1")
        auto_scaling_group_arn2 = config.require("autoScalingGroupArn2")
        capacity_provider1 = aws_native.ecs.CapacityProvider("capacityProvider1", auto_scaling_group_provider={
            "auto_scaling_group_arn": auto_scaling_group_arn1,
            "managed_scaling": {
                "status": aws_native.ecs.CapacityProviderManagedScalingStatus.ENABLED,
            },
            "managed_termination_protection": aws_native.ecs.CapacityProviderAutoScalingGroupProviderManagedTerminationProtection.DISABLED,
        })
        capacity_provider2 = aws_native.ecs.CapacityProvider("capacityProvider2", auto_scaling_group_provider={
            "auto_scaling_group_arn": auto_scaling_group_arn2,
            "managed_scaling": {
                "status": aws_native.ecs.CapacityProviderManagedScalingStatus.ENABLED,
            },
            "managed_termination_protection": aws_native.ecs.CapacityProviderAutoScalingGroupProviderManagedTerminationProtection.DISABLED,
        })
        cluster = aws_native.ecs.Cluster("cluster")
        cluster_cpassociation = aws_native.ecs.ClusterCapacityProviderAssociations("clusterCPAssociation",
            cluster=cluster.id,
            capacity_providers=[
                capacity_provider1.id,
                capacity_provider2.id,
            ],
            default_capacity_provider_strategy=[
                {
                    "base": 2,
                    "weight": 6,
                    "capacity_provider": capacity_provider1.id,
                },
                {
                    "base": 0,
                    "weight": 10,
                    "capacity_provider": capacity_provider2.id,
                },
            ])

        ```

        :param str resource_name: The name of the resource.
        :param CapacityProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CapacityProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_scaling_group_provider: Optional[pulumi.Input[Union['CapacityProviderAutoScalingGroupProviderArgs', 'CapacityProviderAutoScalingGroupProviderArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CapacityProviderArgs.__new__(CapacityProviderArgs)

            __props__.__dict__["auto_scaling_group_provider"] = auto_scaling_group_provider
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["autoScalingGroupProvider.autoScalingGroupArn", "name"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(CapacityProvider, __self__).__init__(
            'aws-native:ecs:CapacityProvider',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'CapacityProvider':
        """
        Get an existing CapacityProvider resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = CapacityProviderArgs.__new__(CapacityProviderArgs)

        __props__.__dict__["auto_scaling_group_provider"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["tags"] = None
        return CapacityProvider(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoScalingGroupProvider")
    def auto_scaling_group_provider(self) -> pulumi.Output[Optional['outputs.CapacityProviderAutoScalingGroupProvider']]:
        """
        The Auto Scaling group settings for the capacity provider.
        """
        return pulumi.get(self, "auto_scaling_group_provider")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the capacity provider. If a name is specified, it cannot start with `aws` , `ecs` , or `fargate` . If no name is specified, a default name in the `CFNStackName-CFNResourceName-RandomString` format is used.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The metadata that you apply to the capacity provider to help you categorize and organize it. Each tag consists of a key and an optional value. You define both.

        The following basic restrictions apply to tags:

        - Maximum number of tags per resource - 50
        - For each resource, each tag key must be unique, and each tag key can have only one value.
        - Maximum key length - 128 Unicode characters in UTF-8
        - Maximum value length - 256 Unicode characters in UTF-8
        - If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
        - Tag keys and values are case-sensitive.
        - Do not use `aws:` , `AWS:` , or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
        """
        return pulumi.get(self, "tags")

