# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PullThroughCacheRuleArgs', 'PullThroughCacheRule']

@pulumi.input_type
class PullThroughCacheRuleArgs:
    def __init__(__self__, *,
                 credential_arn: Optional[pulumi.Input[builtins.str]] = None,
                 custom_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 ecr_repository_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 upstream_registry: Optional[pulumi.Input[builtins.str]] = None,
                 upstream_registry_url: Optional[pulumi.Input[builtins.str]] = None,
                 upstream_repository_prefix: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a PullThroughCacheRule resource.
        :param pulumi.Input[builtins.str] credential_arn: The ARN of the Secrets Manager secret associated with the pull through cache rule.
        :param pulumi.Input[builtins.str] custom_role_arn: The ARN of the IAM role associated with the pull through cache rule.
        :param pulumi.Input[builtins.str] ecr_repository_prefix: The Amazon ECR repository prefix associated with the pull through cache rule.
        :param pulumi.Input[builtins.str] upstream_registry: The name of the upstream source registry associated with the pull through cache rule.
        :param pulumi.Input[builtins.str] upstream_registry_url: The upstream registry URL associated with the pull through cache rule.
        :param pulumi.Input[builtins.str] upstream_repository_prefix: The upstream repository prefix associated with the pull through cache rule.
        """
        if credential_arn is not None:
            pulumi.set(__self__, "credential_arn", credential_arn)
        if custom_role_arn is not None:
            pulumi.set(__self__, "custom_role_arn", custom_role_arn)
        if ecr_repository_prefix is not None:
            pulumi.set(__self__, "ecr_repository_prefix", ecr_repository_prefix)
        if upstream_registry is not None:
            pulumi.set(__self__, "upstream_registry", upstream_registry)
        if upstream_registry_url is not None:
            pulumi.set(__self__, "upstream_registry_url", upstream_registry_url)
        if upstream_repository_prefix is not None:
            pulumi.set(__self__, "upstream_repository_prefix", upstream_repository_prefix)

    @property
    @pulumi.getter(name="credentialArn")
    def credential_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the Secrets Manager secret associated with the pull through cache rule.
        """
        return pulumi.get(self, "credential_arn")

    @credential_arn.setter
    def credential_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "credential_arn", value)

    @property
    @pulumi.getter(name="customRoleArn")
    def custom_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the IAM role associated with the pull through cache rule.
        """
        return pulumi.get(self, "custom_role_arn")

    @custom_role_arn.setter
    def custom_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_role_arn", value)

    @property
    @pulumi.getter(name="ecrRepositoryPrefix")
    def ecr_repository_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon ECR repository prefix associated with the pull through cache rule.
        """
        return pulumi.get(self, "ecr_repository_prefix")

    @ecr_repository_prefix.setter
    def ecr_repository_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ecr_repository_prefix", value)

    @property
    @pulumi.getter(name="upstreamRegistry")
    def upstream_registry(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the upstream source registry associated with the pull through cache rule.
        """
        return pulumi.get(self, "upstream_registry")

    @upstream_registry.setter
    def upstream_registry(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "upstream_registry", value)

    @property
    @pulumi.getter(name="upstreamRegistryUrl")
    def upstream_registry_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The upstream registry URL associated with the pull through cache rule.
        """
        return pulumi.get(self, "upstream_registry_url")

    @upstream_registry_url.setter
    def upstream_registry_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "upstream_registry_url", value)

    @property
    @pulumi.getter(name="upstreamRepositoryPrefix")
    def upstream_repository_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The upstream repository prefix associated with the pull through cache rule.
        """
        return pulumi.get(self, "upstream_repository_prefix")

    @upstream_repository_prefix.setter
    def upstream_repository_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "upstream_repository_prefix", value)


@pulumi.type_token("aws-native:ecr:PullThroughCacheRule")
class PullThroughCacheRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credential_arn: Optional[pulumi.Input[builtins.str]] = None,
                 custom_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 ecr_repository_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 upstream_registry: Optional[pulumi.Input[builtins.str]] = None,
                 upstream_registry_url: Optional[pulumi.Input[builtins.str]] = None,
                 upstream_repository_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The ``AWS::ECR::PullThroughCacheRule`` resource creates or updates a pull through cache rule. A pull through cache rule provides a way to cache images from an upstream registry in your Amazon ECR private registry.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_ecr_pull_through_cache_rule = aws_native.ecr.PullThroughCacheRule("myECRPullThroughCacheRule",
            ecr_repository_prefix="my-ecr",
            upstream_registry_url="public.ecr.aws")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_ecr_pull_through_cache_rule = aws_native.ecr.PullThroughCacheRule("myECRPullThroughCacheRule",
            ecr_repository_prefix="my-ecr",
            upstream_registry_url="public.ecr.aws")

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] credential_arn: The ARN of the Secrets Manager secret associated with the pull through cache rule.
        :param pulumi.Input[builtins.str] custom_role_arn: The ARN of the IAM role associated with the pull through cache rule.
        :param pulumi.Input[builtins.str] ecr_repository_prefix: The Amazon ECR repository prefix associated with the pull through cache rule.
        :param pulumi.Input[builtins.str] upstream_registry: The name of the upstream source registry associated with the pull through cache rule.
        :param pulumi.Input[builtins.str] upstream_registry_url: The upstream registry URL associated with the pull through cache rule.
        :param pulumi.Input[builtins.str] upstream_repository_prefix: The upstream repository prefix associated with the pull through cache rule.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[PullThroughCacheRuleArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The ``AWS::ECR::PullThroughCacheRule`` resource creates or updates a pull through cache rule. A pull through cache rule provides a way to cache images from an upstream registry in your Amazon ECR private registry.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_ecr_pull_through_cache_rule = aws_native.ecr.PullThroughCacheRule("myECRPullThroughCacheRule",
            ecr_repository_prefix="my-ecr",
            upstream_registry_url="public.ecr.aws")

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_ecr_pull_through_cache_rule = aws_native.ecr.PullThroughCacheRule("myECRPullThroughCacheRule",
            ecr_repository_prefix="my-ecr",
            upstream_registry_url="public.ecr.aws")

        ```

        :param str resource_name: The name of the resource.
        :param PullThroughCacheRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PullThroughCacheRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credential_arn: Optional[pulumi.Input[builtins.str]] = None,
                 custom_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 ecr_repository_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 upstream_registry: Optional[pulumi.Input[builtins.str]] = None,
                 upstream_registry_url: Optional[pulumi.Input[builtins.str]] = None,
                 upstream_repository_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PullThroughCacheRuleArgs.__new__(PullThroughCacheRuleArgs)

            __props__.__dict__["credential_arn"] = credential_arn
            __props__.__dict__["custom_role_arn"] = custom_role_arn
            __props__.__dict__["ecr_repository_prefix"] = ecr_repository_prefix
            __props__.__dict__["upstream_registry"] = upstream_registry
            __props__.__dict__["upstream_registry_url"] = upstream_registry_url
            __props__.__dict__["upstream_repository_prefix"] = upstream_repository_prefix
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["credentialArn", "customRoleArn", "ecrRepositoryPrefix", "upstreamRegistry", "upstreamRegistryUrl", "upstreamRepositoryPrefix"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(PullThroughCacheRule, __self__).__init__(
            'aws-native:ecr:PullThroughCacheRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'PullThroughCacheRule':
        """
        Get an existing PullThroughCacheRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = PullThroughCacheRuleArgs.__new__(PullThroughCacheRuleArgs)

        __props__.__dict__["credential_arn"] = None
        __props__.__dict__["custom_role_arn"] = None
        __props__.__dict__["ecr_repository_prefix"] = None
        __props__.__dict__["upstream_registry"] = None
        __props__.__dict__["upstream_registry_url"] = None
        __props__.__dict__["upstream_repository_prefix"] = None
        return PullThroughCacheRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="credentialArn")
    def credential_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ARN of the Secrets Manager secret associated with the pull through cache rule.
        """
        return pulumi.get(self, "credential_arn")

    @property
    @pulumi.getter(name="customRoleArn")
    def custom_role_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ARN of the IAM role associated with the pull through cache rule.
        """
        return pulumi.get(self, "custom_role_arn")

    @property
    @pulumi.getter(name="ecrRepositoryPrefix")
    def ecr_repository_prefix(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon ECR repository prefix associated with the pull through cache rule.
        """
        return pulumi.get(self, "ecr_repository_prefix")

    @property
    @pulumi.getter(name="upstreamRegistry")
    def upstream_registry(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the upstream source registry associated with the pull through cache rule.
        """
        return pulumi.get(self, "upstream_registry")

    @property
    @pulumi.getter(name="upstreamRegistryUrl")
    def upstream_registry_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The upstream registry URL associated with the pull through cache rule.
        """
        return pulumi.get(self, "upstream_registry_url")

    @property
    @pulumi.getter(name="upstreamRepositoryPrefix")
    def upstream_repository_prefix(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The upstream repository prefix associated with the pull through cache rule.
        """
        return pulumi.get(self, "upstream_repository_prefix")

