# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'RegistryScanningConfigurationRepositoryFilter',
    'RegistryScanningConfigurationScanningRule',
    'ReplicationConfiguration',
    'ReplicationConfigurationReplicationDestination',
    'ReplicationConfigurationReplicationRule',
    'ReplicationConfigurationRepositoryFilter',
    'RepositoryCreationTemplateEncryptionConfiguration',
    'RepositoryCreationTemplateTag',
    'RepositoryEncryptionConfiguration',
    'RepositoryImageScanningConfiguration',
    'RepositoryLifecyclePolicy',
]

@pulumi.output_type
class RegistryScanningConfigurationRepositoryFilter(dict):
    """
    The filter settings used with image replication. Specifying a repository filter to a replication rule provides a method for controlling which repositories in a private registry are replicated. If no filters are added, the contents of all repositories are replicated.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filterType":
            suggest = "filter_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistryScanningConfigurationRepositoryFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistryScanningConfigurationRepositoryFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistryScanningConfigurationRepositoryFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filter: builtins.str,
                 filter_type: 'RegistryScanningConfigurationFilterType'):
        """
        The filter settings used with image replication. Specifying a repository filter to a replication rule provides a method for controlling which repositories in a private registry are replicated. If no filters are added, the contents of all repositories are replicated.
        :param builtins.str filter: The filter to use when scanning.
        :param 'RegistryScanningConfigurationFilterType' filter_type: The type associated with the filter.
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "filter_type", filter_type)

    @property
    @pulumi.getter
    def filter(self) -> builtins.str:
        """
        The filter to use when scanning.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> 'RegistryScanningConfigurationFilterType':
        """
        The type associated with the filter.
        """
        return pulumi.get(self, "filter_type")


@pulumi.output_type
class RegistryScanningConfigurationScanningRule(dict):
    """
    The scanning rules associated with the registry.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repositoryFilters":
            suggest = "repository_filters"
        elif key == "scanFrequency":
            suggest = "scan_frequency"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistryScanningConfigurationScanningRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistryScanningConfigurationScanningRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistryScanningConfigurationScanningRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repository_filters: Sequence['outputs.RegistryScanningConfigurationRepositoryFilter'],
                 scan_frequency: 'RegistryScanningConfigurationScanFrequency'):
        """
        The scanning rules associated with the registry.
        :param Sequence['RegistryScanningConfigurationRepositoryFilter'] repository_filters: The details of a scanning repository filter. For more information on how to use filters, see [Using filters](https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-scanning.html#image-scanning-filters) in the *Amazon Elastic Container Registry User Guide*.
        :param 'RegistryScanningConfigurationScanFrequency' scan_frequency: The frequency that scans are performed at for a private registry. When the ``ENHANCED`` scan type is specified, the supported scan frequencies are ``CONTINUOUS_SCAN`` and ``SCAN_ON_PUSH``. When the ``BASIC`` scan type is specified, the ``SCAN_ON_PUSH`` scan frequency is supported. If scan on push is not specified, then the ``MANUAL`` scan frequency is set by default.
        """
        pulumi.set(__self__, "repository_filters", repository_filters)
        pulumi.set(__self__, "scan_frequency", scan_frequency)

    @property
    @pulumi.getter(name="repositoryFilters")
    def repository_filters(self) -> Sequence['outputs.RegistryScanningConfigurationRepositoryFilter']:
        """
        The details of a scanning repository filter. For more information on how to use filters, see [Using filters](https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-scanning.html#image-scanning-filters) in the *Amazon Elastic Container Registry User Guide*.
        """
        return pulumi.get(self, "repository_filters")

    @property
    @pulumi.getter(name="scanFrequency")
    def scan_frequency(self) -> 'RegistryScanningConfigurationScanFrequency':
        """
        The frequency that scans are performed at for a private registry. When the ``ENHANCED`` scan type is specified, the supported scan frequencies are ``CONTINUOUS_SCAN`` and ``SCAN_ON_PUSH``. When the ``BASIC`` scan type is specified, the ``SCAN_ON_PUSH`` scan frequency is supported. If scan on push is not specified, then the ``MANUAL`` scan frequency is set by default.
        """
        return pulumi.get(self, "scan_frequency")


@pulumi.output_type
class ReplicationConfiguration(dict):
    """
    The replication configuration for a registry.
    """
    def __init__(__self__, *,
                 rules: Sequence['outputs.ReplicationConfigurationReplicationRule']):
        """
        The replication configuration for a registry.
        :param Sequence['ReplicationConfigurationReplicationRule'] rules: An array of objects representing the replication destinations and repository filters for a replication configuration.
        """
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.ReplicationConfigurationReplicationRule']:
        """
        An array of objects representing the replication destinations and repository filters for a replication configuration.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class ReplicationConfigurationReplicationDestination(dict):
    """
    An array of objects representing the destination for a replication rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "registryId":
            suggest = "registry_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationConfigurationReplicationDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationConfigurationReplicationDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationConfigurationReplicationDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region: builtins.str,
                 registry_id: builtins.str):
        """
        An array of objects representing the destination for a replication rule.
        :param builtins.str region: The Region to replicate to.
        :param builtins.str registry_id: The AWS account ID of the Amazon ECR private registry to replicate to. When configuring cross-Region replication within your own registry, specify your own account ID.
        """
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "registry_id", registry_id)

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        The Region to replicate to.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> builtins.str:
        """
        The AWS account ID of the Amazon ECR private registry to replicate to. When configuring cross-Region replication within your own registry, specify your own account ID.
        """
        return pulumi.get(self, "registry_id")


@pulumi.output_type
class ReplicationConfigurationReplicationRule(dict):
    """
    An array of objects representing the replication destinations and repository filters for a replication configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repositoryFilters":
            suggest = "repository_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationConfigurationReplicationRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationConfigurationReplicationRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationConfigurationReplicationRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destinations: Sequence['outputs.ReplicationConfigurationReplicationDestination'],
                 repository_filters: Optional[Sequence['outputs.ReplicationConfigurationRepositoryFilter']] = None):
        """
        An array of objects representing the replication destinations and repository filters for a replication configuration.
        :param Sequence['ReplicationConfigurationReplicationDestination'] destinations: An array of objects representing the destination for a replication rule.
        :param Sequence['ReplicationConfigurationRepositoryFilter'] repository_filters: An array of objects representing the filters for a replication rule. Specifying a repository filter for a replication rule provides a method for controlling which repositories in a private registry are replicated.
        """
        pulumi.set(__self__, "destinations", destinations)
        if repository_filters is not None:
            pulumi.set(__self__, "repository_filters", repository_filters)

    @property
    @pulumi.getter
    def destinations(self) -> Sequence['outputs.ReplicationConfigurationReplicationDestination']:
        """
        An array of objects representing the destination for a replication rule.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter(name="repositoryFilters")
    def repository_filters(self) -> Optional[Sequence['outputs.ReplicationConfigurationRepositoryFilter']]:
        """
        An array of objects representing the filters for a replication rule. Specifying a repository filter for a replication rule provides a method for controlling which repositories in a private registry are replicated.
        """
        return pulumi.get(self, "repository_filters")


@pulumi.output_type
class ReplicationConfigurationRepositoryFilter(dict):
    """
    The filter settings used with image replication. Specifying a repository filter to a replication rule provides a method for controlling which repositories in a private registry are replicated. If no filters are added, the contents of all repositories are replicated.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filterType":
            suggest = "filter_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReplicationConfigurationRepositoryFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReplicationConfigurationRepositoryFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReplicationConfigurationRepositoryFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filter: builtins.str,
                 filter_type: 'ReplicationConfigurationFilterType'):
        """
        The filter settings used with image replication. Specifying a repository filter to a replication rule provides a method for controlling which repositories in a private registry are replicated. If no filters are added, the contents of all repositories are replicated.
        :param builtins.str filter: The repository filter details. When the ``PREFIX_MATCH`` filter type is specified, this value is required and should be the repository name prefix to configure replication for.
        :param 'ReplicationConfigurationFilterType' filter_type: The repository filter type. The only supported value is ``PREFIX_MATCH``, which is a repository name prefix specified with the ``filter`` parameter.
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "filter_type", filter_type)

    @property
    @pulumi.getter
    def filter(self) -> builtins.str:
        """
        The repository filter details. When the ``PREFIX_MATCH`` filter type is specified, this value is required and should be the repository name prefix to configure replication for.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> 'ReplicationConfigurationFilterType':
        """
        The repository filter type. The only supported value is ``PREFIX_MATCH``, which is a repository name prefix specified with the ``filter`` parameter.
        """
        return pulumi.get(self, "filter_type")


@pulumi.output_type
class RepositoryCreationTemplateEncryptionConfiguration(dict):
    """
    The encryption configuration for the repository. This determines how the contents of your repository are encrypted at rest.
     By default, when no encryption configuration is set or the ``AES256`` encryption type is used, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts your data at rest using an AES256 encryption algorithm. This does not require any action on your part.
     For more control over the encryption of the contents of your repository, you can use server-side encryption with KMSlong key stored in KMSlong (KMS) to encrypt your images. For more information, see [Amazon ECR encryption at rest](https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html) in the *Amazon Elastic Container Registry User Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionType":
            suggest = "encryption_type"
        elif key == "kmsKey":
            suggest = "kms_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryCreationTemplateEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryCreationTemplateEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryCreationTemplateEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_type: 'RepositoryCreationTemplateEncryptionType',
                 kms_key: Optional[builtins.str] = None):
        """
        The encryption configuration for the repository. This determines how the contents of your repository are encrypted at rest.
         By default, when no encryption configuration is set or the ``AES256`` encryption type is used, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts your data at rest using an AES256 encryption algorithm. This does not require any action on your part.
         For more control over the encryption of the contents of your repository, you can use server-side encryption with KMSlong key stored in KMSlong (KMS) to encrypt your images. For more information, see [Amazon ECR encryption at rest](https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html) in the *Amazon Elastic Container Registry User Guide*.
        :param 'RepositoryCreationTemplateEncryptionType' encryption_type: The encryption type to use.
                If you use the ``KMS`` encryption type, the contents of the repository will be encrypted using server-side encryption with KMSlong key stored in KMS. When you use KMS to encrypt your data, you can either use the default AWS managed KMS key for Amazon ECR, or specify your own KMS key, which you already created.
                If you use the ``KMS_DSSE`` encryption type, the contents of the repository will be encrypted with two layers of encryption using server-side encryption with the KMS Management Service key stored in KMS. Similar to the ``KMS`` encryption type, you can either use the default AWS managed KMS key for Amazon ECR, or specify your own KMS key, which you've already created. 
                If you use the ``AES256`` encryption type, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts the images in the repository using an AES256 encryption algorithm.
                For more information, see [Amazon ECR encryption at rest](https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html) in the *Amazon Elastic Container Registry User Guide*.
        :param builtins.str kms_key: If you use the ``KMS`` encryption type, specify the KMS key to use for encryption. The alias, key ID, or full ARN of the KMS key can be specified. The key must exist in the same Region as the repository. If no key is specified, the default AWS managed KMS key for Amazon ECR will be used.
        """
        pulumi.set(__self__, "encryption_type", encryption_type)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> 'RepositoryCreationTemplateEncryptionType':
        """
        The encryption type to use.
         If you use the ``KMS`` encryption type, the contents of the repository will be encrypted using server-side encryption with KMSlong key stored in KMS. When you use KMS to encrypt your data, you can either use the default AWS managed KMS key for Amazon ECR, or specify your own KMS key, which you already created.
         If you use the ``KMS_DSSE`` encryption type, the contents of the repository will be encrypted with two layers of encryption using server-side encryption with the KMS Management Service key stored in KMS. Similar to the ``KMS`` encryption type, you can either use the default AWS managed KMS key for Amazon ECR, or specify your own KMS key, which you've already created. 
         If you use the ``AES256`` encryption type, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts the images in the repository using an AES256 encryption algorithm.
         For more information, see [Amazon ECR encryption at rest](https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html) in the *Amazon Elastic Container Registry User Guide*.
        """
        return pulumi.get(self, "encryption_type")

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[builtins.str]:
        """
        If you use the ``KMS`` encryption type, specify the KMS key to use for encryption. The alias, key ID, or full ARN of the KMS key can be specified. The key must exist in the same Region as the repository. If no key is specified, the default AWS managed KMS key for Amazon ECR will be used.
        """
        return pulumi.get(self, "kms_key")


@pulumi.output_type
class RepositoryCreationTemplateTag(dict):
    """
    The metadata to apply to a resource to help you categorize and organize them. Each tag consists of a key and a value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
    """
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        The metadata to apply to a resource to help you categorize and organize them. Each tag consists of a key and a value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
        :param builtins.str key: One part of a key-value pair that make up a tag. A ``key`` is a general label that acts like a category for more specific tag values.
        :param builtins.str value: A ``value`` acts as a descriptor within a tag category (key).
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        One part of a key-value pair that make up a tag. A ``key`` is a general label that acts like a category for more specific tag values.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        A ``value`` acts as a descriptor within a tag category (key).
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RepositoryEncryptionConfiguration(dict):
    """
    The encryption configuration for the repository. This determines how the contents of your repository are encrypted at rest.
     By default, when no encryption configuration is set or the ``AES256`` encryption type is used, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts your data at rest using an AES256 encryption algorithm. This does not require any action on your part.
     For more control over the encryption of the contents of your repository, you can use server-side encryption with KMSlong key stored in KMSlong (KMS) to encrypt your images. For more information, see [Amazon ECR encryption at rest](https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html) in the *Amazon Elastic Container Registry User Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionType":
            suggest = "encryption_type"
        elif key == "kmsKey":
            suggest = "kms_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_type: 'RepositoryEncryptionType',
                 kms_key: Optional[builtins.str] = None):
        """
        The encryption configuration for the repository. This determines how the contents of your repository are encrypted at rest.
         By default, when no encryption configuration is set or the ``AES256`` encryption type is used, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts your data at rest using an AES256 encryption algorithm. This does not require any action on your part.
         For more control over the encryption of the contents of your repository, you can use server-side encryption with KMSlong key stored in KMSlong (KMS) to encrypt your images. For more information, see [Amazon ECR encryption at rest](https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html) in the *Amazon Elastic Container Registry User Guide*.
        :param 'RepositoryEncryptionType' encryption_type: The encryption type to use.
               
               If you use the `KMS` encryption type, the contents of the repository will be encrypted using server-side encryption with AWS Key Management Service key stored in AWS KMS . When you use AWS KMS to encrypt your data, you can either use the default AWS managed AWS KMS key for Amazon ECR, or specify your own AWS KMS key, which you already created.
               
               If you use the `KMS_DSSE` encryption type, the contents of the repository will be encrypted with two layers of encryption using server-side encryption with the AWS KMS Management Service key stored in AWS KMS . Similar to the `KMS` encryption type, you can either use the default AWS managed AWS KMS key for Amazon ECR, or specify your own AWS KMS key, which you've already created.
               
               If you use the `AES256` encryption type, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts the images in the repository using an AES256 encryption algorithm.
               
               For more information, see [Amazon ECR encryption at rest](https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html) in the *Amazon Elastic Container Registry User Guide* .
        :param builtins.str kms_key: If you use the ``KMS`` encryption type, specify the KMS key to use for encryption. The alias, key ID, or full ARN of the KMS key can be specified. The key must exist in the same Region as the repository. If no key is specified, the default AWS managed KMS key for Amazon ECR will be used.
        """
        pulumi.set(__self__, "encryption_type", encryption_type)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> 'RepositoryEncryptionType':
        """
        The encryption type to use.

        If you use the `KMS` encryption type, the contents of the repository will be encrypted using server-side encryption with AWS Key Management Service key stored in AWS KMS . When you use AWS KMS to encrypt your data, you can either use the default AWS managed AWS KMS key for Amazon ECR, or specify your own AWS KMS key, which you already created.

        If you use the `KMS_DSSE` encryption type, the contents of the repository will be encrypted with two layers of encryption using server-side encryption with the AWS KMS Management Service key stored in AWS KMS . Similar to the `KMS` encryption type, you can either use the default AWS managed AWS KMS key for Amazon ECR, or specify your own AWS KMS key, which you've already created.

        If you use the `AES256` encryption type, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts the images in the repository using an AES256 encryption algorithm.

        For more information, see [Amazon ECR encryption at rest](https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html) in the *Amazon Elastic Container Registry User Guide* .
        """
        return pulumi.get(self, "encryption_type")

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[builtins.str]:
        """
        If you use the ``KMS`` encryption type, specify the KMS key to use for encryption. The alias, key ID, or full ARN of the KMS key can be specified. The key must exist in the same Region as the repository. If no key is specified, the default AWS managed KMS key for Amazon ECR will be used.
        """
        return pulumi.get(self, "kms_key")


@pulumi.output_type
class RepositoryImageScanningConfiguration(dict):
    """
    The image scanning configuration for a repository.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scanOnPush":
            suggest = "scan_on_push"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryImageScanningConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryImageScanningConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryImageScanningConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scan_on_push: Optional[builtins.bool] = None):
        """
        The image scanning configuration for a repository.
        :param builtins.bool scan_on_push: The setting that determines whether images are scanned after being pushed to a repository. If set to ``true``, images will be scanned after being pushed. If this parameter is not specified, it will default to ``false`` and images will not be scanned unless a scan is manually started.
        """
        if scan_on_push is not None:
            pulumi.set(__self__, "scan_on_push", scan_on_push)

    @property
    @pulumi.getter(name="scanOnPush")
    def scan_on_push(self) -> Optional[builtins.bool]:
        """
        The setting that determines whether images are scanned after being pushed to a repository. If set to ``true``, images will be scanned after being pushed. If this parameter is not specified, it will default to ``false`` and images will not be scanned unless a scan is manually started.
        """
        return pulumi.get(self, "scan_on_push")


@pulumi.output_type
class RepositoryLifecyclePolicy(dict):
    """
    The ``LifecyclePolicy`` property type specifies a lifecycle policy. For information about lifecycle policy syntax, see [Lifecycle policy template](https://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html) in the *Amazon ECR User Guide*.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lifecyclePolicyText":
            suggest = "lifecycle_policy_text"
        elif key == "registryId":
            suggest = "registry_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepositoryLifecyclePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepositoryLifecyclePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepositoryLifecyclePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lifecycle_policy_text: Optional[builtins.str] = None,
                 registry_id: Optional[builtins.str] = None):
        """
        The ``LifecyclePolicy`` property type specifies a lifecycle policy. For information about lifecycle policy syntax, see [Lifecycle policy template](https://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html) in the *Amazon ECR User Guide*.
        :param builtins.str lifecycle_policy_text: The JSON repository policy text to apply to the repository.
        :param builtins.str registry_id: The AWS account ID associated with the registry that contains the repository. If you do
                not specify a registry, the default registry is assumed.
        """
        if lifecycle_policy_text is not None:
            pulumi.set(__self__, "lifecycle_policy_text", lifecycle_policy_text)
        if registry_id is not None:
            pulumi.set(__self__, "registry_id", registry_id)

    @property
    @pulumi.getter(name="lifecyclePolicyText")
    def lifecycle_policy_text(self) -> Optional[builtins.str]:
        """
        The JSON repository policy text to apply to the repository.
        """
        return pulumi.get(self, "lifecycle_policy_text")

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> Optional[builtins.str]:
        """
        The AWS account ID associated with the registry that contains the repository. If you do
         not specify a registry, the default registry is assumed.
        """
        return pulumi.get(self, "registry_id")


