# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetRepositoryCreationTemplateResult',
    'AwaitableGetRepositoryCreationTemplateResult',
    'get_repository_creation_template',
    'get_repository_creation_template_output',
]

@pulumi.output_type
class GetRepositoryCreationTemplateResult:
    def __init__(__self__, applied_for=None, created_at=None, custom_role_arn=None, description=None, encryption_configuration=None, image_tag_mutability=None, lifecycle_policy=None, repository_policy=None, resource_tags=None, updated_at=None):
        if applied_for and not isinstance(applied_for, list):
            raise TypeError("Expected argument 'applied_for' to be a list")
        pulumi.set(__self__, "applied_for", applied_for)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if custom_role_arn and not isinstance(custom_role_arn, str):
            raise TypeError("Expected argument 'custom_role_arn' to be a str")
        pulumi.set(__self__, "custom_role_arn", custom_role_arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if encryption_configuration and not isinstance(encryption_configuration, dict):
            raise TypeError("Expected argument 'encryption_configuration' to be a dict")
        pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if image_tag_mutability and not isinstance(image_tag_mutability, str):
            raise TypeError("Expected argument 'image_tag_mutability' to be a str")
        pulumi.set(__self__, "image_tag_mutability", image_tag_mutability)
        if lifecycle_policy and not isinstance(lifecycle_policy, str):
            raise TypeError("Expected argument 'lifecycle_policy' to be a str")
        pulumi.set(__self__, "lifecycle_policy", lifecycle_policy)
        if repository_policy and not isinstance(repository_policy, str):
            raise TypeError("Expected argument 'repository_policy' to be a str")
        pulumi.set(__self__, "repository_policy", repository_policy)
        if resource_tags and not isinstance(resource_tags, list):
            raise TypeError("Expected argument 'resource_tags' to be a list")
        pulumi.set(__self__, "resource_tags", resource_tags)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="appliedFor")
    def applied_for(self) -> Optional[Sequence['RepositoryCreationTemplateAppliedForItem']]:
        """
        A list of enumerable Strings representing the repository creation scenarios that this template will apply towards. The two supported scenarios are PULL_THROUGH_CACHE and REPLICATION
        """
        return pulumi.get(self, "applied_for")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[builtins.str]:
        """
        The date and time, in JavaScript date format, when the repository creation template was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="customRoleArn")
    def custom_role_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the role to be assumed by Amazon ECR. Amazon ECR will assume your supplied role when the customRoleArn is specified. When this field isn't specified, Amazon ECR will use the service-linked role for the repository creation template.
        """
        return pulumi.get(self, "custom_role_arn")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description associated with the repository creation template.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional['outputs.RepositoryCreationTemplateEncryptionConfiguration']:
        """
        The encryption configuration associated with the repository creation template.
        """
        return pulumi.get(self, "encryption_configuration")

    @property
    @pulumi.getter(name="imageTagMutability")
    def image_tag_mutability(self) -> Optional['RepositoryCreationTemplateImageTagMutability']:
        """
        The tag mutability setting for the repository. If this parameter is omitted, the default setting of MUTABLE will be used which will allow image tags to be overwritten. If IMMUTABLE is specified, all image tags within the repository will be immutable which will prevent them from being overwritten.
        """
        return pulumi.get(self, "image_tag_mutability")

    @property
    @pulumi.getter(name="lifecyclePolicy")
    def lifecycle_policy(self) -> Optional[builtins.str]:
        """
        The lifecycle policy to use for repositories created using the template.
        """
        return pulumi.get(self, "lifecycle_policy")

    @property
    @pulumi.getter(name="repositoryPolicy")
    def repository_policy(self) -> Optional[builtins.str]:
        """
        The repository policy to apply to repositories created using the template. A repository policy is a permissions policy associated with a repository to control access permissions.
        """
        return pulumi.get(self, "repository_policy")

    @property
    @pulumi.getter(name="resourceTags")
    def resource_tags(self) -> Optional[Sequence['outputs.RepositoryCreationTemplateTag']]:
        """
        The metadata to apply to the repository to help you categorize and organize. Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
        """
        return pulumi.get(self, "resource_tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[builtins.str]:
        """
        The date and time, in JavaScript date format, when the repository creation template was last updated.
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetRepositoryCreationTemplateResult(GetRepositoryCreationTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoryCreationTemplateResult(
            applied_for=self.applied_for,
            created_at=self.created_at,
            custom_role_arn=self.custom_role_arn,
            description=self.description,
            encryption_configuration=self.encryption_configuration,
            image_tag_mutability=self.image_tag_mutability,
            lifecycle_policy=self.lifecycle_policy,
            repository_policy=self.repository_policy,
            resource_tags=self.resource_tags,
            updated_at=self.updated_at)


def get_repository_creation_template(prefix: Optional[builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoryCreationTemplateResult:
    """
    The details of the repository creation template associated with the request.


    :param builtins.str prefix: The repository namespace prefix associated with the repository creation template.
    """
    __args__ = dict()
    __args__['prefix'] = prefix
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ecr:getRepositoryCreationTemplate', __args__, opts=opts, typ=GetRepositoryCreationTemplateResult).value

    return AwaitableGetRepositoryCreationTemplateResult(
        applied_for=pulumi.get(__ret__, 'applied_for'),
        created_at=pulumi.get(__ret__, 'created_at'),
        custom_role_arn=pulumi.get(__ret__, 'custom_role_arn'),
        description=pulumi.get(__ret__, 'description'),
        encryption_configuration=pulumi.get(__ret__, 'encryption_configuration'),
        image_tag_mutability=pulumi.get(__ret__, 'image_tag_mutability'),
        lifecycle_policy=pulumi.get(__ret__, 'lifecycle_policy'),
        repository_policy=pulumi.get(__ret__, 'repository_policy'),
        resource_tags=pulumi.get(__ret__, 'resource_tags'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_repository_creation_template_output(prefix: Optional[pulumi.Input[builtins.str]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRepositoryCreationTemplateResult]:
    """
    The details of the repository creation template associated with the request.


    :param builtins.str prefix: The repository namespace prefix associated with the repository creation template.
    """
    __args__ = dict()
    __args__['prefix'] = prefix
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ecr:getRepositoryCreationTemplate', __args__, opts=opts, typ=GetRepositoryCreationTemplateResult)
    return __ret__.apply(lambda __response__: GetRepositoryCreationTemplateResult(
        applied_for=pulumi.get(__response__, 'applied_for'),
        created_at=pulumi.get(__response__, 'created_at'),
        custom_role_arn=pulumi.get(__response__, 'custom_role_arn'),
        description=pulumi.get(__response__, 'description'),
        encryption_configuration=pulumi.get(__response__, 'encryption_configuration'),
        image_tag_mutability=pulumi.get(__response__, 'image_tag_mutability'),
        lifecycle_policy=pulumi.get(__response__, 'lifecycle_policy'),
        repository_policy=pulumi.get(__response__, 'repository_policy'),
        resource_tags=pulumi.get(__response__, 'resource_tags'),
        updated_at=pulumi.get(__response__, 'updated_at')))
