# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetReplicationConfigurationResult',
    'AwaitableGetReplicationConfigurationResult',
    'get_replication_configuration',
    'get_replication_configuration_output',
]

@pulumi.output_type
class GetReplicationConfigurationResult:
    def __init__(__self__, registry_id=None, replication_configuration=None):
        if registry_id and not isinstance(registry_id, str):
            raise TypeError("Expected argument 'registry_id' to be a str")
        pulumi.set(__self__, "registry_id", registry_id)
        if replication_configuration and not isinstance(replication_configuration, dict):
            raise TypeError("Expected argument 'replication_configuration' to be a dict")
        pulumi.set(__self__, "replication_configuration", replication_configuration)

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> Optional[builtins.str]:
        """
        The account ID of the destination registry.
        """
        return pulumi.get(self, "registry_id")

    @property
    @pulumi.getter(name="replicationConfiguration")
    def replication_configuration(self) -> Optional['outputs.ReplicationConfiguration']:
        """
        The replication configuration for a registry.
        """
        return pulumi.get(self, "replication_configuration")


class AwaitableGetReplicationConfigurationResult(GetReplicationConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReplicationConfigurationResult(
            registry_id=self.registry_id,
            replication_configuration=self.replication_configuration)


def get_replication_configuration(registry_id: Optional[builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetReplicationConfigurationResult:
    """
    The ``AWS::ECR::ReplicationConfiguration`` resource creates or updates the replication configuration for a private registry. The first time a replication configuration is applied to a private registry, a service-linked IAM role is created in your account for the replication process. For more information, see [Using Service-Linked Roles for Amazon ECR](https://docs.aws.amazon.com/AmazonECR/latest/userguide/using-service-linked-roles.html) in the *Amazon Elastic Container Registry User Guide*.
      When configuring cross-account replication, the destination account must grant the source account permission to replicate. This permission is controlled using a private registry permissions policy. For more information, see ``AWS::ECR::RegistryPolicy``.


    :param builtins.str registry_id: The account ID of the destination registry.
    """
    __args__ = dict()
    __args__['registryId'] = registry_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ecr:getReplicationConfiguration', __args__, opts=opts, typ=GetReplicationConfigurationResult).value

    return AwaitableGetReplicationConfigurationResult(
        registry_id=pulumi.get(__ret__, 'registry_id'),
        replication_configuration=pulumi.get(__ret__, 'replication_configuration'))
def get_replication_configuration_output(registry_id: Optional[pulumi.Input[builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetReplicationConfigurationResult]:
    """
    The ``AWS::ECR::ReplicationConfiguration`` resource creates or updates the replication configuration for a private registry. The first time a replication configuration is applied to a private registry, a service-linked IAM role is created in your account for the replication process. For more information, see [Using Service-Linked Roles for Amazon ECR](https://docs.aws.amazon.com/AmazonECR/latest/userguide/using-service-linked-roles.html) in the *Amazon Elastic Container Registry User Guide*.
      When configuring cross-account replication, the destination account must grant the source account permission to replicate. This permission is controlled using a private registry permissions policy. For more information, see ``AWS::ECR::RegistryPolicy``.


    :param builtins.str registry_id: The account ID of the destination registry.
    """
    __args__ = dict()
    __args__['registryId'] = registry_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ecr:getReplicationConfiguration', __args__, opts=opts, typ=GetReplicationConfigurationResult)
    return __ret__.apply(lambda __response__: GetReplicationConfigurationResult(
        registry_id=pulumi.get(__response__, 'registry_id'),
        replication_configuration=pulumi.get(__response__, 'replication_configuration')))
