# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetRegistryScanningConfigurationResult',
    'AwaitableGetRegistryScanningConfigurationResult',
    'get_registry_scanning_configuration',
    'get_registry_scanning_configuration_output',
]

@pulumi.output_type
class GetRegistryScanningConfigurationResult:
    def __init__(__self__, registry_id=None, rules=None, scan_type=None):
        if registry_id and not isinstance(registry_id, str):
            raise TypeError("Expected argument 'registry_id' to be a str")
        pulumi.set(__self__, "registry_id", registry_id)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if scan_type and not isinstance(scan_type, str):
            raise TypeError("Expected argument 'scan_type' to be a str")
        pulumi.set(__self__, "scan_type", scan_type)

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> Optional[builtins.str]:
        """
        The account ID of the destination registry.
        """
        return pulumi.get(self, "registry_id")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.RegistryScanningConfigurationScanningRule']]:
        """
        The scanning rules associated with the registry.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="scanType")
    def scan_type(self) -> Optional['RegistryScanningConfigurationScanType']:
        """
        The type of scanning configured for the registry.
        """
        return pulumi.get(self, "scan_type")


class AwaitableGetRegistryScanningConfigurationResult(GetRegistryScanningConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegistryScanningConfigurationResult(
            registry_id=self.registry_id,
            rules=self.rules,
            scan_type=self.scan_type)


def get_registry_scanning_configuration(registry_id: Optional[builtins.str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegistryScanningConfigurationResult:
    """
    The scanning configuration for a private registry.


    :param builtins.str registry_id: The account ID of the destination registry.
    """
    __args__ = dict()
    __args__['registryId'] = registry_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ecr:getRegistryScanningConfiguration', __args__, opts=opts, typ=GetRegistryScanningConfigurationResult).value

    return AwaitableGetRegistryScanningConfigurationResult(
        registry_id=pulumi.get(__ret__, 'registry_id'),
        rules=pulumi.get(__ret__, 'rules'),
        scan_type=pulumi.get(__ret__, 'scan_type'))
def get_registry_scanning_configuration_output(registry_id: Optional[pulumi.Input[builtins.str]] = None,
                                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRegistryScanningConfigurationResult]:
    """
    The scanning configuration for a private registry.


    :param builtins.str registry_id: The account ID of the destination registry.
    """
    __args__ = dict()
    __args__['registryId'] = registry_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ecr:getRegistryScanningConfiguration', __args__, opts=opts, typ=GetRegistryScanningConfigurationResult)
    return __ret__.apply(lambda __response__: GetRegistryScanningConfigurationResult(
        registry_id=pulumi.get(__response__, 'registry_id'),
        rules=pulumi.get(__response__, 'rules'),
        scan_type=pulumi.get(__response__, 'scan_type')))
