# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'RegistryScanningConfigurationRepositoryFilterArgs',
    'RegistryScanningConfigurationRepositoryFilterArgsDict',
    'RegistryScanningConfigurationScanningRuleArgs',
    'RegistryScanningConfigurationScanningRuleArgsDict',
    'ReplicationConfigurationReplicationDestinationArgs',
    'ReplicationConfigurationReplicationDestinationArgsDict',
    'ReplicationConfigurationReplicationRuleArgs',
    'ReplicationConfigurationReplicationRuleArgsDict',
    'ReplicationConfigurationRepositoryFilterArgs',
    'ReplicationConfigurationRepositoryFilterArgsDict',
    'ReplicationConfigurationArgs',
    'ReplicationConfigurationArgsDict',
    'RepositoryCreationTemplateEncryptionConfigurationArgs',
    'RepositoryCreationTemplateEncryptionConfigurationArgsDict',
    'RepositoryCreationTemplateTagArgs',
    'RepositoryCreationTemplateTagArgsDict',
    'RepositoryEncryptionConfigurationArgs',
    'RepositoryEncryptionConfigurationArgsDict',
    'RepositoryImageScanningConfigurationArgs',
    'RepositoryImageScanningConfigurationArgsDict',
    'RepositoryLifecyclePolicyArgs',
    'RepositoryLifecyclePolicyArgsDict',
]

MYPY = False

if not MYPY:
    class RegistryScanningConfigurationRepositoryFilterArgsDict(TypedDict):
        """
        The filter settings used with image replication. Specifying a repository filter to a replication rule provides a method for controlling which repositories in a private registry are replicated. If no filters are added, the contents of all repositories are replicated.
        """
        filter: pulumi.Input[builtins.str]
        """
        The filter to use when scanning.
        """
        filter_type: pulumi.Input['RegistryScanningConfigurationFilterType']
        """
        The type associated with the filter.
        """
elif False:
    RegistryScanningConfigurationRepositoryFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RegistryScanningConfigurationRepositoryFilterArgs:
    def __init__(__self__, *,
                 filter: pulumi.Input[builtins.str],
                 filter_type: pulumi.Input['RegistryScanningConfigurationFilterType']):
        """
        The filter settings used with image replication. Specifying a repository filter to a replication rule provides a method for controlling which repositories in a private registry are replicated. If no filters are added, the contents of all repositories are replicated.
        :param pulumi.Input[builtins.str] filter: The filter to use when scanning.
        :param pulumi.Input['RegistryScanningConfigurationFilterType'] filter_type: The type associated with the filter.
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "filter_type", filter_type)

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Input[builtins.str]:
        """
        The filter to use when scanning.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> pulumi.Input['RegistryScanningConfigurationFilterType']:
        """
        The type associated with the filter.
        """
        return pulumi.get(self, "filter_type")

    @filter_type.setter
    def filter_type(self, value: pulumi.Input['RegistryScanningConfigurationFilterType']):
        pulumi.set(self, "filter_type", value)


if not MYPY:
    class RegistryScanningConfigurationScanningRuleArgsDict(TypedDict):
        """
        The scanning rules associated with the registry.
        """
        repository_filters: pulumi.Input[Sequence[pulumi.Input['RegistryScanningConfigurationRepositoryFilterArgsDict']]]
        """
        The details of a scanning repository filter. For more information on how to use filters, see [Using filters](https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-scanning.html#image-scanning-filters) in the *Amazon Elastic Container Registry User Guide*.
        """
        scan_frequency: pulumi.Input['RegistryScanningConfigurationScanFrequency']
        """
        The frequency that scans are performed at for a private registry. When the ``ENHANCED`` scan type is specified, the supported scan frequencies are ``CONTINUOUS_SCAN`` and ``SCAN_ON_PUSH``. When the ``BASIC`` scan type is specified, the ``SCAN_ON_PUSH`` scan frequency is supported. If scan on push is not specified, then the ``MANUAL`` scan frequency is set by default.
        """
elif False:
    RegistryScanningConfigurationScanningRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RegistryScanningConfigurationScanningRuleArgs:
    def __init__(__self__, *,
                 repository_filters: pulumi.Input[Sequence[pulumi.Input['RegistryScanningConfigurationRepositoryFilterArgs']]],
                 scan_frequency: pulumi.Input['RegistryScanningConfigurationScanFrequency']):
        """
        The scanning rules associated with the registry.
        :param pulumi.Input[Sequence[pulumi.Input['RegistryScanningConfigurationRepositoryFilterArgs']]] repository_filters: The details of a scanning repository filter. For more information on how to use filters, see [Using filters](https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-scanning.html#image-scanning-filters) in the *Amazon Elastic Container Registry User Guide*.
        :param pulumi.Input['RegistryScanningConfigurationScanFrequency'] scan_frequency: The frequency that scans are performed at for a private registry. When the ``ENHANCED`` scan type is specified, the supported scan frequencies are ``CONTINUOUS_SCAN`` and ``SCAN_ON_PUSH``. When the ``BASIC`` scan type is specified, the ``SCAN_ON_PUSH`` scan frequency is supported. If scan on push is not specified, then the ``MANUAL`` scan frequency is set by default.
        """
        pulumi.set(__self__, "repository_filters", repository_filters)
        pulumi.set(__self__, "scan_frequency", scan_frequency)

    @property
    @pulumi.getter(name="repositoryFilters")
    def repository_filters(self) -> pulumi.Input[Sequence[pulumi.Input['RegistryScanningConfigurationRepositoryFilterArgs']]]:
        """
        The details of a scanning repository filter. For more information on how to use filters, see [Using filters](https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-scanning.html#image-scanning-filters) in the *Amazon Elastic Container Registry User Guide*.
        """
        return pulumi.get(self, "repository_filters")

    @repository_filters.setter
    def repository_filters(self, value: pulumi.Input[Sequence[pulumi.Input['RegistryScanningConfigurationRepositoryFilterArgs']]]):
        pulumi.set(self, "repository_filters", value)

    @property
    @pulumi.getter(name="scanFrequency")
    def scan_frequency(self) -> pulumi.Input['RegistryScanningConfigurationScanFrequency']:
        """
        The frequency that scans are performed at for a private registry. When the ``ENHANCED`` scan type is specified, the supported scan frequencies are ``CONTINUOUS_SCAN`` and ``SCAN_ON_PUSH``. When the ``BASIC`` scan type is specified, the ``SCAN_ON_PUSH`` scan frequency is supported. If scan on push is not specified, then the ``MANUAL`` scan frequency is set by default.
        """
        return pulumi.get(self, "scan_frequency")

    @scan_frequency.setter
    def scan_frequency(self, value: pulumi.Input['RegistryScanningConfigurationScanFrequency']):
        pulumi.set(self, "scan_frequency", value)


if not MYPY:
    class ReplicationConfigurationReplicationDestinationArgsDict(TypedDict):
        """
        An array of objects representing the destination for a replication rule.
        """
        region: pulumi.Input[builtins.str]
        """
        The Region to replicate to.
        """
        registry_id: pulumi.Input[builtins.str]
        """
        The AWS account ID of the Amazon ECR private registry to replicate to. When configuring cross-Region replication within your own registry, specify your own account ID.
        """
elif False:
    ReplicationConfigurationReplicationDestinationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicationConfigurationReplicationDestinationArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[builtins.str],
                 registry_id: pulumi.Input[builtins.str]):
        """
        An array of objects representing the destination for a replication rule.
        :param pulumi.Input[builtins.str] region: The Region to replicate to.
        :param pulumi.Input[builtins.str] registry_id: The AWS account ID of the Amazon ECR private registry to replicate to. When configuring cross-Region replication within your own registry, specify your own account ID.
        """
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "registry_id", registry_id)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[builtins.str]:
        """
        The Region to replicate to.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> pulumi.Input[builtins.str]:
        """
        The AWS account ID of the Amazon ECR private registry to replicate to. When configuring cross-Region replication within your own registry, specify your own account ID.
        """
        return pulumi.get(self, "registry_id")

    @registry_id.setter
    def registry_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "registry_id", value)


if not MYPY:
    class ReplicationConfigurationReplicationRuleArgsDict(TypedDict):
        """
        An array of objects representing the replication destinations and repository filters for a replication configuration.
        """
        destinations: pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationDestinationArgsDict']]]
        """
        An array of objects representing the destination for a replication rule.
        """
        repository_filters: NotRequired[pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationRepositoryFilterArgsDict']]]]
        """
        An array of objects representing the filters for a replication rule. Specifying a repository filter for a replication rule provides a method for controlling which repositories in a private registry are replicated.
        """
elif False:
    ReplicationConfigurationReplicationRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicationConfigurationReplicationRuleArgs:
    def __init__(__self__, *,
                 destinations: pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationDestinationArgs']]],
                 repository_filters: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationRepositoryFilterArgs']]]] = None):
        """
        An array of objects representing the replication destinations and repository filters for a replication configuration.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationDestinationArgs']]] destinations: An array of objects representing the destination for a replication rule.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationRepositoryFilterArgs']]] repository_filters: An array of objects representing the filters for a replication rule. Specifying a repository filter for a replication rule provides a method for controlling which repositories in a private registry are replicated.
        """
        pulumi.set(__self__, "destinations", destinations)
        if repository_filters is not None:
            pulumi.set(__self__, "repository_filters", repository_filters)

    @property
    @pulumi.getter
    def destinations(self) -> pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationDestinationArgs']]]:
        """
        An array of objects representing the destination for a replication rule.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationDestinationArgs']]]):
        pulumi.set(self, "destinations", value)

    @property
    @pulumi.getter(name="repositoryFilters")
    def repository_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationRepositoryFilterArgs']]]]:
        """
        An array of objects representing the filters for a replication rule. Specifying a repository filter for a replication rule provides a method for controlling which repositories in a private registry are replicated.
        """
        return pulumi.get(self, "repository_filters")

    @repository_filters.setter
    def repository_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationRepositoryFilterArgs']]]]):
        pulumi.set(self, "repository_filters", value)


if not MYPY:
    class ReplicationConfigurationRepositoryFilterArgsDict(TypedDict):
        """
        The filter settings used with image replication. Specifying a repository filter to a replication rule provides a method for controlling which repositories in a private registry are replicated. If no filters are added, the contents of all repositories are replicated.
        """
        filter: pulumi.Input[builtins.str]
        """
        The repository filter details. When the ``PREFIX_MATCH`` filter type is specified, this value is required and should be the repository name prefix to configure replication for.
        """
        filter_type: pulumi.Input['ReplicationConfigurationFilterType']
        """
        The repository filter type. The only supported value is ``PREFIX_MATCH``, which is a repository name prefix specified with the ``filter`` parameter.
        """
elif False:
    ReplicationConfigurationRepositoryFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicationConfigurationRepositoryFilterArgs:
    def __init__(__self__, *,
                 filter: pulumi.Input[builtins.str],
                 filter_type: pulumi.Input['ReplicationConfigurationFilterType']):
        """
        The filter settings used with image replication. Specifying a repository filter to a replication rule provides a method for controlling which repositories in a private registry are replicated. If no filters are added, the contents of all repositories are replicated.
        :param pulumi.Input[builtins.str] filter: The repository filter details. When the ``PREFIX_MATCH`` filter type is specified, this value is required and should be the repository name prefix to configure replication for.
        :param pulumi.Input['ReplicationConfigurationFilterType'] filter_type: The repository filter type. The only supported value is ``PREFIX_MATCH``, which is a repository name prefix specified with the ``filter`` parameter.
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "filter_type", filter_type)

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Input[builtins.str]:
        """
        The repository filter details. When the ``PREFIX_MATCH`` filter type is specified, this value is required and should be the repository name prefix to configure replication for.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> pulumi.Input['ReplicationConfigurationFilterType']:
        """
        The repository filter type. The only supported value is ``PREFIX_MATCH``, which is a repository name prefix specified with the ``filter`` parameter.
        """
        return pulumi.get(self, "filter_type")

    @filter_type.setter
    def filter_type(self, value: pulumi.Input['ReplicationConfigurationFilterType']):
        pulumi.set(self, "filter_type", value)


if not MYPY:
    class ReplicationConfigurationArgsDict(TypedDict):
        """
        The replication configuration for a registry.
        """
        rules: pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationRuleArgsDict']]]
        """
        An array of objects representing the replication destinations and repository filters for a replication configuration.
        """
elif False:
    ReplicationConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicationConfigurationArgs:
    def __init__(__self__, *,
                 rules: pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationRuleArgs']]]):
        """
        The replication configuration for a registry.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationRuleArgs']]] rules: An array of objects representing the replication destinations and repository filters for a replication configuration.
        """
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationRuleArgs']]]:
        """
        An array of objects representing the replication destinations and repository filters for a replication configuration.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationRuleArgs']]]):
        pulumi.set(self, "rules", value)


if not MYPY:
    class RepositoryCreationTemplateEncryptionConfigurationArgsDict(TypedDict):
        """
        The encryption configuration for the repository. This determines how the contents of your repository are encrypted at rest.
         By default, when no encryption configuration is set or the ``AES256`` encryption type is used, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts your data at rest using an AES256 encryption algorithm. This does not require any action on your part.
         For more control over the encryption of the contents of your repository, you can use server-side encryption with KMSlong key stored in KMSlong (KMS) to encrypt your images. For more information, see [Amazon ECR encryption at rest](https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html) in the *Amazon Elastic Container Registry User Guide*.
        """
        encryption_type: pulumi.Input['RepositoryCreationTemplateEncryptionType']
        """
        The encryption type to use.
         If you use the ``KMS`` encryption type, the contents of the repository will be encrypted using server-side encryption with KMSlong key stored in KMS. When you use KMS to encrypt your data, you can either use the default AWS managed KMS key for Amazon ECR, or specify your own KMS key, which you already created.
         If you use the ``KMS_DSSE`` encryption type, the contents of the repository will be encrypted with two layers of encryption using server-side encryption with the KMS Management Service key stored in KMS. Similar to the ``KMS`` encryption type, you can either use the default AWS managed KMS key for Amazon ECR, or specify your own KMS key, which you've already created. 
         If you use the ``AES256`` encryption type, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts the images in the repository using an AES256 encryption algorithm.
         For more information, see [Amazon ECR encryption at rest](https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html) in the *Amazon Elastic Container Registry User Guide*.
        """
        kms_key: NotRequired[pulumi.Input[builtins.str]]
        """
        If you use the ``KMS`` encryption type, specify the KMS key to use for encryption. The alias, key ID, or full ARN of the KMS key can be specified. The key must exist in the same Region as the repository. If no key is specified, the default AWS managed KMS key for Amazon ECR will be used.
        """
elif False:
    RepositoryCreationTemplateEncryptionConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepositoryCreationTemplateEncryptionConfigurationArgs:
    def __init__(__self__, *,
                 encryption_type: pulumi.Input['RepositoryCreationTemplateEncryptionType'],
                 kms_key: Optional[pulumi.Input[builtins.str]] = None):
        """
        The encryption configuration for the repository. This determines how the contents of your repository are encrypted at rest.
         By default, when no encryption configuration is set or the ``AES256`` encryption type is used, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts your data at rest using an AES256 encryption algorithm. This does not require any action on your part.
         For more control over the encryption of the contents of your repository, you can use server-side encryption with KMSlong key stored in KMSlong (KMS) to encrypt your images. For more information, see [Amazon ECR encryption at rest](https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html) in the *Amazon Elastic Container Registry User Guide*.
        :param pulumi.Input['RepositoryCreationTemplateEncryptionType'] encryption_type: The encryption type to use.
                If you use the ``KMS`` encryption type, the contents of the repository will be encrypted using server-side encryption with KMSlong key stored in KMS. When you use KMS to encrypt your data, you can either use the default AWS managed KMS key for Amazon ECR, or specify your own KMS key, which you already created.
                If you use the ``KMS_DSSE`` encryption type, the contents of the repository will be encrypted with two layers of encryption using server-side encryption with the KMS Management Service key stored in KMS. Similar to the ``KMS`` encryption type, you can either use the default AWS managed KMS key for Amazon ECR, or specify your own KMS key, which you've already created. 
                If you use the ``AES256`` encryption type, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts the images in the repository using an AES256 encryption algorithm.
                For more information, see [Amazon ECR encryption at rest](https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html) in the *Amazon Elastic Container Registry User Guide*.
        :param pulumi.Input[builtins.str] kms_key: If you use the ``KMS`` encryption type, specify the KMS key to use for encryption. The alias, key ID, or full ARN of the KMS key can be specified. The key must exist in the same Region as the repository. If no key is specified, the default AWS managed KMS key for Amazon ECR will be used.
        """
        pulumi.set(__self__, "encryption_type", encryption_type)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> pulumi.Input['RepositoryCreationTemplateEncryptionType']:
        """
        The encryption type to use.
         If you use the ``KMS`` encryption type, the contents of the repository will be encrypted using server-side encryption with KMSlong key stored in KMS. When you use KMS to encrypt your data, you can either use the default AWS managed KMS key for Amazon ECR, or specify your own KMS key, which you already created.
         If you use the ``KMS_DSSE`` encryption type, the contents of the repository will be encrypted with two layers of encryption using server-side encryption with the KMS Management Service key stored in KMS. Similar to the ``KMS`` encryption type, you can either use the default AWS managed KMS key for Amazon ECR, or specify your own KMS key, which you've already created. 
         If you use the ``AES256`` encryption type, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts the images in the repository using an AES256 encryption algorithm.
         For more information, see [Amazon ECR encryption at rest](https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html) in the *Amazon Elastic Container Registry User Guide*.
        """
        return pulumi.get(self, "encryption_type")

    @encryption_type.setter
    def encryption_type(self, value: pulumi.Input['RepositoryCreationTemplateEncryptionType']):
        pulumi.set(self, "encryption_type", value)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If you use the ``KMS`` encryption type, specify the KMS key to use for encryption. The alias, key ID, or full ARN of the KMS key can be specified. The key must exist in the same Region as the repository. If no key is specified, the default AWS managed KMS key for Amazon ECR will be used.
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key", value)


if not MYPY:
    class RepositoryCreationTemplateTagArgsDict(TypedDict):
        """
        The metadata to apply to a resource to help you categorize and organize them. Each tag consists of a key and a value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
        """
        key: pulumi.Input[builtins.str]
        """
        One part of a key-value pair that make up a tag. A ``key`` is a general label that acts like a category for more specific tag values.
        """
        value: pulumi.Input[builtins.str]
        """
        A ``value`` acts as a descriptor within a tag category (key).
        """
elif False:
    RepositoryCreationTemplateTagArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepositoryCreationTemplateTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.str]):
        """
        The metadata to apply to a resource to help you categorize and organize them. Each tag consists of a key and a value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
        :param pulumi.Input[builtins.str] key: One part of a key-value pair that make up a tag. A ``key`` is a general label that acts like a category for more specific tag values.
        :param pulumi.Input[builtins.str] value: A ``value`` acts as a descriptor within a tag category (key).
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[builtins.str]:
        """
        One part of a key-value pair that make up a tag. A ``key`` is a general label that acts like a category for more specific tag values.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        A ``value`` acts as a descriptor within a tag category (key).
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class RepositoryEncryptionConfigurationArgsDict(TypedDict):
        """
        The encryption configuration for the repository. This determines how the contents of your repository are encrypted at rest.
         By default, when no encryption configuration is set or the ``AES256`` encryption type is used, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts your data at rest using an AES256 encryption algorithm. This does not require any action on your part.
         For more control over the encryption of the contents of your repository, you can use server-side encryption with KMSlong key stored in KMSlong (KMS) to encrypt your images. For more information, see [Amazon ECR encryption at rest](https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html) in the *Amazon Elastic Container Registry User Guide*.
        """
        encryption_type: pulumi.Input['RepositoryEncryptionType']
        """
        The encryption type to use.

        If you use the `KMS` encryption type, the contents of the repository will be encrypted using server-side encryption with AWS Key Management Service key stored in AWS KMS . When you use AWS KMS to encrypt your data, you can either use the default AWS managed AWS KMS key for Amazon ECR, or specify your own AWS KMS key, which you already created.

        If you use the `KMS_DSSE` encryption type, the contents of the repository will be encrypted with two layers of encryption using server-side encryption with the AWS KMS Management Service key stored in AWS KMS . Similar to the `KMS` encryption type, you can either use the default AWS managed AWS KMS key for Amazon ECR, or specify your own AWS KMS key, which you've already created.

        If you use the `AES256` encryption type, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts the images in the repository using an AES256 encryption algorithm.

        For more information, see [Amazon ECR encryption at rest](https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html) in the *Amazon Elastic Container Registry User Guide* .
        """
        kms_key: NotRequired[pulumi.Input[builtins.str]]
        """
        If you use the ``KMS`` encryption type, specify the KMS key to use for encryption. The alias, key ID, or full ARN of the KMS key can be specified. The key must exist in the same Region as the repository. If no key is specified, the default AWS managed KMS key for Amazon ECR will be used.
        """
elif False:
    RepositoryEncryptionConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepositoryEncryptionConfigurationArgs:
    def __init__(__self__, *,
                 encryption_type: pulumi.Input['RepositoryEncryptionType'],
                 kms_key: Optional[pulumi.Input[builtins.str]] = None):
        """
        The encryption configuration for the repository. This determines how the contents of your repository are encrypted at rest.
         By default, when no encryption configuration is set or the ``AES256`` encryption type is used, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts your data at rest using an AES256 encryption algorithm. This does not require any action on your part.
         For more control over the encryption of the contents of your repository, you can use server-side encryption with KMSlong key stored in KMSlong (KMS) to encrypt your images. For more information, see [Amazon ECR encryption at rest](https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html) in the *Amazon Elastic Container Registry User Guide*.
        :param pulumi.Input['RepositoryEncryptionType'] encryption_type: The encryption type to use.
               
               If you use the `KMS` encryption type, the contents of the repository will be encrypted using server-side encryption with AWS Key Management Service key stored in AWS KMS . When you use AWS KMS to encrypt your data, you can either use the default AWS managed AWS KMS key for Amazon ECR, or specify your own AWS KMS key, which you already created.
               
               If you use the `KMS_DSSE` encryption type, the contents of the repository will be encrypted with two layers of encryption using server-side encryption with the AWS KMS Management Service key stored in AWS KMS . Similar to the `KMS` encryption type, you can either use the default AWS managed AWS KMS key for Amazon ECR, or specify your own AWS KMS key, which you've already created.
               
               If you use the `AES256` encryption type, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts the images in the repository using an AES256 encryption algorithm.
               
               For more information, see [Amazon ECR encryption at rest](https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html) in the *Amazon Elastic Container Registry User Guide* .
        :param pulumi.Input[builtins.str] kms_key: If you use the ``KMS`` encryption type, specify the KMS key to use for encryption. The alias, key ID, or full ARN of the KMS key can be specified. The key must exist in the same Region as the repository. If no key is specified, the default AWS managed KMS key for Amazon ECR will be used.
        """
        pulumi.set(__self__, "encryption_type", encryption_type)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> pulumi.Input['RepositoryEncryptionType']:
        """
        The encryption type to use.

        If you use the `KMS` encryption type, the contents of the repository will be encrypted using server-side encryption with AWS Key Management Service key stored in AWS KMS . When you use AWS KMS to encrypt your data, you can either use the default AWS managed AWS KMS key for Amazon ECR, or specify your own AWS KMS key, which you already created.

        If you use the `KMS_DSSE` encryption type, the contents of the repository will be encrypted with two layers of encryption using server-side encryption with the AWS KMS Management Service key stored in AWS KMS . Similar to the `KMS` encryption type, you can either use the default AWS managed AWS KMS key for Amazon ECR, or specify your own AWS KMS key, which you've already created.

        If you use the `AES256` encryption type, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts the images in the repository using an AES256 encryption algorithm.

        For more information, see [Amazon ECR encryption at rest](https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html) in the *Amazon Elastic Container Registry User Guide* .
        """
        return pulumi.get(self, "encryption_type")

    @encryption_type.setter
    def encryption_type(self, value: pulumi.Input['RepositoryEncryptionType']):
        pulumi.set(self, "encryption_type", value)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If you use the ``KMS`` encryption type, specify the KMS key to use for encryption. The alias, key ID, or full ARN of the KMS key can be specified. The key must exist in the same Region as the repository. If no key is specified, the default AWS managed KMS key for Amazon ECR will be used.
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key", value)


if not MYPY:
    class RepositoryImageScanningConfigurationArgsDict(TypedDict):
        """
        The image scanning configuration for a repository.
        """
        scan_on_push: NotRequired[pulumi.Input[builtins.bool]]
        """
        The setting that determines whether images are scanned after being pushed to a repository. If set to ``true``, images will be scanned after being pushed. If this parameter is not specified, it will default to ``false`` and images will not be scanned unless a scan is manually started.
        """
elif False:
    RepositoryImageScanningConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepositoryImageScanningConfigurationArgs:
    def __init__(__self__, *,
                 scan_on_push: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The image scanning configuration for a repository.
        :param pulumi.Input[builtins.bool] scan_on_push: The setting that determines whether images are scanned after being pushed to a repository. If set to ``true``, images will be scanned after being pushed. If this parameter is not specified, it will default to ``false`` and images will not be scanned unless a scan is manually started.
        """
        if scan_on_push is not None:
            pulumi.set(__self__, "scan_on_push", scan_on_push)

    @property
    @pulumi.getter(name="scanOnPush")
    def scan_on_push(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The setting that determines whether images are scanned after being pushed to a repository. If set to ``true``, images will be scanned after being pushed. If this parameter is not specified, it will default to ``false`` and images will not be scanned unless a scan is manually started.
        """
        return pulumi.get(self, "scan_on_push")

    @scan_on_push.setter
    def scan_on_push(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "scan_on_push", value)


if not MYPY:
    class RepositoryLifecyclePolicyArgsDict(TypedDict):
        """
        The ``LifecyclePolicy`` property type specifies a lifecycle policy. For information about lifecycle policy syntax, see [Lifecycle policy template](https://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html) in the *Amazon ECR User Guide*.
        """
        lifecycle_policy_text: NotRequired[pulumi.Input[builtins.str]]
        """
        The JSON repository policy text to apply to the repository.
        """
        registry_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The AWS account ID associated with the registry that contains the repository. If you do
         not specify a registry, the default registry is assumed.
        """
elif False:
    RepositoryLifecyclePolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepositoryLifecyclePolicyArgs:
    def __init__(__self__, *,
                 lifecycle_policy_text: Optional[pulumi.Input[builtins.str]] = None,
                 registry_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The ``LifecyclePolicy`` property type specifies a lifecycle policy. For information about lifecycle policy syntax, see [Lifecycle policy template](https://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html) in the *Amazon ECR User Guide*.
        :param pulumi.Input[builtins.str] lifecycle_policy_text: The JSON repository policy text to apply to the repository.
        :param pulumi.Input[builtins.str] registry_id: The AWS account ID associated with the registry that contains the repository. If you do
                not specify a registry, the default registry is assumed.
        """
        if lifecycle_policy_text is not None:
            pulumi.set(__self__, "lifecycle_policy_text", lifecycle_policy_text)
        if registry_id is not None:
            pulumi.set(__self__, "registry_id", registry_id)

    @property
    @pulumi.getter(name="lifecyclePolicyText")
    def lifecycle_policy_text(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The JSON repository policy text to apply to the repository.
        """
        return pulumi.get(self, "lifecycle_policy_text")

    @lifecycle_policy_text.setter
    def lifecycle_policy_text(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_policy_text", value)

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS account ID associated with the registry that contains the repository. If you do
         not specify a registry, the default registry is assumed.
        """
        return pulumi.get(self, "registry_id")

    @registry_id.setter
    def registry_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "registry_id", value)


