# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VpcGatewayAttachmentArgs', 'VpcGatewayAttachment']

@pulumi.input_type
class VpcGatewayAttachmentArgs:
    def __init__(__self__, *,
                 vpc_id: pulumi.Input[builtins.str],
                 internet_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpn_gateway_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a VpcGatewayAttachment resource.
        :param pulumi.Input[builtins.str] vpc_id: The ID of the VPC.
        :param pulumi.Input[builtins.str] internet_gateway_id: The ID of the internet gateway. You must specify either InternetGatewayId or VpnGatewayId, but not both.
        :param pulumi.Input[builtins.str] vpn_gateway_id: The ID of the virtual private gateway. You must specify either InternetGatewayId or VpnGatewayId, but not both.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        if internet_gateway_id is not None:
            pulumi.set(__self__, "internet_gateway_id", internet_gateway_id)
        if vpn_gateway_id is not None:
            pulumi.set(__self__, "vpn_gateway_id", vpn_gateway_id)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="internetGatewayId")
    def internet_gateway_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the internet gateway. You must specify either InternetGatewayId or VpnGatewayId, but not both.
        """
        return pulumi.get(self, "internet_gateway_id")

    @internet_gateway_id.setter
    def internet_gateway_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "internet_gateway_id", value)

    @property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the virtual private gateway. You must specify either InternetGatewayId or VpnGatewayId, but not both.
        """
        return pulumi.get(self, "vpn_gateway_id")

    @vpn_gateway_id.setter
    def vpn_gateway_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpn_gateway_id", value)


@pulumi.type_token("aws-native:ec2:VpcGatewayAttachment")
class VpcGatewayAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 internet_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpn_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::EC2::VPCGatewayAttachment

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] internet_gateway_id: The ID of the internet gateway. You must specify either InternetGatewayId or VpnGatewayId, but not both.
        :param pulumi.Input[builtins.str] vpc_id: The ID of the VPC.
        :param pulumi.Input[builtins.str] vpn_gateway_id: The ID of the virtual private gateway. You must specify either InternetGatewayId or VpnGatewayId, but not both.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcGatewayAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::EC2::VPCGatewayAttachment

        :param str resource_name: The name of the resource.
        :param VpcGatewayAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcGatewayAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 internet_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpn_gateway_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcGatewayAttachmentArgs.__new__(VpcGatewayAttachmentArgs)

            __props__.__dict__["internet_gateway_id"] = internet_gateway_id
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vpn_gateway_id"] = vpn_gateway_id
            __props__.__dict__["attachment_type"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["vpcId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(VpcGatewayAttachment, __self__).__init__(
            'aws-native:ec2:VpcGatewayAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'VpcGatewayAttachment':
        """
        Get an existing VpcGatewayAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = VpcGatewayAttachmentArgs.__new__(VpcGatewayAttachmentArgs)

        __props__.__dict__["attachment_type"] = None
        __props__.__dict__["internet_gateway_id"] = None
        __props__.__dict__["vpc_id"] = None
        __props__.__dict__["vpn_gateway_id"] = None
        return VpcGatewayAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="attachmentType")
    def attachment_type(self) -> pulumi.Output[builtins.str]:
        """
        Used to identify if this resource is an Internet Gateway or Vpn Gateway Attachment 
        """
        return pulumi.get(self, "attachment_type")

    @property
    @pulumi.getter(name="internetGatewayId")
    def internet_gateway_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the internet gateway. You must specify either InternetGatewayId or VpnGatewayId, but not both.
        """
        return pulumi.get(self, "internet_gateway_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the virtual private gateway. You must specify either InternetGatewayId or VpnGatewayId, but not both.
        """
        return pulumi.get(self, "vpn_gateway_id")

