# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = ['VpcEndpointServiceArgs', 'VpcEndpointService']

@pulumi.input_type
class VpcEndpointServiceArgs:
    def __init__(__self__, *,
                 acceptance_required: Optional[pulumi.Input[builtins.bool]] = None,
                 contributor_insights_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 gateway_load_balancer_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 network_load_balancer_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 payer_responsibility: Optional[pulumi.Input[builtins.str]] = None,
                 supported_ip_address_types: Optional[pulumi.Input[Sequence[pulumi.Input['VpcEndpointServiceIpAddressType']]]] = None,
                 supported_regions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a VpcEndpointService resource.
        :param pulumi.Input[builtins.bool] acceptance_required: Indicates whether requests from service consumers to create an endpoint to your service must be accepted.
        :param pulumi.Input[builtins.bool] contributor_insights_enabled: Indicates whether to enable the built-in Contributor Insights rules provided by AWS PrivateLink .
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] gateway_load_balancer_arns: The Amazon Resource Names (ARNs) of the Gateway Load Balancers.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] network_load_balancer_arns: The Amazon Resource Names (ARNs) of the Network Load Balancers.
        :param pulumi.Input[builtins.str] payer_responsibility: The entity that is responsible for the endpoint costs. The default is the endpoint owner. If you set the payer responsibility to the service owner, you cannot set it back to the endpoint owner.
        :param pulumi.Input[Sequence[pulumi.Input['VpcEndpointServiceIpAddressType']]] supported_ip_address_types: Specify which Ip Address types are supported for VPC endpoint service.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] supported_regions: The Regions from which service consumers can access the service.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags to add to the VPC endpoint service.
        """
        if acceptance_required is not None:
            pulumi.set(__self__, "acceptance_required", acceptance_required)
        if contributor_insights_enabled is not None:
            pulumi.set(__self__, "contributor_insights_enabled", contributor_insights_enabled)
        if gateway_load_balancer_arns is not None:
            pulumi.set(__self__, "gateway_load_balancer_arns", gateway_load_balancer_arns)
        if network_load_balancer_arns is not None:
            pulumi.set(__self__, "network_load_balancer_arns", network_load_balancer_arns)
        if payer_responsibility is not None:
            pulumi.set(__self__, "payer_responsibility", payer_responsibility)
        if supported_ip_address_types is not None:
            pulumi.set(__self__, "supported_ip_address_types", supported_ip_address_types)
        if supported_regions is not None:
            pulumi.set(__self__, "supported_regions", supported_regions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="acceptanceRequired")
    def acceptance_required(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether requests from service consumers to create an endpoint to your service must be accepted.
        """
        return pulumi.get(self, "acceptance_required")

    @acceptance_required.setter
    def acceptance_required(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "acceptance_required", value)

    @property
    @pulumi.getter(name="contributorInsightsEnabled")
    def contributor_insights_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether to enable the built-in Contributor Insights rules provided by AWS PrivateLink .
        """
        return pulumi.get(self, "contributor_insights_enabled")

    @contributor_insights_enabled.setter
    def contributor_insights_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "contributor_insights_enabled", value)

    @property
    @pulumi.getter(name="gatewayLoadBalancerArns")
    def gateway_load_balancer_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The Amazon Resource Names (ARNs) of the Gateway Load Balancers.
        """
        return pulumi.get(self, "gateway_load_balancer_arns")

    @gateway_load_balancer_arns.setter
    def gateway_load_balancer_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "gateway_load_balancer_arns", value)

    @property
    @pulumi.getter(name="networkLoadBalancerArns")
    def network_load_balancer_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The Amazon Resource Names (ARNs) of the Network Load Balancers.
        """
        return pulumi.get(self, "network_load_balancer_arns")

    @network_load_balancer_arns.setter
    def network_load_balancer_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "network_load_balancer_arns", value)

    @property
    @pulumi.getter(name="payerResponsibility")
    def payer_responsibility(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The entity that is responsible for the endpoint costs. The default is the endpoint owner. If you set the payer responsibility to the service owner, you cannot set it back to the endpoint owner.
        """
        return pulumi.get(self, "payer_responsibility")

    @payer_responsibility.setter
    def payer_responsibility(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "payer_responsibility", value)

    @property
    @pulumi.getter(name="supportedIpAddressTypes")
    def supported_ip_address_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpcEndpointServiceIpAddressType']]]]:
        """
        Specify which Ip Address types are supported for VPC endpoint service.
        """
        return pulumi.get(self, "supported_ip_address_types")

    @supported_ip_address_types.setter
    def supported_ip_address_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpcEndpointServiceIpAddressType']]]]):
        pulumi.set(self, "supported_ip_address_types", value)

    @property
    @pulumi.getter(name="supportedRegions")
    def supported_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The Regions from which service consumers can access the service.
        """
        return pulumi.get(self, "supported_regions")

    @supported_regions.setter
    def supported_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "supported_regions", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags to add to the VPC endpoint service.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:ec2:VpcEndpointService")
class VpcEndpointService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acceptance_required: Optional[pulumi.Input[builtins.bool]] = None,
                 contributor_insights_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 gateway_load_balancer_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 network_load_balancer_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 payer_responsibility: Optional[pulumi.Input[builtins.str]] = None,
                 supported_ip_address_types: Optional[pulumi.Input[Sequence[pulumi.Input['VpcEndpointServiceIpAddressType']]]] = None,
                 supported_regions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::EC2::VPCEndpointService

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] acceptance_required: Indicates whether requests from service consumers to create an endpoint to your service must be accepted.
        :param pulumi.Input[builtins.bool] contributor_insights_enabled: Indicates whether to enable the built-in Contributor Insights rules provided by AWS PrivateLink .
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] gateway_load_balancer_arns: The Amazon Resource Names (ARNs) of the Gateway Load Balancers.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] network_load_balancer_arns: The Amazon Resource Names (ARNs) of the Network Load Balancers.
        :param pulumi.Input[builtins.str] payer_responsibility: The entity that is responsible for the endpoint costs. The default is the endpoint owner. If you set the payer responsibility to the service owner, you cannot set it back to the endpoint owner.
        :param pulumi.Input[Sequence[pulumi.Input['VpcEndpointServiceIpAddressType']]] supported_ip_address_types: Specify which Ip Address types are supported for VPC endpoint service.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] supported_regions: The Regions from which service consumers can access the service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags to add to the VPC endpoint service.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[VpcEndpointServiceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::EC2::VPCEndpointService

        :param str resource_name: The name of the resource.
        :param VpcEndpointServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcEndpointServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acceptance_required: Optional[pulumi.Input[builtins.bool]] = None,
                 contributor_insights_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 gateway_load_balancer_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 network_load_balancer_arns: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 payer_responsibility: Optional[pulumi.Input[builtins.str]] = None,
                 supported_ip_address_types: Optional[pulumi.Input[Sequence[pulumi.Input['VpcEndpointServiceIpAddressType']]]] = None,
                 supported_regions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcEndpointServiceArgs.__new__(VpcEndpointServiceArgs)

            __props__.__dict__["acceptance_required"] = acceptance_required
            __props__.__dict__["contributor_insights_enabled"] = contributor_insights_enabled
            __props__.__dict__["gateway_load_balancer_arns"] = gateway_load_balancer_arns
            __props__.__dict__["network_load_balancer_arns"] = network_load_balancer_arns
            __props__.__dict__["payer_responsibility"] = payer_responsibility
            __props__.__dict__["supported_ip_address_types"] = supported_ip_address_types
            __props__.__dict__["supported_regions"] = supported_regions
            __props__.__dict__["tags"] = tags
            __props__.__dict__["service_id"] = None
        super(VpcEndpointService, __self__).__init__(
            'aws-native:ec2:VpcEndpointService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'VpcEndpointService':
        """
        Get an existing VpcEndpointService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = VpcEndpointServiceArgs.__new__(VpcEndpointServiceArgs)

        __props__.__dict__["acceptance_required"] = None
        __props__.__dict__["contributor_insights_enabled"] = None
        __props__.__dict__["gateway_load_balancer_arns"] = None
        __props__.__dict__["network_load_balancer_arns"] = None
        __props__.__dict__["payer_responsibility"] = None
        __props__.__dict__["service_id"] = None
        __props__.__dict__["supported_ip_address_types"] = None
        __props__.__dict__["supported_regions"] = None
        __props__.__dict__["tags"] = None
        return VpcEndpointService(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="acceptanceRequired")
    def acceptance_required(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether requests from service consumers to create an endpoint to your service must be accepted.
        """
        return pulumi.get(self, "acceptance_required")

    @property
    @pulumi.getter(name="contributorInsightsEnabled")
    def contributor_insights_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether to enable the built-in Contributor Insights rules provided by AWS PrivateLink .
        """
        return pulumi.get(self, "contributor_insights_enabled")

    @property
    @pulumi.getter(name="gatewayLoadBalancerArns")
    def gateway_load_balancer_arns(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The Amazon Resource Names (ARNs) of the Gateway Load Balancers.
        """
        return pulumi.get(self, "gateway_load_balancer_arns")

    @property
    @pulumi.getter(name="networkLoadBalancerArns")
    def network_load_balancer_arns(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The Amazon Resource Names (ARNs) of the Network Load Balancers.
        """
        return pulumi.get(self, "network_load_balancer_arns")

    @property
    @pulumi.getter(name="payerResponsibility")
    def payer_responsibility(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The entity that is responsible for the endpoint costs. The default is the endpoint owner. If you set the payer responsibility to the service owner, you cannot set it back to the endpoint owner.
        """
        return pulumi.get(self, "payer_responsibility")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the endpoint service.
        """
        return pulumi.get(self, "service_id")

    @property
    @pulumi.getter(name="supportedIpAddressTypes")
    def supported_ip_address_types(self) -> pulumi.Output[Optional[Sequence['VpcEndpointServiceIpAddressType']]]:
        """
        Specify which Ip Address types are supported for VPC endpoint service.
        """
        return pulumi.get(self, "supported_ip_address_types")

    @property
    @pulumi.getter(name="supportedRegions")
    def supported_regions(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The Regions from which service consumers can access the service.
        """
        return pulumi.get(self, "supported_regions")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags to add to the VPC endpoint service.
        """
        return pulumi.get(self, "tags")

