# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['VpcEndpointArgs', 'VpcEndpoint']

@pulumi.input_type
class VpcEndpointArgs:
    def __init__(__self__, *,
                 vpc_id: pulumi.Input[builtins.str],
                 dns_options: Optional[pulumi.Input['VpcEndpointDnsOptionsSpecificationArgs']] = None,
                 ip_address_type: Optional[pulumi.Input['VpcEndpointIpAddressType']] = None,
                 policy_document: Optional[Any] = None,
                 private_dns_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_configuration_arn: Optional[pulumi.Input[builtins.str]] = None,
                 route_table_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_network_arn: Optional[pulumi.Input[builtins.str]] = None,
                 service_region: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 vpc_endpoint_type: Optional[pulumi.Input['VpcEndpointType']] = None):
        """
        The set of arguments for constructing a VpcEndpoint resource.
        :param pulumi.Input[builtins.str] vpc_id: The ID of the VPC.
        :param pulumi.Input['VpcEndpointDnsOptionsSpecificationArgs'] dns_options: Describes the DNS options for an endpoint.
        :param pulumi.Input['VpcEndpointIpAddressType'] ip_address_type: The supported IP address types.
        :param Any policy_document: An endpoint policy, which controls access to the service from the VPC. The default endpoint policy allows full access to the service. Endpoint policies are supported only for gateway and interface endpoints.
                For CloudFormation templates in YAML, you can provide the policy in JSON or YAML format. For example, if you have a JSON policy, you can convert it to YAML before including it in the YAML template, and CFNlong converts the policy to JSON format before calling the API actions for privatelink. Alternatively, you can include the JSON directly in the YAML, as shown in the following ``Properties`` section:
                ``Properties: VpcEndpointType: 'Interface' ServiceName: !Sub 'com.amazonaws.${AWS::Region}.logs' PolicyDocument: '{ "Version":"2012-10-17", "Statement": [{ "Effect":"Allow", "Principal":"*", "Action":["logs:Describe*","logs:Get*","logs:List*","logs:FilterLogEvents"], "Resource":"*" }] }'``
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::EC2::VPCEndpoint` for more information about the expected schema for this property.
        :param pulumi.Input[builtins.bool] private_dns_enabled: Indicate whether to associate a private hosted zone with the specified VPC. The private hosted zone contains a record set for the default public DNS name for the service for the Region (for example, ``kinesis.us-east-1.amazonaws.com``), which resolves to the private IP addresses of the endpoint network interfaces in the VPC. This enables you to make requests to the default public DNS name for the service instead of the public DNS names that are automatically generated by the VPC endpoint service.
                To use a private hosted zone, you must set the following VPC attributes to ``true``: ``enableDnsHostnames`` and ``enableDnsSupport``.
                This property is supported only for interface endpoints.
                Default: ``false``
        :param pulumi.Input[builtins.str] resource_configuration_arn: The Amazon Resource Name (ARN) of the resource configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] route_table_ids: The IDs of the route tables. Routing is supported only for gateway endpoints.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_ids: The IDs of the security groups to associate with the endpoint network interfaces. If this parameter is not specified, we use the default security group for the VPC. Security groups are supported only for interface endpoints.
        :param pulumi.Input[builtins.str] service_name: The name of the endpoint service.
        :param pulumi.Input[builtins.str] service_network_arn: The Amazon Resource Name (ARN) of the service network.
        :param pulumi.Input[builtins.str] service_region: Describes a Region.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: The IDs of the subnets in which to create endpoint network interfaces. You must specify this property for an interface endpoint or a Gateway Load Balancer endpoint. You can't specify this property for a gateway endpoint. For a Gateway Load Balancer endpoint, you can specify only one subnet.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags to associate with the endpoint.
        :param pulumi.Input['VpcEndpointType'] vpc_endpoint_type: The type of endpoint.
                Default: Gateway
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        if dns_options is not None:
            pulumi.set(__self__, "dns_options", dns_options)
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if policy_document is not None:
            pulumi.set(__self__, "policy_document", policy_document)
        if private_dns_enabled is not None:
            pulumi.set(__self__, "private_dns_enabled", private_dns_enabled)
        if resource_configuration_arn is not None:
            pulumi.set(__self__, "resource_configuration_arn", resource_configuration_arn)
        if route_table_ids is not None:
            pulumi.set(__self__, "route_table_ids", route_table_ids)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if service_network_arn is not None:
            pulumi.set(__self__, "service_network_arn", service_network_arn)
        if service_region is not None:
            pulumi.set(__self__, "service_region", service_region)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_endpoint_type is not None:
            pulumi.set(__self__, "vpc_endpoint_type", vpc_endpoint_type)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="dnsOptions")
    def dns_options(self) -> Optional[pulumi.Input['VpcEndpointDnsOptionsSpecificationArgs']]:
        """
        Describes the DNS options for an endpoint.
        """
        return pulumi.get(self, "dns_options")

    @dns_options.setter
    def dns_options(self, value: Optional[pulumi.Input['VpcEndpointDnsOptionsSpecificationArgs']]):
        pulumi.set(self, "dns_options", value)

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[pulumi.Input['VpcEndpointIpAddressType']]:
        """
        The supported IP address types.
        """
        return pulumi.get(self, "ip_address_type")

    @ip_address_type.setter
    def ip_address_type(self, value: Optional[pulumi.Input['VpcEndpointIpAddressType']]):
        pulumi.set(self, "ip_address_type", value)

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Optional[Any]:
        """
        An endpoint policy, which controls access to the service from the VPC. The default endpoint policy allows full access to the service. Endpoint policies are supported only for gateway and interface endpoints.
         For CloudFormation templates in YAML, you can provide the policy in JSON or YAML format. For example, if you have a JSON policy, you can convert it to YAML before including it in the YAML template, and CFNlong converts the policy to JSON format before calling the API actions for privatelink. Alternatively, you can include the JSON directly in the YAML, as shown in the following ``Properties`` section:
         ``Properties: VpcEndpointType: 'Interface' ServiceName: !Sub 'com.amazonaws.${AWS::Region}.logs' PolicyDocument: '{ "Version":"2012-10-17", "Statement": [{ "Effect":"Allow", "Principal":"*", "Action":["logs:Describe*","logs:Get*","logs:List*","logs:FilterLogEvents"], "Resource":"*" }] }'``

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::EC2::VPCEndpoint` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "policy_document")

    @policy_document.setter
    def policy_document(self, value: Optional[Any]):
        pulumi.set(self, "policy_document", value)

    @property
    @pulumi.getter(name="privateDnsEnabled")
    def private_dns_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicate whether to associate a private hosted zone with the specified VPC. The private hosted zone contains a record set for the default public DNS name for the service for the Region (for example, ``kinesis.us-east-1.amazonaws.com``), which resolves to the private IP addresses of the endpoint network interfaces in the VPC. This enables you to make requests to the default public DNS name for the service instead of the public DNS names that are automatically generated by the VPC endpoint service.
         To use a private hosted zone, you must set the following VPC attributes to ``true``: ``enableDnsHostnames`` and ``enableDnsSupport``.
         This property is supported only for interface endpoints.
         Default: ``false``
        """
        return pulumi.get(self, "private_dns_enabled")

    @private_dns_enabled.setter
    def private_dns_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "private_dns_enabled", value)

    @property
    @pulumi.getter(name="resourceConfigurationArn")
    def resource_configuration_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the resource configuration.
        """
        return pulumi.get(self, "resource_configuration_arn")

    @resource_configuration_arn.setter
    def resource_configuration_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_configuration_arn", value)

    @property
    @pulumi.getter(name="routeTableIds")
    def route_table_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The IDs of the route tables. Routing is supported only for gateway endpoints.
        """
        return pulumi.get(self, "route_table_ids")

    @route_table_ids.setter
    def route_table_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "route_table_ids", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The IDs of the security groups to associate with the endpoint network interfaces. If this parameter is not specified, we use the default security group for the VPC. Security groups are supported only for interface endpoints.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the endpoint service.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="serviceNetworkArn")
    def service_network_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the service network.
        """
        return pulumi.get(self, "service_network_arn")

    @service_network_arn.setter
    def service_network_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_network_arn", value)

    @property
    @pulumi.getter(name="serviceRegion")
    def service_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Describes a Region.
        """
        return pulumi.get(self, "service_region")

    @service_region.setter
    def service_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_region", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The IDs of the subnets in which to create endpoint network interfaces. You must specify this property for an interface endpoint or a Gateway Load Balancer endpoint. You can't specify this property for a gateway endpoint. For a Gateway Load Balancer endpoint, you can specify only one subnet.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags to associate with the endpoint.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcEndpointType")
    def vpc_endpoint_type(self) -> Optional[pulumi.Input['VpcEndpointType']]:
        """
        The type of endpoint.
         Default: Gateway
        """
        return pulumi.get(self, "vpc_endpoint_type")

    @vpc_endpoint_type.setter
    def vpc_endpoint_type(self, value: Optional[pulumi.Input['VpcEndpointType']]):
        pulumi.set(self, "vpc_endpoint_type", value)


@pulumi.type_token("aws-native:ec2:VpcEndpoint")
class VpcEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dns_options: Optional[pulumi.Input[Union['VpcEndpointDnsOptionsSpecificationArgs', 'VpcEndpointDnsOptionsSpecificationArgsDict']]] = None,
                 ip_address_type: Optional[pulumi.Input['VpcEndpointIpAddressType']] = None,
                 policy_document: Optional[Any] = None,
                 private_dns_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_configuration_arn: Optional[pulumi.Input[builtins.str]] = None,
                 route_table_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_network_arn: Optional[pulumi.Input[builtins.str]] = None,
                 service_region: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 vpc_endpoint_type: Optional[pulumi.Input['VpcEndpointType']] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Specifies a VPC endpoint. A VPC endpoint provides a private connection between your VPC and an endpoint service. You can use an endpoint service provided by AWS , an AWS Marketplace Partner, or another AWS accounts in your organization. For more information, see the [AWS PrivateLink User Guide](https://docs.aws.amazon.com/vpc/latest/privatelink/) .

        An endpoint of type `Interface` establishes connections between the subnets in your VPC and an AWS service , your own service, or a service hosted by another AWS account . With an interface VPC endpoint, you specify the subnets in which to create the endpoint and the security groups to associate with the endpoint network interfaces.

        An endpoint of type `gateway` serves as a target for a route in your route table for traffic destined for Amazon S3 or DynamoDB . You can specify an endpoint policy for the endpoint, which controls access to the service from your VPC. You can also specify the VPC route tables that use the endpoint. For more information about connectivity to Amazon S3 , see [Why can't I connect to an S3 bucket using a gateway VPC endpoint?](https://docs.aws.amazon.com/premiumsupport/knowledge-center/connect-s3-vpc-endpoint)

        An endpoint of type `GatewayLoadBalancer` provides private connectivity between your VPC and virtual appliances from a service provider.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['VpcEndpointDnsOptionsSpecificationArgs', 'VpcEndpointDnsOptionsSpecificationArgsDict']] dns_options: Describes the DNS options for an endpoint.
        :param pulumi.Input['VpcEndpointIpAddressType'] ip_address_type: The supported IP address types.
        :param Any policy_document: An endpoint policy, which controls access to the service from the VPC. The default endpoint policy allows full access to the service. Endpoint policies are supported only for gateway and interface endpoints.
                For CloudFormation templates in YAML, you can provide the policy in JSON or YAML format. For example, if you have a JSON policy, you can convert it to YAML before including it in the YAML template, and CFNlong converts the policy to JSON format before calling the API actions for privatelink. Alternatively, you can include the JSON directly in the YAML, as shown in the following ``Properties`` section:
                ``Properties: VpcEndpointType: 'Interface' ServiceName: !Sub 'com.amazonaws.${AWS::Region}.logs' PolicyDocument: '{ "Version":"2012-10-17", "Statement": [{ "Effect":"Allow", "Principal":"*", "Action":["logs:Describe*","logs:Get*","logs:List*","logs:FilterLogEvents"], "Resource":"*" }] }'``
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::EC2::VPCEndpoint` for more information about the expected schema for this property.
        :param pulumi.Input[builtins.bool] private_dns_enabled: Indicate whether to associate a private hosted zone with the specified VPC. The private hosted zone contains a record set for the default public DNS name for the service for the Region (for example, ``kinesis.us-east-1.amazonaws.com``), which resolves to the private IP addresses of the endpoint network interfaces in the VPC. This enables you to make requests to the default public DNS name for the service instead of the public DNS names that are automatically generated by the VPC endpoint service.
                To use a private hosted zone, you must set the following VPC attributes to ``true``: ``enableDnsHostnames`` and ``enableDnsSupport``.
                This property is supported only for interface endpoints.
                Default: ``false``
        :param pulumi.Input[builtins.str] resource_configuration_arn: The Amazon Resource Name (ARN) of the resource configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] route_table_ids: The IDs of the route tables. Routing is supported only for gateway endpoints.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_ids: The IDs of the security groups to associate with the endpoint network interfaces. If this parameter is not specified, we use the default security group for the VPC. Security groups are supported only for interface endpoints.
        :param pulumi.Input[builtins.str] service_name: The name of the endpoint service.
        :param pulumi.Input[builtins.str] service_network_arn: The Amazon Resource Name (ARN) of the service network.
        :param pulumi.Input[builtins.str] service_region: Describes a Region.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: The IDs of the subnets in which to create endpoint network interfaces. You must specify this property for an interface endpoint or a Gateway Load Balancer endpoint. You can't specify this property for a gateway endpoint. For a Gateway Load Balancer endpoint, you can specify only one subnet.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags to associate with the endpoint.
        :param pulumi.Input['VpcEndpointType'] vpc_endpoint_type: The type of endpoint.
                Default: Gateway
        :param pulumi.Input[builtins.str] vpc_id: The ID of the VPC.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Specifies a VPC endpoint. A VPC endpoint provides a private connection between your VPC and an endpoint service. You can use an endpoint service provided by AWS , an AWS Marketplace Partner, or another AWS accounts in your organization. For more information, see the [AWS PrivateLink User Guide](https://docs.aws.amazon.com/vpc/latest/privatelink/) .

        An endpoint of type `Interface` establishes connections between the subnets in your VPC and an AWS service , your own service, or a service hosted by another AWS account . With an interface VPC endpoint, you specify the subnets in which to create the endpoint and the security groups to associate with the endpoint network interfaces.

        An endpoint of type `gateway` serves as a target for a route in your route table for traffic destined for Amazon S3 or DynamoDB . You can specify an endpoint policy for the endpoint, which controls access to the service from your VPC. You can also specify the VPC route tables that use the endpoint. For more information about connectivity to Amazon S3 , see [Why can't I connect to an S3 bucket using a gateway VPC endpoint?](https://docs.aws.amazon.com/premiumsupport/knowledge-center/connect-s3-vpc-endpoint)

        An endpoint of type `GatewayLoadBalancer` provides private connectivity between your VPC and virtual appliances from a service provider.

        :param str resource_name: The name of the resource.
        :param VpcEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dns_options: Optional[pulumi.Input[Union['VpcEndpointDnsOptionsSpecificationArgs', 'VpcEndpointDnsOptionsSpecificationArgsDict']]] = None,
                 ip_address_type: Optional[pulumi.Input['VpcEndpointIpAddressType']] = None,
                 policy_document: Optional[Any] = None,
                 private_dns_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_configuration_arn: Optional[pulumi.Input[builtins.str]] = None,
                 route_table_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_network_arn: Optional[pulumi.Input[builtins.str]] = None,
                 service_region: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 vpc_endpoint_type: Optional[pulumi.Input['VpcEndpointType']] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcEndpointArgs.__new__(VpcEndpointArgs)

            __props__.__dict__["dns_options"] = dns_options
            __props__.__dict__["ip_address_type"] = ip_address_type
            __props__.__dict__["policy_document"] = policy_document
            __props__.__dict__["private_dns_enabled"] = private_dns_enabled
            __props__.__dict__["resource_configuration_arn"] = resource_configuration_arn
            __props__.__dict__["route_table_ids"] = route_table_ids
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["service_network_arn"] = service_network_arn
            __props__.__dict__["service_region"] = service_region
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_endpoint_type"] = vpc_endpoint_type
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["dns_entries"] = None
            __props__.__dict__["network_interface_ids"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["resourceConfigurationArn", "serviceName", "serviceNetworkArn", "serviceRegion", "vpcEndpointType", "vpcId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(VpcEndpoint, __self__).__init__(
            'aws-native:ec2:VpcEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'VpcEndpoint':
        """
        Get an existing VpcEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = VpcEndpointArgs.__new__(VpcEndpointArgs)

        __props__.__dict__["aws_id"] = None
        __props__.__dict__["creation_timestamp"] = None
        __props__.__dict__["dns_entries"] = None
        __props__.__dict__["dns_options"] = None
        __props__.__dict__["ip_address_type"] = None
        __props__.__dict__["network_interface_ids"] = None
        __props__.__dict__["policy_document"] = None
        __props__.__dict__["private_dns_enabled"] = None
        __props__.__dict__["resource_configuration_arn"] = None
        __props__.__dict__["route_table_ids"] = None
        __props__.__dict__["security_group_ids"] = None
        __props__.__dict__["service_name"] = None
        __props__.__dict__["service_network_arn"] = None
        __props__.__dict__["service_region"] = None
        __props__.__dict__["subnet_ids"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["vpc_endpoint_type"] = None
        __props__.__dict__["vpc_id"] = None
        return VpcEndpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the VPC endpoint.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the VPC endpoint was created. For example: `Fri Sep 28 23:34:36 UTC 2018.`
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter(name="dnsEntries")
    def dns_entries(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Interface endpoints) The DNS entries for the endpoint. Each entry is a combination of the hosted zone ID and the DNS name. The entries are ordered as follows: regional public DNS, zonal public DNS, private DNS, and wildcard DNS. This order is not enforced for AWS Marketplace services.

        The following is an example. In the first entry, the hosted zone ID is Z1HUB23UULQXV and the DNS name is vpce-01abc23456de78f9g-12abccd3.ec2.us-east-1.vpce.amazonaws.com.

        ["Z1HUB23UULQXV:vpce-01abc23456de78f9g-12abccd3.ec2.us-east-1.vpce.amazonaws.com", "Z1HUB23UULQXV:vpce-01abc23456de78f9g-12abccd3-us-east-1a.ec2.us-east-1.vpce.amazonaws.com", "Z1C12344VYDITB0:ec2.us-east-1.amazonaws.com"]

        If you update the `PrivateDnsEnabled` or `SubnetIds` properties, the DNS entries in the list will change.
        """
        return pulumi.get(self, "dns_entries")

    @property
    @pulumi.getter(name="dnsOptions")
    def dns_options(self) -> pulumi.Output[Optional['outputs.VpcEndpointDnsOptionsSpecification']]:
        """
        Describes the DNS options for an endpoint.
        """
        return pulumi.get(self, "dns_options")

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> pulumi.Output[Optional['VpcEndpointIpAddressType']]:
        """
        The supported IP address types.
        """
        return pulumi.get(self, "ip_address_type")

    @property
    @pulumi.getter(name="networkInterfaceIds")
    def network_interface_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Interface endpoints) The network interface IDs. If you update the `PrivateDnsEnabled` or `SubnetIds` properties, the items in this list might change.
        """
        return pulumi.get(self, "network_interface_ids")

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> pulumi.Output[Optional[Any]]:
        """
        An endpoint policy, which controls access to the service from the VPC. The default endpoint policy allows full access to the service. Endpoint policies are supported only for gateway and interface endpoints.
         For CloudFormation templates in YAML, you can provide the policy in JSON or YAML format. For example, if you have a JSON policy, you can convert it to YAML before including it in the YAML template, and CFNlong converts the policy to JSON format before calling the API actions for privatelink. Alternatively, you can include the JSON directly in the YAML, as shown in the following ``Properties`` section:
         ``Properties: VpcEndpointType: 'Interface' ServiceName: !Sub 'com.amazonaws.${AWS::Region}.logs' PolicyDocument: '{ "Version":"2012-10-17", "Statement": [{ "Effect":"Allow", "Principal":"*", "Action":["logs:Describe*","logs:Get*","logs:List*","logs:FilterLogEvents"], "Resource":"*" }] }'``

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::EC2::VPCEndpoint` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "policy_document")

    @property
    @pulumi.getter(name="privateDnsEnabled")
    def private_dns_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicate whether to associate a private hosted zone with the specified VPC. The private hosted zone contains a record set for the default public DNS name for the service for the Region (for example, ``kinesis.us-east-1.amazonaws.com``), which resolves to the private IP addresses of the endpoint network interfaces in the VPC. This enables you to make requests to the default public DNS name for the service instead of the public DNS names that are automatically generated by the VPC endpoint service.
         To use a private hosted zone, you must set the following VPC attributes to ``true``: ``enableDnsHostnames`` and ``enableDnsSupport``.
         This property is supported only for interface endpoints.
         Default: ``false``
        """
        return pulumi.get(self, "private_dns_enabled")

    @property
    @pulumi.getter(name="resourceConfigurationArn")
    def resource_configuration_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the resource configuration.
        """
        return pulumi.get(self, "resource_configuration_arn")

    @property
    @pulumi.getter(name="routeTableIds")
    def route_table_ids(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The IDs of the route tables. Routing is supported only for gateway endpoints.
        """
        return pulumi.get(self, "route_table_ids")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The IDs of the security groups to associate with the endpoint network interfaces. If this parameter is not specified, we use the default security group for the VPC. Security groups are supported only for interface endpoints.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the endpoint service.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="serviceNetworkArn")
    def service_network_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the service network.
        """
        return pulumi.get(self, "service_network_arn")

    @property
    @pulumi.getter(name="serviceRegion")
    def service_region(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Describes a Region.
        """
        return pulumi.get(self, "service_region")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The IDs of the subnets in which to create endpoint network interfaces. You must specify this property for an interface endpoint or a Gateway Load Balancer endpoint. You can't specify this property for a gateway endpoint. For a Gateway Load Balancer endpoint, you can specify only one subnet.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags to associate with the endpoint.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcEndpointType")
    def vpc_endpoint_type(self) -> pulumi.Output[Optional['VpcEndpointType']]:
        """
        The type of endpoint.
         Default: Gateway
        """
        return pulumi.get(self, "vpc_endpoint_type")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

