# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = ['VpcBlockPublicAccessExclusionArgs', 'VpcBlockPublicAccessExclusion']

@pulumi.input_type
class VpcBlockPublicAccessExclusionArgs:
    def __init__(__self__, *,
                 internet_gateway_exclusion_mode: pulumi.Input['VpcBlockPublicAccessExclusionInternetGatewayExclusionMode'],
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a VpcBlockPublicAccessExclusion resource.
        :param pulumi.Input['VpcBlockPublicAccessExclusionInternetGatewayExclusionMode'] internet_gateway_exclusion_mode: The desired Block Public Access Exclusion Mode for a specific VPC/Subnet.
        :param pulumi.Input[builtins.str] subnet_id: The ID of the subnet. Required only if you don't specify VpcId
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input[builtins.str] vpc_id: The ID of the vpc. Required only if you don't specify SubnetId.
        """
        pulumi.set(__self__, "internet_gateway_exclusion_mode", internet_gateway_exclusion_mode)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="internetGatewayExclusionMode")
    def internet_gateway_exclusion_mode(self) -> pulumi.Input['VpcBlockPublicAccessExclusionInternetGatewayExclusionMode']:
        """
        The desired Block Public Access Exclusion Mode for a specific VPC/Subnet.
        """
        return pulumi.get(self, "internet_gateway_exclusion_mode")

    @internet_gateway_exclusion_mode.setter
    def internet_gateway_exclusion_mode(self, value: pulumi.Input['VpcBlockPublicAccessExclusionInternetGatewayExclusionMode']):
        pulumi.set(self, "internet_gateway_exclusion_mode", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the subnet. Required only if you don't specify VpcId
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the vpc. Required only if you don't specify SubnetId.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("aws-native:ec2:VpcBlockPublicAccessExclusion")
class VpcBlockPublicAccessExclusion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 internet_gateway_exclusion_mode: Optional[pulumi.Input['VpcBlockPublicAccessExclusionInternetGatewayExclusionMode']] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::EC2::VPCBlockPublicAccessExclusion.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input['VpcBlockPublicAccessExclusionInternetGatewayExclusionMode'] internet_gateway_exclusion_mode: The desired Block Public Access Exclusion Mode for a specific VPC/Subnet.
        :param pulumi.Input[builtins.str] subnet_id: The ID of the subnet. Required only if you don't specify VpcId
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input[builtins.str] vpc_id: The ID of the vpc. Required only if you don't specify SubnetId.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcBlockPublicAccessExclusionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::EC2::VPCBlockPublicAccessExclusion.

        :param str resource_name: The name of the resource.
        :param VpcBlockPublicAccessExclusionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcBlockPublicAccessExclusionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 internet_gateway_exclusion_mode: Optional[pulumi.Input['VpcBlockPublicAccessExclusionInternetGatewayExclusionMode']] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcBlockPublicAccessExclusionArgs.__new__(VpcBlockPublicAccessExclusionArgs)

            if internet_gateway_exclusion_mode is None and not opts.urn:
                raise TypeError("Missing required property 'internet_gateway_exclusion_mode'")
            __props__.__dict__["internet_gateway_exclusion_mode"] = internet_gateway_exclusion_mode
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["exclusion_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["subnetId", "vpcId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(VpcBlockPublicAccessExclusion, __self__).__init__(
            'aws-native:ec2:VpcBlockPublicAccessExclusion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'VpcBlockPublicAccessExclusion':
        """
        Get an existing VpcBlockPublicAccessExclusion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = VpcBlockPublicAccessExclusionArgs.__new__(VpcBlockPublicAccessExclusionArgs)

        __props__.__dict__["exclusion_id"] = None
        __props__.__dict__["internet_gateway_exclusion_mode"] = None
        __props__.__dict__["subnet_id"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["vpc_id"] = None
        return VpcBlockPublicAccessExclusion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="exclusionId")
    def exclusion_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the exclusion
        """
        return pulumi.get(self, "exclusion_id")

    @property
    @pulumi.getter(name="internetGatewayExclusionMode")
    def internet_gateway_exclusion_mode(self) -> pulumi.Output['VpcBlockPublicAccessExclusionInternetGatewayExclusionMode']:
        """
        The desired Block Public Access Exclusion Mode for a specific VPC/Subnet.
        """
        return pulumi.get(self, "internet_gateway_exclusion_mode")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the subnet. Required only if you don't specify VpcId
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the vpc. Required only if you don't specify SubnetId.
        """
        return pulumi.get(self, "vpc_id")

