# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs

__all__ = ['VolumeArgs', 'Volume']

@pulumi.input_type
class VolumeArgs:
    def __init__(__self__, *,
                 availability_zone: pulumi.Input[builtins.str],
                 auto_enable_io: Optional[pulumi.Input[builtins.bool]] = None,
                 encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 iops: Optional[pulumi.Input[builtins.int]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 multi_attach_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 outpost_arn: Optional[pulumi.Input[builtins.str]] = None,
                 size: Optional[pulumi.Input[builtins.int]] = None,
                 snapshot_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 throughput: Optional[pulumi.Input[builtins.int]] = None,
                 volume_initialization_rate: Optional[pulumi.Input[builtins.int]] = None,
                 volume_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Volume resource.
        :param pulumi.Input[builtins.str] availability_zone: The ID of the Availability Zone in which to create the volume. For example, ``us-east-1a``.
        :param pulumi.Input[builtins.bool] auto_enable_io: Indicates whether the volume is auto-enabled for I/O operations. By default, Amazon EBS disables I/O to the volume from attached EC2 instances when it determines that a volume's data is potentially inconsistent. If the consistency of the volume is not a concern, and you prefer that the volume be made available immediately if it's impaired, you can configure the volume to automatically enable I/O.
        :param pulumi.Input[builtins.bool] encrypted: Indicates whether the volume should be encrypted. The effect of setting the encryption state to ``true`` depends on the volume origin (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is enabled. For more information, see [Encryption by default](https://docs.aws.amazon.com/ebs/latest/userguide/work-with-ebs-encr.html#encryption-by-default) in the *Amazon EBS User Guide*.
                Encrypted Amazon EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see [Supported instance types](https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption-requirements.html#ebs-encryption_supported_instances).
        :param pulumi.Input[builtins.int] iops: The number of I/O operations per second (IOPS). For ``gp3``, ``io1``, and ``io2`` volumes, this represents the number of IOPS that are provisioned for the volume. For ``gp2`` volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting.
                The following are the supported values for each volume type:
                 +  ``gp3``: 3,000 - 16,000 IOPS
                 +  ``io1``: 100 - 64,000 IOPS
                 +  ``io2``: 100 - 256,000 IOPS
                 
                For ``io2`` volumes, you can achieve up to 256,000 IOPS on [instances built on the Nitro System](https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html). On other instances, you can achieve performance up to 32,000 IOPS.
                This parameter is required for ``io1`` and ``io2`` volumes. The default for ``gp3`` volumes is 3,000 IOPS. This parameter is not supported for ``gp2``, ``st1``, ``sc1``, or ``standard`` volumes.
        :param pulumi.Input[builtins.str] kms_key_id: The identifier of the kms-key-long to use for Amazon EBS encryption. If ``KmsKeyId`` is specified, the encrypted state must be ``true``.
                If you omit this property and your account is enabled for encryption by default, or *Encrypted* is set to ``true``, then the volume is encrypted using the default key specified for your account. If your account does not have a default key, then the volume is encrypted using the aws-managed-key.
                Alternatively, if you want to specify a different key, you can specify one of the following:
                 +  Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
                 +  Key alias. Specify the alias for the key, prefixed with ``alias/``. For example, for a key with the alias ``my_cmk``, use ``alias/my_cmk``. Or to specify the aws-managed-key, use ``alias/aws/ebs``.
                 +  Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
                 +  Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
        :param pulumi.Input[builtins.bool] multi_attach_enabled: Indicates whether Amazon EBS Multi-Attach is enabled.
                CFNlong does not currently support updating a single-attach volume to be multi-attach enabled, updating a multi-attach enabled volume to be single-attach, or updating the size or number of I/O operations per second (IOPS) of a multi-attach enabled volume.
        :param pulumi.Input[builtins.str] outpost_arn: The Amazon Resource Name (ARN) of the Outpost.
        :param pulumi.Input[builtins.int] size: The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size. If you specify a snapshot, the default is the snapshot size. You can specify a volume size that is equal to or larger than the snapshot size.
                The following are the supported volumes sizes for each volume type:
                 +  ``gp2`` and ``gp3``: 1 - 16,384 GiB
                 +  ``io1``: 4 - 16,384 GiB
                 +  ``io2``: 4 - 65,536 GiB
                 +  ``st1`` and ``sc1``: 125 - 16,384 GiB
                 +  ``standard``: 1 - 1024 GiB
        :param pulumi.Input[builtins.str] snapshot_id: The snapshot from which to create the volume. You must specify either a snapshot ID or a volume size.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags to apply to the volume during creation.
        :param pulumi.Input[builtins.int] throughput: The throughput to provision for a volume, with a maximum of 1,000 MiB/s.
                This parameter is valid only for ``gp3`` volumes. The default value is 125.
                Valid Range: Minimum value of 125. Maximum value of 1000.
        :param pulumi.Input[builtins.int] volume_initialization_rate: Specifies the Amazon EBS Provisioned Rate for Volume Initialization (volume initialization rate), in MiB/s, at which to download the snapshot blocks from Amazon S3 to the volume. This is also known as *volume initialization* . Specifying a volume initialization rate ensures that the volume is initialized at a predictable and consistent rate after creation.
               
               This parameter is supported only for volumes created from snapshots. Omit this parameter if:
               
               - You want to create the volume using fast snapshot restore. You must specify a snapshot that is enabled for fast snapshot restore. In this case, the volume is fully initialized at creation.
               
               > If you specify a snapshot that is enabled for fast snapshot restore and a volume initialization rate, the volume will be initialized at the specified rate instead of fast snapshot restore.
               - You want to create a volume that is initialized at the default rate.
               
               For more information, see [Initialize Amazon EBS volumes](https://docs.aws.amazon.com/ebs/latest/userguide/initalize-volume.html) in the *Amazon EC2 User Guide* .
               
               Valid range: 100 - 300 MiB/s
        :param pulumi.Input[builtins.str] volume_type: The volume type. This parameter can be one of the following values:
                 +  General Purpose SSD: ``gp2`` | ``gp3``
                 +  Provisioned IOPS SSD: ``io1`` | ``io2``
                 +  Throughput Optimized HDD: ``st1``
                 +  Cold HDD: ``sc1``
                 +  Magnetic: ``standard``
                 
                For more information, see [Amazon EBS volume types](https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html).
                Default: ``gp2``
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        if auto_enable_io is not None:
            pulumi.set(__self__, "auto_enable_io", auto_enable_io)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if multi_attach_enabled is not None:
            pulumi.set(__self__, "multi_attach_enabled", multi_attach_enabled)
        if outpost_arn is not None:
            pulumi.set(__self__, "outpost_arn", outpost_arn)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if volume_initialization_rate is not None:
            pulumi.set(__self__, "volume_initialization_rate", volume_initialization_rate)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Availability Zone in which to create the volume. For example, ``us-east-1a``.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="autoEnableIo")
    def auto_enable_io(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the volume is auto-enabled for I/O operations. By default, Amazon EBS disables I/O to the volume from attached EC2 instances when it determines that a volume's data is potentially inconsistent. If the consistency of the volume is not a concern, and you prefer that the volume be made available immediately if it's impaired, you can configure the volume to automatically enable I/O.
        """
        return pulumi.get(self, "auto_enable_io")

    @auto_enable_io.setter
    def auto_enable_io(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_enable_io", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the volume should be encrypted. The effect of setting the encryption state to ``true`` depends on the volume origin (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is enabled. For more information, see [Encryption by default](https://docs.aws.amazon.com/ebs/latest/userguide/work-with-ebs-encr.html#encryption-by-default) in the *Amazon EBS User Guide*.
         Encrypted Amazon EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see [Supported instance types](https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption-requirements.html#ebs-encryption_supported_instances).
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of I/O operations per second (IOPS). For ``gp3``, ``io1``, and ``io2`` volumes, this represents the number of IOPS that are provisioned for the volume. For ``gp2`` volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting.
         The following are the supported values for each volume type:
          +  ``gp3``: 3,000 - 16,000 IOPS
          +  ``io1``: 100 - 64,000 IOPS
          +  ``io2``: 100 - 256,000 IOPS
          
         For ``io2`` volumes, you can achieve up to 256,000 IOPS on [instances built on the Nitro System](https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html). On other instances, you can achieve performance up to 32,000 IOPS.
         This parameter is required for ``io1`` and ``io2`` volumes. The default for ``gp3`` volumes is 3,000 IOPS. This parameter is not supported for ``gp2``, ``st1``, ``sc1``, or ``standard`` volumes.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "iops", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier of the kms-key-long to use for Amazon EBS encryption. If ``KmsKeyId`` is specified, the encrypted state must be ``true``.
         If you omit this property and your account is enabled for encryption by default, or *Encrypted* is set to ``true``, then the volume is encrypted using the default key specified for your account. If your account does not have a default key, then the volume is encrypted using the aws-managed-key.
         Alternatively, if you want to specify a different key, you can specify one of the following:
          +  Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
          +  Key alias. Specify the alias for the key, prefixed with ``alias/``. For example, for a key with the alias ``my_cmk``, use ``alias/my_cmk``. Or to specify the aws-managed-key, use ``alias/aws/ebs``.
          +  Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
          +  Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="multiAttachEnabled")
    def multi_attach_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether Amazon EBS Multi-Attach is enabled.
         CFNlong does not currently support updating a single-attach volume to be multi-attach enabled, updating a multi-attach enabled volume to be single-attach, or updating the size or number of I/O operations per second (IOPS) of a multi-attach enabled volume.
        """
        return pulumi.get(self, "multi_attach_enabled")

    @multi_attach_enabled.setter
    def multi_attach_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "multi_attach_enabled", value)

    @property
    @pulumi.getter(name="outpostArn")
    def outpost_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the Outpost.
        """
        return pulumi.get(self, "outpost_arn")

    @outpost_arn.setter
    def outpost_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "outpost_arn", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size. If you specify a snapshot, the default is the snapshot size. You can specify a volume size that is equal to or larger than the snapshot size.
         The following are the supported volumes sizes for each volume type:
          +  ``gp2`` and ``gp3``: 1 - 16,384 GiB
          +  ``io1``: 4 - 16,384 GiB
          +  ``io2``: 4 - 65,536 GiB
          +  ``st1`` and ``sc1``: 125 - 16,384 GiB
          +  ``standard``: 1 - 1024 GiB
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The snapshot from which to create the volume. You must specify either a snapshot ID or a volume size.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags to apply to the volume during creation.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def throughput(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The throughput to provision for a volume, with a maximum of 1,000 MiB/s.
         This parameter is valid only for ``gp3`` volumes. The default value is 125.
         Valid Range: Minimum value of 125. Maximum value of 1000.
        """
        return pulumi.get(self, "throughput")

    @throughput.setter
    def throughput(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "throughput", value)

    @property
    @pulumi.getter(name="volumeInitializationRate")
    def volume_initialization_rate(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the Amazon EBS Provisioned Rate for Volume Initialization (volume initialization rate), in MiB/s, at which to download the snapshot blocks from Amazon S3 to the volume. This is also known as *volume initialization* . Specifying a volume initialization rate ensures that the volume is initialized at a predictable and consistent rate after creation.

        This parameter is supported only for volumes created from snapshots. Omit this parameter if:

        - You want to create the volume using fast snapshot restore. You must specify a snapshot that is enabled for fast snapshot restore. In this case, the volume is fully initialized at creation.

        > If you specify a snapshot that is enabled for fast snapshot restore and a volume initialization rate, the volume will be initialized at the specified rate instead of fast snapshot restore.
        - You want to create a volume that is initialized at the default rate.

        For more information, see [Initialize Amazon EBS volumes](https://docs.aws.amazon.com/ebs/latest/userguide/initalize-volume.html) in the *Amazon EC2 User Guide* .

        Valid range: 100 - 300 MiB/s
        """
        return pulumi.get(self, "volume_initialization_rate")

    @volume_initialization_rate.setter
    def volume_initialization_rate(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "volume_initialization_rate", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The volume type. This parameter can be one of the following values:
          +  General Purpose SSD: ``gp2`` | ``gp3``
          +  Provisioned IOPS SSD: ``io1`` | ``io2``
          +  Throughput Optimized HDD: ``st1``
          +  Cold HDD: ``sc1``
          +  Magnetic: ``standard``
          
         For more information, see [Amazon EBS volume types](https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html).
         Default: ``gp2``
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "volume_type", value)


@pulumi.type_token("aws-native:ec2:Volume")
class Volume(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_enable_io: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 iops: Optional[pulumi.Input[builtins.int]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 multi_attach_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 outpost_arn: Optional[pulumi.Input[builtins.str]] = None,
                 size: Optional[pulumi.Input[builtins.int]] = None,
                 snapshot_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 throughput: Optional[pulumi.Input[builtins.int]] = None,
                 volume_initialization_rate: Optional[pulumi.Input[builtins.int]] = None,
                 volume_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Specifies an Amazon Elastic Block Store (Amazon EBS) volume.

        When you use AWS CloudFormation to update an Amazon EBS volume that modifies `Iops` , `Size` , or `VolumeType` , there is a cooldown period before another operation can occur. This can cause your stack to report being in `UPDATE_IN_PROGRESS` or `UPDATE_ROLLBACK_IN_PROGRESS` for long periods of time.

        Amazon EBS does not support sizing down an Amazon EBS volume. AWS CloudFormation does not attempt to modify an Amazon EBS volume to a smaller size on rollback.

        Some common scenarios when you might encounter a cooldown period for Amazon EBS include:

        - You successfully update an Amazon EBS volume and the update succeeds. When you attempt another update within the cooldown window, that update will be subject to a cooldown period.
        - You successfully update an Amazon EBS volume and the update succeeds but another change in your `update-stack` call fails. The rollback will be subject to a cooldown period.

        For more information, see [Requirements for EBS volume modifications](https://docs.aws.amazon.com/ebs/latest/userguide/modify-volume-requirements.html) .

        *DeletionPolicy attribute*

        To control how AWS CloudFormation handles the volume when the stack is deleted, set a deletion policy for your volume. You can choose to retain the volume, to delete the volume, or to create a snapshot of the volume. For more information, see [DeletionPolicy attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html) .

        > If you set a deletion policy that creates a snapshot, all tags on the volume are included in the snapshot.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] auto_enable_io: Indicates whether the volume is auto-enabled for I/O operations. By default, Amazon EBS disables I/O to the volume from attached EC2 instances when it determines that a volume's data is potentially inconsistent. If the consistency of the volume is not a concern, and you prefer that the volume be made available immediately if it's impaired, you can configure the volume to automatically enable I/O.
        :param pulumi.Input[builtins.str] availability_zone: The ID of the Availability Zone in which to create the volume. For example, ``us-east-1a``.
        :param pulumi.Input[builtins.bool] encrypted: Indicates whether the volume should be encrypted. The effect of setting the encryption state to ``true`` depends on the volume origin (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is enabled. For more information, see [Encryption by default](https://docs.aws.amazon.com/ebs/latest/userguide/work-with-ebs-encr.html#encryption-by-default) in the *Amazon EBS User Guide*.
                Encrypted Amazon EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see [Supported instance types](https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption-requirements.html#ebs-encryption_supported_instances).
        :param pulumi.Input[builtins.int] iops: The number of I/O operations per second (IOPS). For ``gp3``, ``io1``, and ``io2`` volumes, this represents the number of IOPS that are provisioned for the volume. For ``gp2`` volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting.
                The following are the supported values for each volume type:
                 +  ``gp3``: 3,000 - 16,000 IOPS
                 +  ``io1``: 100 - 64,000 IOPS
                 +  ``io2``: 100 - 256,000 IOPS
                 
                For ``io2`` volumes, you can achieve up to 256,000 IOPS on [instances built on the Nitro System](https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html). On other instances, you can achieve performance up to 32,000 IOPS.
                This parameter is required for ``io1`` and ``io2`` volumes. The default for ``gp3`` volumes is 3,000 IOPS. This parameter is not supported for ``gp2``, ``st1``, ``sc1``, or ``standard`` volumes.
        :param pulumi.Input[builtins.str] kms_key_id: The identifier of the kms-key-long to use for Amazon EBS encryption. If ``KmsKeyId`` is specified, the encrypted state must be ``true``.
                If you omit this property and your account is enabled for encryption by default, or *Encrypted* is set to ``true``, then the volume is encrypted using the default key specified for your account. If your account does not have a default key, then the volume is encrypted using the aws-managed-key.
                Alternatively, if you want to specify a different key, you can specify one of the following:
                 +  Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
                 +  Key alias. Specify the alias for the key, prefixed with ``alias/``. For example, for a key with the alias ``my_cmk``, use ``alias/my_cmk``. Or to specify the aws-managed-key, use ``alias/aws/ebs``.
                 +  Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
                 +  Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
        :param pulumi.Input[builtins.bool] multi_attach_enabled: Indicates whether Amazon EBS Multi-Attach is enabled.
                CFNlong does not currently support updating a single-attach volume to be multi-attach enabled, updating a multi-attach enabled volume to be single-attach, or updating the size or number of I/O operations per second (IOPS) of a multi-attach enabled volume.
        :param pulumi.Input[builtins.str] outpost_arn: The Amazon Resource Name (ARN) of the Outpost.
        :param pulumi.Input[builtins.int] size: The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size. If you specify a snapshot, the default is the snapshot size. You can specify a volume size that is equal to or larger than the snapshot size.
                The following are the supported volumes sizes for each volume type:
                 +  ``gp2`` and ``gp3``: 1 - 16,384 GiB
                 +  ``io1``: 4 - 16,384 GiB
                 +  ``io2``: 4 - 65,536 GiB
                 +  ``st1`` and ``sc1``: 125 - 16,384 GiB
                 +  ``standard``: 1 - 1024 GiB
        :param pulumi.Input[builtins.str] snapshot_id: The snapshot from which to create the volume. You must specify either a snapshot ID or a volume size.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags to apply to the volume during creation.
        :param pulumi.Input[builtins.int] throughput: The throughput to provision for a volume, with a maximum of 1,000 MiB/s.
                This parameter is valid only for ``gp3`` volumes. The default value is 125.
                Valid Range: Minimum value of 125. Maximum value of 1000.
        :param pulumi.Input[builtins.int] volume_initialization_rate: Specifies the Amazon EBS Provisioned Rate for Volume Initialization (volume initialization rate), in MiB/s, at which to download the snapshot blocks from Amazon S3 to the volume. This is also known as *volume initialization* . Specifying a volume initialization rate ensures that the volume is initialized at a predictable and consistent rate after creation.
               
               This parameter is supported only for volumes created from snapshots. Omit this parameter if:
               
               - You want to create the volume using fast snapshot restore. You must specify a snapshot that is enabled for fast snapshot restore. In this case, the volume is fully initialized at creation.
               
               > If you specify a snapshot that is enabled for fast snapshot restore and a volume initialization rate, the volume will be initialized at the specified rate instead of fast snapshot restore.
               - You want to create a volume that is initialized at the default rate.
               
               For more information, see [Initialize Amazon EBS volumes](https://docs.aws.amazon.com/ebs/latest/userguide/initalize-volume.html) in the *Amazon EC2 User Guide* .
               
               Valid range: 100 - 300 MiB/s
        :param pulumi.Input[builtins.str] volume_type: The volume type. This parameter can be one of the following values:
                 +  General Purpose SSD: ``gp2`` | ``gp3``
                 +  Provisioned IOPS SSD: ``io1`` | ``io2``
                 +  Throughput Optimized HDD: ``st1``
                 +  Cold HDD: ``sc1``
                 +  Magnetic: ``standard``
                 
                For more information, see [Amazon EBS volume types](https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html).
                Default: ``gp2``
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VolumeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Specifies an Amazon Elastic Block Store (Amazon EBS) volume.

        When you use AWS CloudFormation to update an Amazon EBS volume that modifies `Iops` , `Size` , or `VolumeType` , there is a cooldown period before another operation can occur. This can cause your stack to report being in `UPDATE_IN_PROGRESS` or `UPDATE_ROLLBACK_IN_PROGRESS` for long periods of time.

        Amazon EBS does not support sizing down an Amazon EBS volume. AWS CloudFormation does not attempt to modify an Amazon EBS volume to a smaller size on rollback.

        Some common scenarios when you might encounter a cooldown period for Amazon EBS include:

        - You successfully update an Amazon EBS volume and the update succeeds. When you attempt another update within the cooldown window, that update will be subject to a cooldown period.
        - You successfully update an Amazon EBS volume and the update succeeds but another change in your `update-stack` call fails. The rollback will be subject to a cooldown period.

        For more information, see [Requirements for EBS volume modifications](https://docs.aws.amazon.com/ebs/latest/userguide/modify-volume-requirements.html) .

        *DeletionPolicy attribute*

        To control how AWS CloudFormation handles the volume when the stack is deleted, set a deletion policy for your volume. You can choose to retain the volume, to delete the volume, or to create a snapshot of the volume. For more information, see [DeletionPolicy attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html) .

        > If you set a deletion policy that creates a snapshot, all tags on the volume are included in the snapshot.

        :param str resource_name: The name of the resource.
        :param VolumeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VolumeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_enable_io: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 encrypted: Optional[pulumi.Input[builtins.bool]] = None,
                 iops: Optional[pulumi.Input[builtins.int]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 multi_attach_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 outpost_arn: Optional[pulumi.Input[builtins.str]] = None,
                 size: Optional[pulumi.Input[builtins.int]] = None,
                 snapshot_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 throughput: Optional[pulumi.Input[builtins.int]] = None,
                 volume_initialization_rate: Optional[pulumi.Input[builtins.int]] = None,
                 volume_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VolumeArgs.__new__(VolumeArgs)

            __props__.__dict__["auto_enable_io"] = auto_enable_io
            if availability_zone is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zone'")
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["encrypted"] = encrypted
            __props__.__dict__["iops"] = iops
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["multi_attach_enabled"] = multi_attach_enabled
            __props__.__dict__["outpost_arn"] = outpost_arn
            __props__.__dict__["size"] = size
            __props__.__dict__["snapshot_id"] = snapshot_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["throughput"] = throughput
            __props__.__dict__["volume_initialization_rate"] = volume_initialization_rate
            __props__.__dict__["volume_type"] = volume_type
            __props__.__dict__["volume_id"] = None
        super(Volume, __self__).__init__(
            'aws-native:ec2:Volume',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Volume':
        """
        Get an existing Volume resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = VolumeArgs.__new__(VolumeArgs)

        __props__.__dict__["auto_enable_io"] = None
        __props__.__dict__["availability_zone"] = None
        __props__.__dict__["encrypted"] = None
        __props__.__dict__["iops"] = None
        __props__.__dict__["kms_key_id"] = None
        __props__.__dict__["multi_attach_enabled"] = None
        __props__.__dict__["outpost_arn"] = None
        __props__.__dict__["size"] = None
        __props__.__dict__["snapshot_id"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["throughput"] = None
        __props__.__dict__["volume_id"] = None
        __props__.__dict__["volume_initialization_rate"] = None
        __props__.__dict__["volume_type"] = None
        return Volume(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoEnableIo")
    def auto_enable_io(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether the volume is auto-enabled for I/O operations. By default, Amazon EBS disables I/O to the volume from attached EC2 instances when it determines that a volume's data is potentially inconsistent. If the consistency of the volume is not a concern, and you prefer that the volume be made available immediately if it's impaired, you can configure the volume to automatically enable I/O.
        """
        return pulumi.get(self, "auto_enable_io")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Availability Zone in which to create the volume. For example, ``us-east-1a``.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def encrypted(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether the volume should be encrypted. The effect of setting the encryption state to ``true`` depends on the volume origin (new or from a snapshot), starting encryption state, ownership, and whether encryption by default is enabled. For more information, see [Encryption by default](https://docs.aws.amazon.com/ebs/latest/userguide/work-with-ebs-encr.html#encryption-by-default) in the *Amazon EBS User Guide*.
         Encrypted Amazon EBS volumes must be attached to instances that support Amazon EBS encryption. For more information, see [Supported instance types](https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption-requirements.html#ebs-encryption_supported_instances).
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of I/O operations per second (IOPS). For ``gp3``, ``io1``, and ``io2`` volumes, this represents the number of IOPS that are provisioned for the volume. For ``gp2`` volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting.
         The following are the supported values for each volume type:
          +  ``gp3``: 3,000 - 16,000 IOPS
          +  ``io1``: 100 - 64,000 IOPS
          +  ``io2``: 100 - 256,000 IOPS
          
         For ``io2`` volumes, you can achieve up to 256,000 IOPS on [instances built on the Nitro System](https://docs.aws.amazon.com/ec2/latest/instancetypes/ec2-nitro-instances.html). On other instances, you can achieve performance up to 32,000 IOPS.
         This parameter is required for ``io1`` and ``io2`` volumes. The default for ``gp3`` volumes is 3,000 IOPS. This parameter is not supported for ``gp2``, ``st1``, ``sc1``, or ``standard`` volumes.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The identifier of the kms-key-long to use for Amazon EBS encryption. If ``KmsKeyId`` is specified, the encrypted state must be ``true``.
         If you omit this property and your account is enabled for encryption by default, or *Encrypted* is set to ``true``, then the volume is encrypted using the default key specified for your account. If your account does not have a default key, then the volume is encrypted using the aws-managed-key.
         Alternatively, if you want to specify a different key, you can specify one of the following:
          +  Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
          +  Key alias. Specify the alias for the key, prefixed with ``alias/``. For example, for a key with the alias ``my_cmk``, use ``alias/my_cmk``. Or to specify the aws-managed-key, use ``alias/aws/ebs``.
          +  Key ARN. For example, arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
          +  Alias ARN. For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="multiAttachEnabled")
    def multi_attach_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether Amazon EBS Multi-Attach is enabled.
         CFNlong does not currently support updating a single-attach volume to be multi-attach enabled, updating a multi-attach enabled volume to be single-attach, or updating the size or number of I/O operations per second (IOPS) of a multi-attach enabled volume.
        """
        return pulumi.get(self, "multi_attach_enabled")

    @property
    @pulumi.getter(name="outpostArn")
    def outpost_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the Outpost.
        """
        return pulumi.get(self, "outpost_arn")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The size of the volume, in GiBs. You must specify either a snapshot ID or a volume size. If you specify a snapshot, the default is the snapshot size. You can specify a volume size that is equal to or larger than the snapshot size.
         The following are the supported volumes sizes for each volume type:
          +  ``gp2`` and ``gp3``: 1 - 16,384 GiB
          +  ``io1``: 4 - 16,384 GiB
          +  ``io2``: 4 - 65,536 GiB
          +  ``st1`` and ``sc1``: 125 - 16,384 GiB
          +  ``standard``: 1 - 1024 GiB
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The snapshot from which to create the volume. You must specify either a snapshot ID or a volume size.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags to apply to the volume during creation.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def throughput(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The throughput to provision for a volume, with a maximum of 1,000 MiB/s.
         This parameter is valid only for ``gp3`` volumes. The default value is 125.
         Valid Range: Minimum value of 125. Maximum value of 1000.
        """
        return pulumi.get(self, "throughput")

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the volume.
        """
        return pulumi.get(self, "volume_id")

    @property
    @pulumi.getter(name="volumeInitializationRate")
    def volume_initialization_rate(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies the Amazon EBS Provisioned Rate for Volume Initialization (volume initialization rate), in MiB/s, at which to download the snapshot blocks from Amazon S3 to the volume. This is also known as *volume initialization* . Specifying a volume initialization rate ensures that the volume is initialized at a predictable and consistent rate after creation.

        This parameter is supported only for volumes created from snapshots. Omit this parameter if:

        - You want to create the volume using fast snapshot restore. You must specify a snapshot that is enabled for fast snapshot restore. In this case, the volume is fully initialized at creation.

        > If you specify a snapshot that is enabled for fast snapshot restore and a volume initialization rate, the volume will be initialized at the specified rate instead of fast snapshot restore.
        - You want to create a volume that is initialized at the default rate.

        For more information, see [Initialize Amazon EBS volumes](https://docs.aws.amazon.com/ebs/latest/userguide/initalize-volume.html) in the *Amazon EC2 User Guide* .

        Valid range: 100 - 300 MiB/s
        """
        return pulumi.get(self, "volume_initialization_rate")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The volume type. This parameter can be one of the following values:
          +  General Purpose SSD: ``gp2`` | ``gp3``
          +  Provisioned IOPS SSD: ``io1`` | ``io2``
          +  Throughput Optimized HDD: ``st1``
          +  Cold HDD: ``sc1``
          +  Magnetic: ``standard``
          
         For more information, see [Amazon EBS volume types](https://docs.aws.amazon.com/ebs/latest/userguide/ebs-volume-types.html).
         Default: ``gp2``
        """
        return pulumi.get(self, "volume_type")

