# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = ['SecurityGroupVpcAssociationArgs', 'SecurityGroupVpcAssociation']

@pulumi.input_type
class SecurityGroupVpcAssociationArgs:
    def __init__(__self__, *,
                 group_id: pulumi.Input[builtins.str],
                 vpc_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a SecurityGroupVpcAssociation resource.
        :param pulumi.Input[builtins.str] group_id: The group ID of the specified security group.
        :param pulumi.Input[builtins.str] vpc_id: The ID of the VPC in the security group vpc association.
        """
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[builtins.str]:
        """
        The group ID of the specified security group.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the VPC in the security group vpc association.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("aws-native:ec2:SecurityGroupVpcAssociation")
class SecurityGroupVpcAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource type definition for the AWS::EC2::SecurityGroupVpcAssociation resource

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] group_id: The group ID of the specified security group.
        :param pulumi.Input[builtins.str] vpc_id: The ID of the VPC in the security group vpc association.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityGroupVpcAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource type definition for the AWS::EC2::SecurityGroupVpcAssociation resource

        :param str resource_name: The name of the resource.
        :param SecurityGroupVpcAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityGroupVpcAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityGroupVpcAssociationArgs.__new__(SecurityGroupVpcAssociationArgs)

            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["state"] = None
            __props__.__dict__["state_reason"] = None
            __props__.__dict__["vpc_owner_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["groupId", "vpcId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(SecurityGroupVpcAssociation, __self__).__init__(
            'aws-native:ec2:SecurityGroupVpcAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SecurityGroupVpcAssociation':
        """
        Get an existing SecurityGroupVpcAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SecurityGroupVpcAssociationArgs.__new__(SecurityGroupVpcAssociationArgs)

        __props__.__dict__["group_id"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["state_reason"] = None
        __props__.__dict__["vpc_id"] = None
        __props__.__dict__["vpc_owner_id"] = None
        return SecurityGroupVpcAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[builtins.str]:
        """
        The group ID of the specified security group.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output['SecurityGroupVpcAssociationState']:
        """
        The state of the security group vpc association.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateReason")
    def state_reason(self) -> pulumi.Output[builtins.str]:
        """
        The reason for the state of the security group vpc association.
        """
        return pulumi.get(self, "state_reason")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the VPC in the security group vpc association.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vpcOwnerId")
    def vpc_owner_id(self) -> pulumi.Output[builtins.str]:
        """
        The owner of the VPC in the security group vpc association.
        """
        return pulumi.get(self, "vpc_owner_id")

